# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 disk: Optional[pulumi.Input[_builtins.bool]] = None,
                 identify_by_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 introspection_debugging: Optional[pulumi.Input[_builtins.bool]] = None,
                 introspection_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_factor: Optional[pulumi.Input[_builtins.int]] = None,
                 scheduling: Optional[pulumi.Input['ClusterSchedulingArgs']] = None,
                 size: Optional[pulumi.Input[_builtins.str]] = None,
                 wait_until_ready: Optional[pulumi.Input['ClusterWaitUntilReadyArgs']] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: The specific availability zones of the cluster.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.bool] disk: **Deprecated**. This attribute is maintained for backward compatibility with existing configurations. New users should use 'cc' sizes for disk access.
        :param pulumi.Input[_builtins.bool] identify_by_name: Use the cluster name as the resource identifier in your state file, rather than the internal cluster ID. This is particularly useful in scenarios like dbt-materialize blue/green deployments, where clusters are swapped but the ID changes. By identifying by name, the resource can be managed consistently even when the underlying cluster ID is updated.
        :param pulumi.Input[_builtins.bool] introspection_debugging: Whether to introspect the gathering of the introspection data.
        :param pulumi.Input[_builtins.str] introspection_interval: The interval at which to collect introspection data.
        :param pulumi.Input[_builtins.str] name: The identifier for the cluster.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.int] replication_factor: The number of replicas of each dataflow-powered object to maintain.
        :param pulumi.Input['ClusterSchedulingArgs'] scheduling: Defines the scheduling parameters for the cluster.
        :param pulumi.Input[_builtins.str] size: The size of the managed cluster.
        :param pulumi.Input['ClusterWaitUntilReadyArgs'] wait_until_ready: Defines the parameters for the WAIT UNTIL READY options
        """
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if disk is not None:
            warnings.warn("""Disk replicas are deprecated and will be removed in a future release. The `disk` attribute will be enabled by default for 'cc' clusters""", DeprecationWarning)
            pulumi.log.warn("""disk is deprecated: Disk replicas are deprecated and will be removed in a future release. The `disk` attribute will be enabled by default for 'cc' clusters""")
        if disk is not None:
            pulumi.set(__self__, "disk", disk)
        if identify_by_name is not None:
            pulumi.set(__self__, "identify_by_name", identify_by_name)
        if introspection_debugging is not None:
            pulumi.set(__self__, "introspection_debugging", introspection_debugging)
        if introspection_interval is not None:
            pulumi.set(__self__, "introspection_interval", introspection_interval)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ownership_role is not None:
            pulumi.set(__self__, "ownership_role", ownership_role)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replication_factor is not None:
            pulumi.set(__self__, "replication_factor", replication_factor)
        if scheduling is not None:
            pulumi.set(__self__, "scheduling", scheduling)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if wait_until_ready is not None:
            pulumi.set(__self__, "wait_until_ready", wait_until_ready)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The specific availability zones of the cluster.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "availability_zones", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Disk replicas are deprecated and will be removed in a future release. The `disk` attribute will be enabled by default for 'cc' clusters""")
    def disk(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        **Deprecated**. This attribute is maintained for backward compatibility with existing configurations. New users should use 'cc' sizes for disk access.
        """
        return pulumi.get(self, "disk")

    @disk.setter
    def disk(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disk", value)

    @_builtins.property
    @pulumi.getter(name="identifyByName")
    def identify_by_name(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Use the cluster name as the resource identifier in your state file, rather than the internal cluster ID. This is particularly useful in scenarios like dbt-materialize blue/green deployments, where clusters are swapped but the ID changes. By identifying by name, the resource can be managed consistently even when the underlying cluster ID is updated.
        """
        return pulumi.get(self, "identify_by_name")

    @identify_by_name.setter
    def identify_by_name(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "identify_by_name", value)

    @_builtins.property
    @pulumi.getter(name="introspectionDebugging")
    def introspection_debugging(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to introspect the gathering of the introspection data.
        """
        return pulumi.get(self, "introspection_debugging")

    @introspection_debugging.setter
    def introspection_debugging(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "introspection_debugging", value)

    @_builtins.property
    @pulumi.getter(name="introspectionInterval")
    def introspection_interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The interval at which to collect introspection data.
        """
        return pulumi.get(self, "introspection_interval")

    @introspection_interval.setter
    def introspection_interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "introspection_interval", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @ownership_role.setter
    def ownership_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ownership_role", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="replicationFactor")
    def replication_factor(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of replicas of each dataflow-powered object to maintain.
        """
        return pulumi.get(self, "replication_factor")

    @replication_factor.setter
    def replication_factor(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "replication_factor", value)

    @_builtins.property
    @pulumi.getter
    def scheduling(self) -> Optional[pulumi.Input['ClusterSchedulingArgs']]:
        """
        Defines the scheduling parameters for the cluster.
        """
        return pulumi.get(self, "scheduling")

    @scheduling.setter
    def scheduling(self, value: Optional[pulumi.Input['ClusterSchedulingArgs']]):
        pulumi.set(self, "scheduling", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The size of the managed cluster.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> Optional[pulumi.Input['ClusterWaitUntilReadyArgs']]:
        """
        Defines the parameters for the WAIT UNTIL READY options
        """
        return pulumi.get(self, "wait_until_ready")

    @wait_until_ready.setter
    def wait_until_ready(self, value: Optional[pulumi.Input['ClusterWaitUntilReadyArgs']]):
        pulumi.set(self, "wait_until_ready", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 disk: Optional[pulumi.Input[_builtins.bool]] = None,
                 identify_by_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 introspection_debugging: Optional[pulumi.Input[_builtins.bool]] = None,
                 introspection_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_factor: Optional[pulumi.Input[_builtins.int]] = None,
                 scheduling: Optional[pulumi.Input['ClusterSchedulingArgs']] = None,
                 size: Optional[pulumi.Input[_builtins.str]] = None,
                 wait_until_ready: Optional[pulumi.Input['ClusterWaitUntilReadyArgs']] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: The specific availability zones of the cluster.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.bool] disk: **Deprecated**. This attribute is maintained for backward compatibility with existing configurations. New users should use 'cc' sizes for disk access.
        :param pulumi.Input[_builtins.bool] identify_by_name: Use the cluster name as the resource identifier in your state file, rather than the internal cluster ID. This is particularly useful in scenarios like dbt-materialize blue/green deployments, where clusters are swapped but the ID changes. By identifying by name, the resource can be managed consistently even when the underlying cluster ID is updated.
        :param pulumi.Input[_builtins.bool] introspection_debugging: Whether to introspect the gathering of the introspection data.
        :param pulumi.Input[_builtins.str] introspection_interval: The interval at which to collect introspection data.
        :param pulumi.Input[_builtins.str] name: The identifier for the cluster.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.int] replication_factor: The number of replicas of each dataflow-powered object to maintain.
        :param pulumi.Input['ClusterSchedulingArgs'] scheduling: Defines the scheduling parameters for the cluster.
        :param pulumi.Input[_builtins.str] size: The size of the managed cluster.
        :param pulumi.Input['ClusterWaitUntilReadyArgs'] wait_until_ready: Defines the parameters for the WAIT UNTIL READY options
        """
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if disk is not None:
            warnings.warn("""Disk replicas are deprecated and will be removed in a future release. The `disk` attribute will be enabled by default for 'cc' clusters""", DeprecationWarning)
            pulumi.log.warn("""disk is deprecated: Disk replicas are deprecated and will be removed in a future release. The `disk` attribute will be enabled by default for 'cc' clusters""")
        if disk is not None:
            pulumi.set(__self__, "disk", disk)
        if identify_by_name is not None:
            pulumi.set(__self__, "identify_by_name", identify_by_name)
        if introspection_debugging is not None:
            pulumi.set(__self__, "introspection_debugging", introspection_debugging)
        if introspection_interval is not None:
            pulumi.set(__self__, "introspection_interval", introspection_interval)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ownership_role is not None:
            pulumi.set(__self__, "ownership_role", ownership_role)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replication_factor is not None:
            pulumi.set(__self__, "replication_factor", replication_factor)
        if scheduling is not None:
            pulumi.set(__self__, "scheduling", scheduling)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if wait_until_ready is not None:
            pulumi.set(__self__, "wait_until_ready", wait_until_ready)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The specific availability zones of the cluster.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "availability_zones", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Disk replicas are deprecated and will be removed in a future release. The `disk` attribute will be enabled by default for 'cc' clusters""")
    def disk(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        **Deprecated**. This attribute is maintained for backward compatibility with existing configurations. New users should use 'cc' sizes for disk access.
        """
        return pulumi.get(self, "disk")

    @disk.setter
    def disk(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disk", value)

    @_builtins.property
    @pulumi.getter(name="identifyByName")
    def identify_by_name(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Use the cluster name as the resource identifier in your state file, rather than the internal cluster ID. This is particularly useful in scenarios like dbt-materialize blue/green deployments, where clusters are swapped but the ID changes. By identifying by name, the resource can be managed consistently even when the underlying cluster ID is updated.
        """
        return pulumi.get(self, "identify_by_name")

    @identify_by_name.setter
    def identify_by_name(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "identify_by_name", value)

    @_builtins.property
    @pulumi.getter(name="introspectionDebugging")
    def introspection_debugging(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to introspect the gathering of the introspection data.
        """
        return pulumi.get(self, "introspection_debugging")

    @introspection_debugging.setter
    def introspection_debugging(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "introspection_debugging", value)

    @_builtins.property
    @pulumi.getter(name="introspectionInterval")
    def introspection_interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The interval at which to collect introspection data.
        """
        return pulumi.get(self, "introspection_interval")

    @introspection_interval.setter
    def introspection_interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "introspection_interval", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @ownership_role.setter
    def ownership_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ownership_role", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="replicationFactor")
    def replication_factor(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of replicas of each dataflow-powered object to maintain.
        """
        return pulumi.get(self, "replication_factor")

    @replication_factor.setter
    def replication_factor(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "replication_factor", value)

    @_builtins.property
    @pulumi.getter
    def scheduling(self) -> Optional[pulumi.Input['ClusterSchedulingArgs']]:
        """
        Defines the scheduling parameters for the cluster.
        """
        return pulumi.get(self, "scheduling")

    @scheduling.setter
    def scheduling(self, value: Optional[pulumi.Input['ClusterSchedulingArgs']]):
        pulumi.set(self, "scheduling", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The size of the managed cluster.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> Optional[pulumi.Input['ClusterWaitUntilReadyArgs']]:
        """
        Defines the parameters for the WAIT UNTIL READY options
        """
        return pulumi.get(self, "wait_until_ready")

    @wait_until_ready.setter
    def wait_until_ready(self, value: Optional[pulumi.Input['ClusterWaitUntilReadyArgs']]):
        pulumi.set(self, "wait_until_ready", value)


@pulumi.type_token("materialize:index/cluster:Cluster")
class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 disk: Optional[pulumi.Input[_builtins.bool]] = None,
                 identify_by_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 introspection_debugging: Optional[pulumi.Input[_builtins.bool]] = None,
                 introspection_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_factor: Optional[pulumi.Input[_builtins.int]] = None,
                 scheduling: Optional[pulumi.Input[Union['ClusterSchedulingArgs', 'ClusterSchedulingArgsDict']]] = None,
                 size: Optional[pulumi.Input[_builtins.str]] = None,
                 wait_until_ready: Optional[pulumi.Input[Union['ClusterWaitUntilReadyArgs', 'ClusterWaitUntilReadyArgsDict']]] = None,
                 __props__=None):
        """
        Clusters describe logical compute resources that can be used by sources, sinks, indexes, and materialized views. Managed clusters are created by setting the `size` attribute

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        example_cluster = materialize.Cluster("exampleCluster")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Clusters can be imported using the cluster id or name

        ```sh
        $ pulumi import materialize:index/cluster:Cluster example_cluster <region>:id:<cluster_id>
        ```

        To import using the cluster name, you need to set the `identify_by_name` attribute to true

        ```sh
        $ pulumi import materialize:index/cluster:Cluster example_cluster <region>:name:<cluster_name>
        ```

        Cluster id and information be found in the `mz_catalog.mz_clusters` table

        The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: The specific availability zones of the cluster.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.bool] disk: **Deprecated**. This attribute is maintained for backward compatibility with existing configurations. New users should use 'cc' sizes for disk access.
        :param pulumi.Input[_builtins.bool] identify_by_name: Use the cluster name as the resource identifier in your state file, rather than the internal cluster ID. This is particularly useful in scenarios like dbt-materialize blue/green deployments, where clusters are swapped but the ID changes. By identifying by name, the resource can be managed consistently even when the underlying cluster ID is updated.
        :param pulumi.Input[_builtins.bool] introspection_debugging: Whether to introspect the gathering of the introspection data.
        :param pulumi.Input[_builtins.str] introspection_interval: The interval at which to collect introspection data.
        :param pulumi.Input[_builtins.str] name: The identifier for the cluster.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.int] replication_factor: The number of replicas of each dataflow-powered object to maintain.
        :param pulumi.Input[Union['ClusterSchedulingArgs', 'ClusterSchedulingArgsDict']] scheduling: Defines the scheduling parameters for the cluster.
        :param pulumi.Input[_builtins.str] size: The size of the managed cluster.
        :param pulumi.Input[Union['ClusterWaitUntilReadyArgs', 'ClusterWaitUntilReadyArgsDict']] wait_until_ready: Defines the parameters for the WAIT UNTIL READY options
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ClusterArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Clusters describe logical compute resources that can be used by sources, sinks, indexes, and materialized views. Managed clusters are created by setting the `size` attribute

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        example_cluster = materialize.Cluster("exampleCluster")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Clusters can be imported using the cluster id or name

        ```sh
        $ pulumi import materialize:index/cluster:Cluster example_cluster <region>:id:<cluster_id>
        ```

        To import using the cluster name, you need to set the `identify_by_name` attribute to true

        ```sh
        $ pulumi import materialize:index/cluster:Cluster example_cluster <region>:name:<cluster_name>
        ```

        Cluster id and information be found in the `mz_catalog.mz_clusters` table

        The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 disk: Optional[pulumi.Input[_builtins.bool]] = None,
                 identify_by_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 introspection_debugging: Optional[pulumi.Input[_builtins.bool]] = None,
                 introspection_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_factor: Optional[pulumi.Input[_builtins.int]] = None,
                 scheduling: Optional[pulumi.Input[Union['ClusterSchedulingArgs', 'ClusterSchedulingArgsDict']]] = None,
                 size: Optional[pulumi.Input[_builtins.str]] = None,
                 wait_until_ready: Optional[pulumi.Input[Union['ClusterWaitUntilReadyArgs', 'ClusterWaitUntilReadyArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["availability_zones"] = availability_zones
            __props__.__dict__["comment"] = comment
            __props__.__dict__["disk"] = disk
            __props__.__dict__["identify_by_name"] = identify_by_name
            __props__.__dict__["introspection_debugging"] = introspection_debugging
            __props__.__dict__["introspection_interval"] = introspection_interval
            __props__.__dict__["name"] = name
            __props__.__dict__["ownership_role"] = ownership_role
            __props__.__dict__["region"] = region
            __props__.__dict__["replication_factor"] = replication_factor
            __props__.__dict__["scheduling"] = scheduling
            __props__.__dict__["size"] = size
            __props__.__dict__["wait_until_ready"] = wait_until_ready
        super(Cluster, __self__).__init__(
            'materialize:index/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            disk: Optional[pulumi.Input[_builtins.bool]] = None,
            identify_by_name: Optional[pulumi.Input[_builtins.bool]] = None,
            introspection_debugging: Optional[pulumi.Input[_builtins.bool]] = None,
            introspection_interval: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            replication_factor: Optional[pulumi.Input[_builtins.int]] = None,
            scheduling: Optional[pulumi.Input[Union['ClusterSchedulingArgs', 'ClusterSchedulingArgsDict']]] = None,
            size: Optional[pulumi.Input[_builtins.str]] = None,
            wait_until_ready: Optional[pulumi.Input[Union['ClusterWaitUntilReadyArgs', 'ClusterWaitUntilReadyArgsDict']]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: The specific availability zones of the cluster.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.bool] disk: **Deprecated**. This attribute is maintained for backward compatibility with existing configurations. New users should use 'cc' sizes for disk access.
        :param pulumi.Input[_builtins.bool] identify_by_name: Use the cluster name as the resource identifier in your state file, rather than the internal cluster ID. This is particularly useful in scenarios like dbt-materialize blue/green deployments, where clusters are swapped but the ID changes. By identifying by name, the resource can be managed consistently even when the underlying cluster ID is updated.
        :param pulumi.Input[_builtins.bool] introspection_debugging: Whether to introspect the gathering of the introspection data.
        :param pulumi.Input[_builtins.str] introspection_interval: The interval at which to collect introspection data.
        :param pulumi.Input[_builtins.str] name: The identifier for the cluster.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.int] replication_factor: The number of replicas of each dataflow-powered object to maintain.
        :param pulumi.Input[Union['ClusterSchedulingArgs', 'ClusterSchedulingArgsDict']] scheduling: Defines the scheduling parameters for the cluster.
        :param pulumi.Input[_builtins.str] size: The size of the managed cluster.
        :param pulumi.Input[Union['ClusterWaitUntilReadyArgs', 'ClusterWaitUntilReadyArgsDict']] wait_until_ready: Defines the parameters for the WAIT UNTIL READY options
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["availability_zones"] = availability_zones
        __props__.__dict__["comment"] = comment
        __props__.__dict__["disk"] = disk
        __props__.__dict__["identify_by_name"] = identify_by_name
        __props__.__dict__["introspection_debugging"] = introspection_debugging
        __props__.__dict__["introspection_interval"] = introspection_interval
        __props__.__dict__["name"] = name
        __props__.__dict__["ownership_role"] = ownership_role
        __props__.__dict__["region"] = region
        __props__.__dict__["replication_factor"] = replication_factor
        __props__.__dict__["scheduling"] = scheduling
        __props__.__dict__["size"] = size
        __props__.__dict__["wait_until_ready"] = wait_until_ready
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The specific availability zones of the cluster.
        """
        return pulumi.get(self, "availability_zones")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Disk replicas are deprecated and will be removed in a future release. The `disk` attribute will be enabled by default for 'cc' clusters""")
    def disk(self) -> pulumi.Output[_builtins.bool]:
        """
        **Deprecated**. This attribute is maintained for backward compatibility with existing configurations. New users should use 'cc' sizes for disk access.
        """
        return pulumi.get(self, "disk")

    @_builtins.property
    @pulumi.getter(name="identifyByName")
    def identify_by_name(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Use the cluster name as the resource identifier in your state file, rather than the internal cluster ID. This is particularly useful in scenarios like dbt-materialize blue/green deployments, where clusters are swapped but the ID changes. By identifying by name, the resource can be managed consistently even when the underlying cluster ID is updated.
        """
        return pulumi.get(self, "identify_by_name")

    @_builtins.property
    @pulumi.getter(name="introspectionDebugging")
    def introspection_debugging(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to introspect the gathering of the introspection data.
        """
        return pulumi.get(self, "introspection_debugging")

    @_builtins.property
    @pulumi.getter(name="introspectionInterval")
    def introspection_interval(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The interval at which to collect introspection data.
        """
        return pulumi.get(self, "introspection_interval")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The identifier for the cluster.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> pulumi.Output[_builtins.str]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="replicationFactor")
    def replication_factor(self) -> pulumi.Output[_builtins.int]:
        """
        The number of replicas of each dataflow-powered object to maintain.
        """
        return pulumi.get(self, "replication_factor")

    @_builtins.property
    @pulumi.getter
    def scheduling(self) -> pulumi.Output[Optional['outputs.ClusterScheduling']]:
        """
        Defines the scheduling parameters for the cluster.
        """
        return pulumi.get(self, "scheduling")

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The size of the managed cluster.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> pulumi.Output[Optional['outputs.ClusterWaitUntilReady']]:
        """
        Defines the parameters for the WAIT UNTIL READY options
        """
        return pulumi.get(self, "wait_until_ready")

