# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConnectionAwsArgs', 'ConnectionAws']

@pulumi.input_type
class ConnectionAwsArgs:
    def __init__(__self__, *,
                 access_key_id: Optional[pulumi.Input['ConnectionAwsAccessKeyIdArgs']] = None,
                 assume_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 assume_role_session_name: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_region: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_access_key: Optional[pulumi.Input['ConnectionAwsSecretAccessKeyArgs']] = None,
                 session_token: Optional[pulumi.Input['ConnectionAwsSessionTokenArgs']] = None,
                 validate: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ConnectionAws resource.
        :param pulumi.Input['ConnectionAwsAccessKeyIdArgs'] access_key_id: The access key ID to connect with.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[_builtins.str] assume_role_arn: The Amazon Resource Name (ARN) of the IAM role to assume.
        :param pulumi.Input[_builtins.str] assume_role_session_name: The session name to use when assuming the role.
        :param pulumi.Input[_builtins.str] aws_region: The AWS region to connect to.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[_builtins.str] endpoint: Override the default AWS endpoint URL.
        :param pulumi.Input[_builtins.str] name: The identifier for the connection.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the connection schema in Materialize. Defaults to `public`.
        :param pulumi.Input['ConnectionAwsSecretAccessKeyArgs'] secret_access_key: The secret access key corresponding to the specified access key ID.
        :param pulumi.Input['ConnectionAwsSessionTokenArgs'] session_token: The session token corresponding to the specified access key ID.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[_builtins.bool] validate: If the connection should wait for validation.
        """
        if access_key_id is not None:
            pulumi.set(__self__, "access_key_id", access_key_id)
        if assume_role_arn is not None:
            pulumi.set(__self__, "assume_role_arn", assume_role_arn)
        if assume_role_session_name is not None:
            pulumi.set(__self__, "assume_role_session_name", assume_role_session_name)
        if aws_region is not None:
            pulumi.set(__self__, "aws_region", aws_region)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ownership_role is not None:
            pulumi.set(__self__, "ownership_role", ownership_role)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if secret_access_key is not None:
            pulumi.set(__self__, "secret_access_key", secret_access_key)
        if session_token is not None:
            pulumi.set(__self__, "session_token", session_token)
        if validate is not None:
            pulumi.set(__self__, "validate", validate)

    @_builtins.property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> Optional[pulumi.Input['ConnectionAwsAccessKeyIdArgs']]:
        """
        The access key ID to connect with.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "access_key_id")

    @access_key_id.setter
    def access_key_id(self, value: Optional[pulumi.Input['ConnectionAwsAccessKeyIdArgs']]):
        pulumi.set(self, "access_key_id", value)

    @_builtins.property
    @pulumi.getter(name="assumeRoleArn")
    def assume_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the IAM role to assume.
        """
        return pulumi.get(self, "assume_role_arn")

    @assume_role_arn.setter
    def assume_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "assume_role_arn", value)

    @_builtins.property
    @pulumi.getter(name="assumeRoleSessionName")
    def assume_role_session_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The session name to use when assuming the role.
        """
        return pulumi.get(self, "assume_role_session_name")

    @assume_role_session_name.setter
    def assume_role_session_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "assume_role_session_name", value)

    @_builtins.property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AWS region to connect to.
        """
        return pulumi.get(self, "aws_region")

    @aws_region.setter
    def aws_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_region", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Override the default AWS endpoint URL.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the connection.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @ownership_role.setter
    def ownership_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ownership_role", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the connection schema in Materialize. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema_name", value)

    @_builtins.property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> Optional[pulumi.Input['ConnectionAwsSecretAccessKeyArgs']]:
        """
        The secret access key corresponding to the specified access key ID.
        """
        return pulumi.get(self, "secret_access_key")

    @secret_access_key.setter
    def secret_access_key(self, value: Optional[pulumi.Input['ConnectionAwsSecretAccessKeyArgs']]):
        pulumi.set(self, "secret_access_key", value)

    @_builtins.property
    @pulumi.getter(name="sessionToken")
    def session_token(self) -> Optional[pulumi.Input['ConnectionAwsSessionTokenArgs']]:
        """
        The session token corresponding to the specified access key ID.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "session_token")

    @session_token.setter
    def session_token(self, value: Optional[pulumi.Input['ConnectionAwsSessionTokenArgs']]):
        pulumi.set(self, "session_token", value)

    @_builtins.property
    @pulumi.getter
    def validate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If the connection should wait for validation.
        """
        return pulumi.get(self, "validate")

    @validate.setter
    def validate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "validate", value)


@pulumi.input_type
class _ConnectionAwsState:
    def __init__(__self__, *,
                 access_key_id: Optional[pulumi.Input['ConnectionAwsAccessKeyIdArgs']] = None,
                 assume_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 assume_role_session_name: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_region: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 qualified_sql_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_access_key: Optional[pulumi.Input['ConnectionAwsSecretAccessKeyArgs']] = None,
                 session_token: Optional[pulumi.Input['ConnectionAwsSessionTokenArgs']] = None,
                 validate: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ConnectionAws resources.
        :param pulumi.Input['ConnectionAwsAccessKeyIdArgs'] access_key_id: The access key ID to connect with.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[_builtins.str] assume_role_arn: The Amazon Resource Name (ARN) of the IAM role to assume.
        :param pulumi.Input[_builtins.str] assume_role_session_name: The session name to use when assuming the role.
        :param pulumi.Input[_builtins.str] aws_region: The AWS region to connect to.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[_builtins.str] endpoint: Override the default AWS endpoint URL.
        :param pulumi.Input[_builtins.str] external_id: The external ID used for trust relationship when assume*role*arn is specified. This is a read-only attribute that is automatically generated.
        :param pulumi.Input[_builtins.str] name: The identifier for the connection.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input[_builtins.str] qualified_sql_name: The fully qualified name of the connection.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the connection schema in Materialize. Defaults to `public`.
        :param pulumi.Input['ConnectionAwsSecretAccessKeyArgs'] secret_access_key: The secret access key corresponding to the specified access key ID.
        :param pulumi.Input['ConnectionAwsSessionTokenArgs'] session_token: The session token corresponding to the specified access key ID.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[_builtins.bool] validate: If the connection should wait for validation.
        """
        if access_key_id is not None:
            pulumi.set(__self__, "access_key_id", access_key_id)
        if assume_role_arn is not None:
            pulumi.set(__self__, "assume_role_arn", assume_role_arn)
        if assume_role_session_name is not None:
            pulumi.set(__self__, "assume_role_session_name", assume_role_session_name)
        if aws_region is not None:
            pulumi.set(__self__, "aws_region", aws_region)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ownership_role is not None:
            pulumi.set(__self__, "ownership_role", ownership_role)
        if qualified_sql_name is not None:
            pulumi.set(__self__, "qualified_sql_name", qualified_sql_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if secret_access_key is not None:
            pulumi.set(__self__, "secret_access_key", secret_access_key)
        if session_token is not None:
            pulumi.set(__self__, "session_token", session_token)
        if validate is not None:
            pulumi.set(__self__, "validate", validate)

    @_builtins.property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> Optional[pulumi.Input['ConnectionAwsAccessKeyIdArgs']]:
        """
        The access key ID to connect with.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "access_key_id")

    @access_key_id.setter
    def access_key_id(self, value: Optional[pulumi.Input['ConnectionAwsAccessKeyIdArgs']]):
        pulumi.set(self, "access_key_id", value)

    @_builtins.property
    @pulumi.getter(name="assumeRoleArn")
    def assume_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the IAM role to assume.
        """
        return pulumi.get(self, "assume_role_arn")

    @assume_role_arn.setter
    def assume_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "assume_role_arn", value)

    @_builtins.property
    @pulumi.getter(name="assumeRoleSessionName")
    def assume_role_session_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The session name to use when assuming the role.
        """
        return pulumi.get(self, "assume_role_session_name")

    @assume_role_session_name.setter
    def assume_role_session_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "assume_role_session_name", value)

    @_builtins.property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AWS region to connect to.
        """
        return pulumi.get(self, "aws_region")

    @aws_region.setter
    def aws_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_region", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Override the default AWS endpoint URL.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The external ID used for trust relationship when assume*role*arn is specified. This is a read-only attribute that is automatically generated.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the connection.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @ownership_role.setter
    def ownership_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ownership_role", value)

    @_builtins.property
    @pulumi.getter(name="qualifiedSqlName")
    def qualified_sql_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified name of the connection.
        """
        return pulumi.get(self, "qualified_sql_name")

    @qualified_sql_name.setter
    def qualified_sql_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "qualified_sql_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the connection schema in Materialize. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema_name", value)

    @_builtins.property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> Optional[pulumi.Input['ConnectionAwsSecretAccessKeyArgs']]:
        """
        The secret access key corresponding to the specified access key ID.
        """
        return pulumi.get(self, "secret_access_key")

    @secret_access_key.setter
    def secret_access_key(self, value: Optional[pulumi.Input['ConnectionAwsSecretAccessKeyArgs']]):
        pulumi.set(self, "secret_access_key", value)

    @_builtins.property
    @pulumi.getter(name="sessionToken")
    def session_token(self) -> Optional[pulumi.Input['ConnectionAwsSessionTokenArgs']]:
        """
        The session token corresponding to the specified access key ID.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "session_token")

    @session_token.setter
    def session_token(self, value: Optional[pulumi.Input['ConnectionAwsSessionTokenArgs']]):
        pulumi.set(self, "session_token", value)

    @_builtins.property
    @pulumi.getter
    def validate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If the connection should wait for validation.
        """
        return pulumi.get(self, "validate")

    @validate.setter
    def validate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "validate", value)


@pulumi.type_token("materialize:index/connectionAws:ConnectionAws")
class ConnectionAws(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key_id: Optional[pulumi.Input[Union['ConnectionAwsAccessKeyIdArgs', 'ConnectionAwsAccessKeyIdArgsDict']]] = None,
                 assume_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 assume_role_session_name: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_region: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_access_key: Optional[pulumi.Input[Union['ConnectionAwsSecretAccessKeyArgs', 'ConnectionAwsSecretAccessKeyArgsDict']]] = None,
                 session_token: Optional[pulumi.Input[Union['ConnectionAwsSessionTokenArgs', 'ConnectionAwsSessionTokenArgsDict']]] = None,
                 validate: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        An Amazon Web Services (AWS) connection provides Materialize with access to an Identity and Access Management (IAM) user or role in your AWS account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        # Create a AWS Connection
        example_connection = materialize.ConnectionAws("exampleConnection",
            access_key_id="foo",
            schema_name="public",
            secret_access_key="bar")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Connections can be imported using the connection id:

        ```sh
        $ pulumi import materialize:index/connectionAws:ConnectionAws example <region>:<connection_id>
        ```

        Connection id and information be found in the `mz_catalog.mz_connections` table

        The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ConnectionAwsAccessKeyIdArgs', 'ConnectionAwsAccessKeyIdArgsDict']] access_key_id: The access key ID to connect with.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[_builtins.str] assume_role_arn: The Amazon Resource Name (ARN) of the IAM role to assume.
        :param pulumi.Input[_builtins.str] assume_role_session_name: The session name to use when assuming the role.
        :param pulumi.Input[_builtins.str] aws_region: The AWS region to connect to.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[_builtins.str] endpoint: Override the default AWS endpoint URL.
        :param pulumi.Input[_builtins.str] name: The identifier for the connection.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the connection schema in Materialize. Defaults to `public`.
        :param pulumi.Input[Union['ConnectionAwsSecretAccessKeyArgs', 'ConnectionAwsSecretAccessKeyArgsDict']] secret_access_key: The secret access key corresponding to the specified access key ID.
        :param pulumi.Input[Union['ConnectionAwsSessionTokenArgs', 'ConnectionAwsSessionTokenArgsDict']] session_token: The session token corresponding to the specified access key ID.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[_builtins.bool] validate: If the connection should wait for validation.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ConnectionAwsArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An Amazon Web Services (AWS) connection provides Materialize with access to an Identity and Access Management (IAM) user or role in your AWS account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        # Create a AWS Connection
        example_connection = materialize.ConnectionAws("exampleConnection",
            access_key_id="foo",
            schema_name="public",
            secret_access_key="bar")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Connections can be imported using the connection id:

        ```sh
        $ pulumi import materialize:index/connectionAws:ConnectionAws example <region>:<connection_id>
        ```

        Connection id and information be found in the `mz_catalog.mz_connections` table

        The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param ConnectionAwsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectionAwsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key_id: Optional[pulumi.Input[Union['ConnectionAwsAccessKeyIdArgs', 'ConnectionAwsAccessKeyIdArgsDict']]] = None,
                 assume_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 assume_role_session_name: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_region: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_access_key: Optional[pulumi.Input[Union['ConnectionAwsSecretAccessKeyArgs', 'ConnectionAwsSecretAccessKeyArgsDict']]] = None,
                 session_token: Optional[pulumi.Input[Union['ConnectionAwsSessionTokenArgs', 'ConnectionAwsSessionTokenArgsDict']]] = None,
                 validate: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectionAwsArgs.__new__(ConnectionAwsArgs)

            __props__.__dict__["access_key_id"] = access_key_id
            __props__.__dict__["assume_role_arn"] = assume_role_arn
            __props__.__dict__["assume_role_session_name"] = assume_role_session_name
            __props__.__dict__["aws_region"] = aws_region
            __props__.__dict__["comment"] = comment
            __props__.__dict__["database_name"] = database_name
            __props__.__dict__["endpoint"] = endpoint
            __props__.__dict__["name"] = name
            __props__.__dict__["ownership_role"] = ownership_role
            __props__.__dict__["region"] = region
            __props__.__dict__["schema_name"] = schema_name
            __props__.__dict__["secret_access_key"] = secret_access_key
            __props__.__dict__["session_token"] = session_token
            __props__.__dict__["validate"] = validate
            __props__.__dict__["external_id"] = None
            __props__.__dict__["qualified_sql_name"] = None
        super(ConnectionAws, __self__).__init__(
            'materialize:index/connectionAws:ConnectionAws',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_key_id: Optional[pulumi.Input[Union['ConnectionAwsAccessKeyIdArgs', 'ConnectionAwsAccessKeyIdArgsDict']]] = None,
            assume_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            assume_role_session_name: Optional[pulumi.Input[_builtins.str]] = None,
            aws_region: Optional[pulumi.Input[_builtins.str]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            database_name: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            external_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
            qualified_sql_name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            schema_name: Optional[pulumi.Input[_builtins.str]] = None,
            secret_access_key: Optional[pulumi.Input[Union['ConnectionAwsSecretAccessKeyArgs', 'ConnectionAwsSecretAccessKeyArgsDict']]] = None,
            session_token: Optional[pulumi.Input[Union['ConnectionAwsSessionTokenArgs', 'ConnectionAwsSessionTokenArgsDict']]] = None,
            validate: Optional[pulumi.Input[_builtins.bool]] = None) -> 'ConnectionAws':
        """
        Get an existing ConnectionAws resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ConnectionAwsAccessKeyIdArgs', 'ConnectionAwsAccessKeyIdArgsDict']] access_key_id: The access key ID to connect with.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[_builtins.str] assume_role_arn: The Amazon Resource Name (ARN) of the IAM role to assume.
        :param pulumi.Input[_builtins.str] assume_role_session_name: The session name to use when assuming the role.
        :param pulumi.Input[_builtins.str] aws_region: The AWS region to connect to.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[_builtins.str] endpoint: Override the default AWS endpoint URL.
        :param pulumi.Input[_builtins.str] external_id: The external ID used for trust relationship when assume*role*arn is specified. This is a read-only attribute that is automatically generated.
        :param pulumi.Input[_builtins.str] name: The identifier for the connection.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input[_builtins.str] qualified_sql_name: The fully qualified name of the connection.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the connection schema in Materialize. Defaults to `public`.
        :param pulumi.Input[Union['ConnectionAwsSecretAccessKeyArgs', 'ConnectionAwsSecretAccessKeyArgsDict']] secret_access_key: The secret access key corresponding to the specified access key ID.
        :param pulumi.Input[Union['ConnectionAwsSessionTokenArgs', 'ConnectionAwsSessionTokenArgsDict']] session_token: The session token corresponding to the specified access key ID.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[_builtins.bool] validate: If the connection should wait for validation.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectionAwsState.__new__(_ConnectionAwsState)

        __props__.__dict__["access_key_id"] = access_key_id
        __props__.__dict__["assume_role_arn"] = assume_role_arn
        __props__.__dict__["assume_role_session_name"] = assume_role_session_name
        __props__.__dict__["aws_region"] = aws_region
        __props__.__dict__["comment"] = comment
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["external_id"] = external_id
        __props__.__dict__["name"] = name
        __props__.__dict__["ownership_role"] = ownership_role
        __props__.__dict__["qualified_sql_name"] = qualified_sql_name
        __props__.__dict__["region"] = region
        __props__.__dict__["schema_name"] = schema_name
        __props__.__dict__["secret_access_key"] = secret_access_key
        __props__.__dict__["session_token"] = session_token
        __props__.__dict__["validate"] = validate
        return ConnectionAws(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> pulumi.Output[Optional['outputs.ConnectionAwsAccessKeyId']]:
        """
        The access key ID to connect with.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "access_key_id")

    @_builtins.property
    @pulumi.getter(name="assumeRoleArn")
    def assume_role_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the IAM role to assume.
        """
        return pulumi.get(self, "assume_role_arn")

    @_builtins.property
    @pulumi.getter(name="assumeRoleSessionName")
    def assume_role_session_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The session name to use when assuming the role.
        """
        return pulumi.get(self, "assume_role_session_name")

    @_builtins.property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The AWS region to connect to.
        """
        return pulumi.get(self, "aws_region")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Override the default AWS endpoint URL.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Output[_builtins.str]:
        """
        The external ID used for trust relationship when assume*role*arn is specified. This is a read-only attribute that is automatically generated.
        """
        return pulumi.get(self, "external_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The identifier for the connection.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> pulumi.Output[_builtins.str]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @_builtins.property
    @pulumi.getter(name="qualifiedSqlName")
    def qualified_sql_name(self) -> pulumi.Output[_builtins.str]:
        """
        The fully qualified name of the connection.
        """
        return pulumi.get(self, "qualified_sql_name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The identifier for the connection schema in Materialize. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @_builtins.property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> pulumi.Output[Optional['outputs.ConnectionAwsSecretAccessKey']]:
        """
        The secret access key corresponding to the specified access key ID.
        """
        return pulumi.get(self, "secret_access_key")

    @_builtins.property
    @pulumi.getter(name="sessionToken")
    def session_token(self) -> pulumi.Output[Optional['outputs.ConnectionAwsSessionToken']]:
        """
        The session token corresponding to the specified access key ID.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "session_token")

    @_builtins.property
    @pulumi.getter
    def validate(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If the connection should wait for validation.
        """
        return pulumi.get(self, "validate")

