# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConnectionConfluentSchemaRegistryArgs', 'ConnectionConfluentSchemaRegistry']

@pulumi.input_type
class ConnectionConfluentSchemaRegistryArgs:
    def __init__(__self__, *,
                 url: pulumi.Input[_builtins.str],
                 aws_privatelink: Optional[pulumi.Input['ConnectionConfluentSchemaRegistryAwsPrivatelinkArgs']] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input['ConnectionConfluentSchemaRegistryPasswordArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_tunnel: Optional[pulumi.Input['ConnectionConfluentSchemaRegistrySshTunnelArgs']] = None,
                 ssl_certificate: Optional[pulumi.Input['ConnectionConfluentSchemaRegistrySslCertificateArgs']] = None,
                 ssl_certificate_authority: Optional[pulumi.Input['ConnectionConfluentSchemaRegistrySslCertificateAuthorityArgs']] = None,
                 ssl_key: Optional[pulumi.Input['ConnectionConfluentSchemaRegistrySslKeyArgs']] = None,
                 username: Optional[pulumi.Input['ConnectionConfluentSchemaRegistryUsernameArgs']] = None,
                 validate: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ConnectionConfluentSchemaRegistry resource.
        :param pulumi.Input[_builtins.str] url: The URL of the Confluent Schema Registry.
        :param pulumi.Input['ConnectionConfluentSchemaRegistryAwsPrivatelinkArgs'] aws_privatelink: The AWS PrivateLink configuration for the Confluent Schema Registry.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[_builtins.str] name: The identifier for the connection.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input['ConnectionConfluentSchemaRegistryPasswordArgs'] password: The password for the Confluent Schema Registry.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the connection schema in Materialize. Defaults to `public`.
        :param pulumi.Input['ConnectionConfluentSchemaRegistrySshTunnelArgs'] ssh_tunnel: The SSH tunnel configuration for the Confluent Schema Registry.
        :param pulumi.Input['ConnectionConfluentSchemaRegistrySslCertificateArgs'] ssl_certificate: The client certificate for the Confluent Schema Registry.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input['ConnectionConfluentSchemaRegistrySslCertificateAuthorityArgs'] ssl_certificate_authority: The CA certificate for the Confluent Schema Registry.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input['ConnectionConfluentSchemaRegistrySslKeyArgs'] ssl_key: The client key for the Confluent Schema Registry.
        :param pulumi.Input['ConnectionConfluentSchemaRegistryUsernameArgs'] username: The username for the Confluent Schema Registry.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[_builtins.bool] validate: If the connection should wait for validation.
        """
        pulumi.set(__self__, "url", url)
        if aws_privatelink is not None:
            pulumi.set(__self__, "aws_privatelink", aws_privatelink)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ownership_role is not None:
            pulumi.set(__self__, "ownership_role", ownership_role)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if ssh_tunnel is not None:
            pulumi.set(__self__, "ssh_tunnel", ssh_tunnel)
        if ssl_certificate is not None:
            pulumi.set(__self__, "ssl_certificate", ssl_certificate)
        if ssl_certificate_authority is not None:
            pulumi.set(__self__, "ssl_certificate_authority", ssl_certificate_authority)
        if ssl_key is not None:
            pulumi.set(__self__, "ssl_key", ssl_key)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if validate is not None:
            pulumi.set(__self__, "validate", validate)

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Input[_builtins.str]:
        """
        The URL of the Confluent Schema Registry.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter(name="awsPrivatelink")
    def aws_privatelink(self) -> Optional[pulumi.Input['ConnectionConfluentSchemaRegistryAwsPrivatelinkArgs']]:
        """
        The AWS PrivateLink configuration for the Confluent Schema Registry.
        """
        return pulumi.get(self, "aws_privatelink")

    @aws_privatelink.setter
    def aws_privatelink(self, value: Optional[pulumi.Input['ConnectionConfluentSchemaRegistryAwsPrivatelinkArgs']]):
        pulumi.set(self, "aws_privatelink", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the connection.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @ownership_role.setter
    def ownership_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ownership_role", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input['ConnectionConfluentSchemaRegistryPasswordArgs']]:
        """
        The password for the Confluent Schema Registry.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input['ConnectionConfluentSchemaRegistryPasswordArgs']]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the connection schema in Materialize. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema_name", value)

    @_builtins.property
    @pulumi.getter(name="sshTunnel")
    def ssh_tunnel(self) -> Optional[pulumi.Input['ConnectionConfluentSchemaRegistrySshTunnelArgs']]:
        """
        The SSH tunnel configuration for the Confluent Schema Registry.
        """
        return pulumi.get(self, "ssh_tunnel")

    @ssh_tunnel.setter
    def ssh_tunnel(self, value: Optional[pulumi.Input['ConnectionConfluentSchemaRegistrySshTunnelArgs']]):
        pulumi.set(self, "ssh_tunnel", value)

    @_builtins.property
    @pulumi.getter(name="sslCertificate")
    def ssl_certificate(self) -> Optional[pulumi.Input['ConnectionConfluentSchemaRegistrySslCertificateArgs']]:
        """
        The client certificate for the Confluent Schema Registry.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "ssl_certificate")

    @ssl_certificate.setter
    def ssl_certificate(self, value: Optional[pulumi.Input['ConnectionConfluentSchemaRegistrySslCertificateArgs']]):
        pulumi.set(self, "ssl_certificate", value)

    @_builtins.property
    @pulumi.getter(name="sslCertificateAuthority")
    def ssl_certificate_authority(self) -> Optional[pulumi.Input['ConnectionConfluentSchemaRegistrySslCertificateAuthorityArgs']]:
        """
        The CA certificate for the Confluent Schema Registry.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "ssl_certificate_authority")

    @ssl_certificate_authority.setter
    def ssl_certificate_authority(self, value: Optional[pulumi.Input['ConnectionConfluentSchemaRegistrySslCertificateAuthorityArgs']]):
        pulumi.set(self, "ssl_certificate_authority", value)

    @_builtins.property
    @pulumi.getter(name="sslKey")
    def ssl_key(self) -> Optional[pulumi.Input['ConnectionConfluentSchemaRegistrySslKeyArgs']]:
        """
        The client key for the Confluent Schema Registry.
        """
        return pulumi.get(self, "ssl_key")

    @ssl_key.setter
    def ssl_key(self, value: Optional[pulumi.Input['ConnectionConfluentSchemaRegistrySslKeyArgs']]):
        pulumi.set(self, "ssl_key", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input['ConnectionConfluentSchemaRegistryUsernameArgs']]:
        """
        The username for the Confluent Schema Registry.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input['ConnectionConfluentSchemaRegistryUsernameArgs']]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter
    def validate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If the connection should wait for validation.
        """
        return pulumi.get(self, "validate")

    @validate.setter
    def validate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "validate", value)


@pulumi.input_type
class _ConnectionConfluentSchemaRegistryState:
    def __init__(__self__, *,
                 aws_privatelink: Optional[pulumi.Input['ConnectionConfluentSchemaRegistryAwsPrivatelinkArgs']] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input['ConnectionConfluentSchemaRegistryPasswordArgs']] = None,
                 qualified_sql_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_tunnel: Optional[pulumi.Input['ConnectionConfluentSchemaRegistrySshTunnelArgs']] = None,
                 ssl_certificate: Optional[pulumi.Input['ConnectionConfluentSchemaRegistrySslCertificateArgs']] = None,
                 ssl_certificate_authority: Optional[pulumi.Input['ConnectionConfluentSchemaRegistrySslCertificateAuthorityArgs']] = None,
                 ssl_key: Optional[pulumi.Input['ConnectionConfluentSchemaRegistrySslKeyArgs']] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input['ConnectionConfluentSchemaRegistryUsernameArgs']] = None,
                 validate: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ConnectionConfluentSchemaRegistry resources.
        :param pulumi.Input['ConnectionConfluentSchemaRegistryAwsPrivatelinkArgs'] aws_privatelink: The AWS PrivateLink configuration for the Confluent Schema Registry.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[_builtins.str] name: The identifier for the connection.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input['ConnectionConfluentSchemaRegistryPasswordArgs'] password: The password for the Confluent Schema Registry.
        :param pulumi.Input[_builtins.str] qualified_sql_name: The fully qualified name of the connection.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the connection schema in Materialize. Defaults to `public`.
        :param pulumi.Input['ConnectionConfluentSchemaRegistrySshTunnelArgs'] ssh_tunnel: The SSH tunnel configuration for the Confluent Schema Registry.
        :param pulumi.Input['ConnectionConfluentSchemaRegistrySslCertificateArgs'] ssl_certificate: The client certificate for the Confluent Schema Registry.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input['ConnectionConfluentSchemaRegistrySslCertificateAuthorityArgs'] ssl_certificate_authority: The CA certificate for the Confluent Schema Registry.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input['ConnectionConfluentSchemaRegistrySslKeyArgs'] ssl_key: The client key for the Confluent Schema Registry.
        :param pulumi.Input[_builtins.str] url: The URL of the Confluent Schema Registry.
        :param pulumi.Input['ConnectionConfluentSchemaRegistryUsernameArgs'] username: The username for the Confluent Schema Registry.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[_builtins.bool] validate: If the connection should wait for validation.
        """
        if aws_privatelink is not None:
            pulumi.set(__self__, "aws_privatelink", aws_privatelink)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ownership_role is not None:
            pulumi.set(__self__, "ownership_role", ownership_role)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if qualified_sql_name is not None:
            pulumi.set(__self__, "qualified_sql_name", qualified_sql_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if ssh_tunnel is not None:
            pulumi.set(__self__, "ssh_tunnel", ssh_tunnel)
        if ssl_certificate is not None:
            pulumi.set(__self__, "ssl_certificate", ssl_certificate)
        if ssl_certificate_authority is not None:
            pulumi.set(__self__, "ssl_certificate_authority", ssl_certificate_authority)
        if ssl_key is not None:
            pulumi.set(__self__, "ssl_key", ssl_key)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if validate is not None:
            pulumi.set(__self__, "validate", validate)

    @_builtins.property
    @pulumi.getter(name="awsPrivatelink")
    def aws_privatelink(self) -> Optional[pulumi.Input['ConnectionConfluentSchemaRegistryAwsPrivatelinkArgs']]:
        """
        The AWS PrivateLink configuration for the Confluent Schema Registry.
        """
        return pulumi.get(self, "aws_privatelink")

    @aws_privatelink.setter
    def aws_privatelink(self, value: Optional[pulumi.Input['ConnectionConfluentSchemaRegistryAwsPrivatelinkArgs']]):
        pulumi.set(self, "aws_privatelink", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the connection.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @ownership_role.setter
    def ownership_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ownership_role", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input['ConnectionConfluentSchemaRegistryPasswordArgs']]:
        """
        The password for the Confluent Schema Registry.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input['ConnectionConfluentSchemaRegistryPasswordArgs']]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="qualifiedSqlName")
    def qualified_sql_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified name of the connection.
        """
        return pulumi.get(self, "qualified_sql_name")

    @qualified_sql_name.setter
    def qualified_sql_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "qualified_sql_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the connection schema in Materialize. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema_name", value)

    @_builtins.property
    @pulumi.getter(name="sshTunnel")
    def ssh_tunnel(self) -> Optional[pulumi.Input['ConnectionConfluentSchemaRegistrySshTunnelArgs']]:
        """
        The SSH tunnel configuration for the Confluent Schema Registry.
        """
        return pulumi.get(self, "ssh_tunnel")

    @ssh_tunnel.setter
    def ssh_tunnel(self, value: Optional[pulumi.Input['ConnectionConfluentSchemaRegistrySshTunnelArgs']]):
        pulumi.set(self, "ssh_tunnel", value)

    @_builtins.property
    @pulumi.getter(name="sslCertificate")
    def ssl_certificate(self) -> Optional[pulumi.Input['ConnectionConfluentSchemaRegistrySslCertificateArgs']]:
        """
        The client certificate for the Confluent Schema Registry.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "ssl_certificate")

    @ssl_certificate.setter
    def ssl_certificate(self, value: Optional[pulumi.Input['ConnectionConfluentSchemaRegistrySslCertificateArgs']]):
        pulumi.set(self, "ssl_certificate", value)

    @_builtins.property
    @pulumi.getter(name="sslCertificateAuthority")
    def ssl_certificate_authority(self) -> Optional[pulumi.Input['ConnectionConfluentSchemaRegistrySslCertificateAuthorityArgs']]:
        """
        The CA certificate for the Confluent Schema Registry.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "ssl_certificate_authority")

    @ssl_certificate_authority.setter
    def ssl_certificate_authority(self, value: Optional[pulumi.Input['ConnectionConfluentSchemaRegistrySslCertificateAuthorityArgs']]):
        pulumi.set(self, "ssl_certificate_authority", value)

    @_builtins.property
    @pulumi.getter(name="sslKey")
    def ssl_key(self) -> Optional[pulumi.Input['ConnectionConfluentSchemaRegistrySslKeyArgs']]:
        """
        The client key for the Confluent Schema Registry.
        """
        return pulumi.get(self, "ssl_key")

    @ssl_key.setter
    def ssl_key(self, value: Optional[pulumi.Input['ConnectionConfluentSchemaRegistrySslKeyArgs']]):
        pulumi.set(self, "ssl_key", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the Confluent Schema Registry.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input['ConnectionConfluentSchemaRegistryUsernameArgs']]:
        """
        The username for the Confluent Schema Registry.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input['ConnectionConfluentSchemaRegistryUsernameArgs']]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter
    def validate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If the connection should wait for validation.
        """
        return pulumi.get(self, "validate")

    @validate.setter
    def validate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "validate", value)


@pulumi.type_token("materialize:index/connectionConfluentSchemaRegistry:ConnectionConfluentSchemaRegistry")
class ConnectionConfluentSchemaRegistry(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_privatelink: Optional[pulumi.Input[Union['ConnectionConfluentSchemaRegistryAwsPrivatelinkArgs', 'ConnectionConfluentSchemaRegistryAwsPrivatelinkArgsDict']]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[Union['ConnectionConfluentSchemaRegistryPasswordArgs', 'ConnectionConfluentSchemaRegistryPasswordArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_tunnel: Optional[pulumi.Input[Union['ConnectionConfluentSchemaRegistrySshTunnelArgs', 'ConnectionConfluentSchemaRegistrySshTunnelArgsDict']]] = None,
                 ssl_certificate: Optional[pulumi.Input[Union['ConnectionConfluentSchemaRegistrySslCertificateArgs', 'ConnectionConfluentSchemaRegistrySslCertificateArgsDict']]] = None,
                 ssl_certificate_authority: Optional[pulumi.Input[Union['ConnectionConfluentSchemaRegistrySslCertificateAuthorityArgs', 'ConnectionConfluentSchemaRegistrySslCertificateAuthorityArgsDict']]] = None,
                 ssl_key: Optional[pulumi.Input[Union['ConnectionConfluentSchemaRegistrySslKeyArgs', 'ConnectionConfluentSchemaRegistrySslKeyArgsDict']]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[Union['ConnectionConfluentSchemaRegistryUsernameArgs', 'ConnectionConfluentSchemaRegistryUsernameArgsDict']]] = None,
                 validate: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        A Confluent Schema Registry connection establishes a link to a Confluent Schema Registry server.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        # Create a Confluent Schema Registry Connection
        example_confluent_schema_registry_connection = materialize.ConnectionConfluentSchemaRegistry("exampleConfluentSchemaRegistryConnection",
            password={
                "database_name": "database",
                "name": "example",
                "schema_name": "schema",
            },
            url="https://rp-f00000bar.data.vectorized.cloud:30993",
            username={
                "text": "example",
            })
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Connections can be imported using the connection id:

        ```sh
        $ pulumi import materialize:index/connectionConfluentSchemaRegistry:ConnectionConfluentSchemaRegistry example <region>:<connection_id>
        ```

        Connection id and information be found in the `mz_catalog.mz_connections` table

        The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ConnectionConfluentSchemaRegistryAwsPrivatelinkArgs', 'ConnectionConfluentSchemaRegistryAwsPrivatelinkArgsDict']] aws_privatelink: The AWS PrivateLink configuration for the Confluent Schema Registry.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[_builtins.str] name: The identifier for the connection.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input[Union['ConnectionConfluentSchemaRegistryPasswordArgs', 'ConnectionConfluentSchemaRegistryPasswordArgsDict']] password: The password for the Confluent Schema Registry.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the connection schema in Materialize. Defaults to `public`.
        :param pulumi.Input[Union['ConnectionConfluentSchemaRegistrySshTunnelArgs', 'ConnectionConfluentSchemaRegistrySshTunnelArgsDict']] ssh_tunnel: The SSH tunnel configuration for the Confluent Schema Registry.
        :param pulumi.Input[Union['ConnectionConfluentSchemaRegistrySslCertificateArgs', 'ConnectionConfluentSchemaRegistrySslCertificateArgsDict']] ssl_certificate: The client certificate for the Confluent Schema Registry.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[Union['ConnectionConfluentSchemaRegistrySslCertificateAuthorityArgs', 'ConnectionConfluentSchemaRegistrySslCertificateAuthorityArgsDict']] ssl_certificate_authority: The CA certificate for the Confluent Schema Registry.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[Union['ConnectionConfluentSchemaRegistrySslKeyArgs', 'ConnectionConfluentSchemaRegistrySslKeyArgsDict']] ssl_key: The client key for the Confluent Schema Registry.
        :param pulumi.Input[_builtins.str] url: The URL of the Confluent Schema Registry.
        :param pulumi.Input[Union['ConnectionConfluentSchemaRegistryUsernameArgs', 'ConnectionConfluentSchemaRegistryUsernameArgsDict']] username: The username for the Confluent Schema Registry.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[_builtins.bool] validate: If the connection should wait for validation.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectionConfluentSchemaRegistryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Confluent Schema Registry connection establishes a link to a Confluent Schema Registry server.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        # Create a Confluent Schema Registry Connection
        example_confluent_schema_registry_connection = materialize.ConnectionConfluentSchemaRegistry("exampleConfluentSchemaRegistryConnection",
            password={
                "database_name": "database",
                "name": "example",
                "schema_name": "schema",
            },
            url="https://rp-f00000bar.data.vectorized.cloud:30993",
            username={
                "text": "example",
            })
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Connections can be imported using the connection id:

        ```sh
        $ pulumi import materialize:index/connectionConfluentSchemaRegistry:ConnectionConfluentSchemaRegistry example <region>:<connection_id>
        ```

        Connection id and information be found in the `mz_catalog.mz_connections` table

        The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param ConnectionConfluentSchemaRegistryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectionConfluentSchemaRegistryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_privatelink: Optional[pulumi.Input[Union['ConnectionConfluentSchemaRegistryAwsPrivatelinkArgs', 'ConnectionConfluentSchemaRegistryAwsPrivatelinkArgsDict']]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[Union['ConnectionConfluentSchemaRegistryPasswordArgs', 'ConnectionConfluentSchemaRegistryPasswordArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_tunnel: Optional[pulumi.Input[Union['ConnectionConfluentSchemaRegistrySshTunnelArgs', 'ConnectionConfluentSchemaRegistrySshTunnelArgsDict']]] = None,
                 ssl_certificate: Optional[pulumi.Input[Union['ConnectionConfluentSchemaRegistrySslCertificateArgs', 'ConnectionConfluentSchemaRegistrySslCertificateArgsDict']]] = None,
                 ssl_certificate_authority: Optional[pulumi.Input[Union['ConnectionConfluentSchemaRegistrySslCertificateAuthorityArgs', 'ConnectionConfluentSchemaRegistrySslCertificateAuthorityArgsDict']]] = None,
                 ssl_key: Optional[pulumi.Input[Union['ConnectionConfluentSchemaRegistrySslKeyArgs', 'ConnectionConfluentSchemaRegistrySslKeyArgsDict']]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[Union['ConnectionConfluentSchemaRegistryUsernameArgs', 'ConnectionConfluentSchemaRegistryUsernameArgsDict']]] = None,
                 validate: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectionConfluentSchemaRegistryArgs.__new__(ConnectionConfluentSchemaRegistryArgs)

            __props__.__dict__["aws_privatelink"] = aws_privatelink
            __props__.__dict__["comment"] = comment
            __props__.__dict__["database_name"] = database_name
            __props__.__dict__["name"] = name
            __props__.__dict__["ownership_role"] = ownership_role
            __props__.__dict__["password"] = password
            __props__.__dict__["region"] = region
            __props__.__dict__["schema_name"] = schema_name
            __props__.__dict__["ssh_tunnel"] = ssh_tunnel
            __props__.__dict__["ssl_certificate"] = ssl_certificate
            __props__.__dict__["ssl_certificate_authority"] = ssl_certificate_authority
            __props__.__dict__["ssl_key"] = ssl_key
            if url is None and not opts.urn:
                raise TypeError("Missing required property 'url'")
            __props__.__dict__["url"] = url
            __props__.__dict__["username"] = username
            __props__.__dict__["validate"] = validate
            __props__.__dict__["qualified_sql_name"] = None
        super(ConnectionConfluentSchemaRegistry, __self__).__init__(
            'materialize:index/connectionConfluentSchemaRegistry:ConnectionConfluentSchemaRegistry',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws_privatelink: Optional[pulumi.Input[Union['ConnectionConfluentSchemaRegistryAwsPrivatelinkArgs', 'ConnectionConfluentSchemaRegistryAwsPrivatelinkArgsDict']]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            database_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[Union['ConnectionConfluentSchemaRegistryPasswordArgs', 'ConnectionConfluentSchemaRegistryPasswordArgsDict']]] = None,
            qualified_sql_name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            schema_name: Optional[pulumi.Input[_builtins.str]] = None,
            ssh_tunnel: Optional[pulumi.Input[Union['ConnectionConfluentSchemaRegistrySshTunnelArgs', 'ConnectionConfluentSchemaRegistrySshTunnelArgsDict']]] = None,
            ssl_certificate: Optional[pulumi.Input[Union['ConnectionConfluentSchemaRegistrySslCertificateArgs', 'ConnectionConfluentSchemaRegistrySslCertificateArgsDict']]] = None,
            ssl_certificate_authority: Optional[pulumi.Input[Union['ConnectionConfluentSchemaRegistrySslCertificateAuthorityArgs', 'ConnectionConfluentSchemaRegistrySslCertificateAuthorityArgsDict']]] = None,
            ssl_key: Optional[pulumi.Input[Union['ConnectionConfluentSchemaRegistrySslKeyArgs', 'ConnectionConfluentSchemaRegistrySslKeyArgsDict']]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None,
            username: Optional[pulumi.Input[Union['ConnectionConfluentSchemaRegistryUsernameArgs', 'ConnectionConfluentSchemaRegistryUsernameArgsDict']]] = None,
            validate: Optional[pulumi.Input[_builtins.bool]] = None) -> 'ConnectionConfluentSchemaRegistry':
        """
        Get an existing ConnectionConfluentSchemaRegistry resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ConnectionConfluentSchemaRegistryAwsPrivatelinkArgs', 'ConnectionConfluentSchemaRegistryAwsPrivatelinkArgsDict']] aws_privatelink: The AWS PrivateLink configuration for the Confluent Schema Registry.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[_builtins.str] name: The identifier for the connection.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input[Union['ConnectionConfluentSchemaRegistryPasswordArgs', 'ConnectionConfluentSchemaRegistryPasswordArgsDict']] password: The password for the Confluent Schema Registry.
        :param pulumi.Input[_builtins.str] qualified_sql_name: The fully qualified name of the connection.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the connection schema in Materialize. Defaults to `public`.
        :param pulumi.Input[Union['ConnectionConfluentSchemaRegistrySshTunnelArgs', 'ConnectionConfluentSchemaRegistrySshTunnelArgsDict']] ssh_tunnel: The SSH tunnel configuration for the Confluent Schema Registry.
        :param pulumi.Input[Union['ConnectionConfluentSchemaRegistrySslCertificateArgs', 'ConnectionConfluentSchemaRegistrySslCertificateArgsDict']] ssl_certificate: The client certificate for the Confluent Schema Registry.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[Union['ConnectionConfluentSchemaRegistrySslCertificateAuthorityArgs', 'ConnectionConfluentSchemaRegistrySslCertificateAuthorityArgsDict']] ssl_certificate_authority: The CA certificate for the Confluent Schema Registry.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[Union['ConnectionConfluentSchemaRegistrySslKeyArgs', 'ConnectionConfluentSchemaRegistrySslKeyArgsDict']] ssl_key: The client key for the Confluent Schema Registry.
        :param pulumi.Input[_builtins.str] url: The URL of the Confluent Schema Registry.
        :param pulumi.Input[Union['ConnectionConfluentSchemaRegistryUsernameArgs', 'ConnectionConfluentSchemaRegistryUsernameArgsDict']] username: The username for the Confluent Schema Registry.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[_builtins.bool] validate: If the connection should wait for validation.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectionConfluentSchemaRegistryState.__new__(_ConnectionConfluentSchemaRegistryState)

        __props__.__dict__["aws_privatelink"] = aws_privatelink
        __props__.__dict__["comment"] = comment
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["name"] = name
        __props__.__dict__["ownership_role"] = ownership_role
        __props__.__dict__["password"] = password
        __props__.__dict__["qualified_sql_name"] = qualified_sql_name
        __props__.__dict__["region"] = region
        __props__.__dict__["schema_name"] = schema_name
        __props__.__dict__["ssh_tunnel"] = ssh_tunnel
        __props__.__dict__["ssl_certificate"] = ssl_certificate
        __props__.__dict__["ssl_certificate_authority"] = ssl_certificate_authority
        __props__.__dict__["ssl_key"] = ssl_key
        __props__.__dict__["url"] = url
        __props__.__dict__["username"] = username
        __props__.__dict__["validate"] = validate
        return ConnectionConfluentSchemaRegistry(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="awsPrivatelink")
    def aws_privatelink(self) -> pulumi.Output[Optional['outputs.ConnectionConfluentSchemaRegistryAwsPrivatelink']]:
        """
        The AWS PrivateLink configuration for the Confluent Schema Registry.
        """
        return pulumi.get(self, "aws_privatelink")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The identifier for the connection.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> pulumi.Output[_builtins.str]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional['outputs.ConnectionConfluentSchemaRegistryPassword']]:
        """
        The password for the Confluent Schema Registry.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="qualifiedSqlName")
    def qualified_sql_name(self) -> pulumi.Output[_builtins.str]:
        """
        The fully qualified name of the connection.
        """
        return pulumi.get(self, "qualified_sql_name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The identifier for the connection schema in Materialize. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @_builtins.property
    @pulumi.getter(name="sshTunnel")
    def ssh_tunnel(self) -> pulumi.Output[Optional['outputs.ConnectionConfluentSchemaRegistrySshTunnel']]:
        """
        The SSH tunnel configuration for the Confluent Schema Registry.
        """
        return pulumi.get(self, "ssh_tunnel")

    @_builtins.property
    @pulumi.getter(name="sslCertificate")
    def ssl_certificate(self) -> pulumi.Output[Optional['outputs.ConnectionConfluentSchemaRegistrySslCertificate']]:
        """
        The client certificate for the Confluent Schema Registry.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "ssl_certificate")

    @_builtins.property
    @pulumi.getter(name="sslCertificateAuthority")
    def ssl_certificate_authority(self) -> pulumi.Output[Optional['outputs.ConnectionConfluentSchemaRegistrySslCertificateAuthority']]:
        """
        The CA certificate for the Confluent Schema Registry.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "ssl_certificate_authority")

    @_builtins.property
    @pulumi.getter(name="sslKey")
    def ssl_key(self) -> pulumi.Output[Optional['outputs.ConnectionConfluentSchemaRegistrySslKey']]:
        """
        The client key for the Confluent Schema Registry.
        """
        return pulumi.get(self, "ssl_key")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        The URL of the Confluent Schema Registry.
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[Optional['outputs.ConnectionConfluentSchemaRegistryUsername']]:
        """
        The username for the Confluent Schema Registry.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter
    def validate(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If the connection should wait for validation.
        """
        return pulumi.get(self, "validate")

