# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConnectionKafkaArgs', 'ConnectionKafka']

@pulumi.input_type
class ConnectionKafkaArgs:
    def __init__(__self__, *,
                 aws_connection: Optional[pulumi.Input['ConnectionKafkaAwsConnectionArgs']] = None,
                 aws_privatelink: Optional[pulumi.Input['ConnectionKafkaAwsPrivatelinkArgs']] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kafka_brokers: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionKafkaKafkaBrokerArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 progress_topic: Optional[pulumi.Input[_builtins.str]] = None,
                 progress_topic_replication_factor: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sasl_mechanisms: Optional[pulumi.Input[_builtins.str]] = None,
                 sasl_password: Optional[pulumi.Input['ConnectionKafkaSaslPasswordArgs']] = None,
                 sasl_username: Optional[pulumi.Input['ConnectionKafkaSaslUsernameArgs']] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_tunnel: Optional[pulumi.Input['ConnectionKafkaSshTunnelArgs']] = None,
                 ssl_certificate: Optional[pulumi.Input['ConnectionKafkaSslCertificateArgs']] = None,
                 ssl_certificate_authority: Optional[pulumi.Input['ConnectionKafkaSslCertificateAuthorityArgs']] = None,
                 ssl_key: Optional[pulumi.Input['ConnectionKafkaSslKeyArgs']] = None,
                 validate: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ConnectionKafka resource.
        :param pulumi.Input['ConnectionKafkaAwsConnectionArgs'] aws_connection: The AWS connection to use for IAM authentication.
        :param pulumi.Input['ConnectionKafkaAwsPrivatelinkArgs'] aws_privatelink: AWS PrivateLink configuration. Conflicts with `kafka_broker`.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectionKafkaKafkaBrokerArgs']]] kafka_brokers: The Kafka broker's configuration.
        :param pulumi.Input[_builtins.str] name: The identifier for the connection.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input[_builtins.str] progress_topic: The name of a topic that Kafka sinks can use to track internal consistency metadata.
        :param pulumi.Input[_builtins.int] progress_topic_replication_factor: The replication factor to use when creating the Kafka progress topic (if the Kafka topic does not already exist).
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] sasl_mechanisms: The SASL mechanism for the Kafka broker.
        :param pulumi.Input['ConnectionKafkaSaslPasswordArgs'] sasl_password: The SASL password for the Kafka broker.
        :param pulumi.Input['ConnectionKafkaSaslUsernameArgs'] sasl_username: The SASL username for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the connection schema in Materialize. Defaults to `public`.
        :param pulumi.Input[_builtins.str] security_protocol: The security protocol to use: `PLAINTEXT`, `SSL`, `SASL_PLAINTEXT`, or `SASL_SSL`.
        :param pulumi.Input['ConnectionKafkaSshTunnelArgs'] ssh_tunnel: The default SSH tunnel configuration for the Kafka brokers.
        :param pulumi.Input['ConnectionKafkaSslCertificateArgs'] ssl_certificate: The client certificate for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input['ConnectionKafkaSslCertificateAuthorityArgs'] ssl_certificate_authority: The CA certificate for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input['ConnectionKafkaSslKeyArgs'] ssl_key: The client key for the Kafka broker.
        :param pulumi.Input[_builtins.bool] validate: If the connection should wait for validation.
        """
        if aws_connection is not None:
            pulumi.set(__self__, "aws_connection", aws_connection)
        if aws_privatelink is not None:
            pulumi.set(__self__, "aws_privatelink", aws_privatelink)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if kafka_brokers is not None:
            pulumi.set(__self__, "kafka_brokers", kafka_brokers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ownership_role is not None:
            pulumi.set(__self__, "ownership_role", ownership_role)
        if progress_topic is not None:
            pulumi.set(__self__, "progress_topic", progress_topic)
        if progress_topic_replication_factor is not None:
            pulumi.set(__self__, "progress_topic_replication_factor", progress_topic_replication_factor)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sasl_mechanisms is not None:
            pulumi.set(__self__, "sasl_mechanisms", sasl_mechanisms)
        if sasl_password is not None:
            pulumi.set(__self__, "sasl_password", sasl_password)
        if sasl_username is not None:
            pulumi.set(__self__, "sasl_username", sasl_username)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if security_protocol is not None:
            pulumi.set(__self__, "security_protocol", security_protocol)
        if ssh_tunnel is not None:
            pulumi.set(__self__, "ssh_tunnel", ssh_tunnel)
        if ssl_certificate is not None:
            pulumi.set(__self__, "ssl_certificate", ssl_certificate)
        if ssl_certificate_authority is not None:
            pulumi.set(__self__, "ssl_certificate_authority", ssl_certificate_authority)
        if ssl_key is not None:
            pulumi.set(__self__, "ssl_key", ssl_key)
        if validate is not None:
            pulumi.set(__self__, "validate", validate)

    @_builtins.property
    @pulumi.getter(name="awsConnection")
    def aws_connection(self) -> Optional[pulumi.Input['ConnectionKafkaAwsConnectionArgs']]:
        """
        The AWS connection to use for IAM authentication.
        """
        return pulumi.get(self, "aws_connection")

    @aws_connection.setter
    def aws_connection(self, value: Optional[pulumi.Input['ConnectionKafkaAwsConnectionArgs']]):
        pulumi.set(self, "aws_connection", value)

    @_builtins.property
    @pulumi.getter(name="awsPrivatelink")
    def aws_privatelink(self) -> Optional[pulumi.Input['ConnectionKafkaAwsPrivatelinkArgs']]:
        """
        AWS PrivateLink configuration. Conflicts with `kafka_broker`.
        """
        return pulumi.get(self, "aws_privatelink")

    @aws_privatelink.setter
    def aws_privatelink(self, value: Optional[pulumi.Input['ConnectionKafkaAwsPrivatelinkArgs']]):
        pulumi.set(self, "aws_privatelink", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter(name="kafkaBrokers")
    def kafka_brokers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionKafkaKafkaBrokerArgs']]]]:
        """
        The Kafka broker's configuration.
        """
        return pulumi.get(self, "kafka_brokers")

    @kafka_brokers.setter
    def kafka_brokers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionKafkaKafkaBrokerArgs']]]]):
        pulumi.set(self, "kafka_brokers", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the connection.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @ownership_role.setter
    def ownership_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ownership_role", value)

    @_builtins.property
    @pulumi.getter(name="progressTopic")
    def progress_topic(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of a topic that Kafka sinks can use to track internal consistency metadata.
        """
        return pulumi.get(self, "progress_topic")

    @progress_topic.setter
    def progress_topic(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "progress_topic", value)

    @_builtins.property
    @pulumi.getter(name="progressTopicReplicationFactor")
    def progress_topic_replication_factor(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The replication factor to use when creating the Kafka progress topic (if the Kafka topic does not already exist).
        """
        return pulumi.get(self, "progress_topic_replication_factor")

    @progress_topic_replication_factor.setter
    def progress_topic_replication_factor(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "progress_topic_replication_factor", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="saslMechanisms")
    def sasl_mechanisms(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SASL mechanism for the Kafka broker.
        """
        return pulumi.get(self, "sasl_mechanisms")

    @sasl_mechanisms.setter
    def sasl_mechanisms(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sasl_mechanisms", value)

    @_builtins.property
    @pulumi.getter(name="saslPassword")
    def sasl_password(self) -> Optional[pulumi.Input['ConnectionKafkaSaslPasswordArgs']]:
        """
        The SASL password for the Kafka broker.
        """
        return pulumi.get(self, "sasl_password")

    @sasl_password.setter
    def sasl_password(self, value: Optional[pulumi.Input['ConnectionKafkaSaslPasswordArgs']]):
        pulumi.set(self, "sasl_password", value)

    @_builtins.property
    @pulumi.getter(name="saslUsername")
    def sasl_username(self) -> Optional[pulumi.Input['ConnectionKafkaSaslUsernameArgs']]:
        """
        The SASL username for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "sasl_username")

    @sasl_username.setter
    def sasl_username(self, value: Optional[pulumi.Input['ConnectionKafkaSaslUsernameArgs']]):
        pulumi.set(self, "sasl_username", value)

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the connection schema in Materialize. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema_name", value)

    @_builtins.property
    @pulumi.getter(name="securityProtocol")
    def security_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The security protocol to use: `PLAINTEXT`, `SSL`, `SASL_PLAINTEXT`, or `SASL_SSL`.
        """
        return pulumi.get(self, "security_protocol")

    @security_protocol.setter
    def security_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_protocol", value)

    @_builtins.property
    @pulumi.getter(name="sshTunnel")
    def ssh_tunnel(self) -> Optional[pulumi.Input['ConnectionKafkaSshTunnelArgs']]:
        """
        The default SSH tunnel configuration for the Kafka brokers.
        """
        return pulumi.get(self, "ssh_tunnel")

    @ssh_tunnel.setter
    def ssh_tunnel(self, value: Optional[pulumi.Input['ConnectionKafkaSshTunnelArgs']]):
        pulumi.set(self, "ssh_tunnel", value)

    @_builtins.property
    @pulumi.getter(name="sslCertificate")
    def ssl_certificate(self) -> Optional[pulumi.Input['ConnectionKafkaSslCertificateArgs']]:
        """
        The client certificate for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "ssl_certificate")

    @ssl_certificate.setter
    def ssl_certificate(self, value: Optional[pulumi.Input['ConnectionKafkaSslCertificateArgs']]):
        pulumi.set(self, "ssl_certificate", value)

    @_builtins.property
    @pulumi.getter(name="sslCertificateAuthority")
    def ssl_certificate_authority(self) -> Optional[pulumi.Input['ConnectionKafkaSslCertificateAuthorityArgs']]:
        """
        The CA certificate for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "ssl_certificate_authority")

    @ssl_certificate_authority.setter
    def ssl_certificate_authority(self, value: Optional[pulumi.Input['ConnectionKafkaSslCertificateAuthorityArgs']]):
        pulumi.set(self, "ssl_certificate_authority", value)

    @_builtins.property
    @pulumi.getter(name="sslKey")
    def ssl_key(self) -> Optional[pulumi.Input['ConnectionKafkaSslKeyArgs']]:
        """
        The client key for the Kafka broker.
        """
        return pulumi.get(self, "ssl_key")

    @ssl_key.setter
    def ssl_key(self, value: Optional[pulumi.Input['ConnectionKafkaSslKeyArgs']]):
        pulumi.set(self, "ssl_key", value)

    @_builtins.property
    @pulumi.getter
    def validate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If the connection should wait for validation.
        """
        return pulumi.get(self, "validate")

    @validate.setter
    def validate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "validate", value)


@pulumi.input_type
class _ConnectionKafkaState:
    def __init__(__self__, *,
                 aws_connection: Optional[pulumi.Input['ConnectionKafkaAwsConnectionArgs']] = None,
                 aws_privatelink: Optional[pulumi.Input['ConnectionKafkaAwsPrivatelinkArgs']] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kafka_brokers: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionKafkaKafkaBrokerArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 progress_topic: Optional[pulumi.Input[_builtins.str]] = None,
                 progress_topic_replication_factor: Optional[pulumi.Input[_builtins.int]] = None,
                 qualified_sql_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sasl_mechanisms: Optional[pulumi.Input[_builtins.str]] = None,
                 sasl_password: Optional[pulumi.Input['ConnectionKafkaSaslPasswordArgs']] = None,
                 sasl_username: Optional[pulumi.Input['ConnectionKafkaSaslUsernameArgs']] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_tunnel: Optional[pulumi.Input['ConnectionKafkaSshTunnelArgs']] = None,
                 ssl_certificate: Optional[pulumi.Input['ConnectionKafkaSslCertificateArgs']] = None,
                 ssl_certificate_authority: Optional[pulumi.Input['ConnectionKafkaSslCertificateAuthorityArgs']] = None,
                 ssl_key: Optional[pulumi.Input['ConnectionKafkaSslKeyArgs']] = None,
                 validate: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ConnectionKafka resources.
        :param pulumi.Input['ConnectionKafkaAwsConnectionArgs'] aws_connection: The AWS connection to use for IAM authentication.
        :param pulumi.Input['ConnectionKafkaAwsPrivatelinkArgs'] aws_privatelink: AWS PrivateLink configuration. Conflicts with `kafka_broker`.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectionKafkaKafkaBrokerArgs']]] kafka_brokers: The Kafka broker's configuration.
        :param pulumi.Input[_builtins.str] name: The identifier for the connection.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input[_builtins.str] progress_topic: The name of a topic that Kafka sinks can use to track internal consistency metadata.
        :param pulumi.Input[_builtins.int] progress_topic_replication_factor: The replication factor to use when creating the Kafka progress topic (if the Kafka topic does not already exist).
        :param pulumi.Input[_builtins.str] qualified_sql_name: The fully qualified name of the connection.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] sasl_mechanisms: The SASL mechanism for the Kafka broker.
        :param pulumi.Input['ConnectionKafkaSaslPasswordArgs'] sasl_password: The SASL password for the Kafka broker.
        :param pulumi.Input['ConnectionKafkaSaslUsernameArgs'] sasl_username: The SASL username for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the connection schema in Materialize. Defaults to `public`.
        :param pulumi.Input[_builtins.str] security_protocol: The security protocol to use: `PLAINTEXT`, `SSL`, `SASL_PLAINTEXT`, or `SASL_SSL`.
        :param pulumi.Input['ConnectionKafkaSshTunnelArgs'] ssh_tunnel: The default SSH tunnel configuration for the Kafka brokers.
        :param pulumi.Input['ConnectionKafkaSslCertificateArgs'] ssl_certificate: The client certificate for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input['ConnectionKafkaSslCertificateAuthorityArgs'] ssl_certificate_authority: The CA certificate for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input['ConnectionKafkaSslKeyArgs'] ssl_key: The client key for the Kafka broker.
        :param pulumi.Input[_builtins.bool] validate: If the connection should wait for validation.
        """
        if aws_connection is not None:
            pulumi.set(__self__, "aws_connection", aws_connection)
        if aws_privatelink is not None:
            pulumi.set(__self__, "aws_privatelink", aws_privatelink)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if kafka_brokers is not None:
            pulumi.set(__self__, "kafka_brokers", kafka_brokers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ownership_role is not None:
            pulumi.set(__self__, "ownership_role", ownership_role)
        if progress_topic is not None:
            pulumi.set(__self__, "progress_topic", progress_topic)
        if progress_topic_replication_factor is not None:
            pulumi.set(__self__, "progress_topic_replication_factor", progress_topic_replication_factor)
        if qualified_sql_name is not None:
            pulumi.set(__self__, "qualified_sql_name", qualified_sql_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sasl_mechanisms is not None:
            pulumi.set(__self__, "sasl_mechanisms", sasl_mechanisms)
        if sasl_password is not None:
            pulumi.set(__self__, "sasl_password", sasl_password)
        if sasl_username is not None:
            pulumi.set(__self__, "sasl_username", sasl_username)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if security_protocol is not None:
            pulumi.set(__self__, "security_protocol", security_protocol)
        if ssh_tunnel is not None:
            pulumi.set(__self__, "ssh_tunnel", ssh_tunnel)
        if ssl_certificate is not None:
            pulumi.set(__self__, "ssl_certificate", ssl_certificate)
        if ssl_certificate_authority is not None:
            pulumi.set(__self__, "ssl_certificate_authority", ssl_certificate_authority)
        if ssl_key is not None:
            pulumi.set(__self__, "ssl_key", ssl_key)
        if validate is not None:
            pulumi.set(__self__, "validate", validate)

    @_builtins.property
    @pulumi.getter(name="awsConnection")
    def aws_connection(self) -> Optional[pulumi.Input['ConnectionKafkaAwsConnectionArgs']]:
        """
        The AWS connection to use for IAM authentication.
        """
        return pulumi.get(self, "aws_connection")

    @aws_connection.setter
    def aws_connection(self, value: Optional[pulumi.Input['ConnectionKafkaAwsConnectionArgs']]):
        pulumi.set(self, "aws_connection", value)

    @_builtins.property
    @pulumi.getter(name="awsPrivatelink")
    def aws_privatelink(self) -> Optional[pulumi.Input['ConnectionKafkaAwsPrivatelinkArgs']]:
        """
        AWS PrivateLink configuration. Conflicts with `kafka_broker`.
        """
        return pulumi.get(self, "aws_privatelink")

    @aws_privatelink.setter
    def aws_privatelink(self, value: Optional[pulumi.Input['ConnectionKafkaAwsPrivatelinkArgs']]):
        pulumi.set(self, "aws_privatelink", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter(name="kafkaBrokers")
    def kafka_brokers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionKafkaKafkaBrokerArgs']]]]:
        """
        The Kafka broker's configuration.
        """
        return pulumi.get(self, "kafka_brokers")

    @kafka_brokers.setter
    def kafka_brokers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionKafkaKafkaBrokerArgs']]]]):
        pulumi.set(self, "kafka_brokers", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the connection.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @ownership_role.setter
    def ownership_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ownership_role", value)

    @_builtins.property
    @pulumi.getter(name="progressTopic")
    def progress_topic(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of a topic that Kafka sinks can use to track internal consistency metadata.
        """
        return pulumi.get(self, "progress_topic")

    @progress_topic.setter
    def progress_topic(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "progress_topic", value)

    @_builtins.property
    @pulumi.getter(name="progressTopicReplicationFactor")
    def progress_topic_replication_factor(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The replication factor to use when creating the Kafka progress topic (if the Kafka topic does not already exist).
        """
        return pulumi.get(self, "progress_topic_replication_factor")

    @progress_topic_replication_factor.setter
    def progress_topic_replication_factor(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "progress_topic_replication_factor", value)

    @_builtins.property
    @pulumi.getter(name="qualifiedSqlName")
    def qualified_sql_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified name of the connection.
        """
        return pulumi.get(self, "qualified_sql_name")

    @qualified_sql_name.setter
    def qualified_sql_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "qualified_sql_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="saslMechanisms")
    def sasl_mechanisms(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SASL mechanism for the Kafka broker.
        """
        return pulumi.get(self, "sasl_mechanisms")

    @sasl_mechanisms.setter
    def sasl_mechanisms(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sasl_mechanisms", value)

    @_builtins.property
    @pulumi.getter(name="saslPassword")
    def sasl_password(self) -> Optional[pulumi.Input['ConnectionKafkaSaslPasswordArgs']]:
        """
        The SASL password for the Kafka broker.
        """
        return pulumi.get(self, "sasl_password")

    @sasl_password.setter
    def sasl_password(self, value: Optional[pulumi.Input['ConnectionKafkaSaslPasswordArgs']]):
        pulumi.set(self, "sasl_password", value)

    @_builtins.property
    @pulumi.getter(name="saslUsername")
    def sasl_username(self) -> Optional[pulumi.Input['ConnectionKafkaSaslUsernameArgs']]:
        """
        The SASL username for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "sasl_username")

    @sasl_username.setter
    def sasl_username(self, value: Optional[pulumi.Input['ConnectionKafkaSaslUsernameArgs']]):
        pulumi.set(self, "sasl_username", value)

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the connection schema in Materialize. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema_name", value)

    @_builtins.property
    @pulumi.getter(name="securityProtocol")
    def security_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The security protocol to use: `PLAINTEXT`, `SSL`, `SASL_PLAINTEXT`, or `SASL_SSL`.
        """
        return pulumi.get(self, "security_protocol")

    @security_protocol.setter
    def security_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_protocol", value)

    @_builtins.property
    @pulumi.getter(name="sshTunnel")
    def ssh_tunnel(self) -> Optional[pulumi.Input['ConnectionKafkaSshTunnelArgs']]:
        """
        The default SSH tunnel configuration for the Kafka brokers.
        """
        return pulumi.get(self, "ssh_tunnel")

    @ssh_tunnel.setter
    def ssh_tunnel(self, value: Optional[pulumi.Input['ConnectionKafkaSshTunnelArgs']]):
        pulumi.set(self, "ssh_tunnel", value)

    @_builtins.property
    @pulumi.getter(name="sslCertificate")
    def ssl_certificate(self) -> Optional[pulumi.Input['ConnectionKafkaSslCertificateArgs']]:
        """
        The client certificate for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "ssl_certificate")

    @ssl_certificate.setter
    def ssl_certificate(self, value: Optional[pulumi.Input['ConnectionKafkaSslCertificateArgs']]):
        pulumi.set(self, "ssl_certificate", value)

    @_builtins.property
    @pulumi.getter(name="sslCertificateAuthority")
    def ssl_certificate_authority(self) -> Optional[pulumi.Input['ConnectionKafkaSslCertificateAuthorityArgs']]:
        """
        The CA certificate for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "ssl_certificate_authority")

    @ssl_certificate_authority.setter
    def ssl_certificate_authority(self, value: Optional[pulumi.Input['ConnectionKafkaSslCertificateAuthorityArgs']]):
        pulumi.set(self, "ssl_certificate_authority", value)

    @_builtins.property
    @pulumi.getter(name="sslKey")
    def ssl_key(self) -> Optional[pulumi.Input['ConnectionKafkaSslKeyArgs']]:
        """
        The client key for the Kafka broker.
        """
        return pulumi.get(self, "ssl_key")

    @ssl_key.setter
    def ssl_key(self, value: Optional[pulumi.Input['ConnectionKafkaSslKeyArgs']]):
        pulumi.set(self, "ssl_key", value)

    @_builtins.property
    @pulumi.getter
    def validate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If the connection should wait for validation.
        """
        return pulumi.get(self, "validate")

    @validate.setter
    def validate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "validate", value)


@pulumi.type_token("materialize:index/connectionKafka:ConnectionKafka")
class ConnectionKafka(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_connection: Optional[pulumi.Input[Union['ConnectionKafkaAwsConnectionArgs', 'ConnectionKafkaAwsConnectionArgsDict']]] = None,
                 aws_privatelink: Optional[pulumi.Input[Union['ConnectionKafkaAwsPrivatelinkArgs', 'ConnectionKafkaAwsPrivatelinkArgsDict']]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kafka_brokers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectionKafkaKafkaBrokerArgs', 'ConnectionKafkaKafkaBrokerArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 progress_topic: Optional[pulumi.Input[_builtins.str]] = None,
                 progress_topic_replication_factor: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sasl_mechanisms: Optional[pulumi.Input[_builtins.str]] = None,
                 sasl_password: Optional[pulumi.Input[Union['ConnectionKafkaSaslPasswordArgs', 'ConnectionKafkaSaslPasswordArgsDict']]] = None,
                 sasl_username: Optional[pulumi.Input[Union['ConnectionKafkaSaslUsernameArgs', 'ConnectionKafkaSaslUsernameArgsDict']]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_tunnel: Optional[pulumi.Input[Union['ConnectionKafkaSshTunnelArgs', 'ConnectionKafkaSshTunnelArgsDict']]] = None,
                 ssl_certificate: Optional[pulumi.Input[Union['ConnectionKafkaSslCertificateArgs', 'ConnectionKafkaSslCertificateArgsDict']]] = None,
                 ssl_certificate_authority: Optional[pulumi.Input[Union['ConnectionKafkaSslCertificateAuthorityArgs', 'ConnectionKafkaSslCertificateAuthorityArgsDict']]] = None,
                 ssl_key: Optional[pulumi.Input[Union['ConnectionKafkaSslKeyArgs', 'ConnectionKafkaSslKeyArgsDict']]] = None,
                 validate: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        A Kafka connection establishes a link to a Kafka cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        # Create a Kafka Connection
        example_kafka_connection = materialize.ConnectionKafka("exampleKafkaConnection",
            kafka_brokers=[{
                "broker": "b-1.hostname-1:9096",
            }],
            progress_topic="example",
            sasl_mechanisms="SCRAM-SHA-256",
            sasl_password={
                "database_name": "materialize",
                "name": "kafka_password",
                "schema_name": "public",
            },
            sasl_username={
                "text": "user",
            })
        example_kafka_connection_multiple_brokers = materialize.ConnectionKafka("exampleKafkaConnectionMultipleBrokers", kafka_brokers=[
            {
                "availability_zone": "use1-az1",
                "broker": "b-1.hostname-1:9096",
                "privatelink_connection": {
                    "database_name": "materialize",
                    "name": "example_aws_privatelink_conn",
                    "schema_name": "public",
                },
                "target_group_port": 9001,
            },
            {
                "availability_zone": "use1-az2",
                "broker": "b-2.hostname-2:9096",
                "privatelink_connection": {
                    "database_name": "materialize",
                    "name": "example_aws_privatelink_conn",
                    "schema_name": "public",
                },
                "target_group_port": 9002,
            },
        ])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Connections can be imported using the connection id:

        ```sh
        $ pulumi import materialize:index/connectionKafka:ConnectionKafka example <region>:<connection_id>
        ```

        Connection id and information be found in the `mz_catalog.mz_connections` table

        The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ConnectionKafkaAwsConnectionArgs', 'ConnectionKafkaAwsConnectionArgsDict']] aws_connection: The AWS connection to use for IAM authentication.
        :param pulumi.Input[Union['ConnectionKafkaAwsPrivatelinkArgs', 'ConnectionKafkaAwsPrivatelinkArgsDict']] aws_privatelink: AWS PrivateLink configuration. Conflicts with `kafka_broker`.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConnectionKafkaKafkaBrokerArgs', 'ConnectionKafkaKafkaBrokerArgsDict']]]] kafka_brokers: The Kafka broker's configuration.
        :param pulumi.Input[_builtins.str] name: The identifier for the connection.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input[_builtins.str] progress_topic: The name of a topic that Kafka sinks can use to track internal consistency metadata.
        :param pulumi.Input[_builtins.int] progress_topic_replication_factor: The replication factor to use when creating the Kafka progress topic (if the Kafka topic does not already exist).
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] sasl_mechanisms: The SASL mechanism for the Kafka broker.
        :param pulumi.Input[Union['ConnectionKafkaSaslPasswordArgs', 'ConnectionKafkaSaslPasswordArgsDict']] sasl_password: The SASL password for the Kafka broker.
        :param pulumi.Input[Union['ConnectionKafkaSaslUsernameArgs', 'ConnectionKafkaSaslUsernameArgsDict']] sasl_username: The SASL username for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the connection schema in Materialize. Defaults to `public`.
        :param pulumi.Input[_builtins.str] security_protocol: The security protocol to use: `PLAINTEXT`, `SSL`, `SASL_PLAINTEXT`, or `SASL_SSL`.
        :param pulumi.Input[Union['ConnectionKafkaSshTunnelArgs', 'ConnectionKafkaSshTunnelArgsDict']] ssh_tunnel: The default SSH tunnel configuration for the Kafka brokers.
        :param pulumi.Input[Union['ConnectionKafkaSslCertificateArgs', 'ConnectionKafkaSslCertificateArgsDict']] ssl_certificate: The client certificate for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[Union['ConnectionKafkaSslCertificateAuthorityArgs', 'ConnectionKafkaSslCertificateAuthorityArgsDict']] ssl_certificate_authority: The CA certificate for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[Union['ConnectionKafkaSslKeyArgs', 'ConnectionKafkaSslKeyArgsDict']] ssl_key: The client key for the Kafka broker.
        :param pulumi.Input[_builtins.bool] validate: If the connection should wait for validation.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ConnectionKafkaArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Kafka connection establishes a link to a Kafka cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        # Create a Kafka Connection
        example_kafka_connection = materialize.ConnectionKafka("exampleKafkaConnection",
            kafka_brokers=[{
                "broker": "b-1.hostname-1:9096",
            }],
            progress_topic="example",
            sasl_mechanisms="SCRAM-SHA-256",
            sasl_password={
                "database_name": "materialize",
                "name": "kafka_password",
                "schema_name": "public",
            },
            sasl_username={
                "text": "user",
            })
        example_kafka_connection_multiple_brokers = materialize.ConnectionKafka("exampleKafkaConnectionMultipleBrokers", kafka_brokers=[
            {
                "availability_zone": "use1-az1",
                "broker": "b-1.hostname-1:9096",
                "privatelink_connection": {
                    "database_name": "materialize",
                    "name": "example_aws_privatelink_conn",
                    "schema_name": "public",
                },
                "target_group_port": 9001,
            },
            {
                "availability_zone": "use1-az2",
                "broker": "b-2.hostname-2:9096",
                "privatelink_connection": {
                    "database_name": "materialize",
                    "name": "example_aws_privatelink_conn",
                    "schema_name": "public",
                },
                "target_group_port": 9002,
            },
        ])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Connections can be imported using the connection id:

        ```sh
        $ pulumi import materialize:index/connectionKafka:ConnectionKafka example <region>:<connection_id>
        ```

        Connection id and information be found in the `mz_catalog.mz_connections` table

        The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param ConnectionKafkaArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectionKafkaArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_connection: Optional[pulumi.Input[Union['ConnectionKafkaAwsConnectionArgs', 'ConnectionKafkaAwsConnectionArgsDict']]] = None,
                 aws_privatelink: Optional[pulumi.Input[Union['ConnectionKafkaAwsPrivatelinkArgs', 'ConnectionKafkaAwsPrivatelinkArgsDict']]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kafka_brokers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectionKafkaKafkaBrokerArgs', 'ConnectionKafkaKafkaBrokerArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 progress_topic: Optional[pulumi.Input[_builtins.str]] = None,
                 progress_topic_replication_factor: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sasl_mechanisms: Optional[pulumi.Input[_builtins.str]] = None,
                 sasl_password: Optional[pulumi.Input[Union['ConnectionKafkaSaslPasswordArgs', 'ConnectionKafkaSaslPasswordArgsDict']]] = None,
                 sasl_username: Optional[pulumi.Input[Union['ConnectionKafkaSaslUsernameArgs', 'ConnectionKafkaSaslUsernameArgsDict']]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_tunnel: Optional[pulumi.Input[Union['ConnectionKafkaSshTunnelArgs', 'ConnectionKafkaSshTunnelArgsDict']]] = None,
                 ssl_certificate: Optional[pulumi.Input[Union['ConnectionKafkaSslCertificateArgs', 'ConnectionKafkaSslCertificateArgsDict']]] = None,
                 ssl_certificate_authority: Optional[pulumi.Input[Union['ConnectionKafkaSslCertificateAuthorityArgs', 'ConnectionKafkaSslCertificateAuthorityArgsDict']]] = None,
                 ssl_key: Optional[pulumi.Input[Union['ConnectionKafkaSslKeyArgs', 'ConnectionKafkaSslKeyArgsDict']]] = None,
                 validate: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectionKafkaArgs.__new__(ConnectionKafkaArgs)

            __props__.__dict__["aws_connection"] = aws_connection
            __props__.__dict__["aws_privatelink"] = aws_privatelink
            __props__.__dict__["comment"] = comment
            __props__.__dict__["database_name"] = database_name
            __props__.__dict__["kafka_brokers"] = kafka_brokers
            __props__.__dict__["name"] = name
            __props__.__dict__["ownership_role"] = ownership_role
            __props__.__dict__["progress_topic"] = progress_topic
            __props__.__dict__["progress_topic_replication_factor"] = progress_topic_replication_factor
            __props__.__dict__["region"] = region
            __props__.__dict__["sasl_mechanisms"] = sasl_mechanisms
            __props__.__dict__["sasl_password"] = sasl_password
            __props__.__dict__["sasl_username"] = sasl_username
            __props__.__dict__["schema_name"] = schema_name
            __props__.__dict__["security_protocol"] = security_protocol
            __props__.__dict__["ssh_tunnel"] = ssh_tunnel
            __props__.__dict__["ssl_certificate"] = ssl_certificate
            __props__.__dict__["ssl_certificate_authority"] = ssl_certificate_authority
            __props__.__dict__["ssl_key"] = ssl_key
            __props__.__dict__["validate"] = validate
            __props__.__dict__["qualified_sql_name"] = None
        super(ConnectionKafka, __self__).__init__(
            'materialize:index/connectionKafka:ConnectionKafka',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws_connection: Optional[pulumi.Input[Union['ConnectionKafkaAwsConnectionArgs', 'ConnectionKafkaAwsConnectionArgsDict']]] = None,
            aws_privatelink: Optional[pulumi.Input[Union['ConnectionKafkaAwsPrivatelinkArgs', 'ConnectionKafkaAwsPrivatelinkArgsDict']]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            database_name: Optional[pulumi.Input[_builtins.str]] = None,
            kafka_brokers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectionKafkaKafkaBrokerArgs', 'ConnectionKafkaKafkaBrokerArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
            progress_topic: Optional[pulumi.Input[_builtins.str]] = None,
            progress_topic_replication_factor: Optional[pulumi.Input[_builtins.int]] = None,
            qualified_sql_name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            sasl_mechanisms: Optional[pulumi.Input[_builtins.str]] = None,
            sasl_password: Optional[pulumi.Input[Union['ConnectionKafkaSaslPasswordArgs', 'ConnectionKafkaSaslPasswordArgsDict']]] = None,
            sasl_username: Optional[pulumi.Input[Union['ConnectionKafkaSaslUsernameArgs', 'ConnectionKafkaSaslUsernameArgsDict']]] = None,
            schema_name: Optional[pulumi.Input[_builtins.str]] = None,
            security_protocol: Optional[pulumi.Input[_builtins.str]] = None,
            ssh_tunnel: Optional[pulumi.Input[Union['ConnectionKafkaSshTunnelArgs', 'ConnectionKafkaSshTunnelArgsDict']]] = None,
            ssl_certificate: Optional[pulumi.Input[Union['ConnectionKafkaSslCertificateArgs', 'ConnectionKafkaSslCertificateArgsDict']]] = None,
            ssl_certificate_authority: Optional[pulumi.Input[Union['ConnectionKafkaSslCertificateAuthorityArgs', 'ConnectionKafkaSslCertificateAuthorityArgsDict']]] = None,
            ssl_key: Optional[pulumi.Input[Union['ConnectionKafkaSslKeyArgs', 'ConnectionKafkaSslKeyArgsDict']]] = None,
            validate: Optional[pulumi.Input[_builtins.bool]] = None) -> 'ConnectionKafka':
        """
        Get an existing ConnectionKafka resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ConnectionKafkaAwsConnectionArgs', 'ConnectionKafkaAwsConnectionArgsDict']] aws_connection: The AWS connection to use for IAM authentication.
        :param pulumi.Input[Union['ConnectionKafkaAwsPrivatelinkArgs', 'ConnectionKafkaAwsPrivatelinkArgsDict']] aws_privatelink: AWS PrivateLink configuration. Conflicts with `kafka_broker`.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConnectionKafkaKafkaBrokerArgs', 'ConnectionKafkaKafkaBrokerArgsDict']]]] kafka_brokers: The Kafka broker's configuration.
        :param pulumi.Input[_builtins.str] name: The identifier for the connection.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input[_builtins.str] progress_topic: The name of a topic that Kafka sinks can use to track internal consistency metadata.
        :param pulumi.Input[_builtins.int] progress_topic_replication_factor: The replication factor to use when creating the Kafka progress topic (if the Kafka topic does not already exist).
        :param pulumi.Input[_builtins.str] qualified_sql_name: The fully qualified name of the connection.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] sasl_mechanisms: The SASL mechanism for the Kafka broker.
        :param pulumi.Input[Union['ConnectionKafkaSaslPasswordArgs', 'ConnectionKafkaSaslPasswordArgsDict']] sasl_password: The SASL password for the Kafka broker.
        :param pulumi.Input[Union['ConnectionKafkaSaslUsernameArgs', 'ConnectionKafkaSaslUsernameArgsDict']] sasl_username: The SASL username for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the connection schema in Materialize. Defaults to `public`.
        :param pulumi.Input[_builtins.str] security_protocol: The security protocol to use: `PLAINTEXT`, `SSL`, `SASL_PLAINTEXT`, or `SASL_SSL`.
        :param pulumi.Input[Union['ConnectionKafkaSshTunnelArgs', 'ConnectionKafkaSshTunnelArgsDict']] ssh_tunnel: The default SSH tunnel configuration for the Kafka brokers.
        :param pulumi.Input[Union['ConnectionKafkaSslCertificateArgs', 'ConnectionKafkaSslCertificateArgsDict']] ssl_certificate: The client certificate for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[Union['ConnectionKafkaSslCertificateAuthorityArgs', 'ConnectionKafkaSslCertificateAuthorityArgsDict']] ssl_certificate_authority: The CA certificate for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[Union['ConnectionKafkaSslKeyArgs', 'ConnectionKafkaSslKeyArgsDict']] ssl_key: The client key for the Kafka broker.
        :param pulumi.Input[_builtins.bool] validate: If the connection should wait for validation.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectionKafkaState.__new__(_ConnectionKafkaState)

        __props__.__dict__["aws_connection"] = aws_connection
        __props__.__dict__["aws_privatelink"] = aws_privatelink
        __props__.__dict__["comment"] = comment
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["kafka_brokers"] = kafka_brokers
        __props__.__dict__["name"] = name
        __props__.__dict__["ownership_role"] = ownership_role
        __props__.__dict__["progress_topic"] = progress_topic
        __props__.__dict__["progress_topic_replication_factor"] = progress_topic_replication_factor
        __props__.__dict__["qualified_sql_name"] = qualified_sql_name
        __props__.__dict__["region"] = region
        __props__.__dict__["sasl_mechanisms"] = sasl_mechanisms
        __props__.__dict__["sasl_password"] = sasl_password
        __props__.__dict__["sasl_username"] = sasl_username
        __props__.__dict__["schema_name"] = schema_name
        __props__.__dict__["security_protocol"] = security_protocol
        __props__.__dict__["ssh_tunnel"] = ssh_tunnel
        __props__.__dict__["ssl_certificate"] = ssl_certificate
        __props__.__dict__["ssl_certificate_authority"] = ssl_certificate_authority
        __props__.__dict__["ssl_key"] = ssl_key
        __props__.__dict__["validate"] = validate
        return ConnectionKafka(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="awsConnection")
    def aws_connection(self) -> pulumi.Output[Optional['outputs.ConnectionKafkaAwsConnection']]:
        """
        The AWS connection to use for IAM authentication.
        """
        return pulumi.get(self, "aws_connection")

    @_builtins.property
    @pulumi.getter(name="awsPrivatelink")
    def aws_privatelink(self) -> pulumi.Output[Optional['outputs.ConnectionKafkaAwsPrivatelink']]:
        """
        AWS PrivateLink configuration. Conflicts with `kafka_broker`.
        """
        return pulumi.get(self, "aws_privatelink")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @_builtins.property
    @pulumi.getter(name="kafkaBrokers")
    def kafka_brokers(self) -> pulumi.Output[Optional[Sequence['outputs.ConnectionKafkaKafkaBroker']]]:
        """
        The Kafka broker's configuration.
        """
        return pulumi.get(self, "kafka_brokers")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The identifier for the connection.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> pulumi.Output[_builtins.str]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @_builtins.property
    @pulumi.getter(name="progressTopic")
    def progress_topic(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of a topic that Kafka sinks can use to track internal consistency metadata.
        """
        return pulumi.get(self, "progress_topic")

    @_builtins.property
    @pulumi.getter(name="progressTopicReplicationFactor")
    def progress_topic_replication_factor(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The replication factor to use when creating the Kafka progress topic (if the Kafka topic does not already exist).
        """
        return pulumi.get(self, "progress_topic_replication_factor")

    @_builtins.property
    @pulumi.getter(name="qualifiedSqlName")
    def qualified_sql_name(self) -> pulumi.Output[_builtins.str]:
        """
        The fully qualified name of the connection.
        """
        return pulumi.get(self, "qualified_sql_name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="saslMechanisms")
    def sasl_mechanisms(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The SASL mechanism for the Kafka broker.
        """
        return pulumi.get(self, "sasl_mechanisms")

    @_builtins.property
    @pulumi.getter(name="saslPassword")
    def sasl_password(self) -> pulumi.Output[Optional['outputs.ConnectionKafkaSaslPassword']]:
        """
        The SASL password for the Kafka broker.
        """
        return pulumi.get(self, "sasl_password")

    @_builtins.property
    @pulumi.getter(name="saslUsername")
    def sasl_username(self) -> pulumi.Output[Optional['outputs.ConnectionKafkaSaslUsername']]:
        """
        The SASL username for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "sasl_username")

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The identifier for the connection schema in Materialize. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @_builtins.property
    @pulumi.getter(name="securityProtocol")
    def security_protocol(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The security protocol to use: `PLAINTEXT`, `SSL`, `SASL_PLAINTEXT`, or `SASL_SSL`.
        """
        return pulumi.get(self, "security_protocol")

    @_builtins.property
    @pulumi.getter(name="sshTunnel")
    def ssh_tunnel(self) -> pulumi.Output[Optional['outputs.ConnectionKafkaSshTunnel']]:
        """
        The default SSH tunnel configuration for the Kafka brokers.
        """
        return pulumi.get(self, "ssh_tunnel")

    @_builtins.property
    @pulumi.getter(name="sslCertificate")
    def ssl_certificate(self) -> pulumi.Output[Optional['outputs.ConnectionKafkaSslCertificate']]:
        """
        The client certificate for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "ssl_certificate")

    @_builtins.property
    @pulumi.getter(name="sslCertificateAuthority")
    def ssl_certificate_authority(self) -> pulumi.Output[Optional['outputs.ConnectionKafkaSslCertificateAuthority']]:
        """
        The CA certificate for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "ssl_certificate_authority")

    @_builtins.property
    @pulumi.getter(name="sslKey")
    def ssl_key(self) -> pulumi.Output[Optional['outputs.ConnectionKafkaSslKey']]:
        """
        The client key for the Kafka broker.
        """
        return pulumi.get(self, "ssl_key")

    @_builtins.property
    @pulumi.getter
    def validate(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If the connection should wait for validation.
        """
        return pulumi.get(self, "validate")

