# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConnectionMysqlArgs', 'ConnectionMysql']

@pulumi.input_type
class ConnectionMysqlArgs:
    def __init__(__self__, *,
                 host: pulumi.Input[_builtins.str],
                 user: pulumi.Input['ConnectionMysqlUserArgs'],
                 aws_privatelink: Optional[pulumi.Input['ConnectionMysqlAwsPrivatelinkArgs']] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input['ConnectionMysqlPasswordArgs']] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_tunnel: Optional[pulumi.Input['ConnectionMysqlSshTunnelArgs']] = None,
                 ssl_certificate: Optional[pulumi.Input['ConnectionMysqlSslCertificateArgs']] = None,
                 ssl_certificate_authority: Optional[pulumi.Input['ConnectionMysqlSslCertificateAuthorityArgs']] = None,
                 ssl_key: Optional[pulumi.Input['ConnectionMysqlSslKeyArgs']] = None,
                 ssl_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 validate: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ConnectionMysql resource.
        :param pulumi.Input[_builtins.str] host: The MySQL database hostname.
        :param pulumi.Input['ConnectionMysqlUserArgs'] user: The MySQL database username.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input['ConnectionMysqlAwsPrivatelinkArgs'] aws_privatelink: The AWS PrivateLink configuration for the MySQL database.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[_builtins.str] name: The identifier for the connection.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input['ConnectionMysqlPasswordArgs'] password: The MySQL database password.
        :param pulumi.Input[_builtins.int] port: The MySQL database port.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the connection schema in Materialize. Defaults to `public`.
        :param pulumi.Input['ConnectionMysqlSshTunnelArgs'] ssh_tunnel: The SSH tunnel configuration for the MySQL database.
        :param pulumi.Input['ConnectionMysqlSslCertificateArgs'] ssl_certificate: The client certificate for the MySQL database.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input['ConnectionMysqlSslCertificateAuthorityArgs'] ssl_certificate_authority: The CA certificate for the MySQL database.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input['ConnectionMysqlSslKeyArgs'] ssl_key: The client key for the MySQL database.
        :param pulumi.Input[_builtins.str] ssl_mode: The SSL mode for the MySQL database. Allowed values are disabled, required, verify-ca, verify-identity.
        :param pulumi.Input[_builtins.bool] validate: If the connection should wait for validation.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "user", user)
        if aws_privatelink is not None:
            pulumi.set(__self__, "aws_privatelink", aws_privatelink)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ownership_role is not None:
            pulumi.set(__self__, "ownership_role", ownership_role)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if ssh_tunnel is not None:
            pulumi.set(__self__, "ssh_tunnel", ssh_tunnel)
        if ssl_certificate is not None:
            pulumi.set(__self__, "ssl_certificate", ssl_certificate)
        if ssl_certificate_authority is not None:
            pulumi.set(__self__, "ssl_certificate_authority", ssl_certificate_authority)
        if ssl_key is not None:
            pulumi.set(__self__, "ssl_key", ssl_key)
        if ssl_mode is not None:
            pulumi.set(__self__, "ssl_mode", ssl_mode)
        if validate is not None:
            pulumi.set(__self__, "validate", validate)

    @_builtins.property
    @pulumi.getter
    def host(self) -> pulumi.Input[_builtins.str]:
        """
        The MySQL database hostname.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> pulumi.Input['ConnectionMysqlUserArgs']:
        """
        The MySQL database username.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: pulumi.Input['ConnectionMysqlUserArgs']):
        pulumi.set(self, "user", value)

    @_builtins.property
    @pulumi.getter(name="awsPrivatelink")
    def aws_privatelink(self) -> Optional[pulumi.Input['ConnectionMysqlAwsPrivatelinkArgs']]:
        """
        The AWS PrivateLink configuration for the MySQL database.
        """
        return pulumi.get(self, "aws_privatelink")

    @aws_privatelink.setter
    def aws_privatelink(self, value: Optional[pulumi.Input['ConnectionMysqlAwsPrivatelinkArgs']]):
        pulumi.set(self, "aws_privatelink", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the connection.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @ownership_role.setter
    def ownership_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ownership_role", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input['ConnectionMysqlPasswordArgs']]:
        """
        The MySQL database password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input['ConnectionMysqlPasswordArgs']]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The MySQL database port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the connection schema in Materialize. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema_name", value)

    @_builtins.property
    @pulumi.getter(name="sshTunnel")
    def ssh_tunnel(self) -> Optional[pulumi.Input['ConnectionMysqlSshTunnelArgs']]:
        """
        The SSH tunnel configuration for the MySQL database.
        """
        return pulumi.get(self, "ssh_tunnel")

    @ssh_tunnel.setter
    def ssh_tunnel(self, value: Optional[pulumi.Input['ConnectionMysqlSshTunnelArgs']]):
        pulumi.set(self, "ssh_tunnel", value)

    @_builtins.property
    @pulumi.getter(name="sslCertificate")
    def ssl_certificate(self) -> Optional[pulumi.Input['ConnectionMysqlSslCertificateArgs']]:
        """
        The client certificate for the MySQL database.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "ssl_certificate")

    @ssl_certificate.setter
    def ssl_certificate(self, value: Optional[pulumi.Input['ConnectionMysqlSslCertificateArgs']]):
        pulumi.set(self, "ssl_certificate", value)

    @_builtins.property
    @pulumi.getter(name="sslCertificateAuthority")
    def ssl_certificate_authority(self) -> Optional[pulumi.Input['ConnectionMysqlSslCertificateAuthorityArgs']]:
        """
        The CA certificate for the MySQL database.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "ssl_certificate_authority")

    @ssl_certificate_authority.setter
    def ssl_certificate_authority(self, value: Optional[pulumi.Input['ConnectionMysqlSslCertificateAuthorityArgs']]):
        pulumi.set(self, "ssl_certificate_authority", value)

    @_builtins.property
    @pulumi.getter(name="sslKey")
    def ssl_key(self) -> Optional[pulumi.Input['ConnectionMysqlSslKeyArgs']]:
        """
        The client key for the MySQL database.
        """
        return pulumi.get(self, "ssl_key")

    @ssl_key.setter
    def ssl_key(self, value: Optional[pulumi.Input['ConnectionMysqlSslKeyArgs']]):
        pulumi.set(self, "ssl_key", value)

    @_builtins.property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SSL mode for the MySQL database. Allowed values are disabled, required, verify-ca, verify-identity.
        """
        return pulumi.get(self, "ssl_mode")

    @ssl_mode.setter
    def ssl_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_mode", value)

    @_builtins.property
    @pulumi.getter
    def validate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If the connection should wait for validation.
        """
        return pulumi.get(self, "validate")

    @validate.setter
    def validate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "validate", value)


@pulumi.input_type
class _ConnectionMysqlState:
    def __init__(__self__, *,
                 aws_privatelink: Optional[pulumi.Input['ConnectionMysqlAwsPrivatelinkArgs']] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input['ConnectionMysqlPasswordArgs']] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 qualified_sql_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_tunnel: Optional[pulumi.Input['ConnectionMysqlSshTunnelArgs']] = None,
                 ssl_certificate: Optional[pulumi.Input['ConnectionMysqlSslCertificateArgs']] = None,
                 ssl_certificate_authority: Optional[pulumi.Input['ConnectionMysqlSslCertificateAuthorityArgs']] = None,
                 ssl_key: Optional[pulumi.Input['ConnectionMysqlSslKeyArgs']] = None,
                 ssl_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 user: Optional[pulumi.Input['ConnectionMysqlUserArgs']] = None,
                 validate: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ConnectionMysql resources.
        :param pulumi.Input['ConnectionMysqlAwsPrivatelinkArgs'] aws_privatelink: The AWS PrivateLink configuration for the MySQL database.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[_builtins.str] host: The MySQL database hostname.
        :param pulumi.Input[_builtins.str] name: The identifier for the connection.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input['ConnectionMysqlPasswordArgs'] password: The MySQL database password.
        :param pulumi.Input[_builtins.int] port: The MySQL database port.
        :param pulumi.Input[_builtins.str] qualified_sql_name: The fully qualified name of the connection.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the connection schema in Materialize. Defaults to `public`.
        :param pulumi.Input['ConnectionMysqlSshTunnelArgs'] ssh_tunnel: The SSH tunnel configuration for the MySQL database.
        :param pulumi.Input['ConnectionMysqlSslCertificateArgs'] ssl_certificate: The client certificate for the MySQL database.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input['ConnectionMysqlSslCertificateAuthorityArgs'] ssl_certificate_authority: The CA certificate for the MySQL database.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input['ConnectionMysqlSslKeyArgs'] ssl_key: The client key for the MySQL database.
        :param pulumi.Input[_builtins.str] ssl_mode: The SSL mode for the MySQL database. Allowed values are disabled, required, verify-ca, verify-identity.
        :param pulumi.Input['ConnectionMysqlUserArgs'] user: The MySQL database username.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[_builtins.bool] validate: If the connection should wait for validation.
        """
        if aws_privatelink is not None:
            pulumi.set(__self__, "aws_privatelink", aws_privatelink)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ownership_role is not None:
            pulumi.set(__self__, "ownership_role", ownership_role)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if qualified_sql_name is not None:
            pulumi.set(__self__, "qualified_sql_name", qualified_sql_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if ssh_tunnel is not None:
            pulumi.set(__self__, "ssh_tunnel", ssh_tunnel)
        if ssl_certificate is not None:
            pulumi.set(__self__, "ssl_certificate", ssl_certificate)
        if ssl_certificate_authority is not None:
            pulumi.set(__self__, "ssl_certificate_authority", ssl_certificate_authority)
        if ssl_key is not None:
            pulumi.set(__self__, "ssl_key", ssl_key)
        if ssl_mode is not None:
            pulumi.set(__self__, "ssl_mode", ssl_mode)
        if user is not None:
            pulumi.set(__self__, "user", user)
        if validate is not None:
            pulumi.set(__self__, "validate", validate)

    @_builtins.property
    @pulumi.getter(name="awsPrivatelink")
    def aws_privatelink(self) -> Optional[pulumi.Input['ConnectionMysqlAwsPrivatelinkArgs']]:
        """
        The AWS PrivateLink configuration for the MySQL database.
        """
        return pulumi.get(self, "aws_privatelink")

    @aws_privatelink.setter
    def aws_privatelink(self, value: Optional[pulumi.Input['ConnectionMysqlAwsPrivatelinkArgs']]):
        pulumi.set(self, "aws_privatelink", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The MySQL database hostname.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the connection.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @ownership_role.setter
    def ownership_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ownership_role", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input['ConnectionMysqlPasswordArgs']]:
        """
        The MySQL database password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input['ConnectionMysqlPasswordArgs']]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The MySQL database port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="qualifiedSqlName")
    def qualified_sql_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified name of the connection.
        """
        return pulumi.get(self, "qualified_sql_name")

    @qualified_sql_name.setter
    def qualified_sql_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "qualified_sql_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the connection schema in Materialize. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema_name", value)

    @_builtins.property
    @pulumi.getter(name="sshTunnel")
    def ssh_tunnel(self) -> Optional[pulumi.Input['ConnectionMysqlSshTunnelArgs']]:
        """
        The SSH tunnel configuration for the MySQL database.
        """
        return pulumi.get(self, "ssh_tunnel")

    @ssh_tunnel.setter
    def ssh_tunnel(self, value: Optional[pulumi.Input['ConnectionMysqlSshTunnelArgs']]):
        pulumi.set(self, "ssh_tunnel", value)

    @_builtins.property
    @pulumi.getter(name="sslCertificate")
    def ssl_certificate(self) -> Optional[pulumi.Input['ConnectionMysqlSslCertificateArgs']]:
        """
        The client certificate for the MySQL database.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "ssl_certificate")

    @ssl_certificate.setter
    def ssl_certificate(self, value: Optional[pulumi.Input['ConnectionMysqlSslCertificateArgs']]):
        pulumi.set(self, "ssl_certificate", value)

    @_builtins.property
    @pulumi.getter(name="sslCertificateAuthority")
    def ssl_certificate_authority(self) -> Optional[pulumi.Input['ConnectionMysqlSslCertificateAuthorityArgs']]:
        """
        The CA certificate for the MySQL database.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "ssl_certificate_authority")

    @ssl_certificate_authority.setter
    def ssl_certificate_authority(self, value: Optional[pulumi.Input['ConnectionMysqlSslCertificateAuthorityArgs']]):
        pulumi.set(self, "ssl_certificate_authority", value)

    @_builtins.property
    @pulumi.getter(name="sslKey")
    def ssl_key(self) -> Optional[pulumi.Input['ConnectionMysqlSslKeyArgs']]:
        """
        The client key for the MySQL database.
        """
        return pulumi.get(self, "ssl_key")

    @ssl_key.setter
    def ssl_key(self, value: Optional[pulumi.Input['ConnectionMysqlSslKeyArgs']]):
        pulumi.set(self, "ssl_key", value)

    @_builtins.property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SSL mode for the MySQL database. Allowed values are disabled, required, verify-ca, verify-identity.
        """
        return pulumi.get(self, "ssl_mode")

    @ssl_mode.setter
    def ssl_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_mode", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input['ConnectionMysqlUserArgs']]:
        """
        The MySQL database username.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input['ConnectionMysqlUserArgs']]):
        pulumi.set(self, "user", value)

    @_builtins.property
    @pulumi.getter
    def validate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If the connection should wait for validation.
        """
        return pulumi.get(self, "validate")

    @validate.setter
    def validate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "validate", value)


@pulumi.type_token("materialize:index/connectionMysql:ConnectionMysql")
class ConnectionMysql(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_privatelink: Optional[pulumi.Input[Union['ConnectionMysqlAwsPrivatelinkArgs', 'ConnectionMysqlAwsPrivatelinkArgsDict']]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[Union['ConnectionMysqlPasswordArgs', 'ConnectionMysqlPasswordArgsDict']]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_tunnel: Optional[pulumi.Input[Union['ConnectionMysqlSshTunnelArgs', 'ConnectionMysqlSshTunnelArgsDict']]] = None,
                 ssl_certificate: Optional[pulumi.Input[Union['ConnectionMysqlSslCertificateArgs', 'ConnectionMysqlSslCertificateArgsDict']]] = None,
                 ssl_certificate_authority: Optional[pulumi.Input[Union['ConnectionMysqlSslCertificateAuthorityArgs', 'ConnectionMysqlSslCertificateAuthorityArgsDict']]] = None,
                 ssl_key: Optional[pulumi.Input[Union['ConnectionMysqlSslKeyArgs', 'ConnectionMysqlSslKeyArgsDict']]] = None,
                 ssl_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 user: Optional[pulumi.Input[Union['ConnectionMysqlUserArgs', 'ConnectionMysqlUserArgsDict']]] = None,
                 validate: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        A MySQL connection establishes a link to a single database of a MySQL server.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        # Create a MySQL Connection with SSH tunnel & plain text user
        example_mysql_connection = materialize.ConnectionMysql("exampleMysqlConnection",
            host="instance.foo000.us-west-1.rds.amazonaws.com",
            password={
                "database_name": "database",
                "name": "example",
                "schema_name": "schema",
            },
            port=3306,
            ssh_tunnel={
                "name": "example",
            },
            user={
                "text": "my_user",
            })
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Connections can be imported using the connection id:

        ```sh
        $ pulumi import materialize:index/connectionMysql:ConnectionMysql example <region>:<connection_id>
        ```

        Connection id and information be found in the `mz_catalog.mz_connections` table

        The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ConnectionMysqlAwsPrivatelinkArgs', 'ConnectionMysqlAwsPrivatelinkArgsDict']] aws_privatelink: The AWS PrivateLink configuration for the MySQL database.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[_builtins.str] host: The MySQL database hostname.
        :param pulumi.Input[_builtins.str] name: The identifier for the connection.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input[Union['ConnectionMysqlPasswordArgs', 'ConnectionMysqlPasswordArgsDict']] password: The MySQL database password.
        :param pulumi.Input[_builtins.int] port: The MySQL database port.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the connection schema in Materialize. Defaults to `public`.
        :param pulumi.Input[Union['ConnectionMysqlSshTunnelArgs', 'ConnectionMysqlSshTunnelArgsDict']] ssh_tunnel: The SSH tunnel configuration for the MySQL database.
        :param pulumi.Input[Union['ConnectionMysqlSslCertificateArgs', 'ConnectionMysqlSslCertificateArgsDict']] ssl_certificate: The client certificate for the MySQL database.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[Union['ConnectionMysqlSslCertificateAuthorityArgs', 'ConnectionMysqlSslCertificateAuthorityArgsDict']] ssl_certificate_authority: The CA certificate for the MySQL database.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[Union['ConnectionMysqlSslKeyArgs', 'ConnectionMysqlSslKeyArgsDict']] ssl_key: The client key for the MySQL database.
        :param pulumi.Input[_builtins.str] ssl_mode: The SSL mode for the MySQL database. Allowed values are disabled, required, verify-ca, verify-identity.
        :param pulumi.Input[Union['ConnectionMysqlUserArgs', 'ConnectionMysqlUserArgsDict']] user: The MySQL database username.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[_builtins.bool] validate: If the connection should wait for validation.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectionMysqlArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A MySQL connection establishes a link to a single database of a MySQL server.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        # Create a MySQL Connection with SSH tunnel & plain text user
        example_mysql_connection = materialize.ConnectionMysql("exampleMysqlConnection",
            host="instance.foo000.us-west-1.rds.amazonaws.com",
            password={
                "database_name": "database",
                "name": "example",
                "schema_name": "schema",
            },
            port=3306,
            ssh_tunnel={
                "name": "example",
            },
            user={
                "text": "my_user",
            })
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Connections can be imported using the connection id:

        ```sh
        $ pulumi import materialize:index/connectionMysql:ConnectionMysql example <region>:<connection_id>
        ```

        Connection id and information be found in the `mz_catalog.mz_connections` table

        The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param ConnectionMysqlArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectionMysqlArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_privatelink: Optional[pulumi.Input[Union['ConnectionMysqlAwsPrivatelinkArgs', 'ConnectionMysqlAwsPrivatelinkArgsDict']]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[Union['ConnectionMysqlPasswordArgs', 'ConnectionMysqlPasswordArgsDict']]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_tunnel: Optional[pulumi.Input[Union['ConnectionMysqlSshTunnelArgs', 'ConnectionMysqlSshTunnelArgsDict']]] = None,
                 ssl_certificate: Optional[pulumi.Input[Union['ConnectionMysqlSslCertificateArgs', 'ConnectionMysqlSslCertificateArgsDict']]] = None,
                 ssl_certificate_authority: Optional[pulumi.Input[Union['ConnectionMysqlSslCertificateAuthorityArgs', 'ConnectionMysqlSslCertificateAuthorityArgsDict']]] = None,
                 ssl_key: Optional[pulumi.Input[Union['ConnectionMysqlSslKeyArgs', 'ConnectionMysqlSslKeyArgsDict']]] = None,
                 ssl_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 user: Optional[pulumi.Input[Union['ConnectionMysqlUserArgs', 'ConnectionMysqlUserArgsDict']]] = None,
                 validate: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectionMysqlArgs.__new__(ConnectionMysqlArgs)

            __props__.__dict__["aws_privatelink"] = aws_privatelink
            __props__.__dict__["comment"] = comment
            __props__.__dict__["database_name"] = database_name
            if host is None and not opts.urn:
                raise TypeError("Missing required property 'host'")
            __props__.__dict__["host"] = host
            __props__.__dict__["name"] = name
            __props__.__dict__["ownership_role"] = ownership_role
            __props__.__dict__["password"] = password
            __props__.__dict__["port"] = port
            __props__.__dict__["region"] = region
            __props__.__dict__["schema_name"] = schema_name
            __props__.__dict__["ssh_tunnel"] = ssh_tunnel
            __props__.__dict__["ssl_certificate"] = ssl_certificate
            __props__.__dict__["ssl_certificate_authority"] = ssl_certificate_authority
            __props__.__dict__["ssl_key"] = ssl_key
            __props__.__dict__["ssl_mode"] = ssl_mode
            if user is None and not opts.urn:
                raise TypeError("Missing required property 'user'")
            __props__.__dict__["user"] = user
            __props__.__dict__["validate"] = validate
            __props__.__dict__["qualified_sql_name"] = None
        super(ConnectionMysql, __self__).__init__(
            'materialize:index/connectionMysql:ConnectionMysql',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws_privatelink: Optional[pulumi.Input[Union['ConnectionMysqlAwsPrivatelinkArgs', 'ConnectionMysqlAwsPrivatelinkArgsDict']]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            database_name: Optional[pulumi.Input[_builtins.str]] = None,
            host: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[Union['ConnectionMysqlPasswordArgs', 'ConnectionMysqlPasswordArgsDict']]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            qualified_sql_name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            schema_name: Optional[pulumi.Input[_builtins.str]] = None,
            ssh_tunnel: Optional[pulumi.Input[Union['ConnectionMysqlSshTunnelArgs', 'ConnectionMysqlSshTunnelArgsDict']]] = None,
            ssl_certificate: Optional[pulumi.Input[Union['ConnectionMysqlSslCertificateArgs', 'ConnectionMysqlSslCertificateArgsDict']]] = None,
            ssl_certificate_authority: Optional[pulumi.Input[Union['ConnectionMysqlSslCertificateAuthorityArgs', 'ConnectionMysqlSslCertificateAuthorityArgsDict']]] = None,
            ssl_key: Optional[pulumi.Input[Union['ConnectionMysqlSslKeyArgs', 'ConnectionMysqlSslKeyArgsDict']]] = None,
            ssl_mode: Optional[pulumi.Input[_builtins.str]] = None,
            user: Optional[pulumi.Input[Union['ConnectionMysqlUserArgs', 'ConnectionMysqlUserArgsDict']]] = None,
            validate: Optional[pulumi.Input[_builtins.bool]] = None) -> 'ConnectionMysql':
        """
        Get an existing ConnectionMysql resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ConnectionMysqlAwsPrivatelinkArgs', 'ConnectionMysqlAwsPrivatelinkArgsDict']] aws_privatelink: The AWS PrivateLink configuration for the MySQL database.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[_builtins.str] host: The MySQL database hostname.
        :param pulumi.Input[_builtins.str] name: The identifier for the connection.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input[Union['ConnectionMysqlPasswordArgs', 'ConnectionMysqlPasswordArgsDict']] password: The MySQL database password.
        :param pulumi.Input[_builtins.int] port: The MySQL database port.
        :param pulumi.Input[_builtins.str] qualified_sql_name: The fully qualified name of the connection.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the connection schema in Materialize. Defaults to `public`.
        :param pulumi.Input[Union['ConnectionMysqlSshTunnelArgs', 'ConnectionMysqlSshTunnelArgsDict']] ssh_tunnel: The SSH tunnel configuration for the MySQL database.
        :param pulumi.Input[Union['ConnectionMysqlSslCertificateArgs', 'ConnectionMysqlSslCertificateArgsDict']] ssl_certificate: The client certificate for the MySQL database.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[Union['ConnectionMysqlSslCertificateAuthorityArgs', 'ConnectionMysqlSslCertificateAuthorityArgsDict']] ssl_certificate_authority: The CA certificate for the MySQL database.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[Union['ConnectionMysqlSslKeyArgs', 'ConnectionMysqlSslKeyArgsDict']] ssl_key: The client key for the MySQL database.
        :param pulumi.Input[_builtins.str] ssl_mode: The SSL mode for the MySQL database. Allowed values are disabled, required, verify-ca, verify-identity.
        :param pulumi.Input[Union['ConnectionMysqlUserArgs', 'ConnectionMysqlUserArgsDict']] user: The MySQL database username.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[_builtins.bool] validate: If the connection should wait for validation.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectionMysqlState.__new__(_ConnectionMysqlState)

        __props__.__dict__["aws_privatelink"] = aws_privatelink
        __props__.__dict__["comment"] = comment
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["host"] = host
        __props__.__dict__["name"] = name
        __props__.__dict__["ownership_role"] = ownership_role
        __props__.__dict__["password"] = password
        __props__.__dict__["port"] = port
        __props__.__dict__["qualified_sql_name"] = qualified_sql_name
        __props__.__dict__["region"] = region
        __props__.__dict__["schema_name"] = schema_name
        __props__.__dict__["ssh_tunnel"] = ssh_tunnel
        __props__.__dict__["ssl_certificate"] = ssl_certificate
        __props__.__dict__["ssl_certificate_authority"] = ssl_certificate_authority
        __props__.__dict__["ssl_key"] = ssl_key
        __props__.__dict__["ssl_mode"] = ssl_mode
        __props__.__dict__["user"] = user
        __props__.__dict__["validate"] = validate
        return ConnectionMysql(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="awsPrivatelink")
    def aws_privatelink(self) -> pulumi.Output[Optional['outputs.ConnectionMysqlAwsPrivatelink']]:
        """
        The AWS PrivateLink configuration for the MySQL database.
        """
        return pulumi.get(self, "aws_privatelink")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @_builtins.property
    @pulumi.getter
    def host(self) -> pulumi.Output[_builtins.str]:
        """
        The MySQL database hostname.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The identifier for the connection.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> pulumi.Output[_builtins.str]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional['outputs.ConnectionMysqlPassword']]:
        """
        The MySQL database password.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The MySQL database port.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="qualifiedSqlName")
    def qualified_sql_name(self) -> pulumi.Output[_builtins.str]:
        """
        The fully qualified name of the connection.
        """
        return pulumi.get(self, "qualified_sql_name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The identifier for the connection schema in Materialize. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @_builtins.property
    @pulumi.getter(name="sshTunnel")
    def ssh_tunnel(self) -> pulumi.Output[Optional['outputs.ConnectionMysqlSshTunnel']]:
        """
        The SSH tunnel configuration for the MySQL database.
        """
        return pulumi.get(self, "ssh_tunnel")

    @_builtins.property
    @pulumi.getter(name="sslCertificate")
    def ssl_certificate(self) -> pulumi.Output[Optional['outputs.ConnectionMysqlSslCertificate']]:
        """
        The client certificate for the MySQL database.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "ssl_certificate")

    @_builtins.property
    @pulumi.getter(name="sslCertificateAuthority")
    def ssl_certificate_authority(self) -> pulumi.Output[Optional['outputs.ConnectionMysqlSslCertificateAuthority']]:
        """
        The CA certificate for the MySQL database.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "ssl_certificate_authority")

    @_builtins.property
    @pulumi.getter(name="sslKey")
    def ssl_key(self) -> pulumi.Output[Optional['outputs.ConnectionMysqlSslKey']]:
        """
        The client key for the MySQL database.
        """
        return pulumi.get(self, "ssl_key")

    @_builtins.property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The SSL mode for the MySQL database. Allowed values are disabled, required, verify-ca, verify-identity.
        """
        return pulumi.get(self, "ssl_mode")

    @_builtins.property
    @pulumi.getter
    def user(self) -> pulumi.Output['outputs.ConnectionMysqlUser']:
        """
        The MySQL database username.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "user")

    @_builtins.property
    @pulumi.getter
    def validate(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If the connection should wait for validation.
        """
        return pulumi.get(self, "validate")

