# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConnectionSqlserverArgs', 'ConnectionSqlserver']

@pulumi.input_type
class ConnectionSqlserverArgs:
    def __init__(__self__, *,
                 database: pulumi.Input[_builtins.str],
                 host: pulumi.Input[_builtins.str],
                 user: pulumi.Input['ConnectionSqlserverUserArgs'],
                 aws_privatelink: Optional[pulumi.Input['ConnectionSqlserverAwsPrivatelinkArgs']] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input['ConnectionSqlserverPasswordArgs']] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_tunnel: Optional[pulumi.Input['ConnectionSqlserverSshTunnelArgs']] = None,
                 ssl_certificate_authority: Optional[pulumi.Input['ConnectionSqlserverSslCertificateAuthorityArgs']] = None,
                 ssl_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 validate: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ConnectionSqlserver resource.
        :param pulumi.Input[_builtins.str] database: The target SQL Server database.
        :param pulumi.Input[_builtins.str] host: The SQL Server database hostname.
        :param pulumi.Input['ConnectionSqlserverUserArgs'] user: The SQL Server database username.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input['ConnectionSqlserverAwsPrivatelinkArgs'] aws_privatelink: The AWS PrivateLink configuration for the SQL Server database.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[_builtins.str] name: The identifier for the connection.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input['ConnectionSqlserverPasswordArgs'] password: The SQL Server database password.
        :param pulumi.Input[_builtins.int] port: The SQL Server database port.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the connection schema in Materialize. Defaults to `public`.
        :param pulumi.Input['ConnectionSqlserverSshTunnelArgs'] ssh_tunnel: The SSH tunnel configuration for the SQL Server database.
        :param pulumi.Input['ConnectionSqlserverSslCertificateAuthorityArgs'] ssl_certificate_authority: The CA certificate for the SQL Server database.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[_builtins.str] ssl_mode: The SSL mode for the SQL Server database. Allowed values are disabled, required, verify, verify-ca.
        :param pulumi.Input[_builtins.bool] validate: If the connection should wait for validation.
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "user", user)
        if aws_privatelink is not None:
            pulumi.set(__self__, "aws_privatelink", aws_privatelink)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ownership_role is not None:
            pulumi.set(__self__, "ownership_role", ownership_role)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if ssh_tunnel is not None:
            pulumi.set(__self__, "ssh_tunnel", ssh_tunnel)
        if ssl_certificate_authority is not None:
            pulumi.set(__self__, "ssl_certificate_authority", ssl_certificate_authority)
        if ssl_mode is not None:
            pulumi.set(__self__, "ssl_mode", ssl_mode)
        if validate is not None:
            pulumi.set(__self__, "validate", validate)

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Input[_builtins.str]:
        """
        The target SQL Server database.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> pulumi.Input[_builtins.str]:
        """
        The SQL Server database hostname.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> pulumi.Input['ConnectionSqlserverUserArgs']:
        """
        The SQL Server database username.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: pulumi.Input['ConnectionSqlserverUserArgs']):
        pulumi.set(self, "user", value)

    @_builtins.property
    @pulumi.getter(name="awsPrivatelink")
    def aws_privatelink(self) -> Optional[pulumi.Input['ConnectionSqlserverAwsPrivatelinkArgs']]:
        """
        The AWS PrivateLink configuration for the SQL Server database.
        """
        return pulumi.get(self, "aws_privatelink")

    @aws_privatelink.setter
    def aws_privatelink(self, value: Optional[pulumi.Input['ConnectionSqlserverAwsPrivatelinkArgs']]):
        pulumi.set(self, "aws_privatelink", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the connection.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @ownership_role.setter
    def ownership_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ownership_role", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input['ConnectionSqlserverPasswordArgs']]:
        """
        The SQL Server database password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input['ConnectionSqlserverPasswordArgs']]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The SQL Server database port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the connection schema in Materialize. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema_name", value)

    @_builtins.property
    @pulumi.getter(name="sshTunnel")
    def ssh_tunnel(self) -> Optional[pulumi.Input['ConnectionSqlserverSshTunnelArgs']]:
        """
        The SSH tunnel configuration for the SQL Server database.
        """
        return pulumi.get(self, "ssh_tunnel")

    @ssh_tunnel.setter
    def ssh_tunnel(self, value: Optional[pulumi.Input['ConnectionSqlserverSshTunnelArgs']]):
        pulumi.set(self, "ssh_tunnel", value)

    @_builtins.property
    @pulumi.getter(name="sslCertificateAuthority")
    def ssl_certificate_authority(self) -> Optional[pulumi.Input['ConnectionSqlserverSslCertificateAuthorityArgs']]:
        """
        The CA certificate for the SQL Server database.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "ssl_certificate_authority")

    @ssl_certificate_authority.setter
    def ssl_certificate_authority(self, value: Optional[pulumi.Input['ConnectionSqlserverSslCertificateAuthorityArgs']]):
        pulumi.set(self, "ssl_certificate_authority", value)

    @_builtins.property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SSL mode for the SQL Server database. Allowed values are disabled, required, verify, verify-ca.
        """
        return pulumi.get(self, "ssl_mode")

    @ssl_mode.setter
    def ssl_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_mode", value)

    @_builtins.property
    @pulumi.getter
    def validate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If the connection should wait for validation.
        """
        return pulumi.get(self, "validate")

    @validate.setter
    def validate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "validate", value)


@pulumi.input_type
class _ConnectionSqlserverState:
    def __init__(__self__, *,
                 aws_privatelink: Optional[pulumi.Input['ConnectionSqlserverAwsPrivatelinkArgs']] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input['ConnectionSqlserverPasswordArgs']] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 qualified_sql_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_tunnel: Optional[pulumi.Input['ConnectionSqlserverSshTunnelArgs']] = None,
                 ssl_certificate_authority: Optional[pulumi.Input['ConnectionSqlserverSslCertificateAuthorityArgs']] = None,
                 ssl_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 user: Optional[pulumi.Input['ConnectionSqlserverUserArgs']] = None,
                 validate: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ConnectionSqlserver resources.
        :param pulumi.Input['ConnectionSqlserverAwsPrivatelinkArgs'] aws_privatelink: The AWS PrivateLink configuration for the SQL Server database.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database: The target SQL Server database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[_builtins.str] host: The SQL Server database hostname.
        :param pulumi.Input[_builtins.str] name: The identifier for the connection.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input['ConnectionSqlserverPasswordArgs'] password: The SQL Server database password.
        :param pulumi.Input[_builtins.int] port: The SQL Server database port.
        :param pulumi.Input[_builtins.str] qualified_sql_name: The fully qualified name of the connection.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the connection schema in Materialize. Defaults to `public`.
        :param pulumi.Input['ConnectionSqlserverSshTunnelArgs'] ssh_tunnel: The SSH tunnel configuration for the SQL Server database.
        :param pulumi.Input['ConnectionSqlserverSslCertificateAuthorityArgs'] ssl_certificate_authority: The CA certificate for the SQL Server database.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[_builtins.str] ssl_mode: The SSL mode for the SQL Server database. Allowed values are disabled, required, verify, verify-ca.
        :param pulumi.Input['ConnectionSqlserverUserArgs'] user: The SQL Server database username.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[_builtins.bool] validate: If the connection should wait for validation.
        """
        if aws_privatelink is not None:
            pulumi.set(__self__, "aws_privatelink", aws_privatelink)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ownership_role is not None:
            pulumi.set(__self__, "ownership_role", ownership_role)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if qualified_sql_name is not None:
            pulumi.set(__self__, "qualified_sql_name", qualified_sql_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if ssh_tunnel is not None:
            pulumi.set(__self__, "ssh_tunnel", ssh_tunnel)
        if ssl_certificate_authority is not None:
            pulumi.set(__self__, "ssl_certificate_authority", ssl_certificate_authority)
        if ssl_mode is not None:
            pulumi.set(__self__, "ssl_mode", ssl_mode)
        if user is not None:
            pulumi.set(__self__, "user", user)
        if validate is not None:
            pulumi.set(__self__, "validate", validate)

    @_builtins.property
    @pulumi.getter(name="awsPrivatelink")
    def aws_privatelink(self) -> Optional[pulumi.Input['ConnectionSqlserverAwsPrivatelinkArgs']]:
        """
        The AWS PrivateLink configuration for the SQL Server database.
        """
        return pulumi.get(self, "aws_privatelink")

    @aws_privatelink.setter
    def aws_privatelink(self, value: Optional[pulumi.Input['ConnectionSqlserverAwsPrivatelinkArgs']]):
        pulumi.set(self, "aws_privatelink", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The target SQL Server database.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SQL Server database hostname.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the connection.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @ownership_role.setter
    def ownership_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ownership_role", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input['ConnectionSqlserverPasswordArgs']]:
        """
        The SQL Server database password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input['ConnectionSqlserverPasswordArgs']]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The SQL Server database port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="qualifiedSqlName")
    def qualified_sql_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified name of the connection.
        """
        return pulumi.get(self, "qualified_sql_name")

    @qualified_sql_name.setter
    def qualified_sql_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "qualified_sql_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the connection schema in Materialize. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema_name", value)

    @_builtins.property
    @pulumi.getter(name="sshTunnel")
    def ssh_tunnel(self) -> Optional[pulumi.Input['ConnectionSqlserverSshTunnelArgs']]:
        """
        The SSH tunnel configuration for the SQL Server database.
        """
        return pulumi.get(self, "ssh_tunnel")

    @ssh_tunnel.setter
    def ssh_tunnel(self, value: Optional[pulumi.Input['ConnectionSqlserverSshTunnelArgs']]):
        pulumi.set(self, "ssh_tunnel", value)

    @_builtins.property
    @pulumi.getter(name="sslCertificateAuthority")
    def ssl_certificate_authority(self) -> Optional[pulumi.Input['ConnectionSqlserverSslCertificateAuthorityArgs']]:
        """
        The CA certificate for the SQL Server database.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "ssl_certificate_authority")

    @ssl_certificate_authority.setter
    def ssl_certificate_authority(self, value: Optional[pulumi.Input['ConnectionSqlserverSslCertificateAuthorityArgs']]):
        pulumi.set(self, "ssl_certificate_authority", value)

    @_builtins.property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SSL mode for the SQL Server database. Allowed values are disabled, required, verify, verify-ca.
        """
        return pulumi.get(self, "ssl_mode")

    @ssl_mode.setter
    def ssl_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_mode", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input['ConnectionSqlserverUserArgs']]:
        """
        The SQL Server database username.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input['ConnectionSqlserverUserArgs']]):
        pulumi.set(self, "user", value)

    @_builtins.property
    @pulumi.getter
    def validate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If the connection should wait for validation.
        """
        return pulumi.get(self, "validate")

    @validate.setter
    def validate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "validate", value)


@pulumi.type_token("materialize:index/connectionSqlserver:ConnectionSqlserver")
class ConnectionSqlserver(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_privatelink: Optional[pulumi.Input[Union['ConnectionSqlserverAwsPrivatelinkArgs', 'ConnectionSqlserverAwsPrivatelinkArgsDict']]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[Union['ConnectionSqlserverPasswordArgs', 'ConnectionSqlserverPasswordArgsDict']]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_tunnel: Optional[pulumi.Input[Union['ConnectionSqlserverSshTunnelArgs', 'ConnectionSqlserverSshTunnelArgsDict']]] = None,
                 ssl_certificate_authority: Optional[pulumi.Input[Union['ConnectionSqlserverSslCertificateAuthorityArgs', 'ConnectionSqlserverSslCertificateAuthorityArgsDict']]] = None,
                 ssl_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 user: Optional[pulumi.Input[Union['ConnectionSqlserverUserArgs', 'ConnectionSqlserverUserArgsDict']]] = None,
                 validate: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        A SQL Server connection establishes a link to a single database of a SQL Server instance.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        sqlserver_password = materialize.Secret("sqlserverPassword",
            value="some-secret-value",
            comment="secret comment")
        # Basic SQL Server connection
        basic = materialize.ConnectionSqlserver("basic",
            host="sql-server.example.com",
            port=1433,
            user={
                "text": "sqluser",
            },
            password={
                "name": sqlserver_password.name,
                "schema_name": sqlserver_password.schema_name,
                "database_name": sqlserver_password.database_name,
            },
            database="testdb",
            validate=True)
        # SQL Server connection with SSH tunnel
        example_ssh_connection = materialize.ConnectionSshTunnel("exampleSshConnection",
            host="bastion-host.example.com",
            port=22,
            user="ubuntu")
        ssh_example = materialize.ConnectionSqlserver("sshExample",
            host="private-sql-server.example.com",
            port=1433,
            user={
                "text": "sqluser",
            },
            password={
                "name": sqlserver_password.name,
                "schema_name": sqlserver_password.schema_name,
                "database_name": sqlserver_password.database_name,
            },
            database="testdb",
            ssh_tunnel={
                "name": example_ssh_connection.name,
            },
            validate=False)
        # SQL Server connection with AWS PrivateLink
        sqlserver_privatelink = materialize.ConnectionAwsPrivatelink("sqlserverPrivatelink",
            service_name="com.amazonaws.vpce.us-east-1.vpce-svc-0e123abc123198abc",
            availability_zones=[
                "use1-az1",
                "use1-az4",
            ])
        privatelink_example = materialize.ConnectionSqlserver("privatelinkExample",
            host="sqlserver.example.com",
            port=1433,
            user={
                "text": "sqluser",
            },
            password={
                "name": sqlserver_password.name,
                "schema_name": sqlserver_password.schema_name,
                "database_name": sqlserver_password.database_name,
            },
            database="testdb",
            aws_privatelink={
                "name": sqlserver_privatelink.name,
            },
            validate=False)
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        #!/bin/bash

        SQL Server connections can be imported using the connection name

        ```sh
        $ pulumi import materialize:index/connectionSqlserver:ConnectionSqlserver example <region>:<connection_name>
        ```

        Example

        ```sh
        $ pulumi import materialize:index/connectionSqlserver:ConnectionSqlserver example aws/us-east-1:my_sqlserver_connection
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ConnectionSqlserverAwsPrivatelinkArgs', 'ConnectionSqlserverAwsPrivatelinkArgsDict']] aws_privatelink: The AWS PrivateLink configuration for the SQL Server database.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database: The target SQL Server database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[_builtins.str] host: The SQL Server database hostname.
        :param pulumi.Input[_builtins.str] name: The identifier for the connection.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input[Union['ConnectionSqlserverPasswordArgs', 'ConnectionSqlserverPasswordArgsDict']] password: The SQL Server database password.
        :param pulumi.Input[_builtins.int] port: The SQL Server database port.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the connection schema in Materialize. Defaults to `public`.
        :param pulumi.Input[Union['ConnectionSqlserverSshTunnelArgs', 'ConnectionSqlserverSshTunnelArgsDict']] ssh_tunnel: The SSH tunnel configuration for the SQL Server database.
        :param pulumi.Input[Union['ConnectionSqlserverSslCertificateAuthorityArgs', 'ConnectionSqlserverSslCertificateAuthorityArgsDict']] ssl_certificate_authority: The CA certificate for the SQL Server database.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[_builtins.str] ssl_mode: The SSL mode for the SQL Server database. Allowed values are disabled, required, verify, verify-ca.
        :param pulumi.Input[Union['ConnectionSqlserverUserArgs', 'ConnectionSqlserverUserArgsDict']] user: The SQL Server database username.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[_builtins.bool] validate: If the connection should wait for validation.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectionSqlserverArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A SQL Server connection establishes a link to a single database of a SQL Server instance.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        sqlserver_password = materialize.Secret("sqlserverPassword",
            value="some-secret-value",
            comment="secret comment")
        # Basic SQL Server connection
        basic = materialize.ConnectionSqlserver("basic",
            host="sql-server.example.com",
            port=1433,
            user={
                "text": "sqluser",
            },
            password={
                "name": sqlserver_password.name,
                "schema_name": sqlserver_password.schema_name,
                "database_name": sqlserver_password.database_name,
            },
            database="testdb",
            validate=True)
        # SQL Server connection with SSH tunnel
        example_ssh_connection = materialize.ConnectionSshTunnel("exampleSshConnection",
            host="bastion-host.example.com",
            port=22,
            user="ubuntu")
        ssh_example = materialize.ConnectionSqlserver("sshExample",
            host="private-sql-server.example.com",
            port=1433,
            user={
                "text": "sqluser",
            },
            password={
                "name": sqlserver_password.name,
                "schema_name": sqlserver_password.schema_name,
                "database_name": sqlserver_password.database_name,
            },
            database="testdb",
            ssh_tunnel={
                "name": example_ssh_connection.name,
            },
            validate=False)
        # SQL Server connection with AWS PrivateLink
        sqlserver_privatelink = materialize.ConnectionAwsPrivatelink("sqlserverPrivatelink",
            service_name="com.amazonaws.vpce.us-east-1.vpce-svc-0e123abc123198abc",
            availability_zones=[
                "use1-az1",
                "use1-az4",
            ])
        privatelink_example = materialize.ConnectionSqlserver("privatelinkExample",
            host="sqlserver.example.com",
            port=1433,
            user={
                "text": "sqluser",
            },
            password={
                "name": sqlserver_password.name,
                "schema_name": sqlserver_password.schema_name,
                "database_name": sqlserver_password.database_name,
            },
            database="testdb",
            aws_privatelink={
                "name": sqlserver_privatelink.name,
            },
            validate=False)
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        #!/bin/bash

        SQL Server connections can be imported using the connection name

        ```sh
        $ pulumi import materialize:index/connectionSqlserver:ConnectionSqlserver example <region>:<connection_name>
        ```

        Example

        ```sh
        $ pulumi import materialize:index/connectionSqlserver:ConnectionSqlserver example aws/us-east-1:my_sqlserver_connection
        ```

        :param str resource_name: The name of the resource.
        :param ConnectionSqlserverArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectionSqlserverArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_privatelink: Optional[pulumi.Input[Union['ConnectionSqlserverAwsPrivatelinkArgs', 'ConnectionSqlserverAwsPrivatelinkArgsDict']]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[Union['ConnectionSqlserverPasswordArgs', 'ConnectionSqlserverPasswordArgsDict']]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_tunnel: Optional[pulumi.Input[Union['ConnectionSqlserverSshTunnelArgs', 'ConnectionSqlserverSshTunnelArgsDict']]] = None,
                 ssl_certificate_authority: Optional[pulumi.Input[Union['ConnectionSqlserverSslCertificateAuthorityArgs', 'ConnectionSqlserverSslCertificateAuthorityArgsDict']]] = None,
                 ssl_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 user: Optional[pulumi.Input[Union['ConnectionSqlserverUserArgs', 'ConnectionSqlserverUserArgsDict']]] = None,
                 validate: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectionSqlserverArgs.__new__(ConnectionSqlserverArgs)

            __props__.__dict__["aws_privatelink"] = aws_privatelink
            __props__.__dict__["comment"] = comment
            if database is None and not opts.urn:
                raise TypeError("Missing required property 'database'")
            __props__.__dict__["database"] = database
            __props__.__dict__["database_name"] = database_name
            if host is None and not opts.urn:
                raise TypeError("Missing required property 'host'")
            __props__.__dict__["host"] = host
            __props__.__dict__["name"] = name
            __props__.__dict__["ownership_role"] = ownership_role
            __props__.__dict__["password"] = password
            __props__.__dict__["port"] = port
            __props__.__dict__["region"] = region
            __props__.__dict__["schema_name"] = schema_name
            __props__.__dict__["ssh_tunnel"] = ssh_tunnel
            __props__.__dict__["ssl_certificate_authority"] = ssl_certificate_authority
            __props__.__dict__["ssl_mode"] = ssl_mode
            if user is None and not opts.urn:
                raise TypeError("Missing required property 'user'")
            __props__.__dict__["user"] = user
            __props__.__dict__["validate"] = validate
            __props__.__dict__["qualified_sql_name"] = None
        super(ConnectionSqlserver, __self__).__init__(
            'materialize:index/connectionSqlserver:ConnectionSqlserver',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws_privatelink: Optional[pulumi.Input[Union['ConnectionSqlserverAwsPrivatelinkArgs', 'ConnectionSqlserverAwsPrivatelinkArgsDict']]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            database: Optional[pulumi.Input[_builtins.str]] = None,
            database_name: Optional[pulumi.Input[_builtins.str]] = None,
            host: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[Union['ConnectionSqlserverPasswordArgs', 'ConnectionSqlserverPasswordArgsDict']]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            qualified_sql_name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            schema_name: Optional[pulumi.Input[_builtins.str]] = None,
            ssh_tunnel: Optional[pulumi.Input[Union['ConnectionSqlserverSshTunnelArgs', 'ConnectionSqlserverSshTunnelArgsDict']]] = None,
            ssl_certificate_authority: Optional[pulumi.Input[Union['ConnectionSqlserverSslCertificateAuthorityArgs', 'ConnectionSqlserverSslCertificateAuthorityArgsDict']]] = None,
            ssl_mode: Optional[pulumi.Input[_builtins.str]] = None,
            user: Optional[pulumi.Input[Union['ConnectionSqlserverUserArgs', 'ConnectionSqlserverUserArgsDict']]] = None,
            validate: Optional[pulumi.Input[_builtins.bool]] = None) -> 'ConnectionSqlserver':
        """
        Get an existing ConnectionSqlserver resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ConnectionSqlserverAwsPrivatelinkArgs', 'ConnectionSqlserverAwsPrivatelinkArgsDict']] aws_privatelink: The AWS PrivateLink configuration for the SQL Server database.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database: The target SQL Server database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[_builtins.str] host: The SQL Server database hostname.
        :param pulumi.Input[_builtins.str] name: The identifier for the connection.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input[Union['ConnectionSqlserverPasswordArgs', 'ConnectionSqlserverPasswordArgsDict']] password: The SQL Server database password.
        :param pulumi.Input[_builtins.int] port: The SQL Server database port.
        :param pulumi.Input[_builtins.str] qualified_sql_name: The fully qualified name of the connection.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the connection schema in Materialize. Defaults to `public`.
        :param pulumi.Input[Union['ConnectionSqlserverSshTunnelArgs', 'ConnectionSqlserverSshTunnelArgsDict']] ssh_tunnel: The SSH tunnel configuration for the SQL Server database.
        :param pulumi.Input[Union['ConnectionSqlserverSslCertificateAuthorityArgs', 'ConnectionSqlserverSslCertificateAuthorityArgsDict']] ssl_certificate_authority: The CA certificate for the SQL Server database.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[_builtins.str] ssl_mode: The SSL mode for the SQL Server database. Allowed values are disabled, required, verify, verify-ca.
        :param pulumi.Input[Union['ConnectionSqlserverUserArgs', 'ConnectionSqlserverUserArgsDict']] user: The SQL Server database username.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[_builtins.bool] validate: If the connection should wait for validation.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectionSqlserverState.__new__(_ConnectionSqlserverState)

        __props__.__dict__["aws_privatelink"] = aws_privatelink
        __props__.__dict__["comment"] = comment
        __props__.__dict__["database"] = database
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["host"] = host
        __props__.__dict__["name"] = name
        __props__.__dict__["ownership_role"] = ownership_role
        __props__.__dict__["password"] = password
        __props__.__dict__["port"] = port
        __props__.__dict__["qualified_sql_name"] = qualified_sql_name
        __props__.__dict__["region"] = region
        __props__.__dict__["schema_name"] = schema_name
        __props__.__dict__["ssh_tunnel"] = ssh_tunnel
        __props__.__dict__["ssl_certificate_authority"] = ssl_certificate_authority
        __props__.__dict__["ssl_mode"] = ssl_mode
        __props__.__dict__["user"] = user
        __props__.__dict__["validate"] = validate
        return ConnectionSqlserver(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="awsPrivatelink")
    def aws_privatelink(self) -> pulumi.Output[Optional['outputs.ConnectionSqlserverAwsPrivatelink']]:
        """
        The AWS PrivateLink configuration for the SQL Server database.
        """
        return pulumi.get(self, "aws_privatelink")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Output[_builtins.str]:
        """
        The target SQL Server database.
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @_builtins.property
    @pulumi.getter
    def host(self) -> pulumi.Output[_builtins.str]:
        """
        The SQL Server database hostname.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The identifier for the connection.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> pulumi.Output[_builtins.str]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional['outputs.ConnectionSqlserverPassword']]:
        """
        The SQL Server database password.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The SQL Server database port.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="qualifiedSqlName")
    def qualified_sql_name(self) -> pulumi.Output[_builtins.str]:
        """
        The fully qualified name of the connection.
        """
        return pulumi.get(self, "qualified_sql_name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The identifier for the connection schema in Materialize. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @_builtins.property
    @pulumi.getter(name="sshTunnel")
    def ssh_tunnel(self) -> pulumi.Output[Optional['outputs.ConnectionSqlserverSshTunnel']]:
        """
        The SSH tunnel configuration for the SQL Server database.
        """
        return pulumi.get(self, "ssh_tunnel")

    @_builtins.property
    @pulumi.getter(name="sslCertificateAuthority")
    def ssl_certificate_authority(self) -> pulumi.Output[Optional['outputs.ConnectionSqlserverSslCertificateAuthority']]:
        """
        The CA certificate for the SQL Server database.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "ssl_certificate_authority")

    @_builtins.property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The SSL mode for the SQL Server database. Allowed values are disabled, required, verify, verify-ca.
        """
        return pulumi.get(self, "ssl_mode")

    @_builtins.property
    @pulumi.getter
    def user(self) -> pulumi.Output['outputs.ConnectionSqlserverUser']:
        """
        The SQL Server database username.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "user")

    @_builtins.property
    @pulumi.getter
    def validate(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If the connection should wait for validation.
        """
        return pulumi.get(self, "validate")

