# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ConnectionSshTunnelArgs', 'ConnectionSshTunnel']

@pulumi.input_type
class ConnectionSshTunnelArgs:
    def __init__(__self__, *,
                 host: pulumi.Input[_builtins.str],
                 port: pulumi.Input[_builtins.int],
                 user: pulumi.Input[_builtins.str],
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 validate: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ConnectionSshTunnel resource.
        :param pulumi.Input[_builtins.str] host: The host of the SSH tunnel.
        :param pulumi.Input[_builtins.int] port: The port of the SSH tunnel.
        :param pulumi.Input[_builtins.str] user: The user of the SSH tunnel.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[_builtins.str] name: The identifier for the connection.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the connection schema in Materialize. Defaults to `public`.
        :param pulumi.Input[_builtins.bool] validate: If the connection should wait for validation.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "user", user)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ownership_role is not None:
            pulumi.set(__self__, "ownership_role", ownership_role)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if validate is not None:
            pulumi.set(__self__, "validate", validate)

    @_builtins.property
    @pulumi.getter
    def host(self) -> pulumi.Input[_builtins.str]:
        """
        The host of the SSH tunnel.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Input[_builtins.int]:
        """
        The port of the SSH tunnel.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> pulumi.Input[_builtins.str]:
        """
        The user of the SSH tunnel.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the connection.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @ownership_role.setter
    def ownership_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ownership_role", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the connection schema in Materialize. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema_name", value)

    @_builtins.property
    @pulumi.getter
    def validate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If the connection should wait for validation.
        """
        return pulumi.get(self, "validate")

    @validate.setter
    def validate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "validate", value)


@pulumi.input_type
class _ConnectionSshTunnelState:
    def __init__(__self__, *,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 public_key1: Optional[pulumi.Input[_builtins.str]] = None,
                 public_key2: Optional[pulumi.Input[_builtins.str]] = None,
                 qualified_sql_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None,
                 validate: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ConnectionSshTunnel resources.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[_builtins.str] host: The host of the SSH tunnel.
        :param pulumi.Input[_builtins.str] name: The identifier for the connection.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input[_builtins.int] port: The port of the SSH tunnel.
        :param pulumi.Input[_builtins.str] public_key1: The first public key associated with the SSH tunnel.
        :param pulumi.Input[_builtins.str] public_key2: The second public key associated with the SSH tunnel.
        :param pulumi.Input[_builtins.str] qualified_sql_name: The fully qualified name of the connection.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the connection schema in Materialize. Defaults to `public`.
        :param pulumi.Input[_builtins.str] user: The user of the SSH tunnel.
        :param pulumi.Input[_builtins.bool] validate: If the connection should wait for validation.
        """
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ownership_role is not None:
            pulumi.set(__self__, "ownership_role", ownership_role)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if public_key1 is not None:
            pulumi.set(__self__, "public_key1", public_key1)
        if public_key2 is not None:
            pulumi.set(__self__, "public_key2", public_key2)
        if qualified_sql_name is not None:
            pulumi.set(__self__, "qualified_sql_name", qualified_sql_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if user is not None:
            pulumi.set(__self__, "user", user)
        if validate is not None:
            pulumi.set(__self__, "validate", validate)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The host of the SSH tunnel.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the connection.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @ownership_role.setter
    def ownership_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ownership_role", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port of the SSH tunnel.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="publicKey1")
    def public_key1(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The first public key associated with the SSH tunnel.
        """
        return pulumi.get(self, "public_key1")

    @public_key1.setter
    def public_key1(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_key1", value)

    @_builtins.property
    @pulumi.getter(name="publicKey2")
    def public_key2(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The second public key associated with the SSH tunnel.
        """
        return pulumi.get(self, "public_key2")

    @public_key2.setter
    def public_key2(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_key2", value)

    @_builtins.property
    @pulumi.getter(name="qualifiedSqlName")
    def qualified_sql_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified name of the connection.
        """
        return pulumi.get(self, "qualified_sql_name")

    @qualified_sql_name.setter
    def qualified_sql_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "qualified_sql_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the connection schema in Materialize. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema_name", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user of the SSH tunnel.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user", value)

    @_builtins.property
    @pulumi.getter
    def validate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If the connection should wait for validation.
        """
        return pulumi.get(self, "validate")

    @validate.setter
    def validate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "validate", value)


@pulumi.type_token("materialize:index/connectionSshTunnel:ConnectionSshTunnel")
class ConnectionSshTunnel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None,
                 validate: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        An SSH tunnel connection establishes a link to an SSH bastion server.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        # Create SSH Connection
        example_ssh_connection = materialize.ConnectionSshTunnel("exampleSshConnection",
            host="example.com",
            port=22,
            schema_name="public",
            user="example")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        #Connections can be imported using the connection id:

        ```sh
        $ pulumi import materialize:index/connectionSshTunnel:ConnectionSshTunnel example <region>:<connection_id>
        ```

        Connection id and information be found in the `mz_catalog.mz_connections` table

        The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[_builtins.str] host: The host of the SSH tunnel.
        :param pulumi.Input[_builtins.str] name: The identifier for the connection.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input[_builtins.int] port: The port of the SSH tunnel.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the connection schema in Materialize. Defaults to `public`.
        :param pulumi.Input[_builtins.str] user: The user of the SSH tunnel.
        :param pulumi.Input[_builtins.bool] validate: If the connection should wait for validation.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectionSshTunnelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An SSH tunnel connection establishes a link to an SSH bastion server.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        # Create SSH Connection
        example_ssh_connection = materialize.ConnectionSshTunnel("exampleSshConnection",
            host="example.com",
            port=22,
            schema_name="public",
            user="example")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        #Connections can be imported using the connection id:

        ```sh
        $ pulumi import materialize:index/connectionSshTunnel:ConnectionSshTunnel example <region>:<connection_id>
        ```

        Connection id and information be found in the `mz_catalog.mz_connections` table

        The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param ConnectionSshTunnelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectionSshTunnelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None,
                 validate: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectionSshTunnelArgs.__new__(ConnectionSshTunnelArgs)

            __props__.__dict__["comment"] = comment
            __props__.__dict__["database_name"] = database_name
            if host is None and not opts.urn:
                raise TypeError("Missing required property 'host'")
            __props__.__dict__["host"] = host
            __props__.__dict__["name"] = name
            __props__.__dict__["ownership_role"] = ownership_role
            if port is None and not opts.urn:
                raise TypeError("Missing required property 'port'")
            __props__.__dict__["port"] = port
            __props__.__dict__["region"] = region
            __props__.__dict__["schema_name"] = schema_name
            if user is None and not opts.urn:
                raise TypeError("Missing required property 'user'")
            __props__.__dict__["user"] = user
            __props__.__dict__["validate"] = validate
            __props__.__dict__["public_key1"] = None
            __props__.__dict__["public_key2"] = None
            __props__.__dict__["qualified_sql_name"] = None
        super(ConnectionSshTunnel, __self__).__init__(
            'materialize:index/connectionSshTunnel:ConnectionSshTunnel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            database_name: Optional[pulumi.Input[_builtins.str]] = None,
            host: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            public_key1: Optional[pulumi.Input[_builtins.str]] = None,
            public_key2: Optional[pulumi.Input[_builtins.str]] = None,
            qualified_sql_name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            schema_name: Optional[pulumi.Input[_builtins.str]] = None,
            user: Optional[pulumi.Input[_builtins.str]] = None,
            validate: Optional[pulumi.Input[_builtins.bool]] = None) -> 'ConnectionSshTunnel':
        """
        Get an existing ConnectionSshTunnel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[_builtins.str] host: The host of the SSH tunnel.
        :param pulumi.Input[_builtins.str] name: The identifier for the connection.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input[_builtins.int] port: The port of the SSH tunnel.
        :param pulumi.Input[_builtins.str] public_key1: The first public key associated with the SSH tunnel.
        :param pulumi.Input[_builtins.str] public_key2: The second public key associated with the SSH tunnel.
        :param pulumi.Input[_builtins.str] qualified_sql_name: The fully qualified name of the connection.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the connection schema in Materialize. Defaults to `public`.
        :param pulumi.Input[_builtins.str] user: The user of the SSH tunnel.
        :param pulumi.Input[_builtins.bool] validate: If the connection should wait for validation.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectionSshTunnelState.__new__(_ConnectionSshTunnelState)

        __props__.__dict__["comment"] = comment
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["host"] = host
        __props__.__dict__["name"] = name
        __props__.__dict__["ownership_role"] = ownership_role
        __props__.__dict__["port"] = port
        __props__.__dict__["public_key1"] = public_key1
        __props__.__dict__["public_key2"] = public_key2
        __props__.__dict__["qualified_sql_name"] = qualified_sql_name
        __props__.__dict__["region"] = region
        __props__.__dict__["schema_name"] = schema_name
        __props__.__dict__["user"] = user
        __props__.__dict__["validate"] = validate
        return ConnectionSshTunnel(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The identifier for the connection database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @_builtins.property
    @pulumi.getter
    def host(self) -> pulumi.Output[_builtins.str]:
        """
        The host of the SSH tunnel.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The identifier for the connection.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> pulumi.Output[_builtins.str]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[_builtins.int]:
        """
        The port of the SSH tunnel.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="publicKey1")
    def public_key1(self) -> pulumi.Output[_builtins.str]:
        """
        The first public key associated with the SSH tunnel.
        """
        return pulumi.get(self, "public_key1")

    @_builtins.property
    @pulumi.getter(name="publicKey2")
    def public_key2(self) -> pulumi.Output[_builtins.str]:
        """
        The second public key associated with the SSH tunnel.
        """
        return pulumi.get(self, "public_key2")

    @_builtins.property
    @pulumi.getter(name="qualifiedSqlName")
    def qualified_sql_name(self) -> pulumi.Output[_builtins.str]:
        """
        The fully qualified name of the connection.
        """
        return pulumi.get(self, "qualified_sql_name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The identifier for the connection schema in Materialize. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @_builtins.property
    @pulumi.getter
    def user(self) -> pulumi.Output[_builtins.str]:
        """
        The user of the SSH tunnel.
        """
        return pulumi.get(self, "user")

    @_builtins.property
    @pulumi.getter
    def validate(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If the connection should wait for validation.
        """
        return pulumi.get(self, "validate")

