# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetIndexesResult',
    'AwaitableGetIndexesResult',
    'get_indexes',
    'get_indexes_output',
]

@pulumi.output_type
class GetIndexesResult:
    """
    A collection of values returned by GetIndexes.
    """
    def __init__(__self__, database_name=None, id=None, indexes=None, region=None, schema_name=None):
        if database_name and not isinstance(database_name, str):
            raise TypeError("Expected argument 'database_name' to be a str")
        pulumi.set(__self__, "database_name", database_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if indexes and not isinstance(indexes, list):
            raise TypeError("Expected argument 'indexes' to be a list")
        pulumi.set(__self__, "indexes", indexes)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if schema_name and not isinstance(schema_name, str):
            raise TypeError("Expected argument 'schema_name' to be a str")
        pulumi.set(__self__, "schema_name", schema_name)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[_builtins.str]:
        """
        Limit indexes to a specific database
        """
        return pulumi.get(self, "database_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def indexes(self) -> Sequence['outputs.GetIndexesIndexResult']:
        """
        The indexes in the account
        """
        return pulumi.get(self, "indexes")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region in which the resource is located.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[_builtins.str]:
        """
        Limit indexes to a specific schema within a specific database
        """
        return pulumi.get(self, "schema_name")


class AwaitableGetIndexesResult(GetIndexesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIndexesResult(
            database_name=self.database_name,
            id=self.id,
            indexes=self.indexes,
            region=self.region,
            schema_name=self.schema_name)


def get_indexes(database_name: Optional[_builtins.str] = None,
                region: Optional[_builtins.str] = None,
                schema_name: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIndexesResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_materialize as materialize

    all = materialize.get_indexes()
    materialize = materialize.get_indexes(database_name="materialize")
    materialize_schema = materialize.get_indexes(database_name="materialize",
        schema_name="schema")
    ```


    :param _builtins.str database_name: Limit indexes to a specific database
    :param _builtins.str region: The region in which the resource is located.
    :param _builtins.str schema_name: Limit indexes to a specific schema within a specific database
    """
    __args__ = dict()
    __args__['databaseName'] = database_name
    __args__['region'] = region
    __args__['schemaName'] = schema_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('materialize:index/getIndexes:GetIndexes', __args__, opts=opts, typ=GetIndexesResult).value

    return AwaitableGetIndexesResult(
        database_name=pulumi.get(__ret__, 'database_name'),
        id=pulumi.get(__ret__, 'id'),
        indexes=pulumi.get(__ret__, 'indexes'),
        region=pulumi.get(__ret__, 'region'),
        schema_name=pulumi.get(__ret__, 'schema_name'))
def get_indexes_output(database_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       schema_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIndexesResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_materialize as materialize

    all = materialize.get_indexes()
    materialize = materialize.get_indexes(database_name="materialize")
    materialize_schema = materialize.get_indexes(database_name="materialize",
        schema_name="schema")
    ```


    :param _builtins.str database_name: Limit indexes to a specific database
    :param _builtins.str region: The region in which the resource is located.
    :param _builtins.str schema_name: Limit indexes to a specific schema within a specific database
    """
    __args__ = dict()
    __args__['databaseName'] = database_name
    __args__['region'] = region
    __args__['schemaName'] = schema_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('materialize:index/getIndexes:GetIndexes', __args__, opts=opts, typ=GetIndexesResult)
    return __ret__.apply(lambda __response__: GetIndexesResult(
        database_name=pulumi.get(__response__, 'database_name'),
        id=pulumi.get(__response__, 'id'),
        indexes=pulumi.get(__response__, 'indexes'),
        region=pulumi.get(__response__, 'region'),
        schema_name=pulumi.get(__response__, 'schema_name')))
