# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetMaterializedViewsResult',
    'AwaitableGetMaterializedViewsResult',
    'get_materialized_views',
    'get_materialized_views_output',
]

@pulumi.output_type
class GetMaterializedViewsResult:
    """
    A collection of values returned by GetMaterializedViews.
    """
    def __init__(__self__, database_name=None, id=None, materialized_views=None, region=None, schema_name=None):
        if database_name and not isinstance(database_name, str):
            raise TypeError("Expected argument 'database_name' to be a str")
        pulumi.set(__self__, "database_name", database_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if materialized_views and not isinstance(materialized_views, list):
            raise TypeError("Expected argument 'materialized_views' to be a list")
        pulumi.set(__self__, "materialized_views", materialized_views)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if schema_name and not isinstance(schema_name, str):
            raise TypeError("Expected argument 'schema_name' to be a str")
        pulumi.set(__self__, "schema_name", schema_name)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[_builtins.str]:
        """
        Limit materialized views to a specific database
        """
        return pulumi.get(self, "database_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="materializedViews")
    def materialized_views(self) -> Sequence['outputs.GetMaterializedViewsMaterializedViewResult']:
        """
        The materialized views in the account
        """
        return pulumi.get(self, "materialized_views")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region in which the resource is located.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[_builtins.str]:
        """
        Limit materialized views to a specific schema within a specific database
        """
        return pulumi.get(self, "schema_name")


class AwaitableGetMaterializedViewsResult(GetMaterializedViewsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMaterializedViewsResult(
            database_name=self.database_name,
            id=self.id,
            materialized_views=self.materialized_views,
            region=self.region,
            schema_name=self.schema_name)


def get_materialized_views(database_name: Optional[_builtins.str] = None,
                           region: Optional[_builtins.str] = None,
                           schema_name: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMaterializedViewsResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_materialize as materialize

    all = materialize.get_materialized_views()
    materialize = materialize.get_materialized_views(database_name="materialize")
    materialize_schema = materialize.get_materialized_views(database_name="materialize",
        schema_name="schema")
    ```


    :param _builtins.str database_name: Limit materialized views to a specific database
    :param _builtins.str region: The region in which the resource is located.
    :param _builtins.str schema_name: Limit materialized views to a specific schema within a specific database
    """
    __args__ = dict()
    __args__['databaseName'] = database_name
    __args__['region'] = region
    __args__['schemaName'] = schema_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('materialize:index/getMaterializedViews:GetMaterializedViews', __args__, opts=opts, typ=GetMaterializedViewsResult).value

    return AwaitableGetMaterializedViewsResult(
        database_name=pulumi.get(__ret__, 'database_name'),
        id=pulumi.get(__ret__, 'id'),
        materialized_views=pulumi.get(__ret__, 'materialized_views'),
        region=pulumi.get(__ret__, 'region'),
        schema_name=pulumi.get(__ret__, 'schema_name'))
def get_materialized_views_output(database_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  schema_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMaterializedViewsResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_materialize as materialize

    all = materialize.get_materialized_views()
    materialize = materialize.get_materialized_views(database_name="materialize")
    materialize_schema = materialize.get_materialized_views(database_name="materialize",
        schema_name="schema")
    ```


    :param _builtins.str database_name: Limit materialized views to a specific database
    :param _builtins.str region: The region in which the resource is located.
    :param _builtins.str schema_name: Limit materialized views to a specific schema within a specific database
    """
    __args__ = dict()
    __args__['databaseName'] = database_name
    __args__['region'] = region
    __args__['schemaName'] = schema_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('materialize:index/getMaterializedViews:GetMaterializedViews', __args__, opts=opts, typ=GetMaterializedViewsResult)
    return __ret__.apply(lambda __response__: GetMaterializedViewsResult(
        database_name=pulumi.get(__response__, 'database_name'),
        id=pulumi.get(__response__, 'id'),
        materialized_views=pulumi.get(__response__, 'materialized_views'),
        region=pulumi.get(__response__, 'region'),
        schema_name=pulumi.get(__response__, 'schema_name')))
