# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetSystemParametersResult',
    'AwaitableGetSystemParametersResult',
    'get_system_parameters',
    'get_system_parameters_output',
]

@pulumi.output_type
class GetSystemParametersResult:
    """
    A collection of values returned by GetSystemParameters.
    """
    def __init__(__self__, id=None, name=None, parameters=None, region=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if parameters and not isinstance(parameters, list):
            raise TypeError("Expected argument 'parameters' to be a list")
        pulumi.set(__self__, "parameters", parameters)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the specific system parameter to fetch.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Sequence['outputs.GetSystemParametersParameterResult']:
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region in which the resource is located.
        """
        return pulumi.get(self, "region")


class AwaitableGetSystemParametersResult(GetSystemParametersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSystemParametersResult(
            id=self.id,
            name=self.name,
            parameters=self.parameters,
            region=self.region)


def get_system_parameters(name: Optional[_builtins.str] = None,
                          region: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSystemParametersResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_materialize as materialize

    all = materialize.get_system_parameters()
    ```


    :param _builtins.str name: The name of the specific system parameter to fetch.
    :param _builtins.str region: The region in which the resource is located.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('materialize:index/getSystemParameters:GetSystemParameters', __args__, opts=opts, typ=GetSystemParametersResult).value

    return AwaitableGetSystemParametersResult(
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        parameters=pulumi.get(__ret__, 'parameters'),
        region=pulumi.get(__ret__, 'region'))
def get_system_parameters_output(name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSystemParametersResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_materialize as materialize

    all = materialize.get_system_parameters()
    ```


    :param _builtins.str name: The name of the specific system parameter to fetch.
    :param _builtins.str region: The region in which the resource is located.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('materialize:index/getSystemParameters:GetSystemParameters', __args__, opts=opts, typ=GetSystemParametersResult)
    return __ret__.apply(lambda __response__: GetSystemParametersResult(
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        parameters=pulumi.get(__response__, 'parameters'),
        region=pulumi.get(__response__, 'region')))
