# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetUsersResult',
    'AwaitableGetUsersResult',
    'get_users',
    'get_users_output',
]

@pulumi.output_type
class GetUsersResult:
    """
    A collection of values returned by GetUsers.
    """
    def __init__(__self__, email=None, id=None, verified=None):
        if email and not isinstance(email, str):
            raise TypeError("Expected argument 'email' to be a str")
        pulumi.set(__self__, "email", email)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if verified and not isinstance(verified, bool):
            raise TypeError("Expected argument 'verified' to be a bool")
        pulumi.set(__self__, "verified", verified)

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        """
        The email address of the user to retrieve.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique (UUID) identifier of the user.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def verified(self) -> _builtins.bool:
        """
        Whether the user's email address has been verified.
        """
        return pulumi.get(self, "verified")


class AwaitableGetUsersResult(GetUsersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUsersResult(
            email=self.email,
            id=self.id,
            verified=self.verified)


def get_users(email: Optional[_builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUsersResult:
    """
    The user data source allows you to retrieve information about a user in your Materialize organization.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_materialize as materialize

    example_user = materialize.get_users(email="example@example.com")
    ```


    :param _builtins.str email: The email address of the user to retrieve.
    """
    __args__ = dict()
    __args__['email'] = email
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('materialize:index/getUsers:GetUsers', __args__, opts=opts, typ=GetUsersResult).value

    return AwaitableGetUsersResult(
        email=pulumi.get(__ret__, 'email'),
        id=pulumi.get(__ret__, 'id'),
        verified=pulumi.get(__ret__, 'verified'))
def get_users_output(email: Optional[pulumi.Input[_builtins.str]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUsersResult]:
    """
    The user data source allows you to retrieve information about a user in your Materialize organization.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_materialize as materialize

    example_user = materialize.get_users(email="example@example.com")
    ```


    :param _builtins.str email: The email address of the user to retrieve.
    """
    __args__ = dict()
    __args__['email'] = email
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('materialize:index/getUsers:GetUsers', __args__, opts=opts, typ=GetUsersResult)
    return __ret__.apply(lambda __response__: GetUsersResult(
        email=pulumi.get(__response__, 'email'),
        id=pulumi.get(__response__, 'id'),
        verified=pulumi.get(__response__, 'verified')))
