# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['GrantClusterDefaultPrivilegeArgs', 'GrantClusterDefaultPrivilege']

@pulumi.input_type
class GrantClusterDefaultPrivilegeArgs:
    def __init__(__self__, *,
                 grantee_name: pulumi.Input[_builtins.str],
                 privilege: pulumi.Input[_builtins.str],
                 target_role_name: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a GrantClusterDefaultPrivilege resource.
        :param pulumi.Input[_builtins.str] grantee_name: The role name that will gain the default privilege. Use the `PUBLIC` pseudo-role to grant privileges to all roles.
        :param pulumi.Input[_builtins.str] privilege: The privilege to grant to the object.
        :param pulumi.Input[_builtins.str] target_role_name: The default privilege will apply to objects created by this role. If this is left blank, then the current role is assumed. Use the `PUBLIC` pseudo-role to target objects created by all roles.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        """
        pulumi.set(__self__, "grantee_name", grantee_name)
        pulumi.set(__self__, "privilege", privilege)
        pulumi.set(__self__, "target_role_name", target_role_name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="granteeName")
    def grantee_name(self) -> pulumi.Input[_builtins.str]:
        """
        The role name that will gain the default privilege. Use the `PUBLIC` pseudo-role to grant privileges to all roles.
        """
        return pulumi.get(self, "grantee_name")

    @grantee_name.setter
    def grantee_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "grantee_name", value)

    @_builtins.property
    @pulumi.getter
    def privilege(self) -> pulumi.Input[_builtins.str]:
        """
        The privilege to grant to the object.
        """
        return pulumi.get(self, "privilege")

    @privilege.setter
    def privilege(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "privilege", value)

    @_builtins.property
    @pulumi.getter(name="targetRoleName")
    def target_role_name(self) -> pulumi.Input[_builtins.str]:
        """
        The default privilege will apply to objects created by this role. If this is left blank, then the current role is assumed. Use the `PUBLIC` pseudo-role to target objects created by all roles.
        """
        return pulumi.get(self, "target_role_name")

    @target_role_name.setter
    def target_role_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_role_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _GrantClusterDefaultPrivilegeState:
    def __init__(__self__, *,
                 grantee_name: Optional[pulumi.Input[_builtins.str]] = None,
                 privilege: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 target_role_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GrantClusterDefaultPrivilege resources.
        :param pulumi.Input[_builtins.str] grantee_name: The role name that will gain the default privilege. Use the `PUBLIC` pseudo-role to grant privileges to all roles.
        :param pulumi.Input[_builtins.str] privilege: The privilege to grant to the object.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] target_role_name: The default privilege will apply to objects created by this role. If this is left blank, then the current role is assumed. Use the `PUBLIC` pseudo-role to target objects created by all roles.
        """
        if grantee_name is not None:
            pulumi.set(__self__, "grantee_name", grantee_name)
        if privilege is not None:
            pulumi.set(__self__, "privilege", privilege)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if target_role_name is not None:
            pulumi.set(__self__, "target_role_name", target_role_name)

    @_builtins.property
    @pulumi.getter(name="granteeName")
    def grantee_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role name that will gain the default privilege. Use the `PUBLIC` pseudo-role to grant privileges to all roles.
        """
        return pulumi.get(self, "grantee_name")

    @grantee_name.setter
    def grantee_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "grantee_name", value)

    @_builtins.property
    @pulumi.getter
    def privilege(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The privilege to grant to the object.
        """
        return pulumi.get(self, "privilege")

    @privilege.setter
    def privilege(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "privilege", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="targetRoleName")
    def target_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default privilege will apply to objects created by this role. If this is left blank, then the current role is assumed. Use the `PUBLIC` pseudo-role to target objects created by all roles.
        """
        return pulumi.get(self, "target_role_name")

    @target_role_name.setter
    def target_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_role_name", value)


@pulumi.type_token("materialize:index/grantClusterDefaultPrivilege:GrantClusterDefaultPrivilege")
class GrantClusterDefaultPrivilege(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 grantee_name: Optional[pulumi.Input[_builtins.str]] = None,
                 privilege: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 target_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Defines default privileges that will be applied to objects created in the future. It does not affect any existing objects.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        # Grant role the privilege USAGE for objects
        example = materialize.GrantClusterDefaultPrivilege("example",
            grantee_name="grantee",
            privilege="USAGE",
            target_role_name="target_role")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Grants can be imported using the concatenation of GRANT DEFAULT and the grantee id of the role.

        Optionally, you can include the target id. The privilege is required.

        ```sh
        $ pulumi import materialize:index/grantClusterDefaultPrivilege:GrantClusterDefaultPrivilege example <region>:GRANT DEFAULT|CLUSTER|<grantee_id>|<target_role_id>|||<privilege>
        ```

        The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] grantee_name: The role name that will gain the default privilege. Use the `PUBLIC` pseudo-role to grant privileges to all roles.
        :param pulumi.Input[_builtins.str] privilege: The privilege to grant to the object.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] target_role_name: The default privilege will apply to objects created by this role. If this is left blank, then the current role is assumed. Use the `PUBLIC` pseudo-role to target objects created by all roles.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GrantClusterDefaultPrivilegeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Defines default privileges that will be applied to objects created in the future. It does not affect any existing objects.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        # Grant role the privilege USAGE for objects
        example = materialize.GrantClusterDefaultPrivilege("example",
            grantee_name="grantee",
            privilege="USAGE",
            target_role_name="target_role")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Grants can be imported using the concatenation of GRANT DEFAULT and the grantee id of the role.

        Optionally, you can include the target id. The privilege is required.

        ```sh
        $ pulumi import materialize:index/grantClusterDefaultPrivilege:GrantClusterDefaultPrivilege example <region>:GRANT DEFAULT|CLUSTER|<grantee_id>|<target_role_id>|||<privilege>
        ```

        The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param GrantClusterDefaultPrivilegeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GrantClusterDefaultPrivilegeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 grantee_name: Optional[pulumi.Input[_builtins.str]] = None,
                 privilege: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 target_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GrantClusterDefaultPrivilegeArgs.__new__(GrantClusterDefaultPrivilegeArgs)

            if grantee_name is None and not opts.urn:
                raise TypeError("Missing required property 'grantee_name'")
            __props__.__dict__["grantee_name"] = grantee_name
            if privilege is None and not opts.urn:
                raise TypeError("Missing required property 'privilege'")
            __props__.__dict__["privilege"] = privilege
            __props__.__dict__["region"] = region
            if target_role_name is None and not opts.urn:
                raise TypeError("Missing required property 'target_role_name'")
            __props__.__dict__["target_role_name"] = target_role_name
        super(GrantClusterDefaultPrivilege, __self__).__init__(
            'materialize:index/grantClusterDefaultPrivilege:GrantClusterDefaultPrivilege',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            grantee_name: Optional[pulumi.Input[_builtins.str]] = None,
            privilege: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            target_role_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'GrantClusterDefaultPrivilege':
        """
        Get an existing GrantClusterDefaultPrivilege resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] grantee_name: The role name that will gain the default privilege. Use the `PUBLIC` pseudo-role to grant privileges to all roles.
        :param pulumi.Input[_builtins.str] privilege: The privilege to grant to the object.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] target_role_name: The default privilege will apply to objects created by this role. If this is left blank, then the current role is assumed. Use the `PUBLIC` pseudo-role to target objects created by all roles.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GrantClusterDefaultPrivilegeState.__new__(_GrantClusterDefaultPrivilegeState)

        __props__.__dict__["grantee_name"] = grantee_name
        __props__.__dict__["privilege"] = privilege
        __props__.__dict__["region"] = region
        __props__.__dict__["target_role_name"] = target_role_name
        return GrantClusterDefaultPrivilege(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="granteeName")
    def grantee_name(self) -> pulumi.Output[_builtins.str]:
        """
        The role name that will gain the default privilege. Use the `PUBLIC` pseudo-role to grant privileges to all roles.
        """
        return pulumi.get(self, "grantee_name")

    @_builtins.property
    @pulumi.getter
    def privilege(self) -> pulumi.Output[_builtins.str]:
        """
        The privilege to grant to the object.
        """
        return pulumi.get(self, "privilege")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="targetRoleName")
    def target_role_name(self) -> pulumi.Output[_builtins.str]:
        """
        The default privilege will apply to objects created by this role. If this is left blank, then the current role is assumed. Use the `PUBLIC` pseudo-role to target objects created by all roles.
        """
        return pulumi.get(self, "target_role_name")

