# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['GrantRoleArgs', 'GrantRole']

@pulumi.input_type
class GrantRoleArgs:
    def __init__(__self__, *,
                 member_name: pulumi.Input[_builtins.str],
                 role_name: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a GrantRole resource.
        :param pulumi.Input[_builtins.str] member_name: The role name to add to role_name as a member.
        :param pulumi.Input[_builtins.str] role_name: The role name to add member_name as a member.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        """
        pulumi.set(__self__, "member_name", member_name)
        pulumi.set(__self__, "role_name", role_name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="memberName")
    def member_name(self) -> pulumi.Input[_builtins.str]:
        """
        The role name to add to role_name as a member.
        """
        return pulumi.get(self, "member_name")

    @member_name.setter
    def member_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "member_name", value)

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Input[_builtins.str]:
        """
        The role name to add member_name as a member.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _GrantRoleState:
    def __init__(__self__, *,
                 member_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GrantRole resources.
        :param pulumi.Input[_builtins.str] member_name: The role name to add to role_name as a member.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] role_name: The role name to add member_name as a member.
        """
        if member_name is not None:
            pulumi.set(__self__, "member_name", member_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)

    @_builtins.property
    @pulumi.getter(name="memberName")
    def member_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role name to add to role_name as a member.
        """
        return pulumi.get(self, "member_name")

    @member_name.setter
    def member_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "member_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role name to add member_name as a member.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_name", value)


@pulumi.type_token("materialize:index/grantRole:GrantRole")
class GrantRole(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 member_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages the system privileges for roles.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        # Grant role to user
        role_grant_user = materialize.GrantRole("roleGrantUser",
            member_name="user",
            role_name="role")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Grants can be imported using the concatenation of

        ROLE MEMBER, the id of the role and id of the member

        ```sh
        $ pulumi import materialize:index/grantRole:GrantRole example <region>:ROLE MEMBER|<role_id>|<member_id>
        ```

        The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] member_name: The role name to add to role_name as a member.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] role_name: The role name to add member_name as a member.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GrantRoleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the system privileges for roles.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        # Grant role to user
        role_grant_user = materialize.GrantRole("roleGrantUser",
            member_name="user",
            role_name="role")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Grants can be imported using the concatenation of

        ROLE MEMBER, the id of the role and id of the member

        ```sh
        $ pulumi import materialize:index/grantRole:GrantRole example <region>:ROLE MEMBER|<role_id>|<member_id>
        ```

        The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param GrantRoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GrantRoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 member_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GrantRoleArgs.__new__(GrantRoleArgs)

            if member_name is None and not opts.urn:
                raise TypeError("Missing required property 'member_name'")
            __props__.__dict__["member_name"] = member_name
            __props__.__dict__["region"] = region
            if role_name is None and not opts.urn:
                raise TypeError("Missing required property 'role_name'")
            __props__.__dict__["role_name"] = role_name
        super(GrantRole, __self__).__init__(
            'materialize:index/grantRole:GrantRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            member_name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            role_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'GrantRole':
        """
        Get an existing GrantRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] member_name: The role name to add to role_name as a member.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] role_name: The role name to add member_name as a member.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GrantRoleState.__new__(_GrantRoleState)

        __props__.__dict__["member_name"] = member_name
        __props__.__dict__["region"] = region
        __props__.__dict__["role_name"] = role_name
        return GrantRole(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="memberName")
    def member_name(self) -> pulumi.Output[_builtins.str]:
        """
        The role name to add to role_name as a member.
        """
        return pulumi.get(self, "member_name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Output[_builtins.str]:
        """
        The role name to add member_name as a member.
        """
        return pulumi.get(self, "role_name")

