# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['GrantSecretArgs', 'GrantSecret']

@pulumi.input_type
class GrantSecretArgs:
    def __init__(__self__, *,
                 database_name: pulumi.Input[_builtins.str],
                 privilege: pulumi.Input[_builtins.str],
                 role_name: pulumi.Input[_builtins.str],
                 schema_name: pulumi.Input[_builtins.str],
                 secret_name: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a GrantSecret resource.
        :param pulumi.Input[_builtins.str] database_name: The database that the secret belongs to.
        :param pulumi.Input[_builtins.str] privilege: The privilege to grant to the object.
        :param pulumi.Input[_builtins.str] role_name: The name of the role to grant privilege to.
        :param pulumi.Input[_builtins.str] schema_name: The schema that the secret being to.
        :param pulumi.Input[_builtins.str] secret_name: The secret that is being granted on.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "privilege", privilege)
        pulumi.set(__self__, "role_name", role_name)
        pulumi.set(__self__, "schema_name", schema_name)
        pulumi.set(__self__, "secret_name", secret_name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[_builtins.str]:
        """
        The database that the secret belongs to.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter
    def privilege(self) -> pulumi.Input[_builtins.str]:
        """
        The privilege to grant to the object.
        """
        return pulumi.get(self, "privilege")

    @privilege.setter
    def privilege(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "privilege", value)

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the role to grant privilege to.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role_name", value)

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> pulumi.Input[_builtins.str]:
        """
        The schema that the secret being to.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "schema_name", value)

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> pulumi.Input[_builtins.str]:
        """
        The secret that is being granted on.
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "secret_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _GrantSecretState:
    def __init__(__self__, *,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 privilege: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GrantSecret resources.
        :param pulumi.Input[_builtins.str] database_name: The database that the secret belongs to.
        :param pulumi.Input[_builtins.str] privilege: The privilege to grant to the object.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] role_name: The name of the role to grant privilege to.
        :param pulumi.Input[_builtins.str] schema_name: The schema that the secret being to.
        :param pulumi.Input[_builtins.str] secret_name: The secret that is being granted on.
        """
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if privilege is not None:
            pulumi.set(__self__, "privilege", privilege)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database that the secret belongs to.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter
    def privilege(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The privilege to grant to the object.
        """
        return pulumi.get(self, "privilege")

    @privilege.setter
    def privilege(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "privilege", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the role to grant privilege to.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_name", value)

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schema that the secret being to.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema_name", value)

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The secret that is being granted on.
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_name", value)


@pulumi.type_token("materialize:index/grantSecret:GrantSecret")
class GrantSecret(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 privilege: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages the privileges on a Materailize secret for roles.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        # Grant USAGE to role example_role to secret example_database.example_schema.example_secret
        secret_grant_usage = materialize.GrantSecret("secretGrantUsage",
            database_name="example_database",
            privilege="USAGE",
            role_name="example_role",
            schema_name="example_schema",
            secret_name="example_secret")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Grants can be imported using the concatenation of

        GRANT, the object type, the id of the object, the id of the role and the privilege

        ```sh
        $ pulumi import materialize:index/grantSecret:GrantSecret example <region>:GRANT|SECRET|<secret_id>|<role_id>|<privilege>
        ```

        The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] database_name: The database that the secret belongs to.
        :param pulumi.Input[_builtins.str] privilege: The privilege to grant to the object.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] role_name: The name of the role to grant privilege to.
        :param pulumi.Input[_builtins.str] schema_name: The schema that the secret being to.
        :param pulumi.Input[_builtins.str] secret_name: The secret that is being granted on.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GrantSecretArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the privileges on a Materailize secret for roles.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        # Grant USAGE to role example_role to secret example_database.example_schema.example_secret
        secret_grant_usage = materialize.GrantSecret("secretGrantUsage",
            database_name="example_database",
            privilege="USAGE",
            role_name="example_role",
            schema_name="example_schema",
            secret_name="example_secret")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Grants can be imported using the concatenation of

        GRANT, the object type, the id of the object, the id of the role and the privilege

        ```sh
        $ pulumi import materialize:index/grantSecret:GrantSecret example <region>:GRANT|SECRET|<secret_id>|<role_id>|<privilege>
        ```

        The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param GrantSecretArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GrantSecretArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 privilege: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GrantSecretArgs.__new__(GrantSecretArgs)

            if database_name is None and not opts.urn:
                raise TypeError("Missing required property 'database_name'")
            __props__.__dict__["database_name"] = database_name
            if privilege is None and not opts.urn:
                raise TypeError("Missing required property 'privilege'")
            __props__.__dict__["privilege"] = privilege
            __props__.__dict__["region"] = region
            if role_name is None and not opts.urn:
                raise TypeError("Missing required property 'role_name'")
            __props__.__dict__["role_name"] = role_name
            if schema_name is None and not opts.urn:
                raise TypeError("Missing required property 'schema_name'")
            __props__.__dict__["schema_name"] = schema_name
            if secret_name is None and not opts.urn:
                raise TypeError("Missing required property 'secret_name'")
            __props__.__dict__["secret_name"] = secret_name
        super(GrantSecret, __self__).__init__(
            'materialize:index/grantSecret:GrantSecret',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            database_name: Optional[pulumi.Input[_builtins.str]] = None,
            privilege: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            role_name: Optional[pulumi.Input[_builtins.str]] = None,
            schema_name: Optional[pulumi.Input[_builtins.str]] = None,
            secret_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'GrantSecret':
        """
        Get an existing GrantSecret resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] database_name: The database that the secret belongs to.
        :param pulumi.Input[_builtins.str] privilege: The privilege to grant to the object.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] role_name: The name of the role to grant privilege to.
        :param pulumi.Input[_builtins.str] schema_name: The schema that the secret being to.
        :param pulumi.Input[_builtins.str] secret_name: The secret that is being granted on.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GrantSecretState.__new__(_GrantSecretState)

        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["privilege"] = privilege
        __props__.__dict__["region"] = region
        __props__.__dict__["role_name"] = role_name
        __props__.__dict__["schema_name"] = schema_name
        __props__.__dict__["secret_name"] = secret_name
        return GrantSecret(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[_builtins.str]:
        """
        The database that the secret belongs to.
        """
        return pulumi.get(self, "database_name")

    @_builtins.property
    @pulumi.getter
    def privilege(self) -> pulumi.Output[_builtins.str]:
        """
        The privilege to grant to the object.
        """
        return pulumi.get(self, "privilege")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the role to grant privilege to.
        """
        return pulumi.get(self, "role_name")

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> pulumi.Output[_builtins.str]:
        """
        The schema that the secret being to.
        """
        return pulumi.get(self, "schema_name")

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> pulumi.Output[_builtins.str]:
        """
        The secret that is being granted on.
        """
        return pulumi.get(self, "secret_name")

