# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['GrantSystemPrivilegeArgs', 'GrantSystemPrivilege']

@pulumi.input_type
class GrantSystemPrivilegeArgs:
    def __init__(__self__, *,
                 privilege: pulumi.Input[_builtins.str],
                 role_name: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a GrantSystemPrivilege resource.
        :param pulumi.Input[_builtins.str] privilege: The system privilege to grant.
        :param pulumi.Input[_builtins.str] role_name: The name of the role to grant privilege to.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        """
        pulumi.set(__self__, "privilege", privilege)
        pulumi.set(__self__, "role_name", role_name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def privilege(self) -> pulumi.Input[_builtins.str]:
        """
        The system privilege to grant.
        """
        return pulumi.get(self, "privilege")

    @privilege.setter
    def privilege(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "privilege", value)

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the role to grant privilege to.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _GrantSystemPrivilegeState:
    def __init__(__self__, *,
                 privilege: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GrantSystemPrivilege resources.
        :param pulumi.Input[_builtins.str] privilege: The system privilege to grant.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] role_name: The name of the role to grant privilege to.
        """
        if privilege is not None:
            pulumi.set(__self__, "privilege", privilege)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)

    @_builtins.property
    @pulumi.getter
    def privilege(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The system privilege to grant.
        """
        return pulumi.get(self, "privilege")

    @privilege.setter
    def privilege(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "privilege", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the role to grant privilege to.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_name", value)


@pulumi.type_token("materialize:index/grantSystemPrivilege:GrantSystemPrivilege")
class GrantSystemPrivilege(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 privilege: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages the system privileges for roles.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        # Grant role the privilege CREATEDB
        role_createdb = materialize.GrantSystemPrivilege("roleCreatedb",
            privilege="CREATEDB",
            role_name="role")
        # Grant role the privilege CREATENETWORKPOLICY to allow the role to create network policies
        role_createnetworkpolicy = materialize.GrantSystemPrivilege("roleCreatenetworkpolicy",
            privilege="CREATENETWORKPOLICY",
            role_name="role")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Grants can be imported using the concatenation of

        GRANT SYSTEM, the id of the role and the privilege

        ```sh
        $ pulumi import materialize:index/grantSystemPrivilege:GrantSystemPrivilege example <region>:GRANT SYSTEM|<role_id>|<privilege>
        ```

        The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] privilege: The system privilege to grant.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] role_name: The name of the role to grant privilege to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GrantSystemPrivilegeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the system privileges for roles.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        # Grant role the privilege CREATEDB
        role_createdb = materialize.GrantSystemPrivilege("roleCreatedb",
            privilege="CREATEDB",
            role_name="role")
        # Grant role the privilege CREATENETWORKPOLICY to allow the role to create network policies
        role_createnetworkpolicy = materialize.GrantSystemPrivilege("roleCreatenetworkpolicy",
            privilege="CREATENETWORKPOLICY",
            role_name="role")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Grants can be imported using the concatenation of

        GRANT SYSTEM, the id of the role and the privilege

        ```sh
        $ pulumi import materialize:index/grantSystemPrivilege:GrantSystemPrivilege example <region>:GRANT SYSTEM|<role_id>|<privilege>
        ```

        The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param GrantSystemPrivilegeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GrantSystemPrivilegeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 privilege: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GrantSystemPrivilegeArgs.__new__(GrantSystemPrivilegeArgs)

            if privilege is None and not opts.urn:
                raise TypeError("Missing required property 'privilege'")
            __props__.__dict__["privilege"] = privilege
            __props__.__dict__["region"] = region
            if role_name is None and not opts.urn:
                raise TypeError("Missing required property 'role_name'")
            __props__.__dict__["role_name"] = role_name
        super(GrantSystemPrivilege, __self__).__init__(
            'materialize:index/grantSystemPrivilege:GrantSystemPrivilege',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            privilege: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            role_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'GrantSystemPrivilege':
        """
        Get an existing GrantSystemPrivilege resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] privilege: The system privilege to grant.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] role_name: The name of the role to grant privilege to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GrantSystemPrivilegeState.__new__(_GrantSystemPrivilegeState)

        __props__.__dict__["privilege"] = privilege
        __props__.__dict__["region"] = region
        __props__.__dict__["role_name"] = role_name
        return GrantSystemPrivilege(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def privilege(self) -> pulumi.Output[_builtins.str]:
        """
        The system privilege to grant.
        """
        return pulumi.get(self, "privilege")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the role to grant privilege to.
        """
        return pulumi.get(self, "role_name")

