# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IndexArgs', 'Index']

@pulumi.input_type
class IndexArgs:
    def __init__(__self__, *,
                 cluster_name: pulumi.Input[_builtins.str],
                 obj_name: pulumi.Input['IndexObjNameArgs'],
                 col_exprs: Optional[pulumi.Input[Sequence[pulumi.Input['IndexColExprArgs']]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 default: Optional[pulumi.Input[_builtins.bool]] = None,
                 method: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Index resource.
        :param pulumi.Input[_builtins.str] cluster_name: The cluster to maintain this index.
        :param pulumi.Input['IndexObjNameArgs'] obj_name: The name of the source, view, or materialized view on which you want to create an index.
        :param pulumi.Input[Sequence[pulumi.Input['IndexColExprArgs']]] col_exprs: The expressions to use as the key for the index.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.bool] default: Creates a default index using all inferred columns are used. Required if col_expr is not set.
        :param pulumi.Input[_builtins.str] method: The name of the index method to use.
        :param pulumi.Input[_builtins.str] name: The identifier for the index.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        """
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "obj_name", obj_name)
        if col_exprs is not None:
            pulumi.set(__self__, "col_exprs", col_exprs)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Input[_builtins.str]:
        """
        The cluster to maintain this index.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="objName")
    def obj_name(self) -> pulumi.Input['IndexObjNameArgs']:
        """
        The name of the source, view, or materialized view on which you want to create an index.
        """
        return pulumi.get(self, "obj_name")

    @obj_name.setter
    def obj_name(self, value: pulumi.Input['IndexObjNameArgs']):
        pulumi.set(self, "obj_name", value)

    @_builtins.property
    @pulumi.getter(name="colExprs")
    def col_exprs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IndexColExprArgs']]]]:
        """
        The expressions to use as the key for the index.
        """
        return pulumi.get(self, "col_exprs")

    @col_exprs.setter
    def col_exprs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IndexColExprArgs']]]]):
        pulumi.set(self, "col_exprs", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Creates a default index using all inferred columns are used. Required if col_expr is not set.
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "default", value)

    @_builtins.property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the index method to use.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "method", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the index.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _IndexState:
    def __init__(__self__, *,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 col_exprs: Optional[pulumi.Input[Sequence[pulumi.Input['IndexColExprArgs']]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 default: Optional[pulumi.Input[_builtins.bool]] = None,
                 method: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 obj_name: Optional[pulumi.Input['IndexObjNameArgs']] = None,
                 qualified_sql_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Index resources.
        :param pulumi.Input[_builtins.str] cluster_name: The cluster to maintain this index.
        :param pulumi.Input[Sequence[pulumi.Input['IndexColExprArgs']]] col_exprs: The expressions to use as the key for the index.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the index database.
        :param pulumi.Input[_builtins.bool] default: Creates a default index using all inferred columns are used. Required if col_expr is not set.
        :param pulumi.Input[_builtins.str] method: The name of the index method to use.
        :param pulumi.Input[_builtins.str] name: The identifier for the index.
        :param pulumi.Input['IndexObjNameArgs'] obj_name: The name of the source, view, or materialized view on which you want to create an index.
        :param pulumi.Input[_builtins.str] qualified_sql_name: The fully qualified name of the index.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the index schema.
        """
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if col_exprs is not None:
            pulumi.set(__self__, "col_exprs", col_exprs)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if obj_name is not None:
            pulumi.set(__self__, "obj_name", obj_name)
        if qualified_sql_name is not None:
            pulumi.set(__self__, "qualified_sql_name", qualified_sql_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster to maintain this index.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="colExprs")
    def col_exprs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IndexColExprArgs']]]]:
        """
        The expressions to use as the key for the index.
        """
        return pulumi.get(self, "col_exprs")

    @col_exprs.setter
    def col_exprs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IndexColExprArgs']]]]):
        pulumi.set(self, "col_exprs", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the index database.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Creates a default index using all inferred columns are used. Required if col_expr is not set.
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "default", value)

    @_builtins.property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the index method to use.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "method", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the index.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="objName")
    def obj_name(self) -> Optional[pulumi.Input['IndexObjNameArgs']]:
        """
        The name of the source, view, or materialized view on which you want to create an index.
        """
        return pulumi.get(self, "obj_name")

    @obj_name.setter
    def obj_name(self, value: Optional[pulumi.Input['IndexObjNameArgs']]):
        pulumi.set(self, "obj_name", value)

    @_builtins.property
    @pulumi.getter(name="qualifiedSqlName")
    def qualified_sql_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified name of the index.
        """
        return pulumi.get(self, "qualified_sql_name")

    @qualified_sql_name.setter
    def qualified_sql_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "qualified_sql_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the index schema.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema_name", value)


@pulumi.type_token("materialize:index/index:Index")
class Index(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 col_exprs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IndexColExprArgs', 'IndexColExprArgsDict']]]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 default: Optional[pulumi.Input[_builtins.bool]] = None,
                 method: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 obj_name: Optional[pulumi.Input[Union['IndexObjNameArgs', 'IndexObjNameArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Indexes represent query results stored in memory.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        loadgen_index = materialize.Index("loadgenIndex",
            cluster_name="cluster",
            method="ARRANGEMENT",
            obj_name={
                "database_name": "database",
                "name": "source",
                "schema_name": "schema",
            })
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Indexes can be imported using the index id:

        ```sh
        $ pulumi import materialize:index/index:Index example_index <region>:<index_id>
        ```

        Index id and information be found in the `mz_catalog.mz_indexes` table

        The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_name: The cluster to maintain this index.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IndexColExprArgs', 'IndexColExprArgsDict']]]] col_exprs: The expressions to use as the key for the index.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.bool] default: Creates a default index using all inferred columns are used. Required if col_expr is not set.
        :param pulumi.Input[_builtins.str] method: The name of the index method to use.
        :param pulumi.Input[_builtins.str] name: The identifier for the index.
        :param pulumi.Input[Union['IndexObjNameArgs', 'IndexObjNameArgsDict']] obj_name: The name of the source, view, or materialized view on which you want to create an index.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IndexArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Indexes represent query results stored in memory.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        loadgen_index = materialize.Index("loadgenIndex",
            cluster_name="cluster",
            method="ARRANGEMENT",
            obj_name={
                "database_name": "database",
                "name": "source",
                "schema_name": "schema",
            })
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Indexes can be imported using the index id:

        ```sh
        $ pulumi import materialize:index/index:Index example_index <region>:<index_id>
        ```

        Index id and information be found in the `mz_catalog.mz_indexes` table

        The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param IndexArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IndexArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 col_exprs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IndexColExprArgs', 'IndexColExprArgsDict']]]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 default: Optional[pulumi.Input[_builtins.bool]] = None,
                 method: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 obj_name: Optional[pulumi.Input[Union['IndexObjNameArgs', 'IndexObjNameArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IndexArgs.__new__(IndexArgs)

            if cluster_name is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_name'")
            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["col_exprs"] = col_exprs
            __props__.__dict__["comment"] = comment
            __props__.__dict__["default"] = default
            __props__.__dict__["method"] = method
            __props__.__dict__["name"] = name
            if obj_name is None and not opts.urn:
                raise TypeError("Missing required property 'obj_name'")
            __props__.__dict__["obj_name"] = obj_name
            __props__.__dict__["region"] = region
            __props__.__dict__["database_name"] = None
            __props__.__dict__["qualified_sql_name"] = None
            __props__.__dict__["schema_name"] = None
        super(Index, __self__).__init__(
            'materialize:index/index:Index',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
            col_exprs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IndexColExprArgs', 'IndexColExprArgsDict']]]]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            database_name: Optional[pulumi.Input[_builtins.str]] = None,
            default: Optional[pulumi.Input[_builtins.bool]] = None,
            method: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            obj_name: Optional[pulumi.Input[Union['IndexObjNameArgs', 'IndexObjNameArgsDict']]] = None,
            qualified_sql_name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            schema_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'Index':
        """
        Get an existing Index resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_name: The cluster to maintain this index.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IndexColExprArgs', 'IndexColExprArgsDict']]]] col_exprs: The expressions to use as the key for the index.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the index database.
        :param pulumi.Input[_builtins.bool] default: Creates a default index using all inferred columns are used. Required if col_expr is not set.
        :param pulumi.Input[_builtins.str] method: The name of the index method to use.
        :param pulumi.Input[_builtins.str] name: The identifier for the index.
        :param pulumi.Input[Union['IndexObjNameArgs', 'IndexObjNameArgsDict']] obj_name: The name of the source, view, or materialized view on which you want to create an index.
        :param pulumi.Input[_builtins.str] qualified_sql_name: The fully qualified name of the index.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the index schema.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IndexState.__new__(_IndexState)

        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["col_exprs"] = col_exprs
        __props__.__dict__["comment"] = comment
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["default"] = default
        __props__.__dict__["method"] = method
        __props__.__dict__["name"] = name
        __props__.__dict__["obj_name"] = obj_name
        __props__.__dict__["qualified_sql_name"] = qualified_sql_name
        __props__.__dict__["region"] = region
        __props__.__dict__["schema_name"] = schema_name
        return Index(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[_builtins.str]:
        """
        The cluster to maintain this index.
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="colExprs")
    def col_exprs(self) -> pulumi.Output[Sequence['outputs.IndexColExpr']]:
        """
        The expressions to use as the key for the index.
        """
        return pulumi.get(self, "col_exprs")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[_builtins.str]:
        """
        The identifier for the index database.
        """
        return pulumi.get(self, "database_name")

    @_builtins.property
    @pulumi.getter
    def default(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Creates a default index using all inferred columns are used. Required if col_expr is not set.
        """
        return pulumi.get(self, "default")

    @_builtins.property
    @pulumi.getter
    def method(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the index method to use.
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The identifier for the index.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="objName")
    def obj_name(self) -> pulumi.Output['outputs.IndexObjName']:
        """
        The name of the source, view, or materialized view on which you want to create an index.
        """
        return pulumi.get(self, "obj_name")

    @_builtins.property
    @pulumi.getter(name="qualifiedSqlName")
    def qualified_sql_name(self) -> pulumi.Output[_builtins.str]:
        """
        The fully qualified name of the index.
        """
        return pulumi.get(self, "qualified_sql_name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> pulumi.Output[_builtins.str]:
        """
        The identifier for the index schema.
        """
        return pulumi.get(self, "schema_name")

