# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkPolicyArgs', 'NetworkPolicy']

@pulumi.input_type
class NetworkPolicyArgs:
    def __init__(__self__, *,
                 rules: pulumi.Input[Sequence[pulumi.Input['NetworkPolicyRuleArgs']]],
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NetworkPolicy resource.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkPolicyRuleArgs']]] rules: Rules for the network policy.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] name: The name of the network policy.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        """
        pulumi.set(__self__, "rules", rules)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Input[Sequence[pulumi.Input['NetworkPolicyRuleArgs']]]:
        """
        Rules for the network policy.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: pulumi.Input[Sequence[pulumi.Input['NetworkPolicyRuleArgs']]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the network policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _NetworkPolicyState:
    def __init__(__self__, *,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyRuleArgs']]]] = None):
        """
        Input properties used for looking up and filtering NetworkPolicy resources.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] name: The name of the network policy.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkPolicyRuleArgs']]] rules: Rules for the network policy.
        """
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the network policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyRuleArgs']]]]:
        """
        Rules for the network policy.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.type_token("materialize:index/networkPolicy:NetworkPolicy")
class NetworkPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkPolicyRuleArgs', 'NetworkPolicyRuleArgsDict']]]]] = None,
                 __props__=None):
        """
        A network policy manages access to the system through IP-based rules.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        office_policy = materialize.NetworkPolicy("officePolicy",
            comment="Network policy for office locations",
            rules=[
                {
                    "action": "allow",
                    "address": "2.3.4.5/32",
                    "direction": "ingress",
                    "name": "minnesota",
                },
                {
                    "action": "allow",
                    "address": "1.2.3.4/28",
                    "direction": "ingress",
                    "name": "new_york",
                },
            ])
        # An initial `default` network policy will be created.
        # This policy allows open access to the environment and can be altered by a `superuser`.
        # Use the `ALTER SYSTEM SET network_policy TO 'office_access_policy'` command.
        # Or the `materialize_system_parameter` resource to set the default network policy.
        system_parameter = materialize.SystemParameter("systemParameter", value="office_access_policy")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Network policies can be imported using the `pulumi import` command.

        ```sh
        $ pulumi import materialize:index/networkPolicy:NetworkPolicy example_network_policy <region>:<network_policy_id>
        ```

        The network_policy_id is the ID of the network policy.

        You can find it from the `mz_internal.mz_network_policy_rules` table in the materialize

        The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] name: The name of the network policy.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkPolicyRuleArgs', 'NetworkPolicyRuleArgsDict']]]] rules: Rules for the network policy.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A network policy manages access to the system through IP-based rules.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        office_policy = materialize.NetworkPolicy("officePolicy",
            comment="Network policy for office locations",
            rules=[
                {
                    "action": "allow",
                    "address": "2.3.4.5/32",
                    "direction": "ingress",
                    "name": "minnesota",
                },
                {
                    "action": "allow",
                    "address": "1.2.3.4/28",
                    "direction": "ingress",
                    "name": "new_york",
                },
            ])
        # An initial `default` network policy will be created.
        # This policy allows open access to the environment and can be altered by a `superuser`.
        # Use the `ALTER SYSTEM SET network_policy TO 'office_access_policy'` command.
        # Or the `materialize_system_parameter` resource to set the default network policy.
        system_parameter = materialize.SystemParameter("systemParameter", value="office_access_policy")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Network policies can be imported using the `pulumi import` command.

        ```sh
        $ pulumi import materialize:index/networkPolicy:NetworkPolicy example_network_policy <region>:<network_policy_id>
        ```

        The network_policy_id is the ID of the network policy.

        You can find it from the `mz_internal.mz_network_policy_rules` table in the materialize

        The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param NetworkPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkPolicyRuleArgs', 'NetworkPolicyRuleArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkPolicyArgs.__new__(NetworkPolicyArgs)

            __props__.__dict__["comment"] = comment
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            if rules is None and not opts.urn:
                raise TypeError("Missing required property 'rules'")
            __props__.__dict__["rules"] = rules
        super(NetworkPolicy, __self__).__init__(
            'materialize:index/networkPolicy:NetworkPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkPolicyRuleArgs', 'NetworkPolicyRuleArgsDict']]]]] = None) -> 'NetworkPolicy':
        """
        Get an existing NetworkPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] name: The name of the network policy.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkPolicyRuleArgs', 'NetworkPolicyRuleArgsDict']]]] rules: Rules for the network policy.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkPolicyState.__new__(_NetworkPolicyState)

        __props__.__dict__["comment"] = comment
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["rules"] = rules
        return NetworkPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the network policy.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Sequence['outputs.NetworkPolicyRule']]:
        """
        Rules for the network policy.
        """
        return pulumi.get(self, "rules")

