# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 base_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 default_region: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 sslmode: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[_builtins.str] base_endpoint: The base endpoint for Materialize.
        :param pulumi.Input[_builtins.str] cloud_endpoint: The endpoint for the Materialize Cloud API.
        :param pulumi.Input[_builtins.str] database: The Materialize database. Can also come from the `MZ_DATABASE` environment variable. Defaults to `materialize`.
        :param pulumi.Input[_builtins.str] default_region: The default region if not specified in the resource
        :param pulumi.Input[_builtins.str] endpoint: The endpoint for the Materialize API.
        :param pulumi.Input[_builtins.str] host: The Materialize host. Can also come from the `MZ_HOST` environment variable.
        :param pulumi.Input[_builtins.str] password: Materialize host. Can also come from the `MZ_PASSWORD` environment variable.
        :param pulumi.Input[_builtins.int] port: The Materialize SQL port. Can also come from the `MZ_PORT` environment variable.
        :param pulumi.Input[_builtins.str] sslmode: For testing purposes, the SSL mode to use.
        :param pulumi.Input[_builtins.str] username: The Materialize username. Can also come from the `MZ_USERNAME` environment variable.
        """
        if base_endpoint is None:
            base_endpoint = _utilities.get_env('MZ_BASE_ENDPOINT')
        if base_endpoint is not None:
            pulumi.set(__self__, "base_endpoint", base_endpoint)
        if cloud_endpoint is None:
            cloud_endpoint = _utilities.get_env('MZ_CLOUD_ENDPOINT')
        if cloud_endpoint is not None:
            pulumi.set(__self__, "cloud_endpoint", cloud_endpoint)
        if database is None:
            database = _utilities.get_env('MZ_DATABASE')
        if database is not None:
            pulumi.set(__self__, "database", database)
        if default_region is None:
            default_region = _utilities.get_env('MZ_DEFAULT_REGION')
        if default_region is not None:
            pulumi.set(__self__, "default_region", default_region)
        if endpoint is None:
            endpoint = _utilities.get_env('MZ_ENDPOINT')
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if password is None:
            password = _utilities.get_env('MZ_PASSWORD')
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if sslmode is None:
            sslmode = _utilities.get_env('MZ_SSLMODE')
        if sslmode is not None:
            pulumi.set(__self__, "sslmode", sslmode)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="baseEndpoint")
    def base_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base endpoint for Materialize.
        """
        return pulumi.get(self, "base_endpoint")

    @base_endpoint.setter
    def base_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "base_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="cloudEndpoint")
    def cloud_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The endpoint for the Materialize Cloud API.
        """
        return pulumi.get(self, "cloud_endpoint")

    @cloud_endpoint.setter
    def cloud_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Materialize database. Can also come from the `MZ_DATABASE` environment variable. Defaults to `materialize`.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter(name="defaultRegion")
    def default_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default region if not specified in the resource
        """
        return pulumi.get(self, "default_region")

    @default_region.setter
    def default_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_region", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The endpoint for the Materialize API.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Materialize host. Can also come from the `MZ_HOST` environment variable.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Materialize host. Can also come from the `MZ_PASSWORD` environment variable.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The Materialize SQL port. Can also come from the `MZ_PORT` environment variable.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def sslmode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        For testing purposes, the SSL mode to use.
        """
        return pulumi.get(self, "sslmode")

    @sslmode.setter
    def sslmode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sslmode", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Materialize username. Can also come from the `MZ_USERNAME` environment variable.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.type_token("pulumi:providers:materialize")
class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 default_region: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 sslmode: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The provider type for the materialize package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] base_endpoint: The base endpoint for Materialize.
        :param pulumi.Input[_builtins.str] cloud_endpoint: The endpoint for the Materialize Cloud API.
        :param pulumi.Input[_builtins.str] database: The Materialize database. Can also come from the `MZ_DATABASE` environment variable. Defaults to `materialize`.
        :param pulumi.Input[_builtins.str] default_region: The default region if not specified in the resource
        :param pulumi.Input[_builtins.str] endpoint: The endpoint for the Materialize API.
        :param pulumi.Input[_builtins.str] host: The Materialize host. Can also come from the `MZ_HOST` environment variable.
        :param pulumi.Input[_builtins.str] password: Materialize host. Can also come from the `MZ_PASSWORD` environment variable.
        :param pulumi.Input[_builtins.int] port: The Materialize SQL port. Can also come from the `MZ_PORT` environment variable.
        :param pulumi.Input[_builtins.str] sslmode: For testing purposes, the SSL mode to use.
        :param pulumi.Input[_builtins.str] username: The Materialize username. Can also come from the `MZ_USERNAME` environment variable.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the materialize package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 default_region: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 sslmode: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            if base_endpoint is None:
                base_endpoint = _utilities.get_env('MZ_BASE_ENDPOINT')
            __props__.__dict__["base_endpoint"] = base_endpoint
            if cloud_endpoint is None:
                cloud_endpoint = _utilities.get_env('MZ_CLOUD_ENDPOINT')
            __props__.__dict__["cloud_endpoint"] = cloud_endpoint
            if database is None:
                database = _utilities.get_env('MZ_DATABASE')
            __props__.__dict__["database"] = database
            if default_region is None:
                default_region = _utilities.get_env('MZ_DEFAULT_REGION')
            __props__.__dict__["default_region"] = default_region
            if endpoint is None:
                endpoint = _utilities.get_env('MZ_ENDPOINT')
            __props__.__dict__["endpoint"] = endpoint
            __props__.__dict__["host"] = host
            if password is None:
                password = _utilities.get_env('MZ_PASSWORD')
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["port"] = pulumi.Output.from_input(port).apply(pulumi.runtime.to_json) if port is not None else None
            if sslmode is None:
                sslmode = _utilities.get_env('MZ_SSLMODE')
            __props__.__dict__["sslmode"] = sslmode
            __props__.__dict__["username"] = username
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Provider, __self__).__init__(
            'materialize',
            resource_name,
            __props__,
            opts)

    @_builtins.property
    @pulumi.getter(name="baseEndpoint")
    def base_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The base endpoint for Materialize.
        """
        return pulumi.get(self, "base_endpoint")

    @_builtins.property
    @pulumi.getter(name="cloudEndpoint")
    def cloud_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The endpoint for the Materialize Cloud API.
        """
        return pulumi.get(self, "cloud_endpoint")

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Materialize database. Can also come from the `MZ_DATABASE` environment variable. Defaults to `materialize`.
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter(name="defaultRegion")
    def default_region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The default region if not specified in the resource
        """
        return pulumi.get(self, "default_region")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The endpoint for the Materialize API.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter
    def host(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Materialize host. Can also come from the `MZ_HOST` environment variable.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Materialize host. Can also come from the `MZ_PASSWORD` environment variable.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def sslmode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        For testing purposes, the SSL mode to use.
        """
        return pulumi.get(self, "sslmode")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Materialize username. Can also come from the `MZ_USERNAME` environment variable.
        """
        return pulumi.get(self, "username")

    @pulumi.output_type
    class TerraformConfigResult:
        def __init__(__self__, result=None):
            if result and not isinstance(result, dict):
                raise TypeError("Expected argument 'result' to be a dict")
            pulumi.set(__self__, "result", result)

        @_builtins.property
        @pulumi.getter
        def result(self) -> Mapping[str, Any]:
            return pulumi.get(self, "result")

    def terraform_config(__self__) -> pulumi.Output['Provider.TerraformConfigResult']:
        """
        This function returns a Terraform config object with terraform-namecased keys,to be used with the Terraform Module Provider.
        """
        __args__ = dict()
        __args__['__self__'] = __self__
        return pulumi.runtime.call('pulumi:providers:materialize/terraformConfig', __args__, res=__self__, typ=Provider.TerraformConfigResult)

