# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['RoleParameterArgs', 'RoleParameter']

@pulumi.input_type
class RoleParameterArgs:
    def __init__(__self__, *,
                 role_name: pulumi.Input[_builtins.str],
                 variable_name: pulumi.Input[_builtins.str],
                 variable_value: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RoleParameter resource.
        :param pulumi.Input[_builtins.str] role_name: The name of the role to grant privilege to.
        :param pulumi.Input[_builtins.str] variable_name: The name of the session variable to modify.
        :param pulumi.Input[_builtins.str] variable_value: The value to assign to the session variable.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        """
        pulumi.set(__self__, "role_name", role_name)
        pulumi.set(__self__, "variable_name", variable_name)
        pulumi.set(__self__, "variable_value", variable_value)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the role to grant privilege to.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role_name", value)

    @_builtins.property
    @pulumi.getter(name="variableName")
    def variable_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the session variable to modify.
        """
        return pulumi.get(self, "variable_name")

    @variable_name.setter
    def variable_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "variable_name", value)

    @_builtins.property
    @pulumi.getter(name="variableValue")
    def variable_value(self) -> pulumi.Input[_builtins.str]:
        """
        The value to assign to the session variable.
        """
        return pulumi.get(self, "variable_value")

    @variable_value.setter
    def variable_value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "variable_value", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _RoleParameterState:
    def __init__(__self__, *,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 variable_name: Optional[pulumi.Input[_builtins.str]] = None,
                 variable_value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RoleParameter resources.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] role_name: The name of the role to grant privilege to.
        :param pulumi.Input[_builtins.str] variable_name: The name of the session variable to modify.
        :param pulumi.Input[_builtins.str] variable_value: The value to assign to the session variable.
        """
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if variable_name is not None:
            pulumi.set(__self__, "variable_name", variable_name)
        if variable_value is not None:
            pulumi.set(__self__, "variable_value", variable_value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the role to grant privilege to.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_name", value)

    @_builtins.property
    @pulumi.getter(name="variableName")
    def variable_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the session variable to modify.
        """
        return pulumi.get(self, "variable_name")

    @variable_name.setter
    def variable_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "variable_name", value)

    @_builtins.property
    @pulumi.getter(name="variableValue")
    def variable_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value to assign to the session variable.
        """
        return pulumi.get(self, "variable_value")

    @variable_value.setter
    def variable_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "variable_value", value)


@pulumi.type_token("materialize:index/roleParameter:RoleParameter")
class RoleParameter(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 variable_name: Optional[pulumi.Input[_builtins.str]] = None,
                 variable_value: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a system parameter in Materialize.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        # ALTER ROLE some_role SET transaction_isolation = 'strict serializable';
        example_role = materialize.Role("exampleRole")
        example_role_parameter = materialize.RoleParameter("exampleRoleParameter",
            role_name=example_role.name,
            variable_name="transaction_isolation",
            variable_value="strict serializable")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] role_name: The name of the role to grant privilege to.
        :param pulumi.Input[_builtins.str] variable_name: The name of the session variable to modify.
        :param pulumi.Input[_builtins.str] variable_value: The value to assign to the session variable.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RoleParameterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a system parameter in Materialize.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        # ALTER ROLE some_role SET transaction_isolation = 'strict serializable';
        example_role = materialize.Role("exampleRole")
        example_role_parameter = materialize.RoleParameter("exampleRoleParameter",
            role_name=example_role.name,
            variable_name="transaction_isolation",
            variable_value="strict serializable")
        ```

        :param str resource_name: The name of the resource.
        :param RoleParameterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RoleParameterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 variable_name: Optional[pulumi.Input[_builtins.str]] = None,
                 variable_value: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RoleParameterArgs.__new__(RoleParameterArgs)

            __props__.__dict__["region"] = region
            if role_name is None and not opts.urn:
                raise TypeError("Missing required property 'role_name'")
            __props__.__dict__["role_name"] = role_name
            if variable_name is None and not opts.urn:
                raise TypeError("Missing required property 'variable_name'")
            __props__.__dict__["variable_name"] = variable_name
            if variable_value is None and not opts.urn:
                raise TypeError("Missing required property 'variable_value'")
            __props__.__dict__["variable_value"] = variable_value
        super(RoleParameter, __self__).__init__(
            'materialize:index/roleParameter:RoleParameter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            role_name: Optional[pulumi.Input[_builtins.str]] = None,
            variable_name: Optional[pulumi.Input[_builtins.str]] = None,
            variable_value: Optional[pulumi.Input[_builtins.str]] = None) -> 'RoleParameter':
        """
        Get an existing RoleParameter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] role_name: The name of the role to grant privilege to.
        :param pulumi.Input[_builtins.str] variable_name: The name of the session variable to modify.
        :param pulumi.Input[_builtins.str] variable_value: The value to assign to the session variable.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RoleParameterState.__new__(_RoleParameterState)

        __props__.__dict__["region"] = region
        __props__.__dict__["role_name"] = role_name
        __props__.__dict__["variable_name"] = variable_name
        __props__.__dict__["variable_value"] = variable_value
        return RoleParameter(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the role to grant privilege to.
        """
        return pulumi.get(self, "role_name")

    @_builtins.property
    @pulumi.getter(name="variableName")
    def variable_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the session variable to modify.
        """
        return pulumi.get(self, "variable_name")

    @_builtins.property
    @pulumi.getter(name="variableValue")
    def variable_value(self) -> pulumi.Output[_builtins.str]:
        """
        The value to assign to the session variable.
        """
        return pulumi.get(self, "variable_value")

