# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['SCIM2ConfigurationArgs', 'SCIM2Configuration']

@pulumi.input_type
class SCIM2ConfigurationArgs:
    def __init__(__self__, *,
                 connection_name: pulumi.Input[_builtins.str],
                 source: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a SCIM2Configuration resource.
        :param pulumi.Input[_builtins.str] connection_name: The name of the SCIM 2.0 connection. It must be unique.
        :param pulumi.Input[_builtins.str] source: The source of the SCIM 2.0 configuration. Supported values are `okta`, `azure-ad`, and `other`.
        """
        pulumi.set(__self__, "connection_name", connection_name)
        pulumi.set(__self__, "source", source)

    @_builtins.property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the SCIM 2.0 connection. It must be unique.
        """
        return pulumi.get(self, "connection_name")

    @connection_name.setter
    def connection_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "connection_name", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Input[_builtins.str]:
        """
        The source of the SCIM 2.0 configuration. Supported values are `okta`, `azure-ad`, and `other`.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class _SCIM2ConfigurationState:
    def __init__(__self__, *,
                 connection_name: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioning_url: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_to_user_management: Optional[pulumi.Input[_builtins.bool]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SCIM2Configuration resources.
        :param pulumi.Input[_builtins.str] connection_name: The name of the SCIM 2.0 connection. It must be unique.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the SCIM 2.0 configuration.
        :param pulumi.Input[_builtins.str] provisioning_url: The provisioning URL of the SCIM 2.0 configuration.
        :param pulumi.Input[_builtins.str] source: The source of the SCIM 2.0 configuration. Supported values are `okta`, `azure-ad`, and `other`.
        :param pulumi.Input[_builtins.bool] sync_to_user_management: Indicates whether automatic synchronization of data with the IdP is enabled, ensuring that changes in details or status in the IdP are updated accordingly.
        :param pulumi.Input[_builtins.str] token: The token of the SCIM 2.0 configuration.
        """
        if connection_name is not None:
            pulumi.set(__self__, "connection_name", connection_name)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if provisioning_url is not None:
            pulumi.set(__self__, "provisioning_url", provisioning_url)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if sync_to_user_management is not None:
            pulumi.set(__self__, "sync_to_user_management", sync_to_user_management)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @_builtins.property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the SCIM 2.0 connection. It must be unique.
        """
        return pulumi.get(self, "connection_name")

    @connection_name.setter
    def connection_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_name", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation timestamp of the SCIM 2.0 configuration.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="provisioningUrl")
    def provisioning_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The provisioning URL of the SCIM 2.0 configuration.
        """
        return pulumi.get(self, "provisioning_url")

    @provisioning_url.setter
    def provisioning_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provisioning_url", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source of the SCIM 2.0 configuration. Supported values are `okta`, `azure-ad`, and `other`.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter(name="syncToUserManagement")
    def sync_to_user_management(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether automatic synchronization of data with the IdP is enabled, ensuring that changes in details or status in the IdP are updated accordingly.
        """
        return pulumi.get(self, "sync_to_user_management")

    @sync_to_user_management.setter
    def sync_to_user_management(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sync_to_user_management", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The token of the SCIM 2.0 configuration.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token", value)


@pulumi.type_token("materialize:index/sCIM2Configuration:SCIM2Configuration")
class SCIM2Configuration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The SCIM 2.0 configurations resource allows you to create, read, and delete the SCIM 2.0 configurations.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        # Create a SCIM config
        example_scim_config = materialize.SCIM2Configuration("exampleScimConfig",
            connection_name="example_connection",
            source="okta")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Retrieve the SCIM Configuration ID using the materialize_scim_configs data source

        Example of using the data source in your configuration:

        data "materialize_scim_configs" "all" {}

        output "scim_config_output" {

            value = data.materialize_scim_configs.all

        }

        The ID can be retrieved using the following command:

        terraform output scim_config_output

        Import command:

        ```sh
        $ pulumi import materialize:index/sCIM2Configuration:SCIM2Configuration example_scim_config <scim_config_id>
        ```

        Note: Replace <scim_config_id> with the actual ID of your SCIM configuration

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] connection_name: The name of the SCIM 2.0 connection. It must be unique.
        :param pulumi.Input[_builtins.str] source: The source of the SCIM 2.0 configuration. Supported values are `okta`, `azure-ad`, and `other`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SCIM2ConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The SCIM 2.0 configurations resource allows you to create, read, and delete the SCIM 2.0 configurations.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        # Create a SCIM config
        example_scim_config = materialize.SCIM2Configuration("exampleScimConfig",
            connection_name="example_connection",
            source="okta")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Retrieve the SCIM Configuration ID using the materialize_scim_configs data source

        Example of using the data source in your configuration:

        data "materialize_scim_configs" "all" {}

        output "scim_config_output" {

            value = data.materialize_scim_configs.all

        }

        The ID can be retrieved using the following command:

        terraform output scim_config_output

        Import command:

        ```sh
        $ pulumi import materialize:index/sCIM2Configuration:SCIM2Configuration example_scim_config <scim_config_id>
        ```

        Note: Replace <scim_config_id> with the actual ID of your SCIM configuration

        :param str resource_name: The name of the resource.
        :param SCIM2ConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SCIM2ConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SCIM2ConfigurationArgs.__new__(SCIM2ConfigurationArgs)

            if connection_name is None and not opts.urn:
                raise TypeError("Missing required property 'connection_name'")
            __props__.__dict__["connection_name"] = connection_name
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
            __props__.__dict__["created_at"] = None
            __props__.__dict__["provisioning_url"] = None
            __props__.__dict__["sync_to_user_management"] = None
            __props__.__dict__["tenant_id"] = None
            __props__.__dict__["token"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["provisioningUrl", "token"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(SCIM2Configuration, __self__).__init__(
            'materialize:index/sCIM2Configuration:SCIM2Configuration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connection_name: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            provisioning_url: Optional[pulumi.Input[_builtins.str]] = None,
            source: Optional[pulumi.Input[_builtins.str]] = None,
            sync_to_user_management: Optional[pulumi.Input[_builtins.bool]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
            token: Optional[pulumi.Input[_builtins.str]] = None) -> 'SCIM2Configuration':
        """
        Get an existing SCIM2Configuration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] connection_name: The name of the SCIM 2.0 connection. It must be unique.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the SCIM 2.0 configuration.
        :param pulumi.Input[_builtins.str] provisioning_url: The provisioning URL of the SCIM 2.0 configuration.
        :param pulumi.Input[_builtins.str] source: The source of the SCIM 2.0 configuration. Supported values are `okta`, `azure-ad`, and `other`.
        :param pulumi.Input[_builtins.bool] sync_to_user_management: Indicates whether automatic synchronization of data with the IdP is enabled, ensuring that changes in details or status in the IdP are updated accordingly.
        :param pulumi.Input[_builtins.str] token: The token of the SCIM 2.0 configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SCIM2ConfigurationState.__new__(_SCIM2ConfigurationState)

        __props__.__dict__["connection_name"] = connection_name
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["provisioning_url"] = provisioning_url
        __props__.__dict__["source"] = source
        __props__.__dict__["sync_to_user_management"] = sync_to_user_management
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["token"] = token
        return SCIM2Configuration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the SCIM 2.0 connection. It must be unique.
        """
        return pulumi.get(self, "connection_name")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation timestamp of the SCIM 2.0 configuration.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="provisioningUrl")
    def provisioning_url(self) -> pulumi.Output[_builtins.str]:
        """
        The provisioning URL of the SCIM 2.0 configuration.
        """
        return pulumi.get(self, "provisioning_url")

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Output[_builtins.str]:
        """
        The source of the SCIM 2.0 configuration. Supported values are `okta`, `azure-ad`, and `other`.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="syncToUserManagement")
    def sync_to_user_management(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether automatic synchronization of data with the IdP is enabled, ensuring that changes in details or status in the IdP are updated accordingly.
        """
        return pulumi.get(self, "sync_to_user_management")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter
    def token(self) -> pulumi.Output[_builtins.str]:
        """
        The token of the SCIM 2.0 configuration.
        """
        return pulumi.get(self, "token")

