# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['SCIM2GroupArgs', 'SCIM2Group']

@pulumi.input_type
class SCIM2GroupArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SCIM2Group resource.
        :param pulumi.Input[_builtins.str] description: A description of the SCIM group.
        :param pulumi.Input[_builtins.str] name: The name of the SCIM group.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the SCIM group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the SCIM group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _SCIM2GroupState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SCIM2Group resources.
        :param pulumi.Input[_builtins.str] description: A description of the SCIM group.
        :param pulumi.Input[_builtins.str] name: The name of the SCIM group.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the SCIM group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the SCIM group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("materialize:index/sCIM2Group:SCIM2Group")
class SCIM2Group(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The SCIM group resource allows you to manage user groups in Frontegg.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        # Create a SCIM group
        example_scim_group = materialize.SCIM2Group("exampleScimGroup", description="Example SCIM group")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Retrieve the SCIM Group ID using the materialize_scim_groups data source

        Example of using the data source in your configuration:

        data "materialize_scim_groups" "all" {}

        output "scim_group_output" {

            value = data.materialize_scim_groups.all

        }

        The ID can be retrieved using the following command:

        terraform output scim_group_output

        Import command:

        ```sh
        $ pulumi import materialize:index/sCIM2Group:SCIM2Group example_scim_group <scim_group_id>
        ```

        Note: Replace <scim_group_id> with the SCIM Group ID retrieved

        using the materialize_scim_groups data source.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A description of the SCIM group.
        :param pulumi.Input[_builtins.str] name: The name of the SCIM group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SCIM2GroupArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The SCIM group resource allows you to manage user groups in Frontegg.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        # Create a SCIM group
        example_scim_group = materialize.SCIM2Group("exampleScimGroup", description="Example SCIM group")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Retrieve the SCIM Group ID using the materialize_scim_groups data source

        Example of using the data source in your configuration:

        data "materialize_scim_groups" "all" {}

        output "scim_group_output" {

            value = data.materialize_scim_groups.all

        }

        The ID can be retrieved using the following command:

        terraform output scim_group_output

        Import command:

        ```sh
        $ pulumi import materialize:index/sCIM2Group:SCIM2Group example_scim_group <scim_group_id>
        ```

        Note: Replace <scim_group_id> with the SCIM Group ID retrieved

        using the materialize_scim_groups data source.

        :param str resource_name: The name of the resource.
        :param SCIM2GroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SCIM2GroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SCIM2GroupArgs.__new__(SCIM2GroupArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
        super(SCIM2Group, __self__).__init__(
            'materialize:index/sCIM2Group:SCIM2Group',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'SCIM2Group':
        """
        Get an existing SCIM2Group resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A description of the SCIM group.
        :param pulumi.Input[_builtins.str] name: The name of the SCIM group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SCIM2GroupState.__new__(_SCIM2GroupState)

        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        return SCIM2Group(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A description of the SCIM group.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the SCIM group.
        """
        return pulumi.get(self, "name")

