# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['SCIM2GroupRolesArgs', 'SCIM2GroupRoles']

@pulumi.input_type
class SCIM2GroupRolesArgs:
    def __init__(__self__, *,
                 group_id: pulumi.Input[_builtins.str],
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a SCIM2GroupRoles resource.
        :param pulumi.Input[_builtins.str] group_id: The ID of the SCIM group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] roles: The set of role names to assign to the SCIM group.
        """
        pulumi.set(__self__, "group_id", group_id)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the SCIM group.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The set of role names to assign to the SCIM group.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "roles", value)


@pulumi.input_type
class _SCIM2GroupRolesState:
    def __init__(__self__, *,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering SCIM2GroupRoles resources.
        :param pulumi.Input[_builtins.str] group_id: The ID of the SCIM group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] roles: The set of role names to assign to the SCIM group.
        """
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the SCIM group.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The set of role names to assign to the SCIM group.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "roles", value)


@pulumi.type_token("materialize:index/sCIM2GroupRoles:SCIM2GroupRoles")
class SCIM2GroupRoles(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        The materialize_scim_group_role resource allows managing roles within a SCIM group in Frontegg.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        # Create a SCIM group role
        scim_group_example = materialize.SCIM2Group("scimGroupExample", description="scim_group_example")
        scim_group_roles_example = materialize.SCIM2GroupRoles("scimGroupRolesExample",
            group_id=scim_group_example.id,
            roles=[
                "Admin",
                "Member",
            ])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Retrieve the SCIM Group ID using the materialize_scim_groups data source

        Example of using the data source in your configuration:

        data "materialize_scim_groups" "all" {}

        output "scim_group_output" {

            value = data.materialize_scim_groups.all

        }

        The ID can be retrieved using the following command:

        terraform output scim_group_output

        Import command:

        ```sh
        $ pulumi import materialize:index/sCIM2GroupRoles:SCIM2GroupRoles example_scim_group_roles <scim_group_id>
        ```

        Note: Replace <scim_group_id> with the SCIM Group ID retrieved

        using the materialize_scim_groups data source.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] group_id: The ID of the SCIM group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] roles: The set of role names to assign to the SCIM group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SCIM2GroupRolesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The materialize_scim_group_role resource allows managing roles within a SCIM group in Frontegg.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        # Create a SCIM group role
        scim_group_example = materialize.SCIM2Group("scimGroupExample", description="scim_group_example")
        scim_group_roles_example = materialize.SCIM2GroupRoles("scimGroupRolesExample",
            group_id=scim_group_example.id,
            roles=[
                "Admin",
                "Member",
            ])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Retrieve the SCIM Group ID using the materialize_scim_groups data source

        Example of using the data source in your configuration:

        data "materialize_scim_groups" "all" {}

        output "scim_group_output" {

            value = data.materialize_scim_groups.all

        }

        The ID can be retrieved using the following command:

        terraform output scim_group_output

        Import command:

        ```sh
        $ pulumi import materialize:index/sCIM2GroupRoles:SCIM2GroupRoles example_scim_group_roles <scim_group_id>
        ```

        Note: Replace <scim_group_id> with the SCIM Group ID retrieved

        using the materialize_scim_groups data source.

        :param str resource_name: The name of the resource.
        :param SCIM2GroupRolesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SCIM2GroupRolesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SCIM2GroupRolesArgs.__new__(SCIM2GroupRolesArgs)

            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            __props__.__dict__["roles"] = roles
        super(SCIM2GroupRoles, __self__).__init__(
            'materialize:index/sCIM2GroupRoles:SCIM2GroupRoles',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            group_id: Optional[pulumi.Input[_builtins.str]] = None,
            roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'SCIM2GroupRoles':
        """
        Get an existing SCIM2GroupRoles resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] group_id: The ID of the SCIM group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] roles: The set of role names to assign to the SCIM group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SCIM2GroupRolesState.__new__(_SCIM2GroupRolesState)

        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["roles"] = roles
        return SCIM2GroupRoles(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the SCIM group.
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter
    def roles(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The set of role names to assign to the SCIM group.
        """
        return pulumi.get(self, "roles")

