# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['SCIM2GroupUsersArgs', 'SCIM2GroupUsers']

@pulumi.input_type
class SCIM2GroupUsersArgs:
    def __init__(__self__, *,
                 group_id: pulumi.Input[_builtins.str],
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a SCIM2GroupUsers resource.
        :param pulumi.Input[_builtins.str] group_id: The ID of the SCIM group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] users: The set of user IDs to assign to the SCIM group.
        """
        pulumi.set(__self__, "group_id", group_id)
        if users is not None:
            pulumi.set(__self__, "users", users)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the SCIM group.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The set of user IDs to assign to the SCIM group.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "users", value)


@pulumi.input_type
class _SCIM2GroupUsersState:
    def __init__(__self__, *,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering SCIM2GroupUsers resources.
        :param pulumi.Input[_builtins.str] group_id: The ID of the SCIM group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] users: The set of user IDs to assign to the SCIM group.
        """
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if users is not None:
            pulumi.set(__self__, "users", users)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the SCIM group.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The set of user IDs to assign to the SCIM group.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "users", value)


@pulumi.type_token("materialize:index/sCIM2GroupUsers:SCIM2GroupUsers")
class SCIM2GroupUsers(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        The SCIM2GroupUsers resource allows managing users within a SCIM group in Frontegg.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        # Create a SCIM group users resource
        example_users1 = materialize.User("exampleUsers1",
            email="example-user1@example.com",
            roles=["Member"])
        example_users2 = materialize.User("exampleUsers2",
            email="example-user2@example.com",
            roles=["Member"])
        example_scim_group_users = materialize.SCIM2GroupUsers("exampleScimGroupUsers",
            group_id=materialize_scim_group["example_scim_group"]["id"],
            users=[
                example_users1.id,
                example_users2.id,
            ])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Retrieve the SCIM Group ID using the materialize_scim_groups data source

        Example of using the data source in your configuration:

        data "materialize_scim_groups" "all" {}

        output "scim_group_output" {

            value = data.materialize_scim_groups.all

        }

        The ID can be retrieved using the following command:

        terraform output scim_group_output

        Import command:

        ```sh
        $ pulumi import materialize:index/sCIM2GroupUsers:SCIM2GroupUsers example_scim_group_user <scim_group_id>
        ```

        Note: Replace <scim_group_id> with the SCIM Group ID retrieved

        using the materialize_scim_groups data source.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] group_id: The ID of the SCIM group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] users: The set of user IDs to assign to the SCIM group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SCIM2GroupUsersArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The SCIM2GroupUsers resource allows managing users within a SCIM group in Frontegg.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        # Create a SCIM group users resource
        example_users1 = materialize.User("exampleUsers1",
            email="example-user1@example.com",
            roles=["Member"])
        example_users2 = materialize.User("exampleUsers2",
            email="example-user2@example.com",
            roles=["Member"])
        example_scim_group_users = materialize.SCIM2GroupUsers("exampleScimGroupUsers",
            group_id=materialize_scim_group["example_scim_group"]["id"],
            users=[
                example_users1.id,
                example_users2.id,
            ])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Retrieve the SCIM Group ID using the materialize_scim_groups data source

        Example of using the data source in your configuration:

        data "materialize_scim_groups" "all" {}

        output "scim_group_output" {

            value = data.materialize_scim_groups.all

        }

        The ID can be retrieved using the following command:

        terraform output scim_group_output

        Import command:

        ```sh
        $ pulumi import materialize:index/sCIM2GroupUsers:SCIM2GroupUsers example_scim_group_user <scim_group_id>
        ```

        Note: Replace <scim_group_id> with the SCIM Group ID retrieved

        using the materialize_scim_groups data source.

        :param str resource_name: The name of the resource.
        :param SCIM2GroupUsersArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SCIM2GroupUsersArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SCIM2GroupUsersArgs.__new__(SCIM2GroupUsersArgs)

            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            __props__.__dict__["users"] = users
        super(SCIM2GroupUsers, __self__).__init__(
            'materialize:index/sCIM2GroupUsers:SCIM2GroupUsers',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            group_id: Optional[pulumi.Input[_builtins.str]] = None,
            users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'SCIM2GroupUsers':
        """
        Get an existing SCIM2GroupUsers resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] group_id: The ID of the SCIM group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] users: The set of user IDs to assign to the SCIM group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SCIM2GroupUsersState.__new__(_SCIM2GroupUsersState)

        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["users"] = users
        return SCIM2GroupUsers(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the SCIM group.
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter
    def users(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The set of user IDs to assign to the SCIM group.
        """
        return pulumi.get(self, "users")

