# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SourceKafkaArgs', 'SourceKafka']

@pulumi.input_type
class SourceKafkaArgs:
    def __init__(__self__, *,
                 kafka_connection: pulumi.Input['SourceKafkaKafkaConnectionArgs'],
                 topic: pulumi.Input[_builtins.str],
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 envelope: Optional[pulumi.Input['SourceKafkaEnvelopeArgs']] = None,
                 expose_progress: Optional[pulumi.Input['SourceKafkaExposeProgressArgs']] = None,
                 format: Optional[pulumi.Input['SourceKafkaFormatArgs']] = None,
                 include_headers: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_headers_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 include_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_key_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 include_offset: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_offset_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 include_partition: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_partition_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 include_timestamp: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_timestamp_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 key_format: Optional[pulumi.Input['SourceKafkaKeyFormatArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 start_offsets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 start_timestamp: Optional[pulumi.Input[_builtins.int]] = None,
                 value_format: Optional[pulumi.Input['SourceKafkaValueFormatArgs']] = None):
        """
        The set of arguments for constructing a SourceKafka resource.
        :param pulumi.Input['SourceKafkaKafkaConnectionArgs'] kafka_connection: The Kafka connection to use in the source.
        :param pulumi.Input[_builtins.str] topic: The Kafka topic you want to subscribe to.
        :param pulumi.Input[_builtins.str] cluster_name: The cluster to maintain this source.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the source database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input['SourceKafkaEnvelopeArgs'] envelope: How Materialize should interpret records (e.g. append-only, upsert)..
        :param pulumi.Input['SourceKafkaExposeProgressArgs'] expose_progress: The name of the progress collection for the source. If this is not specified, the collection will be named `<src_name>_progress`.
        :param pulumi.Input['SourceKafkaFormatArgs'] format: How to decode raw bytes from different formats into data structures Materialize can understand at runtime.
        :param pulumi.Input[_builtins.bool] include_headers: Include message headers.
        :param pulumi.Input[_builtins.str] include_headers_alias: Provide an alias for the headers column.
        :param pulumi.Input[_builtins.bool] include_key: Include a column containing the Kafka message key.
        :param pulumi.Input[_builtins.str] include_key_alias: Provide an alias for the key column.
        :param pulumi.Input[_builtins.bool] include_offset: Include an offset column containing the Kafka message offset.
        :param pulumi.Input[_builtins.str] include_offset_alias: Provide an alias for the offset column.
        :param pulumi.Input[_builtins.bool] include_partition: Include a partition column containing the Kafka message partition
        :param pulumi.Input[_builtins.str] include_partition_alias: Provide an alias for the partition column.
        :param pulumi.Input[_builtins.bool] include_timestamp: Include a timestamp column containing the Kafka message timestamp.
        :param pulumi.Input[_builtins.str] include_timestamp_alias: Provide an alias for the timestamp column.
        :param pulumi.Input['SourceKafkaKeyFormatArgs'] key_format: Set the key format explicitly.
        :param pulumi.Input[_builtins.str] name: The identifier for the source.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the source schema in Materialize. Defaults to `public`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] start_offsets: Read partitions from the specified offset.
        :param pulumi.Input[_builtins.int] start_timestamp: Use the specified value to set `START OFFSET` based on the Kafka timestamp.
        :param pulumi.Input['SourceKafkaValueFormatArgs'] value_format: Set the value format explicitly.
        """
        pulumi.set(__self__, "kafka_connection", kafka_connection)
        pulumi.set(__self__, "topic", topic)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if envelope is not None:
            pulumi.set(__self__, "envelope", envelope)
        if expose_progress is not None:
            pulumi.set(__self__, "expose_progress", expose_progress)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if include_headers is not None:
            pulumi.set(__self__, "include_headers", include_headers)
        if include_headers_alias is not None:
            pulumi.set(__self__, "include_headers_alias", include_headers_alias)
        if include_key is not None:
            pulumi.set(__self__, "include_key", include_key)
        if include_key_alias is not None:
            pulumi.set(__self__, "include_key_alias", include_key_alias)
        if include_offset is not None:
            pulumi.set(__self__, "include_offset", include_offset)
        if include_offset_alias is not None:
            pulumi.set(__self__, "include_offset_alias", include_offset_alias)
        if include_partition is not None:
            pulumi.set(__self__, "include_partition", include_partition)
        if include_partition_alias is not None:
            pulumi.set(__self__, "include_partition_alias", include_partition_alias)
        if include_timestamp is not None:
            pulumi.set(__self__, "include_timestamp", include_timestamp)
        if include_timestamp_alias is not None:
            pulumi.set(__self__, "include_timestamp_alias", include_timestamp_alias)
        if key_format is not None:
            pulumi.set(__self__, "key_format", key_format)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ownership_role is not None:
            pulumi.set(__self__, "ownership_role", ownership_role)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if start_offsets is not None:
            pulumi.set(__self__, "start_offsets", start_offsets)
        if start_timestamp is not None:
            pulumi.set(__self__, "start_timestamp", start_timestamp)
        if value_format is not None:
            pulumi.set(__self__, "value_format", value_format)

    @_builtins.property
    @pulumi.getter(name="kafkaConnection")
    def kafka_connection(self) -> pulumi.Input['SourceKafkaKafkaConnectionArgs']:
        """
        The Kafka connection to use in the source.
        """
        return pulumi.get(self, "kafka_connection")

    @kafka_connection.setter
    def kafka_connection(self, value: pulumi.Input['SourceKafkaKafkaConnectionArgs']):
        pulumi.set(self, "kafka_connection", value)

    @_builtins.property
    @pulumi.getter
    def topic(self) -> pulumi.Input[_builtins.str]:
        """
        The Kafka topic you want to subscribe to.
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "topic", value)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster to maintain this source.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the source database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter
    def envelope(self) -> Optional[pulumi.Input['SourceKafkaEnvelopeArgs']]:
        """
        How Materialize should interpret records (e.g. append-only, upsert)..
        """
        return pulumi.get(self, "envelope")

    @envelope.setter
    def envelope(self, value: Optional[pulumi.Input['SourceKafkaEnvelopeArgs']]):
        pulumi.set(self, "envelope", value)

    @_builtins.property
    @pulumi.getter(name="exposeProgress")
    def expose_progress(self) -> Optional[pulumi.Input['SourceKafkaExposeProgressArgs']]:
        """
        The name of the progress collection for the source. If this is not specified, the collection will be named `<src_name>_progress`.
        """
        return pulumi.get(self, "expose_progress")

    @expose_progress.setter
    def expose_progress(self, value: Optional[pulumi.Input['SourceKafkaExposeProgressArgs']]):
        pulumi.set(self, "expose_progress", value)

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input['SourceKafkaFormatArgs']]:
        """
        How to decode raw bytes from different formats into data structures Materialize can understand at runtime.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input['SourceKafkaFormatArgs']]):
        pulumi.set(self, "format", value)

    @_builtins.property
    @pulumi.getter(name="includeHeaders")
    def include_headers(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Include message headers.
        """
        return pulumi.get(self, "include_headers")

    @include_headers.setter
    def include_headers(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_headers", value)

    @_builtins.property
    @pulumi.getter(name="includeHeadersAlias")
    def include_headers_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provide an alias for the headers column.
        """
        return pulumi.get(self, "include_headers_alias")

    @include_headers_alias.setter
    def include_headers_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "include_headers_alias", value)

    @_builtins.property
    @pulumi.getter(name="includeKey")
    def include_key(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Include a column containing the Kafka message key.
        """
        return pulumi.get(self, "include_key")

    @include_key.setter
    def include_key(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_key", value)

    @_builtins.property
    @pulumi.getter(name="includeKeyAlias")
    def include_key_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provide an alias for the key column.
        """
        return pulumi.get(self, "include_key_alias")

    @include_key_alias.setter
    def include_key_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "include_key_alias", value)

    @_builtins.property
    @pulumi.getter(name="includeOffset")
    def include_offset(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Include an offset column containing the Kafka message offset.
        """
        return pulumi.get(self, "include_offset")

    @include_offset.setter
    def include_offset(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_offset", value)

    @_builtins.property
    @pulumi.getter(name="includeOffsetAlias")
    def include_offset_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provide an alias for the offset column.
        """
        return pulumi.get(self, "include_offset_alias")

    @include_offset_alias.setter
    def include_offset_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "include_offset_alias", value)

    @_builtins.property
    @pulumi.getter(name="includePartition")
    def include_partition(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Include a partition column containing the Kafka message partition
        """
        return pulumi.get(self, "include_partition")

    @include_partition.setter
    def include_partition(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_partition", value)

    @_builtins.property
    @pulumi.getter(name="includePartitionAlias")
    def include_partition_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provide an alias for the partition column.
        """
        return pulumi.get(self, "include_partition_alias")

    @include_partition_alias.setter
    def include_partition_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "include_partition_alias", value)

    @_builtins.property
    @pulumi.getter(name="includeTimestamp")
    def include_timestamp(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Include a timestamp column containing the Kafka message timestamp.
        """
        return pulumi.get(self, "include_timestamp")

    @include_timestamp.setter
    def include_timestamp(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_timestamp", value)

    @_builtins.property
    @pulumi.getter(name="includeTimestampAlias")
    def include_timestamp_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provide an alias for the timestamp column.
        """
        return pulumi.get(self, "include_timestamp_alias")

    @include_timestamp_alias.setter
    def include_timestamp_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "include_timestamp_alias", value)

    @_builtins.property
    @pulumi.getter(name="keyFormat")
    def key_format(self) -> Optional[pulumi.Input['SourceKafkaKeyFormatArgs']]:
        """
        Set the key format explicitly.
        """
        return pulumi.get(self, "key_format")

    @key_format.setter
    def key_format(self, value: Optional[pulumi.Input['SourceKafkaKeyFormatArgs']]):
        pulumi.set(self, "key_format", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the source.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @ownership_role.setter
    def ownership_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ownership_role", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the source schema in Materialize. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema_name", value)

    @_builtins.property
    @pulumi.getter(name="startOffsets")
    def start_offsets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        Read partitions from the specified offset.
        """
        return pulumi.get(self, "start_offsets")

    @start_offsets.setter
    def start_offsets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "start_offsets", value)

    @_builtins.property
    @pulumi.getter(name="startTimestamp")
    def start_timestamp(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Use the specified value to set `START OFFSET` based on the Kafka timestamp.
        """
        return pulumi.get(self, "start_timestamp")

    @start_timestamp.setter
    def start_timestamp(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "start_timestamp", value)

    @_builtins.property
    @pulumi.getter(name="valueFormat")
    def value_format(self) -> Optional[pulumi.Input['SourceKafkaValueFormatArgs']]:
        """
        Set the value format explicitly.
        """
        return pulumi.get(self, "value_format")

    @value_format.setter
    def value_format(self, value: Optional[pulumi.Input['SourceKafkaValueFormatArgs']]):
        pulumi.set(self, "value_format", value)


@pulumi.input_type
class _SourceKafkaState:
    def __init__(__self__, *,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 envelope: Optional[pulumi.Input['SourceKafkaEnvelopeArgs']] = None,
                 expose_progress: Optional[pulumi.Input['SourceKafkaExposeProgressArgs']] = None,
                 format: Optional[pulumi.Input['SourceKafkaFormatArgs']] = None,
                 include_headers: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_headers_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 include_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_key_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 include_offset: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_offset_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 include_partition: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_partition_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 include_timestamp: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_timestamp_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 kafka_connection: Optional[pulumi.Input['SourceKafkaKafkaConnectionArgs']] = None,
                 key_format: Optional[pulumi.Input['SourceKafkaKeyFormatArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 qualified_sql_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.str]] = None,
                 start_offsets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 start_timestamp: Optional[pulumi.Input[_builtins.int]] = None,
                 topic: Optional[pulumi.Input[_builtins.str]] = None,
                 value_format: Optional[pulumi.Input['SourceKafkaValueFormatArgs']] = None):
        """
        Input properties used for looking up and filtering SourceKafka resources.
        :param pulumi.Input[_builtins.str] cluster_name: The cluster to maintain this source.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the source database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input['SourceKafkaEnvelopeArgs'] envelope: How Materialize should interpret records (e.g. append-only, upsert)..
        :param pulumi.Input['SourceKafkaExposeProgressArgs'] expose_progress: The name of the progress collection for the source. If this is not specified, the collection will be named `<src_name>_progress`.
        :param pulumi.Input['SourceKafkaFormatArgs'] format: How to decode raw bytes from different formats into data structures Materialize can understand at runtime.
        :param pulumi.Input[_builtins.bool] include_headers: Include message headers.
        :param pulumi.Input[_builtins.str] include_headers_alias: Provide an alias for the headers column.
        :param pulumi.Input[_builtins.bool] include_key: Include a column containing the Kafka message key.
        :param pulumi.Input[_builtins.str] include_key_alias: Provide an alias for the key column.
        :param pulumi.Input[_builtins.bool] include_offset: Include an offset column containing the Kafka message offset.
        :param pulumi.Input[_builtins.str] include_offset_alias: Provide an alias for the offset column.
        :param pulumi.Input[_builtins.bool] include_partition: Include a partition column containing the Kafka message partition
        :param pulumi.Input[_builtins.str] include_partition_alias: Provide an alias for the partition column.
        :param pulumi.Input[_builtins.bool] include_timestamp: Include a timestamp column containing the Kafka message timestamp.
        :param pulumi.Input[_builtins.str] include_timestamp_alias: Provide an alias for the timestamp column.
        :param pulumi.Input['SourceKafkaKafkaConnectionArgs'] kafka_connection: The Kafka connection to use in the source.
        :param pulumi.Input['SourceKafkaKeyFormatArgs'] key_format: Set the key format explicitly.
        :param pulumi.Input[_builtins.str] name: The identifier for the source.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input[_builtins.str] qualified_sql_name: The fully qualified name of the source.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the source schema in Materialize. Defaults to `public`.
        :param pulumi.Input[_builtins.str] size: The size of the cluster maintaining this source.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] start_offsets: Read partitions from the specified offset.
        :param pulumi.Input[_builtins.int] start_timestamp: Use the specified value to set `START OFFSET` based on the Kafka timestamp.
        :param pulumi.Input[_builtins.str] topic: The Kafka topic you want to subscribe to.
        :param pulumi.Input['SourceKafkaValueFormatArgs'] value_format: Set the value format explicitly.
        """
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if envelope is not None:
            pulumi.set(__self__, "envelope", envelope)
        if expose_progress is not None:
            pulumi.set(__self__, "expose_progress", expose_progress)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if include_headers is not None:
            pulumi.set(__self__, "include_headers", include_headers)
        if include_headers_alias is not None:
            pulumi.set(__self__, "include_headers_alias", include_headers_alias)
        if include_key is not None:
            pulumi.set(__self__, "include_key", include_key)
        if include_key_alias is not None:
            pulumi.set(__self__, "include_key_alias", include_key_alias)
        if include_offset is not None:
            pulumi.set(__self__, "include_offset", include_offset)
        if include_offset_alias is not None:
            pulumi.set(__self__, "include_offset_alias", include_offset_alias)
        if include_partition is not None:
            pulumi.set(__self__, "include_partition", include_partition)
        if include_partition_alias is not None:
            pulumi.set(__self__, "include_partition_alias", include_partition_alias)
        if include_timestamp is not None:
            pulumi.set(__self__, "include_timestamp", include_timestamp)
        if include_timestamp_alias is not None:
            pulumi.set(__self__, "include_timestamp_alias", include_timestamp_alias)
        if kafka_connection is not None:
            pulumi.set(__self__, "kafka_connection", kafka_connection)
        if key_format is not None:
            pulumi.set(__self__, "key_format", key_format)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ownership_role is not None:
            pulumi.set(__self__, "ownership_role", ownership_role)
        if qualified_sql_name is not None:
            pulumi.set(__self__, "qualified_sql_name", qualified_sql_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if start_offsets is not None:
            pulumi.set(__self__, "start_offsets", start_offsets)
        if start_timestamp is not None:
            pulumi.set(__self__, "start_timestamp", start_timestamp)
        if topic is not None:
            pulumi.set(__self__, "topic", topic)
        if value_format is not None:
            pulumi.set(__self__, "value_format", value_format)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster to maintain this source.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the source database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter
    def envelope(self) -> Optional[pulumi.Input['SourceKafkaEnvelopeArgs']]:
        """
        How Materialize should interpret records (e.g. append-only, upsert)..
        """
        return pulumi.get(self, "envelope")

    @envelope.setter
    def envelope(self, value: Optional[pulumi.Input['SourceKafkaEnvelopeArgs']]):
        pulumi.set(self, "envelope", value)

    @_builtins.property
    @pulumi.getter(name="exposeProgress")
    def expose_progress(self) -> Optional[pulumi.Input['SourceKafkaExposeProgressArgs']]:
        """
        The name of the progress collection for the source. If this is not specified, the collection will be named `<src_name>_progress`.
        """
        return pulumi.get(self, "expose_progress")

    @expose_progress.setter
    def expose_progress(self, value: Optional[pulumi.Input['SourceKafkaExposeProgressArgs']]):
        pulumi.set(self, "expose_progress", value)

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input['SourceKafkaFormatArgs']]:
        """
        How to decode raw bytes from different formats into data structures Materialize can understand at runtime.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input['SourceKafkaFormatArgs']]):
        pulumi.set(self, "format", value)

    @_builtins.property
    @pulumi.getter(name="includeHeaders")
    def include_headers(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Include message headers.
        """
        return pulumi.get(self, "include_headers")

    @include_headers.setter
    def include_headers(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_headers", value)

    @_builtins.property
    @pulumi.getter(name="includeHeadersAlias")
    def include_headers_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provide an alias for the headers column.
        """
        return pulumi.get(self, "include_headers_alias")

    @include_headers_alias.setter
    def include_headers_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "include_headers_alias", value)

    @_builtins.property
    @pulumi.getter(name="includeKey")
    def include_key(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Include a column containing the Kafka message key.
        """
        return pulumi.get(self, "include_key")

    @include_key.setter
    def include_key(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_key", value)

    @_builtins.property
    @pulumi.getter(name="includeKeyAlias")
    def include_key_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provide an alias for the key column.
        """
        return pulumi.get(self, "include_key_alias")

    @include_key_alias.setter
    def include_key_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "include_key_alias", value)

    @_builtins.property
    @pulumi.getter(name="includeOffset")
    def include_offset(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Include an offset column containing the Kafka message offset.
        """
        return pulumi.get(self, "include_offset")

    @include_offset.setter
    def include_offset(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_offset", value)

    @_builtins.property
    @pulumi.getter(name="includeOffsetAlias")
    def include_offset_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provide an alias for the offset column.
        """
        return pulumi.get(self, "include_offset_alias")

    @include_offset_alias.setter
    def include_offset_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "include_offset_alias", value)

    @_builtins.property
    @pulumi.getter(name="includePartition")
    def include_partition(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Include a partition column containing the Kafka message partition
        """
        return pulumi.get(self, "include_partition")

    @include_partition.setter
    def include_partition(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_partition", value)

    @_builtins.property
    @pulumi.getter(name="includePartitionAlias")
    def include_partition_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provide an alias for the partition column.
        """
        return pulumi.get(self, "include_partition_alias")

    @include_partition_alias.setter
    def include_partition_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "include_partition_alias", value)

    @_builtins.property
    @pulumi.getter(name="includeTimestamp")
    def include_timestamp(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Include a timestamp column containing the Kafka message timestamp.
        """
        return pulumi.get(self, "include_timestamp")

    @include_timestamp.setter
    def include_timestamp(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_timestamp", value)

    @_builtins.property
    @pulumi.getter(name="includeTimestampAlias")
    def include_timestamp_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provide an alias for the timestamp column.
        """
        return pulumi.get(self, "include_timestamp_alias")

    @include_timestamp_alias.setter
    def include_timestamp_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "include_timestamp_alias", value)

    @_builtins.property
    @pulumi.getter(name="kafkaConnection")
    def kafka_connection(self) -> Optional[pulumi.Input['SourceKafkaKafkaConnectionArgs']]:
        """
        The Kafka connection to use in the source.
        """
        return pulumi.get(self, "kafka_connection")

    @kafka_connection.setter
    def kafka_connection(self, value: Optional[pulumi.Input['SourceKafkaKafkaConnectionArgs']]):
        pulumi.set(self, "kafka_connection", value)

    @_builtins.property
    @pulumi.getter(name="keyFormat")
    def key_format(self) -> Optional[pulumi.Input['SourceKafkaKeyFormatArgs']]:
        """
        Set the key format explicitly.
        """
        return pulumi.get(self, "key_format")

    @key_format.setter
    def key_format(self, value: Optional[pulumi.Input['SourceKafkaKeyFormatArgs']]):
        pulumi.set(self, "key_format", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the source.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @ownership_role.setter
    def ownership_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ownership_role", value)

    @_builtins.property
    @pulumi.getter(name="qualifiedSqlName")
    def qualified_sql_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified name of the source.
        """
        return pulumi.get(self, "qualified_sql_name")

    @qualified_sql_name.setter
    def qualified_sql_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "qualified_sql_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the source schema in Materialize. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema_name", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The size of the cluster maintaining this source.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter(name="startOffsets")
    def start_offsets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        Read partitions from the specified offset.
        """
        return pulumi.get(self, "start_offsets")

    @start_offsets.setter
    def start_offsets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "start_offsets", value)

    @_builtins.property
    @pulumi.getter(name="startTimestamp")
    def start_timestamp(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Use the specified value to set `START OFFSET` based on the Kafka timestamp.
        """
        return pulumi.get(self, "start_timestamp")

    @start_timestamp.setter
    def start_timestamp(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "start_timestamp", value)

    @_builtins.property
    @pulumi.getter
    def topic(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Kafka topic you want to subscribe to.
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "topic", value)

    @_builtins.property
    @pulumi.getter(name="valueFormat")
    def value_format(self) -> Optional[pulumi.Input['SourceKafkaValueFormatArgs']]:
        """
        Set the value format explicitly.
        """
        return pulumi.get(self, "value_format")

    @value_format.setter
    def value_format(self, value: Optional[pulumi.Input['SourceKafkaValueFormatArgs']]):
        pulumi.set(self, "value_format", value)


@pulumi.type_token("materialize:index/sourceKafka:SourceKafka")
class SourceKafka(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 envelope: Optional[pulumi.Input[Union['SourceKafkaEnvelopeArgs', 'SourceKafkaEnvelopeArgsDict']]] = None,
                 expose_progress: Optional[pulumi.Input[Union['SourceKafkaExposeProgressArgs', 'SourceKafkaExposeProgressArgsDict']]] = None,
                 format: Optional[pulumi.Input[Union['SourceKafkaFormatArgs', 'SourceKafkaFormatArgsDict']]] = None,
                 include_headers: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_headers_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 include_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_key_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 include_offset: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_offset_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 include_partition: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_partition_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 include_timestamp: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_timestamp_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 kafka_connection: Optional[pulumi.Input[Union['SourceKafkaKafkaConnectionArgs', 'SourceKafkaKafkaConnectionArgsDict']]] = None,
                 key_format: Optional[pulumi.Input[Union['SourceKafkaKeyFormatArgs', 'SourceKafkaKeyFormatArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 start_offsets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 start_timestamp: Optional[pulumi.Input[_builtins.int]] = None,
                 topic: Optional[pulumi.Input[_builtins.str]] = None,
                 value_format: Optional[pulumi.Input[Union['SourceKafkaValueFormatArgs', 'SourceKafkaValueFormatArgsDict']]] = None,
                 __props__=None):
        """
        A Kafka source describes a Kafka cluster you want Materialize to read data from.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        example_source_kafka = materialize.SourceKafka("exampleSourceKafka",
            cluster_name="quickstart",
            envelope={
                "none": True,
            },
            format={
                "avro": {
                    "schema_registry_connection": {
                        "database_name": "database",
                        "name": "csr_connection",
                        "schema_name": "schema",
                    },
                },
            },
            kafka_connection={
                "database_name": "database",
                "name": "kafka_connection",
                "schema_name": "schema",
            },
            schema_name="schema")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Sources can be imported using the source id:

        ```sh
        $ pulumi import materialize:index/sourceKafka:SourceKafka example_source_kafka <region>:<source_id>
        ```

        Source id and information be found in the `mz_catalog.mz_sources` table

        The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_name: The cluster to maintain this source.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the source database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[Union['SourceKafkaEnvelopeArgs', 'SourceKafkaEnvelopeArgsDict']] envelope: How Materialize should interpret records (e.g. append-only, upsert)..
        :param pulumi.Input[Union['SourceKafkaExposeProgressArgs', 'SourceKafkaExposeProgressArgsDict']] expose_progress: The name of the progress collection for the source. If this is not specified, the collection will be named `<src_name>_progress`.
        :param pulumi.Input[Union['SourceKafkaFormatArgs', 'SourceKafkaFormatArgsDict']] format: How to decode raw bytes from different formats into data structures Materialize can understand at runtime.
        :param pulumi.Input[_builtins.bool] include_headers: Include message headers.
        :param pulumi.Input[_builtins.str] include_headers_alias: Provide an alias for the headers column.
        :param pulumi.Input[_builtins.bool] include_key: Include a column containing the Kafka message key.
        :param pulumi.Input[_builtins.str] include_key_alias: Provide an alias for the key column.
        :param pulumi.Input[_builtins.bool] include_offset: Include an offset column containing the Kafka message offset.
        :param pulumi.Input[_builtins.str] include_offset_alias: Provide an alias for the offset column.
        :param pulumi.Input[_builtins.bool] include_partition: Include a partition column containing the Kafka message partition
        :param pulumi.Input[_builtins.str] include_partition_alias: Provide an alias for the partition column.
        :param pulumi.Input[_builtins.bool] include_timestamp: Include a timestamp column containing the Kafka message timestamp.
        :param pulumi.Input[_builtins.str] include_timestamp_alias: Provide an alias for the timestamp column.
        :param pulumi.Input[Union['SourceKafkaKafkaConnectionArgs', 'SourceKafkaKafkaConnectionArgsDict']] kafka_connection: The Kafka connection to use in the source.
        :param pulumi.Input[Union['SourceKafkaKeyFormatArgs', 'SourceKafkaKeyFormatArgsDict']] key_format: Set the key format explicitly.
        :param pulumi.Input[_builtins.str] name: The identifier for the source.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the source schema in Materialize. Defaults to `public`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] start_offsets: Read partitions from the specified offset.
        :param pulumi.Input[_builtins.int] start_timestamp: Use the specified value to set `START OFFSET` based on the Kafka timestamp.
        :param pulumi.Input[_builtins.str] topic: The Kafka topic you want to subscribe to.
        :param pulumi.Input[Union['SourceKafkaValueFormatArgs', 'SourceKafkaValueFormatArgsDict']] value_format: Set the value format explicitly.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SourceKafkaArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Kafka source describes a Kafka cluster you want Materialize to read data from.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        example_source_kafka = materialize.SourceKafka("exampleSourceKafka",
            cluster_name="quickstart",
            envelope={
                "none": True,
            },
            format={
                "avro": {
                    "schema_registry_connection": {
                        "database_name": "database",
                        "name": "csr_connection",
                        "schema_name": "schema",
                    },
                },
            },
            kafka_connection={
                "database_name": "database",
                "name": "kafka_connection",
                "schema_name": "schema",
            },
            schema_name="schema")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Sources can be imported using the source id:

        ```sh
        $ pulumi import materialize:index/sourceKafka:SourceKafka example_source_kafka <region>:<source_id>
        ```

        Source id and information be found in the `mz_catalog.mz_sources` table

        The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param SourceKafkaArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SourceKafkaArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 envelope: Optional[pulumi.Input[Union['SourceKafkaEnvelopeArgs', 'SourceKafkaEnvelopeArgsDict']]] = None,
                 expose_progress: Optional[pulumi.Input[Union['SourceKafkaExposeProgressArgs', 'SourceKafkaExposeProgressArgsDict']]] = None,
                 format: Optional[pulumi.Input[Union['SourceKafkaFormatArgs', 'SourceKafkaFormatArgsDict']]] = None,
                 include_headers: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_headers_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 include_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_key_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 include_offset: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_offset_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 include_partition: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_partition_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 include_timestamp: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_timestamp_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 kafka_connection: Optional[pulumi.Input[Union['SourceKafkaKafkaConnectionArgs', 'SourceKafkaKafkaConnectionArgsDict']]] = None,
                 key_format: Optional[pulumi.Input[Union['SourceKafkaKeyFormatArgs', 'SourceKafkaKeyFormatArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 start_offsets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 start_timestamp: Optional[pulumi.Input[_builtins.int]] = None,
                 topic: Optional[pulumi.Input[_builtins.str]] = None,
                 value_format: Optional[pulumi.Input[Union['SourceKafkaValueFormatArgs', 'SourceKafkaValueFormatArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SourceKafkaArgs.__new__(SourceKafkaArgs)

            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["comment"] = comment
            __props__.__dict__["database_name"] = database_name
            __props__.__dict__["envelope"] = envelope
            __props__.__dict__["expose_progress"] = expose_progress
            __props__.__dict__["format"] = format
            __props__.__dict__["include_headers"] = include_headers
            __props__.__dict__["include_headers_alias"] = include_headers_alias
            __props__.__dict__["include_key"] = include_key
            __props__.__dict__["include_key_alias"] = include_key_alias
            __props__.__dict__["include_offset"] = include_offset
            __props__.__dict__["include_offset_alias"] = include_offset_alias
            __props__.__dict__["include_partition"] = include_partition
            __props__.__dict__["include_partition_alias"] = include_partition_alias
            __props__.__dict__["include_timestamp"] = include_timestamp
            __props__.__dict__["include_timestamp_alias"] = include_timestamp_alias
            if kafka_connection is None and not opts.urn:
                raise TypeError("Missing required property 'kafka_connection'")
            __props__.__dict__["kafka_connection"] = kafka_connection
            __props__.__dict__["key_format"] = key_format
            __props__.__dict__["name"] = name
            __props__.__dict__["ownership_role"] = ownership_role
            __props__.__dict__["region"] = region
            __props__.__dict__["schema_name"] = schema_name
            __props__.__dict__["start_offsets"] = start_offsets
            __props__.__dict__["start_timestamp"] = start_timestamp
            if topic is None and not opts.urn:
                raise TypeError("Missing required property 'topic'")
            __props__.__dict__["topic"] = topic
            __props__.__dict__["value_format"] = value_format
            __props__.__dict__["qualified_sql_name"] = None
            __props__.__dict__["size"] = None
        super(SourceKafka, __self__).__init__(
            'materialize:index/sourceKafka:SourceKafka',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            database_name: Optional[pulumi.Input[_builtins.str]] = None,
            envelope: Optional[pulumi.Input[Union['SourceKafkaEnvelopeArgs', 'SourceKafkaEnvelopeArgsDict']]] = None,
            expose_progress: Optional[pulumi.Input[Union['SourceKafkaExposeProgressArgs', 'SourceKafkaExposeProgressArgsDict']]] = None,
            format: Optional[pulumi.Input[Union['SourceKafkaFormatArgs', 'SourceKafkaFormatArgsDict']]] = None,
            include_headers: Optional[pulumi.Input[_builtins.bool]] = None,
            include_headers_alias: Optional[pulumi.Input[_builtins.str]] = None,
            include_key: Optional[pulumi.Input[_builtins.bool]] = None,
            include_key_alias: Optional[pulumi.Input[_builtins.str]] = None,
            include_offset: Optional[pulumi.Input[_builtins.bool]] = None,
            include_offset_alias: Optional[pulumi.Input[_builtins.str]] = None,
            include_partition: Optional[pulumi.Input[_builtins.bool]] = None,
            include_partition_alias: Optional[pulumi.Input[_builtins.str]] = None,
            include_timestamp: Optional[pulumi.Input[_builtins.bool]] = None,
            include_timestamp_alias: Optional[pulumi.Input[_builtins.str]] = None,
            kafka_connection: Optional[pulumi.Input[Union['SourceKafkaKafkaConnectionArgs', 'SourceKafkaKafkaConnectionArgsDict']]] = None,
            key_format: Optional[pulumi.Input[Union['SourceKafkaKeyFormatArgs', 'SourceKafkaKeyFormatArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
            qualified_sql_name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            schema_name: Optional[pulumi.Input[_builtins.str]] = None,
            size: Optional[pulumi.Input[_builtins.str]] = None,
            start_offsets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
            start_timestamp: Optional[pulumi.Input[_builtins.int]] = None,
            topic: Optional[pulumi.Input[_builtins.str]] = None,
            value_format: Optional[pulumi.Input[Union['SourceKafkaValueFormatArgs', 'SourceKafkaValueFormatArgsDict']]] = None) -> 'SourceKafka':
        """
        Get an existing SourceKafka resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_name: The cluster to maintain this source.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the source database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[Union['SourceKafkaEnvelopeArgs', 'SourceKafkaEnvelopeArgsDict']] envelope: How Materialize should interpret records (e.g. append-only, upsert)..
        :param pulumi.Input[Union['SourceKafkaExposeProgressArgs', 'SourceKafkaExposeProgressArgsDict']] expose_progress: The name of the progress collection for the source. If this is not specified, the collection will be named `<src_name>_progress`.
        :param pulumi.Input[Union['SourceKafkaFormatArgs', 'SourceKafkaFormatArgsDict']] format: How to decode raw bytes from different formats into data structures Materialize can understand at runtime.
        :param pulumi.Input[_builtins.bool] include_headers: Include message headers.
        :param pulumi.Input[_builtins.str] include_headers_alias: Provide an alias for the headers column.
        :param pulumi.Input[_builtins.bool] include_key: Include a column containing the Kafka message key.
        :param pulumi.Input[_builtins.str] include_key_alias: Provide an alias for the key column.
        :param pulumi.Input[_builtins.bool] include_offset: Include an offset column containing the Kafka message offset.
        :param pulumi.Input[_builtins.str] include_offset_alias: Provide an alias for the offset column.
        :param pulumi.Input[_builtins.bool] include_partition: Include a partition column containing the Kafka message partition
        :param pulumi.Input[_builtins.str] include_partition_alias: Provide an alias for the partition column.
        :param pulumi.Input[_builtins.bool] include_timestamp: Include a timestamp column containing the Kafka message timestamp.
        :param pulumi.Input[_builtins.str] include_timestamp_alias: Provide an alias for the timestamp column.
        :param pulumi.Input[Union['SourceKafkaKafkaConnectionArgs', 'SourceKafkaKafkaConnectionArgsDict']] kafka_connection: The Kafka connection to use in the source.
        :param pulumi.Input[Union['SourceKafkaKeyFormatArgs', 'SourceKafkaKeyFormatArgsDict']] key_format: Set the key format explicitly.
        :param pulumi.Input[_builtins.str] name: The identifier for the source.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input[_builtins.str] qualified_sql_name: The fully qualified name of the source.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the source schema in Materialize. Defaults to `public`.
        :param pulumi.Input[_builtins.str] size: The size of the cluster maintaining this source.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] start_offsets: Read partitions from the specified offset.
        :param pulumi.Input[_builtins.int] start_timestamp: Use the specified value to set `START OFFSET` based on the Kafka timestamp.
        :param pulumi.Input[_builtins.str] topic: The Kafka topic you want to subscribe to.
        :param pulumi.Input[Union['SourceKafkaValueFormatArgs', 'SourceKafkaValueFormatArgsDict']] value_format: Set the value format explicitly.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SourceKafkaState.__new__(_SourceKafkaState)

        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["comment"] = comment
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["envelope"] = envelope
        __props__.__dict__["expose_progress"] = expose_progress
        __props__.__dict__["format"] = format
        __props__.__dict__["include_headers"] = include_headers
        __props__.__dict__["include_headers_alias"] = include_headers_alias
        __props__.__dict__["include_key"] = include_key
        __props__.__dict__["include_key_alias"] = include_key_alias
        __props__.__dict__["include_offset"] = include_offset
        __props__.__dict__["include_offset_alias"] = include_offset_alias
        __props__.__dict__["include_partition"] = include_partition
        __props__.__dict__["include_partition_alias"] = include_partition_alias
        __props__.__dict__["include_timestamp"] = include_timestamp
        __props__.__dict__["include_timestamp_alias"] = include_timestamp_alias
        __props__.__dict__["kafka_connection"] = kafka_connection
        __props__.__dict__["key_format"] = key_format
        __props__.__dict__["name"] = name
        __props__.__dict__["ownership_role"] = ownership_role
        __props__.__dict__["qualified_sql_name"] = qualified_sql_name
        __props__.__dict__["region"] = region
        __props__.__dict__["schema_name"] = schema_name
        __props__.__dict__["size"] = size
        __props__.__dict__["start_offsets"] = start_offsets
        __props__.__dict__["start_timestamp"] = start_timestamp
        __props__.__dict__["topic"] = topic
        __props__.__dict__["value_format"] = value_format
        return SourceKafka(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[_builtins.str]:
        """
        The cluster to maintain this source.
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The identifier for the source database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @_builtins.property
    @pulumi.getter
    def envelope(self) -> pulumi.Output[Optional['outputs.SourceKafkaEnvelope']]:
        """
        How Materialize should interpret records (e.g. append-only, upsert)..
        """
        return pulumi.get(self, "envelope")

    @_builtins.property
    @pulumi.getter(name="exposeProgress")
    def expose_progress(self) -> pulumi.Output[Optional['outputs.SourceKafkaExposeProgress']]:
        """
        The name of the progress collection for the source. If this is not specified, the collection will be named `<src_name>_progress`.
        """
        return pulumi.get(self, "expose_progress")

    @_builtins.property
    @pulumi.getter
    def format(self) -> pulumi.Output[Optional['outputs.SourceKafkaFormat']]:
        """
        How to decode raw bytes from different formats into data structures Materialize can understand at runtime.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter(name="includeHeaders")
    def include_headers(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Include message headers.
        """
        return pulumi.get(self, "include_headers")

    @_builtins.property
    @pulumi.getter(name="includeHeadersAlias")
    def include_headers_alias(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Provide an alias for the headers column.
        """
        return pulumi.get(self, "include_headers_alias")

    @_builtins.property
    @pulumi.getter(name="includeKey")
    def include_key(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Include a column containing the Kafka message key.
        """
        return pulumi.get(self, "include_key")

    @_builtins.property
    @pulumi.getter(name="includeKeyAlias")
    def include_key_alias(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Provide an alias for the key column.
        """
        return pulumi.get(self, "include_key_alias")

    @_builtins.property
    @pulumi.getter(name="includeOffset")
    def include_offset(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Include an offset column containing the Kafka message offset.
        """
        return pulumi.get(self, "include_offset")

    @_builtins.property
    @pulumi.getter(name="includeOffsetAlias")
    def include_offset_alias(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Provide an alias for the offset column.
        """
        return pulumi.get(self, "include_offset_alias")

    @_builtins.property
    @pulumi.getter(name="includePartition")
    def include_partition(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Include a partition column containing the Kafka message partition
        """
        return pulumi.get(self, "include_partition")

    @_builtins.property
    @pulumi.getter(name="includePartitionAlias")
    def include_partition_alias(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Provide an alias for the partition column.
        """
        return pulumi.get(self, "include_partition_alias")

    @_builtins.property
    @pulumi.getter(name="includeTimestamp")
    def include_timestamp(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Include a timestamp column containing the Kafka message timestamp.
        """
        return pulumi.get(self, "include_timestamp")

    @_builtins.property
    @pulumi.getter(name="includeTimestampAlias")
    def include_timestamp_alias(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Provide an alias for the timestamp column.
        """
        return pulumi.get(self, "include_timestamp_alias")

    @_builtins.property
    @pulumi.getter(name="kafkaConnection")
    def kafka_connection(self) -> pulumi.Output['outputs.SourceKafkaKafkaConnection']:
        """
        The Kafka connection to use in the source.
        """
        return pulumi.get(self, "kafka_connection")

    @_builtins.property
    @pulumi.getter(name="keyFormat")
    def key_format(self) -> pulumi.Output[Optional['outputs.SourceKafkaKeyFormat']]:
        """
        Set the key format explicitly.
        """
        return pulumi.get(self, "key_format")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The identifier for the source.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> pulumi.Output[_builtins.str]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @_builtins.property
    @pulumi.getter(name="qualifiedSqlName")
    def qualified_sql_name(self) -> pulumi.Output[_builtins.str]:
        """
        The fully qualified name of the source.
        """
        return pulumi.get(self, "qualified_sql_name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The identifier for the source schema in Materialize. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Output[_builtins.str]:
        """
        The size of the cluster maintaining this source.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="startOffsets")
    def start_offsets(self) -> pulumi.Output[Optional[Sequence[_builtins.int]]]:
        """
        Read partitions from the specified offset.
        """
        return pulumi.get(self, "start_offsets")

    @_builtins.property
    @pulumi.getter(name="startTimestamp")
    def start_timestamp(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Use the specified value to set `START OFFSET` based on the Kafka timestamp.
        """
        return pulumi.get(self, "start_timestamp")

    @_builtins.property
    @pulumi.getter
    def topic(self) -> pulumi.Output[_builtins.str]:
        """
        The Kafka topic you want to subscribe to.
        """
        return pulumi.get(self, "topic")

    @_builtins.property
    @pulumi.getter(name="valueFormat")
    def value_format(self) -> pulumi.Output[Optional['outputs.SourceKafkaValueFormat']]:
        """
        Set the value format explicitly.
        """
        return pulumi.get(self, "value_format")

