# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SourceLoadgenArgs', 'SourceLoadgen']

@pulumi.input_type
class SourceLoadgenArgs:
    def __init__(__self__, *,
                 load_generator_type: pulumi.Input[_builtins.str],
                 auction_options: Optional[pulumi.Input['SourceLoadgenAuctionOptionsArgs']] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 expose_progress: Optional[pulumi.Input['SourceLoadgenExposeProgressArgs']] = None,
                 marketing_options: Optional[pulumi.Input['SourceLoadgenMarketingOptionsArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tpch_options: Optional[pulumi.Input['SourceLoadgenTpchOptionsArgs']] = None):
        """
        The set of arguments for constructing a SourceLoadgen resource.
        :param pulumi.Input[_builtins.str] load_generator_type: The load generator types: [AUCTION MARKETING TPCH].
        :param pulumi.Input['SourceLoadgenAuctionOptionsArgs'] auction_options: Auction Options.
        :param pulumi.Input[_builtins.str] cluster_name: The cluster to maintain this source.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the source database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input['SourceLoadgenExposeProgressArgs'] expose_progress: The name of the progress collection for the source. If this is not specified, the collection will be named `<src_name>_progress`.
        :param pulumi.Input['SourceLoadgenMarketingOptionsArgs'] marketing_options: Marketing Options.
        :param pulumi.Input[_builtins.str] name: The identifier for the source.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the source schema in Materialize. Defaults to `public`.
        :param pulumi.Input['SourceLoadgenTpchOptionsArgs'] tpch_options: TPCH Options.
        """
        pulumi.set(__self__, "load_generator_type", load_generator_type)
        if auction_options is not None:
            pulumi.set(__self__, "auction_options", auction_options)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if expose_progress is not None:
            pulumi.set(__self__, "expose_progress", expose_progress)
        if marketing_options is not None:
            pulumi.set(__self__, "marketing_options", marketing_options)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ownership_role is not None:
            pulumi.set(__self__, "ownership_role", ownership_role)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if tpch_options is not None:
            pulumi.set(__self__, "tpch_options", tpch_options)

    @_builtins.property
    @pulumi.getter(name="loadGeneratorType")
    def load_generator_type(self) -> pulumi.Input[_builtins.str]:
        """
        The load generator types: [AUCTION MARKETING TPCH].
        """
        return pulumi.get(self, "load_generator_type")

    @load_generator_type.setter
    def load_generator_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "load_generator_type", value)

    @_builtins.property
    @pulumi.getter(name="auctionOptions")
    def auction_options(self) -> Optional[pulumi.Input['SourceLoadgenAuctionOptionsArgs']]:
        """
        Auction Options.
        """
        return pulumi.get(self, "auction_options")

    @auction_options.setter
    def auction_options(self, value: Optional[pulumi.Input['SourceLoadgenAuctionOptionsArgs']]):
        pulumi.set(self, "auction_options", value)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster to maintain this source.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the source database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter(name="exposeProgress")
    def expose_progress(self) -> Optional[pulumi.Input['SourceLoadgenExposeProgressArgs']]:
        """
        The name of the progress collection for the source. If this is not specified, the collection will be named `<src_name>_progress`.
        """
        return pulumi.get(self, "expose_progress")

    @expose_progress.setter
    def expose_progress(self, value: Optional[pulumi.Input['SourceLoadgenExposeProgressArgs']]):
        pulumi.set(self, "expose_progress", value)

    @_builtins.property
    @pulumi.getter(name="marketingOptions")
    def marketing_options(self) -> Optional[pulumi.Input['SourceLoadgenMarketingOptionsArgs']]:
        """
        Marketing Options.
        """
        return pulumi.get(self, "marketing_options")

    @marketing_options.setter
    def marketing_options(self, value: Optional[pulumi.Input['SourceLoadgenMarketingOptionsArgs']]):
        pulumi.set(self, "marketing_options", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the source.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @ownership_role.setter
    def ownership_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ownership_role", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the source schema in Materialize. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema_name", value)

    @_builtins.property
    @pulumi.getter(name="tpchOptions")
    def tpch_options(self) -> Optional[pulumi.Input['SourceLoadgenTpchOptionsArgs']]:
        """
        TPCH Options.
        """
        return pulumi.get(self, "tpch_options")

    @tpch_options.setter
    def tpch_options(self, value: Optional[pulumi.Input['SourceLoadgenTpchOptionsArgs']]):
        pulumi.set(self, "tpch_options", value)


@pulumi.input_type
class _SourceLoadgenState:
    def __init__(__self__, *,
                 auction_options: Optional[pulumi.Input['SourceLoadgenAuctionOptionsArgs']] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 expose_progress: Optional[pulumi.Input['SourceLoadgenExposeProgressArgs']] = None,
                 load_generator_type: Optional[pulumi.Input[_builtins.str]] = None,
                 marketing_options: Optional[pulumi.Input['SourceLoadgenMarketingOptionsArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 qualified_sql_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.str]] = None,
                 tpch_options: Optional[pulumi.Input['SourceLoadgenTpchOptionsArgs']] = None):
        """
        Input properties used for looking up and filtering SourceLoadgen resources.
        :param pulumi.Input['SourceLoadgenAuctionOptionsArgs'] auction_options: Auction Options.
        :param pulumi.Input[_builtins.str] cluster_name: The cluster to maintain this source.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the source database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input['SourceLoadgenExposeProgressArgs'] expose_progress: The name of the progress collection for the source. If this is not specified, the collection will be named `<src_name>_progress`.
        :param pulumi.Input[_builtins.str] load_generator_type: The load generator types: [AUCTION MARKETING TPCH].
        :param pulumi.Input['SourceLoadgenMarketingOptionsArgs'] marketing_options: Marketing Options.
        :param pulumi.Input[_builtins.str] name: The identifier for the source.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input[_builtins.str] qualified_sql_name: The fully qualified name of the source.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the source schema in Materialize. Defaults to `public`.
        :param pulumi.Input[_builtins.str] size: The size of the cluster maintaining this source.
        :param pulumi.Input['SourceLoadgenTpchOptionsArgs'] tpch_options: TPCH Options.
        """
        if auction_options is not None:
            pulumi.set(__self__, "auction_options", auction_options)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if expose_progress is not None:
            pulumi.set(__self__, "expose_progress", expose_progress)
        if load_generator_type is not None:
            pulumi.set(__self__, "load_generator_type", load_generator_type)
        if marketing_options is not None:
            pulumi.set(__self__, "marketing_options", marketing_options)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ownership_role is not None:
            pulumi.set(__self__, "ownership_role", ownership_role)
        if qualified_sql_name is not None:
            pulumi.set(__self__, "qualified_sql_name", qualified_sql_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tpch_options is not None:
            pulumi.set(__self__, "tpch_options", tpch_options)

    @_builtins.property
    @pulumi.getter(name="auctionOptions")
    def auction_options(self) -> Optional[pulumi.Input['SourceLoadgenAuctionOptionsArgs']]:
        """
        Auction Options.
        """
        return pulumi.get(self, "auction_options")

    @auction_options.setter
    def auction_options(self, value: Optional[pulumi.Input['SourceLoadgenAuctionOptionsArgs']]):
        pulumi.set(self, "auction_options", value)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster to maintain this source.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the source database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter(name="exposeProgress")
    def expose_progress(self) -> Optional[pulumi.Input['SourceLoadgenExposeProgressArgs']]:
        """
        The name of the progress collection for the source. If this is not specified, the collection will be named `<src_name>_progress`.
        """
        return pulumi.get(self, "expose_progress")

    @expose_progress.setter
    def expose_progress(self, value: Optional[pulumi.Input['SourceLoadgenExposeProgressArgs']]):
        pulumi.set(self, "expose_progress", value)

    @_builtins.property
    @pulumi.getter(name="loadGeneratorType")
    def load_generator_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The load generator types: [AUCTION MARKETING TPCH].
        """
        return pulumi.get(self, "load_generator_type")

    @load_generator_type.setter
    def load_generator_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_generator_type", value)

    @_builtins.property
    @pulumi.getter(name="marketingOptions")
    def marketing_options(self) -> Optional[pulumi.Input['SourceLoadgenMarketingOptionsArgs']]:
        """
        Marketing Options.
        """
        return pulumi.get(self, "marketing_options")

    @marketing_options.setter
    def marketing_options(self, value: Optional[pulumi.Input['SourceLoadgenMarketingOptionsArgs']]):
        pulumi.set(self, "marketing_options", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the source.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @ownership_role.setter
    def ownership_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ownership_role", value)

    @_builtins.property
    @pulumi.getter(name="qualifiedSqlName")
    def qualified_sql_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified name of the source.
        """
        return pulumi.get(self, "qualified_sql_name")

    @qualified_sql_name.setter
    def qualified_sql_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "qualified_sql_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the source schema in Materialize. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema_name", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The size of the cluster maintaining this source.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter(name="tpchOptions")
    def tpch_options(self) -> Optional[pulumi.Input['SourceLoadgenTpchOptionsArgs']]:
        """
        TPCH Options.
        """
        return pulumi.get(self, "tpch_options")

    @tpch_options.setter
    def tpch_options(self, value: Optional[pulumi.Input['SourceLoadgenTpchOptionsArgs']]):
        pulumi.set(self, "tpch_options", value)


@pulumi.type_token("materialize:index/sourceLoadgen:SourceLoadgen")
class SourceLoadgen(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auction_options: Optional[pulumi.Input[Union['SourceLoadgenAuctionOptionsArgs', 'SourceLoadgenAuctionOptionsArgsDict']]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 expose_progress: Optional[pulumi.Input[Union['SourceLoadgenExposeProgressArgs', 'SourceLoadgenExposeProgressArgsDict']]] = None,
                 load_generator_type: Optional[pulumi.Input[_builtins.str]] = None,
                 marketing_options: Optional[pulumi.Input[Union['SourceLoadgenMarketingOptionsArgs', 'SourceLoadgenMarketingOptionsArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tpch_options: Optional[pulumi.Input[Union['SourceLoadgenTpchOptionsArgs', 'SourceLoadgenTpchOptionsArgsDict']]] = None,
                 __props__=None):
        """
        A load generator source produces synthetic data for use in demos and performance tests.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        example_source_load_generator = materialize.SourceLoadgen("exampleSourceLoadGenerator",
            cluster_name="quickstart",
            load_generator_type="TPCH",
            schema_name="schema",
            tpch_options={
                "scale_factor": 0.01,
                "tick_interval": "500ms",
            })
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Sources can be imported using the source id:

        ```sh
        $ pulumi import materialize:index/sourceLoadgen:SourceLoadgen example_source_load_generator <region>:<source_id>
        ```

        Source id and information be found in the `mz_catalog.mz_sources` table

        The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SourceLoadgenAuctionOptionsArgs', 'SourceLoadgenAuctionOptionsArgsDict']] auction_options: Auction Options.
        :param pulumi.Input[_builtins.str] cluster_name: The cluster to maintain this source.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the source database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[Union['SourceLoadgenExposeProgressArgs', 'SourceLoadgenExposeProgressArgsDict']] expose_progress: The name of the progress collection for the source. If this is not specified, the collection will be named `<src_name>_progress`.
        :param pulumi.Input[_builtins.str] load_generator_type: The load generator types: [AUCTION MARKETING TPCH].
        :param pulumi.Input[Union['SourceLoadgenMarketingOptionsArgs', 'SourceLoadgenMarketingOptionsArgsDict']] marketing_options: Marketing Options.
        :param pulumi.Input[_builtins.str] name: The identifier for the source.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the source schema in Materialize. Defaults to `public`.
        :param pulumi.Input[Union['SourceLoadgenTpchOptionsArgs', 'SourceLoadgenTpchOptionsArgsDict']] tpch_options: TPCH Options.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SourceLoadgenArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A load generator source produces synthetic data for use in demos and performance tests.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        example_source_load_generator = materialize.SourceLoadgen("exampleSourceLoadGenerator",
            cluster_name="quickstart",
            load_generator_type="TPCH",
            schema_name="schema",
            tpch_options={
                "scale_factor": 0.01,
                "tick_interval": "500ms",
            })
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Sources can be imported using the source id:

        ```sh
        $ pulumi import materialize:index/sourceLoadgen:SourceLoadgen example_source_load_generator <region>:<source_id>
        ```

        Source id and information be found in the `mz_catalog.mz_sources` table

        The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param SourceLoadgenArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SourceLoadgenArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auction_options: Optional[pulumi.Input[Union['SourceLoadgenAuctionOptionsArgs', 'SourceLoadgenAuctionOptionsArgsDict']]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 expose_progress: Optional[pulumi.Input[Union['SourceLoadgenExposeProgressArgs', 'SourceLoadgenExposeProgressArgsDict']]] = None,
                 load_generator_type: Optional[pulumi.Input[_builtins.str]] = None,
                 marketing_options: Optional[pulumi.Input[Union['SourceLoadgenMarketingOptionsArgs', 'SourceLoadgenMarketingOptionsArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tpch_options: Optional[pulumi.Input[Union['SourceLoadgenTpchOptionsArgs', 'SourceLoadgenTpchOptionsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SourceLoadgenArgs.__new__(SourceLoadgenArgs)

            __props__.__dict__["auction_options"] = auction_options
            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["comment"] = comment
            __props__.__dict__["database_name"] = database_name
            __props__.__dict__["expose_progress"] = expose_progress
            if load_generator_type is None and not opts.urn:
                raise TypeError("Missing required property 'load_generator_type'")
            __props__.__dict__["load_generator_type"] = load_generator_type
            __props__.__dict__["marketing_options"] = marketing_options
            __props__.__dict__["name"] = name
            __props__.__dict__["ownership_role"] = ownership_role
            __props__.__dict__["region"] = region
            __props__.__dict__["schema_name"] = schema_name
            __props__.__dict__["tpch_options"] = tpch_options
            __props__.__dict__["qualified_sql_name"] = None
            __props__.__dict__["size"] = None
        super(SourceLoadgen, __self__).__init__(
            'materialize:index/sourceLoadgen:SourceLoadgen',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auction_options: Optional[pulumi.Input[Union['SourceLoadgenAuctionOptionsArgs', 'SourceLoadgenAuctionOptionsArgsDict']]] = None,
            cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            database_name: Optional[pulumi.Input[_builtins.str]] = None,
            expose_progress: Optional[pulumi.Input[Union['SourceLoadgenExposeProgressArgs', 'SourceLoadgenExposeProgressArgsDict']]] = None,
            load_generator_type: Optional[pulumi.Input[_builtins.str]] = None,
            marketing_options: Optional[pulumi.Input[Union['SourceLoadgenMarketingOptionsArgs', 'SourceLoadgenMarketingOptionsArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
            qualified_sql_name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            schema_name: Optional[pulumi.Input[_builtins.str]] = None,
            size: Optional[pulumi.Input[_builtins.str]] = None,
            tpch_options: Optional[pulumi.Input[Union['SourceLoadgenTpchOptionsArgs', 'SourceLoadgenTpchOptionsArgsDict']]] = None) -> 'SourceLoadgen':
        """
        Get an existing SourceLoadgen resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SourceLoadgenAuctionOptionsArgs', 'SourceLoadgenAuctionOptionsArgsDict']] auction_options: Auction Options.
        :param pulumi.Input[_builtins.str] cluster_name: The cluster to maintain this source.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the source database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[Union['SourceLoadgenExposeProgressArgs', 'SourceLoadgenExposeProgressArgsDict']] expose_progress: The name of the progress collection for the source. If this is not specified, the collection will be named `<src_name>_progress`.
        :param pulumi.Input[_builtins.str] load_generator_type: The load generator types: [AUCTION MARKETING TPCH].
        :param pulumi.Input[Union['SourceLoadgenMarketingOptionsArgs', 'SourceLoadgenMarketingOptionsArgsDict']] marketing_options: Marketing Options.
        :param pulumi.Input[_builtins.str] name: The identifier for the source.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input[_builtins.str] qualified_sql_name: The fully qualified name of the source.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the source schema in Materialize. Defaults to `public`.
        :param pulumi.Input[_builtins.str] size: The size of the cluster maintaining this source.
        :param pulumi.Input[Union['SourceLoadgenTpchOptionsArgs', 'SourceLoadgenTpchOptionsArgsDict']] tpch_options: TPCH Options.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SourceLoadgenState.__new__(_SourceLoadgenState)

        __props__.__dict__["auction_options"] = auction_options
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["comment"] = comment
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["expose_progress"] = expose_progress
        __props__.__dict__["load_generator_type"] = load_generator_type
        __props__.__dict__["marketing_options"] = marketing_options
        __props__.__dict__["name"] = name
        __props__.__dict__["ownership_role"] = ownership_role
        __props__.__dict__["qualified_sql_name"] = qualified_sql_name
        __props__.__dict__["region"] = region
        __props__.__dict__["schema_name"] = schema_name
        __props__.__dict__["size"] = size
        __props__.__dict__["tpch_options"] = tpch_options
        return SourceLoadgen(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="auctionOptions")
    def auction_options(self) -> pulumi.Output[Optional['outputs.SourceLoadgenAuctionOptions']]:
        """
        Auction Options.
        """
        return pulumi.get(self, "auction_options")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[_builtins.str]:
        """
        The cluster to maintain this source.
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The identifier for the source database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @_builtins.property
    @pulumi.getter(name="exposeProgress")
    def expose_progress(self) -> pulumi.Output[Optional['outputs.SourceLoadgenExposeProgress']]:
        """
        The name of the progress collection for the source. If this is not specified, the collection will be named `<src_name>_progress`.
        """
        return pulumi.get(self, "expose_progress")

    @_builtins.property
    @pulumi.getter(name="loadGeneratorType")
    def load_generator_type(self) -> pulumi.Output[_builtins.str]:
        """
        The load generator types: [AUCTION MARKETING TPCH].
        """
        return pulumi.get(self, "load_generator_type")

    @_builtins.property
    @pulumi.getter(name="marketingOptions")
    def marketing_options(self) -> pulumi.Output[Optional['outputs.SourceLoadgenMarketingOptions']]:
        """
        Marketing Options.
        """
        return pulumi.get(self, "marketing_options")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The identifier for the source.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> pulumi.Output[_builtins.str]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @_builtins.property
    @pulumi.getter(name="qualifiedSqlName")
    def qualified_sql_name(self) -> pulumi.Output[_builtins.str]:
        """
        The fully qualified name of the source.
        """
        return pulumi.get(self, "qualified_sql_name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The identifier for the source schema in Materialize. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Output[_builtins.str]:
        """
        The size of the cluster maintaining this source.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="tpchOptions")
    def tpch_options(self) -> pulumi.Output[Optional['outputs.SourceLoadgenTpchOptions']]:
        """
        TPCH Options.
        """
        return pulumi.get(self, "tpch_options")

