# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SourceMysqlArgs', 'SourceMysql']

@pulumi.input_type
class SourceMysqlArgs:
    def __init__(__self__, *,
                 mysql_connection: pulumi.Input['SourceMysqlMysqlConnectionArgs'],
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 expose_progress: Optional[pulumi.Input['SourceMysqlExposeProgressArgs']] = None,
                 ignore_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tables: Optional[pulumi.Input[Sequence[pulumi.Input['SourceMysqlTableArgs']]]] = None,
                 text_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a SourceMysql resource.
        :param pulumi.Input['SourceMysqlMysqlConnectionArgs'] mysql_connection: The MySQL connection to use in the source.
        :param pulumi.Input[_builtins.str] cluster_name: The cluster to maintain this source.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the source database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input['SourceMysqlExposeProgressArgs'] expose_progress: The name of the progress collection for the source. If this is not specified, the collection will be named `<src_name>_progress`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ignore_columns: Ignore specific columns when reading data from MySQL. Can only be updated in place when also updating a corresponding `table` attribute.
        :param pulumi.Input[_builtins.str] name: The identifier for the source.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the source schema in Materialize. Defaults to `public`.
        :param pulumi.Input[Sequence[pulumi.Input['SourceMysqlTableArgs']]] tables: Specify the tables to be included in the source. If not specified, all tables are included.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] text_columns: Decode data as text for specific columns that contain MySQL types that are unsupported in Materialize. Can only be updated in place when also updating a corresponding `table` attribute.
        """
        pulumi.set(__self__, "mysql_connection", mysql_connection)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if expose_progress is not None:
            pulumi.set(__self__, "expose_progress", expose_progress)
        if ignore_columns is not None:
            pulumi.set(__self__, "ignore_columns", ignore_columns)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ownership_role is not None:
            pulumi.set(__self__, "ownership_role", ownership_role)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if tables is not None:
            pulumi.set(__self__, "tables", tables)
        if text_columns is not None:
            pulumi.set(__self__, "text_columns", text_columns)

    @_builtins.property
    @pulumi.getter(name="mysqlConnection")
    def mysql_connection(self) -> pulumi.Input['SourceMysqlMysqlConnectionArgs']:
        """
        The MySQL connection to use in the source.
        """
        return pulumi.get(self, "mysql_connection")

    @mysql_connection.setter
    def mysql_connection(self, value: pulumi.Input['SourceMysqlMysqlConnectionArgs']):
        pulumi.set(self, "mysql_connection", value)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster to maintain this source.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the source database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter(name="exposeProgress")
    def expose_progress(self) -> Optional[pulumi.Input['SourceMysqlExposeProgressArgs']]:
        """
        The name of the progress collection for the source. If this is not specified, the collection will be named `<src_name>_progress`.
        """
        return pulumi.get(self, "expose_progress")

    @expose_progress.setter
    def expose_progress(self, value: Optional[pulumi.Input['SourceMysqlExposeProgressArgs']]):
        pulumi.set(self, "expose_progress", value)

    @_builtins.property
    @pulumi.getter(name="ignoreColumns")
    def ignore_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Ignore specific columns when reading data from MySQL. Can only be updated in place when also updating a corresponding `table` attribute.
        """
        return pulumi.get(self, "ignore_columns")

    @ignore_columns.setter
    def ignore_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ignore_columns", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the source.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @ownership_role.setter
    def ownership_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ownership_role", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the source schema in Materialize. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema_name", value)

    @_builtins.property
    @pulumi.getter
    def tables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SourceMysqlTableArgs']]]]:
        """
        Specify the tables to be included in the source. If not specified, all tables are included.
        """
        return pulumi.get(self, "tables")

    @tables.setter
    def tables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SourceMysqlTableArgs']]]]):
        pulumi.set(self, "tables", value)

    @_builtins.property
    @pulumi.getter(name="textColumns")
    def text_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Decode data as text for specific columns that contain MySQL types that are unsupported in Materialize. Can only be updated in place when also updating a corresponding `table` attribute.
        """
        return pulumi.get(self, "text_columns")

    @text_columns.setter
    def text_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "text_columns", value)


@pulumi.input_type
class _SourceMysqlState:
    def __init__(__self__, *,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 expose_progress: Optional[pulumi.Input['SourceMysqlExposeProgressArgs']] = None,
                 ignore_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 mysql_connection: Optional[pulumi.Input['SourceMysqlMysqlConnectionArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 qualified_sql_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.str]] = None,
                 tables: Optional[pulumi.Input[Sequence[pulumi.Input['SourceMysqlTableArgs']]]] = None,
                 text_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering SourceMysql resources.
        :param pulumi.Input[_builtins.str] cluster_name: The cluster to maintain this source.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the source database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input['SourceMysqlExposeProgressArgs'] expose_progress: The name of the progress collection for the source. If this is not specified, the collection will be named `<src_name>_progress`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ignore_columns: Ignore specific columns when reading data from MySQL. Can only be updated in place when also updating a corresponding `table` attribute.
        :param pulumi.Input['SourceMysqlMysqlConnectionArgs'] mysql_connection: The MySQL connection to use in the source.
        :param pulumi.Input[_builtins.str] name: The identifier for the source.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input[_builtins.str] qualified_sql_name: The fully qualified name of the source.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the source schema in Materialize. Defaults to `public`.
        :param pulumi.Input[_builtins.str] size: The size of the cluster maintaining this source.
        :param pulumi.Input[Sequence[pulumi.Input['SourceMysqlTableArgs']]] tables: Specify the tables to be included in the source. If not specified, all tables are included.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] text_columns: Decode data as text for specific columns that contain MySQL types that are unsupported in Materialize. Can only be updated in place when also updating a corresponding `table` attribute.
        """
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if expose_progress is not None:
            pulumi.set(__self__, "expose_progress", expose_progress)
        if ignore_columns is not None:
            pulumi.set(__self__, "ignore_columns", ignore_columns)
        if mysql_connection is not None:
            pulumi.set(__self__, "mysql_connection", mysql_connection)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ownership_role is not None:
            pulumi.set(__self__, "ownership_role", ownership_role)
        if qualified_sql_name is not None:
            pulumi.set(__self__, "qualified_sql_name", qualified_sql_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tables is not None:
            pulumi.set(__self__, "tables", tables)
        if text_columns is not None:
            pulumi.set(__self__, "text_columns", text_columns)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster to maintain this source.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the source database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter(name="exposeProgress")
    def expose_progress(self) -> Optional[pulumi.Input['SourceMysqlExposeProgressArgs']]:
        """
        The name of the progress collection for the source. If this is not specified, the collection will be named `<src_name>_progress`.
        """
        return pulumi.get(self, "expose_progress")

    @expose_progress.setter
    def expose_progress(self, value: Optional[pulumi.Input['SourceMysqlExposeProgressArgs']]):
        pulumi.set(self, "expose_progress", value)

    @_builtins.property
    @pulumi.getter(name="ignoreColumns")
    def ignore_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Ignore specific columns when reading data from MySQL. Can only be updated in place when also updating a corresponding `table` attribute.
        """
        return pulumi.get(self, "ignore_columns")

    @ignore_columns.setter
    def ignore_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ignore_columns", value)

    @_builtins.property
    @pulumi.getter(name="mysqlConnection")
    def mysql_connection(self) -> Optional[pulumi.Input['SourceMysqlMysqlConnectionArgs']]:
        """
        The MySQL connection to use in the source.
        """
        return pulumi.get(self, "mysql_connection")

    @mysql_connection.setter
    def mysql_connection(self, value: Optional[pulumi.Input['SourceMysqlMysqlConnectionArgs']]):
        pulumi.set(self, "mysql_connection", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the source.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @ownership_role.setter
    def ownership_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ownership_role", value)

    @_builtins.property
    @pulumi.getter(name="qualifiedSqlName")
    def qualified_sql_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified name of the source.
        """
        return pulumi.get(self, "qualified_sql_name")

    @qualified_sql_name.setter
    def qualified_sql_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "qualified_sql_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the source schema in Materialize. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema_name", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The size of the cluster maintaining this source.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter
    def tables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SourceMysqlTableArgs']]]]:
        """
        Specify the tables to be included in the source. If not specified, all tables are included.
        """
        return pulumi.get(self, "tables")

    @tables.setter
    def tables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SourceMysqlTableArgs']]]]):
        pulumi.set(self, "tables", value)

    @_builtins.property
    @pulumi.getter(name="textColumns")
    def text_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Decode data as text for specific columns that contain MySQL types that are unsupported in Materialize. Can only be updated in place when also updating a corresponding `table` attribute.
        """
        return pulumi.get(self, "text_columns")

    @text_columns.setter
    def text_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "text_columns", value)


@pulumi.type_token("materialize:index/sourceMysql:SourceMysql")
class SourceMysql(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 expose_progress: Optional[pulumi.Input[Union['SourceMysqlExposeProgressArgs', 'SourceMysqlExposeProgressArgsDict']]] = None,
                 ignore_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 mysql_connection: Optional[pulumi.Input[Union['SourceMysqlMysqlConnectionArgs', 'SourceMysqlMysqlConnectionArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SourceMysqlTableArgs', 'SourceMysqlTableArgsDict']]]]] = None,
                 text_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        A MySQL source describes a MySQL instance you want Materialize to read data from.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        test = materialize.SourceMysql("test",
            schema_name=materialize_schema["test"]["name"],
            database_name=materialize_database["test"]["name"],
            cluster_name="quickstart",
            mysql_connection={
                "name": materialize_connection_mysql["test"]["name"],
            },
            tables=[
                {
                    "upstream_name": "mysql_table1",
                    "upstream_schema_name": "shop",
                    "name": "mysql_table1_local",
                },
                {
                    "upstream_name": "mysql_table2",
                    "upstream_schema_name": "shop",
                    "name": "mysql_table2_local",
                },
            ])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Sources can be imported using the source id:

        ```sh
        $ pulumi import materialize:index/sourceMysql:SourceMysql example_source_mysql <region>:<source_id>
        ```

        Source id and information be found in the `mz_catalog.mz_sources` table

        The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_name: The cluster to maintain this source.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the source database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[Union['SourceMysqlExposeProgressArgs', 'SourceMysqlExposeProgressArgsDict']] expose_progress: The name of the progress collection for the source. If this is not specified, the collection will be named `<src_name>_progress`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ignore_columns: Ignore specific columns when reading data from MySQL. Can only be updated in place when also updating a corresponding `table` attribute.
        :param pulumi.Input[Union['SourceMysqlMysqlConnectionArgs', 'SourceMysqlMysqlConnectionArgsDict']] mysql_connection: The MySQL connection to use in the source.
        :param pulumi.Input[_builtins.str] name: The identifier for the source.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the source schema in Materialize. Defaults to `public`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SourceMysqlTableArgs', 'SourceMysqlTableArgsDict']]]] tables: Specify the tables to be included in the source. If not specified, all tables are included.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] text_columns: Decode data as text for specific columns that contain MySQL types that are unsupported in Materialize. Can only be updated in place when also updating a corresponding `table` attribute.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SourceMysqlArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A MySQL source describes a MySQL instance you want Materialize to read data from.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        test = materialize.SourceMysql("test",
            schema_name=materialize_schema["test"]["name"],
            database_name=materialize_database["test"]["name"],
            cluster_name="quickstart",
            mysql_connection={
                "name": materialize_connection_mysql["test"]["name"],
            },
            tables=[
                {
                    "upstream_name": "mysql_table1",
                    "upstream_schema_name": "shop",
                    "name": "mysql_table1_local",
                },
                {
                    "upstream_name": "mysql_table2",
                    "upstream_schema_name": "shop",
                    "name": "mysql_table2_local",
                },
            ])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Sources can be imported using the source id:

        ```sh
        $ pulumi import materialize:index/sourceMysql:SourceMysql example_source_mysql <region>:<source_id>
        ```

        Source id and information be found in the `mz_catalog.mz_sources` table

        The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param SourceMysqlArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SourceMysqlArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 expose_progress: Optional[pulumi.Input[Union['SourceMysqlExposeProgressArgs', 'SourceMysqlExposeProgressArgsDict']]] = None,
                 ignore_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 mysql_connection: Optional[pulumi.Input[Union['SourceMysqlMysqlConnectionArgs', 'SourceMysqlMysqlConnectionArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SourceMysqlTableArgs', 'SourceMysqlTableArgsDict']]]]] = None,
                 text_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SourceMysqlArgs.__new__(SourceMysqlArgs)

            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["comment"] = comment
            __props__.__dict__["database_name"] = database_name
            __props__.__dict__["expose_progress"] = expose_progress
            __props__.__dict__["ignore_columns"] = ignore_columns
            if mysql_connection is None and not opts.urn:
                raise TypeError("Missing required property 'mysql_connection'")
            __props__.__dict__["mysql_connection"] = mysql_connection
            __props__.__dict__["name"] = name
            __props__.__dict__["ownership_role"] = ownership_role
            __props__.__dict__["region"] = region
            __props__.__dict__["schema_name"] = schema_name
            __props__.__dict__["tables"] = tables
            __props__.__dict__["text_columns"] = text_columns
            __props__.__dict__["qualified_sql_name"] = None
            __props__.__dict__["size"] = None
        super(SourceMysql, __self__).__init__(
            'materialize:index/sourceMysql:SourceMysql',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            database_name: Optional[pulumi.Input[_builtins.str]] = None,
            expose_progress: Optional[pulumi.Input[Union['SourceMysqlExposeProgressArgs', 'SourceMysqlExposeProgressArgsDict']]] = None,
            ignore_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            mysql_connection: Optional[pulumi.Input[Union['SourceMysqlMysqlConnectionArgs', 'SourceMysqlMysqlConnectionArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
            qualified_sql_name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            schema_name: Optional[pulumi.Input[_builtins.str]] = None,
            size: Optional[pulumi.Input[_builtins.str]] = None,
            tables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SourceMysqlTableArgs', 'SourceMysqlTableArgsDict']]]]] = None,
            text_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'SourceMysql':
        """
        Get an existing SourceMysql resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_name: The cluster to maintain this source.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the source database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[Union['SourceMysqlExposeProgressArgs', 'SourceMysqlExposeProgressArgsDict']] expose_progress: The name of the progress collection for the source. If this is not specified, the collection will be named `<src_name>_progress`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ignore_columns: Ignore specific columns when reading data from MySQL. Can only be updated in place when also updating a corresponding `table` attribute.
        :param pulumi.Input[Union['SourceMysqlMysqlConnectionArgs', 'SourceMysqlMysqlConnectionArgsDict']] mysql_connection: The MySQL connection to use in the source.
        :param pulumi.Input[_builtins.str] name: The identifier for the source.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input[_builtins.str] qualified_sql_name: The fully qualified name of the source.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the source schema in Materialize. Defaults to `public`.
        :param pulumi.Input[_builtins.str] size: The size of the cluster maintaining this source.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SourceMysqlTableArgs', 'SourceMysqlTableArgsDict']]]] tables: Specify the tables to be included in the source. If not specified, all tables are included.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] text_columns: Decode data as text for specific columns that contain MySQL types that are unsupported in Materialize. Can only be updated in place when also updating a corresponding `table` attribute.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SourceMysqlState.__new__(_SourceMysqlState)

        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["comment"] = comment
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["expose_progress"] = expose_progress
        __props__.__dict__["ignore_columns"] = ignore_columns
        __props__.__dict__["mysql_connection"] = mysql_connection
        __props__.__dict__["name"] = name
        __props__.__dict__["ownership_role"] = ownership_role
        __props__.__dict__["qualified_sql_name"] = qualified_sql_name
        __props__.__dict__["region"] = region
        __props__.__dict__["schema_name"] = schema_name
        __props__.__dict__["size"] = size
        __props__.__dict__["tables"] = tables
        __props__.__dict__["text_columns"] = text_columns
        return SourceMysql(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[_builtins.str]:
        """
        The cluster to maintain this source.
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The identifier for the source database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @_builtins.property
    @pulumi.getter(name="exposeProgress")
    def expose_progress(self) -> pulumi.Output[Optional['outputs.SourceMysqlExposeProgress']]:
        """
        The name of the progress collection for the source. If this is not specified, the collection will be named `<src_name>_progress`.
        """
        return pulumi.get(self, "expose_progress")

    @_builtins.property
    @pulumi.getter(name="ignoreColumns")
    def ignore_columns(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Ignore specific columns when reading data from MySQL. Can only be updated in place when also updating a corresponding `table` attribute.
        """
        return pulumi.get(self, "ignore_columns")

    @_builtins.property
    @pulumi.getter(name="mysqlConnection")
    def mysql_connection(self) -> pulumi.Output['outputs.SourceMysqlMysqlConnection']:
        """
        The MySQL connection to use in the source.
        """
        return pulumi.get(self, "mysql_connection")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The identifier for the source.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> pulumi.Output[_builtins.str]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @_builtins.property
    @pulumi.getter(name="qualifiedSqlName")
    def qualified_sql_name(self) -> pulumi.Output[_builtins.str]:
        """
        The fully qualified name of the source.
        """
        return pulumi.get(self, "qualified_sql_name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The identifier for the source schema in Materialize. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Output[_builtins.str]:
        """
        The size of the cluster maintaining this source.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def tables(self) -> pulumi.Output[Optional[Sequence['outputs.SourceMysqlTable']]]:
        """
        Specify the tables to be included in the source. If not specified, all tables are included.
        """
        return pulumi.get(self, "tables")

    @_builtins.property
    @pulumi.getter(name="textColumns")
    def text_columns(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Decode data as text for specific columns that contain MySQL types that are unsupported in Materialize. Can only be updated in place when also updating a corresponding `table` attribute.
        """
        return pulumi.get(self, "text_columns")

