# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SourceSqlserverArgs', 'SourceSqlserver']

@pulumi.input_type
class SourceSqlserverArgs:
    def __init__(__self__, *,
                 sqlserver_connection: pulumi.Input['SourceSqlserverSqlserverConnectionArgs'],
                 aws_privatelink: Optional[pulumi.Input['SourceSqlserverAwsPrivatelinkArgs']] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 expose_progress: Optional[pulumi.Input['SourceSqlserverExposeProgressArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tables: Optional[pulumi.Input[Sequence[pulumi.Input['SourceSqlserverTableArgs']]]] = None,
                 text_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a SourceSqlserver resource.
        :param pulumi.Input['SourceSqlserverSqlserverConnectionArgs'] sqlserver_connection: The SQL Server connection to use in the source.
        :param pulumi.Input['SourceSqlserverAwsPrivatelinkArgs'] aws_privatelink: The AWS PrivateLink configuration for the SQL Server database.
        :param pulumi.Input[_builtins.str] cluster_name: The cluster to maintain this source.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the source database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] exclude_columns: Exclude specific columns when reading data from SQL Server. Can only be updated in place when also updating a corresponding `table` attribute.
        :param pulumi.Input['SourceSqlserverExposeProgressArgs'] expose_progress: The name of the progress collection for the source. If this is not specified, the collection will be named `<src_name>_progress`.
        :param pulumi.Input[_builtins.str] name: The identifier for the source.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the source schema in Materialize. Defaults to `public`.
        :param pulumi.Input[Sequence[pulumi.Input['SourceSqlserverTableArgs']]] tables: Specify the tables to be included in the source. If not specified, all tables are included.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] text_columns: Decode data as text for specific columns that contain SQL Server types that are unsupported in Materialize. Can only be updated in place when also updating a corresponding `table` attribute.
        """
        pulumi.set(__self__, "sqlserver_connection", sqlserver_connection)
        if aws_privatelink is not None:
            pulumi.set(__self__, "aws_privatelink", aws_privatelink)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if exclude_columns is not None:
            pulumi.set(__self__, "exclude_columns", exclude_columns)
        if expose_progress is not None:
            pulumi.set(__self__, "expose_progress", expose_progress)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ownership_role is not None:
            pulumi.set(__self__, "ownership_role", ownership_role)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if tables is not None:
            pulumi.set(__self__, "tables", tables)
        if text_columns is not None:
            pulumi.set(__self__, "text_columns", text_columns)

    @_builtins.property
    @pulumi.getter(name="sqlserverConnection")
    def sqlserver_connection(self) -> pulumi.Input['SourceSqlserverSqlserverConnectionArgs']:
        """
        The SQL Server connection to use in the source.
        """
        return pulumi.get(self, "sqlserver_connection")

    @sqlserver_connection.setter
    def sqlserver_connection(self, value: pulumi.Input['SourceSqlserverSqlserverConnectionArgs']):
        pulumi.set(self, "sqlserver_connection", value)

    @_builtins.property
    @pulumi.getter(name="awsPrivatelink")
    def aws_privatelink(self) -> Optional[pulumi.Input['SourceSqlserverAwsPrivatelinkArgs']]:
        """
        The AWS PrivateLink configuration for the SQL Server database.
        """
        return pulumi.get(self, "aws_privatelink")

    @aws_privatelink.setter
    def aws_privatelink(self, value: Optional[pulumi.Input['SourceSqlserverAwsPrivatelinkArgs']]):
        pulumi.set(self, "aws_privatelink", value)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster to maintain this source.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the source database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter(name="excludeColumns")
    def exclude_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Exclude specific columns when reading data from SQL Server. Can only be updated in place when also updating a corresponding `table` attribute.
        """
        return pulumi.get(self, "exclude_columns")

    @exclude_columns.setter
    def exclude_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "exclude_columns", value)

    @_builtins.property
    @pulumi.getter(name="exposeProgress")
    def expose_progress(self) -> Optional[pulumi.Input['SourceSqlserverExposeProgressArgs']]:
        """
        The name of the progress collection for the source. If this is not specified, the collection will be named `<src_name>_progress`.
        """
        return pulumi.get(self, "expose_progress")

    @expose_progress.setter
    def expose_progress(self, value: Optional[pulumi.Input['SourceSqlserverExposeProgressArgs']]):
        pulumi.set(self, "expose_progress", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the source.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @ownership_role.setter
    def ownership_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ownership_role", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the source schema in Materialize. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema_name", value)

    @_builtins.property
    @pulumi.getter
    def tables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SourceSqlserverTableArgs']]]]:
        """
        Specify the tables to be included in the source. If not specified, all tables are included.
        """
        return pulumi.get(self, "tables")

    @tables.setter
    def tables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SourceSqlserverTableArgs']]]]):
        pulumi.set(self, "tables", value)

    @_builtins.property
    @pulumi.getter(name="textColumns")
    def text_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Decode data as text for specific columns that contain SQL Server types that are unsupported in Materialize. Can only be updated in place when also updating a corresponding `table` attribute.
        """
        return pulumi.get(self, "text_columns")

    @text_columns.setter
    def text_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "text_columns", value)


@pulumi.input_type
class _SourceSqlserverState:
    def __init__(__self__, *,
                 aws_privatelink: Optional[pulumi.Input['SourceSqlserverAwsPrivatelinkArgs']] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 expose_progress: Optional[pulumi.Input['SourceSqlserverExposeProgressArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 qualified_sql_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.str]] = None,
                 sqlserver_connection: Optional[pulumi.Input['SourceSqlserverSqlserverConnectionArgs']] = None,
                 tables: Optional[pulumi.Input[Sequence[pulumi.Input['SourceSqlserverTableArgs']]]] = None,
                 text_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering SourceSqlserver resources.
        :param pulumi.Input['SourceSqlserverAwsPrivatelinkArgs'] aws_privatelink: The AWS PrivateLink configuration for the SQL Server database.
        :param pulumi.Input[_builtins.str] cluster_name: The cluster to maintain this source.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the source database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] exclude_columns: Exclude specific columns when reading data from SQL Server. Can only be updated in place when also updating a corresponding `table` attribute.
        :param pulumi.Input['SourceSqlserverExposeProgressArgs'] expose_progress: The name of the progress collection for the source. If this is not specified, the collection will be named `<src_name>_progress`.
        :param pulumi.Input[_builtins.str] name: The identifier for the source.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input[_builtins.str] qualified_sql_name: The fully qualified name of the source.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the source schema in Materialize. Defaults to `public`.
        :param pulumi.Input[_builtins.str] size: The size of the cluster maintaining this source.
        :param pulumi.Input['SourceSqlserverSqlserverConnectionArgs'] sqlserver_connection: The SQL Server connection to use in the source.
        :param pulumi.Input[Sequence[pulumi.Input['SourceSqlserverTableArgs']]] tables: Specify the tables to be included in the source. If not specified, all tables are included.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] text_columns: Decode data as text for specific columns that contain SQL Server types that are unsupported in Materialize. Can only be updated in place when also updating a corresponding `table` attribute.
        """
        if aws_privatelink is not None:
            pulumi.set(__self__, "aws_privatelink", aws_privatelink)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if exclude_columns is not None:
            pulumi.set(__self__, "exclude_columns", exclude_columns)
        if expose_progress is not None:
            pulumi.set(__self__, "expose_progress", expose_progress)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ownership_role is not None:
            pulumi.set(__self__, "ownership_role", ownership_role)
        if qualified_sql_name is not None:
            pulumi.set(__self__, "qualified_sql_name", qualified_sql_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if sqlserver_connection is not None:
            pulumi.set(__self__, "sqlserver_connection", sqlserver_connection)
        if tables is not None:
            pulumi.set(__self__, "tables", tables)
        if text_columns is not None:
            pulumi.set(__self__, "text_columns", text_columns)

    @_builtins.property
    @pulumi.getter(name="awsPrivatelink")
    def aws_privatelink(self) -> Optional[pulumi.Input['SourceSqlserverAwsPrivatelinkArgs']]:
        """
        The AWS PrivateLink configuration for the SQL Server database.
        """
        return pulumi.get(self, "aws_privatelink")

    @aws_privatelink.setter
    def aws_privatelink(self, value: Optional[pulumi.Input['SourceSqlserverAwsPrivatelinkArgs']]):
        pulumi.set(self, "aws_privatelink", value)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster to maintain this source.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the source database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter(name="excludeColumns")
    def exclude_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Exclude specific columns when reading data from SQL Server. Can only be updated in place when also updating a corresponding `table` attribute.
        """
        return pulumi.get(self, "exclude_columns")

    @exclude_columns.setter
    def exclude_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "exclude_columns", value)

    @_builtins.property
    @pulumi.getter(name="exposeProgress")
    def expose_progress(self) -> Optional[pulumi.Input['SourceSqlserverExposeProgressArgs']]:
        """
        The name of the progress collection for the source. If this is not specified, the collection will be named `<src_name>_progress`.
        """
        return pulumi.get(self, "expose_progress")

    @expose_progress.setter
    def expose_progress(self, value: Optional[pulumi.Input['SourceSqlserverExposeProgressArgs']]):
        pulumi.set(self, "expose_progress", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the source.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @ownership_role.setter
    def ownership_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ownership_role", value)

    @_builtins.property
    @pulumi.getter(name="qualifiedSqlName")
    def qualified_sql_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified name of the source.
        """
        return pulumi.get(self, "qualified_sql_name")

    @qualified_sql_name.setter
    def qualified_sql_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "qualified_sql_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier for the source schema in Materialize. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema_name", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The size of the cluster maintaining this source.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter(name="sqlserverConnection")
    def sqlserver_connection(self) -> Optional[pulumi.Input['SourceSqlserverSqlserverConnectionArgs']]:
        """
        The SQL Server connection to use in the source.
        """
        return pulumi.get(self, "sqlserver_connection")

    @sqlserver_connection.setter
    def sqlserver_connection(self, value: Optional[pulumi.Input['SourceSqlserverSqlserverConnectionArgs']]):
        pulumi.set(self, "sqlserver_connection", value)

    @_builtins.property
    @pulumi.getter
    def tables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SourceSqlserverTableArgs']]]]:
        """
        Specify the tables to be included in the source. If not specified, all tables are included.
        """
        return pulumi.get(self, "tables")

    @tables.setter
    def tables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SourceSqlserverTableArgs']]]]):
        pulumi.set(self, "tables", value)

    @_builtins.property
    @pulumi.getter(name="textColumns")
    def text_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Decode data as text for specific columns that contain SQL Server types that are unsupported in Materialize. Can only be updated in place when also updating a corresponding `table` attribute.
        """
        return pulumi.get(self, "text_columns")

    @text_columns.setter
    def text_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "text_columns", value)


@pulumi.type_token("materialize:index/sourceSqlserver:SourceSqlserver")
class SourceSqlserver(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_privatelink: Optional[pulumi.Input[Union['SourceSqlserverAwsPrivatelinkArgs', 'SourceSqlserverAwsPrivatelinkArgsDict']]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 expose_progress: Optional[pulumi.Input[Union['SourceSqlserverExposeProgressArgs', 'SourceSqlserverExposeProgressArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sqlserver_connection: Optional[pulumi.Input[Union['SourceSqlserverSqlserverConnectionArgs', 'SourceSqlserverSqlserverConnectionArgsDict']]] = None,
                 tables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SourceSqlserverTableArgs', 'SourceSqlserverTableArgsDict']]]]] = None,
                 text_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        A SQL Server source describes a SQL Server database instance you want Materialize to read data from using Change Data Capture (CDC).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        sqlserver_password = materialize.Secret("sqlserverPassword",
            value="some-secret-value",
            comment="secret comment")
        sqlserver_connection = materialize.ConnectionSqlserver("sqlserverConnection",
            host="sql-server.example.com",
            port=1433,
            user={
                "text": "sqluser",
            },
            password={
                "name": sqlserver_password.name,
                "schema_name": sqlserver_password.schema_name,
                "database_name": sqlserver_password.database_name,
            },
            database="testdb")
        # Basic SQL Server source for specific tables
        example = materialize.SourceSqlserver("example",
            cluster_name="quickstart",
            sqlserver_connection={
                "name": sqlserver_connection.name,
                "schema_name": sqlserver_connection.schema_name,
                "database_name": sqlserver_connection.database_name,
            },
            tables=[
                {
                    "upstream_name": "dbo.customers",
                    "name": "customers",
                },
                {
                    "upstream_name": "dbo.orders",
                    "name": "orders",
                },
                {
                    "upstream_name": "dbo.products",
                    "name": "products",
                },
            ])
        # SQL Server source for all tables
        all_tables = materialize.SourceSqlserver("allTables",
            cluster_name="quickstart",
            sqlserver_connection={
                "name": sqlserver_connection.name,
                "schema_name": sqlserver_connection.schema_name,
                "database_name": sqlserver_connection.database_name,
            })
        # No table blocks specified means all tables will be included
        # SQL Server source with text columns and excluded columns
        with_options = materialize.SourceSqlserver("withOptions",
            cluster_name="quickstart",
            sqlserver_connection={
                "name": sqlserver_connection.name,
                "schema_name": sqlserver_connection.schema_name,
                "database_name": sqlserver_connection.database_name,
            },
            tables=[
                {
                    "upstream_name": "dbo.users",
                    "name": "users",
                },
                {
                    "upstream_name": "dbo.posts",
                    "name": "posts",
                },
                {
                    "upstream_name": "dbo.comments",
                    "name": "comments",
                },
            ],
            text_columns=[
                "dbo.users.description",
                "dbo.posts.content",
                "dbo.comments.metadata",
            ],
            exclude_columns=[
                "dbo.users.image_data",
                "dbo.posts.binary_data",
            ])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        #!/bin/bash

        SQL Server sources can be imported using the source name

        ```sh
        $ pulumi import materialize:index/sourceSqlserver:SourceSqlserver example <region>:<source_name>
        ```

        Example

        ```sh
        $ pulumi import materialize:index/sourceSqlserver:SourceSqlserver example aws/us-east-1:my_sqlserver_source
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SourceSqlserverAwsPrivatelinkArgs', 'SourceSqlserverAwsPrivatelinkArgsDict']] aws_privatelink: The AWS PrivateLink configuration for the SQL Server database.
        :param pulumi.Input[_builtins.str] cluster_name: The cluster to maintain this source.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the source database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] exclude_columns: Exclude specific columns when reading data from SQL Server. Can only be updated in place when also updating a corresponding `table` attribute.
        :param pulumi.Input[Union['SourceSqlserverExposeProgressArgs', 'SourceSqlserverExposeProgressArgsDict']] expose_progress: The name of the progress collection for the source. If this is not specified, the collection will be named `<src_name>_progress`.
        :param pulumi.Input[_builtins.str] name: The identifier for the source.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the source schema in Materialize. Defaults to `public`.
        :param pulumi.Input[Union['SourceSqlserverSqlserverConnectionArgs', 'SourceSqlserverSqlserverConnectionArgsDict']] sqlserver_connection: The SQL Server connection to use in the source.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SourceSqlserverTableArgs', 'SourceSqlserverTableArgsDict']]]] tables: Specify the tables to be included in the source. If not specified, all tables are included.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] text_columns: Decode data as text for specific columns that contain SQL Server types that are unsupported in Materialize. Can only be updated in place when also updating a corresponding `table` attribute.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SourceSqlserverArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A SQL Server source describes a SQL Server database instance you want Materialize to read data from using Change Data Capture (CDC).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        sqlserver_password = materialize.Secret("sqlserverPassword",
            value="some-secret-value",
            comment="secret comment")
        sqlserver_connection = materialize.ConnectionSqlserver("sqlserverConnection",
            host="sql-server.example.com",
            port=1433,
            user={
                "text": "sqluser",
            },
            password={
                "name": sqlserver_password.name,
                "schema_name": sqlserver_password.schema_name,
                "database_name": sqlserver_password.database_name,
            },
            database="testdb")
        # Basic SQL Server source for specific tables
        example = materialize.SourceSqlserver("example",
            cluster_name="quickstart",
            sqlserver_connection={
                "name": sqlserver_connection.name,
                "schema_name": sqlserver_connection.schema_name,
                "database_name": sqlserver_connection.database_name,
            },
            tables=[
                {
                    "upstream_name": "dbo.customers",
                    "name": "customers",
                },
                {
                    "upstream_name": "dbo.orders",
                    "name": "orders",
                },
                {
                    "upstream_name": "dbo.products",
                    "name": "products",
                },
            ])
        # SQL Server source for all tables
        all_tables = materialize.SourceSqlserver("allTables",
            cluster_name="quickstart",
            sqlserver_connection={
                "name": sqlserver_connection.name,
                "schema_name": sqlserver_connection.schema_name,
                "database_name": sqlserver_connection.database_name,
            })
        # No table blocks specified means all tables will be included
        # SQL Server source with text columns and excluded columns
        with_options = materialize.SourceSqlserver("withOptions",
            cluster_name="quickstart",
            sqlserver_connection={
                "name": sqlserver_connection.name,
                "schema_name": sqlserver_connection.schema_name,
                "database_name": sqlserver_connection.database_name,
            },
            tables=[
                {
                    "upstream_name": "dbo.users",
                    "name": "users",
                },
                {
                    "upstream_name": "dbo.posts",
                    "name": "posts",
                },
                {
                    "upstream_name": "dbo.comments",
                    "name": "comments",
                },
            ],
            text_columns=[
                "dbo.users.description",
                "dbo.posts.content",
                "dbo.comments.metadata",
            ],
            exclude_columns=[
                "dbo.users.image_data",
                "dbo.posts.binary_data",
            ])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        #!/bin/bash

        SQL Server sources can be imported using the source name

        ```sh
        $ pulumi import materialize:index/sourceSqlserver:SourceSqlserver example <region>:<source_name>
        ```

        Example

        ```sh
        $ pulumi import materialize:index/sourceSqlserver:SourceSqlserver example aws/us-east-1:my_sqlserver_source
        ```

        :param str resource_name: The name of the resource.
        :param SourceSqlserverArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SourceSqlserverArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_privatelink: Optional[pulumi.Input[Union['SourceSqlserverAwsPrivatelinkArgs', 'SourceSqlserverAwsPrivatelinkArgsDict']]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 expose_progress: Optional[pulumi.Input[Union['SourceSqlserverExposeProgressArgs', 'SourceSqlserverExposeProgressArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sqlserver_connection: Optional[pulumi.Input[Union['SourceSqlserverSqlserverConnectionArgs', 'SourceSqlserverSqlserverConnectionArgsDict']]] = None,
                 tables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SourceSqlserverTableArgs', 'SourceSqlserverTableArgsDict']]]]] = None,
                 text_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SourceSqlserverArgs.__new__(SourceSqlserverArgs)

            __props__.__dict__["aws_privatelink"] = aws_privatelink
            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["comment"] = comment
            __props__.__dict__["database_name"] = database_name
            __props__.__dict__["exclude_columns"] = exclude_columns
            __props__.__dict__["expose_progress"] = expose_progress
            __props__.__dict__["name"] = name
            __props__.__dict__["ownership_role"] = ownership_role
            __props__.__dict__["region"] = region
            __props__.__dict__["schema_name"] = schema_name
            if sqlserver_connection is None and not opts.urn:
                raise TypeError("Missing required property 'sqlserver_connection'")
            __props__.__dict__["sqlserver_connection"] = sqlserver_connection
            __props__.__dict__["tables"] = tables
            __props__.__dict__["text_columns"] = text_columns
            __props__.__dict__["qualified_sql_name"] = None
            __props__.__dict__["size"] = None
        super(SourceSqlserver, __self__).__init__(
            'materialize:index/sourceSqlserver:SourceSqlserver',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws_privatelink: Optional[pulumi.Input[Union['SourceSqlserverAwsPrivatelinkArgs', 'SourceSqlserverAwsPrivatelinkArgsDict']]] = None,
            cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            database_name: Optional[pulumi.Input[_builtins.str]] = None,
            exclude_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            expose_progress: Optional[pulumi.Input[Union['SourceSqlserverExposeProgressArgs', 'SourceSqlserverExposeProgressArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            ownership_role: Optional[pulumi.Input[_builtins.str]] = None,
            qualified_sql_name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            schema_name: Optional[pulumi.Input[_builtins.str]] = None,
            size: Optional[pulumi.Input[_builtins.str]] = None,
            sqlserver_connection: Optional[pulumi.Input[Union['SourceSqlserverSqlserverConnectionArgs', 'SourceSqlserverSqlserverConnectionArgsDict']]] = None,
            tables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SourceSqlserverTableArgs', 'SourceSqlserverTableArgsDict']]]]] = None,
            text_columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'SourceSqlserver':
        """
        Get an existing SourceSqlserver resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SourceSqlserverAwsPrivatelinkArgs', 'SourceSqlserverAwsPrivatelinkArgsDict']] aws_privatelink: The AWS PrivateLink configuration for the SQL Server database.
        :param pulumi.Input[_builtins.str] cluster_name: The cluster to maintain this source.
        :param pulumi.Input[_builtins.str] comment: Comment on an object in the database.
        :param pulumi.Input[_builtins.str] database_name: The identifier for the source database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] exclude_columns: Exclude specific columns when reading data from SQL Server. Can only be updated in place when also updating a corresponding `table` attribute.
        :param pulumi.Input[Union['SourceSqlserverExposeProgressArgs', 'SourceSqlserverExposeProgressArgsDict']] expose_progress: The name of the progress collection for the source. If this is not specified, the collection will be named `<src_name>_progress`.
        :param pulumi.Input[_builtins.str] name: The identifier for the source.
        :param pulumi.Input[_builtins.str] ownership_role: The owernship role of the object.
        :param pulumi.Input[_builtins.str] qualified_sql_name: The fully qualified name of the source.
        :param pulumi.Input[_builtins.str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[_builtins.str] schema_name: The identifier for the source schema in Materialize. Defaults to `public`.
        :param pulumi.Input[_builtins.str] size: The size of the cluster maintaining this source.
        :param pulumi.Input[Union['SourceSqlserverSqlserverConnectionArgs', 'SourceSqlserverSqlserverConnectionArgsDict']] sqlserver_connection: The SQL Server connection to use in the source.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SourceSqlserverTableArgs', 'SourceSqlserverTableArgsDict']]]] tables: Specify the tables to be included in the source. If not specified, all tables are included.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] text_columns: Decode data as text for specific columns that contain SQL Server types that are unsupported in Materialize. Can only be updated in place when also updating a corresponding `table` attribute.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SourceSqlserverState.__new__(_SourceSqlserverState)

        __props__.__dict__["aws_privatelink"] = aws_privatelink
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["comment"] = comment
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["exclude_columns"] = exclude_columns
        __props__.__dict__["expose_progress"] = expose_progress
        __props__.__dict__["name"] = name
        __props__.__dict__["ownership_role"] = ownership_role
        __props__.__dict__["qualified_sql_name"] = qualified_sql_name
        __props__.__dict__["region"] = region
        __props__.__dict__["schema_name"] = schema_name
        __props__.__dict__["size"] = size
        __props__.__dict__["sqlserver_connection"] = sqlserver_connection
        __props__.__dict__["tables"] = tables
        __props__.__dict__["text_columns"] = text_columns
        return SourceSqlserver(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="awsPrivatelink")
    def aws_privatelink(self) -> pulumi.Output[Optional['outputs.SourceSqlserverAwsPrivatelink']]:
        """
        The AWS PrivateLink configuration for the SQL Server database.
        """
        return pulumi.get(self, "aws_privatelink")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[_builtins.str]:
        """
        The cluster to maintain this source.
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The identifier for the source database in Materialize. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @_builtins.property
    @pulumi.getter(name="excludeColumns")
    def exclude_columns(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Exclude specific columns when reading data from SQL Server. Can only be updated in place when also updating a corresponding `table` attribute.
        """
        return pulumi.get(self, "exclude_columns")

    @_builtins.property
    @pulumi.getter(name="exposeProgress")
    def expose_progress(self) -> pulumi.Output[Optional['outputs.SourceSqlserverExposeProgress']]:
        """
        The name of the progress collection for the source. If this is not specified, the collection will be named `<src_name>_progress`.
        """
        return pulumi.get(self, "expose_progress")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The identifier for the source.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> pulumi.Output[_builtins.str]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @_builtins.property
    @pulumi.getter(name="qualifiedSqlName")
    def qualified_sql_name(self) -> pulumi.Output[_builtins.str]:
        """
        The fully qualified name of the source.
        """
        return pulumi.get(self, "qualified_sql_name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The identifier for the source schema in Materialize. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Output[_builtins.str]:
        """
        The size of the cluster maintaining this source.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="sqlserverConnection")
    def sqlserver_connection(self) -> pulumi.Output['outputs.SourceSqlserverSqlserverConnection']:
        """
        The SQL Server connection to use in the source.
        """
        return pulumi.get(self, "sqlserver_connection")

    @_builtins.property
    @pulumi.getter
    def tables(self) -> pulumi.Output[Sequence['outputs.SourceSqlserverTable']]:
        """
        Specify the tables to be included in the source. If not specified, all tables are included.
        """
        return pulumi.get(self, "tables")

    @_builtins.property
    @pulumi.getter(name="textColumns")
    def text_columns(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Decode data as text for specific columns that contain SQL Server types that are unsupported in Materialize. Can only be updated in place when also updating a corresponding `table` attribute.
        """
        return pulumi.get(self, "text_columns")

