# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['SSOConfigArgs', 'SSOConfig']

@pulumi.input_type
class SSOConfigArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[_builtins.bool],
                 public_certificate: pulumi.Input[_builtins.str],
                 sign_request: pulumi.Input[_builtins.bool],
                 sso_endpoint: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 oidc_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_secret: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SSOConfig resource.
        :param pulumi.Input[_builtins.bool] enabled: Whether SSO is enabled or not. If enabled, users will be redirected to the SSO endpoint for authentication. The configuration needs to be valid for SSO to work.
        :param pulumi.Input[_builtins.str] public_certificate: The public certificate of the SSO service. This is used to verify the SSO response. The certificate must be in PEM format. The certificate must be accessible from the browser. If the certificate is not accessible from the browser, you can use the public certificate of the Identity Provider (IdP) instead.
        :param pulumi.Input[_builtins.bool] sign_request: Indicates whether the SSO request needs to be digitally signed.
        :param pulumi.Input[_builtins.str] sso_endpoint: The URL endpoint for the SSO service. This is the URL that users will be redirected to for authentication. The URL must be accessible from the browser.
        :param pulumi.Input[_builtins.str] type: Defines the type of SSO protocol being used (e.g., saml, oidc).
        :param pulumi.Input[_builtins.str] oidc_client_id: The client ID of the OIDC application. This is used to identify the application to the OIDC service. This is required if the type is OIDC.
        :param pulumi.Input[_builtins.str] oidc_secret: The client secret of the OIDC application. This is used to authenticate the application to the OIDC service. This is required if the type is OIDC.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "public_certificate", public_certificate)
        pulumi.set(__self__, "sign_request", sign_request)
        pulumi.set(__self__, "sso_endpoint", sso_endpoint)
        pulumi.set(__self__, "type", type)
        if oidc_client_id is not None:
            pulumi.set(__self__, "oidc_client_id", oidc_client_id)
        if oidc_secret is not None:
            pulumi.set(__self__, "oidc_secret", oidc_secret)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether SSO is enabled or not. If enabled, users will be redirected to the SSO endpoint for authentication. The configuration needs to be valid for SSO to work.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="publicCertificate")
    def public_certificate(self) -> pulumi.Input[_builtins.str]:
        """
        The public certificate of the SSO service. This is used to verify the SSO response. The certificate must be in PEM format. The certificate must be accessible from the browser. If the certificate is not accessible from the browser, you can use the public certificate of the Identity Provider (IdP) instead.
        """
        return pulumi.get(self, "public_certificate")

    @public_certificate.setter
    def public_certificate(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "public_certificate", value)

    @_builtins.property
    @pulumi.getter(name="signRequest")
    def sign_request(self) -> pulumi.Input[_builtins.bool]:
        """
        Indicates whether the SSO request needs to be digitally signed.
        """
        return pulumi.get(self, "sign_request")

    @sign_request.setter
    def sign_request(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "sign_request", value)

    @_builtins.property
    @pulumi.getter(name="ssoEndpoint")
    def sso_endpoint(self) -> pulumi.Input[_builtins.str]:
        """
        The URL endpoint for the SSO service. This is the URL that users will be redirected to for authentication. The URL must be accessible from the browser.
        """
        return pulumi.get(self, "sso_endpoint")

    @sso_endpoint.setter
    def sso_endpoint(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sso_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Defines the type of SSO protocol being used (e.g., saml, oidc).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="oidcClientId")
    def oidc_client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client ID of the OIDC application. This is used to identify the application to the OIDC service. This is required if the type is OIDC.
        """
        return pulumi.get(self, "oidc_client_id")

    @oidc_client_id.setter
    def oidc_client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oidc_client_id", value)

    @_builtins.property
    @pulumi.getter(name="oidcSecret")
    def oidc_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client secret of the OIDC application. This is used to authenticate the application to the OIDC service. This is required if the type is OIDC.
        """
        return pulumi.get(self, "oidc_secret")

    @oidc_secret.setter
    def oidc_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oidc_secret", value)


@pulumi.input_type
class _SSOConfigState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 oidc_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 public_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 sign_request: Optional[pulumi.Input[_builtins.bool]] = None,
                 sso_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SSOConfig resources.
        :param pulumi.Input[_builtins.bool] enabled: Whether SSO is enabled or not. If enabled, users will be redirected to the SSO endpoint for authentication. The configuration needs to be valid for SSO to work.
        :param pulumi.Input[_builtins.str] oidc_client_id: The client ID of the OIDC application. This is used to identify the application to the OIDC service. This is required if the type is OIDC.
        :param pulumi.Input[_builtins.str] oidc_secret: The client secret of the OIDC application. This is used to authenticate the application to the OIDC service. This is required if the type is OIDC.
        :param pulumi.Input[_builtins.str] public_certificate: The public certificate of the SSO service. This is used to verify the SSO response. The certificate must be in PEM format. The certificate must be accessible from the browser. If the certificate is not accessible from the browser, you can use the public certificate of the Identity Provider (IdP) instead.
        :param pulumi.Input[_builtins.bool] sign_request: Indicates whether the SSO request needs to be digitally signed.
        :param pulumi.Input[_builtins.str] sso_endpoint: The URL endpoint for the SSO service. This is the URL that users will be redirected to for authentication. The URL must be accessible from the browser.
        :param pulumi.Input[_builtins.str] type: Defines the type of SSO protocol being used (e.g., saml, oidc).
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if oidc_client_id is not None:
            pulumi.set(__self__, "oidc_client_id", oidc_client_id)
        if oidc_secret is not None:
            pulumi.set(__self__, "oidc_secret", oidc_secret)
        if public_certificate is not None:
            pulumi.set(__self__, "public_certificate", public_certificate)
        if sign_request is not None:
            pulumi.set(__self__, "sign_request", sign_request)
        if sso_endpoint is not None:
            pulumi.set(__self__, "sso_endpoint", sso_endpoint)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether SSO is enabled or not. If enabled, users will be redirected to the SSO endpoint for authentication. The configuration needs to be valid for SSO to work.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="oidcClientId")
    def oidc_client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client ID of the OIDC application. This is used to identify the application to the OIDC service. This is required if the type is OIDC.
        """
        return pulumi.get(self, "oidc_client_id")

    @oidc_client_id.setter
    def oidc_client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oidc_client_id", value)

    @_builtins.property
    @pulumi.getter(name="oidcSecret")
    def oidc_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client secret of the OIDC application. This is used to authenticate the application to the OIDC service. This is required if the type is OIDC.
        """
        return pulumi.get(self, "oidc_secret")

    @oidc_secret.setter
    def oidc_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oidc_secret", value)

    @_builtins.property
    @pulumi.getter(name="publicCertificate")
    def public_certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The public certificate of the SSO service. This is used to verify the SSO response. The certificate must be in PEM format. The certificate must be accessible from the browser. If the certificate is not accessible from the browser, you can use the public certificate of the Identity Provider (IdP) instead.
        """
        return pulumi.get(self, "public_certificate")

    @public_certificate.setter
    def public_certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_certificate", value)

    @_builtins.property
    @pulumi.getter(name="signRequest")
    def sign_request(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the SSO request needs to be digitally signed.
        """
        return pulumi.get(self, "sign_request")

    @sign_request.setter
    def sign_request(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sign_request", value)

    @_builtins.property
    @pulumi.getter(name="ssoEndpoint")
    def sso_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL endpoint for the SSO service. This is the URL that users will be redirected to for authentication. The URL must be accessible from the browser.
        """
        return pulumi.get(self, "sso_endpoint")

    @sso_endpoint.setter
    def sso_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sso_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the type of SSO protocol being used (e.g., saml, oidc).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("materialize:index/sSOConfig:SSOConfig")
class SSOConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 oidc_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 public_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 sign_request: Optional[pulumi.Input[_builtins.bool]] = None,
                 sso_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The SSO configuration resource allows you to create, read, update, and delete SSO configurations.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        example_sso_config = materialize.SSOConfig("exampleSsoConfig",
            enabled=True,
            oidc_client_id="client-id",
            oidc_secret="client-secret",
            public_certificate="PUBLIC_CERTIFICATE",
            sign_request=True,
            sso_endpoint="https://sso.example2.com",
            type="saml")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Retrieve the SSO Configuration ID using the materialize_sso_config data source

        Example of using the data source in your configuration:

        data "materialize_sso_config" "all" {}

        output "sso_config_output" {

            value = data.materialize_sso_config.all

        }

        The SSO configuration ID can be retrieved using the following command:

        terraform output sso_config_output

        Import command:

        ```sh
        $ pulumi import materialize:index/sSOConfig:SSOConfig example <sso_config_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: Whether SSO is enabled or not. If enabled, users will be redirected to the SSO endpoint for authentication. The configuration needs to be valid for SSO to work.
        :param pulumi.Input[_builtins.str] oidc_client_id: The client ID of the OIDC application. This is used to identify the application to the OIDC service. This is required if the type is OIDC.
        :param pulumi.Input[_builtins.str] oidc_secret: The client secret of the OIDC application. This is used to authenticate the application to the OIDC service. This is required if the type is OIDC.
        :param pulumi.Input[_builtins.str] public_certificate: The public certificate of the SSO service. This is used to verify the SSO response. The certificate must be in PEM format. The certificate must be accessible from the browser. If the certificate is not accessible from the browser, you can use the public certificate of the Identity Provider (IdP) instead.
        :param pulumi.Input[_builtins.bool] sign_request: Indicates whether the SSO request needs to be digitally signed.
        :param pulumi.Input[_builtins.str] sso_endpoint: The URL endpoint for the SSO service. This is the URL that users will be redirected to for authentication. The URL must be accessible from the browser.
        :param pulumi.Input[_builtins.str] type: Defines the type of SSO protocol being used (e.g., saml, oidc).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SSOConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The SSO configuration resource allows you to create, read, update, and delete SSO configurations.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        example_sso_config = materialize.SSOConfig("exampleSsoConfig",
            enabled=True,
            oidc_client_id="client-id",
            oidc_secret="client-secret",
            public_certificate="PUBLIC_CERTIFICATE",
            sign_request=True,
            sso_endpoint="https://sso.example2.com",
            type="saml")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Retrieve the SSO Configuration ID using the materialize_sso_config data source

        Example of using the data source in your configuration:

        data "materialize_sso_config" "all" {}

        output "sso_config_output" {

            value = data.materialize_sso_config.all

        }

        The SSO configuration ID can be retrieved using the following command:

        terraform output sso_config_output

        Import command:

        ```sh
        $ pulumi import materialize:index/sSOConfig:SSOConfig example <sso_config_id>
        ```

        :param str resource_name: The name of the resource.
        :param SSOConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SSOConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 oidc_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 public_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 sign_request: Optional[pulumi.Input[_builtins.bool]] = None,
                 sso_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SSOConfigArgs.__new__(SSOConfigArgs)

            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["oidc_client_id"] = oidc_client_id
            __props__.__dict__["oidc_secret"] = oidc_secret
            if public_certificate is None and not opts.urn:
                raise TypeError("Missing required property 'public_certificate'")
            __props__.__dict__["public_certificate"] = public_certificate
            if sign_request is None and not opts.urn:
                raise TypeError("Missing required property 'sign_request'")
            __props__.__dict__["sign_request"] = sign_request
            if sso_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'sso_endpoint'")
            __props__.__dict__["sso_endpoint"] = sso_endpoint
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
        super(SSOConfig, __self__).__init__(
            'materialize:index/sSOConfig:SSOConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            oidc_client_id: Optional[pulumi.Input[_builtins.str]] = None,
            oidc_secret: Optional[pulumi.Input[_builtins.str]] = None,
            public_certificate: Optional[pulumi.Input[_builtins.str]] = None,
            sign_request: Optional[pulumi.Input[_builtins.bool]] = None,
            sso_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'SSOConfig':
        """
        Get an existing SSOConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: Whether SSO is enabled or not. If enabled, users will be redirected to the SSO endpoint for authentication. The configuration needs to be valid for SSO to work.
        :param pulumi.Input[_builtins.str] oidc_client_id: The client ID of the OIDC application. This is used to identify the application to the OIDC service. This is required if the type is OIDC.
        :param pulumi.Input[_builtins.str] oidc_secret: The client secret of the OIDC application. This is used to authenticate the application to the OIDC service. This is required if the type is OIDC.
        :param pulumi.Input[_builtins.str] public_certificate: The public certificate of the SSO service. This is used to verify the SSO response. The certificate must be in PEM format. The certificate must be accessible from the browser. If the certificate is not accessible from the browser, you can use the public certificate of the Identity Provider (IdP) instead.
        :param pulumi.Input[_builtins.bool] sign_request: Indicates whether the SSO request needs to be digitally signed.
        :param pulumi.Input[_builtins.str] sso_endpoint: The URL endpoint for the SSO service. This is the URL that users will be redirected to for authentication. The URL must be accessible from the browser.
        :param pulumi.Input[_builtins.str] type: Defines the type of SSO protocol being used (e.g., saml, oidc).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SSOConfigState.__new__(_SSOConfigState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["oidc_client_id"] = oidc_client_id
        __props__.__dict__["oidc_secret"] = oidc_secret
        __props__.__dict__["public_certificate"] = public_certificate
        __props__.__dict__["sign_request"] = sign_request
        __props__.__dict__["sso_endpoint"] = sso_endpoint
        __props__.__dict__["type"] = type
        return SSOConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether SSO is enabled or not. If enabled, users will be redirected to the SSO endpoint for authentication. The configuration needs to be valid for SSO to work.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="oidcClientId")
    def oidc_client_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The client ID of the OIDC application. This is used to identify the application to the OIDC service. This is required if the type is OIDC.
        """
        return pulumi.get(self, "oidc_client_id")

    @_builtins.property
    @pulumi.getter(name="oidcSecret")
    def oidc_secret(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The client secret of the OIDC application. This is used to authenticate the application to the OIDC service. This is required if the type is OIDC.
        """
        return pulumi.get(self, "oidc_secret")

    @_builtins.property
    @pulumi.getter(name="publicCertificate")
    def public_certificate(self) -> pulumi.Output[_builtins.str]:
        """
        The public certificate of the SSO service. This is used to verify the SSO response. The certificate must be in PEM format. The certificate must be accessible from the browser. If the certificate is not accessible from the browser, you can use the public certificate of the Identity Provider (IdP) instead.
        """
        return pulumi.get(self, "public_certificate")

    @_builtins.property
    @pulumi.getter(name="signRequest")
    def sign_request(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the SSO request needs to be digitally signed.
        """
        return pulumi.get(self, "sign_request")

    @_builtins.property
    @pulumi.getter(name="ssoEndpoint")
    def sso_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The URL endpoint for the SSO service. This is the URL that users will be redirected to for authentication. The URL must be accessible from the browser.
        """
        return pulumi.get(self, "sso_endpoint")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Defines the type of SSO protocol being used (e.g., saml, oidc).
        """
        return pulumi.get(self, "type")

