# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['SSODefaultRolesArgs', 'SSODefaultRoles']

@pulumi.input_type
class SSODefaultRolesArgs:
    def __init__(__self__, *,
                 roles: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 sso_config_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a SSODefaultRoles resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] roles: Set of default role names for the SSO configuration. These roles will be assigned by default to users who sign up via SSO.
        :param pulumi.Input[_builtins.str] sso_config_id: The ID of the associated SSO configuration.
        """
        pulumi.set(__self__, "roles", roles)
        pulumi.set(__self__, "sso_config_id", sso_config_id)

    @_builtins.property
    @pulumi.getter
    def roles(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Set of default role names for the SSO configuration. These roles will be assigned by default to users who sign up via SSO.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "roles", value)

    @_builtins.property
    @pulumi.getter(name="ssoConfigId")
    def sso_config_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the associated SSO configuration.
        """
        return pulumi.get(self, "sso_config_id")

    @sso_config_id.setter
    def sso_config_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sso_config_id", value)


@pulumi.input_type
class _SSODefaultRolesState:
    def __init__(__self__, *,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sso_config_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SSODefaultRoles resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] roles: Set of default role names for the SSO configuration. These roles will be assigned by default to users who sign up via SSO.
        :param pulumi.Input[_builtins.str] sso_config_id: The ID of the associated SSO configuration.
        """
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if sso_config_id is not None:
            pulumi.set(__self__, "sso_config_id", sso_config_id)

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set of default role names for the SSO configuration. These roles will be assigned by default to users who sign up via SSO.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "roles", value)

    @_builtins.property
    @pulumi.getter(name="ssoConfigId")
    def sso_config_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the associated SSO configuration.
        """
        return pulumi.get(self, "sso_config_id")

    @sso_config_id.setter
    def sso_config_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sso_config_id", value)


@pulumi.type_token("materialize:index/sSODefaultRoles:SSODefaultRoles")
class SSODefaultRoles(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sso_config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The SSO default roles resource allows you to set the default roles for an SSO configuration. These roles will be assigned to users who sign in with SSO.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        example_sso_default_roles = materialize.SSODefaultRoles("exampleSsoDefaultRoles",
            sso_config_id=materialize_sso_config["example_sso_config"]["id"],
            roles=["Admin"])
        example_sso_default_roles2 = materialize.SSODefaultRoles("exampleSsoDefaultRoles2",
            sso_config_id=materialize_sso_config["example_sso_config"]["id"],
            roles=[
                "Admin",
                "Member",
            ])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Retrieve the SSO Configuration ID using the materialize_sso_config data source

        Example of using the data source in your configuration:

        data "materialize_sso_config" "all" {}

        output "sso_config_output" {

            value = data.materialize_sso_config.all

        }

        The SSO configuration ID can be retrieved using the following command:

        terraform output sso_config_output

        Import command:

        ```sh
        $ pulumi import materialize:index/sSODefaultRoles:SSODefaultRoles example_role <configuration_id>
        ```

        Note: Replace <configuration_id> with the actual ID of the SSO configuration

        whose default roles you want to import

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] roles: Set of default role names for the SSO configuration. These roles will be assigned by default to users who sign up via SSO.
        :param pulumi.Input[_builtins.str] sso_config_id: The ID of the associated SSO configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SSODefaultRolesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The SSO default roles resource allows you to set the default roles for an SSO configuration. These roles will be assigned to users who sign in with SSO.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        example_sso_default_roles = materialize.SSODefaultRoles("exampleSsoDefaultRoles",
            sso_config_id=materialize_sso_config["example_sso_config"]["id"],
            roles=["Admin"])
        example_sso_default_roles2 = materialize.SSODefaultRoles("exampleSsoDefaultRoles2",
            sso_config_id=materialize_sso_config["example_sso_config"]["id"],
            roles=[
                "Admin",
                "Member",
            ])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Retrieve the SSO Configuration ID using the materialize_sso_config data source

        Example of using the data source in your configuration:

        data "materialize_sso_config" "all" {}

        output "sso_config_output" {

            value = data.materialize_sso_config.all

        }

        The SSO configuration ID can be retrieved using the following command:

        terraform output sso_config_output

        Import command:

        ```sh
        $ pulumi import materialize:index/sSODefaultRoles:SSODefaultRoles example_role <configuration_id>
        ```

        Note: Replace <configuration_id> with the actual ID of the SSO configuration

        whose default roles you want to import

        :param str resource_name: The name of the resource.
        :param SSODefaultRolesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SSODefaultRolesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sso_config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SSODefaultRolesArgs.__new__(SSODefaultRolesArgs)

            if roles is None and not opts.urn:
                raise TypeError("Missing required property 'roles'")
            __props__.__dict__["roles"] = roles
            if sso_config_id is None and not opts.urn:
                raise TypeError("Missing required property 'sso_config_id'")
            __props__.__dict__["sso_config_id"] = sso_config_id
        super(SSODefaultRoles, __self__).__init__(
            'materialize:index/sSODefaultRoles:SSODefaultRoles',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            sso_config_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'SSODefaultRoles':
        """
        Get an existing SSODefaultRoles resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] roles: Set of default role names for the SSO configuration. These roles will be assigned by default to users who sign up via SSO.
        :param pulumi.Input[_builtins.str] sso_config_id: The ID of the associated SSO configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SSODefaultRolesState.__new__(_SSODefaultRolesState)

        __props__.__dict__["roles"] = roles
        __props__.__dict__["sso_config_id"] = sso_config_id
        return SSODefaultRoles(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def roles(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Set of default role names for the SSO configuration. These roles will be assigned by default to users who sign up via SSO.
        """
        return pulumi.get(self, "roles")

    @_builtins.property
    @pulumi.getter(name="ssoConfigId")
    def sso_config_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the associated SSO configuration.
        """
        return pulumi.get(self, "sso_config_id")

