# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['SSODomainArgs', 'SSODomain']

@pulumi.input_type
class SSODomainArgs:
    def __init__(__self__, *,
                 domain: pulumi.Input[_builtins.str],
                 sso_config_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a SSODomain resource.
        :param pulumi.Input[_builtins.str] domain: The domain name for the SSO domain configuration. This domain will be used to validate the SSO configuration and needs to be unique across all SSO configurations.
        :param pulumi.Input[_builtins.str] sso_config_id: The ID of the associated SSO configuration.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "sso_config_id", sso_config_id)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Input[_builtins.str]:
        """
        The domain name for the SSO domain configuration. This domain will be used to validate the SSO configuration and needs to be unique across all SSO configurations.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter(name="ssoConfigId")
    def sso_config_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the associated SSO configuration.
        """
        return pulumi.get(self, "sso_config_id")

    @sso_config_id.setter
    def sso_config_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sso_config_id", value)


@pulumi.input_type
class _SSODomainState:
    def __init__(__self__, *,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 sso_config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 validated: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering SSODomain resources.
        :param pulumi.Input[_builtins.str] domain: The domain name for the SSO domain configuration. This domain will be used to validate the SSO configuration and needs to be unique across all SSO configurations.
        :param pulumi.Input[_builtins.str] sso_config_id: The ID of the associated SSO configuration.
        :param pulumi.Input[_builtins.bool] validated: Indicates whether the domain has been validated.
        """
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if sso_config_id is not None:
            pulumi.set(__self__, "sso_config_id", sso_config_id)
        if validated is not None:
            pulumi.set(__self__, "validated", validated)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain name for the SSO domain configuration. This domain will be used to validate the SSO configuration and needs to be unique across all SSO configurations.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter(name="ssoConfigId")
    def sso_config_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the associated SSO configuration.
        """
        return pulumi.get(self, "sso_config_id")

    @sso_config_id.setter
    def sso_config_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sso_config_id", value)

    @_builtins.property
    @pulumi.getter
    def validated(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the domain has been validated.
        """
        return pulumi.get(self, "validated")

    @validated.setter
    def validated(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "validated", value)


@pulumi.type_token("materialize:index/sSODomain:SSODomain")
class SSODomain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 sso_config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The SSO domain resource allows you to set the domain for an SSO configuration. This domain will be used to validate the SSO configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        example_sso_domain = materialize.SSODomain("exampleSsoDomain",
            domain="example.com",
            sso_config_id=materialize_sso_config["example_sso_config"]["id"])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Retrieve the SSO Configuration ID using the materialize_sso_config data source

        Example of using the data source in your configuration:

        data "materialize_sso_config" "all" {}

        output "sso_config_output" {

            value = data.materialize_sso_config.all

        }

        The SSO Configuration ID can be retrieved using the following command:

        terraform output sso_config_output

        Import command:

        ```sh
        $ pulumi import materialize:index/sSODomain:SSODomain example <sso_config_id>:<domain.com>
        ```

        Note: Replace <sso_config_id> with the actual ID of the SSO configuration

        and <domain.com> with the actual domain you want to import

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] domain: The domain name for the SSO domain configuration. This domain will be used to validate the SSO configuration and needs to be unique across all SSO configurations.
        :param pulumi.Input[_builtins.str] sso_config_id: The ID of the associated SSO configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SSODomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The SSO domain resource allows you to set the domain for an SSO configuration. This domain will be used to validate the SSO configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        example_sso_domain = materialize.SSODomain("exampleSsoDomain",
            domain="example.com",
            sso_config_id=materialize_sso_config["example_sso_config"]["id"])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Retrieve the SSO Configuration ID using the materialize_sso_config data source

        Example of using the data source in your configuration:

        data "materialize_sso_config" "all" {}

        output "sso_config_output" {

            value = data.materialize_sso_config.all

        }

        The SSO Configuration ID can be retrieved using the following command:

        terraform output sso_config_output

        Import command:

        ```sh
        $ pulumi import materialize:index/sSODomain:SSODomain example <sso_config_id>:<domain.com>
        ```

        Note: Replace <sso_config_id> with the actual ID of the SSO configuration

        and <domain.com> with the actual domain you want to import

        :param str resource_name: The name of the resource.
        :param SSODomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SSODomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 sso_config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SSODomainArgs.__new__(SSODomainArgs)

            if domain is None and not opts.urn:
                raise TypeError("Missing required property 'domain'")
            __props__.__dict__["domain"] = domain
            if sso_config_id is None and not opts.urn:
                raise TypeError("Missing required property 'sso_config_id'")
            __props__.__dict__["sso_config_id"] = sso_config_id
            __props__.__dict__["validated"] = None
        super(SSODomain, __self__).__init__(
            'materialize:index/sSODomain:SSODomain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            domain: Optional[pulumi.Input[_builtins.str]] = None,
            sso_config_id: Optional[pulumi.Input[_builtins.str]] = None,
            validated: Optional[pulumi.Input[_builtins.bool]] = None) -> 'SSODomain':
        """
        Get an existing SSODomain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] domain: The domain name for the SSO domain configuration. This domain will be used to validate the SSO configuration and needs to be unique across all SSO configurations.
        :param pulumi.Input[_builtins.str] sso_config_id: The ID of the associated SSO configuration.
        :param pulumi.Input[_builtins.bool] validated: Indicates whether the domain has been validated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SSODomainState.__new__(_SSODomainState)

        __props__.__dict__["domain"] = domain
        __props__.__dict__["sso_config_id"] = sso_config_id
        __props__.__dict__["validated"] = validated
        return SSODomain(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Output[_builtins.str]:
        """
        The domain name for the SSO domain configuration. This domain will be used to validate the SSO configuration and needs to be unique across all SSO configurations.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="ssoConfigId")
    def sso_config_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the associated SSO configuration.
        """
        return pulumi.get(self, "sso_config_id")

    @_builtins.property
    @pulumi.getter
    def validated(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the domain has been validated.
        """
        return pulumi.get(self, "validated")

