# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 email: pulumi.Input[_builtins.str],
                 roles: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 send_activation_email: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[_builtins.str] email: The email address of the user. This must be unique across all users in the organization.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] roles: The roles to assign to the user. Allowed values are 'Member' and 'Admin'.
        :param pulumi.Input[_builtins.bool] send_activation_email: Whether to send an email either inviting the user to activate their account, if the user is new, or inviting the user to join the organization, if the user already exists in another organization. Changing this property after the resource is created has no effect.
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "roles", roles)
        if send_activation_email is not None:
            pulumi.set(__self__, "send_activation_email", send_activation_email)

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Input[_builtins.str]:
        """
        The email address of the user. This must be unique across all users in the organization.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter
    def roles(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The roles to assign to the user. Allowed values are 'Member' and 'Admin'.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "roles", value)

    @_builtins.property
    @pulumi.getter(name="sendActivationEmail")
    def send_activation_email(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to send an email either inviting the user to activate their account, if the user is new, or inviting the user to join the organization, if the user already exists in another organization. Changing this property after the resource is created has no effect.
        """
        return pulumi.get(self, "send_activation_email")

    @send_activation_email.setter
    def send_activation_email(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "send_activation_email", value)


@pulumi.input_type
class _UserState:
    def __init__(__self__, *,
                 auth_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 send_activation_email: Optional[pulumi.Input[_builtins.bool]] = None,
                 verified: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering User resources.
        :param pulumi.Input[_builtins.str] auth_provider: The authentication provider for the user.
        :param pulumi.Input[_builtins.str] email: The email address of the user. This must be unique across all users in the organization.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] roles: The roles to assign to the user. Allowed values are 'Member' and 'Admin'.
        :param pulumi.Input[_builtins.bool] send_activation_email: Whether to send an email either inviting the user to activate their account, if the user is new, or inviting the user to join the organization, if the user already exists in another organization. Changing this property after the resource is created has no effect.
        """
        if auth_provider is not None:
            pulumi.set(__self__, "auth_provider", auth_provider)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if send_activation_email is not None:
            pulumi.set(__self__, "send_activation_email", send_activation_email)
        if verified is not None:
            pulumi.set(__self__, "verified", verified)

    @_builtins.property
    @pulumi.getter(name="authProvider")
    def auth_provider(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authentication provider for the user.
        """
        return pulumi.get(self, "auth_provider")

    @auth_provider.setter
    def auth_provider(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_provider", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The email address of the user. This must be unique across all users in the organization.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The roles to assign to the user. Allowed values are 'Member' and 'Admin'.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "roles", value)

    @_builtins.property
    @pulumi.getter(name="sendActivationEmail")
    def send_activation_email(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to send an email either inviting the user to activate their account, if the user is new, or inviting the user to join the organization, if the user already exists in another organization. Changing this property after the resource is created has no effect.
        """
        return pulumi.get(self, "send_activation_email")

    @send_activation_email.setter
    def send_activation_email(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "send_activation_email", value)

    @_builtins.property
    @pulumi.getter
    def verified(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "verified")

    @verified.setter
    def verified(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "verified", value)


@pulumi.type_token("materialize:index/user:User")
class User(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 send_activation_email: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        The user resource allows you to invite and delete users in your Materialize organization.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        example_user = materialize.User("exampleUser",
            email="example-user@example.com",
            roles=[
                "Member",
                "Admin",
            ])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Retrieve the User ID using the materialize_user data source

        Example of using the data source in your configuration:

        data "materialize_user" "example_user" {

          email = "example@example.com"

        }

        output "user_output" {

          value = data.materialize_user.example_user

        }

        The User ID can be retrieved using the following command:

        terraform output -json user_output | jq '.id'

        Import command:

        ```sh
        $ pulumi import materialize:index/user:User example_user <user_id>
        ```

        Note: Replace <user_id> with the actual ID of the user you want to import

        You can find the user ID by querying the data source with the user's email

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] email: The email address of the user. This must be unique across all users in the organization.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] roles: The roles to assign to the user. Allowed values are 'Member' and 'Admin'.
        :param pulumi.Input[_builtins.bool] send_activation_email: Whether to send an email either inviting the user to activate their account, if the user is new, or inviting the user to join the organization, if the user already exists in another organization. Changing this property after the resource is created has no effect.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The user resource allows you to invite and delete users in your Materialize organization.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        example_user = materialize.User("exampleUser",
            email="example-user@example.com",
            roles=[
                "Member",
                "Admin",
            ])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Retrieve the User ID using the materialize_user data source

        Example of using the data source in your configuration:

        data "materialize_user" "example_user" {

          email = "example@example.com"

        }

        output "user_output" {

          value = data.materialize_user.example_user

        }

        The User ID can be retrieved using the following command:

        terraform output -json user_output | jq '.id'

        Import command:

        ```sh
        $ pulumi import materialize:index/user:User example_user <user_id>
        ```

        Note: Replace <user_id> with the actual ID of the user you want to import

        You can find the user ID by querying the data source with the user's email

        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 send_activation_email: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = email
            if roles is None and not opts.urn:
                raise TypeError("Missing required property 'roles'")
            __props__.__dict__["roles"] = roles
            __props__.__dict__["send_activation_email"] = send_activation_email
            __props__.__dict__["auth_provider"] = None
            __props__.__dict__["metadata"] = None
            __props__.__dict__["verified"] = None
        super(User, __self__).__init__(
            'materialize:index/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auth_provider: Optional[pulumi.Input[_builtins.str]] = None,
            email: Optional[pulumi.Input[_builtins.str]] = None,
            metadata: Optional[pulumi.Input[_builtins.str]] = None,
            roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            send_activation_email: Optional[pulumi.Input[_builtins.bool]] = None,
            verified: Optional[pulumi.Input[_builtins.bool]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auth_provider: The authentication provider for the user.
        :param pulumi.Input[_builtins.str] email: The email address of the user. This must be unique across all users in the organization.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] roles: The roles to assign to the user. Allowed values are 'Member' and 'Admin'.
        :param pulumi.Input[_builtins.bool] send_activation_email: Whether to send an email either inviting the user to activate their account, if the user is new, or inviting the user to join the organization, if the user already exists in another organization. Changing this property after the resource is created has no effect.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserState.__new__(_UserState)

        __props__.__dict__["auth_provider"] = auth_provider
        __props__.__dict__["email"] = email
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["roles"] = roles
        __props__.__dict__["send_activation_email"] = send_activation_email
        __props__.__dict__["verified"] = verified
        return User(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authProvider")
    def auth_provider(self) -> pulumi.Output[_builtins.str]:
        """
        The authentication provider for the user.
        """
        return pulumi.get(self, "auth_provider")

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Output[_builtins.str]:
        """
        The email address of the user. This must be unique across all users in the organization.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def roles(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The roles to assign to the user. Allowed values are 'Member' and 'Admin'.
        """
        return pulumi.get(self, "roles")

    @_builtins.property
    @pulumi.getter(name="sendActivationEmail")
    def send_activation_email(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to send an email either inviting the user to activate their account, if the user is new, or inviting the user to join the organization, if the user already exists in another organization. Changing this property after the resource is created has no effect.
        """
        return pulumi.get(self, "send_activation_email")

    @_builtins.property
    @pulumi.getter
    def verified(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "verified")

