<a id="mypy-boto3-location"></a>

# mypy-boto3-location

[![PyPI - mypy-boto3-location](https://img.shields.io/pypi/v/mypy-boto3-location.svg?color=blue)](https://pypi.org/project/mypy-boto3-location)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-location.svg?color=blue)](https://pypi.org/project/mypy-boto3-location)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-location?color=blue)](https://pypistats.org/packages/mypy-boto3-location)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.LocationService 1.18.20](https://boto3.amazonaws.com/v1/documentation/api/1.18.20/reference/services/location.html#LocationService)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 5.1.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-location docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_location/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-location](#mypy-boto3-location)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `LocationService` service.

```bash
python -m pip install boto3-stubs[location]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[location]` in your environment:
  `python -m pip install 'boto3-stubs[location]'`

Both type checking and auto-complete should work for `LocationService` service.
No explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[location]` in your environment:
  `python -m pip install 'boto3-stubs[location]'`

Both type checking and auto-complete should work for `LocationService` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[location]` in your environment:
  `python -m pip install 'boto3-stubs[location]'`
- Run `mypy` as usual

Type checking should work for `LocationService` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[location]` in your environment:
  `python -m pip install 'boto3-stubs[location]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `LocationService` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`LocationServiceClient` provides annotations for `boto3.client("location")`.

```python
import boto3

from mypy_boto3_location import LocationServiceClient

client: LocationServiceClient = boto3.client("location")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: LocationServiceClient = session.client("location")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_location.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_location import LocationServiceClient
from mypy_boto3_location.paginator import (
    GetDevicePositionHistoryPaginator,
    ListDevicePositionsPaginator,
    ListGeofenceCollectionsPaginator,
    ListGeofencesPaginator,
    ListMapsPaginator,
    ListPlaceIndexesPaginator,
    ListRouteCalculatorsPaginator,
    ListTrackerConsumersPaginator,
    ListTrackersPaginator,
)

client: LocationServiceClient = boto3.client("location")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
get_device_position_history_paginator: GetDevicePositionHistoryPaginator = client.get_paginator("get_device_position_history")
list_device_positions_paginator: ListDevicePositionsPaginator = client.get_paginator("list_device_positions")
list_geofence_collections_paginator: ListGeofenceCollectionsPaginator = client.get_paginator("list_geofence_collections")
list_geofences_paginator: ListGeofencesPaginator = client.get_paginator("list_geofences")
list_maps_paginator: ListMapsPaginator = client.get_paginator("list_maps")
list_place_indexes_paginator: ListPlaceIndexesPaginator = client.get_paginator("list_place_indexes")
list_route_calculators_paginator: ListRouteCalculatorsPaginator = client.get_paginator("list_route_calculators")
list_tracker_consumers_paginator: ListTrackerConsumersPaginator = client.get_paginator("list_tracker_consumers")
list_trackers_paginator: ListTrackersPaginator = client.get_paginator("list_trackers")
```

<a id="literals"></a>

### Literals

`mypy_boto3_location.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_location.literals import (
    BatchItemErrorCodeType,
    DimensionUnitType,
    DistanceUnitType,
    GetDevicePositionHistoryPaginatorName,
    IntendedUseType,
    ListDevicePositionsPaginatorName,
    ListGeofenceCollectionsPaginatorName,
    ListGeofencesPaginatorName,
    ListMapsPaginatorName,
    ListPlaceIndexesPaginatorName,
    ListRouteCalculatorsPaginatorName,
    ListTrackerConsumersPaginatorName,
    ListTrackersPaginatorName,
    PricingPlanType,
    TravelModeType,
    VehicleWeightUnitType,
)

def check_value(value: BatchItemErrorCodeType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_location.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_location.type_defs import (
    AssociateTrackerConsumerRequestRequestTypeDef,
    BatchDeleteDevicePositionHistoryErrorTypeDef,
    BatchDeleteDevicePositionHistoryRequestRequestTypeDef,
    BatchDeleteDevicePositionHistoryResponseTypeDef,
    BatchDeleteGeofenceErrorTypeDef,
    BatchDeleteGeofenceRequestRequestTypeDef,
    BatchDeleteGeofenceResponseTypeDef,
    BatchEvaluateGeofencesErrorTypeDef,
    BatchEvaluateGeofencesRequestRequestTypeDef,
    BatchEvaluateGeofencesResponseTypeDef,
    BatchGetDevicePositionErrorTypeDef,
    BatchGetDevicePositionRequestRequestTypeDef,
    BatchGetDevicePositionResponseTypeDef,
    BatchItemErrorTypeDef,
    BatchPutGeofenceErrorTypeDef,
    BatchPutGeofenceRequestEntryTypeDef,
    BatchPutGeofenceRequestRequestTypeDef,
    BatchPutGeofenceResponseTypeDef,
    BatchPutGeofenceSuccessTypeDef,
    BatchUpdateDevicePositionErrorTypeDef,
    BatchUpdateDevicePositionRequestRequestTypeDef,
    BatchUpdateDevicePositionResponseTypeDef,
    CalculateRouteCarModeOptionsTypeDef,
    CalculateRouteRequestRequestTypeDef,
    CalculateRouteResponseTypeDef,
    CalculateRouteSummaryTypeDef,
    CalculateRouteTruckModeOptionsTypeDef,
    CreateGeofenceCollectionRequestRequestTypeDef,
    CreateGeofenceCollectionResponseTypeDef,
    CreateMapRequestRequestTypeDef,
    CreateMapResponseTypeDef,
    CreatePlaceIndexRequestRequestTypeDef,
    CreatePlaceIndexResponseTypeDef,
    CreateRouteCalculatorRequestRequestTypeDef,
    CreateRouteCalculatorResponseTypeDef,
    CreateTrackerRequestRequestTypeDef,
    CreateTrackerResponseTypeDef,
    DataSourceConfigurationTypeDef,
    DeleteGeofenceCollectionRequestRequestTypeDef,
    DeleteMapRequestRequestTypeDef,
    DeletePlaceIndexRequestRequestTypeDef,
    DeleteRouteCalculatorRequestRequestTypeDef,
    DeleteTrackerRequestRequestTypeDef,
    DescribeGeofenceCollectionRequestRequestTypeDef,
    DescribeGeofenceCollectionResponseTypeDef,
    DescribeMapRequestRequestTypeDef,
    DescribeMapResponseTypeDef,
    DescribePlaceIndexRequestRequestTypeDef,
    DescribePlaceIndexResponseTypeDef,
    DescribeRouteCalculatorRequestRequestTypeDef,
    DescribeRouteCalculatorResponseTypeDef,
    DescribeTrackerRequestRequestTypeDef,
    DescribeTrackerResponseTypeDef,
    DevicePositionTypeDef,
    DevicePositionUpdateTypeDef,
    DisassociateTrackerConsumerRequestRequestTypeDef,
    GeofenceGeometryTypeDef,
    GetDevicePositionHistoryRequestRequestTypeDef,
    GetDevicePositionHistoryResponseTypeDef,
    GetDevicePositionRequestRequestTypeDef,
    GetDevicePositionResponseTypeDef,
    GetGeofenceRequestRequestTypeDef,
    GetGeofenceResponseTypeDef,
    GetMapGlyphsRequestRequestTypeDef,
    GetMapGlyphsResponseTypeDef,
    GetMapSpritesRequestRequestTypeDef,
    GetMapSpritesResponseTypeDef,
    GetMapStyleDescriptorRequestRequestTypeDef,
    GetMapStyleDescriptorResponseTypeDef,
    GetMapTileRequestRequestTypeDef,
    GetMapTileResponseTypeDef,
    LegGeometryTypeDef,
    LegTypeDef,
    ListDevicePositionsRequestRequestTypeDef,
    ListDevicePositionsResponseEntryTypeDef,
    ListDevicePositionsResponseTypeDef,
    ListGeofenceCollectionsRequestRequestTypeDef,
    ListGeofenceCollectionsResponseEntryTypeDef,
    ListGeofenceCollectionsResponseTypeDef,
    ListGeofenceResponseEntryTypeDef,
    ListGeofencesRequestRequestTypeDef,
    ListGeofencesResponseTypeDef,
    ListMapsRequestRequestTypeDef,
    ListMapsResponseEntryTypeDef,
    ListMapsResponseTypeDef,
    ListPlaceIndexesRequestRequestTypeDef,
    ListPlaceIndexesResponseEntryTypeDef,
    ListPlaceIndexesResponseTypeDef,
    ListRouteCalculatorsRequestRequestTypeDef,
    ListRouteCalculatorsResponseEntryTypeDef,
    ListRouteCalculatorsResponseTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListTrackerConsumersRequestRequestTypeDef,
    ListTrackerConsumersResponseTypeDef,
    ListTrackersRequestRequestTypeDef,
    ListTrackersResponseEntryTypeDef,
    ListTrackersResponseTypeDef,
    MapConfigurationTypeDef,
    PaginatorConfigTypeDef,
    PlaceGeometryTypeDef,
    PlaceTypeDef,
    PutGeofenceRequestRequestTypeDef,
    PutGeofenceResponseTypeDef,
    ResponseMetadataTypeDef,
    SearchForPositionResultTypeDef,
    SearchForTextResultTypeDef,
    SearchPlaceIndexForPositionRequestRequestTypeDef,
    SearchPlaceIndexForPositionResponseTypeDef,
    SearchPlaceIndexForPositionSummaryTypeDef,
    SearchPlaceIndexForTextRequestRequestTypeDef,
    SearchPlaceIndexForTextResponseTypeDef,
    SearchPlaceIndexForTextSummaryTypeDef,
    StepTypeDef,
    TagResourceRequestRequestTypeDef,
    TruckDimensionsTypeDef,
    TruckWeightTypeDef,
    UntagResourceRequestRequestTypeDef,
    UpdateGeofenceCollectionRequestRequestTypeDef,
    UpdateGeofenceCollectionResponseTypeDef,
    UpdateMapRequestRequestTypeDef,
    UpdateMapResponseTypeDef,
    UpdatePlaceIndexRequestRequestTypeDef,
    UpdatePlaceIndexResponseTypeDef,
    UpdateRouteCalculatorRequestRequestTypeDef,
    UpdateRouteCalculatorResponseTypeDef,
    UpdateTrackerRequestRequestTypeDef,
    UpdateTrackerResponseTypeDef,
)

def get_structure() -> AssociateTrackerConsumerRequestRequestTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-location` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-location docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_location/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
