"""Initial tables

Peek Plugin Database Migration Script

Revision ID: 53e411bea4ab
Revises: 
Create Date: 2019-05-03 16:06:24.735325

"""

# revision identifiers, used by Alembic.
revision = '53e411bea4ab'
down_revision = None
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa
import geoalchemy2


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('BranchDetail',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('modelSetKey', sa.String(), nullable=False),
    sa.Column('key', sa.String(), nullable=False),
    sa.Column('location', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(), nullable=False),
    sa.Column('comment', sa.String(), nullable=True),
    sa.Column('userName', sa.String(), nullable=False),
    sa.Column('updatedDate', sa.DateTime(timezone=True), nullable=False),
    sa.Column('createdDate', sa.DateTime(timezone=True), nullable=False),
    sa.PrimaryKeyConstraint('id'),
    schema='pl_branch'
    )
    op.create_table('Setting',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('name', sa.String(), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    schema='pl_branch'
    )
    op.create_table('SettingProperty',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('settingId', sa.Integer(), nullable=False),
    sa.Column('key', sa.String(length=50), nullable=False),
    sa.Column('type', sa.String(length=16), nullable=True),
    sa.Column('int_value', sa.Integer(), nullable=True),
    sa.Column('char_value', sa.String(), nullable=True),
    sa.Column('boolean_value', sa.Boolean(), nullable=True),
    sa.ForeignKeyConstraint(['settingId'], ['pl_branch.Setting.id'], ),
    sa.PrimaryKeyConstraint('id'),
    schema='pl_branch'
    )
    op.create_index('idx_SettingProperty_settingId', 'SettingProperty', ['settingId'], unique=False, schema='pl_branch')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('idx_SettingProperty_settingId', table_name='SettingProperty', schema='pl_branch')
    op.drop_table('SettingProperty', schema='pl_branch')
    op.drop_table('Setting', schema='pl_branch')
    op.drop_table('BranchDetail', schema='pl_branch')
    # ### end Alembic commands ###