# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator (autorest: 3.10.3, generator: @autorest/python@5.16.0)
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
from typing import Any, Callable, Dict, IO, List, Optional, TypeVar, Union

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.utils import case_insensitive_dict

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._affinda_api_operations import (
    build_activate_resthook_subscription_request,
    build_add_mapping_data_source_value_request,
    build_batch_add_tag_request,
    build_batch_create_annotations_request,
    build_batch_create_validation_results_request,
    build_batch_delete_annotations_request,
    build_batch_delete_validation_results_request,
    build_batch_remove_tag_request,
    build_batch_update_annotations_request,
    build_create_annotation_request,
    build_create_api_user_request,
    build_create_collection_request,
    build_create_data_field_for_collection_request,
    build_create_data_point_choice_request,
    build_create_data_point_request,
    build_create_document_request,
    build_create_document_type_request,
    build_create_extractor_request,
    build_create_index_document_request,
    build_create_index_request,
    build_create_invitation_request,
    build_create_job_description_search_embed_url_request,
    build_create_job_description_search_request,
    build_create_mapping_data_source_request,
    build_create_mapping_request,
    build_create_organization_request,
    build_create_resthook_subscription_request,
    build_create_resume_search_embed_url_request,
    build_create_resume_search_request,
    build_create_tag_request,
    build_create_validation_result_request,
    build_create_workspace_membership_request,
    build_create_workspace_request,
    build_delete_annotation_request,
    build_delete_api_user_request,
    build_delete_collection_request,
    build_delete_data_point_choice_request,
    build_delete_data_point_request,
    build_delete_document_request,
    build_delete_document_type_request,
    build_delete_extractor_request,
    build_delete_index_document_request,
    build_delete_index_request,
    build_delete_invitation_request,
    build_delete_mapping_data_source_request,
    build_delete_mapping_data_source_value_request,
    build_delete_mapping_request,
    build_delete_organization_membership_request,
    build_delete_organization_request,
    build_delete_resthook_subscription_request,
    build_delete_tag_request,
    build_delete_validation_result_request,
    build_delete_workspace_membership_request,
    build_delete_workspace_request,
    build_edit_document_pages_request,
    build_get_all_annotations_request,
    build_get_all_api_users_request,
    build_get_all_collections_request,
    build_get_all_data_points_request,
    build_get_all_document_splitters_request,
    build_get_all_documents_request,
    build_get_all_extractors_request,
    build_get_all_index_documents_request,
    build_get_all_indexes_request,
    build_get_all_invitations_request,
    build_get_all_organization_memberships_request,
    build_get_all_organizations_request,
    build_get_all_resthook_subscriptions_request,
    build_get_all_tags_request,
    build_get_all_validation_results_request,
    build_get_all_workspace_memberships_request,
    build_get_all_workspaces_request,
    build_get_annotation_request,
    build_get_api_user_request,
    build_get_collection_request,
    build_get_data_field_for_collection_request,
    build_get_data_point_choice_request,
    build_get_data_point_choices_request,
    build_get_data_point_request,
    build_get_document_request,
    build_get_document_splitter_request,
    build_get_document_type_request,
    build_get_document_types_request,
    build_get_extractor_request,
    build_get_invitation_by_token_request,
    build_get_invitation_request,
    build_get_job_description_search_config_request,
    build_get_job_description_search_detail_request,
    build_get_mapping_data_source_request,
    build_get_mapping_data_source_value_request,
    build_get_mapping_request,
    build_get_organization_membership_request,
    build_get_organization_request,
    build_get_redacted_document_request,
    build_get_resthook_subscription_request,
    build_get_resume_search_config_request,
    build_get_resume_search_detail_request,
    build_get_resume_search_match_request,
    build_get_resume_search_suggestion_job_title_request,
    build_get_resume_search_suggestion_skill_request,
    build_get_tag_request,
    build_get_usage_by_collection_request,
    build_get_usage_by_workspace_request,
    build_get_validation_result_request,
    build_get_workspace_membership_request,
    build_get_workspace_request,
    build_json_schema_from_document_type_request,
    build_list_mapping_data_source_values_request,
    build_list_mapping_data_sources_request,
    build_list_mappings_request,
    build_list_occupation_groups_request,
    build_pydantic_models_from_document_type_request,
    build_re_index_document_request,
    build_regenerate_api_key_for_api_user_request,
    build_replace_data_point_choices_request,
    build_replace_mapping_data_source_values_request,
    build_respond_to_invitation_request,
    build_update_annotation_request,
    build_update_api_user_request,
    build_update_collection_request,
    build_update_data_field_for_collection_request,
    build_update_data_point_choice_request,
    build_update_data_point_request,
    build_update_document_data_request,
    build_update_document_request,
    build_update_document_type_request,
    build_update_extractor_request,
    build_update_index_request,
    build_update_invitation_request,
    build_update_job_description_search_config_request,
    build_update_mapping_data_source_value_request,
    build_update_mapping_request,
    build_update_organization_membership_request,
    build_update_organization_request,
    build_update_resthook_subscription_request,
    build_update_resume_search_config_request,
    build_update_tag_request,
    build_update_validation_result_request,
    build_update_workspace_request,
)

T = TypeVar("T")
ClsType = Optional[
    Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]
]


class AffindaAPIOperationsMixin:  # pylint: disable=too-many-public-methods
    async def get_all_workspaces(
        self, organization: str, name: Optional[str] = None, **kwargs: Any
    ) -> List[_models.Workspace]:
        """Get list of all workspaces.

        Returns your workspaces.

        :param organization: Filter by organization.
        :type organization: str
        :param name: Filter by name. Default value is None.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of Workspace, or the result of cls(response)
        :rtype: list[~affinda.models.Workspace]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[_models.Workspace]]

        request = build_get_all_workspaces_request(
            organization=organization,
            name=name,
            template_url=self.get_all_workspaces.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("[Workspace]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_workspaces.metadata = {"url": "/v3/workspaces"}  # type: ignore

    async def create_workspace(
        self, body: _models.WorkspaceCreate, **kwargs: Any
    ) -> _models.Workspace:
        """Create a workspace.

        Create a workspace.

        :param body: Workspace to create.
        :type body: ~affinda.models.WorkspaceCreate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Workspace, or the result of cls(response)
        :rtype: ~affinda.models.Workspace
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Workspace]

        _json = self._serialize.body(body, "WorkspaceCreate")

        request = build_create_workspace_request(
            content_type=content_type,
            json=_json,
            template_url=self.create_workspace.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Workspace", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_workspace.metadata = {"url": "/v3/workspaces"}  # type: ignore

    async def get_workspace(self, identifier: str, **kwargs: Any) -> _models.Workspace:
        """Get specific workspace.

        Return a specific workspace.

        :param identifier: Workspace's identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Workspace, or the result of cls(response)
        :rtype: ~affinda.models.Workspace
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Workspace]

        request = build_get_workspace_request(
            identifier=identifier,
            template_url=self.get_workspace.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Workspace", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_workspace.metadata = {"url": "/v3/workspaces/{identifier}"}  # type: ignore

    async def update_workspace(
        self, identifier: str, body: _models.WorkspaceUpdate, **kwargs: Any
    ) -> _models.Workspace:
        """Update a workspace.

        Update a workspace.

        :param identifier: Workspace's identifier.
        :type identifier: str
        :param body: Workspace data to update.
        :type body: ~affinda.models.WorkspaceUpdate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Workspace, or the result of cls(response)
        :rtype: ~affinda.models.Workspace
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Workspace]

        _json = self._serialize.body(body, "WorkspaceUpdate")

        request = build_update_workspace_request(
            identifier=identifier,
            content_type=content_type,
            json=_json,
            template_url=self.update_workspace.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Workspace", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_workspace.metadata = {"url": "/v3/workspaces/{identifier}"}  # type: ignore

    async def delete_workspace(  # pylint: disable=inconsistent-return-statements
        self, identifier: str, **kwargs: Any
    ) -> None:
        """Delete a workspace.

        Deletes the specified workspace from the database.

        :param identifier: Workspace's identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_workspace_request(
            identifier=identifier,
            template_url=self.delete_workspace.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_workspace.metadata = {"url": "/v3/workspaces/{identifier}"}  # type: ignore

    async def get_usage_by_workspace(
        self,
        identifier: str,
        start: Optional[str] = None,
        end: Optional[str] = None,
        **kwargs: Any,
    ) -> List[_models.UsageByWorkspace]:
        """Get usage by workspace.

        Return monthly credits consumption of a workspace.

        :param identifier: Workspace's identifier.
        :type identifier: str
        :param start: Start date of the period to retrieve. Format: YYYY-MM. Default value is None.
        :type start: str
        :param end: End date of the period to retrieve. Format: YYYY-MM. Default value is None.
        :type end: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of UsageByWorkspace, or the result of cls(response)
        :rtype: list[~affinda.models.UsageByWorkspace]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[_models.UsageByWorkspace]]

        request = build_get_usage_by_workspace_request(
            identifier=identifier,
            start=start,
            end=end,
            template_url=self.get_usage_by_workspace.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("[UsageByWorkspace]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_usage_by_workspace.metadata = {"url": "/v3/workspaces/{identifier}/usage"}  # type: ignore

    async def get_all_workspace_memberships(
        self,
        offset: Optional[int] = None,
        limit: Optional[int] = None,
        workspace: Optional[str] = None,
        user: Optional[str] = None,
        **kwargs: Any,
    ) -> _models.PathsZ1JuagV3WorkspaceMembershipsGetResponses200ContentApplicationJsonSchema:
        """Get list of all workspace memberships.

        Returns the memberships of your workspaces.

        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is None.
        :type limit: int
        :param workspace: Filter by workspace. Default value is None.
        :type workspace: str
        :param user: Partial text match on user's email, case-insensitive. Default value is None.
        :type user: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PathsZ1JuagV3WorkspaceMembershipsGetResponses200ContentApplicationJsonSchema, or the
         result of cls(response)
        :rtype:
         ~affinda.models.PathsZ1JuagV3WorkspaceMembershipsGetResponses200ContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.PathsZ1JuagV3WorkspaceMembershipsGetResponses200ContentApplicationJsonSchema]

        request = build_get_all_workspace_memberships_request(
            offset=offset,
            limit=limit,
            workspace=workspace,
            user=user,
            template_url=self.get_all_workspace_memberships.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize(
            "PathsZ1JuagV3WorkspaceMembershipsGetResponses200ContentApplicationJsonSchema",
            pipeline_response,
        )

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_workspace_memberships.metadata = {"url": "/v3/workspace_memberships"}  # type: ignore

    async def create_workspace_membership(
        self, body: _models.WorkspaceMembershipCreate, **kwargs: Any
    ) -> _models.WorkspaceMembership:
        """Create a workspace membership.

        Create a workspace membership.

        :param body:
        :type body: ~affinda.models.WorkspaceMembershipCreate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: WorkspaceMembership, or the result of cls(response)
        :rtype: ~affinda.models.WorkspaceMembership
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.WorkspaceMembership]

        _json = self._serialize.body(body, "WorkspaceMembershipCreate")

        request = build_create_workspace_membership_request(
            content_type=content_type,
            json=_json,
            template_url=self.create_workspace_membership.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("WorkspaceMembership", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_workspace_membership.metadata = {"url": "/v3/workspace_memberships"}  # type: ignore

    async def get_workspace_membership(
        self, identifier: str, **kwargs: Any
    ) -> _models.WorkspaceMembership:
        """Get specific workspace membership.

        Return a specific workspace membership.

        :param identifier: Workspace membership's identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: WorkspaceMembership, or the result of cls(response)
        :rtype: ~affinda.models.WorkspaceMembership
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.WorkspaceMembership]

        request = build_get_workspace_membership_request(
            identifier=identifier,
            template_url=self.get_workspace_membership.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("WorkspaceMembership", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_workspace_membership.metadata = {"url": "/v3/workspace_memberships/{identifier}"}  # type: ignore

    async def delete_workspace_membership(  # pylint: disable=inconsistent-return-statements
        self, identifier: str, **kwargs: Any
    ) -> None:
        """Delete a workspace membership.

        Remove an user from a workspace.

        :param identifier: Workspace membership's identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_workspace_membership_request(
            identifier=identifier,
            template_url=self.delete_workspace_membership.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_workspace_membership.metadata = {"url": "/v3/workspace_memberships/{identifier}"}  # type: ignore

    async def get_all_collections(self, workspace: str, **kwargs: Any) -> List[_models.Collection]:
        """Get list of all collections.

        Returns your collections.

        :param workspace: Filter by workspace.
        :type workspace: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of Collection, or the result of cls(response)
        :rtype: list[~affinda.models.Collection]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[_models.Collection]]

        request = build_get_all_collections_request(
            workspace=workspace,
            template_url=self.get_all_collections.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("[Collection]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_collections.metadata = {"url": "/v3/collections"}  # type: ignore

    async def create_collection(
        self, body: _models.CollectionCreate, **kwargs: Any
    ) -> _models.Collection:
        """Create a collection.

        Create a collection.

        :param body:
        :type body: ~affinda.models.CollectionCreate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Collection, or the result of cls(response)
        :rtype: ~affinda.models.Collection
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Collection]

        _json = self._serialize.body(body, "CollectionCreate")

        request = build_create_collection_request(
            content_type=content_type,
            json=_json,
            template_url=self.create_collection.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Collection", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_collection.metadata = {"url": "/v3/collections"}  # type: ignore

    async def get_collection(self, identifier: str, **kwargs: Any) -> _models.Collection:
        """Get specific collection.

        Return a specific collection.

        :param identifier: Collection's identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Collection, or the result of cls(response)
        :rtype: ~affinda.models.Collection
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Collection]

        request = build_get_collection_request(
            identifier=identifier,
            template_url=self.get_collection.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Collection", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_collection.metadata = {"url": "/v3/collections/{identifier}"}  # type: ignore

    async def update_collection(
        self, identifier: str, body: _models.CollectionUpdate, **kwargs: Any
    ) -> _models.Collection:
        """Update a collection.

        Update data of a collection.

        :param identifier: Collection's identifier.
        :type identifier: str
        :param body: Collection data to update.
        :type body: ~affinda.models.CollectionUpdate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Collection, or the result of cls(response)
        :rtype: ~affinda.models.Collection
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Collection]

        _json = self._serialize.body(body, "CollectionUpdate")

        request = build_update_collection_request(
            identifier=identifier,
            content_type=content_type,
            json=_json,
            template_url=self.update_collection.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Collection", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_collection.metadata = {"url": "/v3/collections/{identifier}"}  # type: ignore

    async def delete_collection(  # pylint: disable=inconsistent-return-statements
        self, identifier: str, **kwargs: Any
    ) -> None:
        """Delete a collection.

        Deletes the specified collection from the database.

        :param identifier: Collection's identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_collection_request(
            identifier=identifier,
            template_url=self.delete_collection.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_collection.metadata = {"url": "/v3/collections/{identifier}"}  # type: ignore

    async def create_data_field_for_collection(
        self, identifier: str, body: _models.DataFieldCreate, **kwargs: Any
    ) -> _models.DataField:
        """Create data field for a collection along with a new data point.

        Create data field for a collection along with a new data point.

        :param identifier: Collection's identifier.
        :type identifier: str
        :param body: The data field and data point to be created.
        :type body: ~affinda.models.DataFieldCreate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DataField, or the result of cls(response)
        :rtype: ~affinda.models.DataField
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.DataField]

        _json = self._serialize.body(body, "DataFieldCreate")

        request = build_create_data_field_for_collection_request(
            identifier=identifier,
            content_type=content_type,
            json=_json,
            template_url=self.create_data_field_for_collection.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("DataField", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_data_field_for_collection.metadata = {
        "url": "/v3/collections/{identifier}/create_data_field"
    }  # type: ignore

    async def get_data_field_for_collection(
        self, identifier: str, datapoint_identifier: str, **kwargs: Any
    ) -> _models.CollectionField:
        """Get data field for a collection assosciated with a data point.

        Get a data field for a collection assosciated with a data point.

        :param identifier: Collection's identifier.
        :type identifier: str
        :param datapoint_identifier: Datapoint's identifier.
        :type datapoint_identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CollectionField, or the result of cls(response)
        :rtype: ~affinda.models.CollectionField
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.CollectionField]

        request = build_get_data_field_for_collection_request(
            identifier=identifier,
            datapoint_identifier=datapoint_identifier,
            template_url=self.get_data_field_for_collection.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("CollectionField", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_data_field_for_collection.metadata = {
        "url": "/v3/collections/{identifier}/fields/{datapoint_identifier}"
    }  # type: ignore

    async def update_data_field_for_collection(
        self,
        identifier: str,
        datapoint_identifier: str,
        body: _models.CollectionField,
        **kwargs: Any,
    ) -> _models.CollectionField:
        """Update data field for a collection assosciated with a data point.

        Update data field for a collection assosciated with a data point.

        :param identifier: Collection's identifier.
        :type identifier: str
        :param datapoint_identifier: Datapoint's identifier.
        :type datapoint_identifier: str
        :param body: Data field properties to update.
        :type body: ~affinda.models.CollectionField
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CollectionField, or the result of cls(response)
        :rtype: ~affinda.models.CollectionField
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.CollectionField]

        _json = self._serialize.body(body, "CollectionField")

        request = build_update_data_field_for_collection_request(
            identifier=identifier,
            datapoint_identifier=datapoint_identifier,
            content_type=content_type,
            json=_json,
            template_url=self.update_data_field_for_collection.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("CollectionField", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_data_field_for_collection.metadata = {
        "url": "/v3/collections/{identifier}/fields/{datapoint_identifier}"
    }  # type: ignore

    async def get_usage_by_collection(
        self,
        identifier: str,
        start: Optional[str] = None,
        end: Optional[str] = None,
        **kwargs: Any,
    ) -> List[_models.UsageByCollection]:
        """Get usage by collection.

        Return monthly credits consumption of a collection.

        :param identifier: Collection's identifier.
        :type identifier: str
        :param start: Start date of the period to retrieve. Format: YYYY-MM. Default value is None.
        :type start: str
        :param end: End date of the period to retrieve. Format: YYYY-MM. Default value is None.
        :type end: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of UsageByCollection, or the result of cls(response)
        :rtype: list[~affinda.models.UsageByCollection]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[_models.UsageByCollection]]

        request = build_get_usage_by_collection_request(
            identifier=identifier,
            start=start,
            end=end,
            template_url=self.get_usage_by_collection.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("[UsageByCollection]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_usage_by_collection.metadata = {"url": "/v3/collections/{identifier}/usage"}  # type: ignore

    async def get_all_documents(
        self,
        offset: Optional[int] = None,
        limit: Optional[int] = None,
        workspace: Optional[str] = None,
        collection: Optional[str] = None,
        state: Optional[Union[str, "_models.DocumentState"]] = None,
        tags: Optional[List[int]] = None,
        created_dt: Optional[Union[str, "_models.DateRange"]] = None,
        search: Optional[str] = None,
        ordering: Optional[List[str]] = None,
        include_data: Optional[bool] = None,
        exclude: Optional[List[str]] = None,
        in_review: Optional[bool] = None,
        failed: Optional[bool] = None,
        ready: Optional[bool] = None,
        validatable: Optional[bool] = None,
        has_challenges: Optional[bool] = None,
        custom_identifier: Optional[str] = None,
        compact: Optional[bool] = None,
        count: Optional[bool] = None,
        snake_case: Optional[bool] = None,
        **kwargs: Any,
    ) -> _models.PathsOxm5M7V3DocumentsGetResponses200ContentApplicationJsonSchema:
        """Get list of all documents.

        Returns all the document summaries for that user, limited to 300 per page.

        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is None.
        :type limit: int
        :param workspace: Filter by workspace. Default value is None.
        :type workspace: str
        :param collection: Filter by collection. Default value is None.
        :type collection: str
        :param state: Filter by the document's state. Default value is None.
        :type state: str or ~affinda.models.DocumentState
        :param tags: Filter by tag's IDs. Default value is None.
        :type tags: list[int]
        :param created_dt: Filter by created datetime. Default value is None.
        :type created_dt: str or ~affinda.models.DateRange
        :param search: Partial, case-insensitive match with file name or tag name. Default value is
         None.
        :type search: str
        :param ordering: Sort the result set. A "-" at the beginning denotes DESC sort, e.g.
         -created_dt. Sort by multiple fields is supported. Supported values include: 'file_name',
         'extractor', 'created_dt', 'validated_dt', 'archived_dt' and 'parsed__:code:`<dataPointSlug>`'.
         Default value is None.
        :type ordering: list[str]
        :param include_data: By default, this endpoint returns only the meta data of the documents. Set
         this to ``true`` will return a summary of the data that was parsed. If you want to retrieve the
         full set of data for a document, use the ``GET /documents/{identifier}`` endpoint. Default
         value is None.
        :type include_data: bool
        :param exclude: Exclude some documents from the result. Default value is None.
        :type exclude: list[str]
        :param in_review: Exclude documents that are currently being reviewed. Default value is None.
        :type in_review: bool
        :param failed: Filter by failed status. Default value is None.
        :type failed: bool
        :param ready: Filter by ready status. Default value is None.
        :type ready: bool
        :param validatable: Filter for validatable documents. Default value is None.
        :type validatable: bool
        :param has_challenges: Filter for documents with challenges. Default value is None.
        :type has_challenges: bool
        :param custom_identifier: Filter for documents with this custom identifier. Default value is
         None.
        :type custom_identifier: str
        :param compact: If "true", the response is compacted to annotations' parsed data. Annotations'
         meta data are excluded. Default is "false".
        :type compact: bool
        :param count: If "false", the documents count is not computed, thus saving time for large
         collections. Default is "true".
        :type count: bool
        :param snake_case: Whether to return the response in snake_case instead of camelCase. Default
         is false.
        :type snake_case: bool
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PathsOxm5M7V3DocumentsGetResponses200ContentApplicationJsonSchema, or the result of
         cls(response)
        :rtype: ~affinda.models.PathsOxm5M7V3DocumentsGetResponses200ContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            403: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.PathsOxm5M7V3DocumentsGetResponses200ContentApplicationJsonSchema]

        request = build_get_all_documents_request(
            offset=offset,
            limit=limit,
            workspace=workspace,
            collection=collection,
            state=state,
            tags=tags,
            created_dt=created_dt,
            search=search,
            ordering=ordering,
            include_data=include_data,
            exclude=exclude,
            in_review=in_review,
            failed=failed,
            ready=ready,
            validatable=validatable,
            has_challenges=has_challenges,
            custom_identifier=custom_identifier,
            compact=compact,
            count=count,
            snake_case=snake_case,
            template_url=self.get_all_documents.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize(
            "PathsOxm5M7V3DocumentsGetResponses200ContentApplicationJsonSchema", pipeline_response
        )

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_documents.metadata = {"url": "/v3/documents"}  # type: ignore

    async def create_document(
        self,
        snake_case: Optional[bool] = None,
        file: Optional[IO] = None,
        url: Optional[str] = None,
        data: Any = None,
        collection: Optional[str] = None,
        document_type: Optional[str] = None,
        workspace: Optional[str] = None,
        wait: Optional[bool] = True,
        identifier: Optional[str] = None,
        custom_identifier: Optional[str] = None,
        file_name: Optional[str] = None,
        expiry_time: Optional[datetime.datetime] = None,
        language: Optional[str] = None,
        reject_duplicates: Optional[bool] = None,
        region_bias: Optional[str] = None,
        low_priority: Optional[bool] = None,
        compact: Optional[bool] = None,
        delete_after_parse: Optional[bool] = None,
        enable_validation_tool: Optional[bool] = None,
        use_ocr: Optional[bool] = None,
        warning_messages: Optional[List[_models.DocumentWarning]] = None,
        **kwargs: Any,
    ) -> _models.Document:
        """Upload a document for parsing.

        Uploads a document for parsing. When successful, returns an ``identifier`` in the response for
        subsequent use with the `/documents/{identifier} <#get-/v3/documents/-identifier->`_ endpoint
        to check processing status and retrieve results.:code:`<br/>`.

        :param snake_case: Whether to return the response in snake_case instead of camelCase. Default
         is false.
        :type snake_case: bool
        :param file:  Default value is None.
        :type file: IO
        :param url: URL to download the document. Default value is None.
        :type url: str
        :param data: Create resume or job description directly from data. Default value is None.
        :type data: any
        :param collection:  Default value is None.
        :type collection: str
        :param document_type: The document type's identifier.  Provide if you already know the document
         type. Default value is None.
        :type document_type: str
        :param workspace:  Default value is None.
        :type workspace: str
        :param wait:  Default value is True.
        :type wait: bool
        :param identifier: Deprecated in favor of ``customIdentifier``. Default value is None.
        :type identifier: str
        :param custom_identifier: Specify a custom identifier for the document if you need one, not
         required to be unique. Default value is None.
        :type custom_identifier: str
        :param file_name:  Default value is None.
        :type file_name: str
        :param expiry_time:  Default value is None.
        :type expiry_time: ~datetime.datetime
        :param language:  Default value is None.
        :type language: str
        :param reject_duplicates:  Default value is None.
        :type reject_duplicates: bool
        :param region_bias: A JSON representation of the RegionBias object. Default value is None.
        :type region_bias: str
        :param low_priority: Explicitly mark this document as low priority. Default value is None.
        :type low_priority: bool
        :param compact: If true, the returned parse result (assuming ``wait`` is also true) will be a
         compact version of the full result. Default value is None.
        :type compact: bool
        :param delete_after_parse: If true, no data will be stored after parsing. Only compatible with
         requests where wait: True. Default value is None.
        :type delete_after_parse: bool
        :param enable_validation_tool: If true, the document will be viewable in the Affinda Validation
         Tool. Set to False to optimize parsing speed. Default value is None.
        :type enable_validation_tool: bool
        :param use_ocr: If true, the document will be treated like an image, and the text will be
         extracted using OCR. If false, the document will be treated like a PDF, and the text will be
         extracted using the parser. If not set, we will determine whether to use OCR based on whether
         words are found in the document. Default value is None.
        :type use_ocr: bool
        :param warning_messages:  Default value is None.
        :type warning_messages: list[~affinda.models.DocumentWarning]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Document, or the result of cls(response)
        :rtype: ~affinda.models.Document
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            403: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Document]

        # Construct form data
        _files = {
            "file": file,
            "url": url,
            "data": data,
            "collection": collection,
            "documentType": document_type,
            "workspace": workspace,
            "wait": wait,
            "identifier": identifier,
            "customIdentifier": custom_identifier,
            "fileName": file_name,
            "expiryTime": expiry_time,
            "language": language,
            "rejectDuplicates": reject_duplicates,
            "regionBias": region_bias,
            "lowPriority": low_priority,
            "compact": compact,
            "deleteAfterParse": delete_after_parse,
            "enableValidationTool": enable_validation_tool,
            "useOcr": use_ocr,
            "warningMessages": warning_messages,
        }

        request = build_create_document_request(
            content_type=content_type,
            snake_case=snake_case,
            files=_files,
            template_url=self.create_document.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request, _files)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("Document", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("Document", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_document.metadata = {"url": "/v3/documents"}  # type: ignore

    async def get_document(
        self,
        identifier: str,
        format: Optional[Union[str, "_models.DocumentFormat"]] = None,
        compact: Optional[bool] = None,
        snake_case: Optional[bool] = None,
        **kwargs: Any,
    ) -> _models.Document:
        """Get specific document.

        Return a specific document.

        :param identifier: Document's identifier.
        :type identifier: str
        :param format: Specify which format you want the response to be. Default is "json".
        :type format: str or ~affinda.models.DocumentFormat
        :param compact: If "true", the response is compacted to annotations' parsed data. Annotations'
         meta data are excluded. Default is "false".
        :type compact: bool
        :param snake_case: Whether to return the response in snake_case instead of camelCase. Default
         is false.
        :type snake_case: bool
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Document, or the result of cls(response)
        :rtype: ~affinda.models.Document
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Document]

        request = build_get_document_request(
            identifier=identifier,
            format=format,
            compact=compact,
            snake_case=snake_case,
            template_url=self.get_document.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("Document", pipeline_response)

        if response.status_code == 200:
            deserialized = self._deserialize("Document", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_document.metadata = {"url": "/v3/documents/{identifier}"}  # type: ignore

    async def update_document(
        self,
        identifier: str,
        body: _models.DocumentUpdate,
        compact: Optional[bool] = None,
        snake_case: Optional[bool] = None,
        **kwargs: Any,
    ) -> _models.Document:
        """Update a document.

        Update file name, expiry time, or move to another collection, etc.

        :param identifier: Document's identifier.
        :type identifier: str
        :param body: Document data to update.
        :type body: ~affinda.models.DocumentUpdate
        :param compact: If "true", the response is compacted to annotations' parsed data. Annotations'
         meta data are excluded. Default is "false".
        :type compact: bool
        :param snake_case: Whether to return the response in snake_case instead of camelCase. Default
         is false.
        :type snake_case: bool
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Document, or the result of cls(response)
        :rtype: ~affinda.models.Document
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Document]

        _json = self._serialize.body(body, "DocumentUpdate")

        request = build_update_document_request(
            identifier=identifier,
            content_type=content_type,
            json=_json,
            compact=compact,
            snake_case=snake_case,
            template_url=self.update_document.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Document", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_document.metadata = {"url": "/v3/documents/{identifier}"}  # type: ignore

    async def delete_document(  # pylint: disable=inconsistent-return-statements
        self, identifier: str, **kwargs: Any
    ) -> None:
        """Delete a document.

        Deletes the specified document from the database.

        :param identifier: Document's identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_document_request(
            identifier=identifier,
            template_url=self.delete_document.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_document.metadata = {"url": "/v3/documents/{identifier}"}  # type: ignore

    async def update_document_data(
        self, identifier: str, body: Any, **kwargs: Any
    ) -> _models.Document:
        """Update a document's data.

        Update data of a document.
        Only applicable for resumes and job descriptions. For other document types, please use the
        ``PATCH /annotations/{id}`` endpoint or the ``POST /annotations/batch_update`` endpoint.

        :param identifier: Resume or Job Description identifier.
        :type identifier: str
        :param body: Resume data to update.
        :type body: any
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Document, or the result of cls(response)
        :rtype: ~affinda.models.Document
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Document]

        _json = self._serialize.body(body, "object")

        request = build_update_document_data_request(
            identifier=identifier,
            content_type=content_type,
            json=_json,
            template_url=self.update_document_data.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Document", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_document_data.metadata = {"url": "/v3/documents/{identifier}/update_data"}  # type: ignore

    async def get_redacted_document(self, identifier: str, **kwargs: Any) -> IO:
        """Get redacted document.

        Get the redacted version of a document. The original document is not modified.

        :param identifier: Document identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IO, or the result of cls(response)
        :rtype: IO
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[IO]

        request = build_get_redacted_document_request(
            identifier=identifier,
            template_url=self.get_redacted_document.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=True, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = response.stream_download(self._client._pipeline)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_redacted_document.metadata = {"url": "/v3/documents/{identifier}/redacted"}  # type: ignore

    async def batch_add_tag(  # pylint: disable=inconsistent-return-statements
        self, body: _models.BatchAddTagRequest, **kwargs: Any
    ) -> None:
        """Add a tag to documents.

        Add a tag to documents.
        Tags are used to group documents together.
        Tags can be used to filter documents.

        :param body: Specify the tag and the documents to tag.
        :type body: ~affinda.models.BatchAddTagRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        _json = self._serialize.body(body, "BatchAddTagRequest")

        request = build_batch_add_tag_request(
            content_type=content_type,
            json=_json,
            template_url=self.batch_add_tag.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    batch_add_tag.metadata = {"url": "/v3/documents/batch_add_tag"}  # type: ignore

    async def batch_remove_tag(  # pylint: disable=inconsistent-return-statements
        self, body: _models.BatchRemoveTagRequest, **kwargs: Any
    ) -> None:
        """Remove a tag from documents.

        Remove a tag from documents.

        :param body: Specify the tag and the documents to remove the tag from.
        :type body: ~affinda.models.BatchRemoveTagRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        _json = self._serialize.body(body, "BatchRemoveTagRequest")

        request = build_batch_remove_tag_request(
            content_type=content_type,
            json=_json,
            template_url=self.batch_remove_tag.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    batch_remove_tag.metadata = {"url": "/v3/documents/batch_remove_tag"}  # type: ignore

    async def get_all_validation_results(
        self,
        document: str,
        offset: Optional[int] = None,
        limit: Optional[int] = None,
        **kwargs: Any,
    ) -> List[_models.ValidationResult]:
        """Get list of all validation results.

        Returns the validation results of a document.

        :param document: Filter by document.
        :type document: str
        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is None.
        :type limit: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of ValidationResult, or the result of cls(response)
        :rtype: list[~affinda.models.ValidationResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[_models.ValidationResult]]

        request = build_get_all_validation_results_request(
            document=document,
            offset=offset,
            limit=limit,
            template_url=self.get_all_validation_results.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("[ValidationResult]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_validation_results.metadata = {"url": "/v3/validation_results"}  # type: ignore

    async def create_validation_result(
        self, body: _models.ValidationResultCreate, **kwargs: Any
    ) -> _models.ValidationResult:
        """Create a validation result.

        Create a validation result.

        :param body:
        :type body: ~affinda.models.ValidationResultCreate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ValidationResult, or the result of cls(response)
        :rtype: ~affinda.models.ValidationResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ValidationResult]

        _json = self._serialize.body(body, "ValidationResultCreate")

        request = build_create_validation_result_request(
            content_type=content_type,
            json=_json,
            template_url=self.create_validation_result.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ValidationResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_validation_result.metadata = {"url": "/v3/validation_results"}  # type: ignore

    async def get_validation_result(self, id: int, **kwargs: Any) -> _models.ValidationResult:
        """Get specific validation result.

        Return a specific validation result.

        :param id: Validation result's ID.
        :type id: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ValidationResult, or the result of cls(response)
        :rtype: ~affinda.models.ValidationResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ValidationResult]

        request = build_get_validation_result_request(
            id=id,
            template_url=self.get_validation_result.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ValidationResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_validation_result.metadata = {"url": "/v3/validation_results/{id}"}  # type: ignore

    async def update_validation_result(
        self, id: int, body: _models.ValidationResultUpdate, **kwargs: Any
    ) -> _models.ValidationResult:
        """Update a validation result.

        Update a validation result.

        :param id: Validation result's ID.
        :type id: int
        :param body: Validation result data to update.
        :type body: ~affinda.models.ValidationResultUpdate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ValidationResult, or the result of cls(response)
        :rtype: ~affinda.models.ValidationResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ValidationResult]

        _json = self._serialize.body(body, "ValidationResultUpdate")

        request = build_update_validation_result_request(
            id=id,
            content_type=content_type,
            json=_json,
            template_url=self.update_validation_result.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ValidationResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_validation_result.metadata = {"url": "/v3/validation_results/{id}"}  # type: ignore

    async def delete_validation_result(  # pylint: disable=inconsistent-return-statements
        self, id: int, **kwargs: Any
    ) -> None:
        """Delete a validation result.

        Remove validation result.

        :param id: Validation result's ID.
        :type id: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_validation_result_request(
            id=id,
            template_url=self.delete_validation_result.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_validation_result.metadata = {"url": "/v3/validation_results/{id}"}  # type: ignore

    async def batch_create_validation_results(
        self, body: List[_models.ValidationResultCreate], **kwargs: Any
    ) -> List[_models.ValidationResult]:
        """Batch create validation results.

        Batch create validation results.

        :param body:
        :type body: list[~affinda.models.ValidationResultCreate]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of ValidationResult, or the result of cls(response)
        :rtype: list[~affinda.models.ValidationResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[List[_models.ValidationResult]]

        _json = self._serialize.body(body, "[ValidationResultCreate]")

        request = build_batch_create_validation_results_request(
            content_type=content_type,
            json=_json,
            template_url=self.batch_create_validation_results.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("[ValidationResult]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    batch_create_validation_results.metadata = {"url": "/v3/validation_results/batch_create"}  # type: ignore

    async def batch_delete_validation_results(  # pylint: disable=inconsistent-return-statements
        self, body: _models.BatchDeleteValidationResultsRequest, **kwargs: Any
    ) -> None:
        """Batch delete validation results.

        Batch delete validation results.

        :param body:
        :type body: ~affinda.models.BatchDeleteValidationResultsRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        _json = self._serialize.body(body, "BatchDeleteValidationResultsRequest")

        request = build_batch_delete_validation_results_request(
            content_type=content_type,
            json=_json,
            template_url=self.batch_delete_validation_results.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    batch_delete_validation_results.metadata = {"url": "/v3/validation_results/batch_delete"}  # type: ignore

    async def get_all_document_splitters(
        self,
        offset: Optional[int] = None,
        limit: Optional[int] = None,
        organization: Optional[str] = None,
        include_public: Optional[bool] = None,
        **kwargs: Any,
    ) -> List[_models.DocumentSplitter]:
        """Get list of all document splitters.

        Returns all the document splitters visible to the user.

        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is None.
        :type limit: int
        :param organization: Filter by organization. Default value is None.
        :type organization: str
        :param include_public: Allows you to include public splitters in the response when you're
         filtering by organization. Default value is None.
        :type include_public: bool
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of DocumentSplitter, or the result of cls(response)
        :rtype: list[~affinda.models.DocumentSplitter]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[_models.DocumentSplitter]]

        request = build_get_all_document_splitters_request(
            offset=offset,
            limit=limit,
            organization=organization,
            include_public=include_public,
            template_url=self.get_all_document_splitters.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("[DocumentSplitter]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_document_splitters.metadata = {"url": "/v3/document_splitters"}  # type: ignore

    async def get_document_splitter(
        self, identifier: str, **kwargs: Any
    ) -> _models.DocumentSplitter:
        """Get specific document splitter.

        Return a specific document splitter.

        :param identifier: Document splitter's identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DocumentSplitter, or the result of cls(response)
        :rtype: ~affinda.models.DocumentSplitter
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.DocumentSplitter]

        request = build_get_document_splitter_request(
            identifier=identifier,
            template_url=self.get_document_splitter.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("DocumentSplitter", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_document_splitter.metadata = {"url": "/v3/document_splitters/{identifier}"}  # type: ignore

    async def edit_document_pages(
        self, identifier: str, body: _models.DocumentEditRequest, **kwargs: Any
    ) -> List[_models.Meta]:
        """Split pages of a document.

        Split / merge / rotate / delete pages of a document.
        Documents with multiple pages can be splitted into multiple documents, or merged into one
        document.
        Each page can also be rotated. Edit operations will trigger re-parsing of the documents
        involved.

        :param identifier: Document's identifier.
        :type identifier: str
        :param body: Describe how the pages should be edited.
        :type body: ~affinda.models.DocumentEditRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of Meta, or the result of cls(response)
        :rtype: list[~affinda.models.Meta]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[List[_models.Meta]]

        _json = self._serialize.body(body, "DocumentEditRequest")

        request = build_edit_document_pages_request(
            identifier=identifier,
            content_type=content_type,
            json=_json,
            template_url=self.edit_document_pages.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("[Meta]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    edit_document_pages.metadata = {"url": "/v3/validate/{identifier}/split"}  # type: ignore

    async def get_all_extractors(
        self,
        organization: str,
        include_public_extractors: Optional[bool] = None,
        name: Optional[str] = None,
        validatable: Optional[bool] = None,
        **kwargs: Any,
    ) -> List[_models.Extractor]:
        """Get list of all extractors.

        Returns your custom extractors as well as Affinda's off-the-shelf extractors.

        :param organization: Filter by organization.
        :type organization: str
        :param include_public_extractors: Whether to include Affinda's off-the-shelf extractors.
         Default value is None.
        :type include_public_extractors: bool
        :param name: Filter by name. Default value is None.
        :type name: str
        :param validatable: Filter by validatable. Default value is None.
        :type validatable: bool
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of Extractor, or the result of cls(response)
        :rtype: list[~affinda.models.Extractor]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[_models.Extractor]]

        request = build_get_all_extractors_request(
            organization=organization,
            include_public_extractors=include_public_extractors,
            name=name,
            validatable=validatable,
            template_url=self.get_all_extractors.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("[Extractor]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_extractors.metadata = {"url": "/v3/extractors"}  # type: ignore

    async def create_extractor(
        self, body: Optional[_models.ExtractorCreate] = None, **kwargs: Any
    ) -> _models.Extractor:
        """Create an extractor.

        Create a custom extractor.

        :param body:  Default value is None.
        :type body: ~affinda.models.ExtractorCreate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Extractor, or the result of cls(response)
        :rtype: ~affinda.models.Extractor
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Extractor]

        if body is not None:
            _json = self._serialize.body(body, "ExtractorCreate")
        else:
            _json = None

        request = build_create_extractor_request(
            content_type=content_type,
            json=_json,
            template_url=self.create_extractor.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Extractor", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_extractor.metadata = {"url": "/v3/extractors"}  # type: ignore

    async def get_extractor(self, identifier: str, **kwargs: Any) -> _models.Extractor:
        """Get specific extractor.

        Return a specific extractor.

        :param identifier: Extractor's identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Extractor, or the result of cls(response)
        :rtype: ~affinda.models.Extractor
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Extractor]

        request = build_get_extractor_request(
            identifier=identifier,
            template_url=self.get_extractor.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Extractor", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_extractor.metadata = {"url": "/v3/extractors/{identifier}"}  # type: ignore

    async def update_extractor(
        self, identifier: str, body: _models.ExtractorUpdate, **kwargs: Any
    ) -> _models.Extractor:
        """Update an extractor.

        Update data of an extractor.

        :param identifier: Extractor's identifier.
        :type identifier: str
        :param body: Extractor data to update.
        :type body: ~affinda.models.ExtractorUpdate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Extractor, or the result of cls(response)
        :rtype: ~affinda.models.Extractor
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Extractor]

        _json = self._serialize.body(body, "ExtractorUpdate")

        request = build_update_extractor_request(
            identifier=identifier,
            content_type=content_type,
            json=_json,
            template_url=self.update_extractor.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Extractor", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_extractor.metadata = {"url": "/v3/extractors/{identifier}"}  # type: ignore

    async def delete_extractor(  # pylint: disable=inconsistent-return-statements
        self, identifier: str, **kwargs: Any
    ) -> None:
        """Delete an extractor.

        Deletes the specified extractor from the database.

        :param identifier: Extractor's identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_extractor_request(
            identifier=identifier,
            template_url=self.delete_extractor.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_extractor.metadata = {"url": "/v3/extractors/{identifier}"}  # type: ignore

    async def get_all_data_points(
        self,
        offset: Optional[int] = None,
        limit: Optional[int] = None,
        organization: Optional[str] = None,
        include_public: Optional[bool] = None,
        extractor: Optional[str] = None,
        slug: Optional[str] = None,
        description: Optional[str] = None,
        annotation_content_type: Optional[str] = None,
        identifier: Optional[List[str]] = None,
        **kwargs: Any,
    ) -> List[_models.DataPoint]:
        """Get list of all data points.

        Returns your custom data points as well as Affinda's off-the-shelf data points.

        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is None.
        :type limit: int
        :param organization: Filter by organization. Default value is None.
        :type organization: str
        :param include_public: Allows you to include public data points in the response when you're
         filtering by organization. Default value is None.
        :type include_public: bool
        :param extractor: Filter by extractor. Default value is None.
        :type extractor: str
        :param slug: Filter by slug. Default value is None.
        :type slug: str
        :param description: Filter by description. Default value is None.
        :type description: str
        :param annotation_content_type: Filter by annotation content type, e.g. text, integer, float,
         date, etc. Default value is None.
        :type annotation_content_type: str
        :param identifier: Filter by specific identifiers. Default value is None.
        :type identifier: list[str]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of DataPoint, or the result of cls(response)
        :rtype: list[~affinda.models.DataPoint]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[_models.DataPoint]]

        request = build_get_all_data_points_request(
            offset=offset,
            limit=limit,
            organization=organization,
            include_public=include_public,
            extractor=extractor,
            slug=slug,
            description=description,
            annotation_content_type=annotation_content_type,
            identifier=identifier,
            template_url=self.get_all_data_points.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("[DataPoint]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_data_points.metadata = {"url": "/v3/data_points"}  # type: ignore

    async def create_data_point(
        self, body: Optional[_models.DataPointCreate] = None, **kwargs: Any
    ) -> _models.DataPoint:
        """Create a data point.

        Create a custom data point.

        :param body:  Default value is None.
        :type body: ~affinda.models.DataPointCreate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DataPoint, or the result of cls(response)
        :rtype: ~affinda.models.DataPoint
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.DataPoint]

        if body is not None:
            _json = self._serialize.body(body, "DataPointCreate")
        else:
            _json = None

        request = build_create_data_point_request(
            content_type=content_type,
            json=_json,
            template_url=self.create_data_point.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("DataPoint", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_data_point.metadata = {"url": "/v3/data_points"}  # type: ignore

    async def get_data_point(self, identifier: str, **kwargs: Any) -> _models.DataPoint:
        """Get specific data point.

        Return a specific data point.

        :param identifier: Data point's identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DataPoint, or the result of cls(response)
        :rtype: ~affinda.models.DataPoint
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.DataPoint]

        request = build_get_data_point_request(
            identifier=identifier,
            template_url=self.get_data_point.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("DataPoint", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_data_point.metadata = {"url": "/v3/data_points/{identifier}"}  # type: ignore

    async def update_data_point(
        self, identifier: str, body: _models.DataPointUpdate, **kwargs: Any
    ) -> _models.DataPoint:
        """Update a data point.

        Update data of a data point.

        :param identifier: DataPoint's identifier.
        :type identifier: str
        :param body: Data point to update.
        :type body: ~affinda.models.DataPointUpdate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DataPoint, or the result of cls(response)
        :rtype: ~affinda.models.DataPoint
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.DataPoint]

        _json = self._serialize.body(body, "DataPointUpdate")

        request = build_update_data_point_request(
            identifier=identifier,
            content_type=content_type,
            json=_json,
            template_url=self.update_data_point.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("DataPoint", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_data_point.metadata = {"url": "/v3/data_points/{identifier}"}  # type: ignore

    async def delete_data_point(  # pylint: disable=inconsistent-return-statements
        self, identifier: str, **kwargs: Any
    ) -> None:
        """Delete a data point.

        Deletes the specified data point from the database.

        :param identifier: DataPoint's identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_data_point_request(
            identifier=identifier,
            template_url=self.delete_data_point.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_data_point.metadata = {"url": "/v3/data_points/{identifier}"}  # type: ignore

    async def get_data_point_choices(
        self,
        data_point: str,
        collection: str,
        offset: Optional[int] = None,
        limit: Optional[int] = None,
        search: Optional[str] = None,
        **kwargs: Any,
    ) -> _models.PathsMnwxgV3DataPointChoicesGetResponses200ContentApplicationJsonSchema:
        """Get list of data point choices.

        Returns available choices for a specific enum data point.

        :param data_point: The data point to get choices for.
        :type data_point: str
        :param collection: The collection to get choices for.
        :type collection: str
        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is None.
        :type limit: int
        :param search: Filter choices by searching for a substring. Default value is None.
        :type search: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PathsMnwxgV3DataPointChoicesGetResponses200ContentApplicationJsonSchema, or the result
         of cls(response)
        :rtype: ~affinda.models.PathsMnwxgV3DataPointChoicesGetResponses200ContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.PathsMnwxgV3DataPointChoicesGetResponses200ContentApplicationJsonSchema]

        request = build_get_data_point_choices_request(
            data_point=data_point,
            collection=collection,
            offset=offset,
            limit=limit,
            search=search,
            template_url=self.get_data_point_choices.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize(
            "PathsMnwxgV3DataPointChoicesGetResponses200ContentApplicationJsonSchema",
            pipeline_response,
        )

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_data_point_choices.metadata = {"url": "/v3/data_point_choices"}  # type: ignore

    async def create_data_point_choice(
        self, body: Optional[_models.DataPointChoiceCreate] = None, **kwargs: Any
    ) -> _models.DataPointChoice:
        """Create a data point choice.

        Create a custom data point choice.

        :param body:  Default value is None.
        :type body: ~affinda.models.DataPointChoiceCreate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DataPointChoice, or the result of cls(response)
        :rtype: ~affinda.models.DataPointChoice
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.DataPointChoice]

        if body is not None:
            _json = self._serialize.body(body, "DataPointChoiceCreate")
        else:
            _json = None

        request = build_create_data_point_choice_request(
            content_type=content_type,
            json=_json,
            template_url=self.create_data_point_choice.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("DataPointChoice", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_data_point_choice.metadata = {"url": "/v3/data_point_choices"}  # type: ignore

    async def get_data_point_choice(self, id: int, **kwargs: Any) -> _models.DataPointChoice:
        """Get specific data point choice.

        Return a specific data point choice.

        :param id: Data point choice's ID.
        :type id: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DataPointChoice, or the result of cls(response)
        :rtype: ~affinda.models.DataPointChoice
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.DataPointChoice]

        request = build_get_data_point_choice_request(
            id=id,
            template_url=self.get_data_point_choice.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("DataPointChoice", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_data_point_choice.metadata = {"url": "/v3/data_point_choices/{id}"}  # type: ignore

    async def update_data_point_choice(
        self, id: int, body: _models.DataPointChoiceUpdate, **kwargs: Any
    ) -> _models.DataPointChoice:
        """Update a data point choice.

        Update data of a data point choice.

        :param id: Data point choice's ID.
        :type id: int
        :param body: Data point choice to update.
        :type body: ~affinda.models.DataPointChoiceUpdate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DataPointChoice, or the result of cls(response)
        :rtype: ~affinda.models.DataPointChoice
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.DataPointChoice]

        _json = self._serialize.body(body, "DataPointChoiceUpdate")

        request = build_update_data_point_choice_request(
            id=id,
            content_type=content_type,
            json=_json,
            template_url=self.update_data_point_choice.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("DataPointChoice", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_data_point_choice.metadata = {"url": "/v3/data_point_choices/{id}"}  # type: ignore

    async def delete_data_point_choice(  # pylint: disable=inconsistent-return-statements
        self, id: int, **kwargs: Any
    ) -> None:
        """Delete a data point choice.

        Deletes the specified data point choice from the database.

        :param id: Data point choice's ID.
        :type id: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_data_point_choice_request(
            id=id,
            template_url=self.delete_data_point_choice.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_data_point_choice.metadata = {"url": "/v3/data_point_choices/{id}"}  # type: ignore

    async def replace_data_point_choices(
        self, body: Optional[_models.DataPointChoiceReplaceRequest] = None, **kwargs: Any
    ) -> _models.DataPointChoiceReplaceResponse:
        """Replace choices of a data point.

        Replace choices of a data point. Existing choices and incoming choices are matched base on
        their ``value``. New ``value`` will be created, existing ``value`` will be updated, and
        ``value`` not in incoming choices will be deleted.

        :param body:  Default value is None.
        :type body: ~affinda.models.DataPointChoiceReplaceRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DataPointChoiceReplaceResponse, or the result of cls(response)
        :rtype: ~affinda.models.DataPointChoiceReplaceResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.DataPointChoiceReplaceResponse]

        if body is not None:
            _json = self._serialize.body(body, "DataPointChoiceReplaceRequest")
        else:
            _json = None

        request = build_replace_data_point_choices_request(
            content_type=content_type,
            json=_json,
            template_url=self.replace_data_point_choices.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("DataPointChoiceReplaceResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    replace_data_point_choices.metadata = {"url": "/v3/data_point_choices/replace"}  # type: ignore

    async def get_all_annotations(
        self, document: str, **kwargs: Any
    ) -> _models.Paths1D5Zg6MV3AnnotationsGetResponses200ContentApplicationJsonSchema:
        """Get list of all annotations.

        Returns your annotations.

        :param document: Filter by document.
        :type document: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Paths1D5Zg6MV3AnnotationsGetResponses200ContentApplicationJsonSchema, or the result of
         cls(response)
        :rtype: ~affinda.models.Paths1D5Zg6MV3AnnotationsGetResponses200ContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Paths1D5Zg6MV3AnnotationsGetResponses200ContentApplicationJsonSchema]

        request = build_get_all_annotations_request(
            document=document,
            template_url=self.get_all_annotations.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize(
            "Paths1D5Zg6MV3AnnotationsGetResponses200ContentApplicationJsonSchema",
            pipeline_response,
        )

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_annotations.metadata = {"url": "/v3/annotations"}  # type: ignore

    async def create_annotation(
        self, body: _models.AnnotationCreate, **kwargs: Any
    ) -> Optional[_models.AnnotationWithValidationResults]:
        """Create a annotation.

        Create a annotation.

        :param body:
        :type body: ~affinda.models.AnnotationCreate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AnnotationWithValidationResults or None, or the result of cls(response)
        :rtype: ~affinda.models.AnnotationWithValidationResults or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[Optional[_models.AnnotationWithValidationResults]]

        _json = self._serialize.body(body, "AnnotationCreate")

        request = build_create_annotation_request(
            content_type=content_type,
            json=_json,
            template_url=self.create_annotation.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("AnnotationWithValidationResults", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_annotation.metadata = {"url": "/v3/annotations"}  # type: ignore

    async def get_annotation(self, id: int, **kwargs: Any) -> Optional[_models.Annotation]:
        """Get specific annotation.

        Return a specific annotation.

        :param id: Annotation's ID.
        :type id: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Annotation or None, or the result of cls(response)
        :rtype: ~affinda.models.Annotation or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[Optional[_models.Annotation]]

        request = build_get_annotation_request(
            id=id,
            template_url=self.get_annotation.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Annotation", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_annotation.metadata = {"url": "/v3/annotations/{id}"}  # type: ignore

    async def update_annotation(
        self, id: int, body: _models.AnnotationUpdate, **kwargs: Any
    ) -> Optional[_models.Annotation]:
        """Update an annotation.

        Update data of an annotation.

        :param id: Annotation's ID.
        :type id: int
        :param body: Annotation data to update.
        :type body: ~affinda.models.AnnotationUpdate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Annotation or None, or the result of cls(response)
        :rtype: ~affinda.models.Annotation or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[Optional[_models.Annotation]]

        _json = self._serialize.body(body, "AnnotationUpdate")

        request = build_update_annotation_request(
            id=id,
            content_type=content_type,
            json=_json,
            template_url=self.update_annotation.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Annotation", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_annotation.metadata = {"url": "/v3/annotations/{id}"}  # type: ignore

    async def delete_annotation(self, id: int, **kwargs: Any) -> _models.AnotationDelete:
        """Delete an annotation.

        Deletes the specified annotation from the database.

        :param id: Annotation's ID.
        :type id: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AnotationDelete, or the result of cls(response)
        :rtype: ~affinda.models.AnotationDelete
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.AnotationDelete]

        request = build_delete_annotation_request(
            id=id,
            template_url=self.delete_annotation.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("AnotationDelete", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    delete_annotation.metadata = {"url": "/v3/annotations/{id}"}  # type: ignore

    async def batch_create_annotations(
        self, body: List[_models.AnnotationCreate], **kwargs: Any
    ) -> List[_models.Annotation]:
        """Batch create annotations.

        Batch create annotations.

        :param body:
        :type body: list[~affinda.models.AnnotationCreate]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of Annotation, or the result of cls(response)
        :rtype: list[~affinda.models.Annotation]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[List[_models.Annotation]]

        _json = self._serialize.body(body, "[AnnotationCreate]")

        request = build_batch_create_annotations_request(
            content_type=content_type,
            json=_json,
            template_url=self.batch_create_annotations.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("[Annotation]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    batch_create_annotations.metadata = {"url": "/v3/annotations/batch_create"}  # type: ignore

    async def batch_update_annotations(
        self, body: List[_models.AnnotationBatchUpdate], **kwargs: Any
    ) -> List[_models.Annotation]:
        """Batch update annotations.

        Batch update annotations.

        :param body:
        :type body: list[~affinda.models.AnnotationBatchUpdate]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of Annotation, or the result of cls(response)
        :rtype: list[~affinda.models.Annotation]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[List[_models.Annotation]]

        _json = self._serialize.body(body, "[AnnotationBatchUpdate]")

        request = build_batch_update_annotations_request(
            content_type=content_type,
            json=_json,
            template_url=self.batch_update_annotations.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("[Annotation]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    batch_update_annotations.metadata = {"url": "/v3/annotations/batch_update"}  # type: ignore

    async def batch_delete_annotations(
        self, body: List[int], **kwargs: Any
    ) -> _models.BatchDeleteAnnotationsResponse:
        """Batch delete annotations.

        Batch delete annotations.

        :param body:
        :type body: list[int]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BatchDeleteAnnotationsResponse, or the result of cls(response)
        :rtype: ~affinda.models.BatchDeleteAnnotationsResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.BatchDeleteAnnotationsResponse]

        _json = self._serialize.body(body, "[int]")

        request = build_batch_delete_annotations_request(
            content_type=content_type,
            json=_json,
            template_url=self.batch_delete_annotations.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("BatchDeleteAnnotationsResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    batch_delete_annotations.metadata = {"url": "/v3/annotations/batch_delete"}  # type: ignore

    async def create_mapping_data_source(
        self, body: _models.MappingDataSourceCreate, **kwargs: Any
    ) -> _models.MappingDataSource:
        """Create a mapping data source.

        Create a custom mapping data source.

        :param body:
        :type body: ~affinda.models.MappingDataSourceCreate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: MappingDataSource, or the result of cls(response)
        :rtype: ~affinda.models.MappingDataSource
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.MappingDataSource]

        _json = self._serialize.body(body, "MappingDataSourceCreate")

        request = build_create_mapping_data_source_request(
            content_type=content_type,
            json=_json,
            template_url=self.create_mapping_data_source.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("MappingDataSource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_mapping_data_source.metadata = {"url": "/v3/mapping_data_sources"}  # type: ignore

    async def list_mapping_data_sources(
        self,
        offset: Optional[int] = None,
        limit: Optional[int] = None,
        name: Optional[str] = None,
        organization: Optional[str] = None,
        workspace: Optional[str] = None,
        identifier: Optional[str] = None,
        **kwargs: Any,
    ) -> _models.Paths11QdcofV3MappingDataSourcesGetResponses200ContentApplicationJsonSchema:
        """List mapping data sources.

        Returns the list of all custom mapping data sources.

        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is None.
        :type limit: int
        :param name: Filter by name. Default value is None.
        :type name: str
        :param organization: Filter by organization. Default value is None.
        :type organization: str
        :param workspace: Filter by workspace. Default value is None.
        :type workspace: str
        :param identifier: Filter by identifier. Default value is None.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Paths11QdcofV3MappingDataSourcesGetResponses200ContentApplicationJsonSchema, or the
         result of cls(response)
        :rtype:
         ~affinda.models.Paths11QdcofV3MappingDataSourcesGetResponses200ContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Paths11QdcofV3MappingDataSourcesGetResponses200ContentApplicationJsonSchema]

        request = build_list_mapping_data_sources_request(
            offset=offset,
            limit=limit,
            name=name,
            organization=organization,
            workspace=workspace,
            identifier=identifier,
            template_url=self.list_mapping_data_sources.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize(
            "Paths11QdcofV3MappingDataSourcesGetResponses200ContentApplicationJsonSchema",
            pipeline_response,
        )

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_mapping_data_sources.metadata = {"url": "/v3/mapping_data_sources"}  # type: ignore

    async def get_mapping_data_source(
        self, identifier: str, **kwargs: Any
    ) -> _models.MappingDataSource:
        """Get specific mapping data source.

        Return a specific mapping data source.

        :param identifier: Mapping data source's identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: MappingDataSource, or the result of cls(response)
        :rtype: ~affinda.models.MappingDataSource
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.MappingDataSource]

        request = build_get_mapping_data_source_request(
            identifier=identifier,
            template_url=self.get_mapping_data_source.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("MappingDataSource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_mapping_data_source.metadata = {"url": "/v3/mapping_data_sources/{identifier}"}  # type: ignore

    async def delete_mapping_data_source(  # pylint: disable=inconsistent-return-statements
        self, identifier: str, **kwargs: Any
    ) -> None:
        """Delete specific mapping data source.

        Delete the specified mapping data source from the database.

        :param identifier: Mapping data source's identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_mapping_data_source_request(
            identifier=identifier,
            template_url=self.delete_mapping_data_source.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_mapping_data_source.metadata = {"url": "/v3/mapping_data_sources/{identifier}"}  # type: ignore

    async def list_mapping_data_source_values(
        self,
        identifier: str,
        limit: Optional[int] = None,
        offset: Optional[int] = None,
        search: Optional[str] = None,
        annotation: Optional[int] = None,
        document: Optional[str] = None,
        **kwargs: Any,
    ) -> _models.Paths1Qr7BnyV3MappingDataSourcesIdentifierValuesGetResponses200ContentApplicationJsonSchema:
        """List values for a mapping data source.

        Returns the list of all values in a mapping data source.

        :param identifier: Mapping data source's identifier.
        :type identifier: str
        :param limit: The numbers of results to return. Default value is None.
        :type limit: int
        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param search: Search for specific values. Default value is None.
        :type search: str
        :param annotation: Filter based on annotation ID. Default value is None.
        :type annotation: int
        :param document: Identifier of the document to apply filter lookups on if available. Default
         value is None.
        :type document: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return:
         Paths1Qr7BnyV3MappingDataSourcesIdentifierValuesGetResponses200ContentApplicationJsonSchema, or
         the result of cls(response)
        :rtype:
         ~affinda.models.Paths1Qr7BnyV3MappingDataSourcesIdentifierValuesGetResponses200ContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Paths1Qr7BnyV3MappingDataSourcesIdentifierValuesGetResponses200ContentApplicationJsonSchema]

        request = build_list_mapping_data_source_values_request(
            identifier=identifier,
            limit=limit,
            offset=offset,
            search=search,
            annotation=annotation,
            document=document,
            template_url=self.list_mapping_data_source_values.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize(
            "Paths1Qr7BnyV3MappingDataSourcesIdentifierValuesGetResponses200ContentApplicationJsonSchema",
            pipeline_response,
        )

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_mapping_data_source_values.metadata = {
        "url": "/v3/mapping_data_sources/{identifier}/values"
    }  # type: ignore

    async def replace_mapping_data_source_values(
        self, identifier: str, body: List[Any], **kwargs: Any
    ) -> List[Any]:
        """Replace values for a mapping data source.

        Replaces the list of all values in a mapping data source.

        :param identifier: Mapping data source's identifier.
        :type identifier: str
        :param body:
        :type body: list[any]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of any, or the result of cls(response)
        :rtype: list[any]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[List[Any]]

        _json = self._serialize.body(body, "[object]")

        request = build_replace_mapping_data_source_values_request(
            identifier=identifier,
            content_type=content_type,
            json=_json,
            template_url=self.replace_mapping_data_source_values.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("[object]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    replace_mapping_data_source_values.metadata = {
        "url": "/v3/mapping_data_sources/{identifier}/values"
    }  # type: ignore

    async def add_mapping_data_source_value(
        self, identifier: str, body: Any, **kwargs: Any
    ) -> Any:
        """Add value for a mapping data source.

        Adds a value to a mapping data source.

        :param identifier: Mapping data source's identifier.
        :type identifier: str
        :param body:
        :type body: any
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: any, or the result of cls(response)
        :rtype: any
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[Any]

        _json = self._serialize.body(body, "object")

        request = build_add_mapping_data_source_value_request(
            identifier=identifier,
            content_type=content_type,
            json=_json,
            template_url=self.add_mapping_data_source_value.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("object", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    add_mapping_data_source_value.metadata = {
        "url": "/v3/mapping_data_sources/{identifier}/values"
    }  # type: ignore

    async def get_mapping_data_source_value(
        self, identifier: str, value: str, **kwargs: Any
    ) -> Any:
        """Get specific mapping data source value.

        Return a specific mapping dta source value.

        :param identifier: Mapping data source's identifier.
        :type identifier: str
        :param value: Mapping Data Source Value's value.
        :type value: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: any, or the result of cls(response)
        :rtype: any
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[Any]

        request = build_get_mapping_data_source_value_request(
            identifier=identifier,
            value=value,
            template_url=self.get_mapping_data_source_value.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("object", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_mapping_data_source_value.metadata = {
        "url": "/v3/mapping_data_sources/{identifier}/values/{value}"
    }  # type: ignore

    async def update_mapping_data_source_value(
        self, identifier: str, value: str, body: Any, **kwargs: Any
    ) -> Any:
        """Update specific mapping data source value.

        Update the specified mapping data source value.

        :param identifier: Mapping data source's identifier.
        :type identifier: str
        :param value: Mapping Data Source's value.
        :type value: str
        :param body:
        :type body: any
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: any, or the result of cls(response)
        :rtype: any
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[Any]

        _json = self._serialize.body(body, "object")

        request = build_update_mapping_data_source_value_request(
            identifier=identifier,
            value=value,
            content_type=content_type,
            json=_json,
            template_url=self.update_mapping_data_source_value.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("object", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_mapping_data_source_value.metadata = {
        "url": "/v3/mapping_data_sources/{identifier}/values/{value}"
    }  # type: ignore

    async def delete_mapping_data_source_value(  # pylint: disable=inconsistent-return-statements
        self, identifier: str, value: str, **kwargs: Any
    ) -> None:
        """Delete specific mapping data source value.

        Delete the specified mapping data source value from the database.

        :param identifier: Mapping data source's identifier.
        :type identifier: str
        :param value: Mapping Data Source Value's value.
        :type value: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_mapping_data_source_value_request(
            identifier=identifier,
            value=value,
            template_url=self.delete_mapping_data_source_value.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_mapping_data_source_value.metadata = {
        "url": "/v3/mapping_data_sources/{identifier}/values/{value}"
    }  # type: ignore

    async def create_mapping(self, body: _models.MappingCreate, **kwargs: Any) -> _models.Mapping:
        """Create a mapping.

        Create a custom mapping.

        :param body:
        :type body: ~affinda.models.MappingCreate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Mapping, or the result of cls(response)
        :rtype: ~affinda.models.Mapping
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Mapping]

        _json = self._serialize.body(body, "MappingCreate")

        request = build_create_mapping_request(
            content_type=content_type,
            json=_json,
            template_url=self.create_mapping.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Mapping", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_mapping.metadata = {"url": "/v3/mappings"}  # type: ignore

    async def list_mappings(
        self,
        mapping_data_source: str,
        offset: Optional[int] = None,
        limit: Optional[int] = None,
        **kwargs: Any,
    ) -> _models.Paths1Dpvb2PV3MappingsGetResponses200ContentApplicationJsonSchema:
        """List mappings.

        Returns the list of all custom data mappings.

        :param mapping_data_source: Mapping data source's identifier.
        :type mapping_data_source: str
        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is None.
        :type limit: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Paths1Dpvb2PV3MappingsGetResponses200ContentApplicationJsonSchema, or the result of
         cls(response)
        :rtype: ~affinda.models.Paths1Dpvb2PV3MappingsGetResponses200ContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Paths1Dpvb2PV3MappingsGetResponses200ContentApplicationJsonSchema]

        request = build_list_mappings_request(
            mapping_data_source=mapping_data_source,
            offset=offset,
            limit=limit,
            template_url=self.list_mappings.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize(
            "Paths1Dpvb2PV3MappingsGetResponses200ContentApplicationJsonSchema", pipeline_response
        )

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_mappings.metadata = {"url": "/v3/mappings"}  # type: ignore

    async def get_mapping(self, identifier: str, **kwargs: Any) -> _models.Mapping:
        """Get specific mapping.

        Return a specific mapping.

        :param identifier: Mapping's identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Mapping, or the result of cls(response)
        :rtype: ~affinda.models.Mapping
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Mapping]

        request = build_get_mapping_request(
            identifier=identifier,
            template_url=self.get_mapping.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Mapping", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_mapping.metadata = {"url": "/v3/mappings/{identifier}"}  # type: ignore

    async def delete_mapping(  # pylint: disable=inconsistent-return-statements
        self, identifier: str, **kwargs: Any
    ) -> None:
        """Delete specific mapping.

        Delete the specified mapping from the database.

        :param identifier: Mapping's identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_mapping_request(
            identifier=identifier,
            template_url=self.delete_mapping.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_mapping.metadata = {"url": "/v3/mappings/{identifier}"}  # type: ignore

    async def update_mapping(
        self, identifier: str, body: _models.MappingUpdate, **kwargs: Any
    ) -> _models.Mapping:
        """Update specific mapping.

        Updates a specific mapping.

        :param identifier: Mapping's identifier.
        :type identifier: str
        :param body:
        :type body: ~affinda.models.MappingUpdate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Mapping, or the result of cls(response)
        :rtype: ~affinda.models.Mapping
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Mapping]

        _json = self._serialize.body(body, "MappingUpdate")

        request = build_update_mapping_request(
            identifier=identifier,
            content_type=content_type,
            json=_json,
            template_url=self.update_mapping.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Mapping", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_mapping.metadata = {"url": "/v3/mappings/{identifier}"}  # type: ignore

    async def get_all_tags(
        self,
        limit: Optional[int] = None,
        offset: Optional[int] = None,
        workspace: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs: Any,
    ) -> List[_models.Tag]:
        """Get list of all tags.

        Returns your tags.

        :param limit: The numbers of results to return. Default value is None.
        :type limit: int
        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param workspace: Filter by workspace. Default value is None.
        :type workspace: str
        :param name: Filter by name. Default value is None.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of Tag, or the result of cls(response)
        :rtype: list[~affinda.models.Tag]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[_models.Tag]]

        request = build_get_all_tags_request(
            limit=limit,
            offset=offset,
            workspace=workspace,
            name=name,
            template_url=self.get_all_tags.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("[Tag]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_tags.metadata = {"url": "/v3/tags"}  # type: ignore

    async def create_tag(self, body: _models.TagCreate, **kwargs: Any) -> _models.Tag:
        """Create a tag.

        Create a tag.

        :param body:
        :type body: ~affinda.models.TagCreate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Tag, or the result of cls(response)
        :rtype: ~affinda.models.Tag
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Tag]

        _json = self._serialize.body(body, "TagCreate")

        request = build_create_tag_request(
            content_type=content_type,
            json=_json,
            template_url=self.create_tag.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Tag", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_tag.metadata = {"url": "/v3/tags"}  # type: ignore

    async def get_tag(self, id: int, **kwargs: Any) -> _models.Tag:
        """Get specific tag.

        Return a specific tag.

        :param id: Tag's ID.
        :type id: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Tag, or the result of cls(response)
        :rtype: ~affinda.models.Tag
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Tag]

        request = build_get_tag_request(
            id=id,
            template_url=self.get_tag.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Tag", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_tag.metadata = {"url": "/v3/tags/{id}"}  # type: ignore

    async def update_tag(self, id: int, body: _models.TagUpdate, **kwargs: Any) -> _models.Tag:
        """Update a tag.

        Update data of an tag.

        :param id: Tag's ID.
        :type id: int
        :param body: Tag data to update.
        :type body: ~affinda.models.TagUpdate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Tag, or the result of cls(response)
        :rtype: ~affinda.models.Tag
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Tag]

        _json = self._serialize.body(body, "TagUpdate")

        request = build_update_tag_request(
            id=id,
            content_type=content_type,
            json=_json,
            template_url=self.update_tag.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Tag", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_tag.metadata = {"url": "/v3/tags/{id}"}  # type: ignore

    async def delete_tag(  # pylint: disable=inconsistent-return-statements
        self, id: int, **kwargs: Any
    ) -> None:
        """Delete an tag.

        Deletes the specified tag from the database.

        :param id: Tag's ID.
        :type id: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_tag_request(
            id=id,
            template_url=self.delete_tag.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_tag.metadata = {"url": "/v3/tags/{id}"}  # type: ignore

    async def get_document_types(
        self, organization: Optional[str] = None, workspace: Optional[str] = None, **kwargs: Any
    ) -> List[_models.DocumentType]:
        """List document types.

        Returns a list of document types that the user has access to.

        :param organization: Filter by organization identifier. Default value is None.
        :type organization: str
        :param workspace: Filter by workspace identifier. Default value is None.
        :type workspace: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of DocumentType, or the result of cls(response)
        :rtype: list[~affinda.models.DocumentType]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[_models.DocumentType]]

        request = build_get_document_types_request(
            organization=organization,
            workspace=workspace,
            template_url=self.get_document_types.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("[DocumentType]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_document_types.metadata = {"url": "/v3/document_types"}  # type: ignore

    async def create_document_type(
        self, body: _models.DocumentTypeCreate, **kwargs: Any
    ) -> Optional[_models.DocumentType]:
        """Create a document type.

        Create a new document type in the specified organization.

        :param body:
        :type body: ~affinda.models.DocumentTypeCreate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DocumentType, or the result of cls(response)
        :rtype: ~affinda.models.DocumentType or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[Optional[_models.DocumentType]]

        _json = self._serialize.body(body, "DocumentTypeCreate")

        request = build_create_document_type_request(
            content_type=content_type,
            json=_json,
            template_url=self.create_document_type.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201, 403]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = None
        if response.status_code == 201:
            deserialized = self._deserialize("DocumentType", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_document_type.metadata = {"url": "/v3/document_types"}  # type: ignore

    async def get_document_type(
        self, identifier: str, **kwargs: Any
    ) -> Optional[_models.DocumentType]:
        """Get a document type.

        Returns the details of a specific document type.

        :param identifier: Document type identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DocumentType, or the result of cls(response)
        :rtype: ~affinda.models.DocumentType or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[Optional[_models.DocumentType]]

        request = build_get_document_type_request(
            identifier=identifier,
            template_url=self.get_document_type.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("DocumentType", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_document_type.metadata = {"url": "/v3/document_types/{identifier}"}  # type: ignore

    async def update_document_type(
        self, identifier: str, body: _models.DocumentTypeUpdate, **kwargs: Any
    ) -> Optional[_models.DocumentType]:
        """Update a document type.

        Update an existing document type.

        :param identifier: Document type identifier.
        :type identifier: str
        :param body:
        :type body: ~affinda.models.DocumentTypeUpdate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DocumentType, or the result of cls(response)
        :rtype: ~affinda.models.DocumentType or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[Optional[_models.DocumentType]]

        _json = self._serialize.body(body, "DocumentTypeUpdate")

        request = build_update_document_type_request(
            identifier=identifier,
            content_type=content_type,
            json=_json,
            template_url=self.update_document_type.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 403, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("DocumentType", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_document_type.metadata = {"url": "/v3/document_types/{identifier}"}  # type: ignore

    async def delete_document_type(  # pylint: disable=inconsistent-return-statements
        self, identifier: str, **kwargs: Any
    ) -> None:
        """Delete a document type.

        Delete a document type.

        :param identifier: Document type identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_document_type_request(
            identifier=identifier,
            template_url=self.delete_document_type.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204, 403, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_document_type.metadata = {"url": "/v3/document_types/{identifier}"}  # type: ignore

    async def json_schema_from_document_type(
        self, identifier: str, title: Optional[str] = None, **kwargs: Any
    ) -> Dict[str, Any]:
        """Generate JSON schema from a document type.

        Generate JSON schema from a document type.

        :param identifier: Document type's identifier.
        :type identifier: str
        :param title: Title for the JSON schema. Default value is None.
        :type title: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: dict mapping str to any, or the result of cls(response)
        :rtype: dict[str, any]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[Dict[str, Any]]

        request = build_json_schema_from_document_type_request(
            identifier=identifier,
            title=title,
            template_url=self.json_schema_from_document_type.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("{object}", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    json_schema_from_document_type.metadata = {
        "url": "/v3/document_types/{identifier}/json_schema"
    }  # type: ignore

    async def pydantic_models_from_document_type(
        self, identifier: str, model_name: Optional[str] = None, **kwargs: Any
    ) -> _models.PydanticModelsResponse:
        """Generate Pydantic models from a document type.

        Generate Pydantic models from a document type.

        :param identifier: Document type's identifier.
        :type identifier: str
        :param model_name: Name for the Pydantic model. Default value is None.
        :type model_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PydanticModelsResponse, or the result of cls(response)
        :rtype: ~affinda.models.PydanticModelsResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.PydanticModelsResponse]

        request = build_pydantic_models_from_document_type_request(
            identifier=identifier,
            model_name=model_name,
            template_url=self.pydantic_models_from_document_type.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("PydanticModelsResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    pydantic_models_from_document_type.metadata = {
        "url": "/v3/document_types/{identifier}/pydantic_models"
    }  # type: ignore

    async def get_all_organizations(self, **kwargs: Any) -> List[_models.Organization]:
        """Get list of all organizations.

        Returns all the organizations.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of Organization, or the result of cls(response)
        :rtype: list[~affinda.models.Organization]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[_models.Organization]]

        request = build_get_all_organizations_request(
            template_url=self.get_all_organizations.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("[Organization]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_organizations.metadata = {"url": "/v3/organizations"}  # type: ignore

    async def create_organization(
        self,
        name: str,
        avatar: Optional[IO] = None,
        resthook_signature_key: Optional[str] = None,
        **kwargs: Any,
    ) -> _models.Organization:
        """Create a new organization.

        Create a new organization.

        :param name:
        :type name: str
        :param avatar: Upload avatar for the organization. Default value is None.
        :type avatar: IO
        :param resthook_signature_key:  Default value is None.
        :type resthook_signature_key: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Organization, or the result of cls(response)
        :rtype: ~affinda.models.Organization
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Organization]

        # Construct form data
        _files = {
            "name": name,
            "avatar": avatar,
            "resthookSignatureKey": resthook_signature_key,
        }

        request = build_create_organization_request(
            content_type=content_type,
            files=_files,
            template_url=self.create_organization.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request, _files)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Organization", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_organization.metadata = {"url": "/v3/organizations"}  # type: ignore

    async def get_organization(self, identifier: str, **kwargs: Any) -> _models.Organization:
        """Get detail of an organization.

        Get detail of an organization.

        :param identifier: Organization identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Organization, or the result of cls(response)
        :rtype: ~affinda.models.Organization
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Organization]

        request = build_get_organization_request(
            identifier=identifier,
            template_url=self.get_organization.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Organization", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_organization.metadata = {"url": "/v3/organizations/{identifier}"}  # type: ignore

    async def update_organization(
        self,
        identifier: str,
        name: Optional[str] = None,
        avatar: Optional[IO] = None,
        resthook_signature_key: Optional[str] = None,
        validation_tool_config: Optional[_models.ValidationToolConfig] = None,
        **kwargs: Any,
    ) -> _models.Organization:
        """Update an organization.

        Update the detail of an organization.

        :param identifier: Organization identifier.
        :type identifier: str
        :param name:  Default value is None.
        :type name: str
        :param avatar:  Default value is None.
        :type avatar: IO
        :param resthook_signature_key:  Default value is None.
        :type resthook_signature_key: str
        :param validation_tool_config:  Default value is None.
        :type validation_tool_config: ~affinda.models.ValidationToolConfig
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Organization, or the result of cls(response)
        :rtype: ~affinda.models.Organization
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Organization]

        # Construct form data
        _files = {
            "name": name,
            "avatar": avatar,
            "resthookSignatureKey": resthook_signature_key,
            "validationToolConfig": validation_tool_config,
        }

        request = build_update_organization_request(
            identifier=identifier,
            content_type=content_type,
            files=_files,
            template_url=self.update_organization.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request, _files)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Organization", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_organization.metadata = {"url": "/v3/organizations/{identifier}"}  # type: ignore

    async def delete_organization(  # pylint: disable=inconsistent-return-statements
        self, identifier: str, **kwargs: Any
    ) -> None:
        """Delete an organization.

        Delete the specified organization from the database.

        :param identifier: Organization identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_organization_request(
            identifier=identifier,
            template_url=self.delete_organization.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_organization.metadata = {"url": "/v3/organizations/{identifier}"}  # type: ignore

    async def get_all_organization_memberships(
        self,
        offset: Optional[int] = None,
        limit: Optional[int] = None,
        organization: Optional[str] = None,
        role: Optional[Union[str, "_models.OrganizationRole"]] = None,
        **kwargs: Any,
    ) -> _models.PathsQ5Os5RV3OrganizationMembershipsGetResponses200ContentApplicationJsonSchema:
        """Get list of all organization memberships.

        Returns all the organization memberships.

        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is None.
        :type limit: int
        :param organization: Filter by organization. Default value is None.
        :type organization: str
        :param role: Filter by role. Default value is None.
        :type role: str or ~affinda.models.OrganizationRole
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PathsQ5Os5RV3OrganizationMembershipsGetResponses200ContentApplicationJsonSchema, or
         the result of cls(response)
        :rtype:
         ~affinda.models.PathsQ5Os5RV3OrganizationMembershipsGetResponses200ContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.PathsQ5Os5RV3OrganizationMembershipsGetResponses200ContentApplicationJsonSchema]

        request = build_get_all_organization_memberships_request(
            offset=offset,
            limit=limit,
            organization=organization,
            role=role,
            template_url=self.get_all_organization_memberships.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize(
            "PathsQ5Os5RV3OrganizationMembershipsGetResponses200ContentApplicationJsonSchema",
            pipeline_response,
        )

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_organization_memberships.metadata = {"url": "/v3/organization_memberships"}  # type: ignore

    async def get_organization_membership(
        self, identifier: str, **kwargs: Any
    ) -> _models.OrganizationMembership:
        """Get detail of an organization membership.

        Get detail of an organization membership.

        :param identifier: Membership identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: OrganizationMembership, or the result of cls(response)
        :rtype: ~affinda.models.OrganizationMembership
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.OrganizationMembership]

        request = build_get_organization_membership_request(
            identifier=identifier,
            template_url=self.get_organization_membership.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("OrganizationMembership", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_organization_membership.metadata = {"url": "/v3/organization_memberships/{identifier}"}  # type: ignore

    async def update_organization_membership(
        self, identifier: str, body: _models.OrganizationMembershipUpdate, **kwargs: Any
    ) -> _models.OrganizationMembership:
        """Update an organization membership.

        The admin users can use this endpoint to update the role of the members within their
        organization.

        :param identifier: Membership identifier.
        :type identifier: str
        :param body:
        :type body: ~affinda.models.OrganizationMembershipUpdate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: OrganizationMembership, or the result of cls(response)
        :rtype: ~affinda.models.OrganizationMembership
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.OrganizationMembership]

        _json = self._serialize.body(body, "OrganizationMembershipUpdate")

        request = build_update_organization_membership_request(
            identifier=identifier,
            content_type=content_type,
            json=_json,
            template_url=self.update_organization_membership.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("OrganizationMembership", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_organization_membership.metadata = {"url": "/v3/organization_memberships/{identifier}"}  # type: ignore

    async def delete_organization_membership(  # pylint: disable=inconsistent-return-statements
        self, identifier: str, **kwargs: Any
    ) -> None:
        """Delete an organization membership.

        The admin users can use this endpoint to remove member from their organization. Other users can
        also use this to leave their organization.

        :param identifier: Membership identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_organization_membership_request(
            identifier=identifier,
            template_url=self.delete_organization_membership.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_organization_membership.metadata = {"url": "/v3/organization_memberships/{identifier}"}  # type: ignore

    async def get_all_invitations(
        self,
        offset: Optional[int] = None,
        limit: Optional[int] = None,
        organization: Optional[str] = None,
        status: Optional[Union[str, "_models.InvitationStatus"]] = None,
        role: Optional[Union[str, "_models.OrganizationRole"]] = None,
        **kwargs: Any,
    ) -> _models.Paths18Wh2VcV3InvitationsGetResponses200ContentApplicationJsonSchema:
        """Get list of all invitations.

        Get list of all invitations you created or sent to you.

        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is None.
        :type limit: int
        :param organization: Filter by organization. Default value is None.
        :type organization: str
        :param status: Filter by status. Default value is None.
        :type status: str or ~affinda.models.InvitationStatus
        :param role: Filter by role. Default value is None.
        :type role: str or ~affinda.models.OrganizationRole
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Paths18Wh2VcV3InvitationsGetResponses200ContentApplicationJsonSchema, or the result of
         cls(response)
        :rtype: ~affinda.models.Paths18Wh2VcV3InvitationsGetResponses200ContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Paths18Wh2VcV3InvitationsGetResponses200ContentApplicationJsonSchema]

        request = build_get_all_invitations_request(
            offset=offset,
            limit=limit,
            organization=organization,
            status=status,
            role=role,
            template_url=self.get_all_invitations.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize(
            "Paths18Wh2VcV3InvitationsGetResponses200ContentApplicationJsonSchema",
            pipeline_response,
        )

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_invitations.metadata = {"url": "/v3/invitations"}  # type: ignore

    async def create_invitation(
        self, body: _models.InvitationCreate, **kwargs: Any
    ) -> _models.Invitation:
        """Create a new invitation.

        Create a new invitation.

        :param body: Invitation to create.
        :type body: ~affinda.models.InvitationCreate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Invitation, or the result of cls(response)
        :rtype: ~affinda.models.Invitation
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Invitation]

        _json = self._serialize.body(body, "InvitationCreate")

        request = build_create_invitation_request(
            content_type=content_type,
            json=_json,
            template_url=self.create_invitation.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Invitation", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_invitation.metadata = {"url": "/v3/invitations"}  # type: ignore

    async def get_invitation(self, identifier: str, **kwargs: Any) -> _models.Invitation:
        """Get detail of an invitation.

        Get detail of an invitation.

        :param identifier: Invitation identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Invitation, or the result of cls(response)
        :rtype: ~affinda.models.Invitation
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Invitation]

        request = build_get_invitation_request(
            identifier=identifier,
            template_url=self.get_invitation.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Invitation", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_invitation.metadata = {"url": "/v3/invitations/{identifier}"}  # type: ignore

    async def update_invitation(
        self, identifier: str, body: _models.InvitationUpdate, **kwargs: Any
    ) -> _models.Invitation:
        """Update an invitation.

        Update the detail of an invitation.

        :param identifier: Invitation identifier.
        :type identifier: str
        :param body:
        :type body: ~affinda.models.InvitationUpdate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Invitation, or the result of cls(response)
        :rtype: ~affinda.models.Invitation
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Invitation]

        _json = self._serialize.body(body, "InvitationUpdate")

        request = build_update_invitation_request(
            identifier=identifier,
            content_type=content_type,
            json=_json,
            template_url=self.update_invitation.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Invitation", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_invitation.metadata = {"url": "/v3/invitations/{identifier}"}  # type: ignore

    async def delete_invitation(  # pylint: disable=inconsistent-return-statements
        self, identifier: str, **kwargs: Any
    ) -> None:
        """Delete an invitation.

        Delete the specified invitation from the database.

        :param identifier: Invitation identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_invitation_request(
            identifier=identifier,
            template_url=self.delete_invitation.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_invitation.metadata = {"url": "/v3/invitations/{identifier}"}  # type: ignore

    async def get_invitation_by_token(self, token: str, **kwargs: Any) -> _models.Invitation:
        """Get detail of an invitation by token.

        Get detail of an invitation using a secret token. This allows users who have not
        registered/logged in to view the invitation.

        :param token: Invitation token.
        :type token: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Invitation, or the result of cls(response)
        :rtype: ~affinda.models.Invitation
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Invitation]

        request = build_get_invitation_by_token_request(
            token=token,
            template_url=self.get_invitation_by_token.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Invitation", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_invitation_by_token.metadata = {"url": "/v3/invitations/token/{token}"}  # type: ignore

    async def respond_to_invitation(
        self, token: str, body: _models.InvitationResponse, **kwargs: Any
    ) -> _models.Invitation:
        """Respond to an invitation.

        Choose to accept or decline an invitation.

        :param token: Invitation token.
        :type token: str
        :param body:
        :type body: ~affinda.models.InvitationResponse
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Invitation, or the result of cls(response)
        :rtype: ~affinda.models.Invitation
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Invitation]

        _json = self._serialize.body(body, "InvitationResponse")

        request = build_respond_to_invitation_request(
            token=token,
            content_type=content_type,
            json=_json,
            template_url=self.respond_to_invitation.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Invitation", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    respond_to_invitation.metadata = {"url": "/v3/invitations/token/{token}"}  # type: ignore

    async def get_all_api_users(
        self, organization: Optional[str] = None, **kwargs: Any
    ) -> _models.Paths26Civ0V3ApiUsersGetResponses200ContentApplicationJsonSchema:
        """Get list of all API users.

        Returns your API users.

        :param organization: Filter by organization. Default value is None.
        :type organization: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Paths26Civ0V3ApiUsersGetResponses200ContentApplicationJsonSchema, or the result of
         cls(response)
        :rtype: ~affinda.models.Paths26Civ0V3ApiUsersGetResponses200ContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Paths26Civ0V3ApiUsersGetResponses200ContentApplicationJsonSchema]

        request = build_get_all_api_users_request(
            organization=organization,
            template_url=self.get_all_api_users.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize(
            "Paths26Civ0V3ApiUsersGetResponses200ContentApplicationJsonSchema", pipeline_response
        )

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_api_users.metadata = {"url": "/v3/api_users"}  # type: ignore

    async def create_api_user(
        self, body: _models.ApiUserCreate, **kwargs: Any
    ) -> _models.ApiUserWithKey:
        """Create an API user.

        Create an API user.

        :param body:
        :type body: ~affinda.models.ApiUserCreate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ApiUserWithKey, or the result of cls(response)
        :rtype: ~affinda.models.ApiUserWithKey
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ApiUserWithKey]

        _json = self._serialize.body(body, "ApiUserCreate")

        request = build_create_api_user_request(
            content_type=content_type,
            json=_json,
            template_url=self.create_api_user.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ApiUserWithKey", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_api_user.metadata = {"url": "/v3/api_users"}  # type: ignore

    async def get_api_user(self, id: int, **kwargs: Any) -> _models.ApiUserWithoutKey:
        """Get specific API user.

        Return a specific API user.

        :param id: API user's ID.
        :type id: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ApiUserWithoutKey, or the result of cls(response)
        :rtype: ~affinda.models.ApiUserWithoutKey
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ApiUserWithoutKey]

        request = build_get_api_user_request(
            id=id,
            template_url=self.get_api_user.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ApiUserWithoutKey", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_api_user.metadata = {"url": "/v3/api_users/{id}"}  # type: ignore

    async def update_api_user(
        self, id: int, body: _models.ApiUserUpdate, **kwargs: Any
    ) -> _models.ApiUserWithoutKey:
        """Update an API user.

        Update data of an API user.

        :param id: API user's ID.
        :type id: int
        :param body: API user to update.
        :type body: ~affinda.models.ApiUserUpdate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ApiUserWithoutKey, or the result of cls(response)
        :rtype: ~affinda.models.ApiUserWithoutKey
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ApiUserWithoutKey]

        _json = self._serialize.body(body, "ApiUserUpdate")

        request = build_update_api_user_request(
            id=id,
            content_type=content_type,
            json=_json,
            template_url=self.update_api_user.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ApiUserWithoutKey", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_api_user.metadata = {"url": "/v3/api_users/{id}"}  # type: ignore

    async def delete_api_user(  # pylint: disable=inconsistent-return-statements
        self, id: int, **kwargs: Any
    ) -> None:
        """Delete an API user.

        Deletes the specified API user from the database.

        :param id: API user's ID.
        :type id: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_api_user_request(
            id=id,
            template_url=self.delete_api_user.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_api_user.metadata = {"url": "/v3/api_users/{id}"}  # type: ignore

    async def regenerate_api_key_for_api_user(
        self, id: int, **kwargs: Any
    ) -> _models.ApiUserWithKey:
        """Regenerate API key for an API user.

        Regenerate API key for an API user.

        :param id: API user's ID.
        :type id: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ApiUserWithKey, or the result of cls(response)
        :rtype: ~affinda.models.ApiUserWithKey
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ApiUserWithKey]

        request = build_regenerate_api_key_for_api_user_request(
            id=id,
            template_url=self.regenerate_api_key_for_api_user.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ApiUserWithKey", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    regenerate_api_key_for_api_user.metadata = {"url": "/v3/api_users/{id}/regenerate_api_key"}  # type: ignore

    async def get_all_resthook_subscriptions(
        self, offset: Optional[int] = None, limit: Optional[int] = None, **kwargs: Any
    ) -> _models.PathsVz5Kj2V3ResthookSubscriptionsGetResponses200ContentApplicationJsonSchema:
        """Get list of all resthook subscriptions.

        Returns your resthook subscriptions.

        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is None.
        :type limit: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PathsVz5Kj2V3ResthookSubscriptionsGetResponses200ContentApplicationJsonSchema, or the
         result of cls(response)
        :rtype:
         ~affinda.models.PathsVz5Kj2V3ResthookSubscriptionsGetResponses200ContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.PathsVz5Kj2V3ResthookSubscriptionsGetResponses200ContentApplicationJsonSchema]

        request = build_get_all_resthook_subscriptions_request(
            offset=offset,
            limit=limit,
            template_url=self.get_all_resthook_subscriptions.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize(
            "PathsVz5Kj2V3ResthookSubscriptionsGetResponses200ContentApplicationJsonSchema",
            pipeline_response,
        )

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_resthook_subscriptions.metadata = {"url": "/v3/resthook_subscriptions"}  # type: ignore

    async def create_resthook_subscription(
        self, body: _models.ResthookSubscriptionCreate, **kwargs: Any
    ) -> _models.ResthookSubscription:
        """Create a resthook subscription.

        After a subscription is successfully created, we'll send a POST request to your target URL with
        a ``X-Hook-Secret`` header. :code:`<br />`
        You need to response to this request with a 200 status code to confirm your subscribe
        intention. :code:`<br />`
        Then, you need to use the ``X-Hook-Secret`` to activate the subscription using the
        `/resthook_subscriptions/activate <#post-/v3/resthook_subscriptions/activate>`_ endpoint.
        :code:`<br />`
        For more information and detailed instructions, `see our webhooks documentation here.
        <https://docs.affinda.com/docs/webhooks>`_.

        :param body:
        :type body: ~affinda.models.ResthookSubscriptionCreate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResthookSubscription, or the result of cls(response)
        :rtype: ~affinda.models.ResthookSubscription
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ResthookSubscription]

        _json = self._serialize.body(body, "ResthookSubscriptionCreate")

        request = build_create_resthook_subscription_request(
            content_type=content_type,
            json=_json,
            template_url=self.create_resthook_subscription.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ResthookSubscription", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_resthook_subscription.metadata = {"url": "/v3/resthook_subscriptions"}  # type: ignore

    async def get_resthook_subscription(
        self, id: int, **kwargs: Any
    ) -> _models.ResthookSubscription:
        """Get specific resthook subscription.

        Return a specific resthook subscription.

        :param id: Resthook subscription's ID.
        :type id: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResthookSubscription, or the result of cls(response)
        :rtype: ~affinda.models.ResthookSubscription
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ResthookSubscription]

        request = build_get_resthook_subscription_request(
            id=id,
            template_url=self.get_resthook_subscription.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ResthookSubscription", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_resthook_subscription.metadata = {"url": "/v3/resthook_subscriptions/{id}"}  # type: ignore

    async def update_resthook_subscription(
        self, id: int, body: _models.ResthookSubscriptionUpdate, **kwargs: Any
    ) -> _models.ResthookSubscription:
        """Update a resthook subscription.

        Update data of a resthook subscription.

        :param id: ResthookSubscription's ID.
        :type id: int
        :param body: ResthookSubscription data to update.
        :type body: ~affinda.models.ResthookSubscriptionUpdate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResthookSubscription, or the result of cls(response)
        :rtype: ~affinda.models.ResthookSubscription
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ResthookSubscription]

        _json = self._serialize.body(body, "ResthookSubscriptionUpdate")

        request = build_update_resthook_subscription_request(
            id=id,
            content_type=content_type,
            json=_json,
            template_url=self.update_resthook_subscription.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ResthookSubscription", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_resthook_subscription.metadata = {"url": "/v3/resthook_subscriptions/{id}"}  # type: ignore

    async def delete_resthook_subscription(  # pylint: disable=inconsistent-return-statements
        self, id: int, **kwargs: Any
    ) -> None:
        """Delete a resthook subscription.

        Deletes the specified resthook subscription from the database.

        :param id: ResthookSubscription's ID.
        :type id: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_resthook_subscription_request(
            id=id,
            template_url=self.delete_resthook_subscription.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_resthook_subscription.metadata = {"url": "/v3/resthook_subscriptions/{id}"}  # type: ignore

    async def activate_resthook_subscription(
        self, x_hook_secret: str, **kwargs: Any
    ) -> _models.ResthookSubscription:
        """Activate a resthook subscription.

        After creating a subscription, we'll send a POST request to your target URL with a
        ``X-Hook-Secret`` header. :code:`<br />`
        You should response to this with a 200 status code, and use the value of the ``X-Hook-Secret``
        header that you received to activate the subscription using this endpoint.

        :param x_hook_secret: The secret received when creating a subscription.
        :type x_hook_secret: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResthookSubscription, or the result of cls(response)
        :rtype: ~affinda.models.ResthookSubscription
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ResthookSubscription]

        request = build_activate_resthook_subscription_request(
            x_hook_secret=x_hook_secret,
            template_url=self.activate_resthook_subscription.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ResthookSubscription", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    activate_resthook_subscription.metadata = {"url": "/v3/resthook_subscriptions/activate"}  # type: ignore

    async def list_occupation_groups(self, **kwargs: Any) -> List[_models.OccupationGroup]:
        """List occupation groups.

        Returns the list of searchable occupation groups.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of OccupationGroup, or the result of cls(response)
        :rtype: list[~affinda.models.OccupationGroup]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[_models.OccupationGroup]]

        request = build_list_occupation_groups_request(
            template_url=self.list_occupation_groups.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("[OccupationGroup]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_occupation_groups.metadata = {"url": "/v3/occupation_groups"}  # type: ignore

    async def create_resume_search(
        self,
        body: _models.ResumeSearchParameters,
        offset: Optional[int] = None,
        limit: Optional[int] = None,
        **kwargs: Any,
    ) -> _models.ResumeSearch:
        """Search through parsed resumes.

        Searches through parsed resumes. Users have 3 options to create a search::code:`<br
        />`:code:`<br />` 1.    Match to a job description - a parsed job description is used to find
        candidates that suit it:code:`<br />` 2.  Match to a resume - a parsed resume is used to find
        other candidates that have similar attributes:code:`<br />` 3.  Search using custom
        criteria:code:`<br />`:code:`<br />` Users should only populate 1 of jobDescription, resume or
        the custom criteria.

        :param body: Search parameters.
        :type body: ~affinda.models.ResumeSearchParameters
        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is None.
        :type limit: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResumeSearch, or the result of cls(response)
        :rtype: ~affinda.models.ResumeSearch
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ResumeSearch]

        _json = self._serialize.body(body, "ResumeSearchParameters")

        request = build_create_resume_search_request(
            content_type=content_type,
            json=_json,
            offset=offset,
            limit=limit,
            template_url=self.create_resume_search.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ResumeSearch", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_resume_search.metadata = {"url": "/v3/resume_search"}  # type: ignore

    async def get_resume_search_detail(
        self, identifier: str, body: _models.ResumeSearchParameters, **kwargs: Any
    ) -> _models.ResumeSearchDetail:
        """Get search result of specific resume.

        This contains more detailed information about the matching score of the search criteria, or
        which search criteria is missing in this resume.
        The ``identifier`` is the unique ID returned via the `/resume_search <#post-/resume_search>`_
        endpoint.

        :param identifier: Resume identifier.
        :type identifier: str
        :param body: Search parameters.
        :type body: ~affinda.models.ResumeSearchParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResumeSearchDetail, or the result of cls(response)
        :rtype: ~affinda.models.ResumeSearchDetail
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ResumeSearchDetail]

        _json = self._serialize.body(body, "ResumeSearchParameters")

        request = build_get_resume_search_detail_request(
            identifier=identifier,
            content_type=content_type,
            json=_json,
            template_url=self.get_resume_search_detail.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ResumeSearchDetail", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_resume_search_detail.metadata = {"url": "/v3/resume_search/details/{identifier}"}  # type: ignore

    async def get_resume_search_config(self, **kwargs: Any) -> _models.ResumeSearchConfig:
        """Get the config for the logged in user's embeddable resume search tool.

        Return configurations such as which fields can be displayed in the logged in user's embeddable
        resume search tool, what are their weights, what is the maximum number of results that can be
        returned, etc.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResumeSearchConfig, or the result of cls(response)
        :rtype: ~affinda.models.ResumeSearchConfig
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ResumeSearchConfig]

        request = build_get_resume_search_config_request(
            template_url=self.get_resume_search_config.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ResumeSearchConfig", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_resume_search_config.metadata = {"url": "/v3/resume_search/config"}  # type: ignore

    async def update_resume_search_config(
        self, body: _models.ResumeSearchConfig, **kwargs: Any
    ) -> _models.ResumeSearchConfig:
        """Update the config for the logged in user's embeddable resume search tool.

        Update configurations such as which fields can be displayed in the logged in user's embeddable
        resume search tool, what are their weights, what is the maximum number of results that can be
        returned, etc.

        :param body:
        :type body: ~affinda.models.ResumeSearchConfig
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResumeSearchConfig, or the result of cls(response)
        :rtype: ~affinda.models.ResumeSearchConfig
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ResumeSearchConfig]

        _json = self._serialize.body(body, "ResumeSearchConfig")

        request = build_update_resume_search_config_request(
            content_type=content_type,
            json=_json,
            template_url=self.update_resume_search_config.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ResumeSearchConfig", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_resume_search_config.metadata = {"url": "/v3/resume_search/config"}  # type: ignore

    async def create_resume_search_embed_url(
        self,
        body: Optional[
            _models.Paths1Czpnk1V3ResumeSearchEmbedPostRequestbodyContentApplicationJsonSchema
        ] = None,
        **kwargs: Any,
    ) -> _models.ResumeSearchEmbed:
        """Create a signed URL for the embeddable resume search tool.

        Create and return a signed URL of the resume search tool which then can be embedded on a web
        page. An optional parameter ``config_override`` can be passed to override the user-level
        configurations of the embeddable resume search tool.

        :param body:  Default value is None.
        :type body:
         ~affinda.models.Paths1Czpnk1V3ResumeSearchEmbedPostRequestbodyContentApplicationJsonSchema
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResumeSearchEmbed, or the result of cls(response)
        :rtype: ~affinda.models.ResumeSearchEmbed
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ResumeSearchEmbed]

        if body is not None:
            _json = self._serialize.body(
                body, "Paths1Czpnk1V3ResumeSearchEmbedPostRequestbodyContentApplicationJsonSchema"
            )
        else:
            _json = None

        request = build_create_resume_search_embed_url_request(
            content_type=content_type,
            json=_json,
            template_url=self.create_resume_search_embed_url.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ResumeSearchEmbed", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_resume_search_embed_url.metadata = {"url": "/v3/resume_search/embed"}  # type: ignore

    async def get_resume_search_match(
        self,
        resume: str,
        job_description: str,
        index: Optional[str] = None,
        search_expression: Optional[str] = None,
        job_titles_weight: Optional[float] = None,
        years_experience_weight: Optional[float] = None,
        locations_weight: Optional[float] = None,
        languages_weight: Optional[float] = None,
        skills_weight: Optional[float] = None,
        education_weight: Optional[float] = None,
        search_expression_weight: Optional[float] = None,
        soc_codes_weight: Optional[float] = None,
        management_level_weight: Optional[float] = None,
        **kwargs: Any,
    ) -> _models.ResumeSearchMatch:
        """Match a single resume and job description.

        Get the matching score between a resume and a job description. The score ranges between 0 and
        1, with 0 being not a match at all, and 1 being perfect match.:code:`<br/>` Note, this score
        will not directly match the score returned from POST `/resume_search/details/{identifier}
        <#post-/resume_search/details/-identifier->`_.

        :param resume: Identify the resume to match.
        :type resume: str
        :param job_description: Identify the job description to match.
        :type job_description: str
        :param index: Optionally, specify an index to search in. If not specified, will search in all
         indexes. Default value is None.
        :type index: str
        :param search_expression: Add keywords to the search criteria. Default value is None.
        :type search_expression: str
        :param job_titles_weight: How important is this criteria to the matching score, range from 0 to
         1. Default value is None.
        :type job_titles_weight: float
        :param years_experience_weight: How important is this criteria to the matching score, range
         from 0 to 1. Default value is None.
        :type years_experience_weight: float
        :param locations_weight: How important is this criteria to the matching score, range from 0 to
         1. Default value is None.
        :type locations_weight: float
        :param languages_weight: How important is this criteria to the matching score, range from 0 to
         1. Default value is None.
        :type languages_weight: float
        :param skills_weight: How important is this criteria to the matching score, range from 0 to 1.
         Default value is None.
        :type skills_weight: float
        :param education_weight: How important is this criteria to the matching score, range from 0 to
         1. Default value is None.
        :type education_weight: float
        :param search_expression_weight: How important is this criteria to the matching score, range
         from 0 to 1. Default value is None.
        :type search_expression_weight: float
        :param soc_codes_weight: How important is this criteria to the matching score, range from 0 to
         1. Default value is None.
        :type soc_codes_weight: float
        :param management_level_weight: How important is this criteria to the matching score, range
         from 0 to 1. Default value is None.
        :type management_level_weight: float
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResumeSearchMatch, or the result of cls(response)
        :rtype: ~affinda.models.ResumeSearchMatch
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ResumeSearchMatch]

        request = build_get_resume_search_match_request(
            resume=resume,
            job_description=job_description,
            index=index,
            search_expression=search_expression,
            job_titles_weight=job_titles_weight,
            years_experience_weight=years_experience_weight,
            locations_weight=locations_weight,
            languages_weight=languages_weight,
            skills_weight=skills_weight,
            education_weight=education_weight,
            search_expression_weight=search_expression_weight,
            soc_codes_weight=soc_codes_weight,
            management_level_weight=management_level_weight,
            template_url=self.get_resume_search_match.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ResumeSearchMatch", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_resume_search_match.metadata = {"url": "/v3/resume_search/match"}  # type: ignore

    async def get_resume_search_suggestion_job_title(
        self, job_titles: List[str], **kwargs: Any
    ) -> List[str]:
        """Get job title suggestions based on provided job title(s).

        Provided one or more job titles, get related suggestions for your search.

        :param job_titles: Job title to query suggestions for.
        :type job_titles: list[str]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of str, or the result of cls(response)
        :rtype: list[str]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[str]]

        request = build_get_resume_search_suggestion_job_title_request(
            job_titles=job_titles,
            template_url=self.get_resume_search_suggestion_job_title.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("[str]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_resume_search_suggestion_job_title.metadata = {
        "url": "/v3/resume_search/suggestion_job_title"
    }  # type: ignore

    async def get_resume_search_suggestion_skill(
        self, skills: List[str], **kwargs: Any
    ) -> List[str]:
        """Get skill suggestions based on provided skill(s).

        Provided one or more skills, get related suggestions for your search.

        :param skills: Skill to query suggestions for.
        :type skills: list[str]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of str, or the result of cls(response)
        :rtype: list[str]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[str]]

        request = build_get_resume_search_suggestion_skill_request(
            skills=skills,
            template_url=self.get_resume_search_suggestion_skill.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("[str]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_resume_search_suggestion_skill.metadata = {"url": "/v3/resume_search/suggestion_skill"}  # type: ignore

    async def create_job_description_search(
        self,
        body: _models.JobDescriptionSearchParameters,
        offset: Optional[int] = None,
        limit: Optional[int] = None,
        **kwargs: Any,
    ) -> _models.JobDescriptionSearch:
        """Search through parsed job descriptions.

        Searches through parsed job descriptions. You can search with custom criterias or a resume.

        :param body: Search parameters.
        :type body: ~affinda.models.JobDescriptionSearchParameters
        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is None.
        :type limit: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobDescriptionSearch, or the result of cls(response)
        :rtype: ~affinda.models.JobDescriptionSearch
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.JobDescriptionSearch]

        _json = self._serialize.body(body, "JobDescriptionSearchParameters")

        request = build_create_job_description_search_request(
            content_type=content_type,
            json=_json,
            offset=offset,
            limit=limit,
            template_url=self.create_job_description_search.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("JobDescriptionSearch", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_job_description_search.metadata = {"url": "/v3/job_description_search"}  # type: ignore

    async def get_job_description_search_detail(
        self, identifier: str, body: _models.JobDescriptionSearchParameters, **kwargs: Any
    ) -> _models.JobDescriptionSearchDetail:
        """Get search result of specific job description.

        This contains more detailed information about the matching score of the search criteria, or
        which search criteria is missing in this job description.
        The ``identifier`` is the unique ID returned via the `/job_description_search
        <#post-/job_description_search>`_ endpoint.

        :param identifier: Job Description identifier.
        :type identifier: str
        :param body: Search parameters.
        :type body: ~affinda.models.JobDescriptionSearchParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobDescriptionSearchDetail, or the result of cls(response)
        :rtype: ~affinda.models.JobDescriptionSearchDetail
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.JobDescriptionSearchDetail]

        _json = self._serialize.body(body, "JobDescriptionSearchParameters")

        request = build_get_job_description_search_detail_request(
            identifier=identifier,
            content_type=content_type,
            json=_json,
            template_url=self.get_job_description_search_detail.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("JobDescriptionSearchDetail", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_job_description_search_detail.metadata = {
        "url": "/v3/job_description_search/details/{identifier}"
    }  # type: ignore

    async def get_job_description_search_config(
        self, **kwargs: Any
    ) -> _models.JobDescriptionSearchConfig:
        """Get the config for the logged in user's embeddable job description search tool.

        Return configurations such as which fields can be displayed in the logged in user's embeddable
        job description search tool, what are their weights, what is the maximum number of results that
        can be returned, etc.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobDescriptionSearchConfig, or the result of cls(response)
        :rtype: ~affinda.models.JobDescriptionSearchConfig
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.JobDescriptionSearchConfig]

        request = build_get_job_description_search_config_request(
            template_url=self.get_job_description_search_config.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("JobDescriptionSearchConfig", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_job_description_search_config.metadata = {"url": "/v3/job_description_search/config"}  # type: ignore

    async def update_job_description_search_config(
        self, body: _models.JobDescriptionSearchConfig, **kwargs: Any
    ) -> _models.JobDescriptionSearchConfig:
        """Update the config for the logged in user's embeddable job description search tool.

        Update configurations such as which fields can be displayed in the logged in user's embeddable
        job description search tool, what are their weights, what is the maximum number of results that
        can be returned, etc.

        :param body:
        :type body: ~affinda.models.JobDescriptionSearchConfig
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobDescriptionSearchConfig, or the result of cls(response)
        :rtype: ~affinda.models.JobDescriptionSearchConfig
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.JobDescriptionSearchConfig]

        _json = self._serialize.body(body, "JobDescriptionSearchConfig")

        request = build_update_job_description_search_config_request(
            content_type=content_type,
            json=_json,
            template_url=self.update_job_description_search_config.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("JobDescriptionSearchConfig", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_job_description_search_config.metadata = {"url": "/v3/job_description_search/config"}  # type: ignore

    async def create_job_description_search_embed_url(
        self,
        body: Optional[
            _models.PathsM3DzbgV3JobDescriptionSearchEmbedPostRequestbodyContentApplicationJsonSchema
        ] = None,
        **kwargs: Any,
    ) -> _models.JobDescriptionSearchEmbed:
        """Create a signed URL for the embeddable job description search tool.

        Create and return a signed URL of the job description search tool which then can be embedded on
        a web page. An optional parameter ``config_override`` can be passed to override the user-level
        configurations of the embeddable search tool.

        :param body:  Default value is None.
        :type body:
         ~affinda.models.PathsM3DzbgV3JobDescriptionSearchEmbedPostRequestbodyContentApplicationJsonSchema
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobDescriptionSearchEmbed, or the result of cls(response)
        :rtype: ~affinda.models.JobDescriptionSearchEmbed
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.JobDescriptionSearchEmbed]

        if body is not None:
            _json = self._serialize.body(
                body,
                "PathsM3DzbgV3JobDescriptionSearchEmbedPostRequestbodyContentApplicationJsonSchema",
            )
        else:
            _json = None

        request = build_create_job_description_search_embed_url_request(
            content_type=content_type,
            json=_json,
            template_url=self.create_job_description_search_embed_url.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("JobDescriptionSearchEmbed", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_job_description_search_embed_url.metadata = {"url": "/v3/job_description_search/embed"}  # type: ignore

    async def get_all_indexes(
        self,
        offset: Optional[int] = None,
        limit: Optional[int] = None,
        document_type: Optional[Union[str, "_models.Enum22"]] = None,
        name: Optional[str] = None,
        **kwargs: Any,
    ) -> _models.PathsDvrcp3V3IndexGetResponses200ContentApplicationJsonSchema:
        """Get list of all indexes.

        Returns all the indexes.

        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is None.
        :type limit: int
        :param document_type: Filter indices by a document type. Default value is None.
        :type document_type: str or ~affinda.models.Enum22
        :param name: Filter indices by name. Default value is None.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PathsDvrcp3V3IndexGetResponses200ContentApplicationJsonSchema, or the result of
         cls(response)
        :rtype: ~affinda.models.PathsDvrcp3V3IndexGetResponses200ContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.PathsDvrcp3V3IndexGetResponses200ContentApplicationJsonSchema]

        request = build_get_all_indexes_request(
            offset=offset,
            limit=limit,
            document_type=document_type,
            name=name,
            template_url=self.get_all_indexes.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize(
            "PathsDvrcp3V3IndexGetResponses200ContentApplicationJsonSchema", pipeline_response
        )

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_indexes.metadata = {"url": "/v3/index"}  # type: ignore

    async def create_index(self, body: _models.IndexCreate, **kwargs: Any) -> _models.Index:
        """Create a new index.

        Create an index for the search tool.

        :param body: Index to create.
        :type body: ~affinda.models.IndexCreate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Index, or the result of cls(response)
        :rtype: ~affinda.models.Index
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Index]

        _json = self._serialize.body(body, "IndexCreate")

        request = build_create_index_request(
            content_type=content_type,
            json=_json,
            template_url=self.create_index.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Index", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_index.metadata = {"url": "/v3/index"}  # type: ignore

    async def update_index(
        self, name: str, body: _models.IndexUpdate, **kwargs: Any
    ) -> _models.Index:
        """Update an index.

        Updates the specified index.

        :param name: Index name.
        :type name: str
        :param body: Index data to update.
        :type body: ~affinda.models.IndexUpdate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Index, or the result of cls(response)
        :rtype: ~affinda.models.Index
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Index]

        _json = self._serialize.body(body, "IndexUpdate")

        request = build_update_index_request(
            name=name,
            content_type=content_type,
            json=_json,
            template_url=self.update_index.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Index", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_index.metadata = {"url": "/v3/index/{name}"}  # type: ignore

    async def delete_index(  # pylint: disable=inconsistent-return-statements
        self, name: str, **kwargs: Any
    ) -> None:
        """Delete an index.

        Deletes the specified index from the database.

        :param name: Index name.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_index_request(
            name=name,
            template_url=self.delete_index.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_index.metadata = {"url": "/v3/index/{name}"}  # type: ignore

    async def get_all_index_documents(
        self, name: str, offset: Optional[int] = None, limit: Optional[int] = None, **kwargs: Any
    ) -> _models.PathsO7SnenV3IndexNameDocumentsGetResponses200ContentApplicationJsonSchema:
        """Get indexed documents for a specific index.

        Returns all the indexed documents for that index.

        :param name: Index name.
        :type name: str
        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is None.
        :type limit: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PathsO7SnenV3IndexNameDocumentsGetResponses200ContentApplicationJsonSchema, or the
         result of cls(response)
        :rtype:
         ~affinda.models.PathsO7SnenV3IndexNameDocumentsGetResponses200ContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.PathsO7SnenV3IndexNameDocumentsGetResponses200ContentApplicationJsonSchema]

        request = build_get_all_index_documents_request(
            name=name,
            offset=offset,
            limit=limit,
            template_url=self.get_all_index_documents.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize(
            "PathsO7SnenV3IndexNameDocumentsGetResponses200ContentApplicationJsonSchema",
            pipeline_response,
        )

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_index_documents.metadata = {"url": "/v3/index/{name}/documents"}  # type: ignore

    async def create_index_document(
        self,
        name: str,
        body: _models.PathsCl024WV3IndexNameDocumentsPostRequestbodyContentApplicationJsonSchema,
        **kwargs: Any,
    ) -> _models.PathsFte27NV3IndexNameDocumentsPostResponses201ContentApplicationJsonSchema:
        """Index a new document.

        Create an indexed document for the search tool.

        :param name: Index name.
        :type name: str
        :param body: Document to index.
        :type body:
         ~affinda.models.PathsCl024WV3IndexNameDocumentsPostRequestbodyContentApplicationJsonSchema
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PathsFte27NV3IndexNameDocumentsPostResponses201ContentApplicationJsonSchema, or the
         result of cls(response)
        :rtype:
         ~affinda.models.PathsFte27NV3IndexNameDocumentsPostResponses201ContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.PathsFte27NV3IndexNameDocumentsPostResponses201ContentApplicationJsonSchema]

        _json = self._serialize.body(
            body, "PathsCl024WV3IndexNameDocumentsPostRequestbodyContentApplicationJsonSchema"
        )

        request = build_create_index_document_request(
            name=name,
            content_type=content_type,
            json=_json,
            template_url=self.create_index_document.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize(
            "PathsFte27NV3IndexNameDocumentsPostResponses201ContentApplicationJsonSchema",
            pipeline_response,
        )

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_index_document.metadata = {"url": "/v3/index/{name}/documents"}  # type: ignore

    async def delete_index_document(  # pylint: disable=inconsistent-return-statements
        self, name: str, identifier: str, **kwargs: Any
    ) -> None:
        """Delete an indexed document.

        Delete the specified indexed document from the database.

        :param name: Index name.
        :type name: str
        :param identifier: Document identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_index_document_request(
            name=name,
            identifier=identifier,
            template_url=self.delete_index_document.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_index_document.metadata = {"url": "/v3/index/{name}/documents/{identifier}"}  # type: ignore

    async def re_index_document(  # pylint: disable=inconsistent-return-statements
        self, name: str, identifier: str, **kwargs: Any
    ) -> None:
        """Re-index a document.

        Re-index a document.
        This is relevant if you updated the document's data via the /annotations endpoint, and want to
        refresh
        the document's data in the search index.

        :param name: Index name.
        :type name: str
        :param identifier: Document identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_re_index_document_request(
            name=name,
            identifier=identifier,
            template_url=self.re_index_document.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    re_index_document.metadata = {"url": "/v3/index/{name}/documents/{identifier}/re_index"}  # type: ignore
