# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator (autorest: 3.10.3, generator: @autorest/python@5.16.0)
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, IO, List, Optional, TYPE_CHECKING, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    import __init__ as _models


class Accreditation(msrest.serialization.Model):
    """Accreditation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar education:
    :vartype education: str
    :ivar input_str:
    :vartype input_str: str
    :ivar match_str:
    :vartype match_str: str
    :ivar education_level:
    :vartype education_level: str
    """

    _validation = {
        "input_str": {"readonly": True},
        "match_str": {"readonly": True},
        "education_level": {"readonly": True},
    }

    _attribute_map = {
        "education": {"key": "education", "type": "str"},
        "input_str": {"key": "inputStr", "type": "str"},
        "match_str": {"key": "matchStr", "type": "str"},
        "education_level": {"key": "educationLevel", "type": "str"},
    }

    def __init__(self, *, education: Optional[str] = None, **kwargs):
        """
        :keyword education:
        :paramtype education: str
        """
        super(Accreditation, self).__init__(**kwargs)
        self.education = education
        self.input_str = None
        self.match_str = None
        self.education_level = None


class Annotation(msrest.serialization.Model):
    """Annotation.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required. Annotation's ID.
    :vartype id: int
    :ivar rectangle: Required. x/y coordinates for the rectangular bounding box containing the
     data.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required. x/y coordinates for the rectangles containing the data. An
     annotation can be contained within multiple rectangles.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar document: Required. Unique identifier for the document.
    :vartype document: str
    :ivar page_index: Required. The page number within the document, starting from 0.
    :vartype page_index: int
    :ivar raw: Required. Raw data extracted from the before any post-processing.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required. Indicates whether the data has been validated, either by a human
     using our validation tool or through auto-validation rules.
    :vartype is_verified: bool
    :ivar is_client_verified: Required. Indicates whether the data has been validated by a human.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required. Indicates whether the data has been auto-validated.
    :vartype is_auto_verified: bool
    :ivar data_point: Data point's identifier.
    :vartype data_point: str
    :ivar field: Field's identifier.
    :vartype field: str
    :ivar content_type: Required. The different data types of annotations. Known values are:
     "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
     "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
     "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
    :vartype content_type: str or ~affinda.models.AnnotationContentType
    :ivar parent: The parent annotation's ID.
    :vartype parent: int
    """

    _validation = {
        "id": {"required": True, "minimum": 1},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "document": {"required": True},
        "page_index": {"required": True, "minimum": 0},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "document": {"key": "document", "type": "str"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "field": {"key": "field", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parent": {"key": "parent", "type": "int"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        document: str,
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        content_type: Union[str, "_models.AnnotationContentType"],
        additional_properties: Optional[Dict[str, Any]] = None,
        data_point: Optional[str] = None,
        field: Optional[str] = None,
        parent: Optional[int] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required. Annotation's ID.
        :paramtype id: int
        :keyword rectangle: Required. x/y coordinates for the rectangular bounding box containing the
         data.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required. x/y coordinates for the rectangles containing the data. An
         annotation can be contained within multiple rectangles.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword document: Required. Unique identifier for the document.
        :paramtype document: str
        :keyword page_index: Required. The page number within the document, starting from 0.
        :paramtype page_index: int
        :keyword raw: Required. Raw data extracted from the before any post-processing.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required. Indicates whether the data has been validated, either by a
         human using our validation tool or through auto-validation rules.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required. Indicates whether the data has been validated by a
         human.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required. Indicates whether the data has been auto-validated.
        :paramtype is_auto_verified: bool
        :keyword data_point: Data point's identifier.
        :paramtype data_point: str
        :keyword field: Field's identifier.
        :paramtype field: str
        :keyword content_type: Required. The different data types of annotations. Known values are:
         "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
         "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
         "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
        :paramtype content_type: str or ~affinda.models.AnnotationContentType
        :keyword parent: The parent annotation's ID.
        :paramtype parent: int
        """
        super(Annotation, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.id = id
        self.rectangle = rectangle
        self.rectangles = rectangles
        self.document = document
        self.page_index = page_index
        self.raw = raw
        self.confidence = confidence
        self.classification_confidence = classification_confidence
        self.text_extraction_confidence = text_extraction_confidence
        self.is_verified = is_verified
        self.is_client_verified = is_client_verified
        self.is_auto_verified = is_auto_verified
        self.data_point = data_point
        self.field = field
        self.content_type = content_type
        self.parent = parent


class AnnotationBase(msrest.serialization.Model):
    """AnnotationBase.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id:
    :vartype id: int
    :ivar rectangle:
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles:
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index:
    :vartype page_index: int
    :ivar raw:
    :vartype raw: str
    :ivar confidence: The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: The model's confidence that the text has been classified
     correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: If the document was submitted as an image, this is the
     confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified:
    :vartype is_verified: bool
    :ivar is_client_verified:
    :vartype is_client_verified: bool
    :ivar is_auto_verified:
    :vartype is_auto_verified: bool
    :ivar data_point:
    :vartype data_point: str
    :ivar content_type:
    :vartype content_type: str
    """

    _validation = {
        "rectangles": {"readonly": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        id: Optional[int] = None,
        rectangle: Optional["_models.Rectangle"] = None,
        page_index: Optional[int] = None,
        raw: Optional[str] = None,
        confidence: Optional[float] = None,
        classification_confidence: Optional[float] = None,
        text_extraction_confidence: Optional[float] = None,
        is_verified: Optional[bool] = None,
        is_client_verified: Optional[bool] = None,
        is_auto_verified: Optional[bool] = None,
        data_point: Optional[str] = None,
        content_type: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id:
        :paramtype id: int
        :keyword rectangle:
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword page_index:
        :paramtype page_index: int
        :keyword raw:
        :paramtype raw: str
        :keyword confidence: The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: The model's confidence that the text has been classified
         correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: If the document was submitted as an image, this is the
         confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified:
        :paramtype is_verified: bool
        :keyword is_client_verified:
        :paramtype is_client_verified: bool
        :keyword is_auto_verified:
        :paramtype is_auto_verified: bool
        :keyword data_point:
        :paramtype data_point: str
        :keyword content_type:
        :paramtype content_type: str
        """
        super(AnnotationBase, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.id = id
        self.rectangle = rectangle
        self.rectangles = None
        self.page_index = page_index
        self.raw = raw
        self.confidence = confidence
        self.classification_confidence = classification_confidence
        self.text_extraction_confidence = text_extraction_confidence
        self.is_verified = is_verified
        self.is_client_verified = is_client_verified
        self.is_auto_verified = is_auto_verified
        self.data_point = data_point
        self.content_type = content_type


class AnnotationBatchUpdate(msrest.serialization.Model):
    """AnnotationBatchUpdate.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Annotation's ID.
    :vartype id: int
    :ivar rectangles: x/y coordinates for the rectangles containing the data. An annotation can be
     contained within multiple rectangles.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar document: Unique identifier for the document.
    :vartype document: str
    :ivar page_index: The page number within the document, starting from 0.
    :vartype page_index: int
    :ivar raw: Raw data extracted from the before any post-processing.
    :vartype raw: str
    :ivar parsed: Anything.
    :vartype parsed: any
    :ivar is_client_verified: Indicates whether the data has been validated by a human.
    :vartype is_client_verified: bool
    :ivar data_point: Data point's identifier.
    :vartype data_point: str
    :ivar parent: The parent annotation's ID.
    :vartype parent: int
    :ivar validation_results: The validation results created, changed or deleted as a result of
     updating the annotation.
    :vartype validation_results: list[~affinda.models.ChangedValidationResults]
    """

    _validation = {
        "id": {"required": True, "minimum": 1},
        "page_index": {"minimum": 0},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "document": {"key": "document", "type": "str"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "parsed": {"key": "parsed", "type": "object"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "parent": {"key": "parent", "type": "int"},
        "validation_results": {"key": "validationResults", "type": "[ChangedValidationResults]"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangles: Optional[List["_models.Rectangle"]] = None,
        document: Optional[str] = None,
        page_index: Optional[int] = None,
        raw: Optional[str] = None,
        parsed: Optional[Any] = None,
        is_client_verified: Optional[bool] = None,
        data_point: Optional[str] = None,
        parent: Optional[int] = None,
        validation_results: Optional[List["_models.ChangedValidationResults"]] = None,
        **kwargs,
    ):
        """
        :keyword id: Required. Annotation's ID.
        :paramtype id: int
        :keyword rectangles: x/y coordinates for the rectangles containing the data. An annotation can
         be contained within multiple rectangles.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword document: Unique identifier for the document.
        :paramtype document: str
        :keyword page_index: The page number within the document, starting from 0.
        :paramtype page_index: int
        :keyword raw: Raw data extracted from the before any post-processing.
        :paramtype raw: str
        :keyword parsed: Anything.
        :paramtype parsed: any
        :keyword is_client_verified: Indicates whether the data has been validated by a human.
        :paramtype is_client_verified: bool
        :keyword data_point: Data point's identifier.
        :paramtype data_point: str
        :keyword parent: The parent annotation's ID.
        :paramtype parent: int
        :keyword validation_results: The validation results created, changed or deleted as a result of
         updating the annotation.
        :paramtype validation_results: list[~affinda.models.ChangedValidationResults]
        """
        super(AnnotationBatchUpdate, self).__init__(**kwargs)
        self.id = id
        self.rectangles = rectangles
        self.document = document
        self.page_index = page_index
        self.raw = raw
        self.parsed = parsed
        self.is_client_verified = is_client_verified
        self.data_point = data_point
        self.parent = parent
        self.validation_results = validation_results


class AnnotationCreate(msrest.serialization.Model):
    """AnnotationCreate.

    All required parameters must be populated in order to send to Azure.

    :ivar rectangles: x/y coordinates for the rectangles containing the data. An annotation can be
     contained within multiple rectangles.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar document: Required. Unique identifier for the document.
    :vartype document: str
    :ivar page_index: Required. The page number within the document, starting from 0.
    :vartype page_index: int
    :ivar data_point: Data point's identifier.
    :vartype data_point: str
    :ivar field: Field's identifier.
    :vartype field: str
    :ivar raw: Raw data extracted from the before any post-processing.
    :vartype raw: str
    :ivar parsed: Anything.
    :vartype parsed: any
    :ivar is_client_verified: Indicates whether the data has been validated by a human.
    :vartype is_client_verified: bool
    :ivar parent: The parent annotation's ID.
    :vartype parent: int
    :ivar validation_results: The validation results created, changed or deleted as a result of
     creating the annotation.
    :vartype validation_results: list[~affinda.models.ChangedValidationResults]
    """

    _validation = {
        "document": {"required": True},
        "page_index": {"required": True, "minimum": 0},
    }

    _attribute_map = {
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "document": {"key": "document", "type": "str"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "field": {"key": "field", "type": "str"},
        "raw": {"key": "raw", "type": "str"},
        "parsed": {"key": "parsed", "type": "object"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "parent": {"key": "parent", "type": "int"},
        "validation_results": {"key": "validationResults", "type": "[ChangedValidationResults]"},
    }

    def __init__(
        self,
        *,
        document: str,
        page_index: int,
        rectangles: Optional[List["_models.Rectangle"]] = None,
        data_point: Optional[str] = None,
        field: Optional[str] = None,
        raw: Optional[str] = None,
        parsed: Optional[Any] = None,
        is_client_verified: Optional[bool] = None,
        parent: Optional[int] = None,
        validation_results: Optional[List["_models.ChangedValidationResults"]] = None,
        **kwargs,
    ):
        """
        :keyword rectangles: x/y coordinates for the rectangles containing the data. An annotation can
         be contained within multiple rectangles.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword document: Required. Unique identifier for the document.
        :paramtype document: str
        :keyword page_index: Required. The page number within the document, starting from 0.
        :paramtype page_index: int
        :keyword data_point: Data point's identifier.
        :paramtype data_point: str
        :keyword field: Field's identifier.
        :paramtype field: str
        :keyword raw: Raw data extracted from the before any post-processing.
        :paramtype raw: str
        :keyword parsed: Anything.
        :paramtype parsed: any
        :keyword is_client_verified: Indicates whether the data has been validated by a human.
        :paramtype is_client_verified: bool
        :keyword parent: The parent annotation's ID.
        :paramtype parent: int
        :keyword validation_results: The validation results created, changed or deleted as a result of
         creating the annotation.
        :paramtype validation_results: list[~affinda.models.ChangedValidationResults]
        """
        super(AnnotationCreate, self).__init__(**kwargs)
        self.rectangles = rectangles
        self.document = document
        self.page_index = page_index
        self.data_point = data_point
        self.field = field
        self.raw = raw
        self.parsed = parsed
        self.is_client_verified = is_client_verified
        self.parent = parent
        self.validation_results = validation_results


class AnnotationUpdate(msrest.serialization.Model):
    """AnnotationUpdate.

    :ivar rectangles: x/y coordinates for the rectangles containing the data. An annotation can be
     contained within multiple rectangles.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar document: Unique identifier for the document.
    :vartype document: str
    :ivar page_index: The page number within the document, starting from 0.
    :vartype page_index: int
    :ivar raw: Raw data extracted from the before any post-processing.
    :vartype raw: str
    :ivar parsed: Anything.
    :vartype parsed: any
    :ivar is_client_verified: Indicates whether the data has been validated by a human.
    :vartype is_client_verified: bool
    :ivar data_point: Data point's identifier.
    :vartype data_point: str
    :ivar field: Field's identifier.
    :vartype field: str
    :ivar parent: The parent annotation's ID.
    :vartype parent: int
    :ivar validation_results: The validation results created, changed or deleted as a result of
     updating the annotation.
    :vartype validation_results: list[~affinda.models.ChangedValidationResults]
    """

    _validation = {
        "page_index": {"minimum": 0},
    }

    _attribute_map = {
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "document": {"key": "document", "type": "str"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "parsed": {"key": "parsed", "type": "object"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "field": {"key": "field", "type": "str"},
        "parent": {"key": "parent", "type": "int"},
        "validation_results": {"key": "validationResults", "type": "[ChangedValidationResults]"},
    }

    def __init__(
        self,
        *,
        rectangles: Optional[List["_models.Rectangle"]] = None,
        document: Optional[str] = None,
        page_index: Optional[int] = None,
        raw: Optional[str] = None,
        parsed: Optional[Any] = None,
        is_client_verified: Optional[bool] = None,
        data_point: Optional[str] = None,
        field: Optional[str] = None,
        parent: Optional[int] = None,
        validation_results: Optional[List["_models.ChangedValidationResults"]] = None,
        **kwargs,
    ):
        """
        :keyword rectangles: x/y coordinates for the rectangles containing the data. An annotation can
         be contained within multiple rectangles.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword document: Unique identifier for the document.
        :paramtype document: str
        :keyword page_index: The page number within the document, starting from 0.
        :paramtype page_index: int
        :keyword raw: Raw data extracted from the before any post-processing.
        :paramtype raw: str
        :keyword parsed: Anything.
        :paramtype parsed: any
        :keyword is_client_verified: Indicates whether the data has been validated by a human.
        :paramtype is_client_verified: bool
        :keyword data_point: Data point's identifier.
        :paramtype data_point: str
        :keyword field: Field's identifier.
        :paramtype field: str
        :keyword parent: The parent annotation's ID.
        :paramtype parent: int
        :keyword validation_results: The validation results created, changed or deleted as a result of
         updating the annotation.
        :paramtype validation_results: list[~affinda.models.ChangedValidationResults]
        """
        super(AnnotationUpdate, self).__init__(**kwargs)
        self.rectangles = rectangles
        self.document = document
        self.page_index = page_index
        self.raw = raw
        self.parsed = parsed
        self.is_client_verified = is_client_verified
        self.data_point = data_point
        self.field = field
        self.parent = parent
        self.validation_results = validation_results


class AnnotationWithValidationResults(Annotation):
    """AnnotationWithValidationResults.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required. Annotation's ID.
    :vartype id: int
    :ivar rectangle: Required. x/y coordinates for the rectangular bounding box containing the
     data.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required. x/y coordinates for the rectangles containing the data. An
     annotation can be contained within multiple rectangles.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar document: Required. Unique identifier for the document.
    :vartype document: str
    :ivar page_index: Required. The page number within the document, starting from 0.
    :vartype page_index: int
    :ivar raw: Required. Raw data extracted from the before any post-processing.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required. Indicates whether the data has been validated, either by a human
     using our validation tool or through auto-validation rules.
    :vartype is_verified: bool
    :ivar is_client_verified: Required. Indicates whether the data has been validated by a human.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required. Indicates whether the data has been auto-validated.
    :vartype is_auto_verified: bool
    :ivar data_point: Data point's identifier.
    :vartype data_point: str
    :ivar field: Field's identifier.
    :vartype field: str
    :ivar content_type: Required. The different data types of annotations. Known values are:
     "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
     "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
     "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
    :vartype content_type: str or ~affinda.models.AnnotationContentType
    :ivar parent: The parent annotation's ID.
    :vartype parent: int
    :ivar validation_results: List of validation results for this annotation.
    :vartype validation_results: list[~affinda.models.ValidationResult]
    """

    _validation = {
        "id": {"required": True, "minimum": 1},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "document": {"required": True},
        "page_index": {"required": True, "minimum": 0},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "document": {"key": "document", "type": "str"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "field": {"key": "field", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parent": {"key": "parent", "type": "int"},
        "validation_results": {"key": "validationResults", "type": "[ValidationResult]"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        document: str,
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        content_type: Union[str, "_models.AnnotationContentType"],
        additional_properties: Optional[Dict[str, Any]] = None,
        data_point: Optional[str] = None,
        field: Optional[str] = None,
        parent: Optional[int] = None,
        validation_results: Optional[List["_models.ValidationResult"]] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required. Annotation's ID.
        :paramtype id: int
        :keyword rectangle: Required. x/y coordinates for the rectangular bounding box containing the
         data.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required. x/y coordinates for the rectangles containing the data. An
         annotation can be contained within multiple rectangles.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword document: Required. Unique identifier for the document.
        :paramtype document: str
        :keyword page_index: Required. The page number within the document, starting from 0.
        :paramtype page_index: int
        :keyword raw: Required. Raw data extracted from the before any post-processing.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required. Indicates whether the data has been validated, either by a
         human using our validation tool or through auto-validation rules.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required. Indicates whether the data has been validated by a
         human.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required. Indicates whether the data has been auto-validated.
        :paramtype is_auto_verified: bool
        :keyword data_point: Data point's identifier.
        :paramtype data_point: str
        :keyword field: Field's identifier.
        :paramtype field: str
        :keyword content_type: Required. The different data types of annotations. Known values are:
         "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
         "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
         "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
        :paramtype content_type: str or ~affinda.models.AnnotationContentType
        :keyword parent: The parent annotation's ID.
        :paramtype parent: int
        :keyword validation_results: List of validation results for this annotation.
        :paramtype validation_results: list[~affinda.models.ValidationResult]
        """
        super(AnnotationWithValidationResults, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            document=document,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            field=field,
            content_type=content_type,
            parent=parent,
            **kwargs,
        )
        self.validation_results = validation_results


class AnotationDelete(msrest.serialization.Model):
    """AnotationDelete.

    :ivar validation_results: The validation results created, changed or deleted as a result of
     deleting the annotation.
    :vartype validation_results: any
    """

    _attribute_map = {
        "validation_results": {"key": "validationResults", "type": "object"},
    }

    def __init__(self, *, validation_results: Optional[Any] = None, **kwargs):
        """
        :keyword validation_results: The validation results created, changed or deleted as a result of
         deleting the annotation.
        :paramtype validation_results: any
        """
        super(AnotationDelete, self).__init__(**kwargs)
        self.validation_results = validation_results


class ApiUserCreate(msrest.serialization.Model):
    """ApiUserCreate.

    All required parameters must be populated in order to send to Azure.

    :ivar name:
    :vartype name: str
    :ivar username:
    :vartype username: str
    :ivar email:
    :vartype email: str
    :ivar avatar: URL of the user's avatar.
    :vartype avatar: str
    :ivar organization: Required. Uniquely identify an organization.
    :vartype organization: str
    """

    _validation = {
        "organization": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "username": {"key": "username", "type": "str"},
        "email": {"key": "email", "type": "str"},
        "avatar": {"key": "avatar", "type": "str"},
        "organization": {"key": "organization", "type": "str"},
    }

    def __init__(
        self,
        *,
        organization: str,
        name: Optional[str] = None,
        username: Optional[str] = None,
        email: Optional[str] = None,
        avatar: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword username:
        :paramtype username: str
        :keyword email:
        :paramtype email: str
        :keyword avatar: URL of the user's avatar.
        :paramtype avatar: str
        :keyword organization: Required. Uniquely identify an organization.
        :paramtype organization: str
        """
        super(ApiUserCreate, self).__init__(**kwargs)
        self.name = name
        self.username = username
        self.email = email
        self.avatar = avatar
        self.organization = organization


class ApiUserUpdate(msrest.serialization.Model):
    """ApiUserUpdate.

    :ivar name:
    :vartype name: str
    :ivar username:
    :vartype username: str
    :ivar email:
    :vartype email: str
    :ivar avatar: URL of the user's avatar.
    :vartype avatar: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "username": {"key": "username", "type": "str"},
        "email": {"key": "email", "type": "str"},
        "avatar": {"key": "avatar", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        username: Optional[str] = None,
        email: Optional[str] = None,
        avatar: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword username:
        :paramtype username: str
        :keyword email:
        :paramtype email: str
        :keyword avatar: URL of the user's avatar.
        :paramtype avatar: str
        """
        super(ApiUserUpdate, self).__init__(**kwargs)
        self.name = name
        self.username = username
        self.email = email
        self.avatar = avatar


class ApiUserWithKey(msrest.serialization.Model):
    """ApiUserWithKey.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Uniquely identify a user.
    :vartype id: int
    :ivar name: Required.
    :vartype name: str
    :ivar username: Required.
    :vartype username: str
    :ivar email: Required.
    :vartype email: str
    :ivar avatar: Required. URL of the user's avatar.
    :vartype avatar: str
    :ivar organizations: Required.
    :vartype organizations: list[~affinda.models.ApiUserWithKeyOrganizationsItem]
    :ivar api_key: Required. Use this key to authenticate with the API.
    :vartype api_key: str
    :ivar api_key_last_chars: The last 4 characters of the API key.
    :vartype api_key_last_chars: str
    """

    _validation = {
        "id": {"required": True, "minimum": 1},
        "name": {"required": True},
        "username": {"required": True},
        "email": {"required": True},
        "avatar": {"required": True},
        "organizations": {"required": True},
        "api_key": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "name": {"key": "name", "type": "str"},
        "username": {"key": "username", "type": "str"},
        "email": {"key": "email", "type": "str"},
        "avatar": {"key": "avatar", "type": "str"},
        "organizations": {"key": "organizations", "type": "[ApiUserWithKeyOrganizationsItem]"},
        "api_key": {"key": "apiKey", "type": "str"},
        "api_key_last_chars": {"key": "apiKeyLastChars", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        name: str,
        username: str,
        email: str,
        avatar: str,
        organizations: List["_models.ApiUserWithKeyOrganizationsItem"],
        api_key: str,
        api_key_last_chars: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword id: Required. Uniquely identify a user.
        :paramtype id: int
        :keyword name: Required.
        :paramtype name: str
        :keyword username: Required.
        :paramtype username: str
        :keyword email: Required.
        :paramtype email: str
        :keyword avatar: Required. URL of the user's avatar.
        :paramtype avatar: str
        :keyword organizations: Required.
        :paramtype organizations: list[~affinda.models.ApiUserWithKeyOrganizationsItem]
        :keyword api_key: Required. Use this key to authenticate with the API.
        :paramtype api_key: str
        :keyword api_key_last_chars: The last 4 characters of the API key.
        :paramtype api_key_last_chars: str
        """
        super(ApiUserWithKey, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.username = username
        self.email = email
        self.avatar = avatar
        self.organizations = organizations
        self.api_key = api_key
        self.api_key_last_chars = api_key_last_chars


class ApiUserWithKeyOrganizationsItem(msrest.serialization.Model):
    """ApiUserWithKeyOrganizationsItem.

    All required parameters must be populated in order to send to Azure.

    :ivar identifier: Required. Uniquely identify an organization.
    :vartype identifier: str
    :ivar name: Required.
    :vartype name: str
    """

    _validation = {
        "identifier": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, identifier: str, name: str, **kwargs):
        """
        :keyword identifier: Required. Uniquely identify an organization.
        :paramtype identifier: str
        :keyword name: Required.
        :paramtype name: str
        """
        super(ApiUserWithKeyOrganizationsItem, self).__init__(**kwargs)
        self.identifier = identifier
        self.name = name


class ApiUserWithoutKey(msrest.serialization.Model):
    """ApiUserWithoutKey.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Uniquely identify a user.
    :vartype id: int
    :ivar name: Required.
    :vartype name: str
    :ivar username: Required.
    :vartype username: str
    :ivar email: Required.
    :vartype email: str
    :ivar avatar: Required. URL of the user's avatar.
    :vartype avatar: str
    :ivar organizations: Required.
    :vartype organizations: list[~affinda.models.ApiUserWithoutKeyOrganizationsItem]
    :ivar api_key_last_chars: The last 4 characters of the API key.
    :vartype api_key_last_chars: str
    """

    _validation = {
        "id": {"required": True, "minimum": 1},
        "name": {"required": True},
        "username": {"required": True},
        "email": {"required": True},
        "avatar": {"required": True},
        "organizations": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "name": {"key": "name", "type": "str"},
        "username": {"key": "username", "type": "str"},
        "email": {"key": "email", "type": "str"},
        "avatar": {"key": "avatar", "type": "str"},
        "organizations": {"key": "organizations", "type": "[ApiUserWithoutKeyOrganizationsItem]"},
        "api_key_last_chars": {"key": "apiKeyLastChars", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        name: str,
        username: str,
        email: str,
        avatar: str,
        organizations: List["_models.ApiUserWithoutKeyOrganizationsItem"],
        api_key_last_chars: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword id: Required. Uniquely identify a user.
        :paramtype id: int
        :keyword name: Required.
        :paramtype name: str
        :keyword username: Required.
        :paramtype username: str
        :keyword email: Required.
        :paramtype email: str
        :keyword avatar: Required. URL of the user's avatar.
        :paramtype avatar: str
        :keyword organizations: Required.
        :paramtype organizations: list[~affinda.models.ApiUserWithoutKeyOrganizationsItem]
        :keyword api_key_last_chars: The last 4 characters of the API key.
        :paramtype api_key_last_chars: str
        """
        super(ApiUserWithoutKey, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.username = username
        self.email = email
        self.avatar = avatar
        self.organizations = organizations
        self.api_key_last_chars = api_key_last_chars


class ApiUserWithoutKeyOrganizationsItem(msrest.serialization.Model):
    """ApiUserWithoutKeyOrganizationsItem.

    All required parameters must be populated in order to send to Azure.

    :ivar identifier: Required. Uniquely identify an organization.
    :vartype identifier: str
    :ivar name: Required.
    :vartype name: str
    """

    _validation = {
        "identifier": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, identifier: str, name: str, **kwargs):
        """
        :keyword identifier: Required. Uniquely identify an organization.
        :paramtype identifier: str
        :keyword name: Required.
        :paramtype name: str
        """
        super(ApiUserWithoutKeyOrganizationsItem, self).__init__(**kwargs)
        self.identifier = identifier
        self.name = name


class BaseExtractor(msrest.serialization.Model):
    """BaseExtractor.

    All required parameters must be populated in order to send to Azure.

    :ivar identifier: Required. Uniquely identify an extractor.
    :vartype identifier: str
    :ivar name: Required.
    :vartype name: str
    :ivar name_plural: Required.
    :vartype name_plural: str
    :ivar validatable: Required.
    :vartype validatable: bool
    :ivar is_custom:
    :vartype is_custom: bool
    :ivar created_dt:
    :vartype created_dt: ~datetime.datetime
    """

    _validation = {
        "identifier": {"required": True},
        "name": {"required": True},
        "name_plural": {"required": True},
        "validatable": {"required": True},
    }

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "name_plural": {"key": "namePlural", "type": "str"},
        "validatable": {"key": "validatable", "type": "bool"},
        "is_custom": {"key": "isCustom", "type": "bool"},
        "created_dt": {"key": "createdDt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        identifier: str,
        name: str,
        name_plural: str,
        validatable: bool,
        is_custom: Optional[bool] = None,
        created_dt: Optional[datetime.datetime] = None,
        **kwargs,
    ):
        """
        :keyword identifier: Required. Uniquely identify an extractor.
        :paramtype identifier: str
        :keyword name: Required.
        :paramtype name: str
        :keyword name_plural: Required.
        :paramtype name_plural: str
        :keyword validatable: Required.
        :paramtype validatable: bool
        :keyword is_custom:
        :paramtype is_custom: bool
        :keyword created_dt:
        :paramtype created_dt: ~datetime.datetime
        """
        super(BaseExtractor, self).__init__(**kwargs)
        self.identifier = identifier
        self.name = name
        self.name_plural = name_plural
        self.validatable = validatable
        self.is_custom = is_custom
        self.created_dt = created_dt


class BatchAddTagRequest(msrest.serialization.Model):
    """BatchAddTagRequest.

    :ivar identifiers: List of documents to tag.
    :vartype identifiers: list[str]
    :ivar tag: The tag's ID.
    :vartype tag: int
    """

    _attribute_map = {
        "identifiers": {"key": "identifiers", "type": "[str]"},
        "tag": {"key": "tag", "type": "int"},
    }

    def __init__(
        self, *, identifiers: Optional[List[str]] = None, tag: Optional[int] = None, **kwargs
    ):
        """
        :keyword identifiers: List of documents to tag.
        :paramtype identifiers: list[str]
        :keyword tag: The tag's ID.
        :paramtype tag: int
        """
        super(BatchAddTagRequest, self).__init__(**kwargs)
        self.identifiers = identifiers
        self.tag = tag


class BatchDeleteAnnotationsResponse(msrest.serialization.Model):
    """BatchDeleteAnnotationsResponse.

    :ivar validation_results: The validation results created, changed or deleted as a result of
     deleting the annotations.
    :vartype validation_results: any
    """

    _attribute_map = {
        "validation_results": {"key": "validationResults", "type": "object"},
    }

    def __init__(self, *, validation_results: Optional[Any] = None, **kwargs):
        """
        :keyword validation_results: The validation results created, changed or deleted as a result of
         deleting the annotations.
        :paramtype validation_results: any
        """
        super(BatchDeleteAnnotationsResponse, self).__init__(**kwargs)
        self.validation_results = validation_results


class BatchDeleteValidationResultsRequest(msrest.serialization.Model):
    """BatchDeleteValidationResultsRequest.

    All required parameters must be populated in order to send to Azure.

    :ivar ids: Required. List of validation result IDs to delete.
    :vartype ids: list[int]
    """

    _validation = {
        "ids": {"required": True},
    }

    _attribute_map = {
        "ids": {"key": "ids", "type": "[int]"},
    }

    def __init__(self, *, ids: List[int], **kwargs):
        """
        :keyword ids: Required. List of validation result IDs to delete.
        :paramtype ids: list[int]
        """
        super(BatchDeleteValidationResultsRequest, self).__init__(**kwargs)
        self.ids = ids


class BatchRemoveTagRequest(msrest.serialization.Model):
    """BatchRemoveTagRequest.

    :ivar identifiers: List of documents to remove tag from.
    :vartype identifiers: list[str]
    :ivar tag: The tag's ID.
    :vartype tag: int
    """

    _attribute_map = {
        "identifiers": {"key": "identifiers", "type": "[str]"},
        "tag": {"key": "tag", "type": "int"},
    }

    def __init__(
        self, *, identifiers: Optional[List[str]] = None, tag: Optional[int] = None, **kwargs
    ):
        """
        :keyword identifiers: List of documents to remove tag from.
        :paramtype identifiers: list[str]
        :keyword tag: The tag's ID.
        :paramtype tag: int
        """
        super(BatchRemoveTagRequest, self).__init__(**kwargs)
        self.identifiers = identifiers
        self.tag = tag


class ChangedValidationResults(msrest.serialization.Model):
    """ChangedValidationResults.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar created: List of validation results created during this operation.
    :vartype created: list[~affinda.models.ValidationResult]
    :ivar updated: List of validation results updated during this operation.
    :vartype updated: list[~affinda.models.ValidationResult]
    :ivar deleted: List of validation results deleted during this operation.
    :vartype deleted: list[~affinda.models.ValidationResult]
    """

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "created": {"key": "created", "type": "[ValidationResult]"},
        "updated": {"key": "updated", "type": "[ValidationResult]"},
        "deleted": {"key": "deleted", "type": "[ValidationResult]"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        created: Optional[List["_models.ValidationResult"]] = None,
        updated: Optional[List["_models.ValidationResult"]] = None,
        deleted: Optional[List["_models.ValidationResult"]] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword created: List of validation results created during this operation.
        :paramtype created: list[~affinda.models.ValidationResult]
        :keyword updated: List of validation results updated during this operation.
        :paramtype updated: list[~affinda.models.ValidationResult]
        :keyword deleted: List of validation results deleted during this operation.
        :paramtype deleted: list[~affinda.models.ValidationResult]
        """
        super(ChangedValidationResults, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.created = created
        self.updated = updated
        self.deleted = deleted


class Collection(msrest.serialization.Model):
    """Collection.

    All required parameters must be populated in order to send to Azure.

    :ivar identifier: Required. Uniquely identify a collection.
    :vartype identifier: str
    :ivar name:
    :vartype name: str
    :ivar workspace:
    :vartype workspace: ~affinda.models.CollectionWorkspace
    :ivar extractor:
    :vartype extractor: ~affinda.models.Extractor
    :ivar auto_validation_threshold:
    :vartype auto_validation_threshold: float
    :ivar enable_auto_validation_threshold:
    :vartype enable_auto_validation_threshold: bool
    :ivar auto_validate_if_validation_rules_pass:
    :vartype auto_validate_if_validation_rules_pass: bool
    :ivar fields:
    :vartype fields: list[~affinda.models.FieldGroup]
    :ivar fields_layout:
    :vartype fields_layout: ~affinda.models.FieldsLayout
    :ivar fields_configured:
    :vartype fields_configured: bool
    :ivar date_format_preference: Known values are: "DMY", "MDY", "YMD".
    :vartype date_format_preference: str or ~affinda.models.CollectionDateFormatPreference
    :ivar date_format_from_document: Predict the date format from any dates in the document that is
     not ambiguous.
    :vartype date_format_from_document: bool
    :ivar extractor_config: Extra configurations specific to an extractor.
    :vartype extractor_config: ~affinda.models.ExtractorConfig
    :ivar unvalidated_docs_count: Number of unvalidated documents in the collection.
    :vartype unvalidated_docs_count: int
    :ivar confirmed_docs_count: Number of validated documents in the collection.
    :vartype confirmed_docs_count: int
    :ivar ingest_email: When you send email to this address, any document attached in the body will
     be uploaded to this collection.
    :vartype ingest_email: str
    :ivar tailored_extractor_requested: Whether a tailored extractor has been requested for this
     collection.
    :vartype tailored_extractor_requested: bool
    :ivar allow_openai: Whether to allow OpenAI API to be used to assist in creating a model for
     this collection.
    :vartype allow_openai: bool
    :ivar trains_extractor: Whether this collection feeds documents into the extractor's training
     queue. This setting can only be toggled for custom extractors.
    :vartype trains_extractor: bool
    :ivar disable_confirmation_if_validation_rules_fail: If True, users cannot validate documents
     with missing mandatory fields, or failing validation rules.
    :vartype disable_confirmation_if_validation_rules_fail: bool
    :ivar auto_refresh_validation_results: If True, validation results are refreshed whenever
     annotations are changed.
    :vartype auto_refresh_validation_results: bool
    """

    _validation = {
        "identifier": {"required": True},
        "unvalidated_docs_count": {"minimum": 0},
        "confirmed_docs_count": {"minimum": 0},
    }

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "workspace": {"key": "workspace", "type": "CollectionWorkspace"},
        "extractor": {"key": "extractor", "type": "Extractor"},
        "auto_validation_threshold": {"key": "autoValidationThreshold", "type": "float"},
        "enable_auto_validation_threshold": {
            "key": "enableAutoValidationThreshold",
            "type": "bool",
        },
        "auto_validate_if_validation_rules_pass": {
            "key": "autoValidateIfValidationRulesPass",
            "type": "bool",
        },
        "fields": {"key": "fields", "type": "[FieldGroup]"},
        "fields_layout": {"key": "fieldsLayout", "type": "FieldsLayout"},
        "fields_configured": {"key": "fieldsConfigured", "type": "bool"},
        "date_format_preference": {"key": "dateFormatPreference", "type": "str"},
        "date_format_from_document": {"key": "dateFormatFromDocument", "type": "bool"},
        "extractor_config": {"key": "extractorConfig", "type": "ExtractorConfig"},
        "unvalidated_docs_count": {"key": "unvalidatedDocsCount", "type": "int"},
        "confirmed_docs_count": {"key": "confirmedDocsCount", "type": "int"},
        "ingest_email": {"key": "ingestEmail", "type": "str"},
        "tailored_extractor_requested": {"key": "tailoredExtractorRequested", "type": "bool"},
        "allow_openai": {"key": "allowOpenai", "type": "bool"},
        "trains_extractor": {"key": "trainsExtractor", "type": "bool"},
        "disable_confirmation_if_validation_rules_fail": {
            "key": "disableConfirmationIfValidationRulesFail",
            "type": "bool",
        },
        "auto_refresh_validation_results": {"key": "autoRefreshValidationResults", "type": "bool"},
    }

    def __init__(
        self,
        *,
        identifier: str,
        name: Optional[str] = None,
        workspace: Optional["_models.CollectionWorkspace"] = None,
        extractor: Optional["_models.Extractor"] = None,
        auto_validation_threshold: Optional[float] = None,
        enable_auto_validation_threshold: Optional[bool] = False,
        auto_validate_if_validation_rules_pass: Optional[bool] = False,
        fields: Optional[List["_models.FieldGroup"]] = None,
        fields_layout: Optional["_models.FieldsLayout"] = None,
        fields_configured: Optional[bool] = None,
        date_format_preference: Optional[
            Union[str, "_models.CollectionDateFormatPreference"]
        ] = None,
        date_format_from_document: Optional[bool] = None,
        extractor_config: Optional["_models.ExtractorConfig"] = None,
        unvalidated_docs_count: Optional[int] = None,
        confirmed_docs_count: Optional[int] = None,
        ingest_email: Optional[str] = None,
        tailored_extractor_requested: Optional[bool] = None,
        allow_openai: Optional[bool] = False,
        trains_extractor: Optional[bool] = None,
        disable_confirmation_if_validation_rules_fail: Optional[bool] = False,
        auto_refresh_validation_results: Optional[bool] = True,
        **kwargs,
    ):
        """
        :keyword identifier: Required. Uniquely identify a collection.
        :paramtype identifier: str
        :keyword name:
        :paramtype name: str
        :keyword workspace:
        :paramtype workspace: ~affinda.models.CollectionWorkspace
        :keyword extractor:
        :paramtype extractor: ~affinda.models.Extractor
        :keyword auto_validation_threshold:
        :paramtype auto_validation_threshold: float
        :keyword enable_auto_validation_threshold:
        :paramtype enable_auto_validation_threshold: bool
        :keyword auto_validate_if_validation_rules_pass:
        :paramtype auto_validate_if_validation_rules_pass: bool
        :keyword fields:
        :paramtype fields: list[~affinda.models.FieldGroup]
        :keyword fields_layout:
        :paramtype fields_layout: ~affinda.models.FieldsLayout
        :keyword fields_configured:
        :paramtype fields_configured: bool
        :keyword date_format_preference: Known values are: "DMY", "MDY", "YMD".
        :paramtype date_format_preference: str or ~affinda.models.CollectionDateFormatPreference
        :keyword date_format_from_document: Predict the date format from any dates in the document that
         is not ambiguous.
        :paramtype date_format_from_document: bool
        :keyword extractor_config: Extra configurations specific to an extractor.
        :paramtype extractor_config: ~affinda.models.ExtractorConfig
        :keyword unvalidated_docs_count: Number of unvalidated documents in the collection.
        :paramtype unvalidated_docs_count: int
        :keyword confirmed_docs_count: Number of validated documents in the collection.
        :paramtype confirmed_docs_count: int
        :keyword ingest_email: When you send email to this address, any document attached in the body
         will be uploaded to this collection.
        :paramtype ingest_email: str
        :keyword tailored_extractor_requested: Whether a tailored extractor has been requested for this
         collection.
        :paramtype tailored_extractor_requested: bool
        :keyword allow_openai: Whether to allow OpenAI API to be used to assist in creating a model for
         this collection.
        :paramtype allow_openai: bool
        :keyword trains_extractor: Whether this collection feeds documents into the extractor's
         training queue. This setting can only be toggled for custom extractors.
        :paramtype trains_extractor: bool
        :keyword disable_confirmation_if_validation_rules_fail: If True, users cannot validate
         documents with missing mandatory fields, or failing validation rules.
        :paramtype disable_confirmation_if_validation_rules_fail: bool
        :keyword auto_refresh_validation_results: If True, validation results are refreshed whenever
         annotations are changed.
        :paramtype auto_refresh_validation_results: bool
        """
        super(Collection, self).__init__(**kwargs)
        self.identifier = identifier
        self.name = name
        self.workspace = workspace
        self.extractor = extractor
        self.auto_validation_threshold = auto_validation_threshold
        self.enable_auto_validation_threshold = enable_auto_validation_threshold
        self.auto_validate_if_validation_rules_pass = auto_validate_if_validation_rules_pass
        self.fields = fields
        self.fields_layout = fields_layout
        self.fields_configured = fields_configured
        self.date_format_preference = date_format_preference
        self.date_format_from_document = date_format_from_document
        self.extractor_config = extractor_config
        self.unvalidated_docs_count = unvalidated_docs_count
        self.confirmed_docs_count = confirmed_docs_count
        self.ingest_email = ingest_email
        self.tailored_extractor_requested = tailored_extractor_requested
        self.allow_openai = allow_openai
        self.trains_extractor = trains_extractor
        self.disable_confirmation_if_validation_rules_fail = (
            disable_confirmation_if_validation_rules_fail
        )
        self.auto_refresh_validation_results = auto_refresh_validation_results


class CollectionCreate(msrest.serialization.Model):
    """CollectionCreate.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required.
    :vartype name: str
    :ivar workspace: Required. Uniquely identify a workspace.
    :vartype workspace: str
    :ivar extractor: Uniquely identify an extractor. Required if you are not a super user.
    :vartype extractor: str
    :ivar base_extractor: Not applicable, please leave empty. This feature is reserved for super
     user.
    :vartype base_extractor: str
    :ivar auto_validation_threshold:
    :vartype auto_validation_threshold: float
    :ivar enable_auto_validation_threshold:
    :vartype enable_auto_validation_threshold: bool
    :ivar fields:
    :vartype fields: list[~affinda.models.FieldGroup]
    :ivar fields_layout:
    :vartype fields_layout: ~affinda.models.FieldsLayout
    :ivar date_format_preference: Known values are: "DMY", "MDY", "YMD".
    :vartype date_format_preference: str or ~affinda.models.DateFormatPreference
    :ivar date_format_from_document: Predict the date format from any dates in the document that is
     not ambiguous.
    :vartype date_format_from_document: bool
    :ivar extractor_config: Extra configurations specific to an extractor.
    :vartype extractor_config: ~affinda.models.ExtractorConfig
    :ivar allow_openai: Whether to allow OpenAI API to be used to assist in creating a model for
     this collection.
    :vartype allow_openai: bool
    :ivar trains_extractor: Whether this collection feeds documents into the extractor's training
     queue. This setting can only be toggled for custom extractors.
    :vartype trains_extractor: bool
    :ivar disable_confirmation_if_validation_rules_fail: If True, users cannot validate documents
     with missing mandatory fields, or failing validation rules.
    :vartype disable_confirmation_if_validation_rules_fail: bool
    """

    _validation = {
        "name": {"required": True},
        "workspace": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "workspace": {"key": "workspace", "type": "str"},
        "extractor": {"key": "extractor", "type": "str"},
        "base_extractor": {"key": "baseExtractor", "type": "str"},
        "auto_validation_threshold": {"key": "autoValidationThreshold", "type": "float"},
        "enable_auto_validation_threshold": {
            "key": "enableAutoValidationThreshold",
            "type": "bool",
        },
        "fields": {"key": "fields", "type": "[FieldGroup]"},
        "fields_layout": {"key": "fieldsLayout", "type": "FieldsLayout"},
        "date_format_preference": {"key": "dateFormatPreference", "type": "str"},
        "date_format_from_document": {"key": "dateFormatFromDocument", "type": "bool"},
        "extractor_config": {"key": "extractorConfig", "type": "ExtractorConfig"},
        "allow_openai": {"key": "allowOpenai", "type": "bool"},
        "trains_extractor": {"key": "trainsExtractor", "type": "bool"},
        "disable_confirmation_if_validation_rules_fail": {
            "key": "disableConfirmationIfValidationRulesFail",
            "type": "bool",
        },
    }

    def __init__(
        self,
        *,
        name: str,
        workspace: str,
        extractor: Optional[str] = None,
        base_extractor: Optional[str] = None,
        auto_validation_threshold: Optional[float] = None,
        enable_auto_validation_threshold: Optional[bool] = False,
        fields: Optional[List["_models.FieldGroup"]] = None,
        fields_layout: Optional["_models.FieldsLayout"] = None,
        date_format_preference: Optional[Union[str, "_models.DateFormatPreference"]] = None,
        date_format_from_document: Optional[bool] = None,
        extractor_config: Optional["_models.ExtractorConfig"] = None,
        allow_openai: Optional[bool] = False,
        trains_extractor: Optional[bool] = None,
        disable_confirmation_if_validation_rules_fail: Optional[bool] = False,
        **kwargs,
    ):
        """
        :keyword name: Required.
        :paramtype name: str
        :keyword workspace: Required. Uniquely identify a workspace.
        :paramtype workspace: str
        :keyword extractor: Uniquely identify an extractor. Required if you are not a super user.
        :paramtype extractor: str
        :keyword base_extractor: Not applicable, please leave empty. This feature is reserved for super
         user.
        :paramtype base_extractor: str
        :keyword auto_validation_threshold:
        :paramtype auto_validation_threshold: float
        :keyword enable_auto_validation_threshold:
        :paramtype enable_auto_validation_threshold: bool
        :keyword fields:
        :paramtype fields: list[~affinda.models.FieldGroup]
        :keyword fields_layout:
        :paramtype fields_layout: ~affinda.models.FieldsLayout
        :keyword date_format_preference: Known values are: "DMY", "MDY", "YMD".
        :paramtype date_format_preference: str or ~affinda.models.DateFormatPreference
        :keyword date_format_from_document: Predict the date format from any dates in the document that
         is not ambiguous.
        :paramtype date_format_from_document: bool
        :keyword extractor_config: Extra configurations specific to an extractor.
        :paramtype extractor_config: ~affinda.models.ExtractorConfig
        :keyword allow_openai: Whether to allow OpenAI API to be used to assist in creating a model for
         this collection.
        :paramtype allow_openai: bool
        :keyword trains_extractor: Whether this collection feeds documents into the extractor's
         training queue. This setting can only be toggled for custom extractors.
        :paramtype trains_extractor: bool
        :keyword disable_confirmation_if_validation_rules_fail: If True, users cannot validate
         documents with missing mandatory fields, or failing validation rules.
        :paramtype disable_confirmation_if_validation_rules_fail: bool
        """
        super(CollectionCreate, self).__init__(**kwargs)
        self.name = name
        self.workspace = workspace
        self.extractor = extractor
        self.base_extractor = base_extractor
        self.auto_validation_threshold = auto_validation_threshold
        self.enable_auto_validation_threshold = enable_auto_validation_threshold
        self.fields = fields
        self.fields_layout = fields_layout
        self.date_format_preference = date_format_preference
        self.date_format_from_document = date_format_from_document
        self.extractor_config = extractor_config
        self.allow_openai = allow_openai
        self.trains_extractor = trains_extractor
        self.disable_confirmation_if_validation_rules_fail = (
            disable_confirmation_if_validation_rules_fail
        )


class CollectionField(msrest.serialization.Model):
    """CollectionField.

    :ivar label:
    :vartype label: str
    :ivar field_type: The different data types of annotations. Known values are: "text", "integer",
     "float", "decimal", "date", "datetime", "daterange", "boolean", "enum", "location",
     "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language", "skill",
     "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
    :vartype field_type: str or ~affinda.models.AnnotationContentType
    :ivar mandatory:
    :vartype mandatory: bool
    :ivar show_dropdown:
    :vartype show_dropdown: bool
    :ivar display_enum_value: If true, both the value and the label for the enums will appear in
     the dropdown in the validation tool.
    :vartype display_enum_value: bool
    :ivar auto_validation_threshold: Threshold for auto validation. If null, uses the collection's
     autoValidationThreshold.
    :vartype auto_validation_threshold: float
    :ivar enable_auto_validation_threshold: If true, the autoValidationThreshold enable auto
     validation from the threshold from this field if specified, else from the collection.
    :vartype enable_auto_validation_threshold: bool
    :ivar data_source: Data source mapping identifier.
    :vartype data_source: str
    :ivar mapping: Defines how the data point is mapped to the data source.
    :vartype mapping: str
    :ivar display_raw_text: Defines how the data point is mapped to the data source.
    :vartype display_raw_text: str
    """

    _validation = {
        "auto_validation_threshold": {"maximum": 1, "minimum": 0},
    }

    _attribute_map = {
        "label": {"key": "label", "type": "str"},
        "field_type": {"key": "fieldType", "type": "str"},
        "mandatory": {"key": "mandatory", "type": "bool"},
        "show_dropdown": {"key": "showDropdown", "type": "bool"},
        "display_enum_value": {"key": "displayEnumValue", "type": "bool"},
        "auto_validation_threshold": {"key": "autoValidationThreshold", "type": "float"},
        "enable_auto_validation_threshold": {
            "key": "enableAutoValidationThreshold",
            "type": "bool",
        },
        "data_source": {"key": "dataSource", "type": "str"},
        "mapping": {"key": "mapping", "type": "str"},
        "display_raw_text": {"key": "displayRawText", "type": "str"},
    }

    def __init__(
        self,
        *,
        label: Optional[str] = None,
        field_type: Optional[Union[str, "_models.AnnotationContentType"]] = None,
        mandatory: Optional[bool] = None,
        show_dropdown: Optional[bool] = None,
        display_enum_value: Optional[bool] = None,
        auto_validation_threshold: Optional[float] = None,
        enable_auto_validation_threshold: Optional[bool] = None,
        data_source: Optional[str] = None,
        mapping: Optional[str] = None,
        display_raw_text: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword label:
        :paramtype label: str
        :keyword field_type: The different data types of annotations. Known values are: "text",
         "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum", "location",
         "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language", "skill",
         "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
        :paramtype field_type: str or ~affinda.models.AnnotationContentType
        :keyword mandatory:
        :paramtype mandatory: bool
        :keyword show_dropdown:
        :paramtype show_dropdown: bool
        :keyword display_enum_value: If true, both the value and the label for the enums will appear in
         the dropdown in the validation tool.
        :paramtype display_enum_value: bool
        :keyword auto_validation_threshold: Threshold for auto validation. If null, uses the
         collection's autoValidationThreshold.
        :paramtype auto_validation_threshold: float
        :keyword enable_auto_validation_threshold: If true, the autoValidationThreshold enable auto
         validation from the threshold from this field if specified, else from the collection.
        :paramtype enable_auto_validation_threshold: bool
        :keyword data_source: Data source mapping identifier.
        :paramtype data_source: str
        :keyword mapping: Defines how the data point is mapped to the data source.
        :paramtype mapping: str
        :keyword display_raw_text: Defines how the data point is mapped to the data source.
        :paramtype display_raw_text: str
        """
        super(CollectionField, self).__init__(**kwargs)
        self.label = label
        self.field_type = field_type
        self.mandatory = mandatory
        self.show_dropdown = show_dropdown
        self.display_enum_value = display_enum_value
        self.auto_validation_threshold = auto_validation_threshold
        self.enable_auto_validation_threshold = enable_auto_validation_threshold
        self.data_source = data_source
        self.mapping = mapping
        self.display_raw_text = display_raw_text


class CollectionUpdate(msrest.serialization.Model):
    """CollectionUpdate.

    :ivar name:
    :vartype name: str
    :ivar auto_validation_threshold:
    :vartype auto_validation_threshold: float
    :ivar enable_auto_validation_threshold:
    :vartype enable_auto_validation_threshold: bool
    :ivar fields:
    :vartype fields: list[~affinda.models.FieldGroup]
    :ivar fields_layout:
    :vartype fields_layout: ~affinda.models.FieldsLayout
    :ivar date_format_preference: Known values are: "DMY", "MDY", "YMD".
    :vartype date_format_preference: str or ~affinda.models.DateFormatPreference
    :ivar date_format_from_document: Predict the date format from any dates in the document that is
     not ambiguous.
    :vartype date_format_from_document: bool
    :ivar extractor_config: Extra configurations specific to an extractor.
    :vartype extractor_config: ~affinda.models.ExtractorConfig
    :ivar allow_openai: Whether to allow OpenAI API to be used to assist in creating a model for
     this collection.
    :vartype allow_openai: bool
    :ivar trains_extractor: Whether this collection feeds documents into the extractor's training
     queue. This setting can only be toggled for custom extractors.
    :vartype trains_extractor: bool
    :ivar disable_confirmation_if_validation_rules_fail: If True, users cannot validate documents
     with missing mandatory fields, or failing validation rules.
    :vartype disable_confirmation_if_validation_rules_fail: bool
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "auto_validation_threshold": {"key": "autoValidationThreshold", "type": "float"},
        "enable_auto_validation_threshold": {
            "key": "enableAutoValidationThreshold",
            "type": "bool",
        },
        "fields": {"key": "fields", "type": "[FieldGroup]"},
        "fields_layout": {"key": "fieldsLayout", "type": "FieldsLayout"},
        "date_format_preference": {"key": "dateFormatPreference", "type": "str"},
        "date_format_from_document": {"key": "dateFormatFromDocument", "type": "bool"},
        "extractor_config": {"key": "extractorConfig", "type": "ExtractorConfig"},
        "allow_openai": {"key": "allowOpenai", "type": "bool"},
        "trains_extractor": {"key": "trainsExtractor", "type": "bool"},
        "disable_confirmation_if_validation_rules_fail": {
            "key": "disableConfirmationIfValidationRulesFail",
            "type": "bool",
        },
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        auto_validation_threshold: Optional[float] = None,
        enable_auto_validation_threshold: Optional[bool] = False,
        fields: Optional[List["_models.FieldGroup"]] = None,
        fields_layout: Optional["_models.FieldsLayout"] = None,
        date_format_preference: Optional[Union[str, "_models.DateFormatPreference"]] = None,
        date_format_from_document: Optional[bool] = None,
        extractor_config: Optional["_models.ExtractorConfig"] = None,
        allow_openai: Optional[bool] = False,
        trains_extractor: Optional[bool] = None,
        disable_confirmation_if_validation_rules_fail: Optional[bool] = False,
        **kwargs,
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword auto_validation_threshold:
        :paramtype auto_validation_threshold: float
        :keyword enable_auto_validation_threshold:
        :paramtype enable_auto_validation_threshold: bool
        :keyword fields:
        :paramtype fields: list[~affinda.models.FieldGroup]
        :keyword fields_layout:
        :paramtype fields_layout: ~affinda.models.FieldsLayout
        :keyword date_format_preference: Known values are: "DMY", "MDY", "YMD".
        :paramtype date_format_preference: str or ~affinda.models.DateFormatPreference
        :keyword date_format_from_document: Predict the date format from any dates in the document that
         is not ambiguous.
        :paramtype date_format_from_document: bool
        :keyword extractor_config: Extra configurations specific to an extractor.
        :paramtype extractor_config: ~affinda.models.ExtractorConfig
        :keyword allow_openai: Whether to allow OpenAI API to be used to assist in creating a model for
         this collection.
        :paramtype allow_openai: bool
        :keyword trains_extractor: Whether this collection feeds documents into the extractor's
         training queue. This setting can only be toggled for custom extractors.
        :paramtype trains_extractor: bool
        :keyword disable_confirmation_if_validation_rules_fail: If True, users cannot validate
         documents with missing mandatory fields, or failing validation rules.
        :paramtype disable_confirmation_if_validation_rules_fail: bool
        """
        super(CollectionUpdate, self).__init__(**kwargs)
        self.name = name
        self.auto_validation_threshold = auto_validation_threshold
        self.enable_auto_validation_threshold = enable_auto_validation_threshold
        self.fields = fields
        self.fields_layout = fields_layout
        self.date_format_preference = date_format_preference
        self.date_format_from_document = date_format_from_document
        self.extractor_config = extractor_config
        self.allow_openai = allow_openai
        self.trains_extractor = trains_extractor
        self.disable_confirmation_if_validation_rules_fail = (
            disable_confirmation_if_validation_rules_fail
        )


class CollectionWorkspace(msrest.serialization.Model):
    """CollectionWorkspace.

    :ivar identifier: Uniquely identify a workspace.
    :vartype identifier: str
    :ivar organization:
    :vartype organization: ~affinda.models.Organization
    :ivar name:
    :vartype name: str
    """

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "organization": {"key": "organization", "type": "Organization"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        identifier: Optional[str] = None,
        organization: Optional["_models.Organization"] = None,
        name: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword identifier: Uniquely identify a workspace.
        :paramtype identifier: str
        :keyword organization:
        :paramtype organization: ~affinda.models.Organization
        :keyword name:
        :paramtype name: str
        """
        super(CollectionWorkspace, self).__init__(**kwargs)
        self.identifier = identifier
        self.organization = organization
        self.name = name


class Components159Ji55SchemasResumesearchdetailPropertiesLanguagesPropertiesValueItemsAllof1(
    msrest.serialization.Model
):
    """Components159Ji55SchemasResumesearchdetailPropertiesLanguagesPropertiesValueItemsAllof1.

    :ivar match:
    :vartype match: bool
    """

    _attribute_map = {
        "match": {"key": "match", "type": "bool"},
    }

    def __init__(self, *, match: Optional[bool] = None, **kwargs):
        """
        :keyword match:
        :paramtype match: bool
        """
        super(
            Components159Ji55SchemasResumesearchdetailPropertiesLanguagesPropertiesValueItemsAllof1,
            self,
        ).__init__(**kwargs)
        self.match = match


class Components1Kwk9B6SchemasThemeconfigPropertiesPalettePropertiesBackgroundOneof1(
    msrest.serialization.Model
):
    """Components1Kwk9B6SchemasThemeconfigPropertiesPalettePropertiesBackgroundOneof1.

    :ivar default:
    :vartype default: str
    :ivar paper:
    :vartype paper: str
    """

    _attribute_map = {
        "default": {"key": "default", "type": "str"},
        "paper": {"key": "paper", "type": "str"},
    }

    def __init__(self, *, default: Optional[str] = None, paper: Optional[str] = None, **kwargs):
        """
        :keyword default:
        :paramtype default: str
        :keyword paper:
        :paramtype paper: str
        """
        super(
            Components1Kwk9B6SchemasThemeconfigPropertiesPalettePropertiesBackgroundOneof1, self
        ).__init__(**kwargs)
        self.default = default
        self.paper = paper


class Components1TlnsonSchemasJobdescriptionsearchdetailPropertiesLocationPropertiesValueAllof1(
    msrest.serialization.Model
):
    """Components1TlnsonSchemasJobdescriptionsearchdetailPropertiesLocationPropertiesValueAllof1.

    :ivar match:
    :vartype match: bool
    """

    _attribute_map = {
        "match": {"key": "match", "type": "bool"},
    }

    def __init__(self, *, match: Optional[bool] = None, **kwargs):
        """
        :keyword match:
        :paramtype match: bool
        """
        super(
            Components1TlnsonSchemasJobdescriptionsearchdetailPropertiesLocationPropertiesValueAllof1,
            self,
        ).__init__(**kwargs)
        self.match = match


class Components1TryetgSchemasResumedataPropertiesWorkexperienceItemsPropertiesOccupationPropertiesClassification(
    msrest.serialization.Model
):
    """Components1TryetgSchemasResumedataPropertiesWorkexperienceItemsPropertiesOccupationPropertiesClassification.

    :ivar title: SOC2020 classification for this job title.
    :vartype title: str
    :ivar minor_group: SOC2020 minor group.
    :vartype minor_group: str
    :ivar sub_major_group: SOC2020 sub major group.
    :vartype sub_major_group: str
    :ivar major_group: SOC2020 major group.
    :vartype major_group: str
    :ivar soc_code: The 4 digit code representing the SOC2020 classification for this job title.
    :vartype soc_code: int
    :ivar minor_group_code: The 4 digit code representing the SOC2020 classification for this job
     title.
    :vartype minor_group_code: int
    :ivar sub_major_group_code: The 4 digit code representing the SOC2020 classification for this
     job title.
    :vartype sub_major_group_code: int
    :ivar major_group_code: The 4 digit code representing the SOC2020 classification for this job
     title.
    :vartype major_group_code: int
    """

    _validation = {
        "soc_code": {"maximum": 9999, "minimum": 1},
        "minor_group_code": {"maximum": 9999, "minimum": 1},
        "sub_major_group_code": {"maximum": 9999, "minimum": 1},
        "major_group_code": {"maximum": 9999, "minimum": 1},
    }

    _attribute_map = {
        "title": {"key": "title", "type": "str"},
        "minor_group": {"key": "minorGroup", "type": "str"},
        "sub_major_group": {"key": "subMajorGroup", "type": "str"},
        "major_group": {"key": "majorGroup", "type": "str"},
        "soc_code": {"key": "socCode", "type": "int"},
        "minor_group_code": {"key": "minorGroupCode", "type": "int"},
        "sub_major_group_code": {"key": "subMajorGroupCode", "type": "int"},
        "major_group_code": {"key": "majorGroupCode", "type": "int"},
    }

    def __init__(
        self,
        *,
        title: Optional[str] = None,
        minor_group: Optional[str] = None,
        sub_major_group: Optional[str] = None,
        major_group: Optional[str] = None,
        soc_code: Optional[int] = None,
        minor_group_code: Optional[int] = None,
        sub_major_group_code: Optional[int] = None,
        major_group_code: Optional[int] = None,
        **kwargs,
    ):
        """
        :keyword title: SOC2020 classification for this job title.
        :paramtype title: str
        :keyword minor_group: SOC2020 minor group.
        :paramtype minor_group: str
        :keyword sub_major_group: SOC2020 sub major group.
        :paramtype sub_major_group: str
        :keyword major_group: SOC2020 major group.
        :paramtype major_group: str
        :keyword soc_code: The 4 digit code representing the SOC2020 classification for this job title.
        :paramtype soc_code: int
        :keyword minor_group_code: The 4 digit code representing the SOC2020 classification for this
         job title.
        :paramtype minor_group_code: int
        :keyword sub_major_group_code: The 4 digit code representing the SOC2020 classification for
         this job title.
        :paramtype sub_major_group_code: int
        :keyword major_group_code: The 4 digit code representing the SOC2020 classification for this
         job title.
        :paramtype major_group_code: int
        """
        super(
            Components1TryetgSchemasResumedataPropertiesWorkexperienceItemsPropertiesOccupationPropertiesClassification,
            self,
        ).__init__(**kwargs)
        self.title = title
        self.minor_group = minor_group
        self.sub_major_group = sub_major_group
        self.major_group = major_group
        self.soc_code = soc_code
        self.minor_group_code = minor_group_code
        self.sub_major_group_code = sub_major_group_code
        self.major_group_code = major_group_code


class ComponentsH65QjbSchemasResumesearchdetailPropertiesSkillsPropertiesValueItemsAllof1(
    msrest.serialization.Model
):
    """ComponentsH65QjbSchemasResumesearchdetailPropertiesSkillsPropertiesValueItemsAllof1.

    :ivar match:
    :vartype match: bool
    """

    _attribute_map = {
        "match": {"key": "match", "type": "bool"},
    }

    def __init__(self, *, match: Optional[bool] = None, **kwargs):
        """
        :keyword match:
        :paramtype match: bool
        """
        super(
            ComponentsH65QjbSchemasResumesearchdetailPropertiesSkillsPropertiesValueItemsAllof1,
            self,
        ).__init__(**kwargs)
        self.match = match


class ComponentsN9ShogSchemasResumesearchdetailPropertiesLocationPropertiesValueAllof1(
    msrest.serialization.Model
):
    """ComponentsN9ShogSchemasResumesearchdetailPropertiesLocationPropertiesValueAllof1.

    :ivar match:
    :vartype match: bool
    """

    _attribute_map = {
        "match": {"key": "match", "type": "bool"},
    }

    def __init__(self, *, match: Optional[bool] = None, **kwargs):
        """
        :keyword match:
        :paramtype match: bool
        """
        super(
            ComponentsN9ShogSchemasResumesearchdetailPropertiesLocationPropertiesValueAllof1, self
        ).__init__(**kwargs)
        self.match = match


class ComponentsNqbw24SchemasCustomdatasearchscorecomponentAdditionalproperties(
    msrest.serialization.Model
):
    """ComponentsNqbw24SchemasCustomdatasearchscorecomponentAdditionalproperties.

    All required parameters must be populated in order to send to Azure.

    :ivar value:
    :vartype value: str
    :ivar label: Required.
    :vartype label: str
    :ivar score:
    :vartype score: float
    """

    _validation = {
        "label": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "score": {"key": "score", "type": "float"},
    }

    def __init__(
        self, *, label: str, value: Optional[str] = None, score: Optional[float] = None, **kwargs
    ):
        """
        :keyword value:
        :paramtype value: str
        :keyword label: Required.
        :paramtype label: str
        :keyword score:
        :paramtype score: float
        """
        super(
            ComponentsNqbw24SchemasCustomdatasearchscorecomponentAdditionalproperties, self
        ).__init__(**kwargs)
        self.value = value
        self.label = label
        self.score = score


class ComponentsSxu0N3SchemasResumesearchdetailPropertiesEducationPropertiesValueItemsAllof1(
    msrest.serialization.Model
):
    """ComponentsSxu0N3SchemasResumesearchdetailPropertiesEducationPropertiesValueItemsAllof1.

    :ivar match:
    :vartype match: bool
    """

    _attribute_map = {
        "match": {"key": "match", "type": "bool"},
    }

    def __init__(self, *, match: Optional[bool] = None, **kwargs):
        """
        :keyword match:
        :paramtype match: bool
        """
        super(
            ComponentsSxu0N3SchemasResumesearchdetailPropertiesEducationPropertiesValueItemsAllof1,
            self,
        ).__init__(**kwargs)
        self.match = match


class CurrencyCodeAnnotation(Annotation):
    """CurrencyCodeAnnotation.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required. Annotation's ID.
    :vartype id: int
    :ivar rectangle: Required. x/y coordinates for the rectangular bounding box containing the
     data.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required. x/y coordinates for the rectangles containing the data. An
     annotation can be contained within multiple rectangles.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar document: Required. Unique identifier for the document.
    :vartype document: str
    :ivar page_index: Required. The page number within the document, starting from 0.
    :vartype page_index: int
    :ivar raw: Required. Raw data extracted from the before any post-processing.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required. Indicates whether the data has been validated, either by a human
     using our validation tool or through auto-validation rules.
    :vartype is_verified: bool
    :ivar is_client_verified: Required. Indicates whether the data has been validated by a human.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required. Indicates whether the data has been auto-validated.
    :vartype is_auto_verified: bool
    :ivar data_point: Data point's identifier.
    :vartype data_point: str
    :ivar field: Field's identifier.
    :vartype field: str
    :ivar content_type: Required. The different data types of annotations. Known values are:
     "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
     "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
     "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
    :vartype content_type: str or ~affinda.models.AnnotationContentType
    :ivar parent: The parent annotation's ID.
    :vartype parent: int
    :ivar parsed:
    :vartype parsed: ~affinda.models.DataPointChoice
    """

    _validation = {
        "id": {"required": True, "minimum": 1},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "document": {"required": True},
        "page_index": {"required": True, "minimum": 0},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "document": {"key": "document", "type": "str"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "field": {"key": "field", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parent": {"key": "parent", "type": "int"},
        "parsed": {"key": "parsed", "type": "DataPointChoice"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        document: str,
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        content_type: Union[str, "_models.AnnotationContentType"],
        additional_properties: Optional[Dict[str, Any]] = None,
        data_point: Optional[str] = None,
        field: Optional[str] = None,
        parent: Optional[int] = None,
        parsed: Optional["_models.DataPointChoice"] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required. Annotation's ID.
        :paramtype id: int
        :keyword rectangle: Required. x/y coordinates for the rectangular bounding box containing the
         data.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required. x/y coordinates for the rectangles containing the data. An
         annotation can be contained within multiple rectangles.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword document: Required. Unique identifier for the document.
        :paramtype document: str
        :keyword page_index: Required. The page number within the document, starting from 0.
        :paramtype page_index: int
        :keyword raw: Required. Raw data extracted from the before any post-processing.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required. Indicates whether the data has been validated, either by a
         human using our validation tool or through auto-validation rules.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required. Indicates whether the data has been validated by a
         human.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required. Indicates whether the data has been auto-validated.
        :paramtype is_auto_verified: bool
        :keyword data_point: Data point's identifier.
        :paramtype data_point: str
        :keyword field: Field's identifier.
        :paramtype field: str
        :keyword content_type: Required. The different data types of annotations. Known values are:
         "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
         "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
         "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
        :paramtype content_type: str or ~affinda.models.AnnotationContentType
        :keyword parent: The parent annotation's ID.
        :paramtype parent: int
        :keyword parsed:
        :paramtype parsed: ~affinda.models.DataPointChoice
        """
        super(CurrencyCodeAnnotation, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            document=document,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            field=field,
            content_type=content_type,
            parent=parent,
            **kwargs,
        )
        self.parsed = parsed


class CustomFieldConfig(msrest.serialization.Model):
    """CustomFieldConfig.

    All required parameters must be populated in order to send to Azure.

    :ivar data_point: Required. Data point identifier.
    :vartype data_point: str
    :ivar weight: Required.
    :vartype weight: float
    """

    _validation = {
        "data_point": {"required": True},
        "weight": {"required": True, "maximum": 1, "minimum": 0},
    }

    _attribute_map = {
        "data_point": {"key": "dataPoint", "type": "str"},
        "weight": {"key": "weight", "type": "float"},
    }

    def __init__(self, *, data_point: str, weight: float = 0.5, **kwargs):
        """
        :keyword data_point: Required. Data point identifier.
        :paramtype data_point: str
        :keyword weight: Required.
        :paramtype weight: float
        """
        super(CustomFieldConfig, self).__init__(**kwargs)
        self.data_point = data_point
        self.weight = weight


class DataField(msrest.serialization.Model):
    """DataField.

    All required parameters must be populated in order to send to Azure.

    :ivar category_label: The label of the category that this field will be put into. If not
     provided, the field will be put into the default category. If no category exists with the
     specified label, a new category will be created.
    :vartype category_label: str
    :ivar field: Required. The field to be created.
    :vartype field: ~affinda.models.DataFieldField
    :ivar data_point: Required. The data point to be created for this field. If a data point with
     the same slug and collection already exists, it will be reused.
    :vartype data_point: ~affinda.models.DataFieldDataPoint
    """

    _validation = {
        "field": {"required": True},
        "data_point": {"required": True},
    }

    _attribute_map = {
        "category_label": {"key": "categoryLabel", "type": "str"},
        "field": {"key": "field", "type": "DataFieldField"},
        "data_point": {"key": "dataPoint", "type": "DataFieldDataPoint"},
    }

    def __init__(
        self,
        *,
        field: "_models.DataFieldField",
        data_point: "_models.DataFieldDataPoint",
        category_label: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword category_label: The label of the category that this field will be put into. If not
         provided, the field will be put into the default category. If no category exists with the
         specified label, a new category will be created.
        :paramtype category_label: str
        :keyword field: Required. The field to be created.
        :paramtype field: ~affinda.models.DataFieldField
        :keyword data_point: Required. The data point to be created for this field. If a data point
         with the same slug and collection already exists, it will be reused.
        :paramtype data_point: ~affinda.models.DataFieldDataPoint
        """
        super(DataField, self).__init__(**kwargs)
        self.category_label = category_label
        self.field = field
        self.data_point = data_point


class DataFieldCreate(msrest.serialization.Model):
    """DataFieldCreate.

    All required parameters must be populated in order to send to Azure.

    :ivar category_label: The label of the category that this field will be put into. If not
     provided, the field will be put into the default category. If no category exists with the
     specified label, a new category will be created.
    :vartype category_label: str
    :ivar field: Required. The field to be created.
    :vartype field: ~affinda.models.DataFieldCreateField
    :ivar data_point: Required. The data point to be created for this field. If a data point with
     the same slug and collection already exists, it will be reused.
    :vartype data_point: ~affinda.models.DataFieldCreateDataPoint
    """

    _validation = {
        "field": {"required": True},
        "data_point": {"required": True},
    }

    _attribute_map = {
        "category_label": {"key": "categoryLabel", "type": "str"},
        "field": {"key": "field", "type": "DataFieldCreateField"},
        "data_point": {"key": "dataPoint", "type": "DataFieldCreateDataPoint"},
    }

    def __init__(
        self,
        *,
        field: "_models.DataFieldCreateField",
        data_point: "_models.DataFieldCreateDataPoint",
        category_label: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword category_label: The label of the category that this field will be put into. If not
         provided, the field will be put into the default category. If no category exists with the
         specified label, a new category will be created.
        :paramtype category_label: str
        :keyword field: Required. The field to be created.
        :paramtype field: ~affinda.models.DataFieldCreateField
        :keyword data_point: Required. The data point to be created for this field. If a data point
         with the same slug and collection already exists, it will be reused.
        :paramtype data_point: ~affinda.models.DataFieldCreateDataPoint
        """
        super(DataFieldCreate, self).__init__(**kwargs)
        self.category_label = category_label
        self.field = field
        self.data_point = data_point


class DataFieldCreateDataPoint(msrest.serialization.Model):
    """The data point to be created for this field. If a data point with the same slug and collection already exists, it will be reused.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. Name of the data point.
    :vartype name: str
    :ivar slug: Required. A camelCase string that will be used as the key in the API response.
    :vartype slug: str
    :ivar description:
    :vartype description: str
    :ivar type: Required. The different data types of annotations. Known values are: "text",
     "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum", "location",
     "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language", "skill",
     "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
    :vartype type: str or ~affinda.models.AnnotationContentType
    :ivar multiple:
    :vartype multiple: bool
    :ivar no_rect:
    :vartype no_rect: bool
    :ivar parent: The identifier of the parent data point if applicable.
    :vartype parent: str
    :ivar manual_entry: If true, the model will not be used to predict this data point. Instead,
     the user will be able to manually enter the value in the validation tool.
    :vartype manual_entry: bool
    :ivar mapping_data_source: If populated, the model will learn to predict this field using the
     data source, rather than relying on fuzzy string matching.
    :vartype mapping_data_source: str
    """

    _validation = {
        "name": {"required": True},
        "slug": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "slug": {"key": "slug", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "multiple": {"key": "multiple", "type": "bool"},
        "no_rect": {"key": "noRect", "type": "bool"},
        "parent": {"key": "parent", "type": "str"},
        "manual_entry": {"key": "manualEntry", "type": "bool"},
        "mapping_data_source": {"key": "mappingDataSource", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        slug: str,
        type: Union[str, "_models.AnnotationContentType"],
        description: Optional[str] = None,
        multiple: Optional[bool] = None,
        no_rect: Optional[bool] = None,
        parent: Optional[str] = None,
        manual_entry: Optional[bool] = None,
        mapping_data_source: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword name: Required. Name of the data point.
        :paramtype name: str
        :keyword slug: Required. A camelCase string that will be used as the key in the API response.
        :paramtype slug: str
        :keyword description:
        :paramtype description: str
        :keyword type: Required. The different data types of annotations. Known values are: "text",
         "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum", "location",
         "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language", "skill",
         "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
        :paramtype type: str or ~affinda.models.AnnotationContentType
        :keyword multiple:
        :paramtype multiple: bool
        :keyword no_rect:
        :paramtype no_rect: bool
        :keyword parent: The identifier of the parent data point if applicable.
        :paramtype parent: str
        :keyword manual_entry: If true, the model will not be used to predict this data point. Instead,
         the user will be able to manually enter the value in the validation tool.
        :paramtype manual_entry: bool
        :keyword mapping_data_source: If populated, the model will learn to predict this field using
         the data source, rather than relying on fuzzy string matching.
        :paramtype mapping_data_source: str
        """
        super(DataFieldCreateDataPoint, self).__init__(**kwargs)
        self.name = name
        self.slug = slug
        self.description = description
        self.type = type
        self.multiple = multiple
        self.no_rect = no_rect
        self.parent = parent
        self.manual_entry = manual_entry
        self.mapping_data_source = mapping_data_source


class DataFieldCreateField(msrest.serialization.Model):
    """The field to be created.

    All required parameters must be populated in order to send to Azure.

    :ivar label: Required.
    :vartype label: str
    :ivar field_type: The different data types of annotations. Known values are: "text", "integer",
     "float", "decimal", "date", "datetime", "daterange", "boolean", "enum", "location",
     "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language", "skill",
     "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
    :vartype field_type: str or ~affinda.models.AnnotationContentType
    :ivar mandatory:
    :vartype mandatory: bool
    :ivar show_dropdown:
    :vartype show_dropdown: bool
    :ivar display_enum_value: If true, both the value and the label for the enums will appear in
     the dropdown in the validation tool.
    :vartype display_enum_value: bool
    :ivar auto_validation_threshold: Threshold for auto validation. If null, uses the collection's
     autoValidationThreshold.
    :vartype auto_validation_threshold: float
    :ivar enable_auto_validation_threshold: If true, the autoValidationThreshold enable auto
     validation from the threshold from this field if specified, else from the collection.
    :vartype enable_auto_validation_threshold: bool
    :ivar data_source: Data source mapping identifier.
    :vartype data_source: str
    :ivar mapping: Defines how the data point is mapped to the data source.
    :vartype mapping: str
    :ivar display_raw_text: If true, then the validation tool will show the user the raw text found
     on the page, not the value that has been parsed to a specific type.
    :vartype display_raw_text: bool
    """

    _validation = {
        "label": {"required": True},
        "auto_validation_threshold": {"maximum": 1, "minimum": 0},
    }

    _attribute_map = {
        "label": {"key": "label", "type": "str"},
        "field_type": {"key": "fieldType", "type": "str"},
        "mandatory": {"key": "mandatory", "type": "bool"},
        "show_dropdown": {"key": "showDropdown", "type": "bool"},
        "display_enum_value": {"key": "displayEnumValue", "type": "bool"},
        "auto_validation_threshold": {"key": "autoValidationThreshold", "type": "float"},
        "enable_auto_validation_threshold": {
            "key": "enableAutoValidationThreshold",
            "type": "bool",
        },
        "data_source": {"key": "dataSource", "type": "str"},
        "mapping": {"key": "mapping", "type": "str"},
        "display_raw_text": {"key": "displayRawText", "type": "bool"},
    }

    def __init__(
        self,
        *,
        label: str,
        field_type: Optional[Union[str, "_models.AnnotationContentType"]] = None,
        mandatory: Optional[bool] = None,
        show_dropdown: Optional[bool] = None,
        display_enum_value: Optional[bool] = None,
        auto_validation_threshold: Optional[float] = None,
        enable_auto_validation_threshold: Optional[bool] = None,
        data_source: Optional[str] = None,
        mapping: Optional[str] = None,
        display_raw_text: Optional[bool] = None,
        **kwargs,
    ):
        """
        :keyword label: Required.
        :paramtype label: str
        :keyword field_type: The different data types of annotations. Known values are: "text",
         "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum", "location",
         "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language", "skill",
         "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
        :paramtype field_type: str or ~affinda.models.AnnotationContentType
        :keyword mandatory:
        :paramtype mandatory: bool
        :keyword show_dropdown:
        :paramtype show_dropdown: bool
        :keyword display_enum_value: If true, both the value and the label for the enums will appear in
         the dropdown in the validation tool.
        :paramtype display_enum_value: bool
        :keyword auto_validation_threshold: Threshold for auto validation. If null, uses the
         collection's autoValidationThreshold.
        :paramtype auto_validation_threshold: float
        :keyword enable_auto_validation_threshold: If true, the autoValidationThreshold enable auto
         validation from the threshold from this field if specified, else from the collection.
        :paramtype enable_auto_validation_threshold: bool
        :keyword data_source: Data source mapping identifier.
        :paramtype data_source: str
        :keyword mapping: Defines how the data point is mapped to the data source.
        :paramtype mapping: str
        :keyword display_raw_text: If true, then the validation tool will show the user the raw text
         found on the page, not the value that has been parsed to a specific type.
        :paramtype display_raw_text: bool
        """
        super(DataFieldCreateField, self).__init__(**kwargs)
        self.label = label
        self.field_type = field_type
        self.mandatory = mandatory
        self.show_dropdown = show_dropdown
        self.display_enum_value = display_enum_value
        self.auto_validation_threshold = auto_validation_threshold
        self.enable_auto_validation_threshold = enable_auto_validation_threshold
        self.data_source = data_source
        self.mapping = mapping
        self.display_raw_text = display_raw_text


class DataFieldDataPoint(msrest.serialization.Model):
    """The data point to be created for this field. If a data point with the same slug and collection already exists, it will be reused.

    All required parameters must be populated in order to send to Azure.

    :ivar identifier: Required. Uniquely identify a data point.
    :vartype identifier: str
    :ivar name: Required. Name of the data point.
    :vartype name: str
    :ivar slug: Required. A camelCase string that will be used as the key in the API response.
    :vartype slug: str
    :ivar description: Required.
    :vartype description: str
    :ivar type: Required. The different data types of annotations. Known values are: "text",
     "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum", "location",
     "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language", "skill",
     "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
    :vartype type: str or ~affinda.models.AnnotationContentType
    :ivar multiple: Required.
    :vartype multiple: bool
    :ivar no_rect: Required.
    :vartype no_rect: bool
    :ivar parent: Required. The identifier of the parent data point if applicable.
    :vartype parent: str
    :ivar children: Required.
    :vartype children: list[~affinda.models.DataPoint]
    :ivar manual_entry: If true, the model will not be used to predict this data point. Instead,
     the user will be able to manually enter the value in the validation tool.
    :vartype manual_entry: bool
    :ivar available_data_sources:
    :vartype available_data_sources: list[~affinda.models.MappingDataSource]
    """

    _validation = {
        "identifier": {"required": True},
        "name": {"required": True},
        "slug": {"required": True},
        "description": {"required": True},
        "type": {"required": True},
        "multiple": {"required": True},
        "no_rect": {"required": True},
        "parent": {"required": True},
        "children": {"required": True},
    }

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "slug": {"key": "slug", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "multiple": {"key": "multiple", "type": "bool"},
        "no_rect": {"key": "noRect", "type": "bool"},
        "parent": {"key": "parent", "type": "str"},
        "children": {"key": "children", "type": "[DataPoint]"},
        "manual_entry": {"key": "manualEntry", "type": "bool"},
        "available_data_sources": {"key": "availableDataSources", "type": "[MappingDataSource]"},
    }

    def __init__(
        self,
        *,
        identifier: str,
        name: str,
        slug: str,
        description: str,
        type: Union[str, "_models.AnnotationContentType"],
        multiple: bool,
        no_rect: bool,
        parent: str,
        children: List["_models.DataPoint"],
        manual_entry: Optional[bool] = None,
        available_data_sources: Optional[List["_models.MappingDataSource"]] = None,
        **kwargs,
    ):
        """
        :keyword identifier: Required. Uniquely identify a data point.
        :paramtype identifier: str
        :keyword name: Required. Name of the data point.
        :paramtype name: str
        :keyword slug: Required. A camelCase string that will be used as the key in the API response.
        :paramtype slug: str
        :keyword description: Required.
        :paramtype description: str
        :keyword type: Required. The different data types of annotations. Known values are: "text",
         "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum", "location",
         "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language", "skill",
         "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
        :paramtype type: str or ~affinda.models.AnnotationContentType
        :keyword multiple: Required.
        :paramtype multiple: bool
        :keyword no_rect: Required.
        :paramtype no_rect: bool
        :keyword parent: Required. The identifier of the parent data point if applicable.
        :paramtype parent: str
        :keyword children: Required.
        :paramtype children: list[~affinda.models.DataPoint]
        :keyword manual_entry: If true, the model will not be used to predict this data point. Instead,
         the user will be able to manually enter the value in the validation tool.
        :paramtype manual_entry: bool
        :keyword available_data_sources:
        :paramtype available_data_sources: list[~affinda.models.MappingDataSource]
        """
        super(DataFieldDataPoint, self).__init__(**kwargs)
        self.identifier = identifier
        self.name = name
        self.slug = slug
        self.description = description
        self.type = type
        self.multiple = multiple
        self.no_rect = no_rect
        self.parent = parent
        self.children = children
        self.manual_entry = manual_entry
        self.available_data_sources = available_data_sources


class DataFieldField(msrest.serialization.Model):
    """The field to be created.

    All required parameters must be populated in order to send to Azure.

    :ivar label: Required.
    :vartype label: str
    :ivar field_type: The different data types of annotations. Known values are: "text", "integer",
     "float", "decimal", "date", "datetime", "daterange", "boolean", "enum", "location",
     "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language", "skill",
     "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
    :vartype field_type: str or ~affinda.models.AnnotationContentType
    :ivar mandatory: Required.
    :vartype mandatory: bool
    :ivar show_dropdown:
    :vartype show_dropdown: bool
    :ivar display_enum_value: Required. If true, both the value and the label for the enums will
     appear in the dropdown in the validation tool.
    :vartype display_enum_value: bool
    :ivar auto_validation_threshold: Required. Threshold for auto validation. If null, uses the
     collection's autoValidationThreshold.
    :vartype auto_validation_threshold: float
    :ivar enable_auto_validation_threshold: If true, the autoValidationThreshold enable auto
     validation from the threshold from this field if specified, else from the collection.
    :vartype enable_auto_validation_threshold: bool
    :ivar enabled_child_fields: Required.
    :vartype enabled_child_fields: list[~affinda.models.Field]
    :ivar disabled_child_fields: Required.
    :vartype disabled_child_fields: list[~affinda.models.Field]
    :ivar data_source: Data source mapping identifier.
    :vartype data_source: str
    :ivar mapping: Defines how the data point is mapped to the data source.
    :vartype mapping: str
    :ivar display_raw_text: If true, then the validation tool will show the user the raw text found
     on the page, not the value that has been parsed to a specific type.
    :vartype display_raw_text: bool
    """

    _validation = {
        "label": {"required": True},
        "mandatory": {"required": True},
        "display_enum_value": {"required": True},
        "auto_validation_threshold": {"required": True, "maximum": 1, "minimum": 0},
        "enabled_child_fields": {"required": True},
        "disabled_child_fields": {"required": True},
    }

    _attribute_map = {
        "label": {"key": "label", "type": "str"},
        "field_type": {"key": "fieldType", "type": "str"},
        "mandatory": {"key": "mandatory", "type": "bool"},
        "show_dropdown": {"key": "showDropdown", "type": "bool"},
        "display_enum_value": {"key": "displayEnumValue", "type": "bool"},
        "auto_validation_threshold": {"key": "autoValidationThreshold", "type": "float"},
        "enable_auto_validation_threshold": {
            "key": "enableAutoValidationThreshold",
            "type": "bool",
        },
        "enabled_child_fields": {"key": "enabledChildFields", "type": "[Field]"},
        "disabled_child_fields": {"key": "disabledChildFields", "type": "[Field]"},
        "data_source": {"key": "dataSource", "type": "str"},
        "mapping": {"key": "mapping", "type": "str"},
        "display_raw_text": {"key": "displayRawText", "type": "bool"},
    }

    def __init__(
        self,
        *,
        label: str,
        mandatory: bool,
        display_enum_value: bool,
        auto_validation_threshold: float,
        enabled_child_fields: List["_models.Field"],
        disabled_child_fields: List["_models.Field"],
        field_type: Optional[Union[str, "_models.AnnotationContentType"]] = None,
        show_dropdown: Optional[bool] = None,
        enable_auto_validation_threshold: Optional[bool] = None,
        data_source: Optional[str] = None,
        mapping: Optional[str] = None,
        display_raw_text: Optional[bool] = None,
        **kwargs,
    ):
        """
        :keyword label: Required.
        :paramtype label: str
        :keyword field_type: The different data types of annotations. Known values are: "text",
         "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum", "location",
         "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language", "skill",
         "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
        :paramtype field_type: str or ~affinda.models.AnnotationContentType
        :keyword mandatory: Required.
        :paramtype mandatory: bool
        :keyword show_dropdown:
        :paramtype show_dropdown: bool
        :keyword display_enum_value: Required. If true, both the value and the label for the enums will
         appear in the dropdown in the validation tool.
        :paramtype display_enum_value: bool
        :keyword auto_validation_threshold: Required. Threshold for auto validation. If null, uses the
         collection's autoValidationThreshold.
        :paramtype auto_validation_threshold: float
        :keyword enable_auto_validation_threshold: If true, the autoValidationThreshold enable auto
         validation from the threshold from this field if specified, else from the collection.
        :paramtype enable_auto_validation_threshold: bool
        :keyword enabled_child_fields: Required.
        :paramtype enabled_child_fields: list[~affinda.models.Field]
        :keyword disabled_child_fields: Required.
        :paramtype disabled_child_fields: list[~affinda.models.Field]
        :keyword data_source: Data source mapping identifier.
        :paramtype data_source: str
        :keyword mapping: Defines how the data point is mapped to the data source.
        :paramtype mapping: str
        :keyword display_raw_text: If true, then the validation tool will show the user the raw text
         found on the page, not the value that has been parsed to a specific type.
        :paramtype display_raw_text: bool
        """
        super(DataFieldField, self).__init__(**kwargs)
        self.label = label
        self.field_type = field_type
        self.mandatory = mandatory
        self.show_dropdown = show_dropdown
        self.display_enum_value = display_enum_value
        self.auto_validation_threshold = auto_validation_threshold
        self.enable_auto_validation_threshold = enable_auto_validation_threshold
        self.enabled_child_fields = enabled_child_fields
        self.disabled_child_fields = disabled_child_fields
        self.data_source = data_source
        self.mapping = mapping
        self.display_raw_text = display_raw_text


class DataPoint(msrest.serialization.Model):
    """DataPoint.

    All required parameters must be populated in order to send to Azure.

    :ivar identifier: Required. Uniquely identify a data point.
    :vartype identifier: str
    :ivar name: Required. Name of the data point.
    :vartype name: str
    :ivar slug: Required. A camelCase string that will be used as the key in the API response.
    :vartype slug: str
    :ivar description:
    :vartype description: str
    :ivar annotation_content_type: Required. The different data types of annotations. Known values
     are: "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
     "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
     "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
    :vartype annotation_content_type: str or ~affinda.models.AnnotationContentType
    :ivar organization: Required.
    :vartype organization: ~affinda.models.Organization
    :ivar extractor: Required. Uniquely identify an extractor.
    :vartype extractor: str
    :ivar multiple:
    :vartype multiple: bool
    :ivar no_rect:
    :vartype no_rect: bool
    :ivar parent: The identifier of the parent data point if applicable.
    :vartype parent: str
    :ivar children:
    :vartype children: list[~affinda.models.DataPoint]
    :ivar available_data_sources:
    :vartype available_data_sources: list[~affinda.models.MappingDataSource]
    :ivar mapping_data_source: If populated, the model will learn to predict this field using the
     data source, rather than relying on fuzzy string matching.
    :vartype mapping_data_source: str
    :ivar manual_entry: If true, the model will not be used to predict this data point. Instead,
     the user will be able to manually enter the value in the validation tool.
    :vartype manual_entry: bool
    """

    _validation = {
        "identifier": {"required": True},
        "name": {"required": True},
        "slug": {"required": True},
        "annotation_content_type": {"required": True},
        "organization": {"required": True},
        "extractor": {"required": True},
    }

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "slug": {"key": "slug", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "annotation_content_type": {"key": "annotationContentType", "type": "str"},
        "organization": {"key": "organization", "type": "Organization"},
        "extractor": {"key": "extractor", "type": "str"},
        "multiple": {"key": "multiple", "type": "bool"},
        "no_rect": {"key": "noRect", "type": "bool"},
        "parent": {"key": "parent", "type": "str"},
        "children": {"key": "children", "type": "[DataPoint]"},
        "available_data_sources": {"key": "availableDataSources", "type": "[MappingDataSource]"},
        "mapping_data_source": {"key": "mappingDataSource", "type": "str"},
        "manual_entry": {"key": "manualEntry", "type": "bool"},
    }

    def __init__(
        self,
        *,
        identifier: str,
        name: str,
        slug: str,
        annotation_content_type: Union[str, "_models.AnnotationContentType"],
        organization: "_models.Organization",
        extractor: str,
        description: Optional[str] = None,
        multiple: Optional[bool] = None,
        no_rect: Optional[bool] = None,
        parent: Optional[str] = None,
        children: Optional[List["_models.DataPoint"]] = None,
        available_data_sources: Optional[List["_models.MappingDataSource"]] = None,
        mapping_data_source: Optional[str] = None,
        manual_entry: Optional[bool] = None,
        **kwargs,
    ):
        """
        :keyword identifier: Required. Uniquely identify a data point.
        :paramtype identifier: str
        :keyword name: Required. Name of the data point.
        :paramtype name: str
        :keyword slug: Required. A camelCase string that will be used as the key in the API response.
        :paramtype slug: str
        :keyword description:
        :paramtype description: str
        :keyword annotation_content_type: Required. The different data types of annotations. Known
         values are: "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean",
         "enum", "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle",
         "language", "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
        :paramtype annotation_content_type: str or ~affinda.models.AnnotationContentType
        :keyword organization: Required.
        :paramtype organization: ~affinda.models.Organization
        :keyword extractor: Required. Uniquely identify an extractor.
        :paramtype extractor: str
        :keyword multiple:
        :paramtype multiple: bool
        :keyword no_rect:
        :paramtype no_rect: bool
        :keyword parent: The identifier of the parent data point if applicable.
        :paramtype parent: str
        :keyword children:
        :paramtype children: list[~affinda.models.DataPoint]
        :keyword available_data_sources:
        :paramtype available_data_sources: list[~affinda.models.MappingDataSource]
        :keyword mapping_data_source: If populated, the model will learn to predict this field using
         the data source, rather than relying on fuzzy string matching.
        :paramtype mapping_data_source: str
        :keyword manual_entry: If true, the model will not be used to predict this data point. Instead,
         the user will be able to manually enter the value in the validation tool.
        :paramtype manual_entry: bool
        """
        super(DataPoint, self).__init__(**kwargs)
        self.identifier = identifier
        self.name = name
        self.slug = slug
        self.description = description
        self.annotation_content_type = annotation_content_type
        self.organization = organization
        self.extractor = extractor
        self.multiple = multiple
        self.no_rect = no_rect
        self.parent = parent
        self.children = children
        self.available_data_sources = available_data_sources
        self.mapping_data_source = mapping_data_source
        self.manual_entry = manual_entry


class DataPointChoice(msrest.serialization.Model):
    """DataPointChoice.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Data point choice's ID.
    :vartype id: int
    :ivar label: Required.
    :vartype label: str
    :ivar value: Required.
    :vartype value: str
    :ivar synonyms:
    :vartype synonyms: list[str]
    :ivar description:
    :vartype description: str
    """

    _validation = {
        "id": {"required": True, "minimum": 1},
        "label": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "label": {"key": "label", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "synonyms": {"key": "synonyms", "type": "[str]"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        label: str,
        value: str,
        synonyms: Optional[List[str]] = None,
        description: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword id: Required. Data point choice's ID.
        :paramtype id: int
        :keyword label: Required.
        :paramtype label: str
        :keyword value: Required.
        :paramtype value: str
        :keyword synonyms:
        :paramtype synonyms: list[str]
        :keyword description:
        :paramtype description: str
        """
        super(DataPointChoice, self).__init__(**kwargs)
        self.id = id
        self.label = label
        self.value = value
        self.synonyms = synonyms
        self.description = description


class DataPointChoiceCreate(msrest.serialization.Model):
    """DataPointChoiceCreate.

    All required parameters must be populated in order to send to Azure.

    :ivar data_point: Required. Uniquely identify a data point.
    :vartype data_point: str
    :ivar organization: Uniquely identify an organization.
    :vartype organization: str
    :ivar collection: Uniquely identify a collection.
    :vartype collection: str
    :ivar label: Required.
    :vartype label: str
    :ivar value: Required.
    :vartype value: str
    :ivar synonyms:
    :vartype synonyms: list[str]
    :ivar description:
    :vartype description: str
    """

    _validation = {
        "data_point": {"required": True},
        "label": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "data_point": {"key": "dataPoint", "type": "str"},
        "organization": {"key": "organization", "type": "str"},
        "collection": {"key": "collection", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "synonyms": {"key": "synonyms", "type": "[str]"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        data_point: str,
        label: str,
        value: str,
        organization: Optional[str] = None,
        collection: Optional[str] = None,
        synonyms: Optional[List[str]] = None,
        description: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword data_point: Required. Uniquely identify a data point.
        :paramtype data_point: str
        :keyword organization: Uniquely identify an organization.
        :paramtype organization: str
        :keyword collection: Uniquely identify a collection.
        :paramtype collection: str
        :keyword label: Required.
        :paramtype label: str
        :keyword value: Required.
        :paramtype value: str
        :keyword synonyms:
        :paramtype synonyms: list[str]
        :keyword description:
        :paramtype description: str
        """
        super(DataPointChoiceCreate, self).__init__(**kwargs)
        self.data_point = data_point
        self.organization = organization
        self.collection = collection
        self.label = label
        self.value = value
        self.synonyms = synonyms
        self.description = description


class DataPointChoiceForReplace(msrest.serialization.Model):
    """DataPointChoiceForReplace.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required.
    :vartype value: str
    :ivar label:
    :vartype label: str
    :ivar synonyms:
    :vartype synonyms: list[str]
    :ivar description:
    :vartype description: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "synonyms": {"key": "synonyms", "type": "[str]"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: str,
        label: Optional[str] = None,
        synonyms: Optional[List[str]] = None,
        description: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword value: Required.
        :paramtype value: str
        :keyword label:
        :paramtype label: str
        :keyword synonyms:
        :paramtype synonyms: list[str]
        :keyword description:
        :paramtype description: str
        """
        super(DataPointChoiceForReplace, self).__init__(**kwargs)
        self.value = value
        self.label = label
        self.synonyms = synonyms
        self.description = description


class DataPointChoiceReplaceRequest(msrest.serialization.Model):
    """Request body for replacing choices of a data point. Either ``collection`` or ``organization`` is required.

    All required parameters must be populated in order to send to Azure.

    :ivar data_point: Required. Uniquely identify a data point.
    :vartype data_point: str
    :ivar collection: Uniquely identify a collection.
    :vartype collection: str
    :ivar organization: Uniquely identify an organization.
    :vartype organization: str
    :ivar choices: Required. Incoming choices to replace existing choices of a data point. Existing
     choices and incoming choices are matched base on their ``value``. New ``value`` will be
     created, existing ``value`` will be updated, and ``value`` not in incoming choices will be
     deleted.
    :vartype choices: list[~affinda.models.DataPointChoiceForReplace]
    """

    _validation = {
        "data_point": {"required": True},
        "choices": {"required": True},
    }

    _attribute_map = {
        "data_point": {"key": "dataPoint", "type": "str"},
        "collection": {"key": "collection", "type": "str"},
        "organization": {"key": "organization", "type": "str"},
        "choices": {"key": "choices", "type": "[DataPointChoiceForReplace]"},
    }

    def __init__(
        self,
        *,
        data_point: str,
        choices: List["_models.DataPointChoiceForReplace"],
        collection: Optional[str] = None,
        organization: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword data_point: Required. Uniquely identify a data point.
        :paramtype data_point: str
        :keyword collection: Uniquely identify a collection.
        :paramtype collection: str
        :keyword organization: Uniquely identify an organization.
        :paramtype organization: str
        :keyword choices: Required. Incoming choices to replace existing choices of a data point.
         Existing choices and incoming choices are matched base on their ``value``. New ``value`` will
         be created, existing ``value`` will be updated, and ``value`` not in incoming choices will be
         deleted.
        :paramtype choices: list[~affinda.models.DataPointChoiceForReplace]
        """
        super(DataPointChoiceReplaceRequest, self).__init__(**kwargs)
        self.data_point = data_point
        self.collection = collection
        self.organization = organization
        self.choices = choices


class DataPointChoiceReplaceResponse(msrest.serialization.Model):
    """DataPointChoiceReplaceResponse.

    All required parameters must be populated in order to send to Azure.

    :ivar data_point: Required. Uniquely identify a data point.
    :vartype data_point: str
    :ivar collection: Required. Uniquely identify a collection.
    :vartype collection: str
    :ivar organization: Required. Uniquely identify an organization.
    :vartype organization: str
    :ivar choices: Required.
    :vartype choices: list[~affinda.models.DataPointChoiceReplaceResponseChoicesItem]
    """

    _validation = {
        "data_point": {"required": True},
        "collection": {"required": True},
        "organization": {"required": True},
        "choices": {"required": True},
    }

    _attribute_map = {
        "data_point": {"key": "dataPoint", "type": "str"},
        "collection": {"key": "collection", "type": "str"},
        "organization": {"key": "organization", "type": "str"},
        "choices": {"key": "choices", "type": "[DataPointChoiceReplaceResponseChoicesItem]"},
    }

    def __init__(
        self,
        *,
        data_point: str,
        collection: str,
        organization: str,
        choices: List["_models.DataPointChoiceReplaceResponseChoicesItem"],
        **kwargs,
    ):
        """
        :keyword data_point: Required. Uniquely identify a data point.
        :paramtype data_point: str
        :keyword collection: Required. Uniquely identify a collection.
        :paramtype collection: str
        :keyword organization: Required. Uniquely identify an organization.
        :paramtype organization: str
        :keyword choices: Required.
        :paramtype choices: list[~affinda.models.DataPointChoiceReplaceResponseChoicesItem]
        """
        super(DataPointChoiceReplaceResponse, self).__init__(**kwargs)
        self.data_point = data_point
        self.collection = collection
        self.organization = organization
        self.choices = choices


class DataPointChoiceReplaceResponseChoicesItem(msrest.serialization.Model):
    """DataPointChoiceReplaceResponseChoicesItem.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Data point choice's ID.
    :vartype id: int
    :ivar value: Required.
    :vartype value: str
    :ivar label: Required.
    :vartype label: str
    :ivar synonyms: Required.
    :vartype synonyms: list[str]
    :ivar description: Required.
    :vartype description: str
    """

    _validation = {
        "id": {"required": True, "minimum": 1},
        "value": {"required": True},
        "label": {"required": True},
        "synonyms": {"required": True},
        "description": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "value": {"key": "value", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "synonyms": {"key": "synonyms", "type": "[str]"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self, *, id: int, value: str, label: str, synonyms: List[str], description: str, **kwargs
    ):
        """
        :keyword id: Required. Data point choice's ID.
        :paramtype id: int
        :keyword value: Required.
        :paramtype value: str
        :keyword label: Required.
        :paramtype label: str
        :keyword synonyms: Required.
        :paramtype synonyms: list[str]
        :keyword description: Required.
        :paramtype description: str
        """
        super(DataPointChoiceReplaceResponseChoicesItem, self).__init__(**kwargs)
        self.id = id
        self.value = value
        self.label = label
        self.synonyms = synonyms
        self.description = description


class DataPointChoiceUpdate(msrest.serialization.Model):
    """DataPointChoiceUpdate.

    :ivar data_point: Uniquely identify a data point.
    :vartype data_point: str
    :ivar organization: Uniquely identify an organization.
    :vartype organization: str
    :ivar collection: Uniquely identify a collection.
    :vartype collection: str
    :ivar label:
    :vartype label: str
    :ivar value:
    :vartype value: str
    :ivar synonyms:
    :vartype synonyms: list[str]
    :ivar description:
    :vartype description: str
    """

    _attribute_map = {
        "data_point": {"key": "dataPoint", "type": "str"},
        "organization": {"key": "organization", "type": "str"},
        "collection": {"key": "collection", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "synonyms": {"key": "synonyms", "type": "[str]"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        data_point: Optional[str] = None,
        organization: Optional[str] = None,
        collection: Optional[str] = None,
        label: Optional[str] = None,
        value: Optional[str] = None,
        synonyms: Optional[List[str]] = None,
        description: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword data_point: Uniquely identify a data point.
        :paramtype data_point: str
        :keyword organization: Uniquely identify an organization.
        :paramtype organization: str
        :keyword collection: Uniquely identify a collection.
        :paramtype collection: str
        :keyword label:
        :paramtype label: str
        :keyword value:
        :paramtype value: str
        :keyword synonyms:
        :paramtype synonyms: list[str]
        :keyword description:
        :paramtype description: str
        """
        super(DataPointChoiceUpdate, self).__init__(**kwargs)
        self.data_point = data_point
        self.organization = organization
        self.collection = collection
        self.label = label
        self.value = value
        self.synonyms = synonyms
        self.description = description


class DataPointCreate(msrest.serialization.Model):
    """DataPointCreate.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. Name of the data point.
    :vartype name: str
    :ivar slug: Required. A camelCase string that will be used as the key in the API response.
    :vartype slug: str
    :ivar description:
    :vartype description: str
    :ivar annotation_content_type: Required. The different data types of annotations. Known values
     are: "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
     "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
     "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
    :vartype annotation_content_type: str or ~affinda.models.AnnotationContentType
    :ivar organization: Required. Uniquely identify an organization.
    :vartype organization: str
    :ivar extractor: Required. Uniquely identify an extractor.
    :vartype extractor: str
    :ivar multiple:
    :vartype multiple: bool
    :ivar no_rect:
    :vartype no_rect: bool
    :ivar parent: The identifier of the parent data point if applicable.
    :vartype parent: str
    :ivar manual_entry: If true, the model will not be used to predict this data point. Instead,
     the user will be able to manually enter the value in the validation tool.
    :vartype manual_entry: bool
    :ivar mapping_data_source: If populated, the model will learn to predict this field using the
     data source, rather than relying on fuzzy string matching.
    :vartype mapping_data_source: str
    """

    _validation = {
        "name": {"required": True},
        "slug": {"required": True},
        "annotation_content_type": {"required": True},
        "organization": {"required": True},
        "extractor": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "slug": {"key": "slug", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "annotation_content_type": {"key": "annotationContentType", "type": "str"},
        "organization": {"key": "organization", "type": "str"},
        "extractor": {"key": "extractor", "type": "str"},
        "multiple": {"key": "multiple", "type": "bool"},
        "no_rect": {"key": "noRect", "type": "bool"},
        "parent": {"key": "parent", "type": "str"},
        "manual_entry": {"key": "manualEntry", "type": "bool"},
        "mapping_data_source": {"key": "mappingDataSource", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        slug: str,
        annotation_content_type: Union[str, "_models.AnnotationContentType"],
        organization: str,
        extractor: str,
        description: Optional[str] = None,
        multiple: Optional[bool] = None,
        no_rect: Optional[bool] = None,
        parent: Optional[str] = None,
        manual_entry: Optional[bool] = None,
        mapping_data_source: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword name: Required. Name of the data point.
        :paramtype name: str
        :keyword slug: Required. A camelCase string that will be used as the key in the API response.
        :paramtype slug: str
        :keyword description:
        :paramtype description: str
        :keyword annotation_content_type: Required. The different data types of annotations. Known
         values are: "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean",
         "enum", "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle",
         "language", "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
        :paramtype annotation_content_type: str or ~affinda.models.AnnotationContentType
        :keyword organization: Required. Uniquely identify an organization.
        :paramtype organization: str
        :keyword extractor: Required. Uniquely identify an extractor.
        :paramtype extractor: str
        :keyword multiple:
        :paramtype multiple: bool
        :keyword no_rect:
        :paramtype no_rect: bool
        :keyword parent: The identifier of the parent data point if applicable.
        :paramtype parent: str
        :keyword manual_entry: If true, the model will not be used to predict this data point. Instead,
         the user will be able to manually enter the value in the validation tool.
        :paramtype manual_entry: bool
        :keyword mapping_data_source: If populated, the model will learn to predict this field using
         the data source, rather than relying on fuzzy string matching.
        :paramtype mapping_data_source: str
        """
        super(DataPointCreate, self).__init__(**kwargs)
        self.name = name
        self.slug = slug
        self.description = description
        self.annotation_content_type = annotation_content_type
        self.organization = organization
        self.extractor = extractor
        self.multiple = multiple
        self.no_rect = no_rect
        self.parent = parent
        self.manual_entry = manual_entry
        self.mapping_data_source = mapping_data_source


class DataPointUpdate(msrest.serialization.Model):
    """DataPointUpdate.

    :ivar name: Name of the data point.
    :vartype name: str
    :ivar slug: A camelCase string that will be used as the key in the API response.
    :vartype slug: str
    :ivar description:
    :vartype description: str
    :ivar parent: The identifier of the parent data point if applicable.
    :vartype parent: str
    :ivar mapping_data_source: If populated, the model will learn to predict this field using the
     data source, rather than relying on fuzzy string matching.
    :vartype mapping_data_source: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "slug": {"key": "slug", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "parent": {"key": "parent", "type": "str"},
        "mapping_data_source": {"key": "mappingDataSource", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        slug: Optional[str] = None,
        description: Optional[str] = None,
        parent: Optional[str] = None,
        mapping_data_source: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword name: Name of the data point.
        :paramtype name: str
        :keyword slug: A camelCase string that will be used as the key in the API response.
        :paramtype slug: str
        :keyword description:
        :paramtype description: str
        :keyword parent: The identifier of the parent data point if applicable.
        :paramtype parent: str
        :keyword mapping_data_source: If populated, the model will learn to predict this field using
         the data source, rather than relying on fuzzy string matching.
        :paramtype mapping_data_source: str
        """
        super(DataPointUpdate, self).__init__(**kwargs)
        self.name = name
        self.slug = slug
        self.description = description
        self.parent = parent
        self.mapping_data_source = mapping_data_source


class DateAnnotation(Annotation):
    """DateAnnotation.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required. Annotation's ID.
    :vartype id: int
    :ivar rectangle: Required. x/y coordinates for the rectangular bounding box containing the
     data.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required. x/y coordinates for the rectangles containing the data. An
     annotation can be contained within multiple rectangles.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar document: Required. Unique identifier for the document.
    :vartype document: str
    :ivar page_index: Required. The page number within the document, starting from 0.
    :vartype page_index: int
    :ivar raw: Required. Raw data extracted from the before any post-processing.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required. Indicates whether the data has been validated, either by a human
     using our validation tool or through auto-validation rules.
    :vartype is_verified: bool
    :ivar is_client_verified: Required. Indicates whether the data has been validated by a human.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required. Indicates whether the data has been auto-validated.
    :vartype is_auto_verified: bool
    :ivar data_point: Data point's identifier.
    :vartype data_point: str
    :ivar field: Field's identifier.
    :vartype field: str
    :ivar content_type: Required. The different data types of annotations. Known values are:
     "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
     "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
     "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
    :vartype content_type: str or ~affinda.models.AnnotationContentType
    :ivar parent: The parent annotation's ID.
    :vartype parent: int
    :ivar parsed:
    :vartype parsed: ~datetime.date
    """

    _validation = {
        "id": {"required": True, "minimum": 1},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "document": {"required": True},
        "page_index": {"required": True, "minimum": 0},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "document": {"key": "document", "type": "str"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "field": {"key": "field", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parent": {"key": "parent", "type": "int"},
        "parsed": {"key": "parsed", "type": "date"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        document: str,
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        content_type: Union[str, "_models.AnnotationContentType"],
        additional_properties: Optional[Dict[str, Any]] = None,
        data_point: Optional[str] = None,
        field: Optional[str] = None,
        parent: Optional[int] = None,
        parsed: Optional[datetime.date] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required. Annotation's ID.
        :paramtype id: int
        :keyword rectangle: Required. x/y coordinates for the rectangular bounding box containing the
         data.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required. x/y coordinates for the rectangles containing the data. An
         annotation can be contained within multiple rectangles.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword document: Required. Unique identifier for the document.
        :paramtype document: str
        :keyword page_index: Required. The page number within the document, starting from 0.
        :paramtype page_index: int
        :keyword raw: Required. Raw data extracted from the before any post-processing.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required. Indicates whether the data has been validated, either by a
         human using our validation tool or through auto-validation rules.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required. Indicates whether the data has been validated by a
         human.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required. Indicates whether the data has been auto-validated.
        :paramtype is_auto_verified: bool
        :keyword data_point: Data point's identifier.
        :paramtype data_point: str
        :keyword field: Field's identifier.
        :paramtype field: str
        :keyword content_type: Required. The different data types of annotations. Known values are:
         "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
         "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
         "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
        :paramtype content_type: str or ~affinda.models.AnnotationContentType
        :keyword parent: The parent annotation's ID.
        :paramtype parent: int
        :keyword parsed:
        :paramtype parsed: ~datetime.date
        """
        super(DateAnnotation, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            document=document,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            field=field,
            content_type=content_type,
            parent=parent,
            **kwargs,
        )
        self.parsed = parsed


class DateAnnotationUpdate(AnnotationBase):
    """DateAnnotationUpdate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id:
    :vartype id: int
    :ivar rectangle:
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles:
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index:
    :vartype page_index: int
    :ivar raw:
    :vartype raw: str
    :ivar confidence: The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: The model's confidence that the text has been classified
     correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: If the document was submitted as an image, this is the
     confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified:
    :vartype is_verified: bool
    :ivar is_client_verified:
    :vartype is_client_verified: bool
    :ivar is_auto_verified:
    :vartype is_auto_verified: bool
    :ivar data_point:
    :vartype data_point: str
    :ivar content_type:
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: ~datetime.date
    """

    _validation = {
        "rectangles": {"readonly": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "date"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        id: Optional[int] = None,
        rectangle: Optional["_models.Rectangle"] = None,
        page_index: Optional[int] = None,
        raw: Optional[str] = None,
        confidence: Optional[float] = None,
        classification_confidence: Optional[float] = None,
        text_extraction_confidence: Optional[float] = None,
        is_verified: Optional[bool] = None,
        is_client_verified: Optional[bool] = None,
        is_auto_verified: Optional[bool] = None,
        data_point: Optional[str] = None,
        content_type: Optional[str] = None,
        parsed: Optional[datetime.date] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id:
        :paramtype id: int
        :keyword rectangle:
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword page_index:
        :paramtype page_index: int
        :keyword raw:
        :paramtype raw: str
        :keyword confidence: The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: The model's confidence that the text has been classified
         correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: If the document was submitted as an image, this is the
         confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified:
        :paramtype is_verified: bool
        :keyword is_client_verified:
        :paramtype is_client_verified: bool
        :keyword is_auto_verified:
        :paramtype is_auto_verified: bool
        :keyword data_point:
        :paramtype data_point: str
        :keyword content_type:
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: ~datetime.date
        """
        super(DateAnnotationUpdate, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            **kwargs,
        )
        self.parsed = parsed


class DateRangeAnnotation(Annotation):
    """DateRangeAnnotation.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required. Annotation's ID.
    :vartype id: int
    :ivar rectangle: Required. x/y coordinates for the rectangular bounding box containing the
     data.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required. x/y coordinates for the rectangles containing the data. An
     annotation can be contained within multiple rectangles.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar document: Required. Unique identifier for the document.
    :vartype document: str
    :ivar page_index: Required. The page number within the document, starting from 0.
    :vartype page_index: int
    :ivar raw: Required. Raw data extracted from the before any post-processing.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required. Indicates whether the data has been validated, either by a human
     using our validation tool or through auto-validation rules.
    :vartype is_verified: bool
    :ivar is_client_verified: Required. Indicates whether the data has been validated by a human.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required. Indicates whether the data has been auto-validated.
    :vartype is_auto_verified: bool
    :ivar data_point: Data point's identifier.
    :vartype data_point: str
    :ivar field: Field's identifier.
    :vartype field: str
    :ivar content_type: Required. The different data types of annotations. Known values are:
     "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
     "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
     "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
    :vartype content_type: str or ~affinda.models.AnnotationContentType
    :ivar parent: The parent annotation's ID.
    :vartype parent: int
    :ivar parsed:
    :vartype parsed: ~affinda.models.DateRangeAnnotationParsed
    """

    _validation = {
        "id": {"required": True, "minimum": 1},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "document": {"required": True},
        "page_index": {"required": True, "minimum": 0},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "document": {"key": "document", "type": "str"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "field": {"key": "field", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parent": {"key": "parent", "type": "int"},
        "parsed": {"key": "parsed", "type": "DateRangeAnnotationParsed"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        document: str,
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        content_type: Union[str, "_models.AnnotationContentType"],
        additional_properties: Optional[Dict[str, Any]] = None,
        data_point: Optional[str] = None,
        field: Optional[str] = None,
        parent: Optional[int] = None,
        parsed: Optional["_models.DateRangeAnnotationParsed"] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required. Annotation's ID.
        :paramtype id: int
        :keyword rectangle: Required. x/y coordinates for the rectangular bounding box containing the
         data.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required. x/y coordinates for the rectangles containing the data. An
         annotation can be contained within multiple rectangles.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword document: Required. Unique identifier for the document.
        :paramtype document: str
        :keyword page_index: Required. The page number within the document, starting from 0.
        :paramtype page_index: int
        :keyword raw: Required. Raw data extracted from the before any post-processing.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required. Indicates whether the data has been validated, either by a
         human using our validation tool or through auto-validation rules.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required. Indicates whether the data has been validated by a
         human.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required. Indicates whether the data has been auto-validated.
        :paramtype is_auto_verified: bool
        :keyword data_point: Data point's identifier.
        :paramtype data_point: str
        :keyword field: Field's identifier.
        :paramtype field: str
        :keyword content_type: Required. The different data types of annotations. Known values are:
         "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
         "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
         "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
        :paramtype content_type: str or ~affinda.models.AnnotationContentType
        :keyword parent: The parent annotation's ID.
        :paramtype parent: int
        :keyword parsed:
        :paramtype parsed: ~affinda.models.DateRangeAnnotationParsed
        """
        super(DateRangeAnnotation, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            document=document,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            field=field,
            content_type=content_type,
            parent=parent,
            **kwargs,
        )
        self.parsed = parsed


class DateRangeAnnotationParsed(msrest.serialization.Model):
    """DateRangeAnnotationParsed.

    :ivar start:
    :vartype start: ~affinda.models.DateRangeValue
    :ivar end:
    :vartype end: ~affinda.models.DateRangeValue
    """

    _attribute_map = {
        "start": {"key": "start", "type": "DateRangeValue"},
        "end": {"key": "end", "type": "DateRangeValue"},
    }

    def __init__(
        self,
        *,
        start: Optional["_models.DateRangeValue"] = None,
        end: Optional["_models.DateRangeValue"] = None,
        **kwargs,
    ):
        """
        :keyword start:
        :paramtype start: ~affinda.models.DateRangeValue
        :keyword end:
        :paramtype end: ~affinda.models.DateRangeValue
        """
        super(DateRangeAnnotationParsed, self).__init__(**kwargs)
        self.start = start
        self.end = end


class DateRangeValue(msrest.serialization.Model):
    """DateRangeValue.

    :ivar date:
    :vartype date: ~datetime.date
    :ivar is_current:
    :vartype is_current: bool
    :ivar day:
    :vartype day: int
    :ivar month:
    :vartype month: int
    :ivar year:
    :vartype year: int
    """

    _attribute_map = {
        "date": {"key": "date", "type": "date"},
        "is_current": {"key": "isCurrent", "type": "bool"},
        "day": {"key": "day", "type": "int"},
        "month": {"key": "month", "type": "int"},
        "year": {"key": "year", "type": "int"},
    }

    def __init__(
        self,
        *,
        date: Optional[datetime.date] = None,
        is_current: Optional[bool] = None,
        day: Optional[int] = None,
        month: Optional[int] = None,
        year: Optional[int] = None,
        **kwargs,
    ):
        """
        :keyword date:
        :paramtype date: ~datetime.date
        :keyword is_current:
        :paramtype is_current: bool
        :keyword day:
        :paramtype day: int
        :keyword month:
        :paramtype month: int
        :keyword year:
        :paramtype year: int
        """
        super(DateRangeValue, self).__init__(**kwargs)
        self.date = date
        self.is_current = is_current
        self.day = day
        self.month = month
        self.year = year


class Document(msrest.serialization.Model):
    """Document.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Invoice, JobDescription, Resume, ResumeRedact.

    All required parameters must be populated in order to send to Azure.

    :ivar data: Any object.
    :vartype data: any
    :ivar extractor: Required. Constant filled by server.
    :vartype extractor: str
    :ivar meta: Required.
    :vartype meta: ~affinda.models.DocumentMeta
    :ivar error:
    :vartype error: ~affinda.models.DocumentError
    :ivar warnings:
    :vartype warnings: list[~affinda.models.DocumentWarning]
    """

    _validation = {
        "extractor": {"required": True},
        "meta": {"required": True},
    }

    _attribute_map = {
        "data": {"key": "data", "type": "object"},
        "extractor": {"key": "extractor", "type": "str"},
        "meta": {"key": "meta", "type": "DocumentMeta"},
        "error": {"key": "error", "type": "DocumentError"},
        "warnings": {"key": "warnings", "type": "[DocumentWarning]"},
    }

    _subtype_map = {
        "extractor": {
            "invoice": "Invoice",
            "job-description": "JobDescription",
            "resume": "Resume",
            "resume-redact": "ResumeRedact",
        }
    }

    def __init__(
        self,
        *,
        meta: "_models.DocumentMeta",
        data: Optional[Any] = None,
        error: Optional["_models.DocumentError"] = None,
        warnings: Optional[List["_models.DocumentWarning"]] = None,
        **kwargs,
    ):
        """
        :keyword data: Any object.
        :paramtype data: any
        :keyword meta: Required.
        :paramtype meta: ~affinda.models.DocumentMeta
        :keyword error:
        :paramtype error: ~affinda.models.DocumentError
        :keyword warnings:
        :paramtype warnings: list[~affinda.models.DocumentWarning]
        """
        super(Document, self).__init__(**kwargs)
        self.data = data
        self.extractor = None  # type: Optional[str]
        self.meta = meta
        self.error = error
        self.warnings = warnings


class DocumentCreate(msrest.serialization.Model):
    """DocumentCreate.

    :ivar file: File as binary data blob. Supported formats: PDF, DOC, DOCX, TXT, RTF, HTML, PNG,
     JPG, TIFF, ODT, XLS, XLSX.
    :vartype file: IO
    :ivar url: URL to download the document.
    :vartype url: str
    :ivar data: Create resume or job description directly from data.
    :vartype data: any
    :ivar collection: Uniquely identify a collection.
    :vartype collection: str
    :ivar document_type: The document type's identifier.  Provide if you already know the document
     type.
    :vartype document_type: str
    :ivar workspace: Uniquely identify a workspace.
    :vartype workspace: str
    :ivar wait: If "true" (default), will return a response only after processing has completed. If
     "false", will return an empty data object which can be polled at the GET endpoint until
     processing is complete.
    :vartype wait: bool
    :ivar identifier: Deprecated in favor of ``customIdentifier``.
    :vartype identifier: str
    :ivar custom_identifier: Specify a custom identifier for the document if you need one, not
     required to be unique.
    :vartype custom_identifier: str
    :ivar file_name: Optional filename of the file.
    :vartype file_name: str
    :ivar expiry_time: The date/time in ISO-8601 format when the document will be automatically
     deleted.  Defaults to no expiry.
    :vartype expiry_time: ~datetime.datetime
    :ivar language: Language code in ISO 639-1 format. Must specify zh-cn or zh-tw for Chinese.
    :vartype language: str
    :ivar reject_duplicates: If "true", parsing will fail when the uploaded document is duplicate
     of an existing document, no credits will be consumed. If "false", will parse the document
     normally whether its a duplicate or not. If not provided, will fallback to the workspace
     settings.
    :vartype reject_duplicates: bool
    :ivar region_bias: A JSON representation of the RegionBias object.
    :vartype region_bias: str
    :ivar low_priority: Explicitly mark this document as low priority.
    :vartype low_priority: bool
    :ivar compact: If true, the returned parse result (assuming ``wait`` is also true) will be a
     compact version of the full result.
    :vartype compact: bool
    :ivar delete_after_parse: If true, no data will be stored after parsing. Only compatible with
     requests where wait: True.
    :vartype delete_after_parse: bool
    :ivar enable_validation_tool: If true, the document will be viewable in the Affinda Validation
     Tool. Set to False to optimize parsing speed.
    :vartype enable_validation_tool: bool
    :ivar use_ocr: If true, the document will be treated like an image, and the text will be
     extracted using OCR. If false, the document will be treated like a PDF, and the text will be
     extracted using the parser. If not set, we will determine whether to use OCR based on whether
     words are found in the document.
    :vartype use_ocr: bool
    :ivar warning_messages:
    :vartype warning_messages: list[~affinda.models.DocumentWarning]
    """

    _attribute_map = {
        "file": {"key": "file", "type": "IO"},
        "url": {"key": "url", "type": "str"},
        "data": {"key": "data", "type": "object"},
        "collection": {"key": "collection", "type": "str"},
        "document_type": {"key": "documentType", "type": "str"},
        "workspace": {"key": "workspace", "type": "str"},
        "wait": {"key": "wait", "type": "bool"},
        "identifier": {"key": "identifier", "type": "str"},
        "custom_identifier": {"key": "customIdentifier", "type": "str"},
        "file_name": {"key": "fileName", "type": "str"},
        "expiry_time": {"key": "expiryTime", "type": "iso-8601"},
        "language": {"key": "language", "type": "str"},
        "reject_duplicates": {"key": "rejectDuplicates", "type": "bool"},
        "region_bias": {"key": "regionBias", "type": "str"},
        "low_priority": {"key": "lowPriority", "type": "bool"},
        "compact": {"key": "compact", "type": "bool"},
        "delete_after_parse": {"key": "deleteAfterParse", "type": "bool"},
        "enable_validation_tool": {"key": "enableValidationTool", "type": "bool"},
        "use_ocr": {"key": "useOcr", "type": "bool"},
        "warning_messages": {"key": "warningMessages", "type": "[DocumentWarning]"},
    }

    def __init__(
        self,
        *,
        file: Optional[IO] = None,
        url: Optional[str] = None,
        data: Optional[Any] = None,
        collection: Optional[str] = None,
        document_type: Optional[str] = None,
        workspace: Optional[str] = None,
        wait: Optional[bool] = True,
        identifier: Optional[str] = None,
        custom_identifier: Optional[str] = None,
        file_name: Optional[str] = None,
        expiry_time: Optional[datetime.datetime] = None,
        language: Optional[str] = None,
        reject_duplicates: Optional[bool] = None,
        region_bias: Optional[str] = None,
        low_priority: Optional[bool] = None,
        compact: Optional[bool] = None,
        delete_after_parse: Optional[bool] = None,
        enable_validation_tool: Optional[bool] = None,
        use_ocr: Optional[bool] = None,
        warning_messages: Optional[List["_models.DocumentWarning"]] = None,
        **kwargs,
    ):
        """
        :keyword file: File as binary data blob. Supported formats: PDF, DOC, DOCX, TXT, RTF, HTML,
         PNG, JPG, TIFF, ODT, XLS, XLSX.
        :paramtype file: IO
        :keyword url: URL to download the document.
        :paramtype url: str
        :keyword data: Create resume or job description directly from data.
        :paramtype data: any
        :keyword collection: Uniquely identify a collection.
        :paramtype collection: str
        :keyword document_type: The document type's identifier.  Provide if you already know the
         document type.
        :paramtype document_type: str
        :keyword workspace: Uniquely identify a workspace.
        :paramtype workspace: str
        :keyword wait: If "true" (default), will return a response only after processing has completed.
         If "false", will return an empty data object which can be polled at the GET endpoint until
         processing is complete.
        :paramtype wait: bool
        :keyword identifier: Deprecated in favor of ``customIdentifier``.
        :paramtype identifier: str
        :keyword custom_identifier: Specify a custom identifier for the document if you need one, not
         required to be unique.
        :paramtype custom_identifier: str
        :keyword file_name: Optional filename of the file.
        :paramtype file_name: str
        :keyword expiry_time: The date/time in ISO-8601 format when the document will be automatically
         deleted.  Defaults to no expiry.
        :paramtype expiry_time: ~datetime.datetime
        :keyword language: Language code in ISO 639-1 format. Must specify zh-cn or zh-tw for Chinese.
        :paramtype language: str
        :keyword reject_duplicates: If "true", parsing will fail when the uploaded document is
         duplicate of an existing document, no credits will be consumed. If "false", will parse the
         document normally whether its a duplicate or not. If not provided, will fallback to the
         workspace settings.
        :paramtype reject_duplicates: bool
        :keyword region_bias: A JSON representation of the RegionBias object.
        :paramtype region_bias: str
        :keyword low_priority: Explicitly mark this document as low priority.
        :paramtype low_priority: bool
        :keyword compact: If true, the returned parse result (assuming ``wait`` is also true) will be a
         compact version of the full result.
        :paramtype compact: bool
        :keyword delete_after_parse: If true, no data will be stored after parsing. Only compatible
         with requests where wait: True.
        :paramtype delete_after_parse: bool
        :keyword enable_validation_tool: If true, the document will be viewable in the Affinda
         Validation Tool. Set to False to optimize parsing speed.
        :paramtype enable_validation_tool: bool
        :keyword use_ocr: If true, the document will be treated like an image, and the text will be
         extracted using OCR. If false, the document will be treated like a PDF, and the text will be
         extracted using the parser. If not set, we will determine whether to use OCR based on whether
         words are found in the document.
        :paramtype use_ocr: bool
        :keyword warning_messages:
        :paramtype warning_messages: list[~affinda.models.DocumentWarning]
        """
        super(DocumentCreate, self).__init__(**kwargs)
        self.file = file
        self.url = url
        self.data = data
        self.collection = collection
        self.document_type = document_type
        self.workspace = workspace
        self.wait = wait
        self.identifier = identifier
        self.custom_identifier = custom_identifier
        self.file_name = file_name
        self.expiry_time = expiry_time
        self.language = language
        self.reject_duplicates = reject_duplicates
        self.region_bias = region_bias
        self.low_priority = low_priority
        self.compact = compact
        self.delete_after_parse = delete_after_parse
        self.enable_validation_tool = enable_validation_tool
        self.use_ocr = use_ocr
        self.warning_messages = warning_messages


class DocumentEditRequest(msrest.serialization.Model):
    """DocumentEditRequest.

    All required parameters must be populated in order to send to Azure.

    :ivar splits: Required.
    :vartype splits: list[~affinda.models.DocumentSplit]
    """

    _validation = {
        "splits": {"required": True},
    }

    _attribute_map = {
        "splits": {"key": "splits", "type": "[DocumentSplit]"},
    }

    def __init__(self, *, splits: List["_models.DocumentSplit"], **kwargs):
        """
        :keyword splits: Required.
        :paramtype splits: list[~affinda.models.DocumentSplit]
        """
        super(DocumentEditRequest, self).__init__(**kwargs)
        self.splits = splits


class DocumentError(msrest.serialization.Model):
    """DocumentError.

    :ivar error_code:
    :vartype error_code: str
    :ivar error_detail:
    :vartype error_detail: str
    """

    _attribute_map = {
        "error_code": {"key": "errorCode", "type": "str"},
        "error_detail": {"key": "errorDetail", "type": "str"},
    }

    def __init__(
        self, *, error_code: Optional[str] = None, error_detail: Optional[str] = None, **kwargs
    ):
        """
        :keyword error_code:
        :paramtype error_code: str
        :keyword error_detail:
        :paramtype error_detail: str
        """
        super(DocumentError, self).__init__(**kwargs)
        self.error_code = error_code
        self.error_detail = error_detail


class DocumentMeta(msrest.serialization.Model):
    """DocumentMeta.

    All required parameters must be populated in order to send to Azure.

    :ivar identifier: Required. Unique identifier for the document.
    :vartype identifier: str
    :ivar custom_identifier: Optional identifier for the document that you can set to track the
     document in the Affinda system.  Is not required to be unique.
    :vartype custom_identifier: str
    :ivar file_name: Optional filename of the file.
    :vartype file_name: str
    :ivar ready: If true, the document has finished processing. Particularly useful if an endpoint
     request specified wait=False, when polling use this variable to determine when to stop polling.
    :vartype ready: bool
    :ivar ready_dt: The datetime when the document was ready.
    :vartype ready_dt: ~datetime.datetime
    :ivar failed: If true, some exception was raised during processing. Check the 'error' field of
     the main return object.
    :vartype failed: bool
    :ivar expiry_time: The date/time in ISO-8601 format when the document will be automatically
     deleted.  Defaults to no expiry.
    :vartype expiry_time: ~datetime.datetime
    :ivar language: The document's language.
    :vartype language: str
    :ivar pdf: The URL to the document's pdf (if the uploaded document is not already pdf, it's
     converted to pdf as part of the parsing process).
    :vartype pdf: str
    :ivar parent_document: If this document is part of a splitted document, this attribute points
     to the original document that this document is splitted from.
    :vartype parent_document: ~affinda.models.DocumentMetaParentDocument
    :ivar child_documents: If this document has been splitted into a number of child documents,
     this attribute points to those child documents.
    :vartype child_documents: list[~affinda.models.DocumentMetaChildDocumentsItem]
    :ivar pages: Required. The document's pages.
    :vartype pages: list[~affinda.models.PageMeta]
    :ivar is_ocrd:
    :vartype is_ocrd: bool
    :ivar ocr_confidence:
    :vartype ocr_confidence: float
    :ivar review_url:
    :vartype review_url: str
    :ivar document_type: The document type's identifier.  Provide if you already know the document
     type.
    :vartype document_type: str
    :ivar collection:
    :vartype collection: ~affinda.models.DocumentMetaCollection
    :ivar workspace: Required.
    :vartype workspace: ~affinda.models.DocumentMetaWorkspace
    :ivar archived_dt:
    :vartype archived_dt: ~datetime.datetime
    :ivar is_archived:
    :vartype is_archived: bool
    :ivar skip_parse:
    :vartype skip_parse: bool
    :ivar confirmed_dt:
    :vartype confirmed_dt: ~datetime.datetime
    :ivar confirmed_by:
    :vartype confirmed_by: ~affinda.models.UserNullable
    :ivar is_confirmed:
    :vartype is_confirmed: bool
    :ivar rejected_dt:
    :vartype rejected_dt: ~datetime.datetime
    :ivar rejected_by:
    :vartype rejected_by: ~affinda.models.UserNullable
    :ivar archived_by:
    :vartype archived_by: ~affinda.models.UserNullable
    :ivar is_rejected:
    :vartype is_rejected: bool
    :ivar created_dt:
    :vartype created_dt: ~datetime.datetime
    :ivar error_code:
    :vartype error_code: str
    :ivar error_detail:
    :vartype error_detail: str
    :ivar file: URL to view the file.
    :vartype file: str
    :ivar html: URL to view the file converted to HTML.
    :vartype html: str
    :ivar tags: A set of tags.
    :vartype tags: list[~affinda.models.Tag]
    :ivar created_by:
    :vartype created_by: ~affinda.models.User
    :ivar source_email: If the document is created via email ingestion, this field stores the email
     file's URL.
    :vartype source_email: str
    :ivar source_email_address: If the document is created via email ingestion, this field stores
     the email's From address.
    :vartype source_email_address: str
    :ivar region_bias:
    :vartype region_bias: ~affinda.models.RegionBias
    """

    _validation = {
        "identifier": {"required": True},
        "pages": {"required": True},
        "workspace": {"required": True},
    }

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "custom_identifier": {"key": "customIdentifier", "type": "str"},
        "file_name": {"key": "fileName", "type": "str"},
        "ready": {"key": "ready", "type": "bool"},
        "ready_dt": {"key": "readyDt", "type": "iso-8601"},
        "failed": {"key": "failed", "type": "bool"},
        "expiry_time": {"key": "expiryTime", "type": "iso-8601"},
        "language": {"key": "language", "type": "str"},
        "pdf": {"key": "pdf", "type": "str"},
        "parent_document": {"key": "parentDocument", "type": "DocumentMetaParentDocument"},
        "child_documents": {"key": "childDocuments", "type": "[DocumentMetaChildDocumentsItem]"},
        "pages": {"key": "pages", "type": "[PageMeta]"},
        "is_ocrd": {"key": "isOcrd", "type": "bool"},
        "ocr_confidence": {"key": "ocrConfidence", "type": "float"},
        "review_url": {"key": "reviewUrl", "type": "str"},
        "document_type": {"key": "documentType", "type": "str"},
        "collection": {"key": "collection", "type": "DocumentMetaCollection"},
        "workspace": {"key": "workspace", "type": "DocumentMetaWorkspace"},
        "archived_dt": {"key": "archivedDt", "type": "iso-8601"},
        "is_archived": {"key": "isArchived", "type": "bool"},
        "skip_parse": {"key": "skipParse", "type": "bool"},
        "confirmed_dt": {"key": "confirmedDt", "type": "iso-8601"},
        "confirmed_by": {"key": "confirmedBy", "type": "UserNullable"},
        "is_confirmed": {"key": "isConfirmed", "type": "bool"},
        "rejected_dt": {"key": "rejectedDt", "type": "iso-8601"},
        "rejected_by": {"key": "rejectedBy", "type": "UserNullable"},
        "archived_by": {"key": "archivedBy", "type": "UserNullable"},
        "is_rejected": {"key": "isRejected", "type": "bool"},
        "created_dt": {"key": "createdDt", "type": "iso-8601"},
        "error_code": {"key": "errorCode", "type": "str"},
        "error_detail": {"key": "errorDetail", "type": "str"},
        "file": {"key": "file", "type": "str"},
        "html": {"key": "html", "type": "str"},
        "tags": {"key": "tags", "type": "[Tag]"},
        "created_by": {"key": "createdBy", "type": "User"},
        "source_email": {"key": "sourceEmail", "type": "str"},
        "source_email_address": {"key": "sourceEmailAddress", "type": "str"},
        "region_bias": {"key": "regionBias", "type": "RegionBias"},
    }

    def __init__(
        self,
        *,
        identifier: str,
        pages: List["_models.PageMeta"],
        workspace: "_models.DocumentMetaWorkspace",
        custom_identifier: Optional[str] = None,
        file_name: Optional[str] = None,
        ready: Optional[bool] = None,
        ready_dt: Optional[datetime.datetime] = None,
        failed: Optional[bool] = None,
        expiry_time: Optional[datetime.datetime] = None,
        language: Optional[str] = None,
        pdf: Optional[str] = None,
        parent_document: Optional["_models.DocumentMetaParentDocument"] = None,
        child_documents: Optional[List["_models.DocumentMetaChildDocumentsItem"]] = None,
        is_ocrd: Optional[bool] = None,
        ocr_confidence: Optional[float] = None,
        review_url: Optional[str] = None,
        document_type: Optional[str] = None,
        collection: Optional["_models.DocumentMetaCollection"] = None,
        archived_dt: Optional[datetime.datetime] = None,
        is_archived: Optional[bool] = None,
        skip_parse: Optional[bool] = None,
        confirmed_dt: Optional[datetime.datetime] = None,
        confirmed_by: Optional["_models.UserNullable"] = None,
        is_confirmed: Optional[bool] = None,
        rejected_dt: Optional[datetime.datetime] = None,
        rejected_by: Optional["_models.UserNullable"] = None,
        archived_by: Optional["_models.UserNullable"] = None,
        is_rejected: Optional[bool] = None,
        created_dt: Optional[datetime.datetime] = None,
        error_code: Optional[str] = None,
        error_detail: Optional[str] = None,
        file: Optional[str] = None,
        html: Optional[str] = None,
        tags: Optional[List["_models.Tag"]] = None,
        created_by: Optional["_models.User"] = None,
        source_email: Optional[str] = None,
        source_email_address: Optional[str] = None,
        region_bias: Optional["_models.RegionBias"] = None,
        **kwargs,
    ):
        """
        :keyword identifier: Required. Unique identifier for the document.
        :paramtype identifier: str
        :keyword custom_identifier: Optional identifier for the document that you can set to track the
         document in the Affinda system.  Is not required to be unique.
        :paramtype custom_identifier: str
        :keyword file_name: Optional filename of the file.
        :paramtype file_name: str
        :keyword ready: If true, the document has finished processing. Particularly useful if an
         endpoint request specified wait=False, when polling use this variable to determine when to stop
         polling.
        :paramtype ready: bool
        :keyword ready_dt: The datetime when the document was ready.
        :paramtype ready_dt: ~datetime.datetime
        :keyword failed: If true, some exception was raised during processing. Check the 'error' field
         of the main return object.
        :paramtype failed: bool
        :keyword expiry_time: The date/time in ISO-8601 format when the document will be automatically
         deleted.  Defaults to no expiry.
        :paramtype expiry_time: ~datetime.datetime
        :keyword language: The document's language.
        :paramtype language: str
        :keyword pdf: The URL to the document's pdf (if the uploaded document is not already pdf, it's
         converted to pdf as part of the parsing process).
        :paramtype pdf: str
        :keyword parent_document: If this document is part of a splitted document, this attribute
         points to the original document that this document is splitted from.
        :paramtype parent_document: ~affinda.models.DocumentMetaParentDocument
        :keyword child_documents: If this document has been splitted into a number of child documents,
         this attribute points to those child documents.
        :paramtype child_documents: list[~affinda.models.DocumentMetaChildDocumentsItem]
        :keyword pages: Required. The document's pages.
        :paramtype pages: list[~affinda.models.PageMeta]
        :keyword is_ocrd:
        :paramtype is_ocrd: bool
        :keyword ocr_confidence:
        :paramtype ocr_confidence: float
        :keyword review_url:
        :paramtype review_url: str
        :keyword document_type: The document type's identifier.  Provide if you already know the
         document type.
        :paramtype document_type: str
        :keyword collection:
        :paramtype collection: ~affinda.models.DocumentMetaCollection
        :keyword workspace: Required.
        :paramtype workspace: ~affinda.models.DocumentMetaWorkspace
        :keyword archived_dt:
        :paramtype archived_dt: ~datetime.datetime
        :keyword is_archived:
        :paramtype is_archived: bool
        :keyword skip_parse:
        :paramtype skip_parse: bool
        :keyword confirmed_dt:
        :paramtype confirmed_dt: ~datetime.datetime
        :keyword confirmed_by:
        :paramtype confirmed_by: ~affinda.models.UserNullable
        :keyword is_confirmed:
        :paramtype is_confirmed: bool
        :keyword rejected_dt:
        :paramtype rejected_dt: ~datetime.datetime
        :keyword rejected_by:
        :paramtype rejected_by: ~affinda.models.UserNullable
        :keyword archived_by:
        :paramtype archived_by: ~affinda.models.UserNullable
        :keyword is_rejected:
        :paramtype is_rejected: bool
        :keyword created_dt:
        :paramtype created_dt: ~datetime.datetime
        :keyword error_code:
        :paramtype error_code: str
        :keyword error_detail:
        :paramtype error_detail: str
        :keyword file: URL to view the file.
        :paramtype file: str
        :keyword html: URL to view the file converted to HTML.
        :paramtype html: str
        :keyword tags: A set of tags.
        :paramtype tags: list[~affinda.models.Tag]
        :keyword created_by:
        :paramtype created_by: ~affinda.models.User
        :keyword source_email: If the document is created via email ingestion, this field stores the
         email file's URL.
        :paramtype source_email: str
        :keyword source_email_address: If the document is created via email ingestion, this field
         stores the email's From address.
        :paramtype source_email_address: str
        :keyword region_bias:
        :paramtype region_bias: ~affinda.models.RegionBias
        """
        super(DocumentMeta, self).__init__(**kwargs)
        self.identifier = identifier
        self.custom_identifier = custom_identifier
        self.file_name = file_name
        self.ready = ready
        self.ready_dt = ready_dt
        self.failed = failed
        self.expiry_time = expiry_time
        self.language = language
        self.pdf = pdf
        self.parent_document = parent_document
        self.child_documents = child_documents
        self.pages = pages
        self.is_ocrd = is_ocrd
        self.ocr_confidence = ocr_confidence
        self.review_url = review_url
        self.document_type = document_type
        self.collection = collection
        self.workspace = workspace
        self.archived_dt = archived_dt
        self.is_archived = is_archived
        self.skip_parse = skip_parse
        self.confirmed_dt = confirmed_dt
        self.confirmed_by = confirmed_by
        self.is_confirmed = is_confirmed
        self.rejected_dt = rejected_dt
        self.rejected_by = rejected_by
        self.archived_by = archived_by
        self.is_rejected = is_rejected
        self.created_dt = created_dt
        self.error_code = error_code
        self.error_detail = error_detail
        self.file = file
        self.html = html
        self.tags = tags
        self.created_by = created_by
        self.source_email = source_email
        self.source_email_address = source_email_address
        self.region_bias = region_bias


class DocumentMetaChildDocumentsItem(msrest.serialization.Model):
    """DocumentMetaChildDocumentsItem.

    :ivar identifier: Unique identifier for the document.
    :vartype identifier: str
    :ivar custom_identifier: Optional identifier for the document that you can set to track the
     document in the Affinda system.  Is not required to be unique.
    :vartype custom_identifier: str
    """

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "custom_identifier": {"key": "customIdentifier", "type": "str"},
    }

    def __init__(
        self,
        *,
        identifier: Optional[str] = None,
        custom_identifier: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword identifier: Unique identifier for the document.
        :paramtype identifier: str
        :keyword custom_identifier: Optional identifier for the document that you can set to track the
         document in the Affinda system.  Is not required to be unique.
        :paramtype custom_identifier: str
        """
        super(DocumentMetaChildDocumentsItem, self).__init__(**kwargs)
        self.identifier = identifier
        self.custom_identifier = custom_identifier


class DocumentMetaCollection(msrest.serialization.Model):
    """DocumentMetaCollection.

    All required parameters must be populated in order to send to Azure.

    :ivar identifier: Required. Uniquely identify a collection.
    :vartype identifier: str
    :ivar name:
    :vartype name: str
    :ivar extractor:
    :vartype extractor: ~affinda.models.DocumentMetaCollectionExtractor
    :ivar validation_rules:
    :vartype validation_rules: list[~affinda.models.ValidationRule]
    :ivar auto_refresh_validation_results: If True, validation results are refreshed whenever
     annotations are changed.
    :vartype auto_refresh_validation_results: bool
    """

    _validation = {
        "identifier": {"required": True},
    }

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "extractor": {"key": "extractor", "type": "DocumentMetaCollectionExtractor"},
        "validation_rules": {"key": "validationRules", "type": "[ValidationRule]"},
        "auto_refresh_validation_results": {"key": "autoRefreshValidationResults", "type": "bool"},
    }

    def __init__(
        self,
        *,
        identifier: str,
        name: Optional[str] = None,
        extractor: Optional["_models.DocumentMetaCollectionExtractor"] = None,
        validation_rules: Optional[List["_models.ValidationRule"]] = None,
        auto_refresh_validation_results: Optional[bool] = None,
        **kwargs,
    ):
        """
        :keyword identifier: Required. Uniquely identify a collection.
        :paramtype identifier: str
        :keyword name:
        :paramtype name: str
        :keyword extractor:
        :paramtype extractor: ~affinda.models.DocumentMetaCollectionExtractor
        :keyword validation_rules:
        :paramtype validation_rules: list[~affinda.models.ValidationRule]
        :keyword auto_refresh_validation_results: If True, validation results are refreshed whenever
         annotations are changed.
        :paramtype auto_refresh_validation_results: bool
        """
        super(DocumentMetaCollection, self).__init__(**kwargs)
        self.identifier = identifier
        self.name = name
        self.extractor = extractor
        self.validation_rules = validation_rules
        self.auto_refresh_validation_results = auto_refresh_validation_results


class DocumentMetaCollectionExtractor(msrest.serialization.Model):
    """DocumentMetaCollectionExtractor.

    :ivar identifier: Uniquely identify an extractor.
    :vartype identifier: str
    :ivar name:
    :vartype name: str
    :ivar base_extractor: Base extractor's identifier.
    :vartype base_extractor: str
    :ivar validatable:
    :vartype validatable: bool
    """

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "base_extractor": {"key": "baseExtractor", "type": "str"},
        "validatable": {"key": "validatable", "type": "bool"},
    }

    def __init__(
        self,
        *,
        identifier: Optional[str] = None,
        name: Optional[str] = None,
        base_extractor: Optional[str] = None,
        validatable: Optional[bool] = None,
        **kwargs,
    ):
        """
        :keyword identifier: Uniquely identify an extractor.
        :paramtype identifier: str
        :keyword name:
        :paramtype name: str
        :keyword base_extractor: Base extractor's identifier.
        :paramtype base_extractor: str
        :keyword validatable:
        :paramtype validatable: bool
        """
        super(DocumentMetaCollectionExtractor, self).__init__(**kwargs)
        self.identifier = identifier
        self.name = name
        self.base_extractor = base_extractor
        self.validatable = validatable


class DocumentMetaParentDocument(msrest.serialization.Model):
    """If this document is part of a splitted document, this attribute points to the original document that this document is splitted from.

    :ivar identifier: Unique identifier for the document.
    :vartype identifier: str
    :ivar custom_identifier: Optional identifier for the document that you can set to track the
     document in the Affinda system.  Is not required to be unique.
    :vartype custom_identifier: str
    """

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "custom_identifier": {"key": "customIdentifier", "type": "str"},
    }

    def __init__(
        self,
        *,
        identifier: Optional[str] = None,
        custom_identifier: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword identifier: Unique identifier for the document.
        :paramtype identifier: str
        :keyword custom_identifier: Optional identifier for the document that you can set to track the
         document in the Affinda system.  Is not required to be unique.
        :paramtype custom_identifier: str
        """
        super(DocumentMetaParentDocument, self).__init__(**kwargs)
        self.identifier = identifier
        self.custom_identifier = custom_identifier


class DocumentMetaWorkspace(msrest.serialization.Model):
    """DocumentMetaWorkspace.

    All required parameters must be populated in order to send to Azure.

    :ivar identifier: Required. Uniquely identify a workspace.
    :vartype identifier: str
    :ivar name:
    :vartype name: str
    """

    _validation = {
        "identifier": {"required": True},
    }

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, identifier: str, name: Optional[str] = None, **kwargs):
        """
        :keyword identifier: Required. Uniquely identify a workspace.
        :paramtype identifier: str
        :keyword name:
        :paramtype name: str
        """
        super(DocumentMetaWorkspace, self).__init__(**kwargs)
        self.identifier = identifier
        self.name = name


class DocumentSplit(msrest.serialization.Model):
    """Describe a split of a document.

    All required parameters must be populated in order to send to Azure.

    :ivar identifier: Anything.
    :vartype identifier: any
    :ivar pages: Required.
    :vartype pages: list[~affinda.models.DocumentSplitPage]
    """

    _validation = {
        "pages": {"required": True},
    }

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "object"},
        "pages": {"key": "pages", "type": "[DocumentSplitPage]"},
    }

    def __init__(
        self,
        *,
        pages: List["_models.DocumentSplitPage"],
        identifier: Optional[Any] = None,
        **kwargs,
    ):
        """
        :keyword identifier: Anything.
        :paramtype identifier: any
        :keyword pages: Required.
        :paramtype pages: list[~affinda.models.DocumentSplitPage]
        """
        super(DocumentSplit, self).__init__(**kwargs)
        self.identifier = identifier
        self.pages = pages


class DocumentSplitPage(msrest.serialization.Model):
    """List the pages within this split. Not including a page here will signal that the page should be deleted.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Page's ID.
    :vartype id: int
    :ivar rotation: Specify a degree of rotation if you want to rotate a page. Possitive number for
     clockwise rotation, and negative number for counter-clockwise rotation.
    :vartype rotation: int
    """

    _validation = {
        "id": {"required": True, "minimum": 1},
        "rotation": {"maximum": 360, "minimum": -360},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "rotation": {"key": "rotation", "type": "int"},
    }

    def __init__(self, *, id: int, rotation: Optional[int] = None, **kwargs):
        """
        :keyword id: Required. Page's ID.
        :paramtype id: int
        :keyword rotation: Specify a degree of rotation if you want to rotate a page. Possitive number
         for clockwise rotation, and negative number for counter-clockwise rotation.
        :paramtype rotation: int
        """
        super(DocumentSplitPage, self).__init__(**kwargs)
        self.id = id
        self.rotation = rotation


class DocumentSplitter(msrest.serialization.Model):
    """DocumentSplitter.

    All required parameters must be populated in order to send to Azure.

    :ivar identifier: Required. Uniquely identify a document splitter.
    :vartype identifier: str
    :ivar name: Required.
    :vartype name: str
    :ivar type: Required. The different types of document splitters. Known values are: "llm",
     "extractor", "keyword".
    :vartype type: str or ~affinda.models.DocumentSplitterType
    :ivar organization: Required. Uniquely identify an organization.
    :vartype organization: str
    :ivar extractor: Required. Uniquely identify an extractor.
    :vartype extractor: str
    :ivar llm_hint: Required. The hint about when to split which is passed into the LLM prompt.
    :vartype llm_hint: str
    """

    _validation = {
        "identifier": {"required": True},
        "name": {"required": True},
        "type": {"required": True},
        "organization": {"required": True},
        "extractor": {"required": True},
        "llm_hint": {"required": True},
    }

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "organization": {"key": "organization", "type": "str"},
        "extractor": {"key": "extractor", "type": "str"},
        "llm_hint": {"key": "llmHint", "type": "str"},
    }

    def __init__(
        self,
        *,
        identifier: str,
        name: str,
        type: Union[str, "_models.DocumentSplitterType"],
        organization: str,
        extractor: str,
        llm_hint: str,
        **kwargs,
    ):
        """
        :keyword identifier: Required. Uniquely identify a document splitter.
        :paramtype identifier: str
        :keyword name: Required.
        :paramtype name: str
        :keyword type: Required. The different types of document splitters. Known values are: "llm",
         "extractor", "keyword".
        :paramtype type: str or ~affinda.models.DocumentSplitterType
        :keyword organization: Required. Uniquely identify an organization.
        :paramtype organization: str
        :keyword extractor: Required. Uniquely identify an extractor.
        :paramtype extractor: str
        :keyword llm_hint: Required. The hint about when to split which is passed into the LLM prompt.
        :paramtype llm_hint: str
        """
        super(DocumentSplitter, self).__init__(**kwargs)
        self.identifier = identifier
        self.name = name
        self.type = type
        self.organization = organization
        self.extractor = extractor
        self.llm_hint = llm_hint


class DocumentType(msrest.serialization.Model):
    """DocumentType.

    All required parameters must be populated in order to send to Azure.

    :ivar identifier: Required. Uniquely identify a document type.
    :vartype identifier: str
    :ivar name: Required. The name of the document type.
    :vartype name: str
    :ivar description: A description of the document type.
    :vartype description: str
    :ivar ingest_email: The email address that can be used to email documents directly to this
     document type.
    :vartype ingest_email: str
    :ivar organization: Required. The identifier of the organization this document type belongs to.
    :vartype organization: str
    """

    _validation = {
        "identifier": {"required": True},
        "name": {"required": True},
        "organization": {"required": True},
    }

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "ingest_email": {"key": "ingest_email", "type": "str"},
        "organization": {"key": "organization", "type": "str"},
    }

    def __init__(
        self,
        *,
        identifier: str,
        name: str,
        organization: str,
        description: Optional[str] = None,
        ingest_email: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword identifier: Required. Uniquely identify a document type.
        :paramtype identifier: str
        :keyword name: Required. The name of the document type.
        :paramtype name: str
        :keyword description: A description of the document type.
        :paramtype description: str
        :keyword ingest_email: The email address that can be used to email documents directly to this
         document type.
        :paramtype ingest_email: str
        :keyword organization: Required. The identifier of the organization this document type belongs
         to.
        :paramtype organization: str
        """
        super(DocumentType, self).__init__(**kwargs)
        self.identifier = identifier
        self.name = name
        self.description = description
        self.ingest_email = ingest_email
        self.organization = organization


class DocumentTypeCreate(msrest.serialization.Model):
    """DocumentTypeCreate.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the document type.
    :vartype name: str
    :ivar description: A description of the document type.
    :vartype description: str
    :ivar organization: Required. The identifier of the organization this document type belongs to.
    :vartype organization: str
    """

    _validation = {
        "name": {"required": True},
        "organization": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "organization": {"key": "organization", "type": "str"},
    }

    def __init__(
        self, *, name: str, organization: str, description: Optional[str] = None, **kwargs
    ):
        """
        :keyword name: Required. The name of the document type.
        :paramtype name: str
        :keyword description: A description of the document type.
        :paramtype description: str
        :keyword organization: Required. The identifier of the organization this document type belongs
         to.
        :paramtype organization: str
        """
        super(DocumentTypeCreate, self).__init__(**kwargs)
        self.name = name
        self.description = description
        self.organization = organization


class DocumentTypeUpdate(msrest.serialization.Model):
    """DocumentTypeUpdate.

    :ivar name: The new name of the document type.
    :vartype name: str
    :ivar description: A new description of the document type.
    :vartype description: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, description: Optional[str] = None, **kwargs):
        """
        :keyword name: The new name of the document type.
        :paramtype name: str
        :keyword description: A new description of the document type.
        :paramtype description: str
        """
        super(DocumentTypeUpdate, self).__init__(**kwargs)
        self.name = name
        self.description = description


class DocumentUpdate(msrest.serialization.Model):
    """DocumentUpdate.

    :ivar collection: Uniquely identify a collection.
    :vartype collection: str
    :ivar workspace: Uniquely identify a workspace.
    :vartype workspace: str
    :ivar document_type: The document type's identifier.  Provide if you already know the document
     type.
    :vartype document_type: str
    :ivar file_name: Optional filename of the file.
    :vartype file_name: str
    :ivar expiry_time: The date/time in ISO-8601 format when the document will be automatically
     deleted.  Defaults to no expiry.
    :vartype expiry_time: ~datetime.datetime
    :ivar is_confirmed:
    :vartype is_confirmed: bool
    :ivar is_rejected:
    :vartype is_rejected: bool
    :ivar is_archived:
    :vartype is_archived: bool
    :ivar skip_parse:
    :vartype skip_parse: bool
    :ivar language: Language code in ISO 639-1 format. Must specify zh-cn or zh-tw for Chinese.
    :vartype language: str
    :ivar identifier: Deprecated in favor of ``customIdentifier``.
    :vartype identifier: str
    :ivar custom_identifier: Specify a custom identifier for the document if you need one, not
     required to be unique.
    :vartype custom_identifier: str
    :ivar warning_messages:
    :vartype warning_messages: list[~affinda.models.DocumentWarning]
    """

    _attribute_map = {
        "collection": {"key": "collection", "type": "str"},
        "workspace": {"key": "workspace", "type": "str"},
        "document_type": {"key": "documentType", "type": "str"},
        "file_name": {"key": "fileName", "type": "str"},
        "expiry_time": {"key": "expiryTime", "type": "iso-8601"},
        "is_confirmed": {"key": "isConfirmed", "type": "bool"},
        "is_rejected": {"key": "isRejected", "type": "bool"},
        "is_archived": {"key": "isArchived", "type": "bool"},
        "skip_parse": {"key": "skipParse", "type": "bool"},
        "language": {"key": "language", "type": "str"},
        "identifier": {"key": "identifier", "type": "str"},
        "custom_identifier": {"key": "customIdentifier", "type": "str"},
        "warning_messages": {"key": "warningMessages", "type": "[DocumentWarning]"},
    }

    def __init__(
        self,
        *,
        collection: Optional[str] = None,
        workspace: Optional[str] = None,
        document_type: Optional[str] = None,
        file_name: Optional[str] = None,
        expiry_time: Optional[datetime.datetime] = None,
        is_confirmed: Optional[bool] = None,
        is_rejected: Optional[bool] = None,
        is_archived: Optional[bool] = None,
        skip_parse: Optional[bool] = None,
        language: Optional[str] = None,
        identifier: Optional[str] = None,
        custom_identifier: Optional[str] = None,
        warning_messages: Optional[List["_models.DocumentWarning"]] = None,
        **kwargs,
    ):
        """
        :keyword collection: Uniquely identify a collection.
        :paramtype collection: str
        :keyword workspace: Uniquely identify a workspace.
        :paramtype workspace: str
        :keyword document_type: The document type's identifier.  Provide if you already know the
         document type.
        :paramtype document_type: str
        :keyword file_name: Optional filename of the file.
        :paramtype file_name: str
        :keyword expiry_time: The date/time in ISO-8601 format when the document will be automatically
         deleted.  Defaults to no expiry.
        :paramtype expiry_time: ~datetime.datetime
        :keyword is_confirmed:
        :paramtype is_confirmed: bool
        :keyword is_rejected:
        :paramtype is_rejected: bool
        :keyword is_archived:
        :paramtype is_archived: bool
        :keyword skip_parse:
        :paramtype skip_parse: bool
        :keyword language: Language code in ISO 639-1 format. Must specify zh-cn or zh-tw for Chinese.
        :paramtype language: str
        :keyword identifier: Deprecated in favor of ``customIdentifier``.
        :paramtype identifier: str
        :keyword custom_identifier: Specify a custom identifier for the document if you need one, not
         required to be unique.
        :paramtype custom_identifier: str
        :keyword warning_messages:
        :paramtype warning_messages: list[~affinda.models.DocumentWarning]
        """
        super(DocumentUpdate, self).__init__(**kwargs)
        self.collection = collection
        self.workspace = workspace
        self.document_type = document_type
        self.file_name = file_name
        self.expiry_time = expiry_time
        self.is_confirmed = is_confirmed
        self.is_rejected = is_rejected
        self.is_archived = is_archived
        self.skip_parse = skip_parse
        self.language = language
        self.identifier = identifier
        self.custom_identifier = custom_identifier
        self.warning_messages = warning_messages


class DocumentWarning(msrest.serialization.Model):
    """DocumentWarning.

    :ivar warning_code:
    :vartype warning_code: str
    :ivar warning_detail:
    :vartype warning_detail: str
    """

    _attribute_map = {
        "warning_code": {"key": "warningCode", "type": "str"},
        "warning_detail": {"key": "warningDetail", "type": "str"},
    }

    def __init__(
        self, *, warning_code: Optional[str] = None, warning_detail: Optional[str] = None, **kwargs
    ):
        """
        :keyword warning_code:
        :paramtype warning_code: str
        :keyword warning_detail:
        :paramtype warning_detail: str
        """
        super(DocumentWarning, self).__init__(**kwargs)
        self.warning_code = warning_code
        self.warning_detail = warning_detail


class Education(msrest.serialization.Model):
    """Education.

    :ivar id:
    :vartype id: int
    :ivar organization:
    :vartype organization: str
    :ivar accreditation:
    :vartype accreditation: ~affinda.models.Accreditation
    :ivar grade:
    :vartype grade: ~affinda.models.EducationGrade
    :ivar location:
    :vartype location: ~affinda.models.Location
    :ivar dates:
    :vartype dates: ~affinda.models.EducationDates
    """

    _validation = {
        "id": {"minimum": 1},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "organization": {"key": "organization", "type": "str"},
        "accreditation": {"key": "accreditation", "type": "Accreditation"},
        "grade": {"key": "grade", "type": "EducationGrade"},
        "location": {"key": "location", "type": "Location"},
        "dates": {"key": "dates", "type": "EducationDates"},
    }

    def __init__(
        self,
        *,
        id: Optional[int] = None,
        organization: Optional[str] = None,
        accreditation: Optional["_models.Accreditation"] = None,
        grade: Optional["_models.EducationGrade"] = None,
        location: Optional["_models.Location"] = None,
        dates: Optional["_models.EducationDates"] = None,
        **kwargs,
    ):
        """
        :keyword id:
        :paramtype id: int
        :keyword organization:
        :paramtype organization: str
        :keyword accreditation:
        :paramtype accreditation: ~affinda.models.Accreditation
        :keyword grade:
        :paramtype grade: ~affinda.models.EducationGrade
        :keyword location:
        :paramtype location: ~affinda.models.Location
        :keyword dates:
        :paramtype dates: ~affinda.models.EducationDates
        """
        super(Education, self).__init__(**kwargs)
        self.id = id
        self.organization = organization
        self.accreditation = accreditation
        self.grade = grade
        self.location = location
        self.dates = dates


class EducationDates(msrest.serialization.Model):
    """EducationDates.

    :ivar completion_date:
    :vartype completion_date: ~datetime.date
    :ivar is_current:
    :vartype is_current: bool
    :ivar start_date:
    :vartype start_date: ~datetime.date
    :ivar raw_text:
    :vartype raw_text: str
    """

    _attribute_map = {
        "completion_date": {"key": "completionDate", "type": "date"},
        "is_current": {"key": "isCurrent", "type": "bool"},
        "start_date": {"key": "startDate", "type": "date"},
        "raw_text": {"key": "rawText", "type": "str"},
    }

    def __init__(
        self,
        *,
        completion_date: Optional[datetime.date] = None,
        is_current: Optional[bool] = None,
        start_date: Optional[datetime.date] = None,
        raw_text: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword completion_date:
        :paramtype completion_date: ~datetime.date
        :keyword is_current:
        :paramtype is_current: bool
        :keyword start_date:
        :paramtype start_date: ~datetime.date
        :keyword raw_text:
        :paramtype raw_text: str
        """
        super(EducationDates, self).__init__(**kwargs)
        self.completion_date = completion_date
        self.is_current = is_current
        self.start_date = start_date
        self.raw_text = raw_text


class EducationGrade(msrest.serialization.Model):
    """EducationGrade.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar raw:
    :vartype raw: str
    :ivar metric:
    :vartype metric: str
    :ivar value:
    :vartype value: str
    """

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "raw": {"key": "raw", "type": "str"},
        "metric": {"key": "metric", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        raw: Optional[str] = None,
        metric: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword raw:
        :paramtype raw: str
        :keyword metric:
        :paramtype metric: str
        :keyword value:
        :paramtype value: str
        """
        super(EducationGrade, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.raw = raw
        self.metric = metric
        self.value = value


class EducationSearchScoreComponent(msrest.serialization.Model):
    """EducationSearchScoreComponent.

    All required parameters must be populated in order to send to Azure.

    :ivar value:
    :vartype value: str
    :ivar label: Required.
    :vartype label: str
    :ivar score:
    :vartype score: float
    """

    _validation = {
        "label": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "score": {"key": "score", "type": "float"},
    }

    def __init__(
        self, *, label: str, value: Optional[str] = None, score: Optional[float] = None, **kwargs
    ):
        """
        :keyword value:
        :paramtype value: str
        :keyword label: Required.
        :paramtype label: str
        :keyword score:
        :paramtype score: float
        """
        super(EducationSearchScoreComponent, self).__init__(**kwargs)
        self.value = value
        self.label = label
        self.score = score


class ExpectedRemunerationAnnotation(Annotation):
    """ExpectedRemunerationAnnotation.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required. Annotation's ID.
    :vartype id: int
    :ivar rectangle: Required. x/y coordinates for the rectangular bounding box containing the
     data.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required. x/y coordinates for the rectangles containing the data. An
     annotation can be contained within multiple rectangles.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar document: Required. Unique identifier for the document.
    :vartype document: str
    :ivar page_index: Required. The page number within the document, starting from 0.
    :vartype page_index: int
    :ivar raw: Required. Raw data extracted from the before any post-processing.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required. Indicates whether the data has been validated, either by a human
     using our validation tool or through auto-validation rules.
    :vartype is_verified: bool
    :ivar is_client_verified: Required. Indicates whether the data has been validated by a human.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required. Indicates whether the data has been auto-validated.
    :vartype is_auto_verified: bool
    :ivar data_point: Data point's identifier.
    :vartype data_point: str
    :ivar field: Field's identifier.
    :vartype field: str
    :ivar content_type: Required. The different data types of annotations. Known values are:
     "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
     "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
     "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
    :vartype content_type: str or ~affinda.models.AnnotationContentType
    :ivar parent: The parent annotation's ID.
    :vartype parent: int
    :ivar parsed:
    :vartype parsed: ~affinda.models.ExpectedRemunerationAnnotationParsed
    """

    _validation = {
        "id": {"required": True, "minimum": 1},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "document": {"required": True},
        "page_index": {"required": True, "minimum": 0},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "document": {"key": "document", "type": "str"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "field": {"key": "field", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parent": {"key": "parent", "type": "int"},
        "parsed": {"key": "parsed", "type": "ExpectedRemunerationAnnotationParsed"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        document: str,
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        content_type: Union[str, "_models.AnnotationContentType"],
        additional_properties: Optional[Dict[str, Any]] = None,
        data_point: Optional[str] = None,
        field: Optional[str] = None,
        parent: Optional[int] = None,
        parsed: Optional["_models.ExpectedRemunerationAnnotationParsed"] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required. Annotation's ID.
        :paramtype id: int
        :keyword rectangle: Required. x/y coordinates for the rectangular bounding box containing the
         data.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required. x/y coordinates for the rectangles containing the data. An
         annotation can be contained within multiple rectangles.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword document: Required. Unique identifier for the document.
        :paramtype document: str
        :keyword page_index: Required. The page number within the document, starting from 0.
        :paramtype page_index: int
        :keyword raw: Required. Raw data extracted from the before any post-processing.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required. Indicates whether the data has been validated, either by a
         human using our validation tool or through auto-validation rules.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required. Indicates whether the data has been validated by a
         human.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required. Indicates whether the data has been auto-validated.
        :paramtype is_auto_verified: bool
        :keyword data_point: Data point's identifier.
        :paramtype data_point: str
        :keyword field: Field's identifier.
        :paramtype field: str
        :keyword content_type: Required. The different data types of annotations. Known values are:
         "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
         "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
         "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
        :paramtype content_type: str or ~affinda.models.AnnotationContentType
        :keyword parent: The parent annotation's ID.
        :paramtype parent: int
        :keyword parsed:
        :paramtype parsed: ~affinda.models.ExpectedRemunerationAnnotationParsed
        """
        super(ExpectedRemunerationAnnotation, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            document=document,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            field=field,
            content_type=content_type,
            parent=parent,
            **kwargs,
        )
        self.parsed = parsed


class ExpectedRemunerationAnnotationParsed(msrest.serialization.Model):
    """ExpectedRemunerationAnnotationParsed.

    :ivar minimum:
    :vartype minimum: float
    :ivar maximum:
    :vartype maximum: float
    :ivar currency:
    :vartype currency: str
    :ivar unit:
    :vartype unit: str
    """

    _attribute_map = {
        "minimum": {"key": "minimum", "type": "float"},
        "maximum": {"key": "maximum", "type": "float"},
        "currency": {"key": "currency", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
    }

    def __init__(
        self,
        *,
        minimum: Optional[float] = None,
        maximum: Optional[float] = None,
        currency: Optional[str] = None,
        unit: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword minimum:
        :paramtype minimum: float
        :keyword maximum:
        :paramtype maximum: float
        :keyword currency:
        :paramtype currency: str
        :keyword unit:
        :paramtype unit: str
        """
        super(ExpectedRemunerationAnnotationParsed, self).__init__(**kwargs)
        self.minimum = minimum
        self.maximum = maximum
        self.currency = currency
        self.unit = unit


class ExpectedRemunerationAnnotationUpdate(AnnotationBase):
    """ExpectedRemunerationAnnotationUpdate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id:
    :vartype id: int
    :ivar rectangle:
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles:
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index:
    :vartype page_index: int
    :ivar raw:
    :vartype raw: str
    :ivar confidence: The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: The model's confidence that the text has been classified
     correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: If the document was submitted as an image, this is the
     confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified:
    :vartype is_verified: bool
    :ivar is_client_verified:
    :vartype is_client_verified: bool
    :ivar is_auto_verified:
    :vartype is_auto_verified: bool
    :ivar data_point:
    :vartype data_point: str
    :ivar content_type:
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: ~affinda.models.ExpectedRemunerationAnnotationUpdateParsed
    """

    _validation = {
        "rectangles": {"readonly": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "ExpectedRemunerationAnnotationUpdateParsed"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        id: Optional[int] = None,
        rectangle: Optional["_models.Rectangle"] = None,
        page_index: Optional[int] = None,
        raw: Optional[str] = None,
        confidence: Optional[float] = None,
        classification_confidence: Optional[float] = None,
        text_extraction_confidence: Optional[float] = None,
        is_verified: Optional[bool] = None,
        is_client_verified: Optional[bool] = None,
        is_auto_verified: Optional[bool] = None,
        data_point: Optional[str] = None,
        content_type: Optional[str] = None,
        parsed: Optional["_models.ExpectedRemunerationAnnotationUpdateParsed"] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id:
        :paramtype id: int
        :keyword rectangle:
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword page_index:
        :paramtype page_index: int
        :keyword raw:
        :paramtype raw: str
        :keyword confidence: The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: The model's confidence that the text has been classified
         correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: If the document was submitted as an image, this is the
         confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified:
        :paramtype is_verified: bool
        :keyword is_client_verified:
        :paramtype is_client_verified: bool
        :keyword is_auto_verified:
        :paramtype is_auto_verified: bool
        :keyword data_point:
        :paramtype data_point: str
        :keyword content_type:
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: ~affinda.models.ExpectedRemunerationAnnotationUpdateParsed
        """
        super(ExpectedRemunerationAnnotationUpdate, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            **kwargs,
        )
        self.parsed = parsed


class ExpectedRemunerationAnnotationUpdateParsed(msrest.serialization.Model):
    """ExpectedRemunerationAnnotationUpdateParsed.

    :ivar minimum:
    :vartype minimum: float
    :ivar maximum:
    :vartype maximum: float
    :ivar currency:
    :vartype currency: str
    :ivar unit:
    :vartype unit: str
    """

    _attribute_map = {
        "minimum": {"key": "minimum", "type": "float"},
        "maximum": {"key": "maximum", "type": "float"},
        "currency": {"key": "currency", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
    }

    def __init__(
        self,
        *,
        minimum: Optional[float] = None,
        maximum: Optional[float] = None,
        currency: Optional[str] = None,
        unit: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword minimum:
        :paramtype minimum: float
        :keyword maximum:
        :paramtype maximum: float
        :keyword currency:
        :paramtype currency: str
        :keyword unit:
        :paramtype unit: str
        """
        super(ExpectedRemunerationAnnotationUpdateParsed, self).__init__(**kwargs)
        self.minimum = minimum
        self.maximum = maximum
        self.currency = currency
        self.unit = unit


class ExperienceSearchScoreComponent(msrest.serialization.Model):
    """ExperienceSearchScoreComponent.

    All required parameters must be populated in order to send to Azure.

    :ivar value:
    :vartype value: str
    :ivar label: Required.
    :vartype label: str
    :ivar score:
    :vartype score: float
    """

    _validation = {
        "label": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "score": {"key": "score", "type": "float"},
    }

    def __init__(
        self, *, label: str, value: Optional[str] = None, score: Optional[float] = None, **kwargs
    ):
        """
        :keyword value:
        :paramtype value: str
        :keyword label: Required.
        :paramtype label: str
        :keyword score:
        :paramtype score: float
        """
        super(ExperienceSearchScoreComponent, self).__init__(**kwargs)
        self.value = value
        self.label = label
        self.score = score


class Extractor(msrest.serialization.Model):
    """Extractor.

    All required parameters must be populated in order to send to Azure.

    :ivar identifier: Required. Uniquely identify an extractor.
    :vartype identifier: str
    :ivar name: Required.
    :vartype name: str
    :ivar name_plural: Required.
    :vartype name_plural: str
    :ivar base_extractor:
    :vartype base_extractor: ~affinda.models.ExtractorBaseExtractor
    :ivar organization:
    :vartype organization: ~affinda.models.Organization
    :ivar category:
    :vartype category: str
    :ivar validatable: Required.
    :vartype validatable: bool
    :ivar is_custom:
    :vartype is_custom: bool
    :ivar field_groups:
    :vartype field_groups: list[~affinda.models.FieldGroup]
    :ivar created_dt:
    :vartype created_dt: ~datetime.datetime
    :ivar last_trained_dt:
    :vartype last_trained_dt: ~datetime.datetime
    """

    _validation = {
        "identifier": {"required": True},
        "name": {"required": True},
        "name_plural": {"required": True},
        "validatable": {"required": True},
    }

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "name_plural": {"key": "namePlural", "type": "str"},
        "base_extractor": {"key": "baseExtractor", "type": "ExtractorBaseExtractor"},
        "organization": {"key": "organization", "type": "Organization"},
        "category": {"key": "category", "type": "str"},
        "validatable": {"key": "validatable", "type": "bool"},
        "is_custom": {"key": "isCustom", "type": "bool"},
        "field_groups": {"key": "fieldGroups", "type": "[FieldGroup]"},
        "created_dt": {"key": "createdDt", "type": "iso-8601"},
        "last_trained_dt": {"key": "lastTrainedDt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        identifier: str,
        name: str,
        name_plural: str,
        validatable: bool,
        base_extractor: Optional["_models.ExtractorBaseExtractor"] = None,
        organization: Optional["_models.Organization"] = None,
        category: Optional[str] = None,
        is_custom: Optional[bool] = None,
        field_groups: Optional[List["_models.FieldGroup"]] = None,
        created_dt: Optional[datetime.datetime] = None,
        last_trained_dt: Optional[datetime.datetime] = None,
        **kwargs,
    ):
        """
        :keyword identifier: Required. Uniquely identify an extractor.
        :paramtype identifier: str
        :keyword name: Required.
        :paramtype name: str
        :keyword name_plural: Required.
        :paramtype name_plural: str
        :keyword base_extractor:
        :paramtype base_extractor: ~affinda.models.ExtractorBaseExtractor
        :keyword organization:
        :paramtype organization: ~affinda.models.Organization
        :keyword category:
        :paramtype category: str
        :keyword validatable: Required.
        :paramtype validatable: bool
        :keyword is_custom:
        :paramtype is_custom: bool
        :keyword field_groups:
        :paramtype field_groups: list[~affinda.models.FieldGroup]
        :keyword created_dt:
        :paramtype created_dt: ~datetime.datetime
        :keyword last_trained_dt:
        :paramtype last_trained_dt: ~datetime.datetime
        """
        super(Extractor, self).__init__(**kwargs)
        self.identifier = identifier
        self.name = name
        self.name_plural = name_plural
        self.base_extractor = base_extractor
        self.organization = organization
        self.category = category
        self.validatable = validatable
        self.is_custom = is_custom
        self.field_groups = field_groups
        self.created_dt = created_dt
        self.last_trained_dt = last_trained_dt


class ExtractorBaseExtractor(msrest.serialization.Model):
    """ExtractorBaseExtractor.

    All required parameters must be populated in order to send to Azure.

    :ivar identifier: Required. Uniquely identify an extractor.
    :vartype identifier: str
    :ivar name: Required.
    :vartype name: str
    :ivar name_plural: Required.
    :vartype name_plural: str
    :ivar validatable: Required.
    :vartype validatable: bool
    :ivar is_custom:
    :vartype is_custom: bool
    :ivar created_dt:
    :vartype created_dt: ~datetime.datetime
    """

    _validation = {
        "identifier": {"required": True},
        "name": {"required": True},
        "name_plural": {"required": True},
        "validatable": {"required": True},
    }

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "name_plural": {"key": "namePlural", "type": "str"},
        "validatable": {"key": "validatable", "type": "bool"},
        "is_custom": {"key": "isCustom", "type": "bool"},
        "created_dt": {"key": "createdDt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        identifier: str,
        name: str,
        name_plural: str,
        validatable: bool,
        is_custom: Optional[bool] = None,
        created_dt: Optional[datetime.datetime] = None,
        **kwargs,
    ):
        """
        :keyword identifier: Required. Uniquely identify an extractor.
        :paramtype identifier: str
        :keyword name: Required.
        :paramtype name: str
        :keyword name_plural: Required.
        :paramtype name_plural: str
        :keyword validatable: Required.
        :paramtype validatable: bool
        :keyword is_custom:
        :paramtype is_custom: bool
        :keyword created_dt:
        :paramtype created_dt: ~datetime.datetime
        """
        super(ExtractorBaseExtractor, self).__init__(**kwargs)
        self.identifier = identifier
        self.name = name
        self.name_plural = name_plural
        self.validatable = validatable
        self.is_custom = is_custom
        self.created_dt = created_dt


class ExtractorConfig(msrest.serialization.Model):
    """Extra configurations specific to an extractor.

    :ivar resume_redact:
    :vartype resume_redact: ~affinda.models.RedactConfig
    """

    _attribute_map = {
        "resume_redact": {"key": "resumeRedact", "type": "RedactConfig"},
    }

    def __init__(self, *, resume_redact: Optional["_models.RedactConfig"] = None, **kwargs):
        """
        :keyword resume_redact:
        :paramtype resume_redact: ~affinda.models.RedactConfig
        """
        super(ExtractorConfig, self).__init__(**kwargs)
        self.resume_redact = resume_redact


class ExtractorCreate(msrest.serialization.Model):
    """ExtractorCreate.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required.
    :vartype name: str
    :ivar name_plural:
    :vartype name_plural: str
    :ivar base_extractor: Uniquely identify an extractor.
    :vartype base_extractor: str
    :ivar organization: Required. Uniquely identify an organization.
    :vartype organization: str
    :ivar category:
    :vartype category: str
    :ivar validatable:
    :vartype validatable: bool
    :ivar field_groups:
    :vartype field_groups: list[~affinda.models.FieldGroup]
    """

    _validation = {
        "name": {"required": True},
        "organization": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "name_plural": {"key": "namePlural", "type": "str"},
        "base_extractor": {"key": "baseExtractor", "type": "str"},
        "organization": {"key": "organization", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "validatable": {"key": "validatable", "type": "bool"},
        "field_groups": {"key": "fieldGroups", "type": "[FieldGroup]"},
    }

    def __init__(
        self,
        *,
        name: str,
        organization: str,
        name_plural: Optional[str] = None,
        base_extractor: Optional[str] = None,
        category: Optional[str] = None,
        validatable: Optional[bool] = None,
        field_groups: Optional[List["_models.FieldGroup"]] = None,
        **kwargs,
    ):
        """
        :keyword name: Required.
        :paramtype name: str
        :keyword name_plural:
        :paramtype name_plural: str
        :keyword base_extractor: Uniquely identify an extractor.
        :paramtype base_extractor: str
        :keyword organization: Required. Uniquely identify an organization.
        :paramtype organization: str
        :keyword category:
        :paramtype category: str
        :keyword validatable:
        :paramtype validatable: bool
        :keyword field_groups:
        :paramtype field_groups: list[~affinda.models.FieldGroup]
        """
        super(ExtractorCreate, self).__init__(**kwargs)
        self.name = name
        self.name_plural = name_plural
        self.base_extractor = base_extractor
        self.organization = organization
        self.category = category
        self.validatable = validatable
        self.field_groups = field_groups


class ExtractorUpdate(msrest.serialization.Model):
    """ExtractorUpdate.

    :ivar name:
    :vartype name: str
    :ivar name_plural:
    :vartype name_plural: str
    :ivar base_extractor: Uniquely identify an extractor.
    :vartype base_extractor: str
    :ivar category:
    :vartype category: str
    :ivar validatable:
    :vartype validatable: bool
    :ivar field_groups:
    :vartype field_groups: list[~affinda.models.FieldGroup]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "name_plural": {"key": "namePlural", "type": "str"},
        "base_extractor": {"key": "baseExtractor", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "validatable": {"key": "validatable", "type": "bool"},
        "field_groups": {"key": "fieldGroups", "type": "[FieldGroup]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        name_plural: Optional[str] = None,
        base_extractor: Optional[str] = None,
        category: Optional[str] = None,
        validatable: Optional[bool] = None,
        field_groups: Optional[List["_models.FieldGroup"]] = None,
        **kwargs,
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword name_plural:
        :paramtype name_plural: str
        :keyword base_extractor: Uniquely identify an extractor.
        :paramtype base_extractor: str
        :keyword category:
        :paramtype category: str
        :keyword validatable:
        :paramtype validatable: bool
        :keyword field_groups:
        :paramtype field_groups: list[~affinda.models.FieldGroup]
        """
        super(ExtractorUpdate, self).__init__(**kwargs)
        self.name = name
        self.name_plural = name_plural
        self.base_extractor = base_extractor
        self.category = category
        self.validatable = validatable
        self.field_groups = field_groups


class Field(msrest.serialization.Model):
    """Field.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar label: Required.
    :vartype label: str
    :ivar data_point: Required. Data point identifier.
    :vartype data_point: str
    :ivar field_type: Required. The different data types of annotations. Known values are: "text",
     "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum", "location",
     "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language", "skill",
     "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
    :vartype field_type: str or ~affinda.models.AnnotationContentType
    :ivar data_source: Data source mapping identifier.
    :vartype data_source: str
    :ivar mapping: Defines how the data point is mapped to the data source.
    :vartype mapping: str
    :ivar mandatory:
    :vartype mandatory: bool
    :ivar auto_validation_threshold: Threshold for auto validation. If null, uses the collection's
     autoValidationThreshold.
    :vartype auto_validation_threshold: float
    :ivar enable_auto_validation_threshold: If true, the autoValidationThreshold enable auto
     validation from the threshold from this field if specified, else from the collection.
    :vartype enable_auto_validation_threshold: bool
    :ivar show_dropdown:
    :vartype show_dropdown: bool
    :ivar display_enum_value: If true, both the value and the label for the enums will appear in
     the dropdown in the validation tool.
    :vartype display_enum_value: bool
    :ivar hide_enum_detail: If true, the hoverable enum value detail icon will be hidden.
    :vartype hide_enum_detail: bool
    :ivar drop_null: If True, any dropdown annotations that fail to parse to a value will be
     discarded.
    :vartype drop_null: bool
    :ivar enabled_child_fields:
    :vartype enabled_child_fields: list[~affinda.models.Field]
    :ivar disabled_child_fields:
    :vartype disabled_child_fields: list[~affinda.models.Field]
    :ivar slug:
    :vartype slug: str
    :ivar display_raw_text: If true, then the validation tool will show the user the raw text found
     on the page, not the value that has been parsed to a specific type.
    :vartype display_raw_text: bool
    :ivar fields:
    :vartype fields: list[any]
    """

    _validation = {
        "label": {"required": True},
        "data_point": {"required": True},
        "field_type": {"required": True},
        "auto_validation_threshold": {"maximum": 1, "minimum": 0},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "label": {"key": "label", "type": "str"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "field_type": {"key": "fieldType", "type": "str"},
        "data_source": {"key": "dataSource", "type": "str"},
        "mapping": {"key": "mapping", "type": "str"},
        "mandatory": {"key": "mandatory", "type": "bool"},
        "auto_validation_threshold": {"key": "autoValidationThreshold", "type": "float"},
        "enable_auto_validation_threshold": {
            "key": "enableAutoValidationThreshold",
            "type": "bool",
        },
        "show_dropdown": {"key": "showDropdown", "type": "bool"},
        "display_enum_value": {"key": "displayEnumValue", "type": "bool"},
        "hide_enum_detail": {"key": "hideEnumDetail", "type": "bool"},
        "drop_null": {"key": "dropNull", "type": "bool"},
        "enabled_child_fields": {"key": "enabledChildFields", "type": "[Field]"},
        "disabled_child_fields": {"key": "disabledChildFields", "type": "[Field]"},
        "slug": {"key": "slug", "type": "str"},
        "display_raw_text": {"key": "displayRawText", "type": "bool"},
        "fields": {"key": "fields", "type": "[object]"},
    }

    def __init__(
        self,
        *,
        label: str,
        data_point: str,
        field_type: Union[str, "_models.AnnotationContentType"],
        additional_properties: Optional[Dict[str, Any]] = None,
        data_source: Optional[str] = None,
        mapping: Optional[str] = None,
        mandatory: Optional[bool] = None,
        auto_validation_threshold: Optional[float] = None,
        enable_auto_validation_threshold: Optional[bool] = None,
        show_dropdown: Optional[bool] = None,
        display_enum_value: Optional[bool] = None,
        hide_enum_detail: Optional[bool] = None,
        drop_null: Optional[bool] = None,
        enabled_child_fields: Optional[List["_models.Field"]] = None,
        disabled_child_fields: Optional[List["_models.Field"]] = None,
        slug: Optional[str] = None,
        display_raw_text: Optional[bool] = None,
        fields: Optional[List[Any]] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword label: Required.
        :paramtype label: str
        :keyword data_point: Required. Data point identifier.
        :paramtype data_point: str
        :keyword field_type: Required. The different data types of annotations. Known values are:
         "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
         "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
         "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
        :paramtype field_type: str or ~affinda.models.AnnotationContentType
        :keyword data_source: Data source mapping identifier.
        :paramtype data_source: str
        :keyword mapping: Defines how the data point is mapped to the data source.
        :paramtype mapping: str
        :keyword mandatory:
        :paramtype mandatory: bool
        :keyword auto_validation_threshold: Threshold for auto validation. If null, uses the
         collection's autoValidationThreshold.
        :paramtype auto_validation_threshold: float
        :keyword enable_auto_validation_threshold: If true, the autoValidationThreshold enable auto
         validation from the threshold from this field if specified, else from the collection.
        :paramtype enable_auto_validation_threshold: bool
        :keyword show_dropdown:
        :paramtype show_dropdown: bool
        :keyword display_enum_value: If true, both the value and the label for the enums will appear in
         the dropdown in the validation tool.
        :paramtype display_enum_value: bool
        :keyword hide_enum_detail: If true, the hoverable enum value detail icon will be hidden.
        :paramtype hide_enum_detail: bool
        :keyword drop_null: If True, any dropdown annotations that fail to parse to a value will be
         discarded.
        :paramtype drop_null: bool
        :keyword enabled_child_fields:
        :paramtype enabled_child_fields: list[~affinda.models.Field]
        :keyword disabled_child_fields:
        :paramtype disabled_child_fields: list[~affinda.models.Field]
        :keyword slug:
        :paramtype slug: str
        :keyword display_raw_text: If true, then the validation tool will show the user the raw text
         found on the page, not the value that has been parsed to a specific type.
        :paramtype display_raw_text: bool
        :keyword fields:
        :paramtype fields: list[any]
        """
        super(Field, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.label = label
        self.data_point = data_point
        self.field_type = field_type
        self.data_source = data_source
        self.mapping = mapping
        self.mandatory = mandatory
        self.auto_validation_threshold = auto_validation_threshold
        self.enable_auto_validation_threshold = enable_auto_validation_threshold
        self.show_dropdown = show_dropdown
        self.display_enum_value = display_enum_value
        self.hide_enum_detail = hide_enum_detail
        self.drop_null = drop_null
        self.enabled_child_fields = enabled_child_fields
        self.disabled_child_fields = disabled_child_fields
        self.slug = slug
        self.display_raw_text = display_raw_text
        self.fields = fields


class FieldCategory(msrest.serialization.Model):
    """FieldCategory.

    All required parameters must be populated in order to send to Azure.

    :ivar label: Required.
    :vartype label: str
    :ivar enabled_fields: Required.
    :vartype enabled_fields: list[~affinda.models.Field]
    :ivar disabled_fields: Required.
    :vartype disabled_fields: list[~affinda.models.Field]
    """

    _validation = {
        "label": {"required": True},
        "enabled_fields": {"required": True},
        "disabled_fields": {"required": True},
    }

    _attribute_map = {
        "label": {"key": "label", "type": "str"},
        "enabled_fields": {"key": "enabledFields", "type": "[Field]"},
        "disabled_fields": {"key": "disabledFields", "type": "[Field]"},
    }

    def __init__(
        self,
        *,
        label: str,
        enabled_fields: List["_models.Field"],
        disabled_fields: List["_models.Field"],
        **kwargs,
    ):
        """
        :keyword label: Required.
        :paramtype label: str
        :keyword enabled_fields: Required.
        :paramtype enabled_fields: list[~affinda.models.Field]
        :keyword disabled_fields: Required.
        :paramtype disabled_fields: list[~affinda.models.Field]
        """
        super(FieldCategory, self).__init__(**kwargs)
        self.label = label
        self.enabled_fields = enabled_fields
        self.disabled_fields = disabled_fields


class FieldDeprecated(msrest.serialization.Model):
    """FieldDeprecated.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar label: Required.
    :vartype label: str
    :ivar slug:
    :vartype slug: str
    :ivar field_type: Required. The different data types of annotations. Known values are: "text",
     "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum", "location",
     "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language", "skill",
     "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
    :vartype field_type: str or ~affinda.models.AnnotationContentType
    :ivar data_source: Data source mapping identifier.
    :vartype data_source: str
    :ivar mapping: Defines how the data point is mapped to the data source.
    :vartype mapping: str
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar mandatory:
    :vartype mandatory: bool
    :ivar disabled:
    :vartype disabled: bool
    :ivar auto_validation_threshold:
    :vartype auto_validation_threshold: float
    :ivar show_dropdown:
    :vartype show_dropdown: bool
    :ivar display_raw_text:
    :vartype display_raw_text: bool
    :ivar drop_null: If True, any dropdown annotations that fail to parse to a value will be
     discarded.
    :vartype drop_null: bool
    :ivar display_enum_value:
    :vartype display_enum_value: bool
    :ivar fields:
    :vartype fields: list[~affinda.models.FieldDeprecated]
    """

    _validation = {
        "label": {"required": True},
        "field_type": {"required": True},
        "data_point": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "label": {"key": "label", "type": "str"},
        "slug": {"key": "slug", "type": "str"},
        "field_type": {"key": "fieldType", "type": "str"},
        "data_source": {"key": "dataSource", "type": "str"},
        "mapping": {"key": "mapping", "type": "str"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "mandatory": {"key": "mandatory", "type": "bool"},
        "disabled": {"key": "disabled", "type": "bool"},
        "auto_validation_threshold": {"key": "autoValidationThreshold", "type": "float"},
        "show_dropdown": {"key": "showDropdown", "type": "bool"},
        "display_raw_text": {"key": "displayRawText", "type": "bool"},
        "drop_null": {"key": "dropNull", "type": "bool"},
        "display_enum_value": {"key": "displayEnumValue", "type": "bool"},
        "fields": {"key": "fields", "type": "[FieldDeprecated]"},
    }

    def __init__(
        self,
        *,
        label: str,
        field_type: Union[str, "_models.AnnotationContentType"],
        data_point: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        slug: Optional[str] = None,
        data_source: Optional[str] = None,
        mapping: Optional[str] = None,
        mandatory: Optional[bool] = None,
        disabled: Optional[bool] = None,
        auto_validation_threshold: Optional[float] = None,
        show_dropdown: Optional[bool] = None,
        display_raw_text: Optional[bool] = None,
        drop_null: Optional[bool] = None,
        display_enum_value: Optional[bool] = None,
        fields: Optional[List["_models.FieldDeprecated"]] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword label: Required.
        :paramtype label: str
        :keyword slug:
        :paramtype slug: str
        :keyword field_type: Required. The different data types of annotations. Known values are:
         "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
         "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
         "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
        :paramtype field_type: str or ~affinda.models.AnnotationContentType
        :keyword data_source: Data source mapping identifier.
        :paramtype data_source: str
        :keyword mapping: Defines how the data point is mapped to the data source.
        :paramtype mapping: str
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword mandatory:
        :paramtype mandatory: bool
        :keyword disabled:
        :paramtype disabled: bool
        :keyword auto_validation_threshold:
        :paramtype auto_validation_threshold: float
        :keyword show_dropdown:
        :paramtype show_dropdown: bool
        :keyword display_raw_text:
        :paramtype display_raw_text: bool
        :keyword drop_null: If True, any dropdown annotations that fail to parse to a value will be
         discarded.
        :paramtype drop_null: bool
        :keyword display_enum_value:
        :paramtype display_enum_value: bool
        :keyword fields:
        :paramtype fields: list[~affinda.models.FieldDeprecated]
        """
        super(FieldDeprecated, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.label = label
        self.slug = slug
        self.field_type = field_type
        self.data_source = data_source
        self.mapping = mapping
        self.data_point = data_point
        self.mandatory = mandatory
        self.disabled = disabled
        self.auto_validation_threshold = auto_validation_threshold
        self.show_dropdown = show_dropdown
        self.display_raw_text = display_raw_text
        self.drop_null = drop_null
        self.display_enum_value = display_enum_value
        self.fields = fields


class FieldGroup(msrest.serialization.Model):
    """FieldGroup.

    All required parameters must be populated in order to send to Azure.

    :ivar label: Required.
    :vartype label: str
    :ivar fields: Required.
    :vartype fields: list[~affinda.models.FieldDeprecated]
    """

    _validation = {
        "label": {"required": True},
        "fields": {"required": True},
    }

    _attribute_map = {
        "label": {"key": "label", "type": "str"},
        "fields": {"key": "fields", "type": "[FieldDeprecated]"},
    }

    def __init__(self, *, label: str, fields: List["_models.FieldDeprecated"], **kwargs):
        """
        :keyword label: Required.
        :paramtype label: str
        :keyword fields: Required.
        :paramtype fields: list[~affinda.models.FieldDeprecated]
        """
        super(FieldGroup, self).__init__(**kwargs)
        self.label = label
        self.fields = fields


class FieldsLayout(msrest.serialization.Model):
    """FieldsLayout.

    All required parameters must be populated in order to send to Azure.

    :ivar default_category: Required.
    :vartype default_category: ~affinda.models.FieldCategory
    :ivar categories: Required.
    :vartype categories: list[~affinda.models.FieldCategory]
    """

    _validation = {
        "default_category": {"required": True},
        "categories": {"required": True},
    }

    _attribute_map = {
        "default_category": {"key": "defaultCategory", "type": "FieldCategory"},
        "categories": {"key": "categories", "type": "[FieldCategory]"},
    }

    def __init__(
        self,
        *,
        default_category: "_models.FieldCategory",
        categories: List["_models.FieldCategory"],
        **kwargs,
    ):
        """
        :keyword default_category: Required.
        :paramtype default_category: ~affinda.models.FieldCategory
        :keyword categories: Required.
        :paramtype categories: list[~affinda.models.FieldCategory]
        """
        super(FieldsLayout, self).__init__(**kwargs)
        self.default_category = default_category
        self.categories = categories


class FloatAnnotation(Annotation):
    """FloatAnnotation.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required. Annotation's ID.
    :vartype id: int
    :ivar rectangle: Required. x/y coordinates for the rectangular bounding box containing the
     data.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required. x/y coordinates for the rectangles containing the data. An
     annotation can be contained within multiple rectangles.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar document: Required. Unique identifier for the document.
    :vartype document: str
    :ivar page_index: Required. The page number within the document, starting from 0.
    :vartype page_index: int
    :ivar raw: Required. Raw data extracted from the before any post-processing.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required. Indicates whether the data has been validated, either by a human
     using our validation tool or through auto-validation rules.
    :vartype is_verified: bool
    :ivar is_client_verified: Required. Indicates whether the data has been validated by a human.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required. Indicates whether the data has been auto-validated.
    :vartype is_auto_verified: bool
    :ivar data_point: Data point's identifier.
    :vartype data_point: str
    :ivar field: Field's identifier.
    :vartype field: str
    :ivar content_type: Required. The different data types of annotations. Known values are:
     "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
     "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
     "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
    :vartype content_type: str or ~affinda.models.AnnotationContentType
    :ivar parent: The parent annotation's ID.
    :vartype parent: int
    :ivar parsed:
    :vartype parsed: float
    """

    _validation = {
        "id": {"required": True, "minimum": 1},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "document": {"required": True},
        "page_index": {"required": True, "minimum": 0},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "document": {"key": "document", "type": "str"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "field": {"key": "field", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parent": {"key": "parent", "type": "int"},
        "parsed": {"key": "parsed", "type": "float"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        document: str,
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        content_type: Union[str, "_models.AnnotationContentType"],
        additional_properties: Optional[Dict[str, Any]] = None,
        data_point: Optional[str] = None,
        field: Optional[str] = None,
        parent: Optional[int] = None,
        parsed: Optional[float] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required. Annotation's ID.
        :paramtype id: int
        :keyword rectangle: Required. x/y coordinates for the rectangular bounding box containing the
         data.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required. x/y coordinates for the rectangles containing the data. An
         annotation can be contained within multiple rectangles.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword document: Required. Unique identifier for the document.
        :paramtype document: str
        :keyword page_index: Required. The page number within the document, starting from 0.
        :paramtype page_index: int
        :keyword raw: Required. Raw data extracted from the before any post-processing.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required. Indicates whether the data has been validated, either by a
         human using our validation tool or through auto-validation rules.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required. Indicates whether the data has been validated by a
         human.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required. Indicates whether the data has been auto-validated.
        :paramtype is_auto_verified: bool
        :keyword data_point: Data point's identifier.
        :paramtype data_point: str
        :keyword field: Field's identifier.
        :paramtype field: str
        :keyword content_type: Required. The different data types of annotations. Known values are:
         "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
         "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
         "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
        :paramtype content_type: str or ~affinda.models.AnnotationContentType
        :keyword parent: The parent annotation's ID.
        :paramtype parent: int
        :keyword parsed:
        :paramtype parsed: float
        """
        super(FloatAnnotation, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            document=document,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            field=field,
            content_type=content_type,
            parent=parent,
            **kwargs,
        )
        self.parsed = parsed


class Get200ApplicationJsonPropertiesItemsItem(msrest.serialization.Model):
    """Get200ApplicationJsonPropertiesItemsItem.

    :ivar document:
    :vartype document: str
    """

    _attribute_map = {
        "document": {"key": "document", "type": "str"},
    }

    def __init__(self, *, document: Optional[str] = None, **kwargs):
        """
        :keyword document:
        :paramtype document: str
        """
        super(Get200ApplicationJsonPropertiesItemsItem, self).__init__(**kwargs)
        self.document = document


class Index(msrest.serialization.Model):
    """Index.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar name: Required. Unique index name.
    :vartype name: str
    :ivar doc_type: Required. Known values are: "resumes", "job_descriptions".
    :vartype doc_type: str or ~affinda.models.IndexDocType
    :ivar user: Required. The user who created this index.
    :vartype user: ~affinda.models.IndexUser
    """

    _validation = {
        "name": {"required": True},
        "doc_type": {"required": True},
        "user": {"required": True, "readonly": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "name": {"key": "name", "type": "str"},
        "doc_type": {"key": "docType", "type": "str"},
        "user": {"key": "user", "type": "IndexUser"},
    }

    def __init__(
        self,
        *,
        name: str,
        doc_type: Union[str, "_models.IndexDocType"],
        additional_properties: Optional[Dict[str, Any]] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword name: Required. Unique index name.
        :paramtype name: str
        :keyword doc_type: Required. Known values are: "resumes", "job_descriptions".
        :paramtype doc_type: str or ~affinda.models.IndexDocType
        """
        super(Index, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.name = name
        self.doc_type = doc_type
        self.user = None


class IndexCreate(msrest.serialization.Model):
    """IndexRequestBody.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar name: Required. Unique index name.
    :vartype name: str
    :ivar doc_type: Known values are: "resumes", "job_descriptions".
    :vartype doc_type: str or ~affinda.models.DocType
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "name": {"key": "name", "type": "str"},
        "doc_type": {"key": "docType", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        doc_type: Optional[Union[str, "_models.DocType"]] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword name: Required. Unique index name.
        :paramtype name: str
        :keyword doc_type: Known values are: "resumes", "job_descriptions".
        :paramtype doc_type: str or ~affinda.models.DocType
        """
        super(IndexCreate, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.name = name
        self.doc_type = doc_type


class IndexUpdate(msrest.serialization.Model):
    """IndexUpdate.

    :ivar name: Unique index name.
    :vartype name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, **kwargs):
        """
        :keyword name: Unique index name.
        :paramtype name: str
        """
        super(IndexUpdate, self).__init__(**kwargs)
        self.name = name


class IndexUser(msrest.serialization.Model):
    """The user who created this index.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Uniquely identify a user.
    :vartype id: int
    :ivar name: Required.
    :vartype name: str
    :ivar email: Required.
    :vartype email: str
    :ivar avatar: Required. URL of the user's avatar.
    :vartype avatar: str
    """

    _validation = {
        "id": {"required": True, "minimum": 1},
        "name": {"required": True},
        "email": {"required": True},
        "avatar": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "name": {"key": "name", "type": "str"},
        "email": {"key": "email", "type": "str"},
        "avatar": {"key": "avatar", "type": "str"},
    }

    def __init__(self, *, id: int, name: str, email: str, avatar: str, **kwargs):
        """
        :keyword id: Required. Uniquely identify a user.
        :paramtype id: int
        :keyword name: Required.
        :paramtype name: str
        :keyword email: Required.
        :paramtype email: str
        :keyword avatar: Required. URL of the user's avatar.
        :paramtype avatar: str
        """
        super(IndexUser, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.email = email
        self.avatar = avatar


class Invitation(msrest.serialization.Model):
    """Invitation.

    :ivar identifier: Uniquely identify an invitation.
    :vartype identifier: str
    :ivar organization:
    :vartype organization: ~affinda.models.Organization
    :ivar email: The email which the invitation is sent to.
    :vartype email: str
    :ivar role: Known values are: "admin", "member".
    :vartype role: str or ~affinda.models.OrganizationRole
    :ivar status: Known values are: "pending", "accepted", "declined".
    :vartype status: str or ~affinda.models.InvitationStatus
    :ivar expiry_date: The date after which the invitation expires. Default is 10 days from now.
    :vartype expiry_date: ~datetime.date
    :ivar invited_by:
    :vartype invited_by: ~affinda.models.User
    :ivar responded_by:
    :vartype responded_by: ~affinda.models.InvitationRespondedBy
    :ivar created_dt:
    :vartype created_dt: ~datetime.datetime
    """

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "organization": {"key": "organization", "type": "Organization"},
        "email": {"key": "email", "type": "str"},
        "role": {"key": "role", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "expiry_date": {"key": "expiryDate", "type": "date"},
        "invited_by": {"key": "invitedBy", "type": "User"},
        "responded_by": {"key": "respondedBy", "type": "InvitationRespondedBy"},
        "created_dt": {"key": "createdDt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        identifier: Optional[str] = None,
        organization: Optional["_models.Organization"] = None,
        email: Optional[str] = None,
        role: Optional[Union[str, "_models.OrganizationRole"]] = None,
        status: Optional[Union[str, "_models.InvitationStatus"]] = None,
        expiry_date: Optional[datetime.date] = None,
        invited_by: Optional["_models.User"] = None,
        responded_by: Optional["_models.InvitationRespondedBy"] = None,
        created_dt: Optional[datetime.datetime] = None,
        **kwargs,
    ):
        """
        :keyword identifier: Uniquely identify an invitation.
        :paramtype identifier: str
        :keyword organization:
        :paramtype organization: ~affinda.models.Organization
        :keyword email: The email which the invitation is sent to.
        :paramtype email: str
        :keyword role: Known values are: "admin", "member".
        :paramtype role: str or ~affinda.models.OrganizationRole
        :keyword status: Known values are: "pending", "accepted", "declined".
        :paramtype status: str or ~affinda.models.InvitationStatus
        :keyword expiry_date: The date after which the invitation expires. Default is 10 days from now.
        :paramtype expiry_date: ~datetime.date
        :keyword invited_by:
        :paramtype invited_by: ~affinda.models.User
        :keyword responded_by:
        :paramtype responded_by: ~affinda.models.InvitationRespondedBy
        :keyword created_dt:
        :paramtype created_dt: ~datetime.datetime
        """
        super(Invitation, self).__init__(**kwargs)
        self.identifier = identifier
        self.organization = organization
        self.email = email
        self.role = role
        self.status = status
        self.expiry_date = expiry_date
        self.invited_by = invited_by
        self.responded_by = responded_by
        self.created_dt = created_dt


class InvitationCreate(msrest.serialization.Model):
    """InvitationCreate.

    All required parameters must be populated in order to send to Azure.

    :ivar organization: Required. Uniquely identify an organization.
    :vartype organization: str
    :ivar email: Required. The email which the invitation is sent to.
    :vartype email: str
    :ivar role: Required. Known values are: "admin", "member".
    :vartype role: str or ~affinda.models.OrganizationRole
    """

    _validation = {
        "organization": {"required": True},
        "email": {"required": True},
        "role": {"required": True},
    }

    _attribute_map = {
        "organization": {"key": "organization", "type": "str"},
        "email": {"key": "email", "type": "str"},
        "role": {"key": "role", "type": "str"},
    }

    def __init__(
        self,
        *,
        organization: str,
        email: str,
        role: Union[str, "_models.OrganizationRole"],
        **kwargs,
    ):
        """
        :keyword organization: Required. Uniquely identify an organization.
        :paramtype organization: str
        :keyword email: Required. The email which the invitation is sent to.
        :paramtype email: str
        :keyword role: Required. Known values are: "admin", "member".
        :paramtype role: str or ~affinda.models.OrganizationRole
        """
        super(InvitationCreate, self).__init__(**kwargs)
        self.organization = organization
        self.email = email
        self.role = role


class User(msrest.serialization.Model):
    """User.

    :ivar id: Uniquely identify a user.
    :vartype id: int
    :ivar name:
    :vartype name: str
    :ivar username:
    :vartype username: str
    :ivar email:
    :vartype email: str
    :ivar avatar: URL of the user's avatar.
    :vartype avatar: str
    """

    _validation = {
        "id": {"minimum": 1},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "name": {"key": "name", "type": "str"},
        "username": {"key": "username", "type": "str"},
        "email": {"key": "email", "type": "str"},
        "avatar": {"key": "avatar", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[int] = None,
        name: Optional[str] = None,
        username: Optional[str] = None,
        email: Optional[str] = None,
        avatar: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword id: Uniquely identify a user.
        :paramtype id: int
        :keyword name:
        :paramtype name: str
        :keyword username:
        :paramtype username: str
        :keyword email:
        :paramtype email: str
        :keyword avatar: URL of the user's avatar.
        :paramtype avatar: str
        """
        super(User, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.username = username
        self.email = email
        self.avatar = avatar


class InvitationRespondedBy(User):
    """InvitationRespondedBy.

    :ivar id: Uniquely identify a user.
    :vartype id: int
    :ivar name:
    :vartype name: str
    :ivar username:
    :vartype username: str
    :ivar email:
    :vartype email: str
    :ivar avatar: URL of the user's avatar.
    :vartype avatar: str
    """

    _validation = {
        "id": {"minimum": 1},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "name": {"key": "name", "type": "str"},
        "username": {"key": "username", "type": "str"},
        "email": {"key": "email", "type": "str"},
        "avatar": {"key": "avatar", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[int] = None,
        name: Optional[str] = None,
        username: Optional[str] = None,
        email: Optional[str] = None,
        avatar: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword id: Uniquely identify a user.
        :paramtype id: int
        :keyword name:
        :paramtype name: str
        :keyword username:
        :paramtype username: str
        :keyword email:
        :paramtype email: str
        :keyword avatar: URL of the user's avatar.
        :paramtype avatar: str
        """
        super(InvitationRespondedBy, self).__init__(
            id=id, name=name, username=username, email=email, avatar=avatar, **kwargs
        )


class InvitationResponse(msrest.serialization.Model):
    """InvitationResponse.

    :ivar status: Known values are: "accepted", "declined".
    :vartype status: str or ~affinda.models.InvitationResponseStatus
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self, *, status: Optional[Union[str, "_models.InvitationResponseStatus"]] = None, **kwargs
    ):
        """
        :keyword status: Known values are: "accepted", "declined".
        :paramtype status: str or ~affinda.models.InvitationResponseStatus
        """
        super(InvitationResponse, self).__init__(**kwargs)
        self.status = status


class InvitationUpdate(msrest.serialization.Model):
    """InvitationUpdate.

    :ivar role: Known values are: "admin", "member".
    :vartype role: str or ~affinda.models.OrganizationRole
    """

    _attribute_map = {
        "role": {"key": "role", "type": "str"},
    }

    def __init__(self, *, role: Optional[Union[str, "_models.OrganizationRole"]] = None, **kwargs):
        """
        :keyword role: Known values are: "admin", "member".
        :paramtype role: str or ~affinda.models.OrganizationRole
        """
        super(InvitationUpdate, self).__init__(**kwargs)
        self.role = role


class Invoice(Document):
    """Invoice.

    All required parameters must be populated in order to send to Azure.

    :ivar extractor: Required. Constant filled by server.
    :vartype extractor: str
    :ivar meta: Required.
    :vartype meta: ~affinda.models.DocumentMeta
    :ivar error:
    :vartype error: ~affinda.models.DocumentError
    :ivar warnings:
    :vartype warnings: list[~affinda.models.DocumentWarning]
    :ivar data:
    :vartype data: ~affinda.models.InvoiceData
    """

    _validation = {
        "extractor": {"required": True},
        "meta": {"required": True},
    }

    _attribute_map = {
        "extractor": {"key": "extractor", "type": "str"},
        "meta": {"key": "meta", "type": "DocumentMeta"},
        "error": {"key": "error", "type": "DocumentError"},
        "warnings": {"key": "warnings", "type": "[DocumentWarning]"},
        "data": {"key": "data", "type": "InvoiceData"},
    }

    def __init__(
        self,
        *,
        meta: "_models.DocumentMeta",
        error: Optional["_models.DocumentError"] = None,
        warnings: Optional[List["_models.DocumentWarning"]] = None,
        data: Optional["_models.InvoiceData"] = None,
        **kwargs,
    ):
        """
        :keyword meta: Required.
        :paramtype meta: ~affinda.models.DocumentMeta
        :keyword error:
        :paramtype error: ~affinda.models.DocumentError
        :keyword warnings:
        :paramtype warnings: list[~affinda.models.DocumentWarning]
        :keyword data:
        :paramtype data: ~affinda.models.InvoiceData
        """
        super(Invoice, self).__init__(meta=meta, error=error, warnings=warnings, **kwargs)
        self.extractor = "invoice"  # type: str
        self.data = data


class InvoiceData(msrest.serialization.Model):
    """InvoiceData.

    :ivar tables:
    :vartype tables: list[~affinda.models.TableAnnotation]
    :ivar tables_beta:
    :vartype tables_beta: list[~affinda.models.TableBetaAnnotation]
    :ivar invoice_date:
    :vartype invoice_date: ~affinda.models.DateAnnotation
    :ivar invoice_order_date:
    :vartype invoice_order_date: ~affinda.models.DateAnnotation
    :ivar payment_date_due:
    :vartype payment_date_due: ~affinda.models.DateAnnotation
    :ivar payment_amount_base:
    :vartype payment_amount_base: ~affinda.models.TextAnnotation
    :ivar payment_amount_tax:
    :vartype payment_amount_tax: ~affinda.models.TextAnnotation
    :ivar payment_amount_total:
    :vartype payment_amount_total: ~affinda.models.TextAnnotation
    :ivar payment_amount_paid:
    :vartype payment_amount_paid: ~affinda.models.TextAnnotation
    :ivar payment_amount_due:
    :vartype payment_amount_due: ~affinda.models.TextAnnotation
    :ivar invoice_number:
    :vartype invoice_number: ~affinda.models.TextAnnotation
    :ivar invoice_purchase_order_number:
    :vartype invoice_purchase_order_number: ~affinda.models.TextAnnotation
    :ivar supplier_business_number:
    :vartype supplier_business_number: ~affinda.models.TextAnnotation
    :ivar customer_number:
    :vartype customer_number: ~affinda.models.TextAnnotation
    :ivar customer_business_number:
    :vartype customer_business_number: ~affinda.models.TextAnnotation
    :ivar payment_reference:
    :vartype payment_reference: ~affinda.models.TextAnnotation
    :ivar bank_account_number:
    :vartype bank_account_number: ~affinda.models.TextAnnotation
    :ivar supplier_vat:
    :vartype supplier_vat: ~affinda.models.TextAnnotation
    :ivar customer_vat:
    :vartype customer_vat: ~affinda.models.TextAnnotation
    :ivar bpay_biller_code:
    :vartype bpay_biller_code: ~affinda.models.TextAnnotation
    :ivar bpay_reference:
    :vartype bpay_reference: ~affinda.models.TextAnnotation
    :ivar bank_sort_code:
    :vartype bank_sort_code: ~affinda.models.TextAnnotation
    :ivar bank_iban:
    :vartype bank_iban: ~affinda.models.TextAnnotation
    :ivar bank_swift:
    :vartype bank_swift: ~affinda.models.TextAnnotation
    :ivar bank_bsb:
    :vartype bank_bsb: ~affinda.models.TextAnnotation
    :ivar customer_contact_name:
    :vartype customer_contact_name: ~affinda.models.TextAnnotation
    :ivar customer_company_name:
    :vartype customer_company_name: ~affinda.models.TextAnnotation
    :ivar supplier_company_name:
    :vartype supplier_company_name: ~affinda.models.TextAnnotation
    :ivar customer_billing_address:
    :vartype customer_billing_address: ~affinda.models.LocationAnnotation
    :ivar customer_delivery_address:
    :vartype customer_delivery_address: ~affinda.models.LocationAnnotation
    :ivar supplier_address:
    :vartype supplier_address: ~affinda.models.LocationAnnotation
    :ivar customer_phone_number:
    :vartype customer_phone_number: ~affinda.models.TextAnnotation
    :ivar supplier_phone_number:
    :vartype supplier_phone_number: ~affinda.models.TextAnnotation
    :ivar supplier_fax:
    :vartype supplier_fax: ~affinda.models.TextAnnotation
    :ivar customer_email:
    :vartype customer_email: ~affinda.models.TextAnnotation
    :ivar supplier_email:
    :vartype supplier_email: ~affinda.models.TextAnnotation
    :ivar supplier_website:
    :vartype supplier_website: ~affinda.models.TextAnnotation
    :ivar currency_code:
    :vartype currency_code: ~affinda.models.CurrencyCodeAnnotation
    :ivar custom_fields: Dictionary of :code:`<any>`.
    :vartype custom_fields: dict[str, any]
    :ivar raw_text: All of the raw text of the parsed invoice.
    :vartype raw_text: str
    """

    _attribute_map = {
        "tables": {"key": "tables", "type": "[TableAnnotation]"},
        "tables_beta": {"key": "tablesBeta", "type": "[TableBetaAnnotation]"},
        "invoice_date": {"key": "invoiceDate", "type": "DateAnnotation"},
        "invoice_order_date": {"key": "invoiceOrderDate", "type": "DateAnnotation"},
        "payment_date_due": {"key": "paymentDateDue", "type": "DateAnnotation"},
        "payment_amount_base": {"key": "paymentAmountBase", "type": "TextAnnotation"},
        "payment_amount_tax": {"key": "paymentAmountTax", "type": "TextAnnotation"},
        "payment_amount_total": {"key": "paymentAmountTotal", "type": "TextAnnotation"},
        "payment_amount_paid": {"key": "paymentAmountPaid", "type": "TextAnnotation"},
        "payment_amount_due": {"key": "paymentAmountDue", "type": "TextAnnotation"},
        "invoice_number": {"key": "invoiceNumber", "type": "TextAnnotation"},
        "invoice_purchase_order_number": {
            "key": "invoicePurchaseOrderNumber",
            "type": "TextAnnotation",
        },
        "supplier_business_number": {"key": "supplierBusinessNumber", "type": "TextAnnotation"},
        "customer_number": {"key": "customerNumber", "type": "TextAnnotation"},
        "customer_business_number": {"key": "customerBusinessNumber", "type": "TextAnnotation"},
        "payment_reference": {"key": "paymentReference", "type": "TextAnnotation"},
        "bank_account_number": {"key": "bankAccountNumber", "type": "TextAnnotation"},
        "supplier_vat": {"key": "supplierVat", "type": "TextAnnotation"},
        "customer_vat": {"key": "customerVat", "type": "TextAnnotation"},
        "bpay_biller_code": {"key": "bpayBillerCode", "type": "TextAnnotation"},
        "bpay_reference": {"key": "bpayReference", "type": "TextAnnotation"},
        "bank_sort_code": {"key": "bankSortCode", "type": "TextAnnotation"},
        "bank_iban": {"key": "bankIban", "type": "TextAnnotation"},
        "bank_swift": {"key": "bankSwift", "type": "TextAnnotation"},
        "bank_bsb": {"key": "bankBsb", "type": "TextAnnotation"},
        "customer_contact_name": {"key": "customerContactName", "type": "TextAnnotation"},
        "customer_company_name": {"key": "customerCompanyName", "type": "TextAnnotation"},
        "supplier_company_name": {"key": "supplierCompanyName", "type": "TextAnnotation"},
        "customer_billing_address": {
            "key": "customerBillingAddress",
            "type": "LocationAnnotation",
        },
        "customer_delivery_address": {
            "key": "customerDeliveryAddress",
            "type": "LocationAnnotation",
        },
        "supplier_address": {"key": "supplierAddress", "type": "LocationAnnotation"},
        "customer_phone_number": {"key": "customerPhoneNumber", "type": "TextAnnotation"},
        "supplier_phone_number": {"key": "supplierPhoneNumber", "type": "TextAnnotation"},
        "supplier_fax": {"key": "supplierFax", "type": "TextAnnotation"},
        "customer_email": {"key": "customerEmail", "type": "TextAnnotation"},
        "supplier_email": {"key": "supplierEmail", "type": "TextAnnotation"},
        "supplier_website": {"key": "supplierWebsite", "type": "TextAnnotation"},
        "currency_code": {"key": "currencyCode", "type": "CurrencyCodeAnnotation"},
        "custom_fields": {"key": "customFields", "type": "{object}"},
        "raw_text": {"key": "rawText", "type": "str"},
    }

    def __init__(
        self,
        *,
        tables: Optional[List["_models.TableAnnotation"]] = None,
        tables_beta: Optional[List["_models.TableBetaAnnotation"]] = None,
        invoice_date: Optional["_models.DateAnnotation"] = None,
        invoice_order_date: Optional["_models.DateAnnotation"] = None,
        payment_date_due: Optional["_models.DateAnnotation"] = None,
        payment_amount_base: Optional["_models.TextAnnotation"] = None,
        payment_amount_tax: Optional["_models.TextAnnotation"] = None,
        payment_amount_total: Optional["_models.TextAnnotation"] = None,
        payment_amount_paid: Optional["_models.TextAnnotation"] = None,
        payment_amount_due: Optional["_models.TextAnnotation"] = None,
        invoice_number: Optional["_models.TextAnnotation"] = None,
        invoice_purchase_order_number: Optional["_models.TextAnnotation"] = None,
        supplier_business_number: Optional["_models.TextAnnotation"] = None,
        customer_number: Optional["_models.TextAnnotation"] = None,
        customer_business_number: Optional["_models.TextAnnotation"] = None,
        payment_reference: Optional["_models.TextAnnotation"] = None,
        bank_account_number: Optional["_models.TextAnnotation"] = None,
        supplier_vat: Optional["_models.TextAnnotation"] = None,
        customer_vat: Optional["_models.TextAnnotation"] = None,
        bpay_biller_code: Optional["_models.TextAnnotation"] = None,
        bpay_reference: Optional["_models.TextAnnotation"] = None,
        bank_sort_code: Optional["_models.TextAnnotation"] = None,
        bank_iban: Optional["_models.TextAnnotation"] = None,
        bank_swift: Optional["_models.TextAnnotation"] = None,
        bank_bsb: Optional["_models.TextAnnotation"] = None,
        customer_contact_name: Optional["_models.TextAnnotation"] = None,
        customer_company_name: Optional["_models.TextAnnotation"] = None,
        supplier_company_name: Optional["_models.TextAnnotation"] = None,
        customer_billing_address: Optional["_models.LocationAnnotation"] = None,
        customer_delivery_address: Optional["_models.LocationAnnotation"] = None,
        supplier_address: Optional["_models.LocationAnnotation"] = None,
        customer_phone_number: Optional["_models.TextAnnotation"] = None,
        supplier_phone_number: Optional["_models.TextAnnotation"] = None,
        supplier_fax: Optional["_models.TextAnnotation"] = None,
        customer_email: Optional["_models.TextAnnotation"] = None,
        supplier_email: Optional["_models.TextAnnotation"] = None,
        supplier_website: Optional["_models.TextAnnotation"] = None,
        currency_code: Optional["_models.CurrencyCodeAnnotation"] = None,
        custom_fields: Optional[Dict[str, Any]] = None,
        raw_text: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword tables:
        :paramtype tables: list[~affinda.models.TableAnnotation]
        :keyword tables_beta:
        :paramtype tables_beta: list[~affinda.models.TableBetaAnnotation]
        :keyword invoice_date:
        :paramtype invoice_date: ~affinda.models.DateAnnotation
        :keyword invoice_order_date:
        :paramtype invoice_order_date: ~affinda.models.DateAnnotation
        :keyword payment_date_due:
        :paramtype payment_date_due: ~affinda.models.DateAnnotation
        :keyword payment_amount_base:
        :paramtype payment_amount_base: ~affinda.models.TextAnnotation
        :keyword payment_amount_tax:
        :paramtype payment_amount_tax: ~affinda.models.TextAnnotation
        :keyword payment_amount_total:
        :paramtype payment_amount_total: ~affinda.models.TextAnnotation
        :keyword payment_amount_paid:
        :paramtype payment_amount_paid: ~affinda.models.TextAnnotation
        :keyword payment_amount_due:
        :paramtype payment_amount_due: ~affinda.models.TextAnnotation
        :keyword invoice_number:
        :paramtype invoice_number: ~affinda.models.TextAnnotation
        :keyword invoice_purchase_order_number:
        :paramtype invoice_purchase_order_number: ~affinda.models.TextAnnotation
        :keyword supplier_business_number:
        :paramtype supplier_business_number: ~affinda.models.TextAnnotation
        :keyword customer_number:
        :paramtype customer_number: ~affinda.models.TextAnnotation
        :keyword customer_business_number:
        :paramtype customer_business_number: ~affinda.models.TextAnnotation
        :keyword payment_reference:
        :paramtype payment_reference: ~affinda.models.TextAnnotation
        :keyword bank_account_number:
        :paramtype bank_account_number: ~affinda.models.TextAnnotation
        :keyword supplier_vat:
        :paramtype supplier_vat: ~affinda.models.TextAnnotation
        :keyword customer_vat:
        :paramtype customer_vat: ~affinda.models.TextAnnotation
        :keyword bpay_biller_code:
        :paramtype bpay_biller_code: ~affinda.models.TextAnnotation
        :keyword bpay_reference:
        :paramtype bpay_reference: ~affinda.models.TextAnnotation
        :keyword bank_sort_code:
        :paramtype bank_sort_code: ~affinda.models.TextAnnotation
        :keyword bank_iban:
        :paramtype bank_iban: ~affinda.models.TextAnnotation
        :keyword bank_swift:
        :paramtype bank_swift: ~affinda.models.TextAnnotation
        :keyword bank_bsb:
        :paramtype bank_bsb: ~affinda.models.TextAnnotation
        :keyword customer_contact_name:
        :paramtype customer_contact_name: ~affinda.models.TextAnnotation
        :keyword customer_company_name:
        :paramtype customer_company_name: ~affinda.models.TextAnnotation
        :keyword supplier_company_name:
        :paramtype supplier_company_name: ~affinda.models.TextAnnotation
        :keyword customer_billing_address:
        :paramtype customer_billing_address: ~affinda.models.LocationAnnotation
        :keyword customer_delivery_address:
        :paramtype customer_delivery_address: ~affinda.models.LocationAnnotation
        :keyword supplier_address:
        :paramtype supplier_address: ~affinda.models.LocationAnnotation
        :keyword customer_phone_number:
        :paramtype customer_phone_number: ~affinda.models.TextAnnotation
        :keyword supplier_phone_number:
        :paramtype supplier_phone_number: ~affinda.models.TextAnnotation
        :keyword supplier_fax:
        :paramtype supplier_fax: ~affinda.models.TextAnnotation
        :keyword customer_email:
        :paramtype customer_email: ~affinda.models.TextAnnotation
        :keyword supplier_email:
        :paramtype supplier_email: ~affinda.models.TextAnnotation
        :keyword supplier_website:
        :paramtype supplier_website: ~affinda.models.TextAnnotation
        :keyword currency_code:
        :paramtype currency_code: ~affinda.models.CurrencyCodeAnnotation
        :keyword custom_fields: Dictionary of :code:`<any>`.
        :paramtype custom_fields: dict[str, any]
        :keyword raw_text: All of the raw text of the parsed invoice.
        :paramtype raw_text: str
        """
        super(InvoiceData, self).__init__(**kwargs)
        self.tables = tables
        self.tables_beta = tables_beta
        self.invoice_date = invoice_date
        self.invoice_order_date = invoice_order_date
        self.payment_date_due = payment_date_due
        self.payment_amount_base = payment_amount_base
        self.payment_amount_tax = payment_amount_tax
        self.payment_amount_total = payment_amount_total
        self.payment_amount_paid = payment_amount_paid
        self.payment_amount_due = payment_amount_due
        self.invoice_number = invoice_number
        self.invoice_purchase_order_number = invoice_purchase_order_number
        self.supplier_business_number = supplier_business_number
        self.customer_number = customer_number
        self.customer_business_number = customer_business_number
        self.payment_reference = payment_reference
        self.bank_account_number = bank_account_number
        self.supplier_vat = supplier_vat
        self.customer_vat = customer_vat
        self.bpay_biller_code = bpay_biller_code
        self.bpay_reference = bpay_reference
        self.bank_sort_code = bank_sort_code
        self.bank_iban = bank_iban
        self.bank_swift = bank_swift
        self.bank_bsb = bank_bsb
        self.customer_contact_name = customer_contact_name
        self.customer_company_name = customer_company_name
        self.supplier_company_name = supplier_company_name
        self.customer_billing_address = customer_billing_address
        self.customer_delivery_address = customer_delivery_address
        self.supplier_address = supplier_address
        self.customer_phone_number = customer_phone_number
        self.supplier_phone_number = supplier_phone_number
        self.supplier_fax = supplier_fax
        self.customer_email = customer_email
        self.supplier_email = supplier_email
        self.supplier_website = supplier_website
        self.currency_code = currency_code
        self.custom_fields = custom_fields
        self.raw_text = raw_text


class JobDescription(Document):
    """JobDescription.

    All required parameters must be populated in order to send to Azure.

    :ivar extractor: Required. Constant filled by server.
    :vartype extractor: str
    :ivar meta: Required.
    :vartype meta: ~affinda.models.DocumentMeta
    :ivar error:
    :vartype error: ~affinda.models.DocumentError
    :ivar warnings:
    :vartype warnings: list[~affinda.models.DocumentWarning]
    :ivar data:
    :vartype data: ~affinda.models.JobDescriptionData
    """

    _validation = {
        "extractor": {"required": True},
        "meta": {"required": True},
    }

    _attribute_map = {
        "extractor": {"key": "extractor", "type": "str"},
        "meta": {"key": "meta", "type": "DocumentMeta"},
        "error": {"key": "error", "type": "DocumentError"},
        "warnings": {"key": "warnings", "type": "[DocumentWarning]"},
        "data": {"key": "data", "type": "JobDescriptionData"},
    }

    def __init__(
        self,
        *,
        meta: "_models.DocumentMeta",
        error: Optional["_models.DocumentError"] = None,
        warnings: Optional[List["_models.DocumentWarning"]] = None,
        data: Optional["_models.JobDescriptionData"] = None,
        **kwargs,
    ):
        """
        :keyword meta: Required.
        :paramtype meta: ~affinda.models.DocumentMeta
        :keyword error:
        :paramtype error: ~affinda.models.DocumentError
        :keyword warnings:
        :paramtype warnings: list[~affinda.models.DocumentWarning]
        :keyword data:
        :paramtype data: ~affinda.models.JobDescriptionData
        """
        super(JobDescription, self).__init__(meta=meta, error=error, warnings=warnings, **kwargs)
        self.extractor = "job-description"  # type: str
        self.data = data


class JobDescriptionData(msrest.serialization.Model):
    """JobDescriptionData.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar job_title:
    :vartype job_title: ~affinda.models.JobTitleAnnotation
    :ivar contact_email:
    :vartype contact_email: ~affinda.models.TextAnnotation
    :ivar contact_name:
    :vartype contact_name: ~affinda.models.TextAnnotation
    :ivar contact_phone:
    :vartype contact_phone: ~affinda.models.TextAnnotation
    :ivar start_date:
    :vartype start_date: ~affinda.models.DateAnnotation
    :ivar end_date:
    :vartype end_date: ~affinda.models.DateAnnotation
    :ivar job_type:
    :vartype job_type: ~affinda.models.TextAnnotation
    :ivar languages:
    :vartype languages: list[~affinda.models.LanguageAnnotation]
    :ivar skills:
    :vartype skills: list[~affinda.models.SkillAnnotation]
    :ivar organization_name:
    :vartype organization_name: ~affinda.models.TextAnnotation
    :ivar organization_website:
    :vartype organization_website: ~affinda.models.TextAnnotation
    :ivar education_level:
    :vartype education_level: ~affinda.models.TextAnnotation
    :ivar education_accreditation:
    :vartype education_accreditation: ~affinda.models.TextAnnotation
    :ivar expected_remuneration:
    :vartype expected_remuneration: ~affinda.models.ExpectedRemunerationAnnotation
    :ivar location:
    :vartype location: ~affinda.models.LocationAnnotation
    :ivar certifications:
    :vartype certifications: list[~affinda.models.TextAnnotation]
    :ivar years_experience:
    :vartype years_experience: ~affinda.models.YearsExperienceAnnotation
    :ivar raw_text: All of the raw text of the parsed job description, example is shortened for
     readability.
    :vartype raw_text: str
    """

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "job_title": {"key": "jobTitle", "type": "JobTitleAnnotation"},
        "contact_email": {"key": "contactEmail", "type": "TextAnnotation"},
        "contact_name": {"key": "contactName", "type": "TextAnnotation"},
        "contact_phone": {"key": "contactPhone", "type": "TextAnnotation"},
        "start_date": {"key": "startDate", "type": "DateAnnotation"},
        "end_date": {"key": "endDate", "type": "DateAnnotation"},
        "job_type": {"key": "jobType", "type": "TextAnnotation"},
        "languages": {"key": "languages", "type": "[LanguageAnnotation]"},
        "skills": {"key": "skills", "type": "[SkillAnnotation]"},
        "organization_name": {"key": "organizationName", "type": "TextAnnotation"},
        "organization_website": {"key": "organizationWebsite", "type": "TextAnnotation"},
        "education_level": {"key": "educationLevel", "type": "TextAnnotation"},
        "education_accreditation": {"key": "educationAccreditation", "type": "TextAnnotation"},
        "expected_remuneration": {
            "key": "expectedRemuneration",
            "type": "ExpectedRemunerationAnnotation",
        },
        "location": {"key": "location", "type": "LocationAnnotation"},
        "certifications": {"key": "certifications", "type": "[TextAnnotation]"},
        "years_experience": {"key": "yearsExperience", "type": "YearsExperienceAnnotation"},
        "raw_text": {"key": "rawText", "type": "str"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        job_title: Optional["_models.JobTitleAnnotation"] = None,
        contact_email: Optional["_models.TextAnnotation"] = None,
        contact_name: Optional["_models.TextAnnotation"] = None,
        contact_phone: Optional["_models.TextAnnotation"] = None,
        start_date: Optional["_models.DateAnnotation"] = None,
        end_date: Optional["_models.DateAnnotation"] = None,
        job_type: Optional["_models.TextAnnotation"] = None,
        languages: Optional[List["_models.LanguageAnnotation"]] = None,
        skills: Optional[List["_models.SkillAnnotation"]] = None,
        organization_name: Optional["_models.TextAnnotation"] = None,
        organization_website: Optional["_models.TextAnnotation"] = None,
        education_level: Optional["_models.TextAnnotation"] = None,
        education_accreditation: Optional["_models.TextAnnotation"] = None,
        expected_remuneration: Optional["_models.ExpectedRemunerationAnnotation"] = None,
        location: Optional["_models.LocationAnnotation"] = None,
        certifications: Optional[List["_models.TextAnnotation"]] = None,
        years_experience: Optional["_models.YearsExperienceAnnotation"] = None,
        raw_text: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword job_title:
        :paramtype job_title: ~affinda.models.JobTitleAnnotation
        :keyword contact_email:
        :paramtype contact_email: ~affinda.models.TextAnnotation
        :keyword contact_name:
        :paramtype contact_name: ~affinda.models.TextAnnotation
        :keyword contact_phone:
        :paramtype contact_phone: ~affinda.models.TextAnnotation
        :keyword start_date:
        :paramtype start_date: ~affinda.models.DateAnnotation
        :keyword end_date:
        :paramtype end_date: ~affinda.models.DateAnnotation
        :keyword job_type:
        :paramtype job_type: ~affinda.models.TextAnnotation
        :keyword languages:
        :paramtype languages: list[~affinda.models.LanguageAnnotation]
        :keyword skills:
        :paramtype skills: list[~affinda.models.SkillAnnotation]
        :keyword organization_name:
        :paramtype organization_name: ~affinda.models.TextAnnotation
        :keyword organization_website:
        :paramtype organization_website: ~affinda.models.TextAnnotation
        :keyword education_level:
        :paramtype education_level: ~affinda.models.TextAnnotation
        :keyword education_accreditation:
        :paramtype education_accreditation: ~affinda.models.TextAnnotation
        :keyword expected_remuneration:
        :paramtype expected_remuneration: ~affinda.models.ExpectedRemunerationAnnotation
        :keyword location:
        :paramtype location: ~affinda.models.LocationAnnotation
        :keyword certifications:
        :paramtype certifications: list[~affinda.models.TextAnnotation]
        :keyword years_experience:
        :paramtype years_experience: ~affinda.models.YearsExperienceAnnotation
        :keyword raw_text: All of the raw text of the parsed job description, example is shortened for
         readability.
        :paramtype raw_text: str
        """
        super(JobDescriptionData, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.job_title = job_title
        self.contact_email = contact_email
        self.contact_name = contact_name
        self.contact_phone = contact_phone
        self.start_date = start_date
        self.end_date = end_date
        self.job_type = job_type
        self.languages = languages
        self.skills = skills
        self.organization_name = organization_name
        self.organization_website = organization_website
        self.education_level = education_level
        self.education_accreditation = education_accreditation
        self.expected_remuneration = expected_remuneration
        self.location = location
        self.certifications = certifications
        self.years_experience = years_experience
        self.raw_text = raw_text


class JobDescriptionDataUpdate(msrest.serialization.Model):
    """A JSON-encoded string of the ``JobDescriptionData`` object.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar job_title:
    :vartype job_title: ~affinda.models.JobTitleAnnotationUpdate
    :ivar contact_email:
    :vartype contact_email: ~affinda.models.TextAnnotationUpdate
    :ivar contact_name:
    :vartype contact_name: ~affinda.models.TextAnnotationUpdate
    :ivar contact_phone:
    :vartype contact_phone: ~affinda.models.TextAnnotationUpdate
    :ivar start_date:
    :vartype start_date: ~affinda.models.DateAnnotationUpdate
    :ivar end_date:
    :vartype end_date: ~affinda.models.DateAnnotationUpdate
    :ivar job_type:
    :vartype job_type: ~affinda.models.TextAnnotationUpdate
    :ivar languages:
    :vartype languages: list[~affinda.models.LanguageAnnotationUpdate]
    :ivar skills:
    :vartype skills: list[~affinda.models.SkillAnnotationUpdate]
    :ivar organization_name:
    :vartype organization_name: ~affinda.models.TextAnnotationUpdate
    :ivar organization_website:
    :vartype organization_website: ~affinda.models.TextAnnotationUpdate
    :ivar education_level:
    :vartype education_level: ~affinda.models.TextAnnotationUpdate
    :ivar education_accreditation:
    :vartype education_accreditation: ~affinda.models.TextAnnotationUpdate
    :ivar expected_remuneration:
    :vartype expected_remuneration: ~affinda.models.ExpectedRemunerationAnnotationUpdate
    :ivar location:
    :vartype location: ~affinda.models.LocationAnnotationUpdate
    :ivar certifications:
    :vartype certifications: list[~affinda.models.TextAnnotationUpdate]
    :ivar years_experience:
    :vartype years_experience: ~affinda.models.YearsExperienceAnnotationUpdate
    """

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "job_title": {"key": "jobTitle", "type": "JobTitleAnnotationUpdate"},
        "contact_email": {"key": "contactEmail", "type": "TextAnnotationUpdate"},
        "contact_name": {"key": "contactName", "type": "TextAnnotationUpdate"},
        "contact_phone": {"key": "contactPhone", "type": "TextAnnotationUpdate"},
        "start_date": {"key": "startDate", "type": "DateAnnotationUpdate"},
        "end_date": {"key": "endDate", "type": "DateAnnotationUpdate"},
        "job_type": {"key": "jobType", "type": "TextAnnotationUpdate"},
        "languages": {"key": "languages", "type": "[LanguageAnnotationUpdate]"},
        "skills": {"key": "skills", "type": "[SkillAnnotationUpdate]"},
        "organization_name": {"key": "organizationName", "type": "TextAnnotationUpdate"},
        "organization_website": {"key": "organizationWebsite", "type": "TextAnnotationUpdate"},
        "education_level": {"key": "educationLevel", "type": "TextAnnotationUpdate"},
        "education_accreditation": {
            "key": "educationAccreditation",
            "type": "TextAnnotationUpdate",
        },
        "expected_remuneration": {
            "key": "expectedRemuneration",
            "type": "ExpectedRemunerationAnnotationUpdate",
        },
        "location": {"key": "location", "type": "LocationAnnotationUpdate"},
        "certifications": {"key": "certifications", "type": "[TextAnnotationUpdate]"},
        "years_experience": {"key": "yearsExperience", "type": "YearsExperienceAnnotationUpdate"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        job_title: Optional["_models.JobTitleAnnotationUpdate"] = None,
        contact_email: Optional["_models.TextAnnotationUpdate"] = None,
        contact_name: Optional["_models.TextAnnotationUpdate"] = None,
        contact_phone: Optional["_models.TextAnnotationUpdate"] = None,
        start_date: Optional["_models.DateAnnotationUpdate"] = None,
        end_date: Optional["_models.DateAnnotationUpdate"] = None,
        job_type: Optional["_models.TextAnnotationUpdate"] = None,
        languages: Optional[List["_models.LanguageAnnotationUpdate"]] = None,
        skills: Optional[List["_models.SkillAnnotationUpdate"]] = None,
        organization_name: Optional["_models.TextAnnotationUpdate"] = None,
        organization_website: Optional["_models.TextAnnotationUpdate"] = None,
        education_level: Optional["_models.TextAnnotationUpdate"] = None,
        education_accreditation: Optional["_models.TextAnnotationUpdate"] = None,
        expected_remuneration: Optional["_models.ExpectedRemunerationAnnotationUpdate"] = None,
        location: Optional["_models.LocationAnnotationUpdate"] = None,
        certifications: Optional[List["_models.TextAnnotationUpdate"]] = None,
        years_experience: Optional["_models.YearsExperienceAnnotationUpdate"] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword job_title:
        :paramtype job_title: ~affinda.models.JobTitleAnnotationUpdate
        :keyword contact_email:
        :paramtype contact_email: ~affinda.models.TextAnnotationUpdate
        :keyword contact_name:
        :paramtype contact_name: ~affinda.models.TextAnnotationUpdate
        :keyword contact_phone:
        :paramtype contact_phone: ~affinda.models.TextAnnotationUpdate
        :keyword start_date:
        :paramtype start_date: ~affinda.models.DateAnnotationUpdate
        :keyword end_date:
        :paramtype end_date: ~affinda.models.DateAnnotationUpdate
        :keyword job_type:
        :paramtype job_type: ~affinda.models.TextAnnotationUpdate
        :keyword languages:
        :paramtype languages: list[~affinda.models.LanguageAnnotationUpdate]
        :keyword skills:
        :paramtype skills: list[~affinda.models.SkillAnnotationUpdate]
        :keyword organization_name:
        :paramtype organization_name: ~affinda.models.TextAnnotationUpdate
        :keyword organization_website:
        :paramtype organization_website: ~affinda.models.TextAnnotationUpdate
        :keyword education_level:
        :paramtype education_level: ~affinda.models.TextAnnotationUpdate
        :keyword education_accreditation:
        :paramtype education_accreditation: ~affinda.models.TextAnnotationUpdate
        :keyword expected_remuneration:
        :paramtype expected_remuneration: ~affinda.models.ExpectedRemunerationAnnotationUpdate
        :keyword location:
        :paramtype location: ~affinda.models.LocationAnnotationUpdate
        :keyword certifications:
        :paramtype certifications: list[~affinda.models.TextAnnotationUpdate]
        :keyword years_experience:
        :paramtype years_experience: ~affinda.models.YearsExperienceAnnotationUpdate
        """
        super(JobDescriptionDataUpdate, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.job_title = job_title
        self.contact_email = contact_email
        self.contact_name = contact_name
        self.contact_phone = contact_phone
        self.start_date = start_date
        self.end_date = end_date
        self.job_type = job_type
        self.languages = languages
        self.skills = skills
        self.organization_name = organization_name
        self.organization_website = organization_website
        self.education_level = education_level
        self.education_accreditation = education_accreditation
        self.expected_remuneration = expected_remuneration
        self.location = location
        self.certifications = certifications
        self.years_experience = years_experience


class JobDescriptionSearch(msrest.serialization.Model):
    """JobDescriptionSearch.

    :ivar count: Total number of results.
    :vartype count: int
    :ivar next: URL to request next page of results.
    :vartype next: str
    :ivar previous: URL to request previous page of results.
    :vartype previous: str
    :ivar parameters:
    :vartype parameters: ~affinda.models.JobDescriptionSearchParameters
    :ivar results:
    :vartype results: list[~affinda.models.JobDescriptionSearchResult]
    """

    _validation = {
        "count": {"minimum": 0},
    }

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
        "next": {"key": "next", "type": "str"},
        "previous": {"key": "previous", "type": "str"},
        "parameters": {"key": "parameters", "type": "JobDescriptionSearchParameters"},
        "results": {"key": "results", "type": "[JobDescriptionSearchResult]"},
    }

    def __init__(
        self,
        *,
        count: Optional[int] = None,
        next: Optional[str] = None,
        previous: Optional[str] = None,
        parameters: Optional["_models.JobDescriptionSearchParameters"] = None,
        results: Optional[List["_models.JobDescriptionSearchResult"]] = None,
        **kwargs,
    ):
        """
        :keyword count: Total number of results.
        :paramtype count: int
        :keyword next: URL to request next page of results.
        :paramtype next: str
        :keyword previous: URL to request previous page of results.
        :paramtype previous: str
        :keyword parameters:
        :paramtype parameters: ~affinda.models.JobDescriptionSearchParameters
        :keyword results:
        :paramtype results: list[~affinda.models.JobDescriptionSearchResult]
        """
        super(JobDescriptionSearch, self).__init__(**kwargs)
        self.count = count
        self.next = next
        self.previous = previous
        self.parameters = parameters
        self.results = results


class JobDescriptionSearchConfig(msrest.serialization.Model):
    """JobDescriptionSearchConfig.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar allow_pdf_download:
    :vartype allow_pdf_download: bool
    :ivar max_results: Maximum number of results that can be returned. Setting to "null" means no
     limitation.
    :vartype max_results: int
    :ivar display_job_title:
    :vartype display_job_title: bool
    :ivar display_location:
    :vartype display_location: bool
    :ivar display_years_experience:
    :vartype display_years_experience: bool
    :ivar display_occupation_group:
    :vartype display_occupation_group: bool
    :ivar display_education:
    :vartype display_education: bool
    :ivar display_skills:
    :vartype display_skills: bool
    :ivar display_languages:
    :vartype display_languages: bool
    :ivar display_management_level:
    :vartype display_management_level: bool
    :ivar display_keywords:
    :vartype display_keywords: bool
    :ivar weight_job_title:
    :vartype weight_job_title: float
    :ivar weight_location:
    :vartype weight_location: float
    :ivar weight_years_experience:
    :vartype weight_years_experience: float
    :ivar weight_occupation_group:
    :vartype weight_occupation_group: float
    :ivar weight_education:
    :vartype weight_education: float
    :ivar weight_skills:
    :vartype weight_skills: float
    :ivar weight_languages:
    :vartype weight_languages: float
    :ivar weight_management_level:
    :vartype weight_management_level: float
    :ivar weight_keywords:
    :vartype weight_keywords: float
    :ivar indices: List of index names.
    :vartype indices: list[str]
    :ivar show_index_dropdown: Controls whether or not the index dropdown is displayed to the user.
    :vartype show_index_dropdown: bool
    :ivar search_tool_theme: Customize the theme of the embeded search tool.
    :vartype search_tool_theme: ~affinda.models.JobDescriptionSearchConfigSearchToolTheme
    :ivar user_id: ID of the logged in user.
    :vartype user_id: int
    :ivar username: Username of the logged in user.
    :vartype username: str
    :ivar actions: A list of actions to show in the dropdown in the embedded search tool.
    :vartype actions: list[~affinda.models.SearchConfigAction]
    :ivar hide_toolbar: Hide the reset/import toolbar.
    :vartype hide_toolbar: bool
    :ivar hide_side_panel: Hide the entire side panel.
    :vartype hide_side_panel: bool
    :ivar custom_fields_config:
    :vartype custom_fields_config: list[~affinda.models.CustomFieldConfig]
    :ivar distance_unit: The unit of distance to use for location based searches. Known values are:
     "mi", "km".
    :vartype distance_unit: str or ~affinda.models.JobDescriptionSearchConfigDistanceUnit
    """

    _validation = {
        "max_results": {"minimum": 1},
        "user_id": {"readonly": True, "minimum": 1},
        "username": {"readonly": True},
    }

    _attribute_map = {
        "allow_pdf_download": {"key": "allowPdfDownload", "type": "bool"},
        "max_results": {"key": "maxResults", "type": "int"},
        "display_job_title": {"key": "displayJobTitle", "type": "bool"},
        "display_location": {"key": "displayLocation", "type": "bool"},
        "display_years_experience": {"key": "displayYearsExperience", "type": "bool"},
        "display_occupation_group": {"key": "displayOccupationGroup", "type": "bool"},
        "display_education": {"key": "displayEducation", "type": "bool"},
        "display_skills": {"key": "displaySkills", "type": "bool"},
        "display_languages": {"key": "displayLanguages", "type": "bool"},
        "display_management_level": {"key": "displayManagementLevel", "type": "bool"},
        "display_keywords": {"key": "displayKeywords", "type": "bool"},
        "weight_job_title": {"key": "weightJobTitle", "type": "float"},
        "weight_location": {"key": "weightLocation", "type": "float"},
        "weight_years_experience": {"key": "weightYearsExperience", "type": "float"},
        "weight_occupation_group": {"key": "weightOccupationGroup", "type": "float"},
        "weight_education": {"key": "weightEducation", "type": "float"},
        "weight_skills": {"key": "weightSkills", "type": "float"},
        "weight_languages": {"key": "weightLanguages", "type": "float"},
        "weight_management_level": {"key": "weightManagementLevel", "type": "float"},
        "weight_keywords": {"key": "weightKeywords", "type": "float"},
        "indices": {"key": "indices", "type": "[str]"},
        "show_index_dropdown": {"key": "showIndexDropdown", "type": "bool"},
        "search_tool_theme": {
            "key": "searchToolTheme",
            "type": "JobDescriptionSearchConfigSearchToolTheme",
        },
        "user_id": {"key": "userId", "type": "int"},
        "username": {"key": "username", "type": "str"},
        "actions": {"key": "actions", "type": "[SearchConfigAction]"},
        "hide_toolbar": {"key": "hideToolbar", "type": "bool"},
        "hide_side_panel": {"key": "hideSidePanel", "type": "bool"},
        "custom_fields_config": {"key": "customFieldsConfig", "type": "[CustomFieldConfig]"},
        "distance_unit": {"key": "distanceUnit", "type": "str"},
    }

    def __init__(
        self,
        *,
        allow_pdf_download: Optional[bool] = None,
        max_results: Optional[int] = None,
        display_job_title: Optional[bool] = None,
        display_location: Optional[bool] = None,
        display_years_experience: Optional[bool] = None,
        display_occupation_group: Optional[bool] = None,
        display_education: Optional[bool] = None,
        display_skills: Optional[bool] = None,
        display_languages: Optional[bool] = None,
        display_management_level: Optional[bool] = None,
        display_keywords: Optional[bool] = None,
        weight_job_title: Optional[float] = None,
        weight_location: Optional[float] = None,
        weight_years_experience: Optional[float] = None,
        weight_occupation_group: Optional[float] = None,
        weight_education: Optional[float] = None,
        weight_skills: Optional[float] = None,
        weight_languages: Optional[float] = None,
        weight_management_level: Optional[float] = None,
        weight_keywords: Optional[float] = None,
        indices: Optional[List[str]] = None,
        show_index_dropdown: Optional[bool] = None,
        search_tool_theme: Optional["_models.JobDescriptionSearchConfigSearchToolTheme"] = None,
        actions: Optional[List["_models.SearchConfigAction"]] = None,
        hide_toolbar: Optional[bool] = None,
        hide_side_panel: Optional[bool] = None,
        custom_fields_config: Optional[List["_models.CustomFieldConfig"]] = None,
        distance_unit: Optional[
            Union[str, "_models.JobDescriptionSearchConfigDistanceUnit"]
        ] = None,
        **kwargs,
    ):
        """
        :keyword allow_pdf_download:
        :paramtype allow_pdf_download: bool
        :keyword max_results: Maximum number of results that can be returned. Setting to "null" means
         no limitation.
        :paramtype max_results: int
        :keyword display_job_title:
        :paramtype display_job_title: bool
        :keyword display_location:
        :paramtype display_location: bool
        :keyword display_years_experience:
        :paramtype display_years_experience: bool
        :keyword display_occupation_group:
        :paramtype display_occupation_group: bool
        :keyword display_education:
        :paramtype display_education: bool
        :keyword display_skills:
        :paramtype display_skills: bool
        :keyword display_languages:
        :paramtype display_languages: bool
        :keyword display_management_level:
        :paramtype display_management_level: bool
        :keyword display_keywords:
        :paramtype display_keywords: bool
        :keyword weight_job_title:
        :paramtype weight_job_title: float
        :keyword weight_location:
        :paramtype weight_location: float
        :keyword weight_years_experience:
        :paramtype weight_years_experience: float
        :keyword weight_occupation_group:
        :paramtype weight_occupation_group: float
        :keyword weight_education:
        :paramtype weight_education: float
        :keyword weight_skills:
        :paramtype weight_skills: float
        :keyword weight_languages:
        :paramtype weight_languages: float
        :keyword weight_management_level:
        :paramtype weight_management_level: float
        :keyword weight_keywords:
        :paramtype weight_keywords: float
        :keyword indices: List of index names.
        :paramtype indices: list[str]
        :keyword show_index_dropdown: Controls whether or not the index dropdown is displayed to the
         user.
        :paramtype show_index_dropdown: bool
        :keyword search_tool_theme: Customize the theme of the embeded search tool.
        :paramtype search_tool_theme: ~affinda.models.JobDescriptionSearchConfigSearchToolTheme
        :keyword actions: A list of actions to show in the dropdown in the embedded search tool.
        :paramtype actions: list[~affinda.models.SearchConfigAction]
        :keyword hide_toolbar: Hide the reset/import toolbar.
        :paramtype hide_toolbar: bool
        :keyword hide_side_panel: Hide the entire side panel.
        :paramtype hide_side_panel: bool
        :keyword custom_fields_config:
        :paramtype custom_fields_config: list[~affinda.models.CustomFieldConfig]
        :keyword distance_unit: The unit of distance to use for location based searches. Known values
         are: "mi", "km".
        :paramtype distance_unit: str or ~affinda.models.JobDescriptionSearchConfigDistanceUnit
        """
        super(JobDescriptionSearchConfig, self).__init__(**kwargs)
        self.allow_pdf_download = allow_pdf_download
        self.max_results = max_results
        self.display_job_title = display_job_title
        self.display_location = display_location
        self.display_years_experience = display_years_experience
        self.display_occupation_group = display_occupation_group
        self.display_education = display_education
        self.display_skills = display_skills
        self.display_languages = display_languages
        self.display_management_level = display_management_level
        self.display_keywords = display_keywords
        self.weight_job_title = weight_job_title
        self.weight_location = weight_location
        self.weight_years_experience = weight_years_experience
        self.weight_occupation_group = weight_occupation_group
        self.weight_education = weight_education
        self.weight_skills = weight_skills
        self.weight_languages = weight_languages
        self.weight_management_level = weight_management_level
        self.weight_keywords = weight_keywords
        self.indices = indices
        self.show_index_dropdown = show_index_dropdown
        self.search_tool_theme = search_tool_theme
        self.user_id = None
        self.username = None
        self.actions = actions
        self.hide_toolbar = hide_toolbar
        self.hide_side_panel = hide_side_panel
        self.custom_fields_config = custom_fields_config
        self.distance_unit = distance_unit


class ThemeConfig(msrest.serialization.Model):
    """ThemeConfig.

    :ivar palette:
    :vartype palette: ~affinda.models.ThemeConfigPalette
    :ivar typography:
    :vartype typography: ~affinda.models.ThemeConfigTypography
    :ivar border_radius:
    :vartype border_radius: float
    :ivar font_url:
    :vartype font_url: str
    """

    _attribute_map = {
        "palette": {"key": "palette", "type": "ThemeConfigPalette"},
        "typography": {"key": "typography", "type": "ThemeConfigTypography"},
        "border_radius": {"key": "borderRadius", "type": "float"},
        "font_url": {"key": "fontUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        palette: Optional["_models.ThemeConfigPalette"] = None,
        typography: Optional["_models.ThemeConfigTypography"] = None,
        border_radius: Optional[float] = None,
        font_url: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword palette:
        :paramtype palette: ~affinda.models.ThemeConfigPalette
        :keyword typography:
        :paramtype typography: ~affinda.models.ThemeConfigTypography
        :keyword border_radius:
        :paramtype border_radius: float
        :keyword font_url:
        :paramtype font_url: str
        """
        super(ThemeConfig, self).__init__(**kwargs)
        self.palette = palette
        self.typography = typography
        self.border_radius = border_radius
        self.font_url = font_url


class JobDescriptionSearchConfigSearchToolTheme(ThemeConfig):
    """Customize the theme of the embeded search tool.

    :ivar palette:
    :vartype palette: ~affinda.models.ThemeConfigPalette
    :ivar typography:
    :vartype typography: ~affinda.models.ThemeConfigTypography
    :ivar border_radius:
    :vartype border_radius: float
    :ivar font_url:
    :vartype font_url: str
    """

    _attribute_map = {
        "palette": {"key": "palette", "type": "ThemeConfigPalette"},
        "typography": {"key": "typography", "type": "ThemeConfigTypography"},
        "border_radius": {"key": "borderRadius", "type": "float"},
        "font_url": {"key": "fontUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        palette: Optional["_models.ThemeConfigPalette"] = None,
        typography: Optional["_models.ThemeConfigTypography"] = None,
        border_radius: Optional[float] = None,
        font_url: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword palette:
        :paramtype palette: ~affinda.models.ThemeConfigPalette
        :keyword typography:
        :paramtype typography: ~affinda.models.ThemeConfigTypography
        :keyword border_radius:
        :paramtype border_radius: float
        :keyword font_url:
        :paramtype font_url: str
        """
        super(JobDescriptionSearchConfigSearchToolTheme, self).__init__(
            palette=palette,
            typography=typography,
            border_radius=border_radius,
            font_url=font_url,
            **kwargs,
        )


class JobDescriptionSearchDetail(msrest.serialization.Model):
    """JobDescriptionSearchDetail.

    :ivar job_title:
    :vartype job_title: ~affinda.models.JobDescriptionSearchDetailJobTitle
    :ivar location:
    :vartype location: ~affinda.models.JobDescriptionSearchDetailLocation
    :ivar education:
    :vartype education: ~affinda.models.JobDescriptionSearchDetailEducation
    :ivar skills:
    :vartype skills: ~affinda.models.JobDescriptionSearchDetailSkills
    :ivar experience:
    :vartype experience: ~affinda.models.JobDescriptionSearchDetailExperience
    :ivar occupation_group:
    :vartype occupation_group: ~affinda.models.JobDescriptionSearchDetailOccupationGroup
    :ivar languages:
    :vartype languages: ~affinda.models.JobDescriptionSearchDetailLanguages
    :ivar management_level:
    :vartype management_level: ~affinda.models.JobDescriptionSearchDetailManagementLevel
    :ivar search_expression:
    :vartype search_expression: ~affinda.models.JobDescriptionSearchDetailSearchExpression
    """

    _attribute_map = {
        "job_title": {"key": "jobTitle", "type": "JobDescriptionSearchDetailJobTitle"},
        "location": {"key": "location", "type": "JobDescriptionSearchDetailLocation"},
        "education": {"key": "education", "type": "JobDescriptionSearchDetailEducation"},
        "skills": {"key": "skills", "type": "JobDescriptionSearchDetailSkills"},
        "experience": {"key": "experience", "type": "JobDescriptionSearchDetailExperience"},
        "occupation_group": {
            "key": "occupationGroup",
            "type": "JobDescriptionSearchDetailOccupationGroup",
        },
        "languages": {"key": "languages", "type": "JobDescriptionSearchDetailLanguages"},
        "management_level": {
            "key": "managementLevel",
            "type": "JobDescriptionSearchDetailManagementLevel",
        },
        "search_expression": {
            "key": "searchExpression",
            "type": "JobDescriptionSearchDetailSearchExpression",
        },
    }

    def __init__(
        self,
        *,
        job_title: Optional["_models.JobDescriptionSearchDetailJobTitle"] = None,
        location: Optional["_models.JobDescriptionSearchDetailLocation"] = None,
        education: Optional["_models.JobDescriptionSearchDetailEducation"] = None,
        skills: Optional["_models.JobDescriptionSearchDetailSkills"] = None,
        experience: Optional["_models.JobDescriptionSearchDetailExperience"] = None,
        occupation_group: Optional["_models.JobDescriptionSearchDetailOccupationGroup"] = None,
        languages: Optional["_models.JobDescriptionSearchDetailLanguages"] = None,
        management_level: Optional["_models.JobDescriptionSearchDetailManagementLevel"] = None,
        search_expression: Optional["_models.JobDescriptionSearchDetailSearchExpression"] = None,
        **kwargs,
    ):
        """
        :keyword job_title:
        :paramtype job_title: ~affinda.models.JobDescriptionSearchDetailJobTitle
        :keyword location:
        :paramtype location: ~affinda.models.JobDescriptionSearchDetailLocation
        :keyword education:
        :paramtype education: ~affinda.models.JobDescriptionSearchDetailEducation
        :keyword skills:
        :paramtype skills: ~affinda.models.JobDescriptionSearchDetailSkills
        :keyword experience:
        :paramtype experience: ~affinda.models.JobDescriptionSearchDetailExperience
        :keyword occupation_group:
        :paramtype occupation_group: ~affinda.models.JobDescriptionSearchDetailOccupationGroup
        :keyword languages:
        :paramtype languages: ~affinda.models.JobDescriptionSearchDetailLanguages
        :keyword management_level:
        :paramtype management_level: ~affinda.models.JobDescriptionSearchDetailManagementLevel
        :keyword search_expression:
        :paramtype search_expression: ~affinda.models.JobDescriptionSearchDetailSearchExpression
        """
        super(JobDescriptionSearchDetail, self).__init__(**kwargs)
        self.job_title = job_title
        self.location = location
        self.education = education
        self.skills = skills
        self.experience = experience
        self.occupation_group = occupation_group
        self.languages = languages
        self.management_level = management_level
        self.search_expression = search_expression


class JobDescriptionSearchDetailEducation(msrest.serialization.Model):
    """JobDescriptionSearchDetailEducation.

    :ivar missing:
    :vartype missing: ~affinda.models.JobDescriptionSearchDetailEducationMissing
    :ivar value:
    :vartype value: ~affinda.models.JobDescriptionSearchDetailEducationValue
    """

    _attribute_map = {
        "missing": {"key": "missing", "type": "JobDescriptionSearchDetailEducationMissing"},
        "value": {"key": "value", "type": "JobDescriptionSearchDetailEducationValue"},
    }

    def __init__(
        self,
        *,
        missing: Optional["_models.JobDescriptionSearchDetailEducationMissing"] = None,
        value: Optional["_models.JobDescriptionSearchDetailEducationValue"] = None,
        **kwargs,
    ):
        """
        :keyword missing:
        :paramtype missing: ~affinda.models.JobDescriptionSearchDetailEducationMissing
        :keyword value:
        :paramtype value: ~affinda.models.JobDescriptionSearchDetailEducationValue
        """
        super(JobDescriptionSearchDetailEducation, self).__init__(**kwargs)
        self.missing = missing
        self.value = value


class JobDescriptionSearchDetailEducationMissing(msrest.serialization.Model):
    """JobDescriptionSearchDetailEducationMissing.

    :ivar degrees:
    :vartype degrees: list[str]
    :ivar degree_types:
    :vartype degree_types: list[str]
    """

    _attribute_map = {
        "degrees": {"key": "degrees", "type": "[str]"},
        "degree_types": {"key": "degreeTypes", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        degrees: Optional[List[str]] = None,
        degree_types: Optional[List[str]] = None,
        **kwargs,
    ):
        """
        :keyword degrees:
        :paramtype degrees: list[str]
        :keyword degree_types:
        :paramtype degree_types: list[str]
        """
        super(JobDescriptionSearchDetailEducationMissing, self).__init__(**kwargs)
        self.degrees = degrees
        self.degree_types = degree_types


class JobDescriptionSearchDetailEducationValue(msrest.serialization.Model):
    """JobDescriptionSearchDetailEducationValue.

    :ivar degrees:
    :vartype degrees: list[str]
    :ivar degree_types:
    :vartype degree_types: list[str]
    :ivar match:
    :vartype match: bool
    """

    _attribute_map = {
        "degrees": {"key": "degrees", "type": "[str]"},
        "degree_types": {"key": "degreeTypes", "type": "[str]"},
        "match": {"key": "match", "type": "bool"},
    }

    def __init__(
        self,
        *,
        degrees: Optional[List[str]] = None,
        degree_types: Optional[List[str]] = None,
        match: Optional[bool] = None,
        **kwargs,
    ):
        """
        :keyword degrees:
        :paramtype degrees: list[str]
        :keyword degree_types:
        :paramtype degree_types: list[str]
        :keyword match:
        :paramtype match: bool
        """
        super(JobDescriptionSearchDetailEducationValue, self).__init__(**kwargs)
        self.degrees = degrees
        self.degree_types = degree_types
        self.match = match


class JobDescriptionSearchDetailExperience(msrest.serialization.Model):
    """JobDescriptionSearchDetailExperience.

    :ivar minimum_experience:
    :vartype minimum_experience: int
    :ivar maximum_experience:
    :vartype maximum_experience: int
    :ivar match:
    :vartype match: bool
    """

    _validation = {
        "minimum_experience": {"minimum": 0},
        "maximum_experience": {"minimum": 0},
    }

    _attribute_map = {
        "minimum_experience": {"key": "minimumExperience", "type": "int"},
        "maximum_experience": {"key": "maximumExperience", "type": "int"},
        "match": {"key": "match", "type": "bool"},
    }

    def __init__(
        self,
        *,
        minimum_experience: Optional[int] = None,
        maximum_experience: Optional[int] = None,
        match: Optional[bool] = None,
        **kwargs,
    ):
        """
        :keyword minimum_experience:
        :paramtype minimum_experience: int
        :keyword maximum_experience:
        :paramtype maximum_experience: int
        :keyword match:
        :paramtype match: bool
        """
        super(JobDescriptionSearchDetailExperience, self).__init__(**kwargs)
        self.minimum_experience = minimum_experience
        self.maximum_experience = maximum_experience
        self.match = match


class JobDescriptionSearchDetailJobTitle(msrest.serialization.Model):
    """JobDescriptionSearchDetailJobTitle.

    :ivar missing:
    :vartype missing: list[str]
    :ivar value:
    :vartype value: ~affinda.models.JobDescriptionSearchDetailJobTitleValue
    """

    _attribute_map = {
        "missing": {"key": "missing", "type": "[str]"},
        "value": {"key": "value", "type": "JobDescriptionSearchDetailJobTitleValue"},
    }

    def __init__(
        self,
        *,
        missing: Optional[List[str]] = None,
        value: Optional["_models.JobDescriptionSearchDetailJobTitleValue"] = None,
        **kwargs,
    ):
        """
        :keyword missing:
        :paramtype missing: list[str]
        :keyword value:
        :paramtype value: ~affinda.models.JobDescriptionSearchDetailJobTitleValue
        """
        super(JobDescriptionSearchDetailJobTitle, self).__init__(**kwargs)
        self.missing = missing
        self.value = value


class JobDescriptionSearchDetailJobTitleValue(msrest.serialization.Model):
    """JobDescriptionSearchDetailJobTitleValue.

    :ivar name:
    :vartype name: str
    :ivar company_name:
    :vartype company_name: str
    :ivar match:
    :vartype match: bool
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "company_name": {"key": "companyName", "type": "str"},
        "match": {"key": "match", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        company_name: Optional[str] = None,
        match: Optional[bool] = None,
        **kwargs,
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword company_name:
        :paramtype company_name: str
        :keyword match:
        :paramtype match: bool
        """
        super(JobDescriptionSearchDetailJobTitleValue, self).__init__(**kwargs)
        self.name = name
        self.company_name = company_name
        self.match = match


class JobDescriptionSearchDetailLanguages(msrest.serialization.Model):
    """JobDescriptionSearchDetailLanguages.

    :ivar missing:
    :vartype missing: list[~affinda.models.ResumeSearchParametersSkill]
    :ivar value:
    :vartype value: list[~affinda.models.JobDescriptionSearchDetailLanguagesValueItem]
    """

    _attribute_map = {
        "missing": {"key": "missing", "type": "[ResumeSearchParametersSkill]"},
        "value": {"key": "value", "type": "[JobDescriptionSearchDetailLanguagesValueItem]"},
    }

    def __init__(
        self,
        *,
        missing: Optional[List["_models.ResumeSearchParametersSkill"]] = None,
        value: Optional[List["_models.JobDescriptionSearchDetailLanguagesValueItem"]] = None,
        **kwargs,
    ):
        """
        :keyword missing:
        :paramtype missing: list[~affinda.models.ResumeSearchParametersSkill]
        :keyword value:
        :paramtype value: list[~affinda.models.JobDescriptionSearchDetailLanguagesValueItem]
        """
        super(JobDescriptionSearchDetailLanguages, self).__init__(**kwargs)
        self.missing = missing
        self.value = value


class JobDescriptionSearchDetailLanguagesValueItem(msrest.serialization.Model):
    """JobDescriptionSearchDetailLanguagesValueItem.

    :ivar name:
    :vartype name: str
    :ivar match:
    :vartype match: bool
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "match": {"key": "match", "type": "bool"},
    }

    def __init__(self, *, name: Optional[str] = None, match: Optional[bool] = None, **kwargs):
        """
        :keyword name:
        :paramtype name: str
        :keyword match:
        :paramtype match: bool
        """
        super(JobDescriptionSearchDetailLanguagesValueItem, self).__init__(**kwargs)
        self.name = name
        self.match = match


class JobDescriptionSearchDetailLocation(msrest.serialization.Model):
    """JobDescriptionSearchDetailLocation.

    :ivar missing:
    :vartype missing: list[~affinda.models.ResumeSearchParametersLocation]
    :ivar value:
    :vartype value: ~affinda.models.JobDescriptionSearchDetailLocationValue
    """

    _attribute_map = {
        "missing": {"key": "missing", "type": "[ResumeSearchParametersLocation]"},
        "value": {"key": "value", "type": "JobDescriptionSearchDetailLocationValue"},
    }

    def __init__(
        self,
        *,
        missing: Optional[List["_models.ResumeSearchParametersLocation"]] = None,
        value: Optional["_models.JobDescriptionSearchDetailLocationValue"] = None,
        **kwargs,
    ):
        """
        :keyword missing:
        :paramtype missing: list[~affinda.models.ResumeSearchParametersLocation]
        :keyword value:
        :paramtype value: ~affinda.models.JobDescriptionSearchDetailLocationValue
        """
        super(JobDescriptionSearchDetailLocation, self).__init__(**kwargs)
        self.missing = missing
        self.value = value


class Location(msrest.serialization.Model):
    """Location.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar formatted:
    :vartype formatted: str
    :ivar postal_code:
    :vartype postal_code: str
    :ivar state:
    :vartype state: str
    :ivar state_code:
    :vartype state_code: str
    :ivar country:
    :vartype country: str
    :ivar country_code: Two letter country code (ISO 3166-1 alpha-2).
    :vartype country_code: str
    :ivar raw_input: Required.
    :vartype raw_input: str
    :ivar street_number:
    :vartype street_number: str
    :ivar street:
    :vartype street: str
    :ivar apartment_number:
    :vartype apartment_number: str
    :ivar city:
    :vartype city: str
    :ivar latitude:
    :vartype latitude: float
    :ivar longitude:
    :vartype longitude: float
    :ivar po_box:
    :vartype po_box: str
    """

    _validation = {
        "formatted": {"readonly": True},
        "postal_code": {"readonly": True},
        "state": {"readonly": True},
        "state_code": {"readonly": True},
        "country": {"readonly": True},
        "country_code": {"readonly": True},
        "raw_input": {"required": True},
        "street_number": {"readonly": True},
        "street": {"readonly": True},
        "apartment_number": {"readonly": True},
        "city": {"readonly": True},
        "latitude": {"readonly": True},
        "longitude": {"readonly": True},
        "po_box": {"readonly": True},
    }

    _attribute_map = {
        "formatted": {"key": "formatted", "type": "str"},
        "postal_code": {"key": "postalCode", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "state_code": {"key": "stateCode", "type": "str"},
        "country": {"key": "country", "type": "str"},
        "country_code": {"key": "countryCode", "type": "str"},
        "raw_input": {"key": "rawInput", "type": "str"},
        "street_number": {"key": "streetNumber", "type": "str"},
        "street": {"key": "street", "type": "str"},
        "apartment_number": {"key": "apartmentNumber", "type": "str"},
        "city": {"key": "city", "type": "str"},
        "latitude": {"key": "latitude", "type": "float"},
        "longitude": {"key": "longitude", "type": "float"},
        "po_box": {"key": "poBox", "type": "str"},
    }

    def __init__(self, *, raw_input: str, **kwargs):
        """
        :keyword raw_input: Required.
        :paramtype raw_input: str
        """
        super(Location, self).__init__(**kwargs)
        self.formatted = None
        self.postal_code = None
        self.state = None
        self.state_code = None
        self.country = None
        self.country_code = None
        self.raw_input = raw_input
        self.street_number = None
        self.street = None
        self.apartment_number = None
        self.city = None
        self.latitude = None
        self.longitude = None
        self.po_box = None


class JobDescriptionSearchDetailLocationValue(
    Location,
    Components1TlnsonSchemasJobdescriptionsearchdetailPropertiesLocationPropertiesValueAllof1,
):
    """JobDescriptionSearchDetailLocationValue.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar match:
    :vartype match: bool
    :ivar formatted:
    :vartype formatted: str
    :ivar postal_code:
    :vartype postal_code: str
    :ivar state:
    :vartype state: str
    :ivar state_code:
    :vartype state_code: str
    :ivar country:
    :vartype country: str
    :ivar country_code: Two letter country code (ISO 3166-1 alpha-2).
    :vartype country_code: str
    :ivar raw_input: Required.
    :vartype raw_input: str
    :ivar street_number:
    :vartype street_number: str
    :ivar street:
    :vartype street: str
    :ivar apartment_number:
    :vartype apartment_number: str
    :ivar city:
    :vartype city: str
    :ivar latitude:
    :vartype latitude: float
    :ivar longitude:
    :vartype longitude: float
    :ivar po_box:
    :vartype po_box: str
    """

    _validation = {
        "formatted": {"readonly": True},
        "postal_code": {"readonly": True},
        "state": {"readonly": True},
        "state_code": {"readonly": True},
        "country": {"readonly": True},
        "country_code": {"readonly": True},
        "raw_input": {"required": True},
        "street_number": {"readonly": True},
        "street": {"readonly": True},
        "apartment_number": {"readonly": True},
        "city": {"readonly": True},
        "latitude": {"readonly": True},
        "longitude": {"readonly": True},
        "po_box": {"readonly": True},
    }

    _attribute_map = {
        "match": {"key": "match", "type": "bool"},
        "formatted": {"key": "formatted", "type": "str"},
        "postal_code": {"key": "postalCode", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "state_code": {"key": "stateCode", "type": "str"},
        "country": {"key": "country", "type": "str"},
        "country_code": {"key": "countryCode", "type": "str"},
        "raw_input": {"key": "rawInput", "type": "str"},
        "street_number": {"key": "streetNumber", "type": "str"},
        "street": {"key": "street", "type": "str"},
        "apartment_number": {"key": "apartmentNumber", "type": "str"},
        "city": {"key": "city", "type": "str"},
        "latitude": {"key": "latitude", "type": "float"},
        "longitude": {"key": "longitude", "type": "float"},
        "po_box": {"key": "poBox", "type": "str"},
    }

    def __init__(self, *, raw_input: str, match: Optional[bool] = None, **kwargs):
        """
        :keyword match:
        :paramtype match: bool
        :keyword raw_input: Required.
        :paramtype raw_input: str
        """
        super(JobDescriptionSearchDetailLocationValue, self).__init__(
            raw_input=raw_input, match=match, **kwargs
        )
        self.match = match
        self.formatted = None
        self.postal_code = None
        self.state = None
        self.state_code = None
        self.country = None
        self.country_code = None
        self.raw_input = raw_input
        self.street_number = None
        self.street = None
        self.apartment_number = None
        self.city = None
        self.latitude = None
        self.longitude = None
        self.po_box = None


class JobDescriptionSearchDetailManagementLevel(msrest.serialization.Model):
    """JobDescriptionSearchDetailManagementLevel.

    :ivar level: Known values are: "None", "Low", "Mid", "Upper".
    :vartype level: str or ~affinda.models.ManagementLevel
    :ivar match:
    :vartype match: bool
    """

    _attribute_map = {
        "level": {"key": "level", "type": "str"},
        "match": {"key": "match", "type": "bool"},
    }

    def __init__(
        self,
        *,
        level: Optional[Union[str, "_models.ManagementLevel"]] = None,
        match: Optional[bool] = None,
        **kwargs,
    ):
        """
        :keyword level: Known values are: "None", "Low", "Mid", "Upper".
        :paramtype level: str or ~affinda.models.ManagementLevel
        :keyword match:
        :paramtype match: bool
        """
        super(JobDescriptionSearchDetailManagementLevel, self).__init__(**kwargs)
        self.level = level
        self.match = match


class JobDescriptionSearchDetailOccupationGroup(msrest.serialization.Model):
    """JobDescriptionSearchDetailOccupationGroup.

    :ivar missing:
    :vartype missing: list[int]
    :ivar value:
    :vartype value: ~affinda.models.JobDescriptionSearchDetailOccupationGroupValue
    """

    _attribute_map = {
        "missing": {"key": "missing", "type": "[int]"},
        "value": {"key": "value", "type": "JobDescriptionSearchDetailOccupationGroupValue"},
    }

    def __init__(
        self,
        *,
        missing: Optional[List[int]] = None,
        value: Optional["_models.JobDescriptionSearchDetailOccupationGroupValue"] = None,
        **kwargs,
    ):
        """
        :keyword missing:
        :paramtype missing: list[int]
        :keyword value:
        :paramtype value: ~affinda.models.JobDescriptionSearchDetailOccupationGroupValue
        """
        super(JobDescriptionSearchDetailOccupationGroup, self).__init__(**kwargs)
        self.missing = missing
        self.value = value


class OccupationGroupSearchResult(msrest.serialization.Model):
    """OccupationGroupSearchResult.

    All required parameters must be populated in order to send to Azure.

    :ivar match:
    :vartype match: bool
    :ivar code: Required.
    :vartype code: int
    :ivar name: Required.
    :vartype name: str
    :ivar children:
    :vartype children: list[~affinda.models.OccupationGroup]
    :ivar parents:
    :vartype parents: list[~affinda.models.OccupationGroup]
    """

    _validation = {
        "code": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "match": {"key": "match", "type": "bool"},
        "code": {"key": "code", "type": "int"},
        "name": {"key": "name", "type": "str"},
        "children": {"key": "children", "type": "[OccupationGroup]"},
        "parents": {"key": "parents", "type": "[OccupationGroup]"},
    }

    def __init__(
        self,
        *,
        code: int,
        name: str,
        match: Optional[bool] = None,
        children: Optional[List["_models.OccupationGroup"]] = None,
        parents: Optional[List["_models.OccupationGroup"]] = None,
        **kwargs,
    ):
        """
        :keyword match:
        :paramtype match: bool
        :keyword code: Required.
        :paramtype code: int
        :keyword name: Required.
        :paramtype name: str
        :keyword children:
        :paramtype children: list[~affinda.models.OccupationGroup]
        :keyword parents:
        :paramtype parents: list[~affinda.models.OccupationGroup]
        """
        super(OccupationGroupSearchResult, self).__init__(**kwargs)
        self.match = match
        self.code = code
        self.name = name
        self.children = children
        self.parents = parents


class JobDescriptionSearchDetailOccupationGroupValue(OccupationGroupSearchResult):
    """JobDescriptionSearchDetailOccupationGroupValue.

    All required parameters must be populated in order to send to Azure.

    :ivar match:
    :vartype match: bool
    :ivar code: Required.
    :vartype code: int
    :ivar name: Required.
    :vartype name: str
    :ivar children:
    :vartype children: list[~affinda.models.OccupationGroup]
    :ivar parents:
    :vartype parents: list[~affinda.models.OccupationGroup]
    """

    _validation = {
        "code": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "match": {"key": "match", "type": "bool"},
        "code": {"key": "code", "type": "int"},
        "name": {"key": "name", "type": "str"},
        "children": {"key": "children", "type": "[OccupationGroup]"},
        "parents": {"key": "parents", "type": "[OccupationGroup]"},
    }

    def __init__(
        self,
        *,
        code: int,
        name: str,
        match: Optional[bool] = None,
        children: Optional[List["_models.OccupationGroup"]] = None,
        parents: Optional[List["_models.OccupationGroup"]] = None,
        **kwargs,
    ):
        """
        :keyword match:
        :paramtype match: bool
        :keyword code: Required.
        :paramtype code: int
        :keyword name: Required.
        :paramtype name: str
        :keyword children:
        :paramtype children: list[~affinda.models.OccupationGroup]
        :keyword parents:
        :paramtype parents: list[~affinda.models.OccupationGroup]
        """
        super(JobDescriptionSearchDetailOccupationGroupValue, self).__init__(
            match=match, code=code, name=name, children=children, parents=parents, **kwargs
        )


class JobDescriptionSearchDetailSearchExpression(msrest.serialization.Model):
    """JobDescriptionSearchDetailSearchExpression.

    :ivar missing:
    :vartype missing: list[str]
    :ivar value:
    :vartype value: list[str]
    """

    _attribute_map = {
        "missing": {"key": "missing", "type": "[str]"},
        "value": {"key": "value", "type": "[str]"},
    }

    def __init__(
        self, *, missing: Optional[List[str]] = None, value: Optional[List[str]] = None, **kwargs
    ):
        """
        :keyword missing:
        :paramtype missing: list[str]
        :keyword value:
        :paramtype value: list[str]
        """
        super(JobDescriptionSearchDetailSearchExpression, self).__init__(**kwargs)
        self.missing = missing
        self.value = value


class JobDescriptionSearchDetailSkills(msrest.serialization.Model):
    """JobDescriptionSearchDetailSkills.

    :ivar missing:
    :vartype missing: list[~affinda.models.ResumeSearchParametersSkill]
    :ivar value:
    :vartype value: list[~affinda.models.JobDescriptionSearchDetailSkillsValueItem]
    """

    _attribute_map = {
        "missing": {"key": "missing", "type": "[ResumeSearchParametersSkill]"},
        "value": {"key": "value", "type": "[JobDescriptionSearchDetailSkillsValueItem]"},
    }

    def __init__(
        self,
        *,
        missing: Optional[List["_models.ResumeSearchParametersSkill"]] = None,
        value: Optional[List["_models.JobDescriptionSearchDetailSkillsValueItem"]] = None,
        **kwargs,
    ):
        """
        :keyword missing:
        :paramtype missing: list[~affinda.models.ResumeSearchParametersSkill]
        :keyword value:
        :paramtype value: list[~affinda.models.JobDescriptionSearchDetailSkillsValueItem]
        """
        super(JobDescriptionSearchDetailSkills, self).__init__(**kwargs)
        self.missing = missing
        self.value = value


class JobDescriptionSearchDetailSkillsValueItem(msrest.serialization.Model):
    """JobDescriptionSearchDetailSkillsValueItem.

    :ivar name:
    :vartype name: str
    :ivar match:
    :vartype match: bool
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "match": {"key": "match", "type": "bool"},
    }

    def __init__(self, *, name: Optional[str] = None, match: Optional[bool] = None, **kwargs):
        """
        :keyword name:
        :paramtype name: str
        :keyword match:
        :paramtype match: bool
        """
        super(JobDescriptionSearchDetailSkillsValueItem, self).__init__(**kwargs)
        self.name = name
        self.match = match


class JobDescriptionSearchEmbed(msrest.serialization.Model):
    """JobDescriptionSearchEmbed.

    :ivar url: The signed URL for the embedable search tool.
    :vartype url: str
    """

    _attribute_map = {
        "url": {"key": "url", "type": "str"},
    }

    def __init__(self, *, url: Optional[str] = None, **kwargs):
        """
        :keyword url: The signed URL for the embedable search tool.
        :paramtype url: str
        """
        super(JobDescriptionSearchEmbed, self).__init__(**kwargs)
        self.url = url


class JobDescriptionSearchParameters(msrest.serialization.Model):
    """JobDescriptionSearchParameters.

    All required parameters must be populated in order to send to Azure.

    :ivar indices: Required.
    :vartype indices: list[str]
    :ivar resume: A random string that uniquely identify the resource.
    :vartype resume: str
    :ivar job_titles:
    :vartype job_titles: list[str]
    :ivar job_titles_required:
    :vartype job_titles_required: bool
    :ivar job_titles_weight:
    :vartype job_titles_weight: float
    :ivar total_years_experience:
    :vartype total_years_experience: float
    :ivar years_experience_required:
    :vartype years_experience_required: bool
    :ivar years_experience_weight:
    :vartype years_experience_weight: float
    :ivar locations:
    :vartype locations: list[~affinda.models.ResumeSearchParametersLocation]
    :ivar locations_weight:
    :vartype locations_weight: float
    :ivar locations_required:
    :vartype locations_required: bool
    :ivar skills:
    :vartype skills: list[~affinda.models.ResumeSearchParametersSkill]
    :ivar skills_weight:
    :vartype skills_weight: float
    :ivar languages:
    :vartype languages: list[~affinda.models.ResumeSearchParametersSkill]
    :ivar languages_weight:
    :vartype languages_weight: float
    :ivar degrees:
    :vartype degrees: list[str]
    :ivar degrees_required:
    :vartype degrees_required: bool
    :ivar degree_types:
    :vartype degree_types: list[str or ~affinda.models.EducationLevel]
    :ivar degree_types_required:
    :vartype degree_types_required: bool
    :ivar education_weight:
    :vartype education_weight: float
    :ivar search_expression:
    :vartype search_expression: str
    :ivar search_expression_required:
    :vartype search_expression_required: bool
    :ivar search_expression_weight:
    :vartype search_expression_weight: float
    :ivar soc_codes:
    :vartype soc_codes: list[int]
    :ivar soc_codes_weight:
    :vartype soc_codes_weight: float
    :ivar soc_codes_required:
    :vartype soc_codes_required: bool
    :ivar management_level: Known values are: "None", "Low", "Mid", "Upper".
    :vartype management_level: str or ~affinda.models.ManagementLevel
    :ivar management_level_required:
    :vartype management_level_required: bool
    :ivar management_level_weight:
    :vartype management_level_weight: float
    :ivar custom_data:
    :vartype custom_data: list[~affinda.models.SearchParametersCustomData]
    """

    _validation = {
        "indices": {"required": True},
        "job_titles_weight": {"maximum": 1, "minimum": 0},
        "years_experience_weight": {"maximum": 1, "minimum": 0},
        "locations_weight": {"maximum": 1, "minimum": 0},
        "skills_weight": {"maximum": 1, "minimum": 0},
        "languages_weight": {"maximum": 1, "minimum": 0},
        "degree_types": {"unique": True},
        "education_weight": {"maximum": 1, "minimum": 0},
        "search_expression_weight": {"maximum": 1, "minimum": 0},
        "soc_codes_weight": {"maximum": 1, "minimum": 0},
        "management_level_weight": {"maximum": 1, "minimum": 0},
    }

    _attribute_map = {
        "indices": {"key": "indices", "type": "[str]"},
        "resume": {"key": "resume", "type": "str"},
        "job_titles": {"key": "jobTitles", "type": "[str]"},
        "job_titles_required": {"key": "jobTitlesRequired", "type": "bool"},
        "job_titles_weight": {"key": "jobTitlesWeight", "type": "float"},
        "total_years_experience": {"key": "totalYearsExperience", "type": "float"},
        "years_experience_required": {"key": "yearsExperienceRequired", "type": "bool"},
        "years_experience_weight": {"key": "yearsExperienceWeight", "type": "float"},
        "locations": {"key": "locations", "type": "[ResumeSearchParametersLocation]"},
        "locations_weight": {"key": "locationsWeight", "type": "float"},
        "locations_required": {"key": "locationsRequired", "type": "bool"},
        "skills": {"key": "skills", "type": "[ResumeSearchParametersSkill]"},
        "skills_weight": {"key": "skillsWeight", "type": "float"},
        "languages": {"key": "languages", "type": "[ResumeSearchParametersSkill]"},
        "languages_weight": {"key": "languagesWeight", "type": "float"},
        "degrees": {"key": "degrees", "type": "[str]"},
        "degrees_required": {"key": "degreesRequired", "type": "bool"},
        "degree_types": {"key": "degreeTypes", "type": "[str]"},
        "degree_types_required": {"key": "degreeTypesRequired", "type": "bool"},
        "education_weight": {"key": "educationWeight", "type": "float"},
        "search_expression": {"key": "searchExpression", "type": "str"},
        "search_expression_required": {"key": "searchExpressionRequired", "type": "bool"},
        "search_expression_weight": {"key": "searchExpressionWeight", "type": "float"},
        "soc_codes": {"key": "socCodes", "type": "[int]"},
        "soc_codes_weight": {"key": "socCodesWeight", "type": "float"},
        "soc_codes_required": {"key": "socCodesRequired", "type": "bool"},
        "management_level": {"key": "managementLevel", "type": "str"},
        "management_level_required": {"key": "managementLevelRequired", "type": "bool"},
        "management_level_weight": {"key": "managementLevelWeight", "type": "float"},
        "custom_data": {"key": "customData", "type": "[SearchParametersCustomData]"},
    }

    def __init__(
        self,
        *,
        indices: List[str],
        resume: Optional[str] = None,
        job_titles: Optional[List[str]] = None,
        job_titles_required: Optional[bool] = None,
        job_titles_weight: Optional[float] = None,
        total_years_experience: Optional[float] = None,
        years_experience_required: Optional[bool] = None,
        years_experience_weight: Optional[float] = None,
        locations: Optional[List["_models.ResumeSearchParametersLocation"]] = None,
        locations_weight: Optional[float] = None,
        locations_required: Optional[bool] = None,
        skills: Optional[List["_models.ResumeSearchParametersSkill"]] = None,
        skills_weight: Optional[float] = None,
        languages: Optional[List["_models.ResumeSearchParametersSkill"]] = None,
        languages_weight: Optional[float] = None,
        degrees: Optional[List[str]] = None,
        degrees_required: Optional[bool] = None,
        degree_types: Optional[List[Union[str, "_models.EducationLevel"]]] = None,
        degree_types_required: Optional[bool] = None,
        education_weight: Optional[float] = None,
        search_expression: Optional[str] = None,
        search_expression_required: Optional[bool] = None,
        search_expression_weight: Optional[float] = None,
        soc_codes: Optional[List[int]] = None,
        soc_codes_weight: Optional[float] = None,
        soc_codes_required: Optional[bool] = None,
        management_level: Optional[Union[str, "_models.ManagementLevel"]] = None,
        management_level_required: Optional[bool] = None,
        management_level_weight: Optional[float] = None,
        custom_data: Optional[List["_models.SearchParametersCustomData"]] = None,
        **kwargs,
    ):
        """
        :keyword indices: Required.
        :paramtype indices: list[str]
        :keyword resume: A random string that uniquely identify the resource.
        :paramtype resume: str
        :keyword job_titles:
        :paramtype job_titles: list[str]
        :keyword job_titles_required:
        :paramtype job_titles_required: bool
        :keyword job_titles_weight:
        :paramtype job_titles_weight: float
        :keyword total_years_experience:
        :paramtype total_years_experience: float
        :keyword years_experience_required:
        :paramtype years_experience_required: bool
        :keyword years_experience_weight:
        :paramtype years_experience_weight: float
        :keyword locations:
        :paramtype locations: list[~affinda.models.ResumeSearchParametersLocation]
        :keyword locations_weight:
        :paramtype locations_weight: float
        :keyword locations_required:
        :paramtype locations_required: bool
        :keyword skills:
        :paramtype skills: list[~affinda.models.ResumeSearchParametersSkill]
        :keyword skills_weight:
        :paramtype skills_weight: float
        :keyword languages:
        :paramtype languages: list[~affinda.models.ResumeSearchParametersSkill]
        :keyword languages_weight:
        :paramtype languages_weight: float
        :keyword degrees:
        :paramtype degrees: list[str]
        :keyword degrees_required:
        :paramtype degrees_required: bool
        :keyword degree_types:
        :paramtype degree_types: list[str or ~affinda.models.EducationLevel]
        :keyword degree_types_required:
        :paramtype degree_types_required: bool
        :keyword education_weight:
        :paramtype education_weight: float
        :keyword search_expression:
        :paramtype search_expression: str
        :keyword search_expression_required:
        :paramtype search_expression_required: bool
        :keyword search_expression_weight:
        :paramtype search_expression_weight: float
        :keyword soc_codes:
        :paramtype soc_codes: list[int]
        :keyword soc_codes_weight:
        :paramtype soc_codes_weight: float
        :keyword soc_codes_required:
        :paramtype soc_codes_required: bool
        :keyword management_level: Known values are: "None", "Low", "Mid", "Upper".
        :paramtype management_level: str or ~affinda.models.ManagementLevel
        :keyword management_level_required:
        :paramtype management_level_required: bool
        :keyword management_level_weight:
        :paramtype management_level_weight: float
        :keyword custom_data:
        :paramtype custom_data: list[~affinda.models.SearchParametersCustomData]
        """
        super(JobDescriptionSearchParameters, self).__init__(**kwargs)
        self.indices = indices
        self.resume = resume
        self.job_titles = job_titles
        self.job_titles_required = job_titles_required
        self.job_titles_weight = job_titles_weight
        self.total_years_experience = total_years_experience
        self.years_experience_required = years_experience_required
        self.years_experience_weight = years_experience_weight
        self.locations = locations
        self.locations_weight = locations_weight
        self.locations_required = locations_required
        self.skills = skills
        self.skills_weight = skills_weight
        self.languages = languages
        self.languages_weight = languages_weight
        self.degrees = degrees
        self.degrees_required = degrees_required
        self.degree_types = degree_types
        self.degree_types_required = degree_types_required
        self.education_weight = education_weight
        self.search_expression = search_expression
        self.search_expression_required = search_expression_required
        self.search_expression_weight = search_expression_weight
        self.soc_codes = soc_codes
        self.soc_codes_weight = soc_codes_weight
        self.soc_codes_required = soc_codes_required
        self.management_level = management_level
        self.management_level_required = management_level_required
        self.management_level_weight = management_level_weight
        self.custom_data = custom_data


class JobDescriptionSearchResult(msrest.serialization.Model):
    """JobDescriptionSearchResult.

    All required parameters must be populated in order to send to Azure.

    :ivar identifier: Required. A random string that uniquely identify the resource.
    :vartype identifier: str
    :ivar score: Required.
    :vartype score: float
    :ivar pdf: Required.
    :vartype pdf: str
    :ivar job_title: Required.
    :vartype job_title: ~affinda.models.JobTitleSearchScoreComponent
    :ivar management_level: Required.
    :vartype management_level: ~affinda.models.ManagementLevelSearchScoreComponent
    :ivar experience: Required.
    :vartype experience: ~affinda.models.ExperienceSearchScoreComponent
    :ivar skills: Required.
    :vartype skills: ~affinda.models.SkillsSearchScoreComponent
    :ivar languages: Required.
    :vartype languages: ~affinda.models.LanguagesSearchScoreComponent
    :ivar location: Required.
    :vartype location: ~affinda.models.LocationSearchScoreComponent
    :ivar education: Required.
    :vartype education: ~affinda.models.EducationSearchScoreComponent
    :ivar occupation_group:
    :vartype occupation_group: ~affinda.models.OccupationGroupSearchScoreComponent
    :ivar search_expression: Required.
    :vartype search_expression: ~affinda.models.SearchExpressionSearchScoreComponent
    :ivar organization_name: Required.
    :vartype organization_name: str
    :ivar custom_data: Required. Dictionary of
     <components·nqbw24·schemas·customdatasearchscorecomponent·additionalproperties>.
    :vartype custom_data: dict[str,
     ~affinda.models.ComponentsNqbw24SchemasCustomdatasearchscorecomponentAdditionalproperties]
    """

    _validation = {
        "identifier": {"required": True},
        "score": {"required": True},
        "pdf": {"required": True},
        "job_title": {"required": True},
        "management_level": {"required": True},
        "experience": {"required": True},
        "skills": {"required": True},
        "languages": {"required": True},
        "location": {"required": True},
        "education": {"required": True},
        "search_expression": {"required": True},
        "organization_name": {"required": True},
        "custom_data": {"required": True},
    }

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "score": {"key": "score", "type": "float"},
        "pdf": {"key": "pdf", "type": "str"},
        "job_title": {"key": "jobTitle", "type": "JobTitleSearchScoreComponent"},
        "management_level": {
            "key": "managementLevel",
            "type": "ManagementLevelSearchScoreComponent",
        },
        "experience": {"key": "experience", "type": "ExperienceSearchScoreComponent"},
        "skills": {"key": "skills", "type": "SkillsSearchScoreComponent"},
        "languages": {"key": "languages", "type": "LanguagesSearchScoreComponent"},
        "location": {"key": "location", "type": "LocationSearchScoreComponent"},
        "education": {"key": "education", "type": "EducationSearchScoreComponent"},
        "occupation_group": {
            "key": "occupationGroup",
            "type": "OccupationGroupSearchScoreComponent",
        },
        "search_expression": {
            "key": "searchExpression",
            "type": "SearchExpressionSearchScoreComponent",
        },
        "organization_name": {"key": "organizationName", "type": "str"},
        "custom_data": {
            "key": "customData",
            "type": "{ComponentsNqbw24SchemasCustomdatasearchscorecomponentAdditionalproperties}",
        },
    }

    def __init__(
        self,
        *,
        identifier: str,
        score: float,
        pdf: str,
        job_title: "_models.JobTitleSearchScoreComponent",
        management_level: "_models.ManagementLevelSearchScoreComponent",
        experience: "_models.ExperienceSearchScoreComponent",
        skills: "_models.SkillsSearchScoreComponent",
        languages: "_models.LanguagesSearchScoreComponent",
        location: "_models.LocationSearchScoreComponent",
        education: "_models.EducationSearchScoreComponent",
        search_expression: "_models.SearchExpressionSearchScoreComponent",
        organization_name: str,
        custom_data: Dict[
            str,
            "_models.ComponentsNqbw24SchemasCustomdatasearchscorecomponentAdditionalproperties",
        ],
        occupation_group: Optional["_models.OccupationGroupSearchScoreComponent"] = None,
        **kwargs,
    ):
        """
        :keyword identifier: Required. A random string that uniquely identify the resource.
        :paramtype identifier: str
        :keyword score: Required.
        :paramtype score: float
        :keyword pdf: Required.
        :paramtype pdf: str
        :keyword job_title: Required.
        :paramtype job_title: ~affinda.models.JobTitleSearchScoreComponent
        :keyword management_level: Required.
        :paramtype management_level: ~affinda.models.ManagementLevelSearchScoreComponent
        :keyword experience: Required.
        :paramtype experience: ~affinda.models.ExperienceSearchScoreComponent
        :keyword skills: Required.
        :paramtype skills: ~affinda.models.SkillsSearchScoreComponent
        :keyword languages: Required.
        :paramtype languages: ~affinda.models.LanguagesSearchScoreComponent
        :keyword location: Required.
        :paramtype location: ~affinda.models.LocationSearchScoreComponent
        :keyword education: Required.
        :paramtype education: ~affinda.models.EducationSearchScoreComponent
        :keyword occupation_group:
        :paramtype occupation_group: ~affinda.models.OccupationGroupSearchScoreComponent
        :keyword search_expression: Required.
        :paramtype search_expression: ~affinda.models.SearchExpressionSearchScoreComponent
        :keyword organization_name: Required.
        :paramtype organization_name: str
        :keyword custom_data: Required. Dictionary of
         <components·nqbw24·schemas·customdatasearchscorecomponent·additionalproperties>.
        :paramtype custom_data: dict[str,
         ~affinda.models.ComponentsNqbw24SchemasCustomdatasearchscorecomponentAdditionalproperties]
        """
        super(JobDescriptionSearchResult, self).__init__(**kwargs)
        self.identifier = identifier
        self.score = score
        self.pdf = pdf
        self.job_title = job_title
        self.management_level = management_level
        self.experience = experience
        self.skills = skills
        self.languages = languages
        self.location = location
        self.education = education
        self.occupation_group = occupation_group
        self.search_expression = search_expression
        self.organization_name = organization_name
        self.custom_data = custom_data


class JobTitleAnnotation(Annotation):
    """JobTitleAnnotation.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required. Annotation's ID.
    :vartype id: int
    :ivar rectangle: Required. x/y coordinates for the rectangular bounding box containing the
     data.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required. x/y coordinates for the rectangles containing the data. An
     annotation can be contained within multiple rectangles.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar document: Required. Unique identifier for the document.
    :vartype document: str
    :ivar page_index: Required. The page number within the document, starting from 0.
    :vartype page_index: int
    :ivar raw: Required. Raw data extracted from the before any post-processing.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required. Indicates whether the data has been validated, either by a human
     using our validation tool or through auto-validation rules.
    :vartype is_verified: bool
    :ivar is_client_verified: Required. Indicates whether the data has been validated by a human.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required. Indicates whether the data has been auto-validated.
    :vartype is_auto_verified: bool
    :ivar data_point: Data point's identifier.
    :vartype data_point: str
    :ivar field: Field's identifier.
    :vartype field: str
    :ivar content_type: Required. The different data types of annotations. Known values are:
     "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
     "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
     "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
    :vartype content_type: str or ~affinda.models.AnnotationContentType
    :ivar parent: The parent annotation's ID.
    :vartype parent: int
    :ivar parsed: Years of experience range.
    :vartype parsed: ~affinda.models.JobTitleAnnotationParsed
    """

    _validation = {
        "id": {"required": True, "minimum": 1},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "document": {"required": True},
        "page_index": {"required": True, "minimum": 0},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "document": {"key": "document", "type": "str"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "field": {"key": "field", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parent": {"key": "parent", "type": "int"},
        "parsed": {"key": "parsed", "type": "JobTitleAnnotationParsed"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        document: str,
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        content_type: Union[str, "_models.AnnotationContentType"],
        additional_properties: Optional[Dict[str, Any]] = None,
        data_point: Optional[str] = None,
        field: Optional[str] = None,
        parent: Optional[int] = None,
        parsed: Optional["_models.JobTitleAnnotationParsed"] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required. Annotation's ID.
        :paramtype id: int
        :keyword rectangle: Required. x/y coordinates for the rectangular bounding box containing the
         data.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required. x/y coordinates for the rectangles containing the data. An
         annotation can be contained within multiple rectangles.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword document: Required. Unique identifier for the document.
        :paramtype document: str
        :keyword page_index: Required. The page number within the document, starting from 0.
        :paramtype page_index: int
        :keyword raw: Required. Raw data extracted from the before any post-processing.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required. Indicates whether the data has been validated, either by a
         human using our validation tool or through auto-validation rules.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required. Indicates whether the data has been validated by a
         human.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required. Indicates whether the data has been auto-validated.
        :paramtype is_auto_verified: bool
        :keyword data_point: Data point's identifier.
        :paramtype data_point: str
        :keyword field: Field's identifier.
        :paramtype field: str
        :keyword content_type: Required. The different data types of annotations. Known values are:
         "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
         "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
         "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
        :paramtype content_type: str or ~affinda.models.AnnotationContentType
        :keyword parent: The parent annotation's ID.
        :paramtype parent: int
        :keyword parsed: Years of experience range.
        :paramtype parsed: ~affinda.models.JobTitleAnnotationParsed
        """
        super(JobTitleAnnotation, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            document=document,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            field=field,
            content_type=content_type,
            parent=parent,
            **kwargs,
        )
        self.parsed = parsed


class JobTitleAnnotationParsed(msrest.serialization.Model):
    """Years of experience range.

    :ivar name:
    :vartype name: str
    :ivar management_level:
    :vartype management_level: str
    :ivar classification:
    :vartype classification: ~affinda.models.JobTitleAnnotationParsedClassification
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "management_level": {"key": "managementLevel", "type": "str"},
        "classification": {
            "key": "classification",
            "type": "JobTitleAnnotationParsedClassification",
        },
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        management_level: Optional[str] = None,
        classification: Optional["_models.JobTitleAnnotationParsedClassification"] = None,
        **kwargs,
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword management_level:
        :paramtype management_level: str
        :keyword classification:
        :paramtype classification: ~affinda.models.JobTitleAnnotationParsedClassification
        """
        super(JobTitleAnnotationParsed, self).__init__(**kwargs)
        self.name = name
        self.management_level = management_level
        self.classification = classification


class JobTitleAnnotationParsedClassification(msrest.serialization.Model):
    """JobTitleAnnotationParsedClassification.

    :ivar soc_code:
    :vartype soc_code: float
    :ivar title:
    :vartype title: str
    :ivar minor_group:
    :vartype minor_group: str
    :ivar sub_major_group:
    :vartype sub_major_group: str
    :ivar major_group:
    :vartype major_group: str
    :ivar minor_group_code: The 4 digit code representing the SOC2020 classification for this job
     title.
    :vartype minor_group_code: int
    :ivar sub_major_group_code: The 4 digit code representing the SOC2020 classification for this
     job title.
    :vartype sub_major_group_code: int
    :ivar major_group_code: The 4 digit code representing the SOC2020 classification for this job
     title.
    :vartype major_group_code: int
    """

    _validation = {
        "minor_group_code": {"maximum": 9999, "minimum": 1},
        "sub_major_group_code": {"maximum": 9999, "minimum": 1},
        "major_group_code": {"maximum": 9999, "minimum": 1},
    }

    _attribute_map = {
        "soc_code": {"key": "socCode", "type": "float"},
        "title": {"key": "title", "type": "str"},
        "minor_group": {"key": "minorGroup", "type": "str"},
        "sub_major_group": {"key": "subMajorGroup", "type": "str"},
        "major_group": {"key": "majorGroup", "type": "str"},
        "minor_group_code": {"key": "minorGroupCode", "type": "int"},
        "sub_major_group_code": {"key": "subMajorGroupCode", "type": "int"},
        "major_group_code": {"key": "majorGroupCode", "type": "int"},
    }

    def __init__(
        self,
        *,
        soc_code: Optional[float] = None,
        title: Optional[str] = None,
        minor_group: Optional[str] = None,
        sub_major_group: Optional[str] = None,
        major_group: Optional[str] = None,
        minor_group_code: Optional[int] = None,
        sub_major_group_code: Optional[int] = None,
        major_group_code: Optional[int] = None,
        **kwargs,
    ):
        """
        :keyword soc_code:
        :paramtype soc_code: float
        :keyword title:
        :paramtype title: str
        :keyword minor_group:
        :paramtype minor_group: str
        :keyword sub_major_group:
        :paramtype sub_major_group: str
        :keyword major_group:
        :paramtype major_group: str
        :keyword minor_group_code: The 4 digit code representing the SOC2020 classification for this
         job title.
        :paramtype minor_group_code: int
        :keyword sub_major_group_code: The 4 digit code representing the SOC2020 classification for
         this job title.
        :paramtype sub_major_group_code: int
        :keyword major_group_code: The 4 digit code representing the SOC2020 classification for this
         job title.
        :paramtype major_group_code: int
        """
        super(JobTitleAnnotationParsedClassification, self).__init__(**kwargs)
        self.soc_code = soc_code
        self.title = title
        self.minor_group = minor_group
        self.sub_major_group = sub_major_group
        self.major_group = major_group
        self.minor_group_code = minor_group_code
        self.sub_major_group_code = sub_major_group_code
        self.major_group_code = major_group_code


class JobTitleParsed(msrest.serialization.Model):
    """JobTitleParsed.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar parsed: Matching job title to extracted text.
    :vartype parsed: ~affinda.models.JobTitleParsedParsed
    """

    _validation = {
        "parsed": {"readonly": True},
    }

    _attribute_map = {
        "parsed": {"key": "parsed", "type": "JobTitleParsedParsed"},
    }

    def __init__(self, **kwargs):
        """ """
        super(JobTitleParsed, self).__init__(**kwargs)
        self.parsed = None


class JobTitleAnnotationUpdate(AnnotationBase, JobTitleParsed):
    """JobTitleAnnotationUpdate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar parsed: Matching job title to extracted text.
    :vartype parsed: ~affinda.models.JobTitleParsedParsed
    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id:
    :vartype id: int
    :ivar rectangle:
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles:
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index:
    :vartype page_index: int
    :ivar raw:
    :vartype raw: str
    :ivar confidence: The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: The model's confidence that the text has been classified
     correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: If the document was submitted as an image, this is the
     confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified:
    :vartype is_verified: bool
    :ivar is_client_verified:
    :vartype is_client_verified: bool
    :ivar is_auto_verified:
    :vartype is_auto_verified: bool
    :ivar data_point:
    :vartype data_point: str
    :ivar content_type:
    :vartype content_type: str
    """

    _validation = {
        "parsed": {"readonly": True},
        "rectangles": {"readonly": True},
    }

    _attribute_map = {
        "parsed": {"key": "parsed", "type": "JobTitleParsedParsed"},
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        id: Optional[int] = None,
        rectangle: Optional["_models.Rectangle"] = None,
        page_index: Optional[int] = None,
        raw: Optional[str] = None,
        confidence: Optional[float] = None,
        classification_confidence: Optional[float] = None,
        text_extraction_confidence: Optional[float] = None,
        is_verified: Optional[bool] = None,
        is_client_verified: Optional[bool] = None,
        is_auto_verified: Optional[bool] = None,
        data_point: Optional[str] = None,
        content_type: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id:
        :paramtype id: int
        :keyword rectangle:
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword page_index:
        :paramtype page_index: int
        :keyword raw:
        :paramtype raw: str
        :keyword confidence: The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: The model's confidence that the text has been classified
         correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: If the document was submitted as an image, this is the
         confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified:
        :paramtype is_verified: bool
        :keyword is_client_verified:
        :paramtype is_client_verified: bool
        :keyword is_auto_verified:
        :paramtype is_auto_verified: bool
        :keyword data_point:
        :paramtype data_point: str
        :keyword content_type:
        :paramtype content_type: str
        """
        super(JobTitleAnnotationUpdate, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            **kwargs,
        )
        self.parsed = None
        self.additional_properties = additional_properties
        self.id = id
        self.rectangle = rectangle
        self.rectangles = None
        self.page_index = page_index
        self.raw = raw
        self.confidence = confidence
        self.classification_confidence = classification_confidence
        self.text_extraction_confidence = text_extraction_confidence
        self.is_verified = is_verified
        self.is_client_verified = is_client_verified
        self.is_auto_verified = is_auto_verified
        self.data_point = data_point
        self.content_type = content_type


class JobTitleParsedClassification(msrest.serialization.Model):
    """JobTitleParsedClassification.

    :ivar soc_code:
    :vartype soc_code: float
    :ivar title:
    :vartype title: str
    :ivar minor_group:
    :vartype minor_group: str
    :ivar sub_major_group:
    :vartype sub_major_group: str
    :ivar major_group:
    :vartype major_group: str
    :ivar minor_group_code: The 4 digit code representing the SOC2020 classification for this job
     title.
    :vartype minor_group_code: int
    :ivar sub_major_group_code: The 4 digit code representing the SOC2020 classification for this
     job title.
    :vartype sub_major_group_code: int
    :ivar major_group_code: The 4 digit code representing the SOC2020 classification for this job
     title.
    :vartype major_group_code: int
    """

    _attribute_map = {
        "soc_code": {"key": "socCode", "type": "float"},
        "title": {"key": "title", "type": "str"},
        "minor_group": {"key": "minorGroup", "type": "str"},
        "sub_major_group": {"key": "subMajorGroup", "type": "str"},
        "major_group": {"key": "majorGroup", "type": "str"},
        "minor_group_code": {"key": "minorGroupCode", "type": "int"},
        "sub_major_group_code": {"key": "subMajorGroupCode", "type": "int"},
        "major_group_code": {"key": "majorGroupCode", "type": "int"},
    }

    def __init__(
        self,
        *,
        soc_code: Optional[float] = None,
        title: Optional[str] = None,
        minor_group: Optional[str] = None,
        sub_major_group: Optional[str] = None,
        major_group: Optional[str] = None,
        minor_group_code: Optional[int] = None,
        sub_major_group_code: Optional[int] = None,
        major_group_code: Optional[int] = None,
        **kwargs,
    ):
        """
        :keyword soc_code:
        :paramtype soc_code: float
        :keyword title:
        :paramtype title: str
        :keyword minor_group:
        :paramtype minor_group: str
        :keyword sub_major_group:
        :paramtype sub_major_group: str
        :keyword major_group:
        :paramtype major_group: str
        :keyword minor_group_code: The 4 digit code representing the SOC2020 classification for this
         job title.
        :paramtype minor_group_code: int
        :keyword sub_major_group_code: The 4 digit code representing the SOC2020 classification for
         this job title.
        :paramtype sub_major_group_code: int
        :keyword major_group_code: The 4 digit code representing the SOC2020 classification for this
         job title.
        :paramtype major_group_code: int
        """
        super(JobTitleParsedClassification, self).__init__(**kwargs)
        self.soc_code = soc_code
        self.title = title
        self.minor_group = minor_group
        self.sub_major_group = sub_major_group
        self.major_group = major_group
        self.minor_group_code = minor_group_code
        self.sub_major_group_code = sub_major_group_code
        self.major_group_code = major_group_code


class JobTitleParsedParsed(msrest.serialization.Model):
    """Matching job title to extracted text.

    :ivar name:
    :vartype name: str
    :ivar management_level:
    :vartype management_level: str
    :ivar classification:
    :vartype classification: ~affinda.models.JobTitleParsedClassification
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "management_level": {"key": "managementLevel", "type": "str"},
        "classification": {"key": "classification", "type": "JobTitleParsedClassification"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        management_level: Optional[str] = None,
        classification: Optional["_models.JobTitleParsedClassification"] = None,
        **kwargs,
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword management_level:
        :paramtype management_level: str
        :keyword classification:
        :paramtype classification: ~affinda.models.JobTitleParsedClassification
        """
        super(JobTitleParsedParsed, self).__init__(**kwargs)
        self.name = name
        self.management_level = management_level
        self.classification = classification


class JobTitleSearchScoreComponent(msrest.serialization.Model):
    """JobTitleSearchScoreComponent.

    All required parameters must be populated in order to send to Azure.

    :ivar value:
    :vartype value: str
    :ivar label: Required.
    :vartype label: str
    :ivar score:
    :vartype score: float
    """

    _validation = {
        "label": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "score": {"key": "score", "type": "float"},
    }

    def __init__(
        self, *, label: str, value: Optional[str] = None, score: Optional[float] = None, **kwargs
    ):
        """
        :keyword value:
        :paramtype value: str
        :keyword label: Required.
        :paramtype label: str
        :keyword score:
        :paramtype score: float
        """
        super(JobTitleSearchScoreComponent, self).__init__(**kwargs)
        self.value = value
        self.label = label
        self.score = score


class LanguageAnnotation(Annotation):
    """LanguageAnnotation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required. Annotation's ID.
    :vartype id: int
    :ivar rectangle: Required. x/y coordinates for the rectangular bounding box containing the
     data.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required. x/y coordinates for the rectangles containing the data. An
     annotation can be contained within multiple rectangles.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar document: Required. Unique identifier for the document.
    :vartype document: str
    :ivar page_index: Required. The page number within the document, starting from 0.
    :vartype page_index: int
    :ivar raw: Required. Raw data extracted from the before any post-processing.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required. Indicates whether the data has been validated, either by a human
     using our validation tool or through auto-validation rules.
    :vartype is_verified: bool
    :ivar is_client_verified: Required. Indicates whether the data has been validated by a human.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required. Indicates whether the data has been auto-validated.
    :vartype is_auto_verified: bool
    :ivar data_point: Data point's identifier.
    :vartype data_point: str
    :ivar field: Field's identifier.
    :vartype field: str
    :ivar content_type: Required. The different data types of annotations. Known values are:
     "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
     "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
     "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
    :vartype content_type: str or ~affinda.models.AnnotationContentType
    :ivar parent: The parent annotation's ID.
    :vartype parent: int
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "id": {"required": True, "minimum": 1},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "document": {"required": True},
        "page_index": {"required": True, "minimum": 0},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "content_type": {"required": True},
        "parsed": {"readonly": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "document": {"key": "document", "type": "str"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "field": {"key": "field", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parent": {"key": "parent", "type": "int"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        document: str,
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        content_type: Union[str, "_models.AnnotationContentType"],
        additional_properties: Optional[Dict[str, Any]] = None,
        data_point: Optional[str] = None,
        field: Optional[str] = None,
        parent: Optional[int] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required. Annotation's ID.
        :paramtype id: int
        :keyword rectangle: Required. x/y coordinates for the rectangular bounding box containing the
         data.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required. x/y coordinates for the rectangles containing the data. An
         annotation can be contained within multiple rectangles.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword document: Required. Unique identifier for the document.
        :paramtype document: str
        :keyword page_index: Required. The page number within the document, starting from 0.
        :paramtype page_index: int
        :keyword raw: Required. Raw data extracted from the before any post-processing.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required. Indicates whether the data has been validated, either by a
         human using our validation tool or through auto-validation rules.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required. Indicates whether the data has been validated by a
         human.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required. Indicates whether the data has been auto-validated.
        :paramtype is_auto_verified: bool
        :keyword data_point: Data point's identifier.
        :paramtype data_point: str
        :keyword field: Field's identifier.
        :paramtype field: str
        :keyword content_type: Required. The different data types of annotations. Known values are:
         "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
         "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
         "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
        :paramtype content_type: str or ~affinda.models.AnnotationContentType
        :keyword parent: The parent annotation's ID.
        :paramtype parent: int
        """
        super(LanguageAnnotation, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            document=document,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            field=field,
            content_type=content_type,
            parent=parent,
            **kwargs,
        )
        self.parsed = None


class LanguageAnnotationUpdate(AnnotationBase):
    """LanguageAnnotationUpdate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id:
    :vartype id: int
    :ivar rectangle:
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles:
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index:
    :vartype page_index: int
    :ivar raw:
    :vartype raw: str
    :ivar confidence: The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: The model's confidence that the text has been classified
     correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: If the document was submitted as an image, this is the
     confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified:
    :vartype is_verified: bool
    :ivar is_client_verified:
    :vartype is_client_verified: bool
    :ivar is_auto_verified:
    :vartype is_auto_verified: bool
    :ivar data_point:
    :vartype data_point: str
    :ivar content_type:
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "rectangles": {"readonly": True},
        "parsed": {"readonly": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        id: Optional[int] = None,
        rectangle: Optional["_models.Rectangle"] = None,
        page_index: Optional[int] = None,
        raw: Optional[str] = None,
        confidence: Optional[float] = None,
        classification_confidence: Optional[float] = None,
        text_extraction_confidence: Optional[float] = None,
        is_verified: Optional[bool] = None,
        is_client_verified: Optional[bool] = None,
        is_auto_verified: Optional[bool] = None,
        data_point: Optional[str] = None,
        content_type: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id:
        :paramtype id: int
        :keyword rectangle:
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword page_index:
        :paramtype page_index: int
        :keyword raw:
        :paramtype raw: str
        :keyword confidence: The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: The model's confidence that the text has been classified
         correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: If the document was submitted as an image, this is the
         confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified:
        :paramtype is_verified: bool
        :keyword is_client_verified:
        :paramtype is_client_verified: bool
        :keyword is_auto_verified:
        :paramtype is_auto_verified: bool
        :keyword data_point:
        :paramtype data_point: str
        :keyword content_type:
        :paramtype content_type: str
        """
        super(LanguageAnnotationUpdate, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            **kwargs,
        )
        self.parsed = None


class LanguagesSearchScoreComponent(msrest.serialization.Model):
    """LanguagesSearchScoreComponent.

    All required parameters must be populated in order to send to Azure.

    :ivar value:
    :vartype value: str
    :ivar label: Required.
    :vartype label: str
    :ivar score:
    :vartype score: float
    """

    _validation = {
        "label": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "score": {"key": "score", "type": "float"},
    }

    def __init__(
        self, *, label: str, value: Optional[str] = None, score: Optional[float] = None, **kwargs
    ):
        """
        :keyword value:
        :paramtype value: str
        :keyword label: Required.
        :paramtype label: str
        :keyword score:
        :paramtype score: float
        """
        super(LanguagesSearchScoreComponent, self).__init__(**kwargs)
        self.value = value
        self.label = label
        self.score = score


class LocationAnnotation(Annotation):
    """LocationAnnotation.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required. Annotation's ID.
    :vartype id: int
    :ivar rectangle: Required. x/y coordinates for the rectangular bounding box containing the
     data.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required. x/y coordinates for the rectangles containing the data. An
     annotation can be contained within multiple rectangles.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar document: Required. Unique identifier for the document.
    :vartype document: str
    :ivar page_index: Required. The page number within the document, starting from 0.
    :vartype page_index: int
    :ivar raw: Required. Raw data extracted from the before any post-processing.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required. Indicates whether the data has been validated, either by a human
     using our validation tool or through auto-validation rules.
    :vartype is_verified: bool
    :ivar is_client_verified: Required. Indicates whether the data has been validated by a human.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required. Indicates whether the data has been auto-validated.
    :vartype is_auto_verified: bool
    :ivar data_point: Data point's identifier.
    :vartype data_point: str
    :ivar field: Field's identifier.
    :vartype field: str
    :ivar content_type: Required. The different data types of annotations. Known values are:
     "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
     "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
     "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
    :vartype content_type: str or ~affinda.models.AnnotationContentType
    :ivar parent: The parent annotation's ID.
    :vartype parent: int
    :ivar parsed:
    :vartype parsed: ~affinda.models.Location
    """

    _validation = {
        "id": {"required": True, "minimum": 1},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "document": {"required": True},
        "page_index": {"required": True, "minimum": 0},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "document": {"key": "document", "type": "str"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "field": {"key": "field", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parent": {"key": "parent", "type": "int"},
        "parsed": {"key": "parsed", "type": "Location"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        document: str,
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        content_type: Union[str, "_models.AnnotationContentType"],
        additional_properties: Optional[Dict[str, Any]] = None,
        data_point: Optional[str] = None,
        field: Optional[str] = None,
        parent: Optional[int] = None,
        parsed: Optional["_models.Location"] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required. Annotation's ID.
        :paramtype id: int
        :keyword rectangle: Required. x/y coordinates for the rectangular bounding box containing the
         data.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required. x/y coordinates for the rectangles containing the data. An
         annotation can be contained within multiple rectangles.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword document: Required. Unique identifier for the document.
        :paramtype document: str
        :keyword page_index: Required. The page number within the document, starting from 0.
        :paramtype page_index: int
        :keyword raw: Required. Raw data extracted from the before any post-processing.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required. Indicates whether the data has been validated, either by a
         human using our validation tool or through auto-validation rules.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required. Indicates whether the data has been validated by a
         human.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required. Indicates whether the data has been auto-validated.
        :paramtype is_auto_verified: bool
        :keyword data_point: Data point's identifier.
        :paramtype data_point: str
        :keyword field: Field's identifier.
        :paramtype field: str
        :keyword content_type: Required. The different data types of annotations. Known values are:
         "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
         "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
         "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
        :paramtype content_type: str or ~affinda.models.AnnotationContentType
        :keyword parent: The parent annotation's ID.
        :paramtype parent: int
        :keyword parsed:
        :paramtype parsed: ~affinda.models.Location
        """
        super(LocationAnnotation, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            document=document,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            field=field,
            content_type=content_type,
            parent=parent,
            **kwargs,
        )
        self.parsed = parsed


class LocationAnnotationUpdate(AnnotationBase):
    """LocationAnnotationUpdate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id:
    :vartype id: int
    :ivar rectangle:
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles:
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index:
    :vartype page_index: int
    :ivar raw:
    :vartype raw: str
    :ivar confidence: The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: The model's confidence that the text has been classified
     correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: If the document was submitted as an image, this is the
     confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified:
    :vartype is_verified: bool
    :ivar is_client_verified:
    :vartype is_client_verified: bool
    :ivar is_auto_verified:
    :vartype is_auto_verified: bool
    :ivar data_point:
    :vartype data_point: str
    :ivar content_type:
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: ~affinda.models.LocationAnnotationUpdateParsed
    """

    _validation = {
        "rectangles": {"readonly": True},
        "parsed": {"readonly": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "LocationAnnotationUpdateParsed"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        id: Optional[int] = None,
        rectangle: Optional["_models.Rectangle"] = None,
        page_index: Optional[int] = None,
        raw: Optional[str] = None,
        confidence: Optional[float] = None,
        classification_confidence: Optional[float] = None,
        text_extraction_confidence: Optional[float] = None,
        is_verified: Optional[bool] = None,
        is_client_verified: Optional[bool] = None,
        is_auto_verified: Optional[bool] = None,
        data_point: Optional[str] = None,
        content_type: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id:
        :paramtype id: int
        :keyword rectangle:
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword page_index:
        :paramtype page_index: int
        :keyword raw:
        :paramtype raw: str
        :keyword confidence: The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: The model's confidence that the text has been classified
         correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: If the document was submitted as an image, this is the
         confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified:
        :paramtype is_verified: bool
        :keyword is_client_verified:
        :paramtype is_client_verified: bool
        :keyword is_auto_verified:
        :paramtype is_auto_verified: bool
        :keyword data_point:
        :paramtype data_point: str
        :keyword content_type:
        :paramtype content_type: str
        """
        super(LocationAnnotationUpdate, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            **kwargs,
        )
        self.parsed = None


class LocationAnnotationUpdateParsed(Location):
    """LocationAnnotationUpdateParsed.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar formatted:
    :vartype formatted: str
    :ivar postal_code:
    :vartype postal_code: str
    :ivar state:
    :vartype state: str
    :ivar state_code:
    :vartype state_code: str
    :ivar country:
    :vartype country: str
    :ivar country_code: Two letter country code (ISO 3166-1 alpha-2).
    :vartype country_code: str
    :ivar raw_input: Required.
    :vartype raw_input: str
    :ivar street_number:
    :vartype street_number: str
    :ivar street:
    :vartype street: str
    :ivar apartment_number:
    :vartype apartment_number: str
    :ivar city:
    :vartype city: str
    :ivar latitude:
    :vartype latitude: float
    :ivar longitude:
    :vartype longitude: float
    :ivar po_box:
    :vartype po_box: str
    """

    _validation = {
        "formatted": {"readonly": True},
        "postal_code": {"readonly": True},
        "state": {"readonly": True},
        "state_code": {"readonly": True},
        "country": {"readonly": True},
        "country_code": {"readonly": True},
        "raw_input": {"required": True},
        "street_number": {"readonly": True},
        "street": {"readonly": True},
        "apartment_number": {"readonly": True},
        "city": {"readonly": True},
        "latitude": {"readonly": True},
        "longitude": {"readonly": True},
        "po_box": {"readonly": True},
    }

    _attribute_map = {
        "formatted": {"key": "formatted", "type": "str"},
        "postal_code": {"key": "postalCode", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "state_code": {"key": "stateCode", "type": "str"},
        "country": {"key": "country", "type": "str"},
        "country_code": {"key": "countryCode", "type": "str"},
        "raw_input": {"key": "rawInput", "type": "str"},
        "street_number": {"key": "streetNumber", "type": "str"},
        "street": {"key": "street", "type": "str"},
        "apartment_number": {"key": "apartmentNumber", "type": "str"},
        "city": {"key": "city", "type": "str"},
        "latitude": {"key": "latitude", "type": "float"},
        "longitude": {"key": "longitude", "type": "float"},
        "po_box": {"key": "poBox", "type": "str"},
    }

    def __init__(self, *, raw_input: str, **kwargs):
        """
        :keyword raw_input: Required.
        :paramtype raw_input: str
        """
        super(LocationAnnotationUpdateParsed, self).__init__(raw_input=raw_input, **kwargs)


class LocationSearchScoreComponent(msrest.serialization.Model):
    """LocationSearchScoreComponent.

    All required parameters must be populated in order to send to Azure.

    :ivar value:
    :vartype value: str
    :ivar label: Required.
    :vartype label: str
    :ivar score:
    :vartype score: float
    """

    _validation = {
        "label": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "score": {"key": "score", "type": "float"},
    }

    def __init__(
        self, *, label: str, value: Optional[str] = None, score: Optional[float] = None, **kwargs
    ):
        """
        :keyword value:
        :paramtype value: str
        :keyword label: Required.
        :paramtype label: str
        :keyword score:
        :paramtype score: float
        """
        super(LocationSearchScoreComponent, self).__init__(**kwargs)
        self.value = value
        self.label = label
        self.score = score


class ManagementLevelSearchScoreComponent(msrest.serialization.Model):
    """ManagementLevelSearchScoreComponent.

    All required parameters must be populated in order to send to Azure.

    :ivar value:
    :vartype value: str
    :ivar label: Required.
    :vartype label: str
    :ivar score:
    :vartype score: float
    """

    _validation = {
        "label": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "score": {"key": "score", "type": "float"},
    }

    def __init__(
        self, *, label: str, value: Optional[str] = None, score: Optional[float] = None, **kwargs
    ):
        """
        :keyword value:
        :paramtype value: str
        :keyword label: Required.
        :paramtype label: str
        :keyword score:
        :paramtype score: float
        """
        super(ManagementLevelSearchScoreComponent, self).__init__(**kwargs)
        self.value = value
        self.label = label
        self.score = score


class Mapping(msrest.serialization.Model):
    """A mapping allows you to specify specific settings regarding a lookup against a MappingDataSource should be applied.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar identifier: Required. Uniquely identify a mapping.
    :vartype identifier: str
    :ivar organization: The organization that this mapping belongs to.
    :vartype organization: str
    :ivar data_source: Required. The mapping data source this mapping applies to.
    :vartype data_source: str
    :ivar score_cutoff: Higher values will result in more strict matching.
    :vartype score_cutoff: float
    :ivar order_by: The field to order the results by. Leave blank for ordering by relevance.
    :vartype order_by: str
    """

    _validation = {
        "identifier": {"required": True, "readonly": True},
        "data_source": {"required": True},
    }

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "organization": {"key": "organization", "type": "str"},
        "data_source": {"key": "dataSource", "type": "str"},
        "score_cutoff": {"key": "scoreCutoff", "type": "float"},
        "order_by": {"key": "orderBy", "type": "str"},
    }

    def __init__(
        self,
        *,
        data_source: str,
        organization: Optional[str] = None,
        score_cutoff: Optional[float] = None,
        order_by: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword organization: The organization that this mapping belongs to.
        :paramtype organization: str
        :keyword data_source: Required. The mapping data source this mapping applies to.
        :paramtype data_source: str
        :keyword score_cutoff: Higher values will result in more strict matching.
        :paramtype score_cutoff: float
        :keyword order_by: The field to order the results by. Leave blank for ordering by relevance.
        :paramtype order_by: str
        """
        super(Mapping, self).__init__(**kwargs)
        self.identifier = None
        self.organization = organization
        self.data_source = data_source
        self.score_cutoff = score_cutoff
        self.order_by = order_by


class MappingCreate(msrest.serialization.Model):
    """MappingCreate.

    All required parameters must be populated in order to send to Azure.

    :ivar data_source: Required. The mapping data source this mapping applies to.
    :vartype data_source: str
    :ivar score_cutoff: Higher values will result in more strict matching.
    :vartype score_cutoff: float
    :ivar organization: The organization that this mapping belongs to.
    :vartype organization: str
    :ivar order_by: The field to order the results by. Leave blank for ordering by relevance.
    :vartype order_by: str
    """

    _validation = {
        "data_source": {"required": True},
    }

    _attribute_map = {
        "data_source": {"key": "dataSource", "type": "str"},
        "score_cutoff": {"key": "scoreCutoff", "type": "float"},
        "organization": {"key": "organization", "type": "str"},
        "order_by": {"key": "orderBy", "type": "str"},
    }

    def __init__(
        self,
        *,
        data_source: str,
        score_cutoff: Optional[float] = None,
        organization: Optional[str] = None,
        order_by: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword data_source: Required. The mapping data source this mapping applies to.
        :paramtype data_source: str
        :keyword score_cutoff: Higher values will result in more strict matching.
        :paramtype score_cutoff: float
        :keyword organization: The organization that this mapping belongs to.
        :paramtype organization: str
        :keyword order_by: The field to order the results by. Leave blank for ordering by relevance.
        :paramtype order_by: str
        """
        super(MappingCreate, self).__init__(**kwargs)
        self.data_source = data_source
        self.score_cutoff = score_cutoff
        self.organization = organization
        self.order_by = order_by


class MappingDataSource(msrest.serialization.Model):
    """A mapping data source is used to map from raw data found by our AI models to records in your database.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar identifier: Required. Uniquely identify a mapping data source.
    :vartype identifier: str
    :ivar name:
    :vartype name: str
    :ivar key_property: Required. Attribute in the schema which uniquely identifiers the value.
    :vartype key_property: str
    :ivar display_property: Required. Attribute in the schema which is used to display the value.
    :vartype display_property: str
    :ivar organization: Required. The organization that this mapping data source belongs to.
    :vartype organization: str
    :ivar workspace: Required. The workspace that this mapping data source belongs to.
    :vartype workspace: str
    :ivar schema: The schema of the mapping data source.
    :vartype schema: any
    """

    _validation = {
        "identifier": {"required": True, "readonly": True},
        "key_property": {"required": True},
        "display_property": {"required": True},
        "organization": {"required": True},
        "workspace": {"required": True},
    }

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "key_property": {"key": "keyProperty", "type": "str"},
        "display_property": {"key": "displayProperty", "type": "str"},
        "organization": {"key": "organization", "type": "str"},
        "workspace": {"key": "workspace", "type": "str"},
        "schema": {"key": "schema", "type": "object"},
    }

    def __init__(
        self,
        *,
        key_property: str,
        display_property: str,
        organization: str,
        workspace: str,
        name: Optional[str] = None,
        schema: Optional[Any] = None,
        **kwargs,
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword key_property: Required. Attribute in the schema which uniquely identifiers the value.
        :paramtype key_property: str
        :keyword display_property: Required. Attribute in the schema which is used to display the
         value.
        :paramtype display_property: str
        :keyword organization: Required. The organization that this mapping data source belongs to.
        :paramtype organization: str
        :keyword workspace: Required. The workspace that this mapping data source belongs to.
        :paramtype workspace: str
        :keyword schema: The schema of the mapping data source.
        :paramtype schema: any
        """
        super(MappingDataSource, self).__init__(**kwargs)
        self.identifier = None
        self.name = name
        self.key_property = key_property
        self.display_property = display_property
        self.organization = organization
        self.workspace = workspace
        self.schema = schema


class MappingDataSourceCreate(msrest.serialization.Model):
    """A mapping data source is used to map from raw data found by our AI models to records in your database.

    :ivar name:
    :vartype name: str
    :ivar organization: The organization that this mapping data source belongs to.
    :vartype organization: str
    :ivar workspace: The workspace that this mapping data source belongs to.
    :vartype workspace: str
    :ivar key_property: Attribute in the schema which uniquely identifiers the value.
    :vartype key_property: str
    :ivar display_property: Attribute in the schema which is used to display the value.
    :vartype display_property: str
    :ivar values:
    :vartype values: list[any]
    :ivar schema: The schema of the mapping data source.
    :vartype schema: any
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "organization": {"key": "organization", "type": "str"},
        "workspace": {"key": "workspace", "type": "str"},
        "key_property": {"key": "keyProperty", "type": "str"},
        "display_property": {"key": "displayProperty", "type": "str"},
        "values": {"key": "values", "type": "[object]"},
        "schema": {"key": "schema", "type": "object"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        organization: Optional[str] = None,
        workspace: Optional[str] = None,
        key_property: Optional[str] = None,
        display_property: Optional[str] = None,
        values: Optional[List[Any]] = None,
        schema: Optional[Any] = None,
        **kwargs,
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword organization: The organization that this mapping data source belongs to.
        :paramtype organization: str
        :keyword workspace: The workspace that this mapping data source belongs to.
        :paramtype workspace: str
        :keyword key_property: Attribute in the schema which uniquely identifiers the value.
        :paramtype key_property: str
        :keyword display_property: Attribute in the schema which is used to display the value.
        :paramtype display_property: str
        :keyword values:
        :paramtype values: list[any]
        :keyword schema: The schema of the mapping data source.
        :paramtype schema: any
        """
        super(MappingDataSourceCreate, self).__init__(**kwargs)
        self.name = name
        self.organization = organization
        self.workspace = workspace
        self.key_property = key_property
        self.display_property = display_property
        self.values = values
        self.schema = schema


class MappingUpdate(msrest.serialization.Model):
    """MappingUpdate.

    :ivar score_cutoff: Higher values will result in more strict matching.
    :vartype score_cutoff: float
    :ivar order_by: The field to order the results by. Leave blank for ordering by relevance.
    :vartype order_by: str
    """

    _attribute_map = {
        "score_cutoff": {"key": "scoreCutoff", "type": "float"},
        "order_by": {"key": "orderBy", "type": "str"},
    }

    def __init__(
        self, *, score_cutoff: Optional[float] = None, order_by: Optional[str] = None, **kwargs
    ):
        """
        :keyword score_cutoff: Higher values will result in more strict matching.
        :paramtype score_cutoff: float
        :keyword order_by: The field to order the results by. Leave blank for ordering by relevance.
        :paramtype order_by: str
        """
        super(MappingUpdate, self).__init__(**kwargs)
        self.score_cutoff = score_cutoff
        self.order_by = order_by


class Meta(msrest.serialization.Model):
    """Meta.

    :ivar identifier: Unique identifier for the document.
    :vartype identifier: str
    :ivar custom_identifier: Optional identifier for the document that you can set to track the
     document in the Affinda system.  Is not required to be unique.
    :vartype custom_identifier: str
    :ivar file_name: Optional filename of the file.
    :vartype file_name: str
    :ivar ready: If true, the document has finished processing. Particularly useful if an endpoint
     request specified wait=False, when polling use this variable to determine when to stop polling.
    :vartype ready: bool
    :ivar ready_dt: The datetime when the document was ready.
    :vartype ready_dt: ~datetime.datetime
    :ivar failed: If true, some exception was raised during processing. Check the 'error' field of
     the main return object.
    :vartype failed: bool
    :ivar expiry_time: The date/time in ISO-8601 format when the document will be automatically
     deleted.  Defaults to no expiry.
    :vartype expiry_time: ~datetime.datetime
    :ivar language: The document's language.
    :vartype language: str
    :ivar pdf: The URL to the document's pdf (if the uploaded document is not already pdf, it's
     converted to pdf as part of the parsing process).
    :vartype pdf: str
    :ivar parent_document: If this document is part of a splitted document, this attribute points
     to the original document that this document is splitted from.
    :vartype parent_document: ~affinda.models.MetaParentDocument
    :ivar child_documents: If this document has been splitted into a number of child documents,
     this attribute points to those child documents.
    :vartype child_documents: list[~affinda.models.MetaChildDocumentsItem]
    :ivar pages: The document's pages.
    :vartype pages: list[~affinda.models.PageMeta]
    :ivar is_verified: This is true if the 'confirm' button has been clicked in the Affinda
     validation tool.
    :vartype is_verified: bool
    :ivar review_url: Signed URL (valid for 60 minutes) to access the validation tool.  Not
     applicable for documents types such a resumes.
    :vartype review_url: str
    :ivar ocr_confidence: The overall confidence in the conversion of image to text.  (only
     applicable for images or PDF documents without a text layer).
    :vartype ocr_confidence: float
    :ivar created_dt:
    :vartype created_dt: ~datetime.datetime
    :ivar document_type:
    :vartype document_type: str
    :ivar region_bias:
    :vartype region_bias: ~affinda.models.RegionBias
    :ivar is_ocrd:
    :vartype is_ocrd: bool
    """

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "custom_identifier": {"key": "customIdentifier", "type": "str"},
        "file_name": {"key": "fileName", "type": "str"},
        "ready": {"key": "ready", "type": "bool"},
        "ready_dt": {"key": "readyDt", "type": "iso-8601"},
        "failed": {"key": "failed", "type": "bool"},
        "expiry_time": {"key": "expiryTime", "type": "iso-8601"},
        "language": {"key": "language", "type": "str"},
        "pdf": {"key": "pdf", "type": "str"},
        "parent_document": {"key": "parentDocument", "type": "MetaParentDocument"},
        "child_documents": {"key": "childDocuments", "type": "[MetaChildDocumentsItem]"},
        "pages": {"key": "pages", "type": "[PageMeta]"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "review_url": {"key": "reviewUrl", "type": "str"},
        "ocr_confidence": {"key": "ocrConfidence", "type": "float"},
        "created_dt": {"key": "createdDt", "type": "iso-8601"},
        "document_type": {"key": "documentType", "type": "str"},
        "region_bias": {"key": "regionBias", "type": "RegionBias"},
        "is_ocrd": {"key": "isOcrd", "type": "bool"},
    }

    def __init__(
        self,
        *,
        identifier: Optional[str] = None,
        custom_identifier: Optional[str] = None,
        file_name: Optional[str] = None,
        ready: Optional[bool] = None,
        ready_dt: Optional[datetime.datetime] = None,
        failed: Optional[bool] = None,
        expiry_time: Optional[datetime.datetime] = None,
        language: Optional[str] = None,
        pdf: Optional[str] = None,
        parent_document: Optional["_models.MetaParentDocument"] = None,
        child_documents: Optional[List["_models.MetaChildDocumentsItem"]] = None,
        pages: Optional[List["_models.PageMeta"]] = None,
        is_verified: Optional[bool] = None,
        review_url: Optional[str] = None,
        ocr_confidence: Optional[float] = None,
        created_dt: Optional[datetime.datetime] = None,
        document_type: Optional[str] = None,
        region_bias: Optional["_models.RegionBias"] = None,
        is_ocrd: Optional[bool] = None,
        **kwargs,
    ):
        """
        :keyword identifier: Unique identifier for the document.
        :paramtype identifier: str
        :keyword custom_identifier: Optional identifier for the document that you can set to track the
         document in the Affinda system.  Is not required to be unique.
        :paramtype custom_identifier: str
        :keyword file_name: Optional filename of the file.
        :paramtype file_name: str
        :keyword ready: If true, the document has finished processing. Particularly useful if an
         endpoint request specified wait=False, when polling use this variable to determine when to stop
         polling.
        :paramtype ready: bool
        :keyword ready_dt: The datetime when the document was ready.
        :paramtype ready_dt: ~datetime.datetime
        :keyword failed: If true, some exception was raised during processing. Check the 'error' field
         of the main return object.
        :paramtype failed: bool
        :keyword expiry_time: The date/time in ISO-8601 format when the document will be automatically
         deleted.  Defaults to no expiry.
        :paramtype expiry_time: ~datetime.datetime
        :keyword language: The document's language.
        :paramtype language: str
        :keyword pdf: The URL to the document's pdf (if the uploaded document is not already pdf, it's
         converted to pdf as part of the parsing process).
        :paramtype pdf: str
        :keyword parent_document: If this document is part of a splitted document, this attribute
         points to the original document that this document is splitted from.
        :paramtype parent_document: ~affinda.models.MetaParentDocument
        :keyword child_documents: If this document has been splitted into a number of child documents,
         this attribute points to those child documents.
        :paramtype child_documents: list[~affinda.models.MetaChildDocumentsItem]
        :keyword pages: The document's pages.
        :paramtype pages: list[~affinda.models.PageMeta]
        :keyword is_verified: This is true if the 'confirm' button has been clicked in the Affinda
         validation tool.
        :paramtype is_verified: bool
        :keyword review_url: Signed URL (valid for 60 minutes) to access the validation tool.  Not
         applicable for documents types such a resumes.
        :paramtype review_url: str
        :keyword ocr_confidence: The overall confidence in the conversion of image to text.  (only
         applicable for images or PDF documents without a text layer).
        :paramtype ocr_confidence: float
        :keyword created_dt:
        :paramtype created_dt: ~datetime.datetime
        :keyword document_type:
        :paramtype document_type: str
        :keyword region_bias:
        :paramtype region_bias: ~affinda.models.RegionBias
        :keyword is_ocrd:
        :paramtype is_ocrd: bool
        """
        super(Meta, self).__init__(**kwargs)
        self.identifier = identifier
        self.custom_identifier = custom_identifier
        self.file_name = file_name
        self.ready = ready
        self.ready_dt = ready_dt
        self.failed = failed
        self.expiry_time = expiry_time
        self.language = language
        self.pdf = pdf
        self.parent_document = parent_document
        self.child_documents = child_documents
        self.pages = pages
        self.is_verified = is_verified
        self.review_url = review_url
        self.ocr_confidence = ocr_confidence
        self.created_dt = created_dt
        self.document_type = document_type
        self.region_bias = region_bias
        self.is_ocrd = is_ocrd


class MetaChildDocumentsItem(msrest.serialization.Model):
    """MetaChildDocumentsItem.

    :ivar identifier: Unique identifier for the document.
    :vartype identifier: str
    """

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
    }

    def __init__(self, *, identifier: Optional[str] = None, **kwargs):
        """
        :keyword identifier: Unique identifier for the document.
        :paramtype identifier: str
        """
        super(MetaChildDocumentsItem, self).__init__(**kwargs)
        self.identifier = identifier


class MetaParentDocument(msrest.serialization.Model):
    """If this document is part of a splitted document, this attribute points to the original document that this document is splitted from.

    :ivar identifier: Unique identifier for the document.
    :vartype identifier: str
    """

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
    }

    def __init__(self, *, identifier: Optional[str] = None, **kwargs):
        """
        :keyword identifier: Unique identifier for the document.
        :paramtype identifier: str
        """
        super(MetaParentDocument, self).__init__(**kwargs)
        self.identifier = identifier


class OccupationGroup(msrest.serialization.Model):
    """OccupationGroup.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required.
    :vartype code: int
    :ivar name: Required.
    :vartype name: str
    :ivar children: Required.
    :vartype children: list[~affinda.models.OccupationGroup]
    """

    _validation = {
        "code": {"required": True},
        "name": {"required": True},
        "children": {"required": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "int"},
        "name": {"key": "name", "type": "str"},
        "children": {"key": "children", "type": "[OccupationGroup]"},
    }

    def __init__(
        self, *, code: int, name: str, children: List["_models.OccupationGroup"], **kwargs
    ):
        """
        :keyword code: Required.
        :paramtype code: int
        :keyword name: Required.
        :paramtype name: str
        :keyword children: Required.
        :paramtype children: list[~affinda.models.OccupationGroup]
        """
        super(OccupationGroup, self).__init__(**kwargs)
        self.code = code
        self.name = name
        self.children = children


class OccupationGroupSearchScoreComponent(msrest.serialization.Model):
    """OccupationGroupSearchScoreComponent.

    All required parameters must be populated in order to send to Azure.

    :ivar value:
    :vartype value: str
    :ivar label: Required.
    :vartype label: str
    :ivar score:
    :vartype score: float
    """

    _validation = {
        "label": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "score": {"key": "score", "type": "float"},
    }

    def __init__(
        self, *, label: str, value: Optional[str] = None, score: Optional[float] = None, **kwargs
    ):
        """
        :keyword value:
        :paramtype value: str
        :keyword label: Required.
        :paramtype label: str
        :keyword score:
        :paramtype score: float
        """
        super(OccupationGroupSearchScoreComponent, self).__init__(**kwargs)
        self.value = value
        self.label = label
        self.score = score


class Organization(msrest.serialization.Model):
    """Organization.

    :ivar identifier: Uniquely identify an organization.
    :vartype identifier: str
    :ivar name:
    :vartype name: str
    :ivar user_role: The role of the logged in user within the organization. Known values are:
     "admin", "member".
    :vartype user_role: str or ~affinda.models.OrganizationUserRole
    :ivar avatar: URL of the organization's avatar.
    :vartype avatar: str
    :ivar resthook_signature_key: Used to sign webhook payloads so you can verify their integrity.
    :vartype resthook_signature_key: str
    :ivar is_trial:
    :vartype is_trial: bool
    :ivar validation_tool_config: Configuration of the embeddable validation tool.
    :vartype validation_tool_config: ~affinda.models.OrganizationValidationToolConfig
    :ivar show_custom_field_creation: Whether to show the custom field creation in the UI.
    :vartype show_custom_field_creation: bool
    """

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "user_role": {"key": "userRole", "type": "str"},
        "avatar": {"key": "avatar", "type": "str"},
        "resthook_signature_key": {"key": "resthookSignatureKey", "type": "str"},
        "is_trial": {"key": "isTrial", "type": "bool"},
        "validation_tool_config": {
            "key": "validationToolConfig",
            "type": "OrganizationValidationToolConfig",
        },
        "show_custom_field_creation": {"key": "showCustomFieldCreation", "type": "bool"},
    }

    def __init__(
        self,
        *,
        identifier: Optional[str] = None,
        name: Optional[str] = None,
        user_role: Optional[Union[str, "_models.OrganizationUserRole"]] = None,
        avatar: Optional[str] = None,
        resthook_signature_key: Optional[str] = None,
        is_trial: Optional[bool] = None,
        validation_tool_config: Optional["_models.OrganizationValidationToolConfig"] = None,
        show_custom_field_creation: Optional[bool] = None,
        **kwargs,
    ):
        """
        :keyword identifier: Uniquely identify an organization.
        :paramtype identifier: str
        :keyword name:
        :paramtype name: str
        :keyword user_role: The role of the logged in user within the organization. Known values are:
         "admin", "member".
        :paramtype user_role: str or ~affinda.models.OrganizationUserRole
        :keyword avatar: URL of the organization's avatar.
        :paramtype avatar: str
        :keyword resthook_signature_key: Used to sign webhook payloads so you can verify their
         integrity.
        :paramtype resthook_signature_key: str
        :keyword is_trial:
        :paramtype is_trial: bool
        :keyword validation_tool_config: Configuration of the embeddable validation tool.
        :paramtype validation_tool_config: ~affinda.models.OrganizationValidationToolConfig
        :keyword show_custom_field_creation: Whether to show the custom field creation in the UI.
        :paramtype show_custom_field_creation: bool
        """
        super(Organization, self).__init__(**kwargs)
        self.identifier = identifier
        self.name = name
        self.user_role = user_role
        self.avatar = avatar
        self.resthook_signature_key = resthook_signature_key
        self.is_trial = is_trial
        self.validation_tool_config = validation_tool_config
        self.show_custom_field_creation = show_custom_field_creation


class OrganizationCreate(msrest.serialization.Model):
    """OrganizationCreate.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required.
    :vartype name: str
    :ivar avatar: Upload avatar for the organization.
    :vartype avatar: IO
    :ivar resthook_signature_key: Used to sign webhook payloads so you can verify their integrity.
    :vartype resthook_signature_key: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "avatar": {"key": "avatar", "type": "IO"},
        "resthook_signature_key": {"key": "resthookSignatureKey", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        avatar: Optional[IO] = None,
        resthook_signature_key: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword name: Required.
        :paramtype name: str
        :keyword avatar: Upload avatar for the organization.
        :paramtype avatar: IO
        :keyword resthook_signature_key: Used to sign webhook payloads so you can verify their
         integrity.
        :paramtype resthook_signature_key: str
        """
        super(OrganizationCreate, self).__init__(**kwargs)
        self.name = name
        self.avatar = avatar
        self.resthook_signature_key = resthook_signature_key


class OrganizationMembership(msrest.serialization.Model):
    """OrganizationMembership.

    All required parameters must be populated in order to send to Azure.

    :ivar identifier: Required. A random string that uniquely identify the resource.
    :vartype identifier: str
    :ivar organization: Required. Uniquely identify an organization.
    :vartype organization: str
    :ivar user: Required.
    :vartype user: ~affinda.models.User
    :ivar role: Required. Known values are: "admin", "member".
    :vartype role: str or ~affinda.models.OrganizationRole
    """

    _validation = {
        "identifier": {"required": True},
        "organization": {"required": True},
        "user": {"required": True},
        "role": {"required": True},
    }

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "organization": {"key": "organization", "type": "str"},
        "user": {"key": "user", "type": "User"},
        "role": {"key": "role", "type": "str"},
    }

    def __init__(
        self,
        *,
        identifier: str,
        organization: str,
        user: "_models.User",
        role: Union[str, "_models.OrganizationRole"],
        **kwargs,
    ):
        """
        :keyword identifier: Required. A random string that uniquely identify the resource.
        :paramtype identifier: str
        :keyword organization: Required. Uniquely identify an organization.
        :paramtype organization: str
        :keyword user: Required.
        :paramtype user: ~affinda.models.User
        :keyword role: Required. Known values are: "admin", "member".
        :paramtype role: str or ~affinda.models.OrganizationRole
        """
        super(OrganizationMembership, self).__init__(**kwargs)
        self.identifier = identifier
        self.organization = organization
        self.user = user
        self.role = role


class OrganizationMembershipUpdate(msrest.serialization.Model):
    """OrganizationMembershipUpdate.

    :ivar role: Known values are: "admin", "member".
    :vartype role: str or ~affinda.models.OrganizationRole
    """

    _attribute_map = {
        "role": {"key": "role", "type": "str"},
    }

    def __init__(self, *, role: Optional[Union[str, "_models.OrganizationRole"]] = None, **kwargs):
        """
        :keyword role: Known values are: "admin", "member".
        :paramtype role: str or ~affinda.models.OrganizationRole
        """
        super(OrganizationMembershipUpdate, self).__init__(**kwargs)
        self.role = role


class OrganizationUpdate(msrest.serialization.Model):
    """OrganizationUpdate.

    :ivar name:
    :vartype name: str
    :ivar avatar: Upload avatar for the organization.
    :vartype avatar: IO
    :ivar resthook_signature_key: Used to sign webhook payloads so you can verify their integrity.
    :vartype resthook_signature_key: str
    :ivar validation_tool_config: Configuration of the embeddable validation tool.
    :vartype validation_tool_config: ~affinda.models.ValidationToolConfig
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "avatar": {"key": "avatar", "type": "IO"},
        "resthook_signature_key": {"key": "resthookSignatureKey", "type": "str"},
        "validation_tool_config": {"key": "validationToolConfig", "type": "ValidationToolConfig"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        avatar: Optional[IO] = None,
        resthook_signature_key: Optional[str] = None,
        validation_tool_config: Optional["_models.ValidationToolConfig"] = None,
        **kwargs,
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword avatar: Upload avatar for the organization.
        :paramtype avatar: IO
        :keyword resthook_signature_key: Used to sign webhook payloads so you can verify their
         integrity.
        :paramtype resthook_signature_key: str
        :keyword validation_tool_config: Configuration of the embeddable validation tool.
        :paramtype validation_tool_config: ~affinda.models.ValidationToolConfig
        """
        super(OrganizationUpdate, self).__init__(**kwargs)
        self.name = name
        self.avatar = avatar
        self.resthook_signature_key = resthook_signature_key
        self.validation_tool_config = validation_tool_config


class OrganizationValidationToolConfig(msrest.serialization.Model):
    """Configuration of the embeddable validation tool.

    :ivar theme:
    :vartype theme: ~affinda.models.ThemeConfig
    :ivar hide_actions: Hide the confirm document button and other actions.
    :vartype hide_actions: bool
    :ivar hide_collection: Hide the collection selector.
    :vartype hide_collection: bool
    :ivar hide_edit_pages: Hide the edit pages button.
    :vartype hide_edit_pages: bool
    :ivar hide_export: Hide the export menu.
    :vartype hide_export: bool
    :ivar hide_filename: Hide the filename input.
    :vartype hide_filename: bool
    :ivar hide_reject: Hide the reject document button.
    :vartype hide_reject: bool
    :ivar hide_reparse: Hide the reparse button.
    :vartype hide_reparse: bool
    :ivar hide_run_ocr: Hide the run OCR button.
    :vartype hide_run_ocr: bool
    :ivar hide_tags: Hide the tags editor.
    :vartype hide_tags: bool
    :ivar hide_warnings: Hide the warnings panel.
    :vartype hide_warnings: bool
    :ivar restrict_document_splitting: Disable the page editor after a document has been split
     once.
    :vartype restrict_document_splitting: bool
    :ivar disable_currency_formatting: Disable currency formatting of decimals values.
    :vartype disable_currency_formatting: bool
    :ivar disable_edit_document_metadata: Disable editing document metadata. Makes the collection
     selector, filename input and tags editor read only.
    :vartype disable_edit_document_metadata: bool
    """

    _attribute_map = {
        "theme": {"key": "theme", "type": "ThemeConfig"},
        "hide_actions": {"key": "hideActions", "type": "bool"},
        "hide_collection": {"key": "hideCollection", "type": "bool"},
        "hide_edit_pages": {"key": "hideEditPages", "type": "bool"},
        "hide_export": {"key": "hideExport", "type": "bool"},
        "hide_filename": {"key": "hideFilename", "type": "bool"},
        "hide_reject": {"key": "hideReject", "type": "bool"},
        "hide_reparse": {"key": "hideReparse", "type": "bool"},
        "hide_run_ocr": {"key": "hideRunOcr", "type": "bool"},
        "hide_tags": {"key": "hideTags", "type": "bool"},
        "hide_warnings": {"key": "hideWarnings", "type": "bool"},
        "restrict_document_splitting": {"key": "restrictDocumentSplitting", "type": "bool"},
        "disable_currency_formatting": {"key": "disableCurrencyFormatting", "type": "bool"},
        "disable_edit_document_metadata": {"key": "disableEditDocumentMetadata", "type": "bool"},
    }

    def __init__(
        self,
        *,
        theme: Optional["_models.ThemeConfig"] = None,
        hide_actions: Optional[bool] = None,
        hide_collection: Optional[bool] = None,
        hide_edit_pages: Optional[bool] = None,
        hide_export: Optional[bool] = None,
        hide_filename: Optional[bool] = None,
        hide_reject: Optional[bool] = None,
        hide_reparse: Optional[bool] = None,
        hide_run_ocr: Optional[bool] = None,
        hide_tags: Optional[bool] = None,
        hide_warnings: Optional[bool] = None,
        restrict_document_splitting: Optional[bool] = None,
        disable_currency_formatting: Optional[bool] = None,
        disable_edit_document_metadata: Optional[bool] = None,
        **kwargs,
    ):
        """
        :keyword theme:
        :paramtype theme: ~affinda.models.ThemeConfig
        :keyword hide_actions: Hide the confirm document button and other actions.
        :paramtype hide_actions: bool
        :keyword hide_collection: Hide the collection selector.
        :paramtype hide_collection: bool
        :keyword hide_edit_pages: Hide the edit pages button.
        :paramtype hide_edit_pages: bool
        :keyword hide_export: Hide the export menu.
        :paramtype hide_export: bool
        :keyword hide_filename: Hide the filename input.
        :paramtype hide_filename: bool
        :keyword hide_reject: Hide the reject document button.
        :paramtype hide_reject: bool
        :keyword hide_reparse: Hide the reparse button.
        :paramtype hide_reparse: bool
        :keyword hide_run_ocr: Hide the run OCR button.
        :paramtype hide_run_ocr: bool
        :keyword hide_tags: Hide the tags editor.
        :paramtype hide_tags: bool
        :keyword hide_warnings: Hide the warnings panel.
        :paramtype hide_warnings: bool
        :keyword restrict_document_splitting: Disable the page editor after a document has been split
         once.
        :paramtype restrict_document_splitting: bool
        :keyword disable_currency_formatting: Disable currency formatting of decimals values.
        :paramtype disable_currency_formatting: bool
        :keyword disable_edit_document_metadata: Disable editing document metadata. Makes the
         collection selector, filename input and tags editor read only.
        :paramtype disable_edit_document_metadata: bool
        """
        super(OrganizationValidationToolConfig, self).__init__(**kwargs)
        self.theme = theme
        self.hide_actions = hide_actions
        self.hide_collection = hide_collection
        self.hide_edit_pages = hide_edit_pages
        self.hide_export = hide_export
        self.hide_filename = hide_filename
        self.hide_reject = hide_reject
        self.hide_reparse = hide_reparse
        self.hide_run_ocr = hide_run_ocr
        self.hide_tags = hide_tags
        self.hide_warnings = hide_warnings
        self.restrict_document_splitting = restrict_document_splitting
        self.disable_currency_formatting = disable_currency_formatting
        self.disable_edit_document_metadata = disable_edit_document_metadata


class PageMeta(msrest.serialization.Model):
    """PageMeta.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required.
    :vartype id: int
    :ivar page_index: Required. Page number within the document, starts from 0.
    :vartype page_index: int
    :ivar image: Required. The URL to the image of the page.
    :vartype image: str
    :ivar image_translated: The URL to the translated image of the page.
    :vartype image_translated: str
    :ivar height: Required. Height of the page's image in px.
    :vartype height: float
    :ivar width: Required. Width of the page's image in px.
    :vartype width: float
    :ivar rotation: Required. The degree of rotation applied to the page. Greater than 0 indicates
     clockwise rotation. Less than 0 indicates counter-clockwise rotation.
    :vartype rotation: int
    """

    _validation = {
        "id": {"required": True, "minimum": 1},
        "page_index": {"required": True, "minimum": 0},
        "image": {"required": True},
        "height": {"required": True},
        "width": {"required": True},
        "rotation": {"required": True, "maximum": 360, "minimum": -360},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "image": {"key": "image", "type": "str"},
        "image_translated": {"key": "imageTranslated", "type": "str"},
        "height": {"key": "height", "type": "float"},
        "width": {"key": "width", "type": "float"},
        "rotation": {"key": "rotation", "type": "int"},
    }

    def __init__(
        self,
        *,
        id: int,
        page_index: int,
        image: str,
        height: float,
        width: float,
        rotation: int,
        image_translated: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword id: Required.
        :paramtype id: int
        :keyword page_index: Required. Page number within the document, starts from 0.
        :paramtype page_index: int
        :keyword image: Required. The URL to the image of the page.
        :paramtype image: str
        :keyword image_translated: The URL to the translated image of the page.
        :paramtype image_translated: str
        :keyword height: Required. Height of the page's image in px.
        :paramtype height: float
        :keyword width: Required. Width of the page's image in px.
        :paramtype width: float
        :keyword rotation: Required. The degree of rotation applied to the page. Greater than 0
         indicates clockwise rotation. Less than 0 indicates counter-clockwise rotation.
        :paramtype rotation: int
        """
        super(PageMeta, self).__init__(**kwargs)
        self.id = id
        self.page_index = page_index
        self.image = image
        self.image_translated = image_translated
        self.height = height
        self.width = width
        self.rotation = rotation


class PaginatedResponse(msrest.serialization.Model):
    """PaginatedResponse.

    All required parameters must be populated in order to send to Azure.

    :ivar count: Required. Number of items in results.
    :vartype count: int
    :ivar next: URL to request next page of results.
    :vartype next: str
    :ivar previous: URL to request previous page of results.
    :vartype previous: str
    """

    _validation = {
        "count": {"required": True, "minimum": 0},
    }

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
        "next": {"key": "next", "type": "str"},
        "previous": {"key": "previous", "type": "str"},
    }

    def __init__(
        self, *, count: int, next: Optional[str] = None, previous: Optional[str] = None, **kwargs
    ):
        """
        :keyword count: Required. Number of items in results.
        :paramtype count: int
        :keyword next: URL to request next page of results.
        :paramtype next: str
        :keyword previous: URL to request previous page of results.
        :paramtype previous: str
        """
        super(PaginatedResponse, self).__init__(**kwargs)
        self.count = count
        self.next = next
        self.previous = previous


class PaletteColorOptions(msrest.serialization.Model):
    """PaletteColorOptions.

    All required parameters must be populated in order to send to Azure.

    :ivar main: Required.
    :vartype main: str
    :ivar light:
    :vartype light: str
    :ivar dark:
    :vartype dark: str
    :ivar contrast_text:
    :vartype contrast_text: str
    """

    _validation = {
        "main": {"required": True},
    }

    _attribute_map = {
        "main": {"key": "main", "type": "str"},
        "light": {"key": "light", "type": "str"},
        "dark": {"key": "dark", "type": "str"},
        "contrast_text": {"key": "contrastText", "type": "str"},
    }

    def __init__(
        self,
        *,
        main: str,
        light: Optional[str] = None,
        dark: Optional[str] = None,
        contrast_text: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword main: Required.
        :paramtype main: str
        :keyword light:
        :paramtype light: str
        :keyword dark:
        :paramtype dark: str
        :keyword contrast_text:
        :paramtype contrast_text: str
        """
        super(PaletteColorOptions, self).__init__(**kwargs)
        self.main = main
        self.light = light
        self.dark = dark
        self.contrast_text = contrast_text


class Paths11PzrpaV3ApiUsersGetResponses200ContentApplicationJsonSchemaAllof1(
    msrest.serialization.Model
):
    """Paths11PzrpaV3ApiUsersGetResponses200ContentApplicationJsonSchemaAllof1.

    :ivar results:
    :vartype results: list[~affinda.models.ApiUserWithoutKey]
    """

    _attribute_map = {
        "results": {"key": "results", "type": "[ApiUserWithoutKey]"},
    }

    def __init__(self, *, results: Optional[List["_models.ApiUserWithoutKey"]] = None, **kwargs):
        """
        :keyword results:
        :paramtype results: list[~affinda.models.ApiUserWithoutKey]
        """
        super(
            Paths11PzrpaV3ApiUsersGetResponses200ContentApplicationJsonSchemaAllof1, self
        ).__init__(**kwargs)
        self.results = results


class Paths1UmoszuV3MappingDataSourcesGetResponses200ContentApplicationJsonSchemaAllof1(
    msrest.serialization.Model
):
    """Paths1UmoszuV3MappingDataSourcesGetResponses200ContentApplicationJsonSchemaAllof1.

    :ivar results:
    :vartype results: list[~affinda.models.MappingDataSource]
    """

    _attribute_map = {
        "results": {"key": "results", "type": "[MappingDataSource]"},
    }

    def __init__(self, *, results: Optional[List["_models.MappingDataSource"]] = None, **kwargs):
        """
        :keyword results:
        :paramtype results: list[~affinda.models.MappingDataSource]
        """
        super(
            Paths1UmoszuV3MappingDataSourcesGetResponses200ContentApplicationJsonSchemaAllof1, self
        ).__init__(**kwargs)
        self.results = results


class Paths11QdcofV3MappingDataSourcesGetResponses200ContentApplicationJsonSchema(
    PaginatedResponse,
    Paths1UmoszuV3MappingDataSourcesGetResponses200ContentApplicationJsonSchemaAllof1,
):
    """Paths11QdcofV3MappingDataSourcesGetResponses200ContentApplicationJsonSchema.

    All required parameters must be populated in order to send to Azure.

    :ivar results:
    :vartype results: list[~affinda.models.MappingDataSource]
    :ivar count: Required. Number of items in results.
    :vartype count: int
    :ivar next: URL to request next page of results.
    :vartype next: str
    :ivar previous: URL to request previous page of results.
    :vartype previous: str
    """

    _validation = {
        "count": {"required": True, "minimum": 0},
    }

    _attribute_map = {
        "results": {"key": "results", "type": "[MappingDataSource]"},
        "count": {"key": "count", "type": "int"},
        "next": {"key": "next", "type": "str"},
        "previous": {"key": "previous", "type": "str"},
    }

    def __init__(
        self,
        *,
        count: int,
        results: Optional[List["_models.MappingDataSource"]] = None,
        next: Optional[str] = None,
        previous: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword results:
        :paramtype results: list[~affinda.models.MappingDataSource]
        :keyword count: Required. Number of items in results.
        :paramtype count: int
        :keyword next: URL to request next page of results.
        :paramtype next: str
        :keyword previous: URL to request previous page of results.
        :paramtype previous: str
        """
        super(
            Paths11QdcofV3MappingDataSourcesGetResponses200ContentApplicationJsonSchema, self
        ).__init__(count=count, next=next, previous=previous, results=results, **kwargs)
        self.results = results
        self.count = count
        self.next = next
        self.previous = previous


class PathsKhpbbuV3InvitationsGetResponses200ContentApplicationJsonSchemaAllof1(
    msrest.serialization.Model
):
    """PathsKhpbbuV3InvitationsGetResponses200ContentApplicationJsonSchemaAllof1.

    :ivar results:
    :vartype results: list[~affinda.models.Invitation]
    """

    _attribute_map = {
        "results": {"key": "results", "type": "[Invitation]"},
    }

    def __init__(self, *, results: Optional[List["_models.Invitation"]] = None, **kwargs):
        """
        :keyword results:
        :paramtype results: list[~affinda.models.Invitation]
        """
        super(
            PathsKhpbbuV3InvitationsGetResponses200ContentApplicationJsonSchemaAllof1, self
        ).__init__(**kwargs)
        self.results = results


class Paths18Wh2VcV3InvitationsGetResponses200ContentApplicationJsonSchema(
    PaginatedResponse, PathsKhpbbuV3InvitationsGetResponses200ContentApplicationJsonSchemaAllof1
):
    """Paths18Wh2VcV3InvitationsGetResponses200ContentApplicationJsonSchema.

    All required parameters must be populated in order to send to Azure.

    :ivar results:
    :vartype results: list[~affinda.models.Invitation]
    :ivar count: Required. Number of items in results.
    :vartype count: int
    :ivar next: URL to request next page of results.
    :vartype next: str
    :ivar previous: URL to request previous page of results.
    :vartype previous: str
    """

    _validation = {
        "count": {"required": True, "minimum": 0},
    }

    _attribute_map = {
        "results": {"key": "results", "type": "[Invitation]"},
        "count": {"key": "count", "type": "int"},
        "next": {"key": "next", "type": "str"},
        "previous": {"key": "previous", "type": "str"},
    }

    def __init__(
        self,
        *,
        count: int,
        results: Optional[List["_models.Invitation"]] = None,
        next: Optional[str] = None,
        previous: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword results:
        :paramtype results: list[~affinda.models.Invitation]
        :keyword count: Required. Number of items in results.
        :paramtype count: int
        :keyword next: URL to request next page of results.
        :paramtype next: str
        :keyword previous: URL to request previous page of results.
        :paramtype previous: str
        """
        super(Paths18Wh2VcV3InvitationsGetResponses200ContentApplicationJsonSchema, self).__init__(
            count=count, next=next, previous=previous, results=results, **kwargs
        )
        self.results = results
        self.count = count
        self.next = next
        self.previous = previous


class Paths1Czpnk1V3ResumeSearchEmbedPostRequestbodyContentApplicationJsonSchema(
    msrest.serialization.Model
):
    """Paths1Czpnk1V3ResumeSearchEmbedPostRequestbodyContentApplicationJsonSchema.

    :ivar config_override:
    :vartype config_override: ~affinda.models.ResumeSearchConfig
    """

    _attribute_map = {
        "config_override": {"key": "configOverride", "type": "ResumeSearchConfig"},
    }

    def __init__(
        self, *, config_override: Optional["_models.ResumeSearchConfig"] = None, **kwargs
    ):
        """
        :keyword config_override:
        :paramtype config_override: ~affinda.models.ResumeSearchConfig
        """
        super(
            Paths1Czpnk1V3ResumeSearchEmbedPostRequestbodyContentApplicationJsonSchema, self
        ).__init__(**kwargs)
        self.config_override = config_override


class Paths1Dgz0V9V3AnnotationsGetResponses200ContentApplicationJsonSchemaAllof1(
    msrest.serialization.Model
):
    """Paths1Dgz0V9V3AnnotationsGetResponses200ContentApplicationJsonSchemaAllof1.

    :ivar results:
    :vartype results: list[~affinda.models.Annotation]
    """

    _attribute_map = {
        "results": {"key": "results", "type": "[Annotation]"},
    }

    def __init__(self, *, results: Optional[List["_models.Annotation"]] = None, **kwargs):
        """
        :keyword results:
        :paramtype results: list[~affinda.models.Annotation]
        """
        super(
            Paths1Dgz0V9V3AnnotationsGetResponses200ContentApplicationJsonSchemaAllof1, self
        ).__init__(**kwargs)
        self.results = results


class Paths1D5Zg6MV3AnnotationsGetResponses200ContentApplicationJsonSchema(
    PaginatedResponse, Paths1Dgz0V9V3AnnotationsGetResponses200ContentApplicationJsonSchemaAllof1
):
    """Paths1D5Zg6MV3AnnotationsGetResponses200ContentApplicationJsonSchema.

    All required parameters must be populated in order to send to Azure.

    :ivar results:
    :vartype results: list[~affinda.models.Annotation]
    :ivar count: Required. Number of items in results.
    :vartype count: int
    :ivar next: URL to request next page of results.
    :vartype next: str
    :ivar previous: URL to request previous page of results.
    :vartype previous: str
    """

    _validation = {
        "count": {"required": True, "minimum": 0},
    }

    _attribute_map = {
        "results": {"key": "results", "type": "[Annotation]"},
        "count": {"key": "count", "type": "int"},
        "next": {"key": "next", "type": "str"},
        "previous": {"key": "previous", "type": "str"},
    }

    def __init__(
        self,
        *,
        count: int,
        results: Optional[List["_models.Annotation"]] = None,
        next: Optional[str] = None,
        previous: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword results:
        :paramtype results: list[~affinda.models.Annotation]
        :keyword count: Required. Number of items in results.
        :paramtype count: int
        :keyword next: URL to request next page of results.
        :paramtype next: str
        :keyword previous: URL to request previous page of results.
        :paramtype previous: str
        """
        super(Paths1D5Zg6MV3AnnotationsGetResponses200ContentApplicationJsonSchema, self).__init__(
            count=count, next=next, previous=previous, results=results, **kwargs
        )
        self.results = results
        self.count = count
        self.next = next
        self.previous = previous


class PathsWvcyp9V3MappingsGetResponses200ContentApplicationJsonSchemaAllof1(
    msrest.serialization.Model
):
    """PathsWvcyp9V3MappingsGetResponses200ContentApplicationJsonSchemaAllof1.

    :ivar results:
    :vartype results: list[~affinda.models.Mapping]
    """

    _attribute_map = {
        "results": {"key": "results", "type": "[Mapping]"},
    }

    def __init__(self, *, results: Optional[List["_models.Mapping"]] = None, **kwargs):
        """
        :keyword results:
        :paramtype results: list[~affinda.models.Mapping]
        """
        super(
            PathsWvcyp9V3MappingsGetResponses200ContentApplicationJsonSchemaAllof1, self
        ).__init__(**kwargs)
        self.results = results


class Paths1Dpvb2PV3MappingsGetResponses200ContentApplicationJsonSchema(
    PaginatedResponse, PathsWvcyp9V3MappingsGetResponses200ContentApplicationJsonSchemaAllof1
):
    """Paths1Dpvb2PV3MappingsGetResponses200ContentApplicationJsonSchema.

    All required parameters must be populated in order to send to Azure.

    :ivar results:
    :vartype results: list[~affinda.models.Mapping]
    :ivar count: Required. Number of items in results.
    :vartype count: int
    :ivar next: URL to request next page of results.
    :vartype next: str
    :ivar previous: URL to request previous page of results.
    :vartype previous: str
    """

    _validation = {
        "count": {"required": True, "minimum": 0},
    }

    _attribute_map = {
        "results": {"key": "results", "type": "[Mapping]"},
        "count": {"key": "count", "type": "int"},
        "next": {"key": "next", "type": "str"},
        "previous": {"key": "previous", "type": "str"},
    }

    def __init__(
        self,
        *,
        count: int,
        results: Optional[List["_models.Mapping"]] = None,
        next: Optional[str] = None,
        previous: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword results:
        :paramtype results: list[~affinda.models.Mapping]
        :keyword count: Required. Number of items in results.
        :paramtype count: int
        :keyword next: URL to request next page of results.
        :paramtype next: str
        :keyword previous: URL to request previous page of results.
        :paramtype previous: str
        """
        super(Paths1Dpvb2PV3MappingsGetResponses200ContentApplicationJsonSchema, self).__init__(
            count=count, next=next, previous=previous, results=results, **kwargs
        )
        self.results = results
        self.count = count
        self.next = next
        self.previous = previous


class Paths1O6IvdaV3MappingDataSourcesIdentifierValuesGetResponses200ContentApplicationJsonSchemaAllof1(
    msrest.serialization.Model
):
    """Paths1O6IvdaV3MappingDataSourcesIdentifierValuesGetResponses200ContentApplicationJsonSchemaAllof1.

    :ivar results:
    :vartype results: list[any]
    """

    _attribute_map = {
        "results": {"key": "results", "type": "[object]"},
    }

    def __init__(self, *, results: Optional[List[Any]] = None, **kwargs):
        """
        :keyword results:
        :paramtype results: list[any]
        """
        super(
            Paths1O6IvdaV3MappingDataSourcesIdentifierValuesGetResponses200ContentApplicationJsonSchemaAllof1,
            self,
        ).__init__(**kwargs)
        self.results = results


class Paths1Qojy9V3ResthookSubscriptionsGetResponses200ContentApplicationJsonSchemaAllof1(
    msrest.serialization.Model
):
    """Paths1Qojy9V3ResthookSubscriptionsGetResponses200ContentApplicationJsonSchemaAllof1.

    :ivar results:
    :vartype results: list[~affinda.models.ResthookSubscription]
    """

    _attribute_map = {
        "results": {"key": "results", "type": "[ResthookSubscription]"},
    }

    def __init__(
        self, *, results: Optional[List["_models.ResthookSubscription"]] = None, **kwargs
    ):
        """
        :keyword results:
        :paramtype results: list[~affinda.models.ResthookSubscription]
        """
        super(
            Paths1Qojy9V3ResthookSubscriptionsGetResponses200ContentApplicationJsonSchemaAllof1,
            self,
        ).__init__(**kwargs)
        self.results = results


class Paths1Qr7BnyV3MappingDataSourcesIdentifierValuesGetResponses200ContentApplicationJsonSchema(
    PaginatedResponse,
    Paths1O6IvdaV3MappingDataSourcesIdentifierValuesGetResponses200ContentApplicationJsonSchemaAllof1,
):
    """Paths1Qr7BnyV3MappingDataSourcesIdentifierValuesGetResponses200ContentApplicationJsonSchema.

    All required parameters must be populated in order to send to Azure.

    :ivar results:
    :vartype results: list[any]
    :ivar count: Required. Number of items in results.
    :vartype count: int
    :ivar next: URL to request next page of results.
    :vartype next: str
    :ivar previous: URL to request previous page of results.
    :vartype previous: str
    """

    _validation = {
        "count": {"required": True, "minimum": 0},
    }

    _attribute_map = {
        "results": {"key": "results", "type": "[object]"},
        "count": {"key": "count", "type": "int"},
        "next": {"key": "next", "type": "str"},
        "previous": {"key": "previous", "type": "str"},
    }

    def __init__(
        self,
        *,
        count: int,
        results: Optional[List[Any]] = None,
        next: Optional[str] = None,
        previous: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword results:
        :paramtype results: list[any]
        :keyword count: Required. Number of items in results.
        :paramtype count: int
        :keyword next: URL to request next page of results.
        :paramtype next: str
        :keyword previous: URL to request previous page of results.
        :paramtype previous: str
        """
        super(
            Paths1Qr7BnyV3MappingDataSourcesIdentifierValuesGetResponses200ContentApplicationJsonSchema,
            self,
        ).__init__(count=count, next=next, previous=previous, results=results, **kwargs)
        self.results = results
        self.count = count
        self.next = next
        self.previous = previous


class Paths26Civ0V3ApiUsersGetResponses200ContentApplicationJsonSchema(
    PaginatedResponse, Paths11PzrpaV3ApiUsersGetResponses200ContentApplicationJsonSchemaAllof1
):
    """Paths26Civ0V3ApiUsersGetResponses200ContentApplicationJsonSchema.

    All required parameters must be populated in order to send to Azure.

    :ivar results:
    :vartype results: list[~affinda.models.ApiUserWithoutKey]
    :ivar count: Required. Number of items in results.
    :vartype count: int
    :ivar next: URL to request next page of results.
    :vartype next: str
    :ivar previous: URL to request previous page of results.
    :vartype previous: str
    """

    _validation = {
        "count": {"required": True, "minimum": 0},
    }

    _attribute_map = {
        "results": {"key": "results", "type": "[ApiUserWithoutKey]"},
        "count": {"key": "count", "type": "int"},
        "next": {"key": "next", "type": "str"},
        "previous": {"key": "previous", "type": "str"},
    }

    def __init__(
        self,
        *,
        count: int,
        results: Optional[List["_models.ApiUserWithoutKey"]] = None,
        next: Optional[str] = None,
        previous: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword results:
        :paramtype results: list[~affinda.models.ApiUserWithoutKey]
        :keyword count: Required. Number of items in results.
        :paramtype count: int
        :keyword next: URL to request next page of results.
        :paramtype next: str
        :keyword previous: URL to request previous page of results.
        :paramtype previous: str
        """
        super(Paths26Civ0V3ApiUsersGetResponses200ContentApplicationJsonSchema, self).__init__(
            count=count, next=next, previous=previous, results=results, **kwargs
        )
        self.results = results
        self.count = count
        self.next = next
        self.previous = previous


class Paths2Ld2HiV3WorkspaceMembershipsGetResponses200ContentApplicationJsonSchemaAllof1(
    msrest.serialization.Model
):
    """Paths2Ld2HiV3WorkspaceMembershipsGetResponses200ContentApplicationJsonSchemaAllof1.

    All required parameters must be populated in order to send to Azure.

    :ivar results: Required.
    :vartype results: list[~affinda.models.WorkspaceMembership]
    """

    _validation = {
        "results": {"required": True},
    }

    _attribute_map = {
        "results": {"key": "results", "type": "[WorkspaceMembership]"},
    }

    def __init__(self, *, results: List["_models.WorkspaceMembership"], **kwargs):
        """
        :keyword results: Required.
        :paramtype results: list[~affinda.models.WorkspaceMembership]
        """
        super(
            Paths2Ld2HiV3WorkspaceMembershipsGetResponses200ContentApplicationJsonSchemaAllof1,
            self,
        ).__init__(**kwargs)
        self.results = results


class Paths4K6IzqV3DataPointChoicesGetResponses200ContentApplicationJsonSchemaAllof1(
    msrest.serialization.Model
):
    """Paths4K6IzqV3DataPointChoicesGetResponses200ContentApplicationJsonSchemaAllof1.

    :ivar results:
    :vartype results: list[~affinda.models.DataPointChoice]
    """

    _attribute_map = {
        "results": {"key": "results", "type": "[DataPointChoice]"},
    }

    def __init__(self, *, results: Optional[List["_models.DataPointChoice"]] = None, **kwargs):
        """
        :keyword results:
        :paramtype results: list[~affinda.models.DataPointChoice]
        """
        super(
            Paths4K6IzqV3DataPointChoicesGetResponses200ContentApplicationJsonSchemaAllof1, self
        ).__init__(**kwargs)
        self.results = results


class Paths4T5Cm5V3IndexGetResponses200ContentApplicationJsonSchemaAllof1(
    msrest.serialization.Model
):
    """Paths4T5Cm5V3IndexGetResponses200ContentApplicationJsonSchemaAllof1.

    :ivar results:
    :vartype results: list[~affinda.models.Index]
    """

    _attribute_map = {
        "results": {"key": "results", "type": "[Index]"},
    }

    def __init__(self, *, results: Optional[List["_models.Index"]] = None, **kwargs):
        """
        :keyword results:
        :paramtype results: list[~affinda.models.Index]
        """
        super(Paths4T5Cm5V3IndexGetResponses200ContentApplicationJsonSchemaAllof1, self).__init__(
            **kwargs
        )
        self.results = results


class Paths93Fa0ZV3OrganizationMembershipsGetResponses200ContentApplicationJsonSchemaAllof1(
    msrest.serialization.Model
):
    """Paths93Fa0ZV3OrganizationMembershipsGetResponses200ContentApplicationJsonSchemaAllof1.

    :ivar results:
    :vartype results: list[~affinda.models.OrganizationMembership]
    """

    _attribute_map = {
        "results": {"key": "results", "type": "[OrganizationMembership]"},
    }

    def __init__(
        self, *, results: Optional[List["_models.OrganizationMembership"]] = None, **kwargs
    ):
        """
        :keyword results:
        :paramtype results: list[~affinda.models.OrganizationMembership]
        """
        super(
            Paths93Fa0ZV3OrganizationMembershipsGetResponses200ContentApplicationJsonSchemaAllof1,
            self,
        ).__init__(**kwargs)
        self.results = results


class PathsCl024WV3IndexNameDocumentsPostRequestbodyContentApplicationJsonSchema(
    msrest.serialization.Model
):
    """PathsCl024WV3IndexNameDocumentsPostRequestbodyContentApplicationJsonSchema.

    :ivar document:
    :vartype document: str
    """

    _attribute_map = {
        "document": {"key": "document", "type": "str"},
    }

    def __init__(self, *, document: Optional[str] = None, **kwargs):
        """
        :keyword document:
        :paramtype document: str
        """
        super(
            PathsCl024WV3IndexNameDocumentsPostRequestbodyContentApplicationJsonSchema, self
        ).__init__(**kwargs)
        self.document = document


class PathsDvrcp3V3IndexGetResponses200ContentApplicationJsonSchema(
    PaginatedResponse, Paths4T5Cm5V3IndexGetResponses200ContentApplicationJsonSchemaAllof1
):
    """PathsDvrcp3V3IndexGetResponses200ContentApplicationJsonSchema.

    All required parameters must be populated in order to send to Azure.

    :ivar results:
    :vartype results: list[~affinda.models.Index]
    :ivar count: Required. Number of items in results.
    :vartype count: int
    :ivar next: URL to request next page of results.
    :vartype next: str
    :ivar previous: URL to request previous page of results.
    :vartype previous: str
    """

    _validation = {
        "count": {"required": True, "minimum": 0},
    }

    _attribute_map = {
        "results": {"key": "results", "type": "[Index]"},
        "count": {"key": "count", "type": "int"},
        "next": {"key": "next", "type": "str"},
        "previous": {"key": "previous", "type": "str"},
    }

    def __init__(
        self,
        *,
        count: int,
        results: Optional[List["_models.Index"]] = None,
        next: Optional[str] = None,
        previous: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword results:
        :paramtype results: list[~affinda.models.Index]
        :keyword count: Required. Number of items in results.
        :paramtype count: int
        :keyword next: URL to request next page of results.
        :paramtype next: str
        :keyword previous: URL to request previous page of results.
        :paramtype previous: str
        """
        super(PathsDvrcp3V3IndexGetResponses200ContentApplicationJsonSchema, self).__init__(
            count=count, next=next, previous=previous, results=results, **kwargs
        )
        self.results = results
        self.count = count
        self.next = next
        self.previous = previous


class PathsFte27NV3IndexNameDocumentsPostResponses201ContentApplicationJsonSchema(
    msrest.serialization.Model
):
    """PathsFte27NV3IndexNameDocumentsPostResponses201ContentApplicationJsonSchema.

    :ivar document: Unique identifier for the document.
    :vartype document: str
    """

    _attribute_map = {
        "document": {"key": "document", "type": "str"},
    }

    def __init__(self, *, document: Optional[str] = None, **kwargs):
        """
        :keyword document: Unique identifier for the document.
        :paramtype document: str
        """
        super(
            PathsFte27NV3IndexNameDocumentsPostResponses201ContentApplicationJsonSchema, self
        ).__init__(**kwargs)
        self.document = document


class PathsL3R02CV3DocumentsGetResponses200ContentApplicationJsonSchemaAllof1(
    msrest.serialization.Model
):
    """PathsL3R02CV3DocumentsGetResponses200ContentApplicationJsonSchemaAllof1.

    :ivar results:
    :vartype results: list[~affinda.models.Document]
    """

    _attribute_map = {
        "results": {"key": "results", "type": "[Document]"},
    }

    def __init__(self, *, results: Optional[List["_models.Document"]] = None, **kwargs):
        """
        :keyword results:
        :paramtype results: list[~affinda.models.Document]
        """
        super(
            PathsL3R02CV3DocumentsGetResponses200ContentApplicationJsonSchemaAllof1, self
        ).__init__(**kwargs)
        self.results = results


class PathsM3DzbgV3JobDescriptionSearchEmbedPostRequestbodyContentApplicationJsonSchema(
    msrest.serialization.Model
):
    """PathsM3DzbgV3JobDescriptionSearchEmbedPostRequestbodyContentApplicationJsonSchema.

    :ivar config_override:
    :vartype config_override: ~affinda.models.JobDescriptionSearchConfig
    """

    _attribute_map = {
        "config_override": {"key": "configOverride", "type": "JobDescriptionSearchConfig"},
    }

    def __init__(
        self, *, config_override: Optional["_models.JobDescriptionSearchConfig"] = None, **kwargs
    ):
        """
        :keyword config_override:
        :paramtype config_override: ~affinda.models.JobDescriptionSearchConfig
        """
        super(
            PathsM3DzbgV3JobDescriptionSearchEmbedPostRequestbodyContentApplicationJsonSchema, self
        ).__init__(**kwargs)
        self.config_override = config_override


class PathsMnwxgV3DataPointChoicesGetResponses200ContentApplicationJsonSchema(
    PaginatedResponse,
    Paths4K6IzqV3DataPointChoicesGetResponses200ContentApplicationJsonSchemaAllof1,
):
    """PathsMnwxgV3DataPointChoicesGetResponses200ContentApplicationJsonSchema.

    All required parameters must be populated in order to send to Azure.

    :ivar results:
    :vartype results: list[~affinda.models.DataPointChoice]
    :ivar count: Required. Number of items in results.
    :vartype count: int
    :ivar next: URL to request next page of results.
    :vartype next: str
    :ivar previous: URL to request previous page of results.
    :vartype previous: str
    """

    _validation = {
        "count": {"required": True, "minimum": 0},
    }

    _attribute_map = {
        "results": {"key": "results", "type": "[DataPointChoice]"},
        "count": {"key": "count", "type": "int"},
        "next": {"key": "next", "type": "str"},
        "previous": {"key": "previous", "type": "str"},
    }

    def __init__(
        self,
        *,
        count: int,
        results: Optional[List["_models.DataPointChoice"]] = None,
        next: Optional[str] = None,
        previous: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword results:
        :paramtype results: list[~affinda.models.DataPointChoice]
        :keyword count: Required. Number of items in results.
        :paramtype count: int
        :keyword next: URL to request next page of results.
        :paramtype next: str
        :keyword previous: URL to request previous page of results.
        :paramtype previous: str
        """
        super(
            PathsMnwxgV3DataPointChoicesGetResponses200ContentApplicationJsonSchema, self
        ).__init__(count=count, next=next, previous=previous, results=results, **kwargs)
        self.results = results
        self.count = count
        self.next = next
        self.previous = previous


class PathsO7SnenV3IndexNameDocumentsGetResponses200ContentApplicationJsonSchema(
    msrest.serialization.Model
):
    """PathsO7SnenV3IndexNameDocumentsGetResponses200ContentApplicationJsonSchema.

    :ivar count: Number of indexed documents in result.
    :vartype count: int
    :ivar next: URL to request next page of results.
    :vartype next: str
    :ivar previous: URL to request previous page of results.
    :vartype previous: str
    :ivar results:
    :vartype results: list[~affinda.models.Get200ApplicationJsonPropertiesItemsItem]
    """

    _validation = {
        "count": {"minimum": 1},
    }

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
        "next": {"key": "next", "type": "str"},
        "previous": {"key": "previous", "type": "str"},
        "results": {"key": "results", "type": "[Get200ApplicationJsonPropertiesItemsItem]"},
    }

    def __init__(
        self,
        *,
        count: Optional[int] = None,
        next: Optional[str] = None,
        previous: Optional[str] = None,
        results: Optional[List["_models.Get200ApplicationJsonPropertiesItemsItem"]] = None,
        **kwargs,
    ):
        """
        :keyword count: Number of indexed documents in result.
        :paramtype count: int
        :keyword next: URL to request next page of results.
        :paramtype next: str
        :keyword previous: URL to request previous page of results.
        :paramtype previous: str
        :keyword results:
        :paramtype results: list[~affinda.models.Get200ApplicationJsonPropertiesItemsItem]
        """
        super(
            PathsO7SnenV3IndexNameDocumentsGetResponses200ContentApplicationJsonSchema, self
        ).__init__(**kwargs)
        self.count = count
        self.next = next
        self.previous = previous
        self.results = results


class PathsOxm5M7V3DocumentsGetResponses200ContentApplicationJsonSchema(
    PaginatedResponse, PathsL3R02CV3DocumentsGetResponses200ContentApplicationJsonSchemaAllof1
):
    """PathsOxm5M7V3DocumentsGetResponses200ContentApplicationJsonSchema.

    All required parameters must be populated in order to send to Azure.

    :ivar results:
    :vartype results: list[~affinda.models.Document]
    :ivar count: Required. Number of items in results.
    :vartype count: int
    :ivar next: URL to request next page of results.
    :vartype next: str
    :ivar previous: URL to request previous page of results.
    :vartype previous: str
    """

    _validation = {
        "count": {"required": True, "minimum": 0},
    }

    _attribute_map = {
        "results": {"key": "results", "type": "[Document]"},
        "count": {"key": "count", "type": "int"},
        "next": {"key": "next", "type": "str"},
        "previous": {"key": "previous", "type": "str"},
    }

    def __init__(
        self,
        *,
        count: int,
        results: Optional[List["_models.Document"]] = None,
        next: Optional[str] = None,
        previous: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword results:
        :paramtype results: list[~affinda.models.Document]
        :keyword count: Required. Number of items in results.
        :paramtype count: int
        :keyword next: URL to request next page of results.
        :paramtype next: str
        :keyword previous: URL to request previous page of results.
        :paramtype previous: str
        """
        super(PathsOxm5M7V3DocumentsGetResponses200ContentApplicationJsonSchema, self).__init__(
            count=count, next=next, previous=previous, results=results, **kwargs
        )
        self.results = results
        self.count = count
        self.next = next
        self.previous = previous


class PathsQ5Os5RV3OrganizationMembershipsGetResponses200ContentApplicationJsonSchema(
    PaginatedResponse,
    Paths93Fa0ZV3OrganizationMembershipsGetResponses200ContentApplicationJsonSchemaAllof1,
):
    """PathsQ5Os5RV3OrganizationMembershipsGetResponses200ContentApplicationJsonSchema.

    All required parameters must be populated in order to send to Azure.

    :ivar results:
    :vartype results: list[~affinda.models.OrganizationMembership]
    :ivar count: Required. Number of items in results.
    :vartype count: int
    :ivar next: URL to request next page of results.
    :vartype next: str
    :ivar previous: URL to request previous page of results.
    :vartype previous: str
    """

    _validation = {
        "count": {"required": True, "minimum": 0},
    }

    _attribute_map = {
        "results": {"key": "results", "type": "[OrganizationMembership]"},
        "count": {"key": "count", "type": "int"},
        "next": {"key": "next", "type": "str"},
        "previous": {"key": "previous", "type": "str"},
    }

    def __init__(
        self,
        *,
        count: int,
        results: Optional[List["_models.OrganizationMembership"]] = None,
        next: Optional[str] = None,
        previous: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword results:
        :paramtype results: list[~affinda.models.OrganizationMembership]
        :keyword count: Required. Number of items in results.
        :paramtype count: int
        :keyword next: URL to request next page of results.
        :paramtype next: str
        :keyword previous: URL to request previous page of results.
        :paramtype previous: str
        """
        super(
            PathsQ5Os5RV3OrganizationMembershipsGetResponses200ContentApplicationJsonSchema, self
        ).__init__(count=count, next=next, previous=previous, results=results, **kwargs)
        self.results = results
        self.count = count
        self.next = next
        self.previous = previous


class PathsVz5Kj2V3ResthookSubscriptionsGetResponses200ContentApplicationJsonSchema(
    PaginatedResponse,
    Paths1Qojy9V3ResthookSubscriptionsGetResponses200ContentApplicationJsonSchemaAllof1,
):
    """PathsVz5Kj2V3ResthookSubscriptionsGetResponses200ContentApplicationJsonSchema.

    All required parameters must be populated in order to send to Azure.

    :ivar results:
    :vartype results: list[~affinda.models.ResthookSubscription]
    :ivar count: Required. Number of items in results.
    :vartype count: int
    :ivar next: URL to request next page of results.
    :vartype next: str
    :ivar previous: URL to request previous page of results.
    :vartype previous: str
    """

    _validation = {
        "count": {"required": True, "minimum": 0},
    }

    _attribute_map = {
        "results": {"key": "results", "type": "[ResthookSubscription]"},
        "count": {"key": "count", "type": "int"},
        "next": {"key": "next", "type": "str"},
        "previous": {"key": "previous", "type": "str"},
    }

    def __init__(
        self,
        *,
        count: int,
        results: Optional[List["_models.ResthookSubscription"]] = None,
        next: Optional[str] = None,
        previous: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword results:
        :paramtype results: list[~affinda.models.ResthookSubscription]
        :keyword count: Required. Number of items in results.
        :paramtype count: int
        :keyword next: URL to request next page of results.
        :paramtype next: str
        :keyword previous: URL to request previous page of results.
        :paramtype previous: str
        """
        super(
            PathsVz5Kj2V3ResthookSubscriptionsGetResponses200ContentApplicationJsonSchema, self
        ).__init__(count=count, next=next, previous=previous, results=results, **kwargs)
        self.results = results
        self.count = count
        self.next = next
        self.previous = previous


class PathsZ1JuagV3WorkspaceMembershipsGetResponses200ContentApplicationJsonSchema(
    PaginatedResponse,
    Paths2Ld2HiV3WorkspaceMembershipsGetResponses200ContentApplicationJsonSchemaAllof1,
):
    """PathsZ1JuagV3WorkspaceMembershipsGetResponses200ContentApplicationJsonSchema.

    All required parameters must be populated in order to send to Azure.

    :ivar results: Required.
    :vartype results: list[~affinda.models.WorkspaceMembership]
    :ivar count: Required. Number of items in results.
    :vartype count: int
    :ivar next: URL to request next page of results.
    :vartype next: str
    :ivar previous: URL to request previous page of results.
    :vartype previous: str
    """

    _validation = {
        "results": {"required": True},
        "count": {"required": True, "minimum": 0},
    }

    _attribute_map = {
        "results": {"key": "results", "type": "[WorkspaceMembership]"},
        "count": {"key": "count", "type": "int"},
        "next": {"key": "next", "type": "str"},
        "previous": {"key": "previous", "type": "str"},
    }

    def __init__(
        self,
        *,
        results: List["_models.WorkspaceMembership"],
        count: int,
        next: Optional[str] = None,
        previous: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword results: Required.
        :paramtype results: list[~affinda.models.WorkspaceMembership]
        :keyword count: Required. Number of items in results.
        :paramtype count: int
        :keyword next: URL to request next page of results.
        :paramtype next: str
        :keyword previous: URL to request previous page of results.
        :paramtype previous: str
        """
        super(
            PathsZ1JuagV3WorkspaceMembershipsGetResponses200ContentApplicationJsonSchema, self
        ).__init__(count=count, next=next, previous=previous, results=results, **kwargs)
        self.results = results
        self.count = count
        self.next = next
        self.previous = previous


class PhoneNumberAnnotation(Annotation):
    """PhoneNumberAnnotation.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required. Annotation's ID.
    :vartype id: int
    :ivar rectangle: Required. x/y coordinates for the rectangular bounding box containing the
     data.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required. x/y coordinates for the rectangles containing the data. An
     annotation can be contained within multiple rectangles.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar document: Required. Unique identifier for the document.
    :vartype document: str
    :ivar page_index: Required. The page number within the document, starting from 0.
    :vartype page_index: int
    :ivar raw: Required. Raw data extracted from the before any post-processing.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required. Indicates whether the data has been validated, either by a human
     using our validation tool or through auto-validation rules.
    :vartype is_verified: bool
    :ivar is_client_verified: Required. Indicates whether the data has been validated by a human.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required. Indicates whether the data has been auto-validated.
    :vartype is_auto_verified: bool
    :ivar data_point: Data point's identifier.
    :vartype data_point: str
    :ivar field: Field's identifier.
    :vartype field: str
    :ivar content_type: Required. The different data types of annotations. Known values are:
     "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
     "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
     "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
    :vartype content_type: str or ~affinda.models.AnnotationContentType
    :ivar parent: The parent annotation's ID.
    :vartype parent: int
    :ivar parsed:
    :vartype parsed: ~affinda.models.PhoneNumberAnnotationParsed
    """

    _validation = {
        "id": {"required": True, "minimum": 1},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "document": {"required": True},
        "page_index": {"required": True, "minimum": 0},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "document": {"key": "document", "type": "str"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "field": {"key": "field", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parent": {"key": "parent", "type": "int"},
        "parsed": {"key": "parsed", "type": "PhoneNumberAnnotationParsed"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        document: str,
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        content_type: Union[str, "_models.AnnotationContentType"],
        additional_properties: Optional[Dict[str, Any]] = None,
        data_point: Optional[str] = None,
        field: Optional[str] = None,
        parent: Optional[int] = None,
        parsed: Optional["_models.PhoneNumberAnnotationParsed"] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required. Annotation's ID.
        :paramtype id: int
        :keyword rectangle: Required. x/y coordinates for the rectangular bounding box containing the
         data.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required. x/y coordinates for the rectangles containing the data. An
         annotation can be contained within multiple rectangles.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword document: Required. Unique identifier for the document.
        :paramtype document: str
        :keyword page_index: Required. The page number within the document, starting from 0.
        :paramtype page_index: int
        :keyword raw: Required. Raw data extracted from the before any post-processing.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required. Indicates whether the data has been validated, either by a
         human using our validation tool or through auto-validation rules.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required. Indicates whether the data has been validated by a
         human.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required. Indicates whether the data has been auto-validated.
        :paramtype is_auto_verified: bool
        :keyword data_point: Data point's identifier.
        :paramtype data_point: str
        :keyword field: Field's identifier.
        :paramtype field: str
        :keyword content_type: Required. The different data types of annotations. Known values are:
         "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
         "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
         "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
        :paramtype content_type: str or ~affinda.models.AnnotationContentType
        :keyword parent: The parent annotation's ID.
        :paramtype parent: int
        :keyword parsed:
        :paramtype parsed: ~affinda.models.PhoneNumberAnnotationParsed
        """
        super(PhoneNumberAnnotation, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            document=document,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            field=field,
            content_type=content_type,
            parent=parent,
            **kwargs,
        )
        self.parsed = parsed


class PhoneNumberAnnotationParsed(msrest.serialization.Model):
    """PhoneNumberAnnotationParsed.

    :ivar raw_text:
    :vartype raw_text: str
    :ivar formatted_number:
    :vartype formatted_number: str
    :ivar country_code:
    :vartype country_code: str
    :ivar international_country_code:
    :vartype international_country_code: int
    :ivar national_number:
    :vartype national_number: str
    """

    _validation = {
        "international_country_code": {"minimum": 1},
    }

    _attribute_map = {
        "raw_text": {"key": "rawText", "type": "str"},
        "formatted_number": {"key": "formattedNumber", "type": "str"},
        "country_code": {"key": "countryCode", "type": "str"},
        "international_country_code": {"key": "internationalCountryCode", "type": "int"},
        "national_number": {"key": "nationalNumber", "type": "str"},
    }

    def __init__(
        self,
        *,
        raw_text: Optional[str] = None,
        formatted_number: Optional[str] = None,
        country_code: Optional[str] = None,
        international_country_code: Optional[int] = None,
        national_number: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword raw_text:
        :paramtype raw_text: str
        :keyword formatted_number:
        :paramtype formatted_number: str
        :keyword country_code:
        :paramtype country_code: str
        :keyword international_country_code:
        :paramtype international_country_code: int
        :keyword national_number:
        :paramtype national_number: str
        """
        super(PhoneNumberAnnotationParsed, self).__init__(**kwargs)
        self.raw_text = raw_text
        self.formatted_number = formatted_number
        self.country_code = country_code
        self.international_country_code = international_country_code
        self.national_number = national_number


class PydanticModelsResponse(msrest.serialization.Model):
    """PydanticModelsResponse.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required. Pydantic model code.
    :vartype code: str
    """

    _validation = {
        "code": {"required": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
    }

    def __init__(self, *, code: str, **kwargs):
        """
        :keyword code: Required. Pydantic model code.
        :paramtype code: str
        """
        super(PydanticModelsResponse, self).__init__(**kwargs)
        self.code = code


class Rectangle(msrest.serialization.Model):
    """Rectangle.

    All required parameters must be populated in order to send to Azure.

    :ivar page_index:
    :vartype page_index: int
    :ivar x0: Required.
    :vartype x0: float
    :ivar y0: Required.
    :vartype y0: float
    :ivar x1: Required.
    :vartype x1: float
    :ivar y1: Required.
    :vartype y1: float
    """

    _validation = {
        "page_index": {"minimum": 0},
        "x0": {"required": True},
        "y0": {"required": True},
        "x1": {"required": True},
        "y1": {"required": True},
    }

    _attribute_map = {
        "page_index": {"key": "pageIndex", "type": "int"},
        "x0": {"key": "x0", "type": "float"},
        "y0": {"key": "y0", "type": "float"},
        "x1": {"key": "x1", "type": "float"},
        "y1": {"key": "y1", "type": "float"},
    }

    def __init__(
        self,
        *,
        x0: float,
        y0: float,
        x1: float,
        y1: float,
        page_index: Optional[int] = None,
        **kwargs,
    ):
        """
        :keyword page_index:
        :paramtype page_index: int
        :keyword x0: Required.
        :paramtype x0: float
        :keyword y0: Required.
        :paramtype y0: float
        :keyword x1: Required.
        :paramtype x1: float
        :keyword y1: Required.
        :paramtype y1: float
        """
        super(Rectangle, self).__init__(**kwargs)
        self.page_index = page_index
        self.x0 = x0
        self.y0 = y0
        self.x1 = x1
        self.y1 = y1


class RedactConfig(msrest.serialization.Model):
    """RedactConfig.

    :ivar redact_headshot:
    :vartype redact_headshot: bool
    :ivar redact_personal_details:
    :vartype redact_personal_details: bool
    :ivar redact_work_details:
    :vartype redact_work_details: bool
    :ivar redact_referees:
    :vartype redact_referees: bool
    :ivar redact_education_details:
    :vartype redact_education_details: bool
    :ivar redact_locations:
    :vartype redact_locations: bool
    :ivar redact_dates:
    :vartype redact_dates: bool
    :ivar redact_gender:
    :vartype redact_gender: bool
    """

    _attribute_map = {
        "redact_headshot": {"key": "redactHeadshot", "type": "bool"},
        "redact_personal_details": {"key": "redactPersonalDetails", "type": "bool"},
        "redact_work_details": {"key": "redactWorkDetails", "type": "bool"},
        "redact_referees": {"key": "redactReferees", "type": "bool"},
        "redact_education_details": {"key": "redactEducationDetails", "type": "bool"},
        "redact_locations": {"key": "redactLocations", "type": "bool"},
        "redact_dates": {"key": "redactDates", "type": "bool"},
        "redact_gender": {"key": "redactGender", "type": "bool"},
    }

    def __init__(
        self,
        *,
        redact_headshot: Optional[bool] = None,
        redact_personal_details: Optional[bool] = None,
        redact_work_details: Optional[bool] = None,
        redact_referees: Optional[bool] = None,
        redact_education_details: Optional[bool] = None,
        redact_locations: Optional[bool] = None,
        redact_dates: Optional[bool] = None,
        redact_gender: Optional[bool] = None,
        **kwargs,
    ):
        """
        :keyword redact_headshot:
        :paramtype redact_headshot: bool
        :keyword redact_personal_details:
        :paramtype redact_personal_details: bool
        :keyword redact_work_details:
        :paramtype redact_work_details: bool
        :keyword redact_referees:
        :paramtype redact_referees: bool
        :keyword redact_education_details:
        :paramtype redact_education_details: bool
        :keyword redact_locations:
        :paramtype redact_locations: bool
        :keyword redact_dates:
        :paramtype redact_dates: bool
        :keyword redact_gender:
        :paramtype redact_gender: bool
        """
        super(RedactConfig, self).__init__(**kwargs)
        self.redact_headshot = redact_headshot
        self.redact_personal_details = redact_personal_details
        self.redact_work_details = redact_work_details
        self.redact_referees = redact_referees
        self.redact_education_details = redact_education_details
        self.redact_locations = redact_locations
        self.redact_dates = redact_dates
        self.redact_gender = redact_gender


class RegionBias(msrest.serialization.Model):
    """RegionBias.

    :ivar country: A single alpha-2 country code (e.g. AU) used by google geocoding service.
    :vartype country: str
    :ivar countries: A list of alpha-2 country codes used by Pelias.
    :vartype countries: list[str]
    :ivar square_coordinates: A list of coordinates used by Pelias in the shape of [min_lon,
     min_lat, max_lon, max_lat].
    :vartype square_coordinates: list[float]
    :ivar strict: If true, the location must be within the region, as opposed to prefering
     locations within the region.
     Default to false.
    :vartype strict: bool
    """

    _attribute_map = {
        "country": {"key": "country", "type": "str"},
        "countries": {"key": "countries", "type": "[str]"},
        "square_coordinates": {"key": "squareCoordinates", "type": "[float]"},
        "strict": {"key": "strict", "type": "bool"},
    }

    def __init__(
        self,
        *,
        country: Optional[str] = None,
        countries: Optional[List[str]] = None,
        square_coordinates: Optional[List[float]] = None,
        strict: Optional[bool] = None,
        **kwargs,
    ):
        """
        :keyword country: A single alpha-2 country code (e.g. AU) used by google geocoding service.
        :paramtype country: str
        :keyword countries: A list of alpha-2 country codes used by Pelias.
        :paramtype countries: list[str]
        :keyword square_coordinates: A list of coordinates used by Pelias in the shape of [min_lon,
         min_lat, max_lon, max_lat].
        :paramtype square_coordinates: list[float]
        :keyword strict: If true, the location must be within the region, as opposed to prefering
         locations within the region.
         Default to false.
        :paramtype strict: bool
        """
        super(RegionBias, self).__init__(**kwargs)
        self.country = country
        self.countries = countries
        self.square_coordinates = square_coordinates
        self.strict = strict


class RequestError(msrest.serialization.Model):
    """RequestError.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required.
    :vartype type: str
    :ivar errors: Required.
    :vartype errors: list[~affinda.models.RequestErrorErrorsItem]
    """

    _validation = {
        "type": {"required": True},
        "errors": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "errors": {"key": "errors", "type": "[RequestErrorErrorsItem]"},
    }

    def __init__(self, *, type: str, errors: List["_models.RequestErrorErrorsItem"], **kwargs):
        """
        :keyword type: Required.
        :paramtype type: str
        :keyword errors: Required.
        :paramtype errors: list[~affinda.models.RequestErrorErrorsItem]
        """
        super(RequestError, self).__init__(**kwargs)
        self.type = type
        self.errors = errors


class RequestErrorErrorsItem(msrest.serialization.Model):
    """RequestErrorErrorsItem.

    All required parameters must be populated in order to send to Azure.

    :ivar attr: Required.
    :vartype attr: str
    :ivar code: Required.
    :vartype code: str
    :ivar detail: Required.
    :vartype detail: str
    """

    _validation = {
        "attr": {"required": True},
        "code": {"required": True},
        "detail": {"required": True},
    }

    _attribute_map = {
        "attr": {"key": "attr", "type": "str"},
        "code": {"key": "code", "type": "str"},
        "detail": {"key": "detail", "type": "str"},
    }

    def __init__(self, *, attr: str, code: str, detail: str, **kwargs):
        """
        :keyword attr: Required.
        :paramtype attr: str
        :keyword code: Required.
        :paramtype code: str
        :keyword detail: Required.
        :paramtype detail: str
        """
        super(RequestErrorErrorsItem, self).__init__(**kwargs)
        self.attr = attr
        self.code = code
        self.detail = detail


class ResthookSubscription(msrest.serialization.Model):
    """ResthookSubscription.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Resthook subscription's ID.
    :vartype id: int
    :ivar event: Required. The event name to subscribe to. Known values are:
     "resume.parse.succeeded", "resume.parse.failed", "resume.parse.completed",
     "invoice.parse.succeeded", "invoice.parse.failed", "invoice.parse.completed",
     "invoice.validate.completed", "document.parse.succeeded", "document.parse.failed",
     "document.parse.completed", "document.validate.completed", "document.classify.succeeded",
     "document.classify.failed", "document.classify.completed", "document.rejected",
     "annotation.validated".
    :vartype event: str or ~affinda.models.ResthookEvent
    :ivar organization: Required.
    :vartype organization: ~affinda.models.Organization
    :ivar workspace: Required.
    :vartype workspace: ~affinda.models.ResthookSubscriptionWorkspace
    :ivar target_url: Required. URL of the resthook's receiver.
    :vartype target_url: str
    :ivar active: Required. Resthooks only fire for active subscriptions.
    :vartype active: bool
    :ivar auto_deactivated: Required. Resthook subscriptions can be auto deactivated if the
     receiver continuously returns error status code over a period of time.
    :vartype auto_deactivated: bool
    :ivar auto_deactivate_reason: Required. The reason for the subscription being auto deactivated.
     May contains the error response that the receiver returned.
    :vartype auto_deactivate_reason: str
    :ivar version: Required. Version of the resthook subscription. Determines the resthook body
     being fired. Known values are: "v1", "v2", "v3".
    :vartype version: str or ~affinda.models.ResthookSubscriptionVersion
    """

    _validation = {
        "id": {"required": True},
        "event": {"required": True},
        "organization": {"required": True},
        "workspace": {"required": True},
        "target_url": {"required": True},
        "active": {"required": True},
        "auto_deactivated": {"required": True},
        "auto_deactivate_reason": {"required": True},
        "version": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "event": {"key": "event", "type": "str"},
        "organization": {"key": "organization", "type": "Organization"},
        "workspace": {"key": "workspace", "type": "ResthookSubscriptionWorkspace"},
        "target_url": {"key": "targetUrl", "type": "str"},
        "active": {"key": "active", "type": "bool"},
        "auto_deactivated": {"key": "autoDeactivated", "type": "bool"},
        "auto_deactivate_reason": {"key": "autoDeactivateReason", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        event: Union[str, "_models.ResthookEvent"],
        organization: "_models.Organization",
        workspace: "_models.ResthookSubscriptionWorkspace",
        target_url: str,
        active: bool,
        auto_deactivated: bool,
        auto_deactivate_reason: str,
        version: Union[str, "_models.ResthookSubscriptionVersion"],
        **kwargs,
    ):
        """
        :keyword id: Required. Resthook subscription's ID.
        :paramtype id: int
        :keyword event: Required. The event name to subscribe to. Known values are:
         "resume.parse.succeeded", "resume.parse.failed", "resume.parse.completed",
         "invoice.parse.succeeded", "invoice.parse.failed", "invoice.parse.completed",
         "invoice.validate.completed", "document.parse.succeeded", "document.parse.failed",
         "document.parse.completed", "document.validate.completed", "document.classify.succeeded",
         "document.classify.failed", "document.classify.completed", "document.rejected",
         "annotation.validated".
        :paramtype event: str or ~affinda.models.ResthookEvent
        :keyword organization: Required.
        :paramtype organization: ~affinda.models.Organization
        :keyword workspace: Required.
        :paramtype workspace: ~affinda.models.ResthookSubscriptionWorkspace
        :keyword target_url: Required. URL of the resthook's receiver.
        :paramtype target_url: str
        :keyword active: Required. Resthooks only fire for active subscriptions.
        :paramtype active: bool
        :keyword auto_deactivated: Required. Resthook subscriptions can be auto deactivated if the
         receiver continuously returns error status code over a period of time.
        :paramtype auto_deactivated: bool
        :keyword auto_deactivate_reason: Required. The reason for the subscription being auto
         deactivated. May contains the error response that the receiver returned.
        :paramtype auto_deactivate_reason: str
        :keyword version: Required. Version of the resthook subscription. Determines the resthook body
         being fired. Known values are: "v1", "v2", "v3".
        :paramtype version: str or ~affinda.models.ResthookSubscriptionVersion
        """
        super(ResthookSubscription, self).__init__(**kwargs)
        self.id = id
        self.event = event
        self.organization = organization
        self.workspace = workspace
        self.target_url = target_url
        self.active = active
        self.auto_deactivated = auto_deactivated
        self.auto_deactivate_reason = auto_deactivate_reason
        self.version = version


class ResthookSubscriptionCreate(msrest.serialization.Model):
    """ResthookSubscriptionCreate.

    All required parameters must be populated in order to send to Azure.

    :ivar target_url: Required. URL of the resthook's receiver.
    :vartype target_url: str
    :ivar event: Required. The event name to subscribe to. Known values are:
     "resume.parse.succeeded", "resume.parse.failed", "resume.parse.completed",
     "invoice.parse.succeeded", "invoice.parse.failed", "invoice.parse.completed",
     "invoice.validate.completed", "document.parse.succeeded", "document.parse.failed",
     "document.parse.completed", "document.validate.completed", "document.classify.succeeded",
     "document.classify.failed", "document.classify.completed", "document.rejected",
     "annotation.validated".
    :vartype event: str or ~affinda.models.ResthookEvent
    :ivar organization:
    :vartype organization: str
    :ivar workspace:
    :vartype workspace: str
    :ivar version: Version of the resthook subscription. Determines the resthook body being fired.
     Known values are: "v1", "v2", "v3".
    :vartype version: str or ~affinda.models.Version
    """

    _validation = {
        "target_url": {"required": True},
        "event": {"required": True},
    }

    _attribute_map = {
        "target_url": {"key": "targetUrl", "type": "str"},
        "event": {"key": "event", "type": "str"},
        "organization": {"key": "organization", "type": "str"},
        "workspace": {"key": "workspace", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(
        self,
        *,
        target_url: str,
        event: Union[str, "_models.ResthookEvent"],
        organization: Optional[str] = None,
        workspace: Optional[str] = None,
        version: Optional[Union[str, "_models.Version"]] = None,
        **kwargs,
    ):
        """
        :keyword target_url: Required. URL of the resthook's receiver.
        :paramtype target_url: str
        :keyword event: Required. The event name to subscribe to. Known values are:
         "resume.parse.succeeded", "resume.parse.failed", "resume.parse.completed",
         "invoice.parse.succeeded", "invoice.parse.failed", "invoice.parse.completed",
         "invoice.validate.completed", "document.parse.succeeded", "document.parse.failed",
         "document.parse.completed", "document.validate.completed", "document.classify.succeeded",
         "document.classify.failed", "document.classify.completed", "document.rejected",
         "annotation.validated".
        :paramtype event: str or ~affinda.models.ResthookEvent
        :keyword organization:
        :paramtype organization: str
        :keyword workspace:
        :paramtype workspace: str
        :keyword version: Version of the resthook subscription. Determines the resthook body being
         fired. Known values are: "v1", "v2", "v3".
        :paramtype version: str or ~affinda.models.Version
        """
        super(ResthookSubscriptionCreate, self).__init__(**kwargs)
        self.target_url = target_url
        self.event = event
        self.organization = organization
        self.workspace = workspace
        self.version = version


class ResthookSubscriptionUpdate(msrest.serialization.Model):
    """ResthookSubscriptionUpdate.

    :ivar event: The event name to subscribe to. Known values are: "resume.parse.succeeded",
     "resume.parse.failed", "resume.parse.completed", "invoice.parse.succeeded",
     "invoice.parse.failed", "invoice.parse.completed", "invoice.validate.completed",
     "document.parse.succeeded", "document.parse.failed", "document.parse.completed",
     "document.validate.completed", "document.classify.succeeded", "document.classify.failed",
     "document.classify.completed", "document.rejected", "annotation.validated".
    :vartype event: str or ~affinda.models.ResthookEvent
    :ivar organization: Uniquely identify an organization.
    :vartype organization: str
    :ivar workspace: Uniquely identify a workspace.
    :vartype workspace: str
    :ivar version: Version of the resthook subscription. Determines the resthook body being fired.
     Known values are: "v1", "v2", "v3".
    :vartype version: str or ~affinda.models.Version
    """

    _attribute_map = {
        "event": {"key": "event", "type": "str"},
        "organization": {"key": "organization", "type": "str"},
        "workspace": {"key": "workspace", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(
        self,
        *,
        event: Optional[Union[str, "_models.ResthookEvent"]] = None,
        organization: Optional[str] = None,
        workspace: Optional[str] = None,
        version: Optional[Union[str, "_models.Version"]] = None,
        **kwargs,
    ):
        """
        :keyword event: The event name to subscribe to. Known values are: "resume.parse.succeeded",
         "resume.parse.failed", "resume.parse.completed", "invoice.parse.succeeded",
         "invoice.parse.failed", "invoice.parse.completed", "invoice.validate.completed",
         "document.parse.succeeded", "document.parse.failed", "document.parse.completed",
         "document.validate.completed", "document.classify.succeeded", "document.classify.failed",
         "document.classify.completed", "document.rejected", "annotation.validated".
        :paramtype event: str or ~affinda.models.ResthookEvent
        :keyword organization: Uniquely identify an organization.
        :paramtype organization: str
        :keyword workspace: Uniquely identify a workspace.
        :paramtype workspace: str
        :keyword version: Version of the resthook subscription. Determines the resthook body being
         fired. Known values are: "v1", "v2", "v3".
        :paramtype version: str or ~affinda.models.Version
        """
        super(ResthookSubscriptionUpdate, self).__init__(**kwargs)
        self.event = event
        self.organization = organization
        self.workspace = workspace
        self.version = version


class ResthookSubscriptionWorkspace(msrest.serialization.Model):
    """ResthookSubscriptionWorkspace.

    All required parameters must be populated in order to send to Azure.

    :ivar identifier: Required. Uniquely identify a workspace.
    :vartype identifier: str
    :ivar name: Required.
    :vartype name: str
    :ivar organization: Required.
    :vartype organization: ~affinda.models.Organization
    """

    _validation = {
        "identifier": {"required": True},
        "name": {"required": True},
        "organization": {"required": True},
    }

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "organization": {"key": "organization", "type": "Organization"},
    }

    def __init__(
        self, *, identifier: str, name: str, organization: "_models.Organization", **kwargs
    ):
        """
        :keyword identifier: Required. Uniquely identify a workspace.
        :paramtype identifier: str
        :keyword name: Required.
        :paramtype name: str
        :keyword organization: Required.
        :paramtype organization: ~affinda.models.Organization
        """
        super(ResthookSubscriptionWorkspace, self).__init__(**kwargs)
        self.identifier = identifier
        self.name = name
        self.organization = organization


class Resume(Document):
    """Resume.

    All required parameters must be populated in order to send to Azure.

    :ivar extractor: Required. Constant filled by server.
    :vartype extractor: str
    :ivar meta: Required.
    :vartype meta: ~affinda.models.DocumentMeta
    :ivar error:
    :vartype error: ~affinda.models.DocumentError
    :ivar warnings:
    :vartype warnings: list[~affinda.models.DocumentWarning]
    :ivar data: A JSON-encoded string of the ``ResumeData`` object.
    :vartype data: ~affinda.models.ResumeData
    """

    _validation = {
        "extractor": {"required": True},
        "meta": {"required": True},
    }

    _attribute_map = {
        "extractor": {"key": "extractor", "type": "str"},
        "meta": {"key": "meta", "type": "DocumentMeta"},
        "error": {"key": "error", "type": "DocumentError"},
        "warnings": {"key": "warnings", "type": "[DocumentWarning]"},
        "data": {"key": "data", "type": "ResumeData"},
    }

    def __init__(
        self,
        *,
        meta: "_models.DocumentMeta",
        error: Optional["_models.DocumentError"] = None,
        warnings: Optional[List["_models.DocumentWarning"]] = None,
        data: Optional["_models.ResumeData"] = None,
        **kwargs,
    ):
        """
        :keyword meta: Required.
        :paramtype meta: ~affinda.models.DocumentMeta
        :keyword error:
        :paramtype error: ~affinda.models.DocumentError
        :keyword warnings:
        :paramtype warnings: list[~affinda.models.DocumentWarning]
        :keyword data: A JSON-encoded string of the ``ResumeData`` object.
        :paramtype data: ~affinda.models.ResumeData
        """
        super(Resume, self).__init__(meta=meta, error=error, warnings=warnings, **kwargs)
        self.extractor = "resume"  # type: str
        self.data = data


class ResumeData(msrest.serialization.Model):
    """A JSON-encoded string of the ``ResumeData`` object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar name:
    :vartype name: ~affinda.models.ResumeDataName
    :ivar phone_numbers:
    :vartype phone_numbers: list[str]
    :ivar phone_number_details:
    :vartype phone_number_details: list[~affinda.models.ResumeDataPhoneNumberDetailsItem]
    :ivar websites:
    :vartype websites: list[str]
    :ivar emails:
    :vartype emails: list[str]
    :ivar date_of_birth:
    :vartype date_of_birth: str
    :ivar location:
    :vartype location: ~affinda.models.Location
    :ivar objective:
    :vartype objective: str
    :ivar languages:
    :vartype languages: list[str or ~affinda.models.ResumeDataLanguagesItem]
    :ivar language_codes:
    :vartype language_codes: list[str]
    :ivar summary:
    :vartype summary: str
    :ivar total_years_experience:
    :vartype total_years_experience: int
    :ivar head_shot: base64 encoded string.
    :vartype head_shot: bytearray
    :ivar education:
    :vartype education: list[~affinda.models.Education]
    :ivar profession: Prediction of the candidate's profession based on recent work experience.
    :vartype profession: str
    :ivar linkedin: Linkedin account associated with the candidate.
    :vartype linkedin: str
    :ivar work_experience:
    :vartype work_experience: list[~affinda.models.ResumeDataWorkExperienceItem]
    :ivar skills:
    :vartype skills: list[~affinda.models.ResumeDataSkillsItem]
    :ivar certifications:
    :vartype certifications: list[str]
    :ivar publications:
    :vartype publications: list[str]
    :ivar referees:
    :vartype referees: list[~affinda.models.ResumeDataRefereesItem]
    :ivar sections:
    :vartype sections: list[~affinda.models.ResumeDataSectionsItem]
    :ivar is_resume_probability: Probability that the given document is a resume. Values below 30
     suggest that the document is not a resume.
    :vartype is_resume_probability: int
    :ivar raw_text: All of the raw text of the parsed resume, example is shortened for readability.
    :vartype raw_text: str
    :ivar redacted_text: Redacted version of the text in the resume, removing PII.
    :vartype redacted_text: str
    """

    _validation = {
        "language_codes": {"readonly": True},
        "total_years_experience": {"minimum": 0},
        "head_shot": {"readonly": True},
        "profession": {"readonly": True},
        "linkedin": {"readonly": True},
        "sections": {"readonly": True},
        "is_resume_probability": {"readonly": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "name": {"key": "name", "type": "ResumeDataName"},
        "phone_numbers": {"key": "phoneNumbers", "type": "[str]"},
        "phone_number_details": {
            "key": "phoneNumberDetails",
            "type": "[ResumeDataPhoneNumberDetailsItem]",
        },
        "websites": {"key": "websites", "type": "[str]"},
        "emails": {"key": "emails", "type": "[str]"},
        "date_of_birth": {"key": "dateOfBirth", "type": "str"},
        "location": {"key": "location", "type": "Location"},
        "objective": {"key": "objective", "type": "str"},
        "languages": {"key": "languages", "type": "[str]"},
        "language_codes": {"key": "languageCodes", "type": "[str]"},
        "summary": {"key": "summary", "type": "str"},
        "total_years_experience": {"key": "totalYearsExperience", "type": "int"},
        "head_shot": {"key": "headShot", "type": "bytearray"},
        "education": {"key": "education", "type": "[Education]"},
        "profession": {"key": "profession", "type": "str"},
        "linkedin": {"key": "linkedin", "type": "str"},
        "work_experience": {"key": "workExperience", "type": "[ResumeDataWorkExperienceItem]"},
        "skills": {"key": "skills", "type": "[ResumeDataSkillsItem]"},
        "certifications": {"key": "certifications", "type": "[str]"},
        "publications": {"key": "publications", "type": "[str]"},
        "referees": {"key": "referees", "type": "[ResumeDataRefereesItem]"},
        "sections": {"key": "sections", "type": "[ResumeDataSectionsItem]"},
        "is_resume_probability": {"key": "isResumeProbability", "type": "int"},
        "raw_text": {"key": "rawText", "type": "str"},
        "redacted_text": {"key": "redactedText", "type": "str"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        name: Optional["_models.ResumeDataName"] = None,
        phone_numbers: Optional[List[str]] = None,
        phone_number_details: Optional[List["_models.ResumeDataPhoneNumberDetailsItem"]] = None,
        websites: Optional[List[str]] = None,
        emails: Optional[List[str]] = None,
        date_of_birth: Optional[str] = None,
        location: Optional["_models.Location"] = None,
        objective: Optional[str] = "",
        languages: Optional[List[Union[str, "_models.ResumeDataLanguagesItem"]]] = None,
        summary: Optional[str] = "",
        total_years_experience: Optional[int] = None,
        education: Optional[List["_models.Education"]] = None,
        work_experience: Optional[List["_models.ResumeDataWorkExperienceItem"]] = None,
        skills: Optional[List["_models.ResumeDataSkillsItem"]] = None,
        certifications: Optional[List[str]] = None,
        publications: Optional[List[str]] = None,
        referees: Optional[List["_models.ResumeDataRefereesItem"]] = None,
        raw_text: Optional[str] = None,
        redacted_text: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword name:
        :paramtype name: ~affinda.models.ResumeDataName
        :keyword phone_numbers:
        :paramtype phone_numbers: list[str]
        :keyword phone_number_details:
        :paramtype phone_number_details: list[~affinda.models.ResumeDataPhoneNumberDetailsItem]
        :keyword websites:
        :paramtype websites: list[str]
        :keyword emails:
        :paramtype emails: list[str]
        :keyword date_of_birth:
        :paramtype date_of_birth: str
        :keyword location:
        :paramtype location: ~affinda.models.Location
        :keyword objective:
        :paramtype objective: str
        :keyword languages:
        :paramtype languages: list[str or ~affinda.models.ResumeDataLanguagesItem]
        :keyword summary:
        :paramtype summary: str
        :keyword total_years_experience:
        :paramtype total_years_experience: int
        :keyword education:
        :paramtype education: list[~affinda.models.Education]
        :keyword work_experience:
        :paramtype work_experience: list[~affinda.models.ResumeDataWorkExperienceItem]
        :keyword skills:
        :paramtype skills: list[~affinda.models.ResumeDataSkillsItem]
        :keyword certifications:
        :paramtype certifications: list[str]
        :keyword publications:
        :paramtype publications: list[str]
        :keyword referees:
        :paramtype referees: list[~affinda.models.ResumeDataRefereesItem]
        :keyword raw_text: All of the raw text of the parsed resume, example is shortened for
         readability.
        :paramtype raw_text: str
        :keyword redacted_text: Redacted version of the text in the resume, removing PII.
        :paramtype redacted_text: str
        """
        super(ResumeData, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.name = name
        self.phone_numbers = phone_numbers
        self.phone_number_details = phone_number_details
        self.websites = websites
        self.emails = emails
        self.date_of_birth = date_of_birth
        self.location = location
        self.objective = objective
        self.languages = languages
        self.language_codes = None
        self.summary = summary
        self.total_years_experience = total_years_experience
        self.head_shot = None
        self.education = education
        self.profession = None
        self.linkedin = None
        self.work_experience = work_experience
        self.skills = skills
        self.certifications = certifications
        self.publications = publications
        self.referees = referees
        self.sections = None
        self.is_resume_probability = None
        self.raw_text = raw_text
        self.redacted_text = redacted_text


class ResumeDataName(msrest.serialization.Model):
    """ResumeDataName.

    :ivar raw:
    :vartype raw: str
    :ivar first:
    :vartype first: str
    :ivar last:
    :vartype last: str
    :ivar middle:
    :vartype middle: str
    :ivar title:
    :vartype title: str
    """

    _attribute_map = {
        "raw": {"key": "raw", "type": "str"},
        "first": {"key": "first", "type": "str"},
        "last": {"key": "last", "type": "str"},
        "middle": {"key": "middle", "type": "str"},
        "title": {"key": "title", "type": "str"},
    }

    def __init__(
        self,
        *,
        raw: Optional[str] = None,
        first: Optional[str] = None,
        last: Optional[str] = None,
        middle: Optional[str] = None,
        title: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword raw:
        :paramtype raw: str
        :keyword first:
        :paramtype first: str
        :keyword last:
        :paramtype last: str
        :keyword middle:
        :paramtype middle: str
        :keyword title:
        :paramtype title: str
        """
        super(ResumeDataName, self).__init__(**kwargs)
        self.raw = raw
        self.first = first
        self.last = last
        self.middle = middle
        self.title = title


class ResumeDataPhoneNumberDetailsItem(msrest.serialization.Model):
    """ResumeDataPhoneNumberDetailsItem.

    :ivar raw_text:
    :vartype raw_text: str
    :ivar formatted_number:
    :vartype formatted_number: str
    :ivar country_code:
    :vartype country_code: str
    :ivar international_country_code:
    :vartype international_country_code: int
    :ivar national_number:
    :vartype national_number: str
    """

    _validation = {
        "international_country_code": {"minimum": 1},
    }

    _attribute_map = {
        "raw_text": {"key": "rawText", "type": "str"},
        "formatted_number": {"key": "formattedNumber", "type": "str"},
        "country_code": {"key": "countryCode", "type": "str"},
        "international_country_code": {"key": "internationalCountryCode", "type": "int"},
        "national_number": {"key": "nationalNumber", "type": "str"},
    }

    def __init__(
        self,
        *,
        raw_text: Optional[str] = None,
        formatted_number: Optional[str] = None,
        country_code: Optional[str] = None,
        international_country_code: Optional[int] = None,
        national_number: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword raw_text:
        :paramtype raw_text: str
        :keyword formatted_number:
        :paramtype formatted_number: str
        :keyword country_code:
        :paramtype country_code: str
        :keyword international_country_code:
        :paramtype international_country_code: int
        :keyword national_number:
        :paramtype national_number: str
        """
        super(ResumeDataPhoneNumberDetailsItem, self).__init__(**kwargs)
        self.raw_text = raw_text
        self.formatted_number = formatted_number
        self.country_code = country_code
        self.international_country_code = international_country_code
        self.national_number = national_number


class ResumeDataRefereesItem(msrest.serialization.Model):
    """ResumeDataRefereesItem.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar name:
    :vartype name: str
    :ivar text:
    :vartype text: str
    :ivar email:
    :vartype email: str
    :ivar number:
    :vartype number: str
    :ivar position:
    :vartype position: str
    """

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "name": {"key": "name", "type": "str"},
        "text": {"key": "text", "type": "str"},
        "email": {"key": "email", "type": "str"},
        "number": {"key": "number", "type": "str"},
        "position": {"key": "position", "type": "str"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        name: Optional[str] = None,
        text: Optional[str] = None,
        email: Optional[str] = None,
        number: Optional[str] = None,
        position: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword name:
        :paramtype name: str
        :keyword text:
        :paramtype text: str
        :keyword email:
        :paramtype email: str
        :keyword number:
        :paramtype number: str
        :keyword position:
        :paramtype position: str
        """
        super(ResumeDataRefereesItem, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.name = name
        self.text = text
        self.email = email
        self.number = number
        self.position = position


class ResumeDataSectionsItem(msrest.serialization.Model):
    """ResumeDataSectionsItem.

    :ivar section_type:
    :vartype section_type: str
    :ivar bbox:
    :vartype bbox: list[float]
    :ivar page_index:
    :vartype page_index: int
    :ivar text:
    :vartype text: str
    """

    _validation = {
        "bbox": {"max_items": 4, "min_items": 4},
    }

    _attribute_map = {
        "section_type": {"key": "sectionType", "type": "str"},
        "bbox": {"key": "bbox", "type": "[float]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "text": {"key": "text", "type": "str"},
    }

    def __init__(
        self,
        *,
        section_type: Optional[str] = None,
        bbox: Optional[List[float]] = None,
        page_index: Optional[int] = None,
        text: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword section_type:
        :paramtype section_type: str
        :keyword bbox:
        :paramtype bbox: list[float]
        :keyword page_index:
        :paramtype page_index: int
        :keyword text:
        :paramtype text: str
        """
        super(ResumeDataSectionsItem, self).__init__(**kwargs)
        self.section_type = section_type
        self.bbox = bbox
        self.page_index = page_index
        self.text = text


class ResumeDataSkillsItem(msrest.serialization.Model):
    """ResumeDataSkillsItem.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id:
    :vartype id: int
    :ivar emsi_id: EMSI id of this skill.
    :vartype emsi_id: str
    :ivar name:
    :vartype name: str
    :ivar last_used:
    :vartype last_used: str
    :ivar number_of_months:
    :vartype number_of_months: int
    :ivar type:
    :vartype type: str
    :ivar count:
    :vartype count: int
    :ivar weighting:
    :vartype weighting: float
    :ivar sources:
    :vartype sources: list[~affinda.models.ResumeDataSkillsPropertiesItemsItem]
    """

    _validation = {
        "id": {"minimum": 1},
        "emsi_id": {"readonly": True},
        "number_of_months": {"minimum": 0},
        "type": {"readonly": True},
        "count": {"readonly": True, "minimum": 0},
        "weighting": {"readonly": True},
        "sources": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "emsi_id": {"key": "emsiId", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "last_used": {"key": "lastUsed", "type": "str"},
        "number_of_months": {"key": "numberOfMonths", "type": "int"},
        "type": {"key": "type", "type": "str"},
        "count": {"key": "count", "type": "int"},
        "weighting": {"key": "weighting", "type": "float"},
        "sources": {"key": "sources", "type": "[ResumeDataSkillsPropertiesItemsItem]"},
    }

    def __init__(
        self,
        *,
        id: Optional[int] = None,
        name: Optional[str] = None,
        last_used: Optional[str] = None,
        number_of_months: Optional[int] = None,
        **kwargs,
    ):
        """
        :keyword id:
        :paramtype id: int
        :keyword name:
        :paramtype name: str
        :keyword last_used:
        :paramtype last_used: str
        :keyword number_of_months:
        :paramtype number_of_months: int
        """
        super(ResumeDataSkillsItem, self).__init__(**kwargs)
        self.id = id
        self.emsi_id = None
        self.name = name
        self.last_used = last_used
        self.number_of_months = number_of_months
        self.type = None
        self.count = None
        self.weighting = None
        self.sources = None


class ResumeDataSkillsPropertiesItemsItem(msrest.serialization.Model):
    """ResumeDataSkillsPropertiesItemsItem.

    :ivar section:
    :vartype section: str
    :ivar position: If this skill is extracted from a "workExperience" section, the "position" is
     the index of the work experience where this skill is found, with 0 being the first work
     experience, 1 being the second work experience, and so on.
    :vartype position: int
    :ivar work_experience_id: If this skill is extracted from a "workExperience" section, the
     "workExperienceId" is the id of the work experience where this skill is found.
    :vartype work_experience_id: int
    """

    _attribute_map = {
        "section": {"key": "section", "type": "str"},
        "position": {"key": "position", "type": "int"},
        "work_experience_id": {"key": "workExperienceId", "type": "int"},
    }

    def __init__(
        self,
        *,
        section: Optional[str] = None,
        position: Optional[int] = None,
        work_experience_id: Optional[int] = None,
        **kwargs,
    ):
        """
        :keyword section:
        :paramtype section: str
        :keyword position: If this skill is extracted from a "workExperience" section, the "position"
         is the index of the work experience where this skill is found, with 0 being the first work
         experience, 1 being the second work experience, and so on.
        :paramtype position: int
        :keyword work_experience_id: If this skill is extracted from a "workExperience" section, the
         "workExperienceId" is the id of the work experience where this skill is found.
        :paramtype work_experience_id: int
        """
        super(ResumeDataSkillsPropertiesItemsItem, self).__init__(**kwargs)
        self.section = section
        self.position = position
        self.work_experience_id = work_experience_id


class ResumeDataWorkExperienceItem(msrest.serialization.Model):
    """ResumeDataWorkExperienceItem.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id:
    :vartype id: int
    :ivar job_title:
    :vartype job_title: str
    :ivar soc_code:
    :vartype soc_code: str
    :ivar soc_name:
    :vartype soc_name: str
    :ivar organization:
    :vartype organization: str
    :ivar industry:
    :vartype industry: str
    :ivar location:
    :vartype location: ~affinda.models.Location
    :ivar job_description:
    :vartype job_description: str
    :ivar dates:
    :vartype dates: ~affinda.models.ResumeDataWorkExperienceItemDates
    :ivar occupation:
    :vartype occupation: ~affinda.models.ResumeDataWorkExperienceItemOccupation
    """

    _validation = {
        "id": {"minimum": 1},
        "soc_code": {"readonly": True},
        "soc_name": {"readonly": True},
        "industry": {"readonly": True},
        "occupation": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "job_title": {"key": "jobTitle", "type": "str"},
        "soc_code": {"key": "socCode", "type": "str"},
        "soc_name": {"key": "socName", "type": "str"},
        "organization": {"key": "organization", "type": "str"},
        "industry": {"key": "industry", "type": "str"},
        "location": {"key": "location", "type": "Location"},
        "job_description": {"key": "jobDescription", "type": "str"},
        "dates": {"key": "dates", "type": "ResumeDataWorkExperienceItemDates"},
        "occupation": {"key": "occupation", "type": "ResumeDataWorkExperienceItemOccupation"},
    }

    def __init__(
        self,
        *,
        id: Optional[int] = None,
        job_title: Optional[str] = None,
        organization: Optional[str] = None,
        location: Optional["_models.Location"] = None,
        job_description: Optional[str] = None,
        dates: Optional["_models.ResumeDataWorkExperienceItemDates"] = None,
        **kwargs,
    ):
        """
        :keyword id:
        :paramtype id: int
        :keyword job_title:
        :paramtype job_title: str
        :keyword organization:
        :paramtype organization: str
        :keyword location:
        :paramtype location: ~affinda.models.Location
        :keyword job_description:
        :paramtype job_description: str
        :keyword dates:
        :paramtype dates: ~affinda.models.ResumeDataWorkExperienceItemDates
        """
        super(ResumeDataWorkExperienceItem, self).__init__(**kwargs)
        self.id = id
        self.job_title = job_title
        self.soc_code = None
        self.soc_name = None
        self.organization = organization
        self.industry = None
        self.location = location
        self.job_description = job_description
        self.dates = dates
        self.occupation = None


class ResumeDataWorkExperienceItemDates(msrest.serialization.Model):
    """ResumeDataWorkExperienceItemDates.

    :ivar start_date:
    :vartype start_date: ~datetime.date
    :ivar end_date:
    :vartype end_date: ~datetime.date
    :ivar months_in_position:
    :vartype months_in_position: int
    :ivar is_current:
    :vartype is_current: bool
    :ivar raw_text:
    :vartype raw_text: str
    """

    _validation = {
        "months_in_position": {"minimum": 0},
    }

    _attribute_map = {
        "start_date": {"key": "startDate", "type": "date"},
        "end_date": {"key": "endDate", "type": "date"},
        "months_in_position": {"key": "monthsInPosition", "type": "int"},
        "is_current": {"key": "isCurrent", "type": "bool"},
        "raw_text": {"key": "rawText", "type": "str"},
    }

    def __init__(
        self,
        *,
        start_date: Optional[datetime.date] = None,
        end_date: Optional[datetime.date] = None,
        months_in_position: Optional[int] = None,
        is_current: Optional[bool] = None,
        raw_text: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword start_date:
        :paramtype start_date: ~datetime.date
        :keyword end_date:
        :paramtype end_date: ~datetime.date
        :keyword months_in_position:
        :paramtype months_in_position: int
        :keyword is_current:
        :paramtype is_current: bool
        :keyword raw_text:
        :paramtype raw_text: str
        """
        super(ResumeDataWorkExperienceItemDates, self).__init__(**kwargs)
        self.start_date = start_date
        self.end_date = end_date
        self.months_in_position = months_in_position
        self.is_current = is_current
        self.raw_text = raw_text


class ResumeDataWorkExperienceItemOccupation(msrest.serialization.Model):
    """ResumeDataWorkExperienceItemOccupation.

    :ivar job_title: The raw (not normalized) job title pulled from the work experience entry.
    :vartype job_title: str
    :ivar job_title_normalized: Mapped onto the EMSI job title taxonomy if a sufficiently close
     match exists.
    :vartype job_title_normalized: str
    :ivar emsi_id: EMSI id of the normalised job title.
    :vartype emsi_id: str
    :ivar management_level: Known values are: "None", "Low", "Mid", "Upper".
    :vartype management_level: str or ~affinda.models.ManagementLevel
    :ivar classification:
    :vartype classification:
     ~affinda.models.Components1TryetgSchemasResumedataPropertiesWorkexperienceItemsPropertiesOccupationPropertiesClassification
    """

    _attribute_map = {
        "job_title": {"key": "jobTitle", "type": "str"},
        "job_title_normalized": {"key": "jobTitleNormalized", "type": "str"},
        "emsi_id": {"key": "emsiId", "type": "str"},
        "management_level": {"key": "managementLevel", "type": "str"},
        "classification": {
            "key": "classification",
            "type": "Components1TryetgSchemasResumedataPropertiesWorkexperienceItemsPropertiesOccupationPropertiesClassification",
        },
    }

    def __init__(
        self,
        *,
        job_title: Optional[str] = None,
        job_title_normalized: Optional[str] = None,
        emsi_id: Optional[str] = None,
        management_level: Optional[Union[str, "_models.ManagementLevel"]] = None,
        classification: Optional[
            "_models.Components1TryetgSchemasResumedataPropertiesWorkexperienceItemsPropertiesOccupationPropertiesClassification"
        ] = None,
        **kwargs,
    ):
        """
        :keyword job_title: The raw (not normalized) job title pulled from the work experience entry.
        :paramtype job_title: str
        :keyword job_title_normalized: Mapped onto the EMSI job title taxonomy if a sufficiently close
         match exists.
        :paramtype job_title_normalized: str
        :keyword emsi_id: EMSI id of the normalised job title.
        :paramtype emsi_id: str
        :keyword management_level: Known values are: "None", "Low", "Mid", "Upper".
        :paramtype management_level: str or ~affinda.models.ManagementLevel
        :keyword classification:
        :paramtype classification:
         ~affinda.models.Components1TryetgSchemasResumedataPropertiesWorkexperienceItemsPropertiesOccupationPropertiesClassification
        """
        super(ResumeDataWorkExperienceItemOccupation, self).__init__(**kwargs)
        self.job_title = job_title
        self.job_title_normalized = job_title_normalized
        self.emsi_id = emsi_id
        self.management_level = management_level
        self.classification = classification


class ResumeRedact(Document):
    """ResumeRedact.

    All required parameters must be populated in order to send to Azure.

    :ivar extractor: Required. Constant filled by server.
    :vartype extractor: str
    :ivar meta: Required.
    :vartype meta: ~affinda.models.DocumentMeta
    :ivar error:
    :vartype error: ~affinda.models.DocumentError
    :ivar warnings:
    :vartype warnings: list[~affinda.models.DocumentWarning]
    :ivar data:
    :vartype data: ~affinda.models.ResumeRedactData
    """

    _validation = {
        "extractor": {"required": True},
        "meta": {"required": True},
    }

    _attribute_map = {
        "extractor": {"key": "extractor", "type": "str"},
        "meta": {"key": "meta", "type": "DocumentMeta"},
        "error": {"key": "error", "type": "DocumentError"},
        "warnings": {"key": "warnings", "type": "[DocumentWarning]"},
        "data": {"key": "data", "type": "ResumeRedactData"},
    }

    def __init__(
        self,
        *,
        meta: "_models.DocumentMeta",
        error: Optional["_models.DocumentError"] = None,
        warnings: Optional[List["_models.DocumentWarning"]] = None,
        data: Optional["_models.ResumeRedactData"] = None,
        **kwargs,
    ):
        """
        :keyword meta: Required.
        :paramtype meta: ~affinda.models.DocumentMeta
        :keyword error:
        :paramtype error: ~affinda.models.DocumentError
        :keyword warnings:
        :paramtype warnings: list[~affinda.models.DocumentWarning]
        :keyword data:
        :paramtype data: ~affinda.models.ResumeRedactData
        """
        super(ResumeRedact, self).__init__(meta=meta, error=error, warnings=warnings, **kwargs)
        self.extractor = "resume-redact"  # type: str
        self.data = data


class ResumeRedactData(msrest.serialization.Model):
    """ResumeRedactData.

    :ivar redacted_pdf: URL to download the redacted resume.
    :vartype redacted_pdf: str
    """

    _attribute_map = {
        "redacted_pdf": {"key": "redactedPdf", "type": "str"},
    }

    def __init__(self, *, redacted_pdf: Optional[str] = None, **kwargs):
        """
        :keyword redacted_pdf: URL to download the redacted resume.
        :paramtype redacted_pdf: str
        """
        super(ResumeRedactData, self).__init__(**kwargs)
        self.redacted_pdf = redacted_pdf


class ResumeSearch(msrest.serialization.Model):
    """ResumeSearch.

    :ivar count: Total number of results.
    :vartype count: int
    :ivar next: URL to request next page of results.
    :vartype next: str
    :ivar previous: URL to request previous page of results.
    :vartype previous: str
    :ivar parameters:
    :vartype parameters: ~affinda.models.ResumeSearchParameters
    :ivar results:
    :vartype results: list[~affinda.models.ResumeSearchResult]
    """

    _validation = {
        "count": {"minimum": 0},
    }

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
        "next": {"key": "next", "type": "str"},
        "previous": {"key": "previous", "type": "str"},
        "parameters": {"key": "parameters", "type": "ResumeSearchParameters"},
        "results": {"key": "results", "type": "[ResumeSearchResult]"},
    }

    def __init__(
        self,
        *,
        count: Optional[int] = None,
        next: Optional[str] = None,
        previous: Optional[str] = None,
        parameters: Optional["_models.ResumeSearchParameters"] = None,
        results: Optional[List["_models.ResumeSearchResult"]] = None,
        **kwargs,
    ):
        """
        :keyword count: Total number of results.
        :paramtype count: int
        :keyword next: URL to request next page of results.
        :paramtype next: str
        :keyword previous: URL to request previous page of results.
        :paramtype previous: str
        :keyword parameters:
        :paramtype parameters: ~affinda.models.ResumeSearchParameters
        :keyword results:
        :paramtype results: list[~affinda.models.ResumeSearchResult]
        """
        super(ResumeSearch, self).__init__(**kwargs)
        self.count = count
        self.next = next
        self.previous = previous
        self.parameters = parameters
        self.results = results


class ResumeSearchConfig(msrest.serialization.Model):
    """ResumeSearchConfig.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar allow_pdf_download:
    :vartype allow_pdf_download: bool
    :ivar max_results: Maximum number of results that can be returned. Setting to "null" means no
     limitation.
    :vartype max_results: int
    :ivar display_job_title:
    :vartype display_job_title: bool
    :ivar display_location:
    :vartype display_location: bool
    :ivar display_years_experience:
    :vartype display_years_experience: bool
    :ivar display_occupation_group:
    :vartype display_occupation_group: bool
    :ivar display_education:
    :vartype display_education: bool
    :ivar display_skills:
    :vartype display_skills: bool
    :ivar display_languages:
    :vartype display_languages: bool
    :ivar display_management_level:
    :vartype display_management_level: bool
    :ivar display_keywords:
    :vartype display_keywords: bool
    :ivar weight_job_title:
    :vartype weight_job_title: float
    :ivar weight_location:
    :vartype weight_location: float
    :ivar weight_years_experience:
    :vartype weight_years_experience: float
    :ivar weight_occupation_group:
    :vartype weight_occupation_group: float
    :ivar weight_education:
    :vartype weight_education: float
    :ivar weight_skills:
    :vartype weight_skills: float
    :ivar weight_languages:
    :vartype weight_languages: float
    :ivar weight_management_level:
    :vartype weight_management_level: float
    :ivar weight_keywords:
    :vartype weight_keywords: float
    :ivar indices: List of index names.
    :vartype indices: list[str]
    :ivar show_index_dropdown: Controls whether or not the index dropdown is displayed to the user.
    :vartype show_index_dropdown: bool
    :ivar search_tool_theme: Customize the theme of the embeded search tool.
    :vartype search_tool_theme: ~affinda.models.ResumeSearchConfigSearchToolTheme
    :ivar user_id: ID of the logged in user.
    :vartype user_id: int
    :ivar username: Username of the logged in user.
    :vartype username: str
    :ivar actions: A list of actions to show in the dropdown in the embedded search tool.
    :vartype actions: list[~affinda.models.SearchConfigAction]
    :ivar hide_toolbar: Hide the reset/import toolbar.
    :vartype hide_toolbar: bool
    :ivar hide_side_panel: Hide the entire side panel.
    :vartype hide_side_panel: bool
    :ivar custom_fields_config:
    :vartype custom_fields_config: list[~affinda.models.CustomFieldConfig]
    :ivar distance_unit: The unit of distance to use for location based searches. Known values are:
     "mi", "km".
    :vartype distance_unit: str or ~affinda.models.ResumeSearchConfigDistanceUnit
    """

    _validation = {
        "max_results": {"minimum": 1},
        "user_id": {"readonly": True, "minimum": 1},
        "username": {"readonly": True},
    }

    _attribute_map = {
        "allow_pdf_download": {"key": "allowPdfDownload", "type": "bool"},
        "max_results": {"key": "maxResults", "type": "int"},
        "display_job_title": {"key": "displayJobTitle", "type": "bool"},
        "display_location": {"key": "displayLocation", "type": "bool"},
        "display_years_experience": {"key": "displayYearsExperience", "type": "bool"},
        "display_occupation_group": {"key": "displayOccupationGroup", "type": "bool"},
        "display_education": {"key": "displayEducation", "type": "bool"},
        "display_skills": {"key": "displaySkills", "type": "bool"},
        "display_languages": {"key": "displayLanguages", "type": "bool"},
        "display_management_level": {"key": "displayManagementLevel", "type": "bool"},
        "display_keywords": {"key": "displayKeywords", "type": "bool"},
        "weight_job_title": {"key": "weightJobTitle", "type": "float"},
        "weight_location": {"key": "weightLocation", "type": "float"},
        "weight_years_experience": {"key": "weightYearsExperience", "type": "float"},
        "weight_occupation_group": {"key": "weightOccupationGroup", "type": "float"},
        "weight_education": {"key": "weightEducation", "type": "float"},
        "weight_skills": {"key": "weightSkills", "type": "float"},
        "weight_languages": {"key": "weightLanguages", "type": "float"},
        "weight_management_level": {"key": "weightManagementLevel", "type": "float"},
        "weight_keywords": {"key": "weightKeywords", "type": "float"},
        "indices": {"key": "indices", "type": "[str]"},
        "show_index_dropdown": {"key": "showIndexDropdown", "type": "bool"},
        "search_tool_theme": {
            "key": "searchToolTheme",
            "type": "ResumeSearchConfigSearchToolTheme",
        },
        "user_id": {"key": "userId", "type": "int"},
        "username": {"key": "username", "type": "str"},
        "actions": {"key": "actions", "type": "[SearchConfigAction]"},
        "hide_toolbar": {"key": "hideToolbar", "type": "bool"},
        "hide_side_panel": {"key": "hideSidePanel", "type": "bool"},
        "custom_fields_config": {"key": "customFieldsConfig", "type": "[CustomFieldConfig]"},
        "distance_unit": {"key": "distanceUnit", "type": "str"},
    }

    def __init__(
        self,
        *,
        allow_pdf_download: Optional[bool] = None,
        max_results: Optional[int] = None,
        display_job_title: Optional[bool] = None,
        display_location: Optional[bool] = None,
        display_years_experience: Optional[bool] = None,
        display_occupation_group: Optional[bool] = None,
        display_education: Optional[bool] = None,
        display_skills: Optional[bool] = None,
        display_languages: Optional[bool] = None,
        display_management_level: Optional[bool] = None,
        display_keywords: Optional[bool] = None,
        weight_job_title: Optional[float] = None,
        weight_location: Optional[float] = None,
        weight_years_experience: Optional[float] = None,
        weight_occupation_group: Optional[float] = None,
        weight_education: Optional[float] = None,
        weight_skills: Optional[float] = None,
        weight_languages: Optional[float] = None,
        weight_management_level: Optional[float] = None,
        weight_keywords: Optional[float] = None,
        indices: Optional[List[str]] = None,
        show_index_dropdown: Optional[bool] = None,
        search_tool_theme: Optional["_models.ResumeSearchConfigSearchToolTheme"] = None,
        actions: Optional[List["_models.SearchConfigAction"]] = None,
        hide_toolbar: Optional[bool] = None,
        hide_side_panel: Optional[bool] = None,
        custom_fields_config: Optional[List["_models.CustomFieldConfig"]] = None,
        distance_unit: Optional[Union[str, "_models.ResumeSearchConfigDistanceUnit"]] = None,
        **kwargs,
    ):
        """
        :keyword allow_pdf_download:
        :paramtype allow_pdf_download: bool
        :keyword max_results: Maximum number of results that can be returned. Setting to "null" means
         no limitation.
        :paramtype max_results: int
        :keyword display_job_title:
        :paramtype display_job_title: bool
        :keyword display_location:
        :paramtype display_location: bool
        :keyword display_years_experience:
        :paramtype display_years_experience: bool
        :keyword display_occupation_group:
        :paramtype display_occupation_group: bool
        :keyword display_education:
        :paramtype display_education: bool
        :keyword display_skills:
        :paramtype display_skills: bool
        :keyword display_languages:
        :paramtype display_languages: bool
        :keyword display_management_level:
        :paramtype display_management_level: bool
        :keyword display_keywords:
        :paramtype display_keywords: bool
        :keyword weight_job_title:
        :paramtype weight_job_title: float
        :keyword weight_location:
        :paramtype weight_location: float
        :keyword weight_years_experience:
        :paramtype weight_years_experience: float
        :keyword weight_occupation_group:
        :paramtype weight_occupation_group: float
        :keyword weight_education:
        :paramtype weight_education: float
        :keyword weight_skills:
        :paramtype weight_skills: float
        :keyword weight_languages:
        :paramtype weight_languages: float
        :keyword weight_management_level:
        :paramtype weight_management_level: float
        :keyword weight_keywords:
        :paramtype weight_keywords: float
        :keyword indices: List of index names.
        :paramtype indices: list[str]
        :keyword show_index_dropdown: Controls whether or not the index dropdown is displayed to the
         user.
        :paramtype show_index_dropdown: bool
        :keyword search_tool_theme: Customize the theme of the embeded search tool.
        :paramtype search_tool_theme: ~affinda.models.ResumeSearchConfigSearchToolTheme
        :keyword actions: A list of actions to show in the dropdown in the embedded search tool.
        :paramtype actions: list[~affinda.models.SearchConfigAction]
        :keyword hide_toolbar: Hide the reset/import toolbar.
        :paramtype hide_toolbar: bool
        :keyword hide_side_panel: Hide the entire side panel.
        :paramtype hide_side_panel: bool
        :keyword custom_fields_config:
        :paramtype custom_fields_config: list[~affinda.models.CustomFieldConfig]
        :keyword distance_unit: The unit of distance to use for location based searches. Known values
         are: "mi", "km".
        :paramtype distance_unit: str or ~affinda.models.ResumeSearchConfigDistanceUnit
        """
        super(ResumeSearchConfig, self).__init__(**kwargs)
        self.allow_pdf_download = allow_pdf_download
        self.max_results = max_results
        self.display_job_title = display_job_title
        self.display_location = display_location
        self.display_years_experience = display_years_experience
        self.display_occupation_group = display_occupation_group
        self.display_education = display_education
        self.display_skills = display_skills
        self.display_languages = display_languages
        self.display_management_level = display_management_level
        self.display_keywords = display_keywords
        self.weight_job_title = weight_job_title
        self.weight_location = weight_location
        self.weight_years_experience = weight_years_experience
        self.weight_occupation_group = weight_occupation_group
        self.weight_education = weight_education
        self.weight_skills = weight_skills
        self.weight_languages = weight_languages
        self.weight_management_level = weight_management_level
        self.weight_keywords = weight_keywords
        self.indices = indices
        self.show_index_dropdown = show_index_dropdown
        self.search_tool_theme = search_tool_theme
        self.user_id = None
        self.username = None
        self.actions = actions
        self.hide_toolbar = hide_toolbar
        self.hide_side_panel = hide_side_panel
        self.custom_fields_config = custom_fields_config
        self.distance_unit = distance_unit


class ResumeSearchConfigSearchToolTheme(ThemeConfig):
    """Customize the theme of the embeded search tool.

    :ivar palette:
    :vartype palette: ~affinda.models.ThemeConfigPalette
    :ivar typography:
    :vartype typography: ~affinda.models.ThemeConfigTypography
    :ivar border_radius:
    :vartype border_radius: float
    :ivar font_url:
    :vartype font_url: str
    """

    _attribute_map = {
        "palette": {"key": "palette", "type": "ThemeConfigPalette"},
        "typography": {"key": "typography", "type": "ThemeConfigTypography"},
        "border_radius": {"key": "borderRadius", "type": "float"},
        "font_url": {"key": "fontUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        palette: Optional["_models.ThemeConfigPalette"] = None,
        typography: Optional["_models.ThemeConfigTypography"] = None,
        border_radius: Optional[float] = None,
        font_url: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword palette:
        :paramtype palette: ~affinda.models.ThemeConfigPalette
        :keyword typography:
        :paramtype typography: ~affinda.models.ThemeConfigTypography
        :keyword border_radius:
        :paramtype border_radius: float
        :keyword font_url:
        :paramtype font_url: str
        """
        super(ResumeSearchConfigSearchToolTheme, self).__init__(
            palette=palette,
            typography=typography,
            border_radius=border_radius,
            font_url=font_url,
            **kwargs,
        )


class ResumeSearchDetail(msrest.serialization.Model):
    """ResumeSearchDetail.

    :ivar job_title:
    :vartype job_title: ~affinda.models.ResumeSearchDetailJobTitle
    :ivar location:
    :vartype location: ~affinda.models.ResumeSearchDetailLocation
    :ivar education:
    :vartype education: ~affinda.models.ResumeSearchDetailEducation
    :ivar skills:
    :vartype skills: ~affinda.models.ResumeSearchDetailSkills
    :ivar experience:
    :vartype experience: ~affinda.models.ResumeSearchDetailExperience
    :ivar occupation_group:
    :vartype occupation_group: ~affinda.models.ResumeSearchDetailOccupationGroup
    :ivar languages:
    :vartype languages: ~affinda.models.ResumeSearchDetailLanguages
    :ivar management_level:
    :vartype management_level: ~affinda.models.ResumeSearchDetailManagementLevel
    :ivar search_expression:
    :vartype search_expression: ~affinda.models.ResumeSearchDetailSearchExpression
    """

    _attribute_map = {
        "job_title": {"key": "jobTitle", "type": "ResumeSearchDetailJobTitle"},
        "location": {"key": "location", "type": "ResumeSearchDetailLocation"},
        "education": {"key": "education", "type": "ResumeSearchDetailEducation"},
        "skills": {"key": "skills", "type": "ResumeSearchDetailSkills"},
        "experience": {"key": "experience", "type": "ResumeSearchDetailExperience"},
        "occupation_group": {
            "key": "occupationGroup",
            "type": "ResumeSearchDetailOccupationGroup",
        },
        "languages": {"key": "languages", "type": "ResumeSearchDetailLanguages"},
        "management_level": {
            "key": "managementLevel",
            "type": "ResumeSearchDetailManagementLevel",
        },
        "search_expression": {
            "key": "searchExpression",
            "type": "ResumeSearchDetailSearchExpression",
        },
    }

    def __init__(
        self,
        *,
        job_title: Optional["_models.ResumeSearchDetailJobTitle"] = None,
        location: Optional["_models.ResumeSearchDetailLocation"] = None,
        education: Optional["_models.ResumeSearchDetailEducation"] = None,
        skills: Optional["_models.ResumeSearchDetailSkills"] = None,
        experience: Optional["_models.ResumeSearchDetailExperience"] = None,
        occupation_group: Optional["_models.ResumeSearchDetailOccupationGroup"] = None,
        languages: Optional["_models.ResumeSearchDetailLanguages"] = None,
        management_level: Optional["_models.ResumeSearchDetailManagementLevel"] = None,
        search_expression: Optional["_models.ResumeSearchDetailSearchExpression"] = None,
        **kwargs,
    ):
        """
        :keyword job_title:
        :paramtype job_title: ~affinda.models.ResumeSearchDetailJobTitle
        :keyword location:
        :paramtype location: ~affinda.models.ResumeSearchDetailLocation
        :keyword education:
        :paramtype education: ~affinda.models.ResumeSearchDetailEducation
        :keyword skills:
        :paramtype skills: ~affinda.models.ResumeSearchDetailSkills
        :keyword experience:
        :paramtype experience: ~affinda.models.ResumeSearchDetailExperience
        :keyword occupation_group:
        :paramtype occupation_group: ~affinda.models.ResumeSearchDetailOccupationGroup
        :keyword languages:
        :paramtype languages: ~affinda.models.ResumeSearchDetailLanguages
        :keyword management_level:
        :paramtype management_level: ~affinda.models.ResumeSearchDetailManagementLevel
        :keyword search_expression:
        :paramtype search_expression: ~affinda.models.ResumeSearchDetailSearchExpression
        """
        super(ResumeSearchDetail, self).__init__(**kwargs)
        self.job_title = job_title
        self.location = location
        self.education = education
        self.skills = skills
        self.experience = experience
        self.occupation_group = occupation_group
        self.languages = languages
        self.management_level = management_level
        self.search_expression = search_expression


class ResumeSearchDetailEducation(msrest.serialization.Model):
    """ResumeSearchDetailEducation.

    :ivar missing:
    :vartype missing: ~affinda.models.ResumeSearchDetailEducationMissing
    :ivar value:
    :vartype value: list[~affinda.models.ResumeSearchDetailEducationValueItem]
    """

    _attribute_map = {
        "missing": {"key": "missing", "type": "ResumeSearchDetailEducationMissing"},
        "value": {"key": "value", "type": "[ResumeSearchDetailEducationValueItem]"},
    }

    def __init__(
        self,
        *,
        missing: Optional["_models.ResumeSearchDetailEducationMissing"] = None,
        value: Optional[List["_models.ResumeSearchDetailEducationValueItem"]] = None,
        **kwargs,
    ):
        """
        :keyword missing:
        :paramtype missing: ~affinda.models.ResumeSearchDetailEducationMissing
        :keyword value:
        :paramtype value: list[~affinda.models.ResumeSearchDetailEducationValueItem]
        """
        super(ResumeSearchDetailEducation, self).__init__(**kwargs)
        self.missing = missing
        self.value = value


class ResumeSearchDetailEducationMissing(msrest.serialization.Model):
    """ResumeSearchDetailEducationMissing.

    :ivar degrees:
    :vartype degrees: list[str]
    :ivar highest_degree_types:
    :vartype highest_degree_types: list[str]
    :ivar institutions:
    :vartype institutions: list[str]
    :ivar current_student:
    :vartype current_student: bool
    :ivar recent_graduate:
    :vartype recent_graduate: bool
    """

    _attribute_map = {
        "degrees": {"key": "degrees", "type": "[str]"},
        "highest_degree_types": {"key": "highestDegreeTypes", "type": "[str]"},
        "institutions": {"key": "institutions", "type": "[str]"},
        "current_student": {"key": "currentStudent", "type": "bool"},
        "recent_graduate": {"key": "recentGraduate", "type": "bool"},
    }

    def __init__(
        self,
        *,
        degrees: Optional[List[str]] = None,
        highest_degree_types: Optional[List[str]] = None,
        institutions: Optional[List[str]] = None,
        current_student: Optional[bool] = None,
        recent_graduate: Optional[bool] = None,
        **kwargs,
    ):
        """
        :keyword degrees:
        :paramtype degrees: list[str]
        :keyword highest_degree_types:
        :paramtype highest_degree_types: list[str]
        :keyword institutions:
        :paramtype institutions: list[str]
        :keyword current_student:
        :paramtype current_student: bool
        :keyword recent_graduate:
        :paramtype recent_graduate: bool
        """
        super(ResumeSearchDetailEducationMissing, self).__init__(**kwargs)
        self.degrees = degrees
        self.highest_degree_types = highest_degree_types
        self.institutions = institutions
        self.current_student = current_student
        self.recent_graduate = recent_graduate


class ResumeSearchDetailEducationValueItem(
    Education,
    ComponentsSxu0N3SchemasResumesearchdetailPropertiesEducationPropertiesValueItemsAllof1,
):
    """ResumeSearchDetailEducationValueItem.

    :ivar match:
    :vartype match: bool
    :ivar id:
    :vartype id: int
    :ivar organization:
    :vartype organization: str
    :ivar accreditation:
    :vartype accreditation: ~affinda.models.Accreditation
    :ivar grade:
    :vartype grade: ~affinda.models.EducationGrade
    :ivar location:
    :vartype location: ~affinda.models.Location
    :ivar dates:
    :vartype dates: ~affinda.models.EducationDates
    """

    _validation = {
        "id": {"minimum": 1},
    }

    _attribute_map = {
        "match": {"key": "match", "type": "bool"},
        "id": {"key": "id", "type": "int"},
        "organization": {"key": "organization", "type": "str"},
        "accreditation": {"key": "accreditation", "type": "Accreditation"},
        "grade": {"key": "grade", "type": "EducationGrade"},
        "location": {"key": "location", "type": "Location"},
        "dates": {"key": "dates", "type": "EducationDates"},
    }

    def __init__(
        self,
        *,
        match: Optional[bool] = None,
        id: Optional[int] = None,
        organization: Optional[str] = None,
        accreditation: Optional["_models.Accreditation"] = None,
        grade: Optional["_models.EducationGrade"] = None,
        location: Optional["_models.Location"] = None,
        dates: Optional["_models.EducationDates"] = None,
        **kwargs,
    ):
        """
        :keyword match:
        :paramtype match: bool
        :keyword id:
        :paramtype id: int
        :keyword organization:
        :paramtype organization: str
        :keyword accreditation:
        :paramtype accreditation: ~affinda.models.Accreditation
        :keyword grade:
        :paramtype grade: ~affinda.models.EducationGrade
        :keyword location:
        :paramtype location: ~affinda.models.Location
        :keyword dates:
        :paramtype dates: ~affinda.models.EducationDates
        """
        super(ResumeSearchDetailEducationValueItem, self).__init__(
            id=id,
            organization=organization,
            accreditation=accreditation,
            grade=grade,
            location=location,
            dates=dates,
            match=match,
            **kwargs,
        )
        self.match = match
        self.id = id
        self.organization = organization
        self.accreditation = accreditation
        self.grade = grade
        self.location = location
        self.dates = dates


class ResumeSearchDetailExperience(msrest.serialization.Model):
    """ResumeSearchDetailExperience.

    :ivar years:
    :vartype years: int
    :ivar match:
    :vartype match: bool
    """

    _validation = {
        "years": {"minimum": 0},
    }

    _attribute_map = {
        "years": {"key": "years", "type": "int"},
        "match": {"key": "match", "type": "bool"},
    }

    def __init__(self, *, years: Optional[int] = None, match: Optional[bool] = None, **kwargs):
        """
        :keyword years:
        :paramtype years: int
        :keyword match:
        :paramtype match: bool
        """
        super(ResumeSearchDetailExperience, self).__init__(**kwargs)
        self.years = years
        self.match = match


class ResumeSearchDetailJobTitle(msrest.serialization.Model):
    """ResumeSearchDetailJobTitle.

    :ivar missing:
    :vartype missing: list[str]
    :ivar value:
    :vartype value: list[~affinda.models.ResumeSearchDetailJobTitleValueItem]
    """

    _attribute_map = {
        "missing": {"key": "missing", "type": "[str]"},
        "value": {"key": "value", "type": "[ResumeSearchDetailJobTitleValueItem]"},
    }

    def __init__(
        self,
        *,
        missing: Optional[List[str]] = None,
        value: Optional[List["_models.ResumeSearchDetailJobTitleValueItem"]] = None,
        **kwargs,
    ):
        """
        :keyword missing:
        :paramtype missing: list[str]
        :keyword value:
        :paramtype value: list[~affinda.models.ResumeSearchDetailJobTitleValueItem]
        """
        super(ResumeSearchDetailJobTitle, self).__init__(**kwargs)
        self.missing = missing
        self.value = value


class ResumeSearchDetailJobTitleValueItem(msrest.serialization.Model):
    """ResumeSearchDetailJobTitleValueItem.

    :ivar name:
    :vartype name: str
    :ivar start_date:
    :vartype start_date: str
    :ivar end_date:
    :vartype end_date: str
    :ivar company_name:
    :vartype company_name: str
    :ivar match:
    :vartype match: bool
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "start_date": {"key": "startDate", "type": "str"},
        "end_date": {"key": "endDate", "type": "str"},
        "company_name": {"key": "companyName", "type": "str"},
        "match": {"key": "match", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        start_date: Optional[str] = None,
        end_date: Optional[str] = None,
        company_name: Optional[str] = None,
        match: Optional[bool] = None,
        **kwargs,
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword start_date:
        :paramtype start_date: str
        :keyword end_date:
        :paramtype end_date: str
        :keyword company_name:
        :paramtype company_name: str
        :keyword match:
        :paramtype match: bool
        """
        super(ResumeSearchDetailJobTitleValueItem, self).__init__(**kwargs)
        self.name = name
        self.start_date = start_date
        self.end_date = end_date
        self.company_name = company_name
        self.match = match


class ResumeSearchDetailLanguages(msrest.serialization.Model):
    """ResumeSearchDetailLanguages.

    :ivar missing:
    :vartype missing: list[~affinda.models.ResumeSearchParametersSkill]
    :ivar value:
    :vartype value: list[~affinda.models.ResumeSearchDetailLanguagesValueItem]
    """

    _attribute_map = {
        "missing": {"key": "missing", "type": "[ResumeSearchParametersSkill]"},
        "value": {"key": "value", "type": "[ResumeSearchDetailLanguagesValueItem]"},
    }

    def __init__(
        self,
        *,
        missing: Optional[List["_models.ResumeSearchParametersSkill"]] = None,
        value: Optional[List["_models.ResumeSearchDetailLanguagesValueItem"]] = None,
        **kwargs,
    ):
        """
        :keyword missing:
        :paramtype missing: list[~affinda.models.ResumeSearchParametersSkill]
        :keyword value:
        :paramtype value: list[~affinda.models.ResumeSearchDetailLanguagesValueItem]
        """
        super(ResumeSearchDetailLanguages, self).__init__(**kwargs)
        self.missing = missing
        self.value = value


class ResumeSkill(msrest.serialization.Model):
    """ResumeSkill.

    :ivar name:
    :vartype name: str
    :ivar last_used:
    :vartype last_used: str
    :ivar number_of_months:
    :vartype number_of_months: int
    :ivar type:
    :vartype type: str
    :ivar sources:
    :vartype sources: list[~affinda.models.ResumeSkillSourcesItem]
    """

    _validation = {
        "number_of_months": {"minimum": 0},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "last_used": {"key": "lastUsed", "type": "str"},
        "number_of_months": {"key": "numberOfMonths", "type": "int"},
        "type": {"key": "type", "type": "str"},
        "sources": {"key": "sources", "type": "[ResumeSkillSourcesItem]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        last_used: Optional[str] = None,
        number_of_months: Optional[int] = None,
        type: Optional[str] = None,
        sources: Optional[List["_models.ResumeSkillSourcesItem"]] = None,
        **kwargs,
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword last_used:
        :paramtype last_used: str
        :keyword number_of_months:
        :paramtype number_of_months: int
        :keyword type:
        :paramtype type: str
        :keyword sources:
        :paramtype sources: list[~affinda.models.ResumeSkillSourcesItem]
        """
        super(ResumeSkill, self).__init__(**kwargs)
        self.name = name
        self.last_used = last_used
        self.number_of_months = number_of_months
        self.type = type
        self.sources = sources


class ResumeSearchDetailLanguagesValueItem(
    ResumeSkill,
    Components159Ji55SchemasResumesearchdetailPropertiesLanguagesPropertiesValueItemsAllof1,
):
    """ResumeSearchDetailLanguagesValueItem.

    :ivar match:
    :vartype match: bool
    :ivar name:
    :vartype name: str
    :ivar last_used:
    :vartype last_used: str
    :ivar number_of_months:
    :vartype number_of_months: int
    :ivar type:
    :vartype type: str
    :ivar sources:
    :vartype sources: list[~affinda.models.ResumeSkillSourcesItem]
    """

    _validation = {
        "number_of_months": {"minimum": 0},
    }

    _attribute_map = {
        "match": {"key": "match", "type": "bool"},
        "name": {"key": "name", "type": "str"},
        "last_used": {"key": "lastUsed", "type": "str"},
        "number_of_months": {"key": "numberOfMonths", "type": "int"},
        "type": {"key": "type", "type": "str"},
        "sources": {"key": "sources", "type": "[ResumeSkillSourcesItem]"},
    }

    def __init__(
        self,
        *,
        match: Optional[bool] = None,
        name: Optional[str] = None,
        last_used: Optional[str] = None,
        number_of_months: Optional[int] = None,
        type: Optional[str] = None,
        sources: Optional[List["_models.ResumeSkillSourcesItem"]] = None,
        **kwargs,
    ):
        """
        :keyword match:
        :paramtype match: bool
        :keyword name:
        :paramtype name: str
        :keyword last_used:
        :paramtype last_used: str
        :keyword number_of_months:
        :paramtype number_of_months: int
        :keyword type:
        :paramtype type: str
        :keyword sources:
        :paramtype sources: list[~affinda.models.ResumeSkillSourcesItem]
        """
        super(ResumeSearchDetailLanguagesValueItem, self).__init__(
            name=name,
            last_used=last_used,
            number_of_months=number_of_months,
            type=type,
            sources=sources,
            match=match,
            **kwargs,
        )
        self.match = match
        self.name = name
        self.last_used = last_used
        self.number_of_months = number_of_months
        self.type = type
        self.sources = sources


class ResumeSearchDetailLocation(msrest.serialization.Model):
    """ResumeSearchDetailLocation.

    :ivar missing:
    :vartype missing: list[~affinda.models.ResumeSearchParametersLocation]
    :ivar value:
    :vartype value: ~affinda.models.ResumeSearchDetailLocationValue
    """

    _attribute_map = {
        "missing": {"key": "missing", "type": "[ResumeSearchParametersLocation]"},
        "value": {"key": "value", "type": "ResumeSearchDetailLocationValue"},
    }

    def __init__(
        self,
        *,
        missing: Optional[List["_models.ResumeSearchParametersLocation"]] = None,
        value: Optional["_models.ResumeSearchDetailLocationValue"] = None,
        **kwargs,
    ):
        """
        :keyword missing:
        :paramtype missing: list[~affinda.models.ResumeSearchParametersLocation]
        :keyword value:
        :paramtype value: ~affinda.models.ResumeSearchDetailLocationValue
        """
        super(ResumeSearchDetailLocation, self).__init__(**kwargs)
        self.missing = missing
        self.value = value


class ResumeSearchDetailLocationValue(
    Location, ComponentsN9ShogSchemasResumesearchdetailPropertiesLocationPropertiesValueAllof1
):
    """ResumeSearchDetailLocationValue.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar match:
    :vartype match: bool
    :ivar formatted:
    :vartype formatted: str
    :ivar postal_code:
    :vartype postal_code: str
    :ivar state:
    :vartype state: str
    :ivar state_code:
    :vartype state_code: str
    :ivar country:
    :vartype country: str
    :ivar country_code: Two letter country code (ISO 3166-1 alpha-2).
    :vartype country_code: str
    :ivar raw_input: Required.
    :vartype raw_input: str
    :ivar street_number:
    :vartype street_number: str
    :ivar street:
    :vartype street: str
    :ivar apartment_number:
    :vartype apartment_number: str
    :ivar city:
    :vartype city: str
    :ivar latitude:
    :vartype latitude: float
    :ivar longitude:
    :vartype longitude: float
    :ivar po_box:
    :vartype po_box: str
    """

    _validation = {
        "formatted": {"readonly": True},
        "postal_code": {"readonly": True},
        "state": {"readonly": True},
        "state_code": {"readonly": True},
        "country": {"readonly": True},
        "country_code": {"readonly": True},
        "raw_input": {"required": True},
        "street_number": {"readonly": True},
        "street": {"readonly": True},
        "apartment_number": {"readonly": True},
        "city": {"readonly": True},
        "latitude": {"readonly": True},
        "longitude": {"readonly": True},
        "po_box": {"readonly": True},
    }

    _attribute_map = {
        "match": {"key": "match", "type": "bool"},
        "formatted": {"key": "formatted", "type": "str"},
        "postal_code": {"key": "postalCode", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "state_code": {"key": "stateCode", "type": "str"},
        "country": {"key": "country", "type": "str"},
        "country_code": {"key": "countryCode", "type": "str"},
        "raw_input": {"key": "rawInput", "type": "str"},
        "street_number": {"key": "streetNumber", "type": "str"},
        "street": {"key": "street", "type": "str"},
        "apartment_number": {"key": "apartmentNumber", "type": "str"},
        "city": {"key": "city", "type": "str"},
        "latitude": {"key": "latitude", "type": "float"},
        "longitude": {"key": "longitude", "type": "float"},
        "po_box": {"key": "poBox", "type": "str"},
    }

    def __init__(self, *, raw_input: str, match: Optional[bool] = None, **kwargs):
        """
        :keyword match:
        :paramtype match: bool
        :keyword raw_input: Required.
        :paramtype raw_input: str
        """
        super(ResumeSearchDetailLocationValue, self).__init__(
            raw_input=raw_input, match=match, **kwargs
        )
        self.match = match
        self.formatted = None
        self.postal_code = None
        self.state = None
        self.state_code = None
        self.country = None
        self.country_code = None
        self.raw_input = raw_input
        self.street_number = None
        self.street = None
        self.apartment_number = None
        self.city = None
        self.latitude = None
        self.longitude = None
        self.po_box = None


class ResumeSearchDetailManagementLevel(msrest.serialization.Model):
    """ResumeSearchDetailManagementLevel.

    :ivar level: Known values are: "None", "Low", "Mid", "Upper".
    :vartype level: str or ~affinda.models.ManagementLevel
    :ivar match:
    :vartype match: bool
    """

    _attribute_map = {
        "level": {"key": "level", "type": "str"},
        "match": {"key": "match", "type": "bool"},
    }

    def __init__(
        self,
        *,
        level: Optional[Union[str, "_models.ManagementLevel"]] = None,
        match: Optional[bool] = None,
        **kwargs,
    ):
        """
        :keyword level: Known values are: "None", "Low", "Mid", "Upper".
        :paramtype level: str or ~affinda.models.ManagementLevel
        :keyword match:
        :paramtype match: bool
        """
        super(ResumeSearchDetailManagementLevel, self).__init__(**kwargs)
        self.level = level
        self.match = match


class ResumeSearchDetailOccupationGroup(msrest.serialization.Model):
    """ResumeSearchDetailOccupationGroup.

    :ivar missing:
    :vartype missing: list[int]
    :ivar value:
    :vartype value: list[~affinda.models.OccupationGroupSearchResult]
    """

    _attribute_map = {
        "missing": {"key": "missing", "type": "[int]"},
        "value": {"key": "value", "type": "[OccupationGroupSearchResult]"},
    }

    def __init__(
        self,
        *,
        missing: Optional[List[int]] = None,
        value: Optional[List["_models.OccupationGroupSearchResult"]] = None,
        **kwargs,
    ):
        """
        :keyword missing:
        :paramtype missing: list[int]
        :keyword value:
        :paramtype value: list[~affinda.models.OccupationGroupSearchResult]
        """
        super(ResumeSearchDetailOccupationGroup, self).__init__(**kwargs)
        self.missing = missing
        self.value = value


class ResumeSearchDetailSearchExpression(msrest.serialization.Model):
    """ResumeSearchDetailSearchExpression.

    :ivar missing:
    :vartype missing: list[str]
    :ivar value:
    :vartype value: list[str]
    """

    _attribute_map = {
        "missing": {"key": "missing", "type": "[str]"},
        "value": {"key": "value", "type": "[str]"},
    }

    def __init__(
        self, *, missing: Optional[List[str]] = None, value: Optional[List[str]] = None, **kwargs
    ):
        """
        :keyword missing:
        :paramtype missing: list[str]
        :keyword value:
        :paramtype value: list[str]
        """
        super(ResumeSearchDetailSearchExpression, self).__init__(**kwargs)
        self.missing = missing
        self.value = value


class ResumeSearchDetailSkills(msrest.serialization.Model):
    """ResumeSearchDetailSkills.

    :ivar missing:
    :vartype missing: list[~affinda.models.ResumeSearchParametersSkill]
    :ivar value:
    :vartype value: list[~affinda.models.ResumeSearchDetailSkillsValueItem]
    """

    _attribute_map = {
        "missing": {"key": "missing", "type": "[ResumeSearchParametersSkill]"},
        "value": {"key": "value", "type": "[ResumeSearchDetailSkillsValueItem]"},
    }

    def __init__(
        self,
        *,
        missing: Optional[List["_models.ResumeSearchParametersSkill"]] = None,
        value: Optional[List["_models.ResumeSearchDetailSkillsValueItem"]] = None,
        **kwargs,
    ):
        """
        :keyword missing:
        :paramtype missing: list[~affinda.models.ResumeSearchParametersSkill]
        :keyword value:
        :paramtype value: list[~affinda.models.ResumeSearchDetailSkillsValueItem]
        """
        super(ResumeSearchDetailSkills, self).__init__(**kwargs)
        self.missing = missing
        self.value = value


class ResumeSearchDetailSkillsValueItem(
    ResumeSkill,
    ComponentsH65QjbSchemasResumesearchdetailPropertiesSkillsPropertiesValueItemsAllof1,
):
    """ResumeSearchDetailSkillsValueItem.

    :ivar match:
    :vartype match: bool
    :ivar name:
    :vartype name: str
    :ivar last_used:
    :vartype last_used: str
    :ivar number_of_months:
    :vartype number_of_months: int
    :ivar type:
    :vartype type: str
    :ivar sources:
    :vartype sources: list[~affinda.models.ResumeSkillSourcesItem]
    """

    _validation = {
        "number_of_months": {"minimum": 0},
    }

    _attribute_map = {
        "match": {"key": "match", "type": "bool"},
        "name": {"key": "name", "type": "str"},
        "last_used": {"key": "lastUsed", "type": "str"},
        "number_of_months": {"key": "numberOfMonths", "type": "int"},
        "type": {"key": "type", "type": "str"},
        "sources": {"key": "sources", "type": "[ResumeSkillSourcesItem]"},
    }

    def __init__(
        self,
        *,
        match: Optional[bool] = None,
        name: Optional[str] = None,
        last_used: Optional[str] = None,
        number_of_months: Optional[int] = None,
        type: Optional[str] = None,
        sources: Optional[List["_models.ResumeSkillSourcesItem"]] = None,
        **kwargs,
    ):
        """
        :keyword match:
        :paramtype match: bool
        :keyword name:
        :paramtype name: str
        :keyword last_used:
        :paramtype last_used: str
        :keyword number_of_months:
        :paramtype number_of_months: int
        :keyword type:
        :paramtype type: str
        :keyword sources:
        :paramtype sources: list[~affinda.models.ResumeSkillSourcesItem]
        """
        super(ResumeSearchDetailSkillsValueItem, self).__init__(
            name=name,
            last_used=last_used,
            number_of_months=number_of_months,
            type=type,
            sources=sources,
            match=match,
            **kwargs,
        )
        self.match = match
        self.name = name
        self.last_used = last_used
        self.number_of_months = number_of_months
        self.type = type
        self.sources = sources


class ResumeSearchEmbed(msrest.serialization.Model):
    """ResumeSearchEmbed.

    :ivar url: The signed URL for the embedable search tool.
    :vartype url: str
    """

    _attribute_map = {
        "url": {"key": "url", "type": "str"},
    }

    def __init__(self, *, url: Optional[str] = None, **kwargs):
        """
        :keyword url: The signed URL for the embedable search tool.
        :paramtype url: str
        """
        super(ResumeSearchEmbed, self).__init__(**kwargs)
        self.url = url


class ResumeSearchMatch(msrest.serialization.Model):
    """ResumeSearchMatch.

    :ivar score: The matching score between the provided resume and job description.
    :vartype score: float
    :ivar details:
    :vartype details: ~affinda.models.ResumeSearchMatchDetails
    """

    _validation = {
        "score": {"maximum": 1, "minimum": 0},
    }

    _attribute_map = {
        "score": {"key": "score", "type": "float"},
        "details": {"key": "details", "type": "ResumeSearchMatchDetails"},
    }

    def __init__(
        self,
        *,
        score: Optional[float] = None,
        details: Optional["_models.ResumeSearchMatchDetails"] = None,
        **kwargs,
    ):
        """
        :keyword score: The matching score between the provided resume and job description.
        :paramtype score: float
        :keyword details:
        :paramtype details: ~affinda.models.ResumeSearchMatchDetails
        """
        super(ResumeSearchMatch, self).__init__(**kwargs)
        self.score = score
        self.details = details


class ResumeSearchMatchDetails(msrest.serialization.Model):
    """ResumeSearchMatchDetails.

    :ivar job_title:
    :vartype job_title: ~affinda.models.JobTitleSearchScoreComponent
    :ivar management_level:
    :vartype management_level: ~affinda.models.ManagementLevelSearchScoreComponent
    :ivar experience:
    :vartype experience: ~affinda.models.ExperienceSearchScoreComponent
    :ivar skills:
    :vartype skills: ~affinda.models.SkillsSearchScoreComponent
    :ivar languages:
    :vartype languages: ~affinda.models.LanguagesSearchScoreComponent
    :ivar location:
    :vartype location: ~affinda.models.LocationSearchScoreComponent
    :ivar education:
    :vartype education: ~affinda.models.EducationSearchScoreComponent
    :ivar occupation_group:
    :vartype occupation_group: ~affinda.models.OccupationGroupSearchScoreComponent
    :ivar search_expression:
    :vartype search_expression: ~affinda.models.SearchExpressionSearchScoreComponent
    """

    _attribute_map = {
        "job_title": {"key": "jobTitle", "type": "JobTitleSearchScoreComponent"},
        "management_level": {
            "key": "managementLevel",
            "type": "ManagementLevelSearchScoreComponent",
        },
        "experience": {"key": "experience", "type": "ExperienceSearchScoreComponent"},
        "skills": {"key": "skills", "type": "SkillsSearchScoreComponent"},
        "languages": {"key": "languages", "type": "LanguagesSearchScoreComponent"},
        "location": {"key": "location", "type": "LocationSearchScoreComponent"},
        "education": {"key": "education", "type": "EducationSearchScoreComponent"},
        "occupation_group": {
            "key": "occupationGroup",
            "type": "OccupationGroupSearchScoreComponent",
        },
        "search_expression": {
            "key": "searchExpression",
            "type": "SearchExpressionSearchScoreComponent",
        },
    }

    def __init__(
        self,
        *,
        job_title: Optional["_models.JobTitleSearchScoreComponent"] = None,
        management_level: Optional["_models.ManagementLevelSearchScoreComponent"] = None,
        experience: Optional["_models.ExperienceSearchScoreComponent"] = None,
        skills: Optional["_models.SkillsSearchScoreComponent"] = None,
        languages: Optional["_models.LanguagesSearchScoreComponent"] = None,
        location: Optional["_models.LocationSearchScoreComponent"] = None,
        education: Optional["_models.EducationSearchScoreComponent"] = None,
        occupation_group: Optional["_models.OccupationGroupSearchScoreComponent"] = None,
        search_expression: Optional["_models.SearchExpressionSearchScoreComponent"] = None,
        **kwargs,
    ):
        """
        :keyword job_title:
        :paramtype job_title: ~affinda.models.JobTitleSearchScoreComponent
        :keyword management_level:
        :paramtype management_level: ~affinda.models.ManagementLevelSearchScoreComponent
        :keyword experience:
        :paramtype experience: ~affinda.models.ExperienceSearchScoreComponent
        :keyword skills:
        :paramtype skills: ~affinda.models.SkillsSearchScoreComponent
        :keyword languages:
        :paramtype languages: ~affinda.models.LanguagesSearchScoreComponent
        :keyword location:
        :paramtype location: ~affinda.models.LocationSearchScoreComponent
        :keyword education:
        :paramtype education: ~affinda.models.EducationSearchScoreComponent
        :keyword occupation_group:
        :paramtype occupation_group: ~affinda.models.OccupationGroupSearchScoreComponent
        :keyword search_expression:
        :paramtype search_expression: ~affinda.models.SearchExpressionSearchScoreComponent
        """
        super(ResumeSearchMatchDetails, self).__init__(**kwargs)
        self.job_title = job_title
        self.management_level = management_level
        self.experience = experience
        self.skills = skills
        self.languages = languages
        self.location = location
        self.education = education
        self.occupation_group = occupation_group
        self.search_expression = search_expression


class ResumeSearchParameters(msrest.serialization.Model):
    """ResumeSearchParameters.

    All required parameters must be populated in order to send to Azure.

    :ivar indices: Required.
    :vartype indices: list[str]
    :ivar job_description: A random string that uniquely identify the resource.
    :vartype job_description: str
    :ivar resume: A random string that uniquely identify the resource.
    :vartype resume: str
    :ivar job_titles:
    :vartype job_titles: list[str]
    :ivar job_titles_current_only: Search only through the canditate's current job.
    :vartype job_titles_current_only: bool
    :ivar job_titles_required:
    :vartype job_titles_required: bool
    :ivar job_titles_weight:
    :vartype job_titles_weight: float
    :ivar years_experience_min: Minimum years of total work experience.
    :vartype years_experience_min: int
    :ivar years_experience_max: Maximum years of total work experience.
    :vartype years_experience_max: int
    :ivar years_experience_required:
    :vartype years_experience_required: bool
    :ivar years_experience_weight:
    :vartype years_experience_weight: float
    :ivar locations: Search by location name or by coordinates.
    :vartype locations: list[~affinda.models.ResumeSearchParametersLocation]
    :ivar locations_weight:
    :vartype locations_weight: float
    :ivar locations_required:
    :vartype locations_required: bool
    :ivar skills:
    :vartype skills: list[~affinda.models.ResumeSearchParametersSkill]
    :ivar skills_weight:
    :vartype skills_weight: float
    :ivar languages:
    :vartype languages: list[~affinda.models.ResumeSearchParametersSkill]
    :ivar languages_weight:
    :vartype languages_weight: float
    :ivar institutions:
    :vartype institutions: list[str]
    :ivar institutions_required:
    :vartype institutions_required: bool
    :ivar degrees:
    :vartype degrees: list[str]
    :ivar degrees_required:
    :vartype degrees_required: bool
    :ivar highest_degree_types:
    :vartype highest_degree_types: list[str or ~affinda.models.EducationLevel]
    :ivar highest_degree_types_required:
    :vartype highest_degree_types_required: bool
    :ivar is_current_student: Search for student canditates.
    :vartype is_current_student: bool
    :ivar is_current_student_required:
    :vartype is_current_student_required: bool
    :ivar is_recent_graduate: Search for canditates that graduated less than a year ago.
    :vartype is_recent_graduate: bool
    :ivar is_recent_graduate_required:
    :vartype is_recent_graduate_required: bool
    :ivar education_weight:
    :vartype education_weight: float
    :ivar search_expression: Search through resumes' raw text.
    :vartype search_expression: str
    :ivar search_expression_required:
    :vartype search_expression_required: bool
    :ivar search_expression_weight:
    :vartype search_expression_weight: float
    :ivar soc_codes:
    :vartype soc_codes: list[int]
    :ivar soc_codes_weight:
    :vartype soc_codes_weight: float
    :ivar soc_codes_required:
    :vartype soc_codes_required: bool
    :ivar management_level: Known values are: "None", "Low", "Mid", "Upper".
    :vartype management_level: str or ~affinda.models.ManagementLevel
    :ivar management_level_required:
    :vartype management_level_required: bool
    :ivar management_level_weight:
    :vartype management_level_weight: float
    :ivar custom_data:
    :vartype custom_data: list[~affinda.models.ResumeSearchParametersCustomData]
    """

    _validation = {
        "indices": {"required": True},
        "job_titles_weight": {"maximum": 1, "minimum": 0},
        "years_experience_min": {"minimum": 0},
        "years_experience_max": {"minimum": 0},
        "years_experience_weight": {"maximum": 1, "minimum": 0},
        "locations_weight": {"maximum": 1, "minimum": 0},
        "skills_weight": {"maximum": 1, "minimum": 0},
        "languages_weight": {"maximum": 1, "minimum": 0},
        "highest_degree_types": {"unique": True},
        "education_weight": {"maximum": 1, "minimum": 0},
        "search_expression_weight": {"maximum": 1, "minimum": 0},
        "soc_codes_weight": {"maximum": 1, "minimum": 0},
        "management_level_weight": {"maximum": 1, "minimum": 0},
    }

    _attribute_map = {
        "indices": {"key": "indices", "type": "[str]"},
        "job_description": {"key": "jobDescription", "type": "str"},
        "resume": {"key": "resume", "type": "str"},
        "job_titles": {"key": "jobTitles", "type": "[str]"},
        "job_titles_current_only": {"key": "jobTitlesCurrentOnly", "type": "bool"},
        "job_titles_required": {"key": "jobTitlesRequired", "type": "bool"},
        "job_titles_weight": {"key": "jobTitlesWeight", "type": "float"},
        "years_experience_min": {"key": "yearsExperienceMin", "type": "int"},
        "years_experience_max": {"key": "yearsExperienceMax", "type": "int"},
        "years_experience_required": {"key": "yearsExperienceRequired", "type": "bool"},
        "years_experience_weight": {"key": "yearsExperienceWeight", "type": "float"},
        "locations": {"key": "locations", "type": "[ResumeSearchParametersLocation]"},
        "locations_weight": {"key": "locationsWeight", "type": "float"},
        "locations_required": {"key": "locationsRequired", "type": "bool"},
        "skills": {"key": "skills", "type": "[ResumeSearchParametersSkill]"},
        "skills_weight": {"key": "skillsWeight", "type": "float"},
        "languages": {"key": "languages", "type": "[ResumeSearchParametersSkill]"},
        "languages_weight": {"key": "languagesWeight", "type": "float"},
        "institutions": {"key": "institutions", "type": "[str]"},
        "institutions_required": {"key": "institutionsRequired", "type": "bool"},
        "degrees": {"key": "degrees", "type": "[str]"},
        "degrees_required": {"key": "degreesRequired", "type": "bool"},
        "highest_degree_types": {"key": "highestDegreeTypes", "type": "[str]"},
        "highest_degree_types_required": {"key": "highestDegreeTypesRequired", "type": "bool"},
        "is_current_student": {"key": "isCurrentStudent", "type": "bool"},
        "is_current_student_required": {"key": "isCurrentStudentRequired", "type": "bool"},
        "is_recent_graduate": {"key": "isRecentGraduate", "type": "bool"},
        "is_recent_graduate_required": {"key": "isRecentGraduateRequired", "type": "bool"},
        "education_weight": {"key": "educationWeight", "type": "float"},
        "search_expression": {"key": "searchExpression", "type": "str"},
        "search_expression_required": {"key": "searchExpressionRequired", "type": "bool"},
        "search_expression_weight": {"key": "searchExpressionWeight", "type": "float"},
        "soc_codes": {"key": "socCodes", "type": "[int]"},
        "soc_codes_weight": {"key": "socCodesWeight", "type": "float"},
        "soc_codes_required": {"key": "socCodesRequired", "type": "bool"},
        "management_level": {"key": "managementLevel", "type": "str"},
        "management_level_required": {"key": "managementLevelRequired", "type": "bool"},
        "management_level_weight": {"key": "managementLevelWeight", "type": "float"},
        "custom_data": {"key": "customData", "type": "[ResumeSearchParametersCustomData]"},
    }

    def __init__(
        self,
        *,
        indices: List[str],
        job_description: Optional[str] = None,
        resume: Optional[str] = None,
        job_titles: Optional[List[str]] = None,
        job_titles_current_only: Optional[bool] = None,
        job_titles_required: Optional[bool] = None,
        job_titles_weight: Optional[float] = None,
        years_experience_min: Optional[int] = None,
        years_experience_max: Optional[int] = None,
        years_experience_required: Optional[bool] = None,
        years_experience_weight: Optional[float] = None,
        locations: Optional[List["_models.ResumeSearchParametersLocation"]] = None,
        locations_weight: Optional[float] = None,
        locations_required: Optional[bool] = None,
        skills: Optional[List["_models.ResumeSearchParametersSkill"]] = None,
        skills_weight: Optional[float] = None,
        languages: Optional[List["_models.ResumeSearchParametersSkill"]] = None,
        languages_weight: Optional[float] = None,
        institutions: Optional[List[str]] = None,
        institutions_required: Optional[bool] = None,
        degrees: Optional[List[str]] = None,
        degrees_required: Optional[bool] = None,
        highest_degree_types: Optional[List[Union[str, "_models.EducationLevel"]]] = None,
        highest_degree_types_required: Optional[bool] = None,
        is_current_student: Optional[bool] = None,
        is_current_student_required: Optional[bool] = None,
        is_recent_graduate: Optional[bool] = None,
        is_recent_graduate_required: Optional[bool] = None,
        education_weight: Optional[float] = None,
        search_expression: Optional[str] = None,
        search_expression_required: Optional[bool] = None,
        search_expression_weight: Optional[float] = None,
        soc_codes: Optional[List[int]] = None,
        soc_codes_weight: Optional[float] = None,
        soc_codes_required: Optional[bool] = None,
        management_level: Optional[Union[str, "_models.ManagementLevel"]] = None,
        management_level_required: Optional[bool] = None,
        management_level_weight: Optional[float] = None,
        custom_data: Optional[List["_models.ResumeSearchParametersCustomData"]] = None,
        **kwargs,
    ):
        """
        :keyword indices: Required.
        :paramtype indices: list[str]
        :keyword job_description: A random string that uniquely identify the resource.
        :paramtype job_description: str
        :keyword resume: A random string that uniquely identify the resource.
        :paramtype resume: str
        :keyword job_titles:
        :paramtype job_titles: list[str]
        :keyword job_titles_current_only: Search only through the canditate's current job.
        :paramtype job_titles_current_only: bool
        :keyword job_titles_required:
        :paramtype job_titles_required: bool
        :keyword job_titles_weight:
        :paramtype job_titles_weight: float
        :keyword years_experience_min: Minimum years of total work experience.
        :paramtype years_experience_min: int
        :keyword years_experience_max: Maximum years of total work experience.
        :paramtype years_experience_max: int
        :keyword years_experience_required:
        :paramtype years_experience_required: bool
        :keyword years_experience_weight:
        :paramtype years_experience_weight: float
        :keyword locations: Search by location name or by coordinates.
        :paramtype locations: list[~affinda.models.ResumeSearchParametersLocation]
        :keyword locations_weight:
        :paramtype locations_weight: float
        :keyword locations_required:
        :paramtype locations_required: bool
        :keyword skills:
        :paramtype skills: list[~affinda.models.ResumeSearchParametersSkill]
        :keyword skills_weight:
        :paramtype skills_weight: float
        :keyword languages:
        :paramtype languages: list[~affinda.models.ResumeSearchParametersSkill]
        :keyword languages_weight:
        :paramtype languages_weight: float
        :keyword institutions:
        :paramtype institutions: list[str]
        :keyword institutions_required:
        :paramtype institutions_required: bool
        :keyword degrees:
        :paramtype degrees: list[str]
        :keyword degrees_required:
        :paramtype degrees_required: bool
        :keyword highest_degree_types:
        :paramtype highest_degree_types: list[str or ~affinda.models.EducationLevel]
        :keyword highest_degree_types_required:
        :paramtype highest_degree_types_required: bool
        :keyword is_current_student: Search for student canditates.
        :paramtype is_current_student: bool
        :keyword is_current_student_required:
        :paramtype is_current_student_required: bool
        :keyword is_recent_graduate: Search for canditates that graduated less than a year ago.
        :paramtype is_recent_graduate: bool
        :keyword is_recent_graduate_required:
        :paramtype is_recent_graduate_required: bool
        :keyword education_weight:
        :paramtype education_weight: float
        :keyword search_expression: Search through resumes' raw text.
        :paramtype search_expression: str
        :keyword search_expression_required:
        :paramtype search_expression_required: bool
        :keyword search_expression_weight:
        :paramtype search_expression_weight: float
        :keyword soc_codes:
        :paramtype soc_codes: list[int]
        :keyword soc_codes_weight:
        :paramtype soc_codes_weight: float
        :keyword soc_codes_required:
        :paramtype soc_codes_required: bool
        :keyword management_level: Known values are: "None", "Low", "Mid", "Upper".
        :paramtype management_level: str or ~affinda.models.ManagementLevel
        :keyword management_level_required:
        :paramtype management_level_required: bool
        :keyword management_level_weight:
        :paramtype management_level_weight: float
        :keyword custom_data:
        :paramtype custom_data: list[~affinda.models.ResumeSearchParametersCustomData]
        """
        super(ResumeSearchParameters, self).__init__(**kwargs)
        self.indices = indices
        self.job_description = job_description
        self.resume = resume
        self.job_titles = job_titles
        self.job_titles_current_only = job_titles_current_only
        self.job_titles_required = job_titles_required
        self.job_titles_weight = job_titles_weight
        self.years_experience_min = years_experience_min
        self.years_experience_max = years_experience_max
        self.years_experience_required = years_experience_required
        self.years_experience_weight = years_experience_weight
        self.locations = locations
        self.locations_weight = locations_weight
        self.locations_required = locations_required
        self.skills = skills
        self.skills_weight = skills_weight
        self.languages = languages
        self.languages_weight = languages_weight
        self.institutions = institutions
        self.institutions_required = institutions_required
        self.degrees = degrees
        self.degrees_required = degrees_required
        self.highest_degree_types = highest_degree_types
        self.highest_degree_types_required = highest_degree_types_required
        self.is_current_student = is_current_student
        self.is_current_student_required = is_current_student_required
        self.is_recent_graduate = is_recent_graduate
        self.is_recent_graduate_required = is_recent_graduate_required
        self.education_weight = education_weight
        self.search_expression = search_expression
        self.search_expression_required = search_expression_required
        self.search_expression_weight = search_expression_weight
        self.soc_codes = soc_codes
        self.soc_codes_weight = soc_codes_weight
        self.soc_codes_required = soc_codes_required
        self.management_level = management_level
        self.management_level_required = management_level_required
        self.management_level_weight = management_level_weight
        self.custom_data = custom_data


class SearchParametersCustomData(msrest.serialization.Model):
    """SearchParametersCustomData.

    All required parameters must be populated in order to send to Azure.

    :ivar filter_type: Required. Data points of "text" type support only "equals" filterType,
     others support both "equals" and "range". Known values are: "equals", "range".
    :vartype filter_type: str or ~affinda.models.SearchParametersCustomDataFilterType
    :ivar data_point: Required. The data point's slug.
    :vartype data_point: str
    :ivar query: Required. "equals" searches require the "value" key inside the query, and "range"
     searches require at least one of "gte" (greater than or equal) and "lte" (less than or equal).
    :vartype query: any
    :ivar required:
    :vartype required: bool
    :ivar weight:
    :vartype weight: float
    """

    _validation = {
        "filter_type": {"required": True},
        "data_point": {"required": True},
        "query": {"required": True},
        "weight": {"maximum": 1, "minimum": 0},
    }

    _attribute_map = {
        "filter_type": {"key": "filterType", "type": "str"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "query": {"key": "query", "type": "object"},
        "required": {"key": "required", "type": "bool"},
        "weight": {"key": "weight", "type": "float"},
    }

    def __init__(
        self,
        *,
        filter_type: Union[str, "_models.SearchParametersCustomDataFilterType"],
        data_point: str,
        query: Any,
        required: Optional[bool] = None,
        weight: Optional[float] = None,
        **kwargs,
    ):
        """
        :keyword filter_type: Required. Data points of "text" type support only "equals" filterType,
         others support both "equals" and "range". Known values are: "equals", "range".
        :paramtype filter_type: str or ~affinda.models.SearchParametersCustomDataFilterType
        :keyword data_point: Required. The data point's slug.
        :paramtype data_point: str
        :keyword query: Required. "equals" searches require the "value" key inside the query, and
         "range" searches require at least one of "gte" (greater than or equal) and "lte" (less than or
         equal).
        :paramtype query: any
        :keyword required:
        :paramtype required: bool
        :keyword weight:
        :paramtype weight: float
        """
        super(SearchParametersCustomData, self).__init__(**kwargs)
        self.filter_type = filter_type
        self.data_point = data_point
        self.query = query
        self.required = required
        self.weight = weight


class ResumeSearchParametersCustomData(SearchParametersCustomData):
    """ResumeSearchParametersCustomData.

    All required parameters must be populated in order to send to Azure.

    :ivar filter_type: Required. Data points of "text" type support only "equals" filterType,
     others support both "equals" and "range". Known values are: "equals", "range".
    :vartype filter_type: str or ~affinda.models.SearchParametersCustomDataFilterType
    :ivar data_point: Required. The data point's slug.
    :vartype data_point: str
    :ivar query: Required. "equals" searches require the "value" key inside the query, and "range"
     searches require at least one of "gte" (greater than or equal) and "lte" (less than or equal).
    :vartype query: any
    :ivar required:
    :vartype required: bool
    :ivar weight:
    :vartype weight: float
    """

    _validation = {
        "filter_type": {"required": True},
        "data_point": {"required": True},
        "query": {"required": True},
        "weight": {"maximum": 1, "minimum": 0},
    }

    _attribute_map = {
        "filter_type": {"key": "filterType", "type": "str"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "query": {"key": "query", "type": "object"},
        "required": {"key": "required", "type": "bool"},
        "weight": {"key": "weight", "type": "float"},
    }

    def __init__(
        self,
        *,
        filter_type: Union[str, "_models.SearchParametersCustomDataFilterType"],
        data_point: str,
        query: Any,
        required: Optional[bool] = None,
        weight: Optional[float] = None,
        **kwargs,
    ):
        """
        :keyword filter_type: Required. Data points of "text" type support only "equals" filterType,
         others support both "equals" and "range". Known values are: "equals", "range".
        :paramtype filter_type: str or ~affinda.models.SearchParametersCustomDataFilterType
        :keyword data_point: Required. The data point's slug.
        :paramtype data_point: str
        :keyword query: Required. "equals" searches require the "value" key inside the query, and
         "range" searches require at least one of "gte" (greater than or equal) and "lte" (less than or
         equal).
        :paramtype query: any
        :keyword required:
        :paramtype required: bool
        :keyword weight:
        :paramtype weight: float
        """
        super(ResumeSearchParametersCustomData, self).__init__(
            filter_type=filter_type,
            data_point=data_point,
            query=query,
            required=required,
            weight=weight,
            **kwargs,
        )


class ResumeSearchParametersLocation(msrest.serialization.Model):
    """ResumeSearchParametersLocation.

    :ivar name:
    :vartype name: str
    :ivar coordinates:
    :vartype coordinates: ~affinda.models.ResumeSearchParametersLocationCoordinates
    :ivar distance:
    :vartype distance: int
    :ivar unit: Known values are: "km", "mi". Default value: "km".
    :vartype unit: str or ~affinda.models.SearchLocationUnit
    """

    _validation = {
        "distance": {"minimum": 1},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "coordinates": {"key": "coordinates", "type": "ResumeSearchParametersLocationCoordinates"},
        "distance": {"key": "distance", "type": "int"},
        "unit": {"key": "unit", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = "",
        coordinates: Optional["_models.ResumeSearchParametersLocationCoordinates"] = None,
        distance: Optional[int] = 100,
        unit: Optional[Union[str, "_models.SearchLocationUnit"]] = "km",
        **kwargs,
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword coordinates:
        :paramtype coordinates: ~affinda.models.ResumeSearchParametersLocationCoordinates
        :keyword distance:
        :paramtype distance: int
        :keyword unit: Known values are: "km", "mi". Default value: "km".
        :paramtype unit: str or ~affinda.models.SearchLocationUnit
        """
        super(ResumeSearchParametersLocation, self).__init__(**kwargs)
        self.name = name
        self.coordinates = coordinates
        self.distance = distance
        self.unit = unit


class ResumeSearchParametersLocationCoordinates(msrest.serialization.Model):
    """ResumeSearchParametersLocationCoordinates.

    :ivar latitude:
    :vartype latitude: float
    :ivar longitude:
    :vartype longitude: float
    """

    _attribute_map = {
        "latitude": {"key": "latitude", "type": "float"},
        "longitude": {"key": "longitude", "type": "float"},
    }

    def __init__(
        self, *, latitude: Optional[float] = None, longitude: Optional[float] = None, **kwargs
    ):
        """
        :keyword latitude:
        :paramtype latitude: float
        :keyword longitude:
        :paramtype longitude: float
        """
        super(ResumeSearchParametersLocationCoordinates, self).__init__(**kwargs)
        self.latitude = latitude
        self.longitude = longitude


class ResumeSearchParametersSkill(msrest.serialization.Model):
    """ResumeSearchParametersSkill.

    :ivar name:
    :vartype name: str
    :ivar required:
    :vartype required: bool
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "required": {"key": "required", "type": "bool"},
    }

    def __init__(self, *, name: Optional[str] = None, required: Optional[bool] = None, **kwargs):
        """
        :keyword name:
        :paramtype name: str
        :keyword required:
        :paramtype required: bool
        """
        super(ResumeSearchParametersSkill, self).__init__(**kwargs)
        self.name = name
        self.required = required


class ResumeSearchResult(msrest.serialization.Model):
    """ResumeSearchResult.

    All required parameters must be populated in order to send to Azure.

    :ivar identifier: Required. A random string that uniquely identify the resource.
    :vartype identifier: str
    :ivar score: Required.
    :vartype score: float
    :ivar pdf: Required.
    :vartype pdf: str
    :ivar name:
    :vartype name: str
    :ivar job_title: Required.
    :vartype job_title: ~affinda.models.JobTitleSearchScoreComponent
    :ivar management_level: Required.
    :vartype management_level: ~affinda.models.ManagementLevelSearchScoreComponent
    :ivar experience: Required.
    :vartype experience: ~affinda.models.ExperienceSearchScoreComponent
    :ivar skills: Required.
    :vartype skills: ~affinda.models.SkillsSearchScoreComponent
    :ivar languages: Required.
    :vartype languages: ~affinda.models.LanguagesSearchScoreComponent
    :ivar location: Required.
    :vartype location: ~affinda.models.LocationSearchScoreComponent
    :ivar education: Required.
    :vartype education: ~affinda.models.EducationSearchScoreComponent
    :ivar occupation_group: Required.
    :vartype occupation_group: ~affinda.models.OccupationGroupSearchScoreComponent
    :ivar search_expression: Required.
    :vartype search_expression: ~affinda.models.SearchExpressionSearchScoreComponent
    :ivar custom_data: Required. Dictionary of
     <components·nqbw24·schemas·customdatasearchscorecomponent·additionalproperties>.
    :vartype custom_data: dict[str,
     ~affinda.models.ComponentsNqbw24SchemasCustomdatasearchscorecomponentAdditionalproperties]
    """

    _validation = {
        "identifier": {"required": True},
        "score": {"required": True},
        "pdf": {"required": True},
        "job_title": {"required": True},
        "management_level": {"required": True},
        "experience": {"required": True},
        "skills": {"required": True},
        "languages": {"required": True},
        "location": {"required": True},
        "education": {"required": True},
        "occupation_group": {"required": True},
        "search_expression": {"required": True},
        "custom_data": {"required": True},
    }

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "score": {"key": "score", "type": "float"},
        "pdf": {"key": "pdf", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "job_title": {"key": "jobTitle", "type": "JobTitleSearchScoreComponent"},
        "management_level": {
            "key": "managementLevel",
            "type": "ManagementLevelSearchScoreComponent",
        },
        "experience": {"key": "experience", "type": "ExperienceSearchScoreComponent"},
        "skills": {"key": "skills", "type": "SkillsSearchScoreComponent"},
        "languages": {"key": "languages", "type": "LanguagesSearchScoreComponent"},
        "location": {"key": "location", "type": "LocationSearchScoreComponent"},
        "education": {"key": "education", "type": "EducationSearchScoreComponent"},
        "occupation_group": {
            "key": "occupationGroup",
            "type": "OccupationGroupSearchScoreComponent",
        },
        "search_expression": {
            "key": "searchExpression",
            "type": "SearchExpressionSearchScoreComponent",
        },
        "custom_data": {
            "key": "customData",
            "type": "{ComponentsNqbw24SchemasCustomdatasearchscorecomponentAdditionalproperties}",
        },
    }

    def __init__(
        self,
        *,
        identifier: str,
        score: float,
        pdf: str,
        job_title: "_models.JobTitleSearchScoreComponent",
        management_level: "_models.ManagementLevelSearchScoreComponent",
        experience: "_models.ExperienceSearchScoreComponent",
        skills: "_models.SkillsSearchScoreComponent",
        languages: "_models.LanguagesSearchScoreComponent",
        location: "_models.LocationSearchScoreComponent",
        education: "_models.EducationSearchScoreComponent",
        occupation_group: "_models.OccupationGroupSearchScoreComponent",
        search_expression: "_models.SearchExpressionSearchScoreComponent",
        custom_data: Dict[
            str,
            "_models.ComponentsNqbw24SchemasCustomdatasearchscorecomponentAdditionalproperties",
        ],
        name: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword identifier: Required. A random string that uniquely identify the resource.
        :paramtype identifier: str
        :keyword score: Required.
        :paramtype score: float
        :keyword pdf: Required.
        :paramtype pdf: str
        :keyword name:
        :paramtype name: str
        :keyword job_title: Required.
        :paramtype job_title: ~affinda.models.JobTitleSearchScoreComponent
        :keyword management_level: Required.
        :paramtype management_level: ~affinda.models.ManagementLevelSearchScoreComponent
        :keyword experience: Required.
        :paramtype experience: ~affinda.models.ExperienceSearchScoreComponent
        :keyword skills: Required.
        :paramtype skills: ~affinda.models.SkillsSearchScoreComponent
        :keyword languages: Required.
        :paramtype languages: ~affinda.models.LanguagesSearchScoreComponent
        :keyword location: Required.
        :paramtype location: ~affinda.models.LocationSearchScoreComponent
        :keyword education: Required.
        :paramtype education: ~affinda.models.EducationSearchScoreComponent
        :keyword occupation_group: Required.
        :paramtype occupation_group: ~affinda.models.OccupationGroupSearchScoreComponent
        :keyword search_expression: Required.
        :paramtype search_expression: ~affinda.models.SearchExpressionSearchScoreComponent
        :keyword custom_data: Required. Dictionary of
         <components·nqbw24·schemas·customdatasearchscorecomponent·additionalproperties>.
        :paramtype custom_data: dict[str,
         ~affinda.models.ComponentsNqbw24SchemasCustomdatasearchscorecomponentAdditionalproperties]
        """
        super(ResumeSearchResult, self).__init__(**kwargs)
        self.identifier = identifier
        self.score = score
        self.pdf = pdf
        self.name = name
        self.job_title = job_title
        self.management_level = management_level
        self.experience = experience
        self.skills = skills
        self.languages = languages
        self.location = location
        self.education = education
        self.occupation_group = occupation_group
        self.search_expression = search_expression
        self.custom_data = custom_data


class ResumeSkillSourcesItem(msrest.serialization.Model):
    """ResumeSkillSourcesItem.

    :ivar section: Known values are: "Achievements", "AdditionalInformation", "Education",
     "Extracurriculars", "Organisations", "Other", "PersonalDetails", "Projects", "Publications",
     "Referees", "Skills", "Summary", "Training", "WorkExperience", "NotPopulated", "Header",
     "Footer", "Skills/Interests/Languages", "Training/Certifications",
     "Extracurriculars/Leadership".
    :vartype section: str or ~affinda.models.ResumeSkillSourcesItemSection
    :ivar position:
    :vartype position: int
    """

    _validation = {
        "position": {"minimum": 0},
    }

    _attribute_map = {
        "section": {"key": "section", "type": "str"},
        "position": {"key": "position", "type": "int"},
    }

    def __init__(
        self,
        *,
        section: Optional[Union[str, "_models.ResumeSkillSourcesItemSection"]] = None,
        position: Optional[int] = None,
        **kwargs,
    ):
        """
        :keyword section: Known values are: "Achievements", "AdditionalInformation", "Education",
         "Extracurriculars", "Organisations", "Other", "PersonalDetails", "Projects", "Publications",
         "Referees", "Skills", "Summary", "Training", "WorkExperience", "NotPopulated", "Header",
         "Footer", "Skills/Interests/Languages", "Training/Certifications",
         "Extracurriculars/Leadership".
        :paramtype section: str or ~affinda.models.ResumeSkillSourcesItemSection
        :keyword position:
        :paramtype position: int
        """
        super(ResumeSkillSourcesItem, self).__init__(**kwargs)
        self.section = section
        self.position = position


class RowAnnotation(Annotation):
    """RowAnnotation.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required. Annotation's ID.
    :vartype id: int
    :ivar rectangle: Required. x/y coordinates for the rectangular bounding box containing the
     data.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required. x/y coordinates for the rectangles containing the data. An
     annotation can be contained within multiple rectangles.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar document: Required. Unique identifier for the document.
    :vartype document: str
    :ivar page_index: Required. The page number within the document, starting from 0.
    :vartype page_index: int
    :ivar raw: Required. Raw data extracted from the before any post-processing.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required. Indicates whether the data has been validated, either by a human
     using our validation tool or through auto-validation rules.
    :vartype is_verified: bool
    :ivar is_client_verified: Required. Indicates whether the data has been validated by a human.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required. Indicates whether the data has been auto-validated.
    :vartype is_auto_verified: bool
    :ivar data_point: Data point's identifier.
    :vartype data_point: str
    :ivar field: Field's identifier.
    :vartype field: str
    :ivar content_type: Required. The different data types of annotations. Known values are:
     "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
     "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
     "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
    :vartype content_type: str or ~affinda.models.AnnotationContentType
    :ivar parent: The parent annotation's ID.
    :vartype parent: int
    :ivar parsed:
    :vartype parsed: ~affinda.models.RowAnnotationParsed
    """

    _validation = {
        "id": {"required": True, "minimum": 1},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "document": {"required": True},
        "page_index": {"required": True, "minimum": 0},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "document": {"key": "document", "type": "str"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "field": {"key": "field", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parent": {"key": "parent", "type": "int"},
        "parsed": {"key": "parsed", "type": "RowAnnotationParsed"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        document: str,
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        content_type: Union[str, "_models.AnnotationContentType"],
        additional_properties: Optional[Dict[str, Any]] = None,
        data_point: Optional[str] = None,
        field: Optional[str] = None,
        parent: Optional[int] = None,
        parsed: Optional["_models.RowAnnotationParsed"] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required. Annotation's ID.
        :paramtype id: int
        :keyword rectangle: Required. x/y coordinates for the rectangular bounding box containing the
         data.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required. x/y coordinates for the rectangles containing the data. An
         annotation can be contained within multiple rectangles.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword document: Required. Unique identifier for the document.
        :paramtype document: str
        :keyword page_index: Required. The page number within the document, starting from 0.
        :paramtype page_index: int
        :keyword raw: Required. Raw data extracted from the before any post-processing.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required. Indicates whether the data has been validated, either by a
         human using our validation tool or through auto-validation rules.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required. Indicates whether the data has been validated by a
         human.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required. Indicates whether the data has been auto-validated.
        :paramtype is_auto_verified: bool
        :keyword data_point: Data point's identifier.
        :paramtype data_point: str
        :keyword field: Field's identifier.
        :paramtype field: str
        :keyword content_type: Required. The different data types of annotations. Known values are:
         "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
         "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
         "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
        :paramtype content_type: str or ~affinda.models.AnnotationContentType
        :keyword parent: The parent annotation's ID.
        :paramtype parent: int
        :keyword parsed:
        :paramtype parsed: ~affinda.models.RowAnnotationParsed
        """
        super(RowAnnotation, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            document=document,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            field=field,
            content_type=content_type,
            parent=parent,
            **kwargs,
        )
        self.parsed = parsed


class RowAnnotationParsed(msrest.serialization.Model):
    """RowAnnotationParsed.

    :ivar item_code:
    :vartype item_code: ~affinda.models.TextAnnotation
    :ivar item_date:
    :vartype item_date: ~affinda.models.DateAnnotation
    :ivar item_description:
    :vartype item_description: ~affinda.models.TextAnnotation
    :ivar item_unit:
    :vartype item_unit: ~affinda.models.TextAnnotation
    :ivar item_unit_price:
    :vartype item_unit_price: ~affinda.models.FloatAnnotation
    :ivar item_quantity:
    :vartype item_quantity: ~affinda.models.FloatAnnotation
    :ivar item_discount:
    :vartype item_discount: ~affinda.models.TextAnnotation
    :ivar item_base_total:
    :vartype item_base_total: ~affinda.models.FloatAnnotation
    :ivar item_tax_rate:
    :vartype item_tax_rate: ~affinda.models.TextAnnotation
    :ivar item_tax_total:
    :vartype item_tax_total: ~affinda.models.FloatAnnotation
    :ivar item_total:
    :vartype item_total: ~affinda.models.FloatAnnotation
    :ivar item_other:
    :vartype item_other: ~affinda.models.TextAnnotation
    """

    _attribute_map = {
        "item_code": {"key": "itemCode", "type": "TextAnnotation"},
        "item_date": {"key": "itemDate", "type": "DateAnnotation"},
        "item_description": {"key": "itemDescription", "type": "TextAnnotation"},
        "item_unit": {"key": "itemUnit", "type": "TextAnnotation"},
        "item_unit_price": {"key": "itemUnitPrice", "type": "FloatAnnotation"},
        "item_quantity": {"key": "itemQuantity", "type": "FloatAnnotation"},
        "item_discount": {"key": "itemDiscount", "type": "TextAnnotation"},
        "item_base_total": {"key": "itemBaseTotal", "type": "FloatAnnotation"},
        "item_tax_rate": {"key": "itemTaxRate", "type": "TextAnnotation"},
        "item_tax_total": {"key": "itemTaxTotal", "type": "FloatAnnotation"},
        "item_total": {"key": "itemTotal", "type": "FloatAnnotation"},
        "item_other": {"key": "itemOther", "type": "TextAnnotation"},
    }

    def __init__(
        self,
        *,
        item_code: Optional["_models.TextAnnotation"] = None,
        item_date: Optional["_models.DateAnnotation"] = None,
        item_description: Optional["_models.TextAnnotation"] = None,
        item_unit: Optional["_models.TextAnnotation"] = None,
        item_unit_price: Optional["_models.FloatAnnotation"] = None,
        item_quantity: Optional["_models.FloatAnnotation"] = None,
        item_discount: Optional["_models.TextAnnotation"] = None,
        item_base_total: Optional["_models.FloatAnnotation"] = None,
        item_tax_rate: Optional["_models.TextAnnotation"] = None,
        item_tax_total: Optional["_models.FloatAnnotation"] = None,
        item_total: Optional["_models.FloatAnnotation"] = None,
        item_other: Optional["_models.TextAnnotation"] = None,
        **kwargs,
    ):
        """
        :keyword item_code:
        :paramtype item_code: ~affinda.models.TextAnnotation
        :keyword item_date:
        :paramtype item_date: ~affinda.models.DateAnnotation
        :keyword item_description:
        :paramtype item_description: ~affinda.models.TextAnnotation
        :keyword item_unit:
        :paramtype item_unit: ~affinda.models.TextAnnotation
        :keyword item_unit_price:
        :paramtype item_unit_price: ~affinda.models.FloatAnnotation
        :keyword item_quantity:
        :paramtype item_quantity: ~affinda.models.FloatAnnotation
        :keyword item_discount:
        :paramtype item_discount: ~affinda.models.TextAnnotation
        :keyword item_base_total:
        :paramtype item_base_total: ~affinda.models.FloatAnnotation
        :keyword item_tax_rate:
        :paramtype item_tax_rate: ~affinda.models.TextAnnotation
        :keyword item_tax_total:
        :paramtype item_tax_total: ~affinda.models.FloatAnnotation
        :keyword item_total:
        :paramtype item_total: ~affinda.models.FloatAnnotation
        :keyword item_other:
        :paramtype item_other: ~affinda.models.TextAnnotation
        """
        super(RowAnnotationParsed, self).__init__(**kwargs)
        self.item_code = item_code
        self.item_date = item_date
        self.item_description = item_description
        self.item_unit = item_unit
        self.item_unit_price = item_unit_price
        self.item_quantity = item_quantity
        self.item_discount = item_discount
        self.item_base_total = item_base_total
        self.item_tax_rate = item_tax_rate
        self.item_tax_total = item_tax_total
        self.item_total = item_total
        self.item_other = item_other


class RowBetaAnnotation(Annotation):
    """RowBetaAnnotation.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required. Annotation's ID.
    :vartype id: int
    :ivar rectangle: Required. x/y coordinates for the rectangular bounding box containing the
     data.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required. x/y coordinates for the rectangles containing the data. An
     annotation can be contained within multiple rectangles.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar document: Required. Unique identifier for the document.
    :vartype document: str
    :ivar page_index: Required. The page number within the document, starting from 0.
    :vartype page_index: int
    :ivar raw: Required. Raw data extracted from the before any post-processing.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required. Indicates whether the data has been validated, either by a human
     using our validation tool or through auto-validation rules.
    :vartype is_verified: bool
    :ivar is_client_verified: Required. Indicates whether the data has been validated by a human.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required. Indicates whether the data has been auto-validated.
    :vartype is_auto_verified: bool
    :ivar data_point: Data point's identifier.
    :vartype data_point: str
    :ivar field: Field's identifier.
    :vartype field: str
    :ivar content_type: Required. The different data types of annotations. Known values are:
     "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
     "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
     "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
    :vartype content_type: str or ~affinda.models.AnnotationContentType
    :ivar parent: The parent annotation's ID.
    :vartype parent: int
    :ivar parsed:
    :vartype parsed: ~affinda.models.RowBetaAnnotationParsed
    """

    _validation = {
        "id": {"required": True, "minimum": 1},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "document": {"required": True},
        "page_index": {"required": True, "minimum": 0},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "document": {"key": "document", "type": "str"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "field": {"key": "field", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parent": {"key": "parent", "type": "int"},
        "parsed": {"key": "parsed", "type": "RowBetaAnnotationParsed"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        document: str,
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        content_type: Union[str, "_models.AnnotationContentType"],
        additional_properties: Optional[Dict[str, Any]] = None,
        data_point: Optional[str] = None,
        field: Optional[str] = None,
        parent: Optional[int] = None,
        parsed: Optional["_models.RowBetaAnnotationParsed"] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required. Annotation's ID.
        :paramtype id: int
        :keyword rectangle: Required. x/y coordinates for the rectangular bounding box containing the
         data.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required. x/y coordinates for the rectangles containing the data. An
         annotation can be contained within multiple rectangles.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword document: Required. Unique identifier for the document.
        :paramtype document: str
        :keyword page_index: Required. The page number within the document, starting from 0.
        :paramtype page_index: int
        :keyword raw: Required. Raw data extracted from the before any post-processing.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required. Indicates whether the data has been validated, either by a
         human using our validation tool or through auto-validation rules.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required. Indicates whether the data has been validated by a
         human.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required. Indicates whether the data has been auto-validated.
        :paramtype is_auto_verified: bool
        :keyword data_point: Data point's identifier.
        :paramtype data_point: str
        :keyword field: Field's identifier.
        :paramtype field: str
        :keyword content_type: Required. The different data types of annotations. Known values are:
         "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
         "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
         "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
        :paramtype content_type: str or ~affinda.models.AnnotationContentType
        :keyword parent: The parent annotation's ID.
        :paramtype parent: int
        :keyword parsed:
        :paramtype parsed: ~affinda.models.RowBetaAnnotationParsed
        """
        super(RowBetaAnnotation, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            document=document,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            field=field,
            content_type=content_type,
            parent=parent,
            **kwargs,
        )
        self.parsed = parsed


class RowBetaAnnotationParsed(msrest.serialization.Model):
    """RowBetaAnnotationParsed.

    :ivar item_code_beta:
    :vartype item_code_beta: ~affinda.models.TextAnnotation
    :ivar item_date_beta:
    :vartype item_date_beta: ~affinda.models.DateAnnotation
    :ivar item_description_beta:
    :vartype item_description_beta: ~affinda.models.TextAnnotation
    :ivar item_unit_beta:
    :vartype item_unit_beta: ~affinda.models.TextAnnotation
    :ivar item_unit_price_beta:
    :vartype item_unit_price_beta: ~affinda.models.FloatAnnotation
    :ivar item_quantity_beta:
    :vartype item_quantity_beta: ~affinda.models.FloatAnnotation
    :ivar item_discount_beta:
    :vartype item_discount_beta: ~affinda.models.TextAnnotation
    :ivar item_base_total_beta:
    :vartype item_base_total_beta: ~affinda.models.FloatAnnotation
    :ivar item_tax_rate_beta:
    :vartype item_tax_rate_beta: ~affinda.models.TextAnnotation
    :ivar item_tax_total_beta:
    :vartype item_tax_total_beta: ~affinda.models.FloatAnnotation
    :ivar item_total_beta:
    :vartype item_total_beta: ~affinda.models.FloatAnnotation
    :ivar item_other_beta:
    :vartype item_other_beta: ~affinda.models.TextAnnotation
    """

    _attribute_map = {
        "item_code_beta": {"key": "itemCodeBeta", "type": "TextAnnotation"},
        "item_date_beta": {"key": "itemDateBeta", "type": "DateAnnotation"},
        "item_description_beta": {"key": "itemDescriptionBeta", "type": "TextAnnotation"},
        "item_unit_beta": {"key": "itemUnitBeta", "type": "TextAnnotation"},
        "item_unit_price_beta": {"key": "itemUnitPriceBeta", "type": "FloatAnnotation"},
        "item_quantity_beta": {"key": "itemQuantityBeta", "type": "FloatAnnotation"},
        "item_discount_beta": {"key": "itemDiscountBeta", "type": "TextAnnotation"},
        "item_base_total_beta": {"key": "itemBaseTotalBeta", "type": "FloatAnnotation"},
        "item_tax_rate_beta": {"key": "itemTaxRateBeta", "type": "TextAnnotation"},
        "item_tax_total_beta": {"key": "itemTaxTotalBeta", "type": "FloatAnnotation"},
        "item_total_beta": {"key": "itemTotalBeta", "type": "FloatAnnotation"},
        "item_other_beta": {"key": "itemOtherBeta", "type": "TextAnnotation"},
    }

    def __init__(
        self,
        *,
        item_code_beta: Optional["_models.TextAnnotation"] = None,
        item_date_beta: Optional["_models.DateAnnotation"] = None,
        item_description_beta: Optional["_models.TextAnnotation"] = None,
        item_unit_beta: Optional["_models.TextAnnotation"] = None,
        item_unit_price_beta: Optional["_models.FloatAnnotation"] = None,
        item_quantity_beta: Optional["_models.FloatAnnotation"] = None,
        item_discount_beta: Optional["_models.TextAnnotation"] = None,
        item_base_total_beta: Optional["_models.FloatAnnotation"] = None,
        item_tax_rate_beta: Optional["_models.TextAnnotation"] = None,
        item_tax_total_beta: Optional["_models.FloatAnnotation"] = None,
        item_total_beta: Optional["_models.FloatAnnotation"] = None,
        item_other_beta: Optional["_models.TextAnnotation"] = None,
        **kwargs,
    ):
        """
        :keyword item_code_beta:
        :paramtype item_code_beta: ~affinda.models.TextAnnotation
        :keyword item_date_beta:
        :paramtype item_date_beta: ~affinda.models.DateAnnotation
        :keyword item_description_beta:
        :paramtype item_description_beta: ~affinda.models.TextAnnotation
        :keyword item_unit_beta:
        :paramtype item_unit_beta: ~affinda.models.TextAnnotation
        :keyword item_unit_price_beta:
        :paramtype item_unit_price_beta: ~affinda.models.FloatAnnotation
        :keyword item_quantity_beta:
        :paramtype item_quantity_beta: ~affinda.models.FloatAnnotation
        :keyword item_discount_beta:
        :paramtype item_discount_beta: ~affinda.models.TextAnnotation
        :keyword item_base_total_beta:
        :paramtype item_base_total_beta: ~affinda.models.FloatAnnotation
        :keyword item_tax_rate_beta:
        :paramtype item_tax_rate_beta: ~affinda.models.TextAnnotation
        :keyword item_tax_total_beta:
        :paramtype item_tax_total_beta: ~affinda.models.FloatAnnotation
        :keyword item_total_beta:
        :paramtype item_total_beta: ~affinda.models.FloatAnnotation
        :keyword item_other_beta:
        :paramtype item_other_beta: ~affinda.models.TextAnnotation
        """
        super(RowBetaAnnotationParsed, self).__init__(**kwargs)
        self.item_code_beta = item_code_beta
        self.item_date_beta = item_date_beta
        self.item_description_beta = item_description_beta
        self.item_unit_beta = item_unit_beta
        self.item_unit_price_beta = item_unit_price_beta
        self.item_quantity_beta = item_quantity_beta
        self.item_discount_beta = item_discount_beta
        self.item_base_total_beta = item_base_total_beta
        self.item_tax_rate_beta = item_tax_rate_beta
        self.item_tax_total_beta = item_tax_total_beta
        self.item_total_beta = item_total_beta
        self.item_other_beta = item_other_beta


class SearchConfigAction(msrest.serialization.Model):
    """SearchConfigAction.

    All required parameters must be populated in order to send to Azure.

    :ivar label: Required. Human readable label to display in the UI.
    :vartype label: str
    :ivar event_name: Required. Name of the event to be triggered.
    :vartype event_name: str
    """

    _validation = {
        "label": {"required": True},
        "event_name": {"required": True},
    }

    _attribute_map = {
        "label": {"key": "label", "type": "str"},
        "event_name": {"key": "eventName", "type": "str"},
    }

    def __init__(self, *, label: str, event_name: str, **kwargs):
        """
        :keyword label: Required. Human readable label to display in the UI.
        :paramtype label: str
        :keyword event_name: Required. Name of the event to be triggered.
        :paramtype event_name: str
        """
        super(SearchConfigAction, self).__init__(**kwargs)
        self.label = label
        self.event_name = event_name


class SearchExpressionSearchScoreComponent(msrest.serialization.Model):
    """SearchExpressionSearchScoreComponent.

    All required parameters must be populated in order to send to Azure.

    :ivar label: Required.
    :vartype label: str
    :ivar value:
    :vartype value: str
    :ivar score:
    :vartype score: float
    """

    _validation = {
        "label": {"required": True},
    }

    _attribute_map = {
        "label": {"key": "label", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "score": {"key": "score", "type": "float"},
    }

    def __init__(
        self, *, label: str, value: Optional[str] = None, score: Optional[float] = None, **kwargs
    ):
        """
        :keyword label: Required.
        :paramtype label: str
        :keyword value:
        :paramtype value: str
        :keyword score:
        :paramtype score: float
        """
        super(SearchExpressionSearchScoreComponent, self).__init__(**kwargs)
        self.label = label
        self.value = value
        self.score = score


class SkillAnnotation(Annotation):
    """SkillAnnotation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required. Annotation's ID.
    :vartype id: int
    :ivar rectangle: Required. x/y coordinates for the rectangular bounding box containing the
     data.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required. x/y coordinates for the rectangles containing the data. An
     annotation can be contained within multiple rectangles.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar document: Required. Unique identifier for the document.
    :vartype document: str
    :ivar page_index: Required. The page number within the document, starting from 0.
    :vartype page_index: int
    :ivar raw: Required. Raw data extracted from the before any post-processing.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required. Indicates whether the data has been validated, either by a human
     using our validation tool or through auto-validation rules.
    :vartype is_verified: bool
    :ivar is_client_verified: Required. Indicates whether the data has been validated by a human.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required. Indicates whether the data has been auto-validated.
    :vartype is_auto_verified: bool
    :ivar data_point: Data point's identifier.
    :vartype data_point: str
    :ivar field: Field's identifier.
    :vartype field: str
    :ivar content_type: Required. The different data types of annotations. Known values are:
     "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
     "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
     "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
    :vartype content_type: str or ~affinda.models.AnnotationContentType
    :ivar parent: The parent annotation's ID.
    :vartype parent: int
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "id": {"required": True, "minimum": 1},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "document": {"required": True},
        "page_index": {"required": True, "minimum": 0},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "content_type": {"required": True},
        "parsed": {"readonly": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "document": {"key": "document", "type": "str"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "field": {"key": "field", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parent": {"key": "parent", "type": "int"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        document: str,
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        content_type: Union[str, "_models.AnnotationContentType"],
        additional_properties: Optional[Dict[str, Any]] = None,
        data_point: Optional[str] = None,
        field: Optional[str] = None,
        parent: Optional[int] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required. Annotation's ID.
        :paramtype id: int
        :keyword rectangle: Required. x/y coordinates for the rectangular bounding box containing the
         data.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required. x/y coordinates for the rectangles containing the data. An
         annotation can be contained within multiple rectangles.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword document: Required. Unique identifier for the document.
        :paramtype document: str
        :keyword page_index: Required. The page number within the document, starting from 0.
        :paramtype page_index: int
        :keyword raw: Required. Raw data extracted from the before any post-processing.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required. Indicates whether the data has been validated, either by a
         human using our validation tool or through auto-validation rules.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required. Indicates whether the data has been validated by a
         human.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required. Indicates whether the data has been auto-validated.
        :paramtype is_auto_verified: bool
        :keyword data_point: Data point's identifier.
        :paramtype data_point: str
        :keyword field: Field's identifier.
        :paramtype field: str
        :keyword content_type: Required. The different data types of annotations. Known values are:
         "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
         "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
         "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
        :paramtype content_type: str or ~affinda.models.AnnotationContentType
        :keyword parent: The parent annotation's ID.
        :paramtype parent: int
        """
        super(SkillAnnotation, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            document=document,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            field=field,
            content_type=content_type,
            parent=parent,
            **kwargs,
        )
        self.parsed = None


class SkillAnnotationUpdate(AnnotationBase):
    """SkillAnnotationUpdate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id:
    :vartype id: int
    :ivar rectangle:
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles:
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index:
    :vartype page_index: int
    :ivar raw:
    :vartype raw: str
    :ivar confidence: The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: The model's confidence that the text has been classified
     correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: If the document was submitted as an image, this is the
     confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified:
    :vartype is_verified: bool
    :ivar is_client_verified:
    :vartype is_client_verified: bool
    :ivar is_auto_verified:
    :vartype is_auto_verified: bool
    :ivar data_point:
    :vartype data_point: str
    :ivar content_type:
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "rectangles": {"readonly": True},
        "parsed": {"readonly": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        id: Optional[int] = None,
        rectangle: Optional["_models.Rectangle"] = None,
        page_index: Optional[int] = None,
        raw: Optional[str] = None,
        confidence: Optional[float] = None,
        classification_confidence: Optional[float] = None,
        text_extraction_confidence: Optional[float] = None,
        is_verified: Optional[bool] = None,
        is_client_verified: Optional[bool] = None,
        is_auto_verified: Optional[bool] = None,
        data_point: Optional[str] = None,
        content_type: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id:
        :paramtype id: int
        :keyword rectangle:
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword page_index:
        :paramtype page_index: int
        :keyword raw:
        :paramtype raw: str
        :keyword confidence: The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: The model's confidence that the text has been classified
         correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: If the document was submitted as an image, this is the
         confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified:
        :paramtype is_verified: bool
        :keyword is_client_verified:
        :paramtype is_client_verified: bool
        :keyword is_auto_verified:
        :paramtype is_auto_verified: bool
        :keyword data_point:
        :paramtype data_point: str
        :keyword content_type:
        :paramtype content_type: str
        """
        super(SkillAnnotationUpdate, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            **kwargs,
        )
        self.parsed = None


class SkillsSearchScoreComponent(msrest.serialization.Model):
    """SkillsSearchScoreComponent.

    All required parameters must be populated in order to send to Azure.

    :ivar value:
    :vartype value: str
    :ivar label: Required.
    :vartype label: str
    :ivar score:
    :vartype score: float
    """

    _validation = {
        "label": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "score": {"key": "score", "type": "float"},
    }

    def __init__(
        self, *, label: str, value: Optional[str] = None, score: Optional[float] = None, **kwargs
    ):
        """
        :keyword value:
        :paramtype value: str
        :keyword label: Required.
        :paramtype label: str
        :keyword score:
        :paramtype score: float
        """
        super(SkillsSearchScoreComponent, self).__init__(**kwargs)
        self.value = value
        self.label = label
        self.score = score


class TableAnnotation(Annotation):
    """TableAnnotation.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required. Annotation's ID.
    :vartype id: int
    :ivar rectangle: Required. x/y coordinates for the rectangular bounding box containing the
     data.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required. x/y coordinates for the rectangles containing the data. An
     annotation can be contained within multiple rectangles.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar document: Required. Unique identifier for the document.
    :vartype document: str
    :ivar page_index: Required. The page number within the document, starting from 0.
    :vartype page_index: int
    :ivar raw: Required. Raw data extracted from the before any post-processing.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required. Indicates whether the data has been validated, either by a human
     using our validation tool or through auto-validation rules.
    :vartype is_verified: bool
    :ivar is_client_verified: Required. Indicates whether the data has been validated by a human.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required. Indicates whether the data has been auto-validated.
    :vartype is_auto_verified: bool
    :ivar data_point: Data point's identifier.
    :vartype data_point: str
    :ivar field: Field's identifier.
    :vartype field: str
    :ivar content_type: Required. The different data types of annotations. Known values are:
     "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
     "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
     "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
    :vartype content_type: str or ~affinda.models.AnnotationContentType
    :ivar parent: The parent annotation's ID.
    :vartype parent: int
    :ivar parsed:
    :vartype parsed: ~affinda.models.TableAnnotationParsed
    """

    _validation = {
        "id": {"required": True, "minimum": 1},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "document": {"required": True},
        "page_index": {"required": True, "minimum": 0},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "document": {"key": "document", "type": "str"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "field": {"key": "field", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parent": {"key": "parent", "type": "int"},
        "parsed": {"key": "parsed", "type": "TableAnnotationParsed"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        document: str,
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        content_type: Union[str, "_models.AnnotationContentType"],
        additional_properties: Optional[Dict[str, Any]] = None,
        data_point: Optional[str] = None,
        field: Optional[str] = None,
        parent: Optional[int] = None,
        parsed: Optional["_models.TableAnnotationParsed"] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required. Annotation's ID.
        :paramtype id: int
        :keyword rectangle: Required. x/y coordinates for the rectangular bounding box containing the
         data.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required. x/y coordinates for the rectangles containing the data. An
         annotation can be contained within multiple rectangles.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword document: Required. Unique identifier for the document.
        :paramtype document: str
        :keyword page_index: Required. The page number within the document, starting from 0.
        :paramtype page_index: int
        :keyword raw: Required. Raw data extracted from the before any post-processing.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required. Indicates whether the data has been validated, either by a
         human using our validation tool or through auto-validation rules.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required. Indicates whether the data has been validated by a
         human.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required. Indicates whether the data has been auto-validated.
        :paramtype is_auto_verified: bool
        :keyword data_point: Data point's identifier.
        :paramtype data_point: str
        :keyword field: Field's identifier.
        :paramtype field: str
        :keyword content_type: Required. The different data types of annotations. Known values are:
         "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
         "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
         "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
        :paramtype content_type: str or ~affinda.models.AnnotationContentType
        :keyword parent: The parent annotation's ID.
        :paramtype parent: int
        :keyword parsed:
        :paramtype parsed: ~affinda.models.TableAnnotationParsed
        """
        super(TableAnnotation, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            document=document,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            field=field,
            content_type=content_type,
            parent=parent,
            **kwargs,
        )
        self.parsed = parsed


class TableAnnotationParsed(msrest.serialization.Model):
    """TableAnnotationParsed.

    :ivar rows:
    :vartype rows: list[~affinda.models.RowAnnotation]
    """

    _attribute_map = {
        "rows": {"key": "rows", "type": "[RowAnnotation]"},
    }

    def __init__(self, *, rows: Optional[List["_models.RowAnnotation"]] = None, **kwargs):
        """
        :keyword rows:
        :paramtype rows: list[~affinda.models.RowAnnotation]
        """
        super(TableAnnotationParsed, self).__init__(**kwargs)
        self.rows = rows


class TableBetaAnnotation(Annotation):
    """TableBetaAnnotation.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required. Annotation's ID.
    :vartype id: int
    :ivar rectangle: Required. x/y coordinates for the rectangular bounding box containing the
     data.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required. x/y coordinates for the rectangles containing the data. An
     annotation can be contained within multiple rectangles.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar document: Required. Unique identifier for the document.
    :vartype document: str
    :ivar page_index: Required. The page number within the document, starting from 0.
    :vartype page_index: int
    :ivar raw: Required. Raw data extracted from the before any post-processing.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required. Indicates whether the data has been validated, either by a human
     using our validation tool or through auto-validation rules.
    :vartype is_verified: bool
    :ivar is_client_verified: Required. Indicates whether the data has been validated by a human.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required. Indicates whether the data has been auto-validated.
    :vartype is_auto_verified: bool
    :ivar data_point: Data point's identifier.
    :vartype data_point: str
    :ivar field: Field's identifier.
    :vartype field: str
    :ivar content_type: Required. The different data types of annotations. Known values are:
     "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
     "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
     "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
    :vartype content_type: str or ~affinda.models.AnnotationContentType
    :ivar parent: The parent annotation's ID.
    :vartype parent: int
    :ivar parsed:
    :vartype parsed: ~affinda.models.TableBetaAnnotationParsed
    """

    _validation = {
        "id": {"required": True, "minimum": 1},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "document": {"required": True},
        "page_index": {"required": True, "minimum": 0},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "document": {"key": "document", "type": "str"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "field": {"key": "field", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parent": {"key": "parent", "type": "int"},
        "parsed": {"key": "parsed", "type": "TableBetaAnnotationParsed"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        document: str,
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        content_type: Union[str, "_models.AnnotationContentType"],
        additional_properties: Optional[Dict[str, Any]] = None,
        data_point: Optional[str] = None,
        field: Optional[str] = None,
        parent: Optional[int] = None,
        parsed: Optional["_models.TableBetaAnnotationParsed"] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required. Annotation's ID.
        :paramtype id: int
        :keyword rectangle: Required. x/y coordinates for the rectangular bounding box containing the
         data.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required. x/y coordinates for the rectangles containing the data. An
         annotation can be contained within multiple rectangles.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword document: Required. Unique identifier for the document.
        :paramtype document: str
        :keyword page_index: Required. The page number within the document, starting from 0.
        :paramtype page_index: int
        :keyword raw: Required. Raw data extracted from the before any post-processing.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required. Indicates whether the data has been validated, either by a
         human using our validation tool or through auto-validation rules.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required. Indicates whether the data has been validated by a
         human.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required. Indicates whether the data has been auto-validated.
        :paramtype is_auto_verified: bool
        :keyword data_point: Data point's identifier.
        :paramtype data_point: str
        :keyword field: Field's identifier.
        :paramtype field: str
        :keyword content_type: Required. The different data types of annotations. Known values are:
         "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
         "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
         "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
        :paramtype content_type: str or ~affinda.models.AnnotationContentType
        :keyword parent: The parent annotation's ID.
        :paramtype parent: int
        :keyword parsed:
        :paramtype parsed: ~affinda.models.TableBetaAnnotationParsed
        """
        super(TableBetaAnnotation, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            document=document,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            field=field,
            content_type=content_type,
            parent=parent,
            **kwargs,
        )
        self.parsed = parsed


class TableBetaAnnotationParsed(msrest.serialization.Model):
    """TableBetaAnnotationParsed.

    :ivar rows:
    :vartype rows: list[~affinda.models.RowBetaAnnotation]
    """

    _attribute_map = {
        "rows": {"key": "rows", "type": "[RowBetaAnnotation]"},
    }

    def __init__(self, *, rows: Optional[List["_models.RowBetaAnnotation"]] = None, **kwargs):
        """
        :keyword rows:
        :paramtype rows: list[~affinda.models.RowBetaAnnotation]
        """
        super(TableBetaAnnotationParsed, self).__init__(**kwargs)
        self.rows = rows


class Tag(msrest.serialization.Model):
    """Tag.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Uniquely identify a tag.
    :vartype id: int
    :ivar name: Required.
    :vartype name: str
    :ivar workspace: Required. Uniquely identify a workspace.
    :vartype workspace: str
    :ivar document_count: Required. Number of documents tagged with this.
    :vartype document_count: int
    """

    _validation = {
        "id": {"required": True, "minimum": 1},
        "name": {"required": True},
        "workspace": {"required": True},
        "document_count": {"required": True, "minimum": 0},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "name": {"key": "name", "type": "str"},
        "workspace": {"key": "workspace", "type": "str"},
        "document_count": {"key": "documentCount", "type": "int"},
    }

    def __init__(self, *, id: int, name: str, workspace: str, document_count: int, **kwargs):
        """
        :keyword id: Required. Uniquely identify a tag.
        :paramtype id: int
        :keyword name: Required.
        :paramtype name: str
        :keyword workspace: Required. Uniquely identify a workspace.
        :paramtype workspace: str
        :keyword document_count: Required. Number of documents tagged with this.
        :paramtype document_count: int
        """
        super(Tag, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.workspace = workspace
        self.document_count = document_count


class TagCreate(msrest.serialization.Model):
    """TagCreate.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required.
    :vartype name: str
    :ivar workspace: Required. Uniquely identify a workspace.
    :vartype workspace: str
    """

    _validation = {
        "name": {"required": True},
        "workspace": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "workspace": {"key": "workspace", "type": "str"},
    }

    def __init__(self, *, name: str, workspace: str, **kwargs):
        """
        :keyword name: Required.
        :paramtype name: str
        :keyword workspace: Required. Uniquely identify a workspace.
        :paramtype workspace: str
        """
        super(TagCreate, self).__init__(**kwargs)
        self.name = name
        self.workspace = workspace


class TagUpdate(msrest.serialization.Model):
    """TagUpdate.

    :ivar name:
    :vartype name: str
    :ivar workspace: Uniquely identify a workspace.
    :vartype workspace: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "workspace": {"key": "workspace", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, workspace: Optional[str] = None, **kwargs):
        """
        :keyword name:
        :paramtype name: str
        :keyword workspace: Uniquely identify a workspace.
        :paramtype workspace: str
        """
        super(TagUpdate, self).__init__(**kwargs)
        self.name = name
        self.workspace = workspace


class TextAnnotation(Annotation):
    """TextAnnotation.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required. Annotation's ID.
    :vartype id: int
    :ivar rectangle: Required. x/y coordinates for the rectangular bounding box containing the
     data.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required. x/y coordinates for the rectangles containing the data. An
     annotation can be contained within multiple rectangles.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar document: Required. Unique identifier for the document.
    :vartype document: str
    :ivar page_index: Required. The page number within the document, starting from 0.
    :vartype page_index: int
    :ivar raw: Required. Raw data extracted from the before any post-processing.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required. Indicates whether the data has been validated, either by a human
     using our validation tool or through auto-validation rules.
    :vartype is_verified: bool
    :ivar is_client_verified: Required. Indicates whether the data has been validated by a human.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required. Indicates whether the data has been auto-validated.
    :vartype is_auto_verified: bool
    :ivar data_point: Data point's identifier.
    :vartype data_point: str
    :ivar field: Field's identifier.
    :vartype field: str
    :ivar content_type: Required. The different data types of annotations. Known values are:
     "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
     "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
     "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
    :vartype content_type: str or ~affinda.models.AnnotationContentType
    :ivar parent: The parent annotation's ID.
    :vartype parent: int
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "id": {"required": True, "minimum": 1},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "document": {"required": True},
        "page_index": {"required": True, "minimum": 0},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "document": {"key": "document", "type": "str"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "field": {"key": "field", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parent": {"key": "parent", "type": "int"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        document: str,
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        content_type: Union[str, "_models.AnnotationContentType"],
        additional_properties: Optional[Dict[str, Any]] = None,
        data_point: Optional[str] = None,
        field: Optional[str] = None,
        parent: Optional[int] = None,
        parsed: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required. Annotation's ID.
        :paramtype id: int
        :keyword rectangle: Required. x/y coordinates for the rectangular bounding box containing the
         data.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required. x/y coordinates for the rectangles containing the data. An
         annotation can be contained within multiple rectangles.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword document: Required. Unique identifier for the document.
        :paramtype document: str
        :keyword page_index: Required. The page number within the document, starting from 0.
        :paramtype page_index: int
        :keyword raw: Required. Raw data extracted from the before any post-processing.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required. Indicates whether the data has been validated, either by a
         human using our validation tool or through auto-validation rules.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required. Indicates whether the data has been validated by a
         human.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required. Indicates whether the data has been auto-validated.
        :paramtype is_auto_verified: bool
        :keyword data_point: Data point's identifier.
        :paramtype data_point: str
        :keyword field: Field's identifier.
        :paramtype field: str
        :keyword content_type: Required. The different data types of annotations. Known values are:
         "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
         "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
         "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
        :paramtype content_type: str or ~affinda.models.AnnotationContentType
        :keyword parent: The parent annotation's ID.
        :paramtype parent: int
        :keyword parsed:
        :paramtype parsed: str
        """
        super(TextAnnotation, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            document=document,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            field=field,
            content_type=content_type,
            parent=parent,
            **kwargs,
        )
        self.parsed = parsed


class TextAnnotationUpdate(AnnotationBase):
    """TextAnnotationUpdate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id:
    :vartype id: int
    :ivar rectangle:
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles:
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index:
    :vartype page_index: int
    :ivar raw:
    :vartype raw: str
    :ivar confidence: The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: The model's confidence that the text has been classified
     correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: If the document was submitted as an image, this is the
     confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified:
    :vartype is_verified: bool
    :ivar is_client_verified:
    :vartype is_client_verified: bool
    :ivar is_auto_verified:
    :vartype is_auto_verified: bool
    :ivar data_point:
    :vartype data_point: str
    :ivar content_type:
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "rectangles": {"readonly": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        id: Optional[int] = None,
        rectangle: Optional["_models.Rectangle"] = None,
        page_index: Optional[int] = None,
        raw: Optional[str] = None,
        confidence: Optional[float] = None,
        classification_confidence: Optional[float] = None,
        text_extraction_confidence: Optional[float] = None,
        is_verified: Optional[bool] = None,
        is_client_verified: Optional[bool] = None,
        is_auto_verified: Optional[bool] = None,
        data_point: Optional[str] = None,
        content_type: Optional[str] = None,
        parsed: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id:
        :paramtype id: int
        :keyword rectangle:
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword page_index:
        :paramtype page_index: int
        :keyword raw:
        :paramtype raw: str
        :keyword confidence: The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: The model's confidence that the text has been classified
         correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: If the document was submitted as an image, this is the
         confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified:
        :paramtype is_verified: bool
        :keyword is_client_verified:
        :paramtype is_client_verified: bool
        :keyword is_auto_verified:
        :paramtype is_auto_verified: bool
        :keyword data_point:
        :paramtype data_point: str
        :keyword content_type:
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(TextAnnotationUpdate, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            **kwargs,
        )
        self.parsed = parsed


class ThemeConfigPalette(msrest.serialization.Model):
    """ThemeConfigPalette.

    :ivar mode: Known values are: "light", "dark".
    :vartype mode: str or ~affinda.models.ThemeConfigPaletteMode
    :ivar background: Anything.
    :vartype background: any
    :ivar text:
    :vartype text: ~affinda.models.ThemeConfigPaletteText
    :ivar divider:
    :vartype divider: str
    :ivar primary:
    :vartype primary: ~affinda.models.PaletteColorOptions
    :ivar secondary:
    :vartype secondary: ~affinda.models.PaletteColorOptions
    :ivar success:
    :vartype success: ~affinda.models.PaletteColorOptions
    :ivar annotation:
    :vartype annotation: ~affinda.models.PaletteColorOptions
    :ivar error:
    :vartype error: ~affinda.models.PaletteColorOptions
    :ivar info:
    :vartype info: ~affinda.models.PaletteColorOptions
    :ivar warning:
    :vartype warning: ~affinda.models.PaletteColorOptions
    """

    _attribute_map = {
        "mode": {"key": "mode", "type": "str"},
        "background": {"key": "background", "type": "object"},
        "text": {"key": "text", "type": "ThemeConfigPaletteText"},
        "divider": {"key": "divider", "type": "str"},
        "primary": {"key": "primary", "type": "PaletteColorOptions"},
        "secondary": {"key": "secondary", "type": "PaletteColorOptions"},
        "success": {"key": "success", "type": "PaletteColorOptions"},
        "annotation": {"key": "annotation", "type": "PaletteColorOptions"},
        "error": {"key": "error", "type": "PaletteColorOptions"},
        "info": {"key": "info", "type": "PaletteColorOptions"},
        "warning": {"key": "warning", "type": "PaletteColorOptions"},
    }

    def __init__(
        self,
        *,
        mode: Optional[Union[str, "_models.ThemeConfigPaletteMode"]] = None,
        background: Optional[Any] = None,
        text: Optional["_models.ThemeConfigPaletteText"] = None,
        divider: Optional[str] = None,
        primary: Optional["_models.PaletteColorOptions"] = None,
        secondary: Optional["_models.PaletteColorOptions"] = None,
        success: Optional["_models.PaletteColorOptions"] = None,
        annotation: Optional["_models.PaletteColorOptions"] = None,
        error: Optional["_models.PaletteColorOptions"] = None,
        info: Optional["_models.PaletteColorOptions"] = None,
        warning: Optional["_models.PaletteColorOptions"] = None,
        **kwargs,
    ):
        """
        :keyword mode: Known values are: "light", "dark".
        :paramtype mode: str or ~affinda.models.ThemeConfigPaletteMode
        :keyword background: Anything.
        :paramtype background: any
        :keyword text:
        :paramtype text: ~affinda.models.ThemeConfigPaletteText
        :keyword divider:
        :paramtype divider: str
        :keyword primary:
        :paramtype primary: ~affinda.models.PaletteColorOptions
        :keyword secondary:
        :paramtype secondary: ~affinda.models.PaletteColorOptions
        :keyword success:
        :paramtype success: ~affinda.models.PaletteColorOptions
        :keyword annotation:
        :paramtype annotation: ~affinda.models.PaletteColorOptions
        :keyword error:
        :paramtype error: ~affinda.models.PaletteColorOptions
        :keyword info:
        :paramtype info: ~affinda.models.PaletteColorOptions
        :keyword warning:
        :paramtype warning: ~affinda.models.PaletteColorOptions
        """
        super(ThemeConfigPalette, self).__init__(**kwargs)
        self.mode = mode
        self.background = background
        self.text = text
        self.divider = divider
        self.primary = primary
        self.secondary = secondary
        self.success = success
        self.annotation = annotation
        self.error = error
        self.info = info
        self.warning = warning


class ThemeConfigPaletteText(msrest.serialization.Model):
    """ThemeConfigPaletteText.

    :ivar primary:
    :vartype primary: str
    :ivar secondary:
    :vartype secondary: str
    :ivar disabled:
    :vartype disabled: str
    """

    _attribute_map = {
        "primary": {"key": "primary", "type": "str"},
        "secondary": {"key": "secondary", "type": "str"},
        "disabled": {"key": "disabled", "type": "str"},
    }

    def __init__(
        self,
        *,
        primary: Optional[str] = None,
        secondary: Optional[str] = None,
        disabled: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword primary:
        :paramtype primary: str
        :keyword secondary:
        :paramtype secondary: str
        :keyword disabled:
        :paramtype disabled: str
        """
        super(ThemeConfigPaletteText, self).__init__(**kwargs)
        self.primary = primary
        self.secondary = secondary
        self.disabled = disabled


class ThemeConfigTypography(msrest.serialization.Model):
    """ThemeConfigTypography.

    :ivar font_family:
    :vartype font_family: str
    :ivar font_size: Anything.
    :vartype font_size: any
    :ivar font_weight_regular:
    :vartype font_weight_regular: str
    :ivar font_weight_medium:
    :vartype font_weight_medium: str
    :ivar font_weight_bold:
    :vartype font_weight_bold: str
    """

    _attribute_map = {
        "font_family": {"key": "fontFamily", "type": "str"},
        "font_size": {"key": "fontSize", "type": "object"},
        "font_weight_regular": {"key": "fontWeightRegular", "type": "str"},
        "font_weight_medium": {"key": "fontWeightMedium", "type": "str"},
        "font_weight_bold": {"key": "fontWeightBold", "type": "str"},
    }

    def __init__(
        self,
        *,
        font_family: Optional[str] = None,
        font_size: Optional[Any] = None,
        font_weight_regular: Optional[str] = None,
        font_weight_medium: Optional[str] = None,
        font_weight_bold: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword font_family:
        :paramtype font_family: str
        :keyword font_size: Anything.
        :paramtype font_size: any
        :keyword font_weight_regular:
        :paramtype font_weight_regular: str
        :keyword font_weight_medium:
        :paramtype font_weight_medium: str
        :keyword font_weight_bold:
        :paramtype font_weight_bold: str
        """
        super(ThemeConfigTypography, self).__init__(**kwargs)
        self.font_family = font_family
        self.font_size = font_size
        self.font_weight_regular = font_weight_regular
        self.font_weight_medium = font_weight_medium
        self.font_weight_bold = font_weight_bold


class UrlAnnotation(Annotation):
    """UrlAnnotation.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required. Annotation's ID.
    :vartype id: int
    :ivar rectangle: Required. x/y coordinates for the rectangular bounding box containing the
     data.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required. x/y coordinates for the rectangles containing the data. An
     annotation can be contained within multiple rectangles.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar document: Required. Unique identifier for the document.
    :vartype document: str
    :ivar page_index: Required. The page number within the document, starting from 0.
    :vartype page_index: int
    :ivar raw: Required. Raw data extracted from the before any post-processing.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required. Indicates whether the data has been validated, either by a human
     using our validation tool or through auto-validation rules.
    :vartype is_verified: bool
    :ivar is_client_verified: Required. Indicates whether the data has been validated by a human.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required. Indicates whether the data has been auto-validated.
    :vartype is_auto_verified: bool
    :ivar data_point: Data point's identifier.
    :vartype data_point: str
    :ivar field: Field's identifier.
    :vartype field: str
    :ivar content_type: Required. The different data types of annotations. Known values are:
     "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
     "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
     "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
    :vartype content_type: str or ~affinda.models.AnnotationContentType
    :ivar parent: The parent annotation's ID.
    :vartype parent: int
    :ivar parsed:
    :vartype parsed: ~affinda.models.UrlAnnotationParsed
    """

    _validation = {
        "id": {"required": True, "minimum": 1},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "document": {"required": True},
        "page_index": {"required": True, "minimum": 0},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "document": {"key": "document", "type": "str"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "field": {"key": "field", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parent": {"key": "parent", "type": "int"},
        "parsed": {"key": "parsed", "type": "UrlAnnotationParsed"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        document: str,
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        content_type: Union[str, "_models.AnnotationContentType"],
        additional_properties: Optional[Dict[str, Any]] = None,
        data_point: Optional[str] = None,
        field: Optional[str] = None,
        parent: Optional[int] = None,
        parsed: Optional["_models.UrlAnnotationParsed"] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required. Annotation's ID.
        :paramtype id: int
        :keyword rectangle: Required. x/y coordinates for the rectangular bounding box containing the
         data.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required. x/y coordinates for the rectangles containing the data. An
         annotation can be contained within multiple rectangles.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword document: Required. Unique identifier for the document.
        :paramtype document: str
        :keyword page_index: Required. The page number within the document, starting from 0.
        :paramtype page_index: int
        :keyword raw: Required. Raw data extracted from the before any post-processing.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required. Indicates whether the data has been validated, either by a
         human using our validation tool or through auto-validation rules.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required. Indicates whether the data has been validated by a
         human.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required. Indicates whether the data has been auto-validated.
        :paramtype is_auto_verified: bool
        :keyword data_point: Data point's identifier.
        :paramtype data_point: str
        :keyword field: Field's identifier.
        :paramtype field: str
        :keyword content_type: Required. The different data types of annotations. Known values are:
         "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
         "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
         "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
        :paramtype content_type: str or ~affinda.models.AnnotationContentType
        :keyword parent: The parent annotation's ID.
        :paramtype parent: int
        :keyword parsed:
        :paramtype parsed: ~affinda.models.UrlAnnotationParsed
        """
        super(UrlAnnotation, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            document=document,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            field=field,
            content_type=content_type,
            parent=parent,
            **kwargs,
        )
        self.parsed = parsed


class UrlAnnotationParsed(msrest.serialization.Model):
    """UrlAnnotationParsed.

    :ivar url:
    :vartype url: str
    :ivar domain:
    :vartype domain: str
    """

    _attribute_map = {
        "url": {"key": "url", "type": "str"},
        "domain": {"key": "domain", "type": "str"},
    }

    def __init__(self, *, url: Optional[str] = None, domain: Optional[str] = None, **kwargs):
        """
        :keyword url:
        :paramtype url: str
        :keyword domain:
        :paramtype domain: str
        """
        super(UrlAnnotationParsed, self).__init__(**kwargs)
        self.url = url
        self.domain = domain


class UsageByCollection(msrest.serialization.Model):
    """Monthly credits consumption.

    All required parameters must be populated in order to send to Azure.

    :ivar month: Required. Month of the usage.
    :vartype month: str
    :ivar count: Required. Usage count.
    :vartype count: int
    """

    _validation = {
        "month": {"required": True},
        "count": {"required": True},
    }

    _attribute_map = {
        "month": {"key": "month", "type": "str"},
        "count": {"key": "count", "type": "int"},
    }

    def __init__(self, *, month: str, count: int, **kwargs):
        """
        :keyword month: Required. Month of the usage.
        :paramtype month: str
        :keyword count: Required. Usage count.
        :paramtype count: int
        """
        super(UsageByCollection, self).__init__(**kwargs)
        self.month = month
        self.count = count


class UsageByWorkspace(msrest.serialization.Model):
    """Monthly credits consumption.

    All required parameters must be populated in order to send to Azure.

    :ivar month: Required. Month of the usage.
    :vartype month: str
    :ivar count: Required. Usage count.
    :vartype count: int
    """

    _validation = {
        "month": {"required": True},
        "count": {"required": True},
    }

    _attribute_map = {
        "month": {"key": "month", "type": "str"},
        "count": {"key": "count", "type": "int"},
    }

    def __init__(self, *, month: str, count: int, **kwargs):
        """
        :keyword month: Required. Month of the usage.
        :paramtype month: str
        :keyword count: Required. Usage count.
        :paramtype count: int
        """
        super(UsageByWorkspace, self).__init__(**kwargs)
        self.month = month
        self.count = count


class UserNullable(msrest.serialization.Model):
    """UserNullable.

    :ivar id: Uniquely identify a user.
    :vartype id: int
    :ivar name:
    :vartype name: str
    :ivar username:
    :vartype username: str
    :ivar email:
    :vartype email: str
    :ivar avatar: URL of the user's avatar.
    :vartype avatar: str
    """

    _validation = {
        "id": {"minimum": 1},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "name": {"key": "name", "type": "str"},
        "username": {"key": "username", "type": "str"},
        "email": {"key": "email", "type": "str"},
        "avatar": {"key": "avatar", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[int] = None,
        name: Optional[str] = None,
        username: Optional[str] = None,
        email: Optional[str] = None,
        avatar: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword id: Uniquely identify a user.
        :paramtype id: int
        :keyword name:
        :paramtype name: str
        :keyword username:
        :paramtype username: str
        :keyword email:
        :paramtype email: str
        :keyword avatar: URL of the user's avatar.
        :paramtype avatar: str
        """
        super(UserNullable, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.username = username
        self.email = email
        self.avatar = avatar


class ValidationResult(msrest.serialization.Model):
    """Validation result arising from a ValidationRule.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Validation Result's ID.
    :vartype id: int
    :ivar annotations: Required. List of annotation ids that were validated.
    :vartype annotations: list[int]
    :ivar passed: Required. Whether the validation passed or not, null if the validation was not
     applicable.
    :vartype passed: bool
    :ivar rule_slug: Required. The hot-dog case slug of the validation rule that was applied.
    :vartype rule_slug: str
    :ivar message: Required. Message explaining why the validation failed.
    :vartype message: str
    :ivar document: Required. Unique identifier for the document.
    :vartype document: str
    """

    _validation = {
        "id": {"required": True, "minimum": 1},
        "annotations": {"required": True},
        "passed": {"required": True},
        "rule_slug": {"required": True, "pattern": r"^[a-z0-9][a-z0-9-]*[a-z0-9]$"},
        "message": {"required": True},
        "document": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "annotations": {"key": "annotations", "type": "[int]"},
        "passed": {"key": "passed", "type": "bool"},
        "rule_slug": {"key": "ruleSlug", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "document": {"key": "document", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        annotations: List[int],
        passed: bool,
        rule_slug: str,
        message: str,
        document: str,
        **kwargs,
    ):
        """
        :keyword id: Required. Validation Result's ID.
        :paramtype id: int
        :keyword annotations: Required. List of annotation ids that were validated.
        :paramtype annotations: list[int]
        :keyword passed: Required. Whether the validation passed or not, null if the validation was not
         applicable.
        :paramtype passed: bool
        :keyword rule_slug: Required. The hot-dog case slug of the validation rule that was applied.
        :paramtype rule_slug: str
        :keyword message: Required. Message explaining why the validation failed.
        :paramtype message: str
        :keyword document: Required. Unique identifier for the document.
        :paramtype document: str
        """
        super(ValidationResult, self).__init__(**kwargs)
        self.id = id
        self.annotations = annotations
        self.passed = passed
        self.rule_slug = rule_slug
        self.message = message
        self.document = document


class ValidationResultCreate(msrest.serialization.Model):
    """ValidationResultCreate.

    All required parameters must be populated in order to send to Azure.

    :ivar annotations: Required. List of annotation ids that were validated.
    :vartype annotations: list[int]
    :ivar passed: Whether the validation passed or not, null if the validation was not applicable.
    :vartype passed: bool
    :ivar rule_slug: Required. The hot-dog case slug of the validation rule that was applied.
    :vartype rule_slug: str
    :ivar message: Required. Message explaining why the validation failed.
    :vartype message: str
    :ivar document: Required. Unique identifier for the document.
    :vartype document: str
    """

    _validation = {
        "annotations": {"required": True},
        "rule_slug": {"required": True, "pattern": r"^[a-z0-9][a-z0-9-]*[a-z0-9]$"},
        "message": {"required": True},
        "document": {"required": True},
    }

    _attribute_map = {
        "annotations": {"key": "annotations", "type": "[int]"},
        "passed": {"key": "passed", "type": "bool"},
        "rule_slug": {"key": "ruleSlug", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "document": {"key": "document", "type": "str"},
    }

    def __init__(
        self,
        *,
        annotations: List[int],
        rule_slug: str,
        message: str,
        document: str,
        passed: Optional[bool] = None,
        **kwargs,
    ):
        """
        :keyword annotations: Required. List of annotation ids that were validated.
        :paramtype annotations: list[int]
        :keyword passed: Whether the validation passed or not, null if the validation was not
         applicable.
        :paramtype passed: bool
        :keyword rule_slug: Required. The hot-dog case slug of the validation rule that was applied.
        :paramtype rule_slug: str
        :keyword message: Required. Message explaining why the validation failed.
        :paramtype message: str
        :keyword document: Required. Unique identifier for the document.
        :paramtype document: str
        """
        super(ValidationResultCreate, self).__init__(**kwargs)
        self.annotations = annotations
        self.passed = passed
        self.rule_slug = rule_slug
        self.message = message
        self.document = document


class ValidationResultUpdate(msrest.serialization.Model):
    """ValidationResultUpdate.

    :ivar annotations: List of annotation ids that were validated.
    :vartype annotations: list[int]
    :ivar passed: Whether the validation passed or not, null if the validation was not applicable.
    :vartype passed: bool
    :ivar rule_slug: The hot-dog case slug of the validation rule that was applied.
    :vartype rule_slug: str
    :ivar message: Message explaining why the validation failed.
    :vartype message: str
    :ivar document: Unique identifier for the document.
    :vartype document: str
    """

    _validation = {
        "rule_slug": {"pattern": r"^[a-z0-9][a-z0-9-]*[a-z0-9]$"},
    }

    _attribute_map = {
        "annotations": {"key": "annotations", "type": "[int]"},
        "passed": {"key": "passed", "type": "bool"},
        "rule_slug": {"key": "ruleSlug", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "document": {"key": "document", "type": "str"},
    }

    def __init__(
        self,
        *,
        annotations: Optional[List[int]] = None,
        passed: Optional[bool] = None,
        rule_slug: Optional[str] = None,
        message: Optional[str] = None,
        document: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword annotations: List of annotation ids that were validated.
        :paramtype annotations: list[int]
        :keyword passed: Whether the validation passed or not, null if the validation was not
         applicable.
        :paramtype passed: bool
        :keyword rule_slug: The hot-dog case slug of the validation rule that was applied.
        :paramtype rule_slug: str
        :keyword message: Message explaining why the validation failed.
        :paramtype message: str
        :keyword document: Unique identifier for the document.
        :paramtype document: str
        """
        super(ValidationResultUpdate, self).__init__(**kwargs)
        self.annotations = annotations
        self.passed = passed
        self.rule_slug = rule_slug
        self.message = message
        self.document = document


class ValidationRule(msrest.serialization.Model):
    """A validation rule for a collection.

    All required parameters must be populated in order to send to Azure.

    :ivar slug: Required. The slug of the validation rule, in lowercase snake_case.
    :vartype slug: str
    :ivar data_points: Required. The data point identifier that this validation rule applies to,
     can be an empty list if the rule doens't use any data points as sources.
    :vartype data_points: list[str]
    """

    _validation = {
        "slug": {"required": True, "pattern": r"^[a-z0-9_]+$"},
        "data_points": {"required": True},
    }

    _attribute_map = {
        "slug": {"key": "slug", "type": "str"},
        "data_points": {"key": "dataPoints", "type": "[str]"},
    }

    def __init__(self, *, slug: str, data_points: List[str], **kwargs):
        """
        :keyword slug: Required. The slug of the validation rule, in lowercase snake_case.
        :paramtype slug: str
        :keyword data_points: Required. The data point identifier that this validation rule applies to,
         can be an empty list if the rule doens't use any data points as sources.
        :paramtype data_points: list[str]
        """
        super(ValidationRule, self).__init__(**kwargs)
        self.slug = slug
        self.data_points = data_points


class ValidationToolConfig(msrest.serialization.Model):
    """Configuration of the embeddable validation tool.

    :ivar theme:
    :vartype theme: ~affinda.models.ThemeConfig
    :ivar hide_actions: Hide the confirm document button and other actions.
    :vartype hide_actions: bool
    :ivar hide_collection: Hide the collection selector.
    :vartype hide_collection: bool
    :ivar hide_edit_pages: Hide the edit pages button.
    :vartype hide_edit_pages: bool
    :ivar hide_export: Hide the export menu.
    :vartype hide_export: bool
    :ivar hide_filename: Hide the filename input.
    :vartype hide_filename: bool
    :ivar hide_reject: Hide the reject document button.
    :vartype hide_reject: bool
    :ivar hide_reparse: Hide the reparse button.
    :vartype hide_reparse: bool
    :ivar hide_run_ocr: Hide the run OCR button.
    :vartype hide_run_ocr: bool
    :ivar hide_tags: Hide the tags editor.
    :vartype hide_tags: bool
    :ivar hide_warnings: Hide the warnings panel.
    :vartype hide_warnings: bool
    :ivar restrict_document_splitting: Disable the page editor after a document has been split
     once.
    :vartype restrict_document_splitting: bool
    :ivar disable_currency_formatting: Disable currency formatting of decimals values.
    :vartype disable_currency_formatting: bool
    :ivar disable_edit_document_metadata: Disable editing document metadata. Makes the collection
     selector, filename input and tags editor read only.
    :vartype disable_edit_document_metadata: bool
    """

    _attribute_map = {
        "theme": {"key": "theme", "type": "ThemeConfig"},
        "hide_actions": {"key": "hideActions", "type": "bool"},
        "hide_collection": {"key": "hideCollection", "type": "bool"},
        "hide_edit_pages": {"key": "hideEditPages", "type": "bool"},
        "hide_export": {"key": "hideExport", "type": "bool"},
        "hide_filename": {"key": "hideFilename", "type": "bool"},
        "hide_reject": {"key": "hideReject", "type": "bool"},
        "hide_reparse": {"key": "hideReparse", "type": "bool"},
        "hide_run_ocr": {"key": "hideRunOcr", "type": "bool"},
        "hide_tags": {"key": "hideTags", "type": "bool"},
        "hide_warnings": {"key": "hideWarnings", "type": "bool"},
        "restrict_document_splitting": {"key": "restrictDocumentSplitting", "type": "bool"},
        "disable_currency_formatting": {"key": "disableCurrencyFormatting", "type": "bool"},
        "disable_edit_document_metadata": {"key": "disableEditDocumentMetadata", "type": "bool"},
    }

    def __init__(
        self,
        *,
        theme: Optional["_models.ThemeConfig"] = None,
        hide_actions: Optional[bool] = None,
        hide_collection: Optional[bool] = None,
        hide_edit_pages: Optional[bool] = None,
        hide_export: Optional[bool] = None,
        hide_filename: Optional[bool] = None,
        hide_reject: Optional[bool] = None,
        hide_reparse: Optional[bool] = None,
        hide_run_ocr: Optional[bool] = None,
        hide_tags: Optional[bool] = None,
        hide_warnings: Optional[bool] = None,
        restrict_document_splitting: Optional[bool] = None,
        disable_currency_formatting: Optional[bool] = None,
        disable_edit_document_metadata: Optional[bool] = None,
        **kwargs,
    ):
        """
        :keyword theme:
        :paramtype theme: ~affinda.models.ThemeConfig
        :keyword hide_actions: Hide the confirm document button and other actions.
        :paramtype hide_actions: bool
        :keyword hide_collection: Hide the collection selector.
        :paramtype hide_collection: bool
        :keyword hide_edit_pages: Hide the edit pages button.
        :paramtype hide_edit_pages: bool
        :keyword hide_export: Hide the export menu.
        :paramtype hide_export: bool
        :keyword hide_filename: Hide the filename input.
        :paramtype hide_filename: bool
        :keyword hide_reject: Hide the reject document button.
        :paramtype hide_reject: bool
        :keyword hide_reparse: Hide the reparse button.
        :paramtype hide_reparse: bool
        :keyword hide_run_ocr: Hide the run OCR button.
        :paramtype hide_run_ocr: bool
        :keyword hide_tags: Hide the tags editor.
        :paramtype hide_tags: bool
        :keyword hide_warnings: Hide the warnings panel.
        :paramtype hide_warnings: bool
        :keyword restrict_document_splitting: Disable the page editor after a document has been split
         once.
        :paramtype restrict_document_splitting: bool
        :keyword disable_currency_formatting: Disable currency formatting of decimals values.
        :paramtype disable_currency_formatting: bool
        :keyword disable_edit_document_metadata: Disable editing document metadata. Makes the
         collection selector, filename input and tags editor read only.
        :paramtype disable_edit_document_metadata: bool
        """
        super(ValidationToolConfig, self).__init__(**kwargs)
        self.theme = theme
        self.hide_actions = hide_actions
        self.hide_collection = hide_collection
        self.hide_edit_pages = hide_edit_pages
        self.hide_export = hide_export
        self.hide_filename = hide_filename
        self.hide_reject = hide_reject
        self.hide_reparse = hide_reparse
        self.hide_run_ocr = hide_run_ocr
        self.hide_tags = hide_tags
        self.hide_warnings = hide_warnings
        self.restrict_document_splitting = restrict_document_splitting
        self.disable_currency_formatting = disable_currency_formatting
        self.disable_edit_document_metadata = disable_edit_document_metadata


class Workspace(msrest.serialization.Model):
    """Workspace.

    All required parameters must be populated in order to send to Azure.

    :ivar identifier: Required. Uniquely identify a workspace.
    :vartype identifier: str
    :ivar organization:
    :vartype organization: ~affinda.models.Organization
    :ivar name:
    :vartype name: str
    :ivar visibility: Visibility "organization" means everyone in the organization can access the
     workspace. Visibility "private" means only people explicitly added can access the workspace.
     Known values are: "organization", "private".
    :vartype visibility: str or ~affinda.models.WorkspaceVisibility
    :ivar collections:
    :vartype collections: list[~affinda.models.WorkspaceCollectionsItem]
    :ivar reject_invalid_documents: If true, the uploaded document will be rejected if it's of the
     wrong document type, or if its document type cannot be determined. No credits will be consumed.
    :vartype reject_invalid_documents: bool
    :ivar reject_duplicates: If "true", parsing will fail when the uploaded document is duplicate
     of an existing document, no credits will be consumed. If "false", will parse the document
     normally whether its a duplicate or not. If not provided, will fallback to the workspace
     settings.
    :vartype reject_duplicates: bool
    :ivar members:
    :vartype members: list[~affinda.models.User]
    :ivar unvalidated_docs_count: Number of unvalidated documents in the workspace.
    :vartype unvalidated_docs_count: int
    :ivar confirmed_docs_count: Number of validated documents in the workspace.
    :vartype confirmed_docs_count: int
    :ivar ingest_email: When you send email to this address, any document attached in the body will
     be uploaded to this workspace.
    :vartype ingest_email: str
    :ivar whitelist_ingest_addresses: If specified, only emails from these addresses will be
     ingested for parsing. Wild cards are allowed, e.g. "*@eyefind.info".
    :vartype whitelist_ingest_addresses: list[str]
    :ivar document_splitter:
    :vartype document_splitter: ~affinda.models.WorkspaceDocumentSplitter
    """

    _validation = {
        "identifier": {"required": True},
        "unvalidated_docs_count": {"minimum": 0},
        "confirmed_docs_count": {"minimum": 0},
    }

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "organization": {"key": "organization", "type": "Organization"},
        "name": {"key": "name", "type": "str"},
        "visibility": {"key": "visibility", "type": "str"},
        "collections": {"key": "collections", "type": "[WorkspaceCollectionsItem]"},
        "reject_invalid_documents": {"key": "rejectInvalidDocuments", "type": "bool"},
        "reject_duplicates": {"key": "rejectDuplicates", "type": "bool"},
        "members": {"key": "members", "type": "[User]"},
        "unvalidated_docs_count": {"key": "unvalidatedDocsCount", "type": "int"},
        "confirmed_docs_count": {"key": "confirmedDocsCount", "type": "int"},
        "ingest_email": {"key": "ingestEmail", "type": "str"},
        "whitelist_ingest_addresses": {"key": "whitelistIngestAddresses", "type": "[str]"},
        "document_splitter": {"key": "documentSplitter", "type": "WorkspaceDocumentSplitter"},
    }

    def __init__(
        self,
        *,
        identifier: str,
        organization: Optional["_models.Organization"] = None,
        name: Optional[str] = None,
        visibility: Optional[Union[str, "_models.WorkspaceVisibility"]] = None,
        collections: Optional[List["_models.WorkspaceCollectionsItem"]] = None,
        reject_invalid_documents: Optional[bool] = None,
        reject_duplicates: Optional[bool] = None,
        members: Optional[List["_models.User"]] = None,
        unvalidated_docs_count: Optional[int] = None,
        confirmed_docs_count: Optional[int] = None,
        ingest_email: Optional[str] = None,
        whitelist_ingest_addresses: Optional[List[str]] = None,
        document_splitter: Optional["_models.WorkspaceDocumentSplitter"] = None,
        **kwargs,
    ):
        """
        :keyword identifier: Required. Uniquely identify a workspace.
        :paramtype identifier: str
        :keyword organization:
        :paramtype organization: ~affinda.models.Organization
        :keyword name:
        :paramtype name: str
        :keyword visibility: Visibility "organization" means everyone in the organization can access
         the workspace. Visibility "private" means only people explicitly added can access the
         workspace. Known values are: "organization", "private".
        :paramtype visibility: str or ~affinda.models.WorkspaceVisibility
        :keyword collections:
        :paramtype collections: list[~affinda.models.WorkspaceCollectionsItem]
        :keyword reject_invalid_documents: If true, the uploaded document will be rejected if it's of
         the wrong document type, or if its document type cannot be determined. No credits will be
         consumed.
        :paramtype reject_invalid_documents: bool
        :keyword reject_duplicates: If "true", parsing will fail when the uploaded document is
         duplicate of an existing document, no credits will be consumed. If "false", will parse the
         document normally whether its a duplicate or not. If not provided, will fallback to the
         workspace settings.
        :paramtype reject_duplicates: bool
        :keyword members:
        :paramtype members: list[~affinda.models.User]
        :keyword unvalidated_docs_count: Number of unvalidated documents in the workspace.
        :paramtype unvalidated_docs_count: int
        :keyword confirmed_docs_count: Number of validated documents in the workspace.
        :paramtype confirmed_docs_count: int
        :keyword ingest_email: When you send email to this address, any document attached in the body
         will be uploaded to this workspace.
        :paramtype ingest_email: str
        :keyword whitelist_ingest_addresses: If specified, only emails from these addresses will be
         ingested for parsing. Wild cards are allowed, e.g. "*@eyefind.info".
        :paramtype whitelist_ingest_addresses: list[str]
        :keyword document_splitter:
        :paramtype document_splitter: ~affinda.models.WorkspaceDocumentSplitter
        """
        super(Workspace, self).__init__(**kwargs)
        self.identifier = identifier
        self.organization = organization
        self.name = name
        self.visibility = visibility
        self.collections = collections
        self.reject_invalid_documents = reject_invalid_documents
        self.reject_duplicates = reject_duplicates
        self.members = members
        self.unvalidated_docs_count = unvalidated_docs_count
        self.confirmed_docs_count = confirmed_docs_count
        self.ingest_email = ingest_email
        self.whitelist_ingest_addresses = whitelist_ingest_addresses
        self.document_splitter = document_splitter


class WorkspaceCollectionsItem(msrest.serialization.Model):
    """WorkspaceCollectionsItem.

    All required parameters must be populated in order to send to Azure.

    :ivar identifier: Required. Uniquely identify a collection.
    :vartype identifier: str
    :ivar name: Required.
    :vartype name: str
    :ivar extractor: Required.
    :vartype extractor: ~affinda.models.WorkspaceCollectionsItemExtractor
    :ivar unvalidated_docs_count: Number of unvalidated documents in the collection.
    :vartype unvalidated_docs_count: int
    :ivar confirmed_docs_count: Number of validated documents in the collection.
    :vartype confirmed_docs_count: int
    """

    _validation = {
        "identifier": {"required": True},
        "name": {"required": True},
        "extractor": {"required": True},
        "unvalidated_docs_count": {"minimum": 0},
        "confirmed_docs_count": {"minimum": 0},
    }

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "extractor": {"key": "extractor", "type": "WorkspaceCollectionsItemExtractor"},
        "unvalidated_docs_count": {"key": "unvalidatedDocsCount", "type": "int"},
        "confirmed_docs_count": {"key": "confirmedDocsCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        identifier: str,
        name: str,
        extractor: "_models.WorkspaceCollectionsItemExtractor",
        unvalidated_docs_count: Optional[int] = None,
        confirmed_docs_count: Optional[int] = None,
        **kwargs,
    ):
        """
        :keyword identifier: Required. Uniquely identify a collection.
        :paramtype identifier: str
        :keyword name: Required.
        :paramtype name: str
        :keyword extractor: Required.
        :paramtype extractor: ~affinda.models.WorkspaceCollectionsItemExtractor
        :keyword unvalidated_docs_count: Number of unvalidated documents in the collection.
        :paramtype unvalidated_docs_count: int
        :keyword confirmed_docs_count: Number of validated documents in the collection.
        :paramtype confirmed_docs_count: int
        """
        super(WorkspaceCollectionsItem, self).__init__(**kwargs)
        self.identifier = identifier
        self.name = name
        self.extractor = extractor
        self.unvalidated_docs_count = unvalidated_docs_count
        self.confirmed_docs_count = confirmed_docs_count


class WorkspaceCollectionsItemExtractor(msrest.serialization.Model):
    """WorkspaceCollectionsItemExtractor.

    All required parameters must be populated in order to send to Azure.

    :ivar identifier: Required. Uniquely identify an extractor.
    :vartype identifier: str
    :ivar name: Required.
    :vartype name: str
    :ivar name_plural: Required.
    :vartype name_plural: str
    :ivar base_extractor:
    :vartype base_extractor: ~affinda.models.BaseExtractor
    :ivar category:
    :vartype category: str
    :ivar validatable: Required.
    :vartype validatable: bool
    :ivar is_custom:
    :vartype is_custom: bool
    :ivar created_dt:
    :vartype created_dt: ~datetime.datetime
    """

    _validation = {
        "identifier": {"required": True},
        "name": {"required": True},
        "name_plural": {"required": True},
        "validatable": {"required": True},
    }

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "name_plural": {"key": "namePlural", "type": "str"},
        "base_extractor": {"key": "baseExtractor", "type": "BaseExtractor"},
        "category": {"key": "category", "type": "str"},
        "validatable": {"key": "validatable", "type": "bool"},
        "is_custom": {"key": "isCustom", "type": "bool"},
        "created_dt": {"key": "createdDt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        identifier: str,
        name: str,
        name_plural: str,
        validatable: bool,
        base_extractor: Optional["_models.BaseExtractor"] = None,
        category: Optional[str] = None,
        is_custom: Optional[bool] = None,
        created_dt: Optional[datetime.datetime] = None,
        **kwargs,
    ):
        """
        :keyword identifier: Required. Uniquely identify an extractor.
        :paramtype identifier: str
        :keyword name: Required.
        :paramtype name: str
        :keyword name_plural: Required.
        :paramtype name_plural: str
        :keyword base_extractor:
        :paramtype base_extractor: ~affinda.models.BaseExtractor
        :keyword category:
        :paramtype category: str
        :keyword validatable: Required.
        :paramtype validatable: bool
        :keyword is_custom:
        :paramtype is_custom: bool
        :keyword created_dt:
        :paramtype created_dt: ~datetime.datetime
        """
        super(WorkspaceCollectionsItemExtractor, self).__init__(**kwargs)
        self.identifier = identifier
        self.name = name
        self.name_plural = name_plural
        self.base_extractor = base_extractor
        self.category = category
        self.validatable = validatable
        self.is_custom = is_custom
        self.created_dt = created_dt


class WorkspaceCreate(msrest.serialization.Model):
    """WorkspaceCreate.

    All required parameters must be populated in order to send to Azure.

    :ivar organization: Required. Uniquely identify an organization.
    :vartype organization: str
    :ivar name: Required.
    :vartype name: str
    :ivar visibility: Visibility "organization" means everyone in the organization can access the
     workspace. Visibility "private" means only people explicitly added can access the workspace.
     Known values are: "organization", "private".
    :vartype visibility: str or ~affinda.models.WorkspaceVisibility
    :ivar reject_invalid_documents: If true, the uploaded document will be rejected if it's of the
     wrong document type, or if its document type cannot be determined. No credits will be consumed.
    :vartype reject_invalid_documents: bool
    :ivar reject_duplicates: If "true", parsing will fail when the uploaded document is duplicate
     of an existing document, no credits will be consumed. If "false", will parse the document
     normally whether its a duplicate or not. If not provided, will fallback to the workspace
     settings.
    :vartype reject_duplicates: bool
    :ivar whitelist_ingest_addresses: If specified, only emails from these addresses will be
     ingested for parsing. Wild cards are allowed, e.g. "*@eyefind.info".
    :vartype whitelist_ingest_addresses: list[str]
    :ivar document_splitter: Uniquely identify a document splitter.
    :vartype document_splitter: str
    """

    _validation = {
        "organization": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "organization": {"key": "organization", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "visibility": {"key": "visibility", "type": "str"},
        "reject_invalid_documents": {"key": "rejectInvalidDocuments", "type": "bool"},
        "reject_duplicates": {"key": "rejectDuplicates", "type": "bool"},
        "whitelist_ingest_addresses": {"key": "whitelistIngestAddresses", "type": "[str]"},
        "document_splitter": {"key": "documentSplitter", "type": "str"},
    }

    def __init__(
        self,
        *,
        organization: str,
        name: str,
        visibility: Optional[Union[str, "_models.WorkspaceVisibility"]] = None,
        reject_invalid_documents: Optional[bool] = None,
        reject_duplicates: Optional[bool] = None,
        whitelist_ingest_addresses: Optional[List[str]] = None,
        document_splitter: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword organization: Required. Uniquely identify an organization.
        :paramtype organization: str
        :keyword name: Required.
        :paramtype name: str
        :keyword visibility: Visibility "organization" means everyone in the organization can access
         the workspace. Visibility "private" means only people explicitly added can access the
         workspace. Known values are: "organization", "private".
        :paramtype visibility: str or ~affinda.models.WorkspaceVisibility
        :keyword reject_invalid_documents: If true, the uploaded document will be rejected if it's of
         the wrong document type, or if its document type cannot be determined. No credits will be
         consumed.
        :paramtype reject_invalid_documents: bool
        :keyword reject_duplicates: If "true", parsing will fail when the uploaded document is
         duplicate of an existing document, no credits will be consumed. If "false", will parse the
         document normally whether its a duplicate or not. If not provided, will fallback to the
         workspace settings.
        :paramtype reject_duplicates: bool
        :keyword whitelist_ingest_addresses: If specified, only emails from these addresses will be
         ingested for parsing. Wild cards are allowed, e.g. "*@eyefind.info".
        :paramtype whitelist_ingest_addresses: list[str]
        :keyword document_splitter: Uniquely identify a document splitter.
        :paramtype document_splitter: str
        """
        super(WorkspaceCreate, self).__init__(**kwargs)
        self.organization = organization
        self.name = name
        self.visibility = visibility
        self.reject_invalid_documents = reject_invalid_documents
        self.reject_duplicates = reject_duplicates
        self.whitelist_ingest_addresses = whitelist_ingest_addresses
        self.document_splitter = document_splitter


class WorkspaceDocumentSplitter(msrest.serialization.Model):
    """WorkspaceDocumentSplitter.

    All required parameters must be populated in order to send to Azure.

    :ivar identifier: Required. Uniquely identify a document splitter.
    :vartype identifier: str
    :ivar name: Required.
    :vartype name: str
    """

    _validation = {
        "identifier": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, identifier: str, name: str, **kwargs):
        """
        :keyword identifier: Required. Uniquely identify a document splitter.
        :paramtype identifier: str
        :keyword name: Required.
        :paramtype name: str
        """
        super(WorkspaceDocumentSplitter, self).__init__(**kwargs)
        self.identifier = identifier
        self.name = name


class WorkspaceMembership(msrest.serialization.Model):
    """WorkspaceMembership.

    :ivar identifier: Uniquely identify a membership.
    :vartype identifier: str
    :ivar workspace: Uniquely identify a workspace.
    :vartype workspace: str
    :ivar user:
    :vartype user: ~affinda.models.User
    """

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "workspace": {"key": "workspace", "type": "str"},
        "user": {"key": "user", "type": "User"},
    }

    def __init__(
        self,
        *,
        identifier: Optional[str] = None,
        workspace: Optional[str] = None,
        user: Optional["_models.User"] = None,
        **kwargs,
    ):
        """
        :keyword identifier: Uniquely identify a membership.
        :paramtype identifier: str
        :keyword workspace: Uniquely identify a workspace.
        :paramtype workspace: str
        :keyword user:
        :paramtype user: ~affinda.models.User
        """
        super(WorkspaceMembership, self).__init__(**kwargs)
        self.identifier = identifier
        self.workspace = workspace
        self.user = user


class WorkspaceMembershipCreate(msrest.serialization.Model):
    """WorkspaceMembershipCreate.

    :ivar workspace: Uniquely identify a workspace.
    :vartype workspace: str
    :ivar user: Uniquely identify a user.
    :vartype user: int
    """

    _validation = {
        "user": {"minimum": 1},
    }

    _attribute_map = {
        "workspace": {"key": "workspace", "type": "str"},
        "user": {"key": "user", "type": "int"},
    }

    def __init__(self, *, workspace: Optional[str] = None, user: Optional[int] = None, **kwargs):
        """
        :keyword workspace: Uniquely identify a workspace.
        :paramtype workspace: str
        :keyword user: Uniquely identify a user.
        :paramtype user: int
        """
        super(WorkspaceMembershipCreate, self).__init__(**kwargs)
        self.workspace = workspace
        self.user = user


class WorkspaceUpdate(msrest.serialization.Model):
    """WorkspaceUpdate.

    :ivar name:
    :vartype name: str
    :ivar visibility: Visibility "organization" means everyone in the organization can access the
     workspace. Visibility "private" means only people explicitly added can access the workspace.
     Known values are: "organization", "private".
    :vartype visibility: str or ~affinda.models.WorkspaceVisibility
    :ivar reject_invalid_documents: If true, the uploaded document will be rejected if it's of the
     wrong document type, or if its document type cannot be determined. No credits will be consumed.
    :vartype reject_invalid_documents: bool
    :ivar reject_duplicates: If "true", parsing will fail when the uploaded document is duplicate
     of an existing document, no credits will be consumed. If "false", will parse the document
     normally whether its a duplicate or not. If not provided, will fallback to the workspace
     settings.
    :vartype reject_duplicates: bool
    :ivar whitelist_ingest_addresses: If specified, only emails from these addresses will be
     ingested for parsing. Wild cards are allowed, e.g. "*@eyefind.info".
    :vartype whitelist_ingest_addresses: list[str]
    :ivar document_splitter: Uniquely identify a document splitter.
    :vartype document_splitter: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "visibility": {"key": "visibility", "type": "str"},
        "reject_invalid_documents": {"key": "rejectInvalidDocuments", "type": "bool"},
        "reject_duplicates": {"key": "rejectDuplicates", "type": "bool"},
        "whitelist_ingest_addresses": {"key": "whitelistIngestAddresses", "type": "[str]"},
        "document_splitter": {"key": "documentSplitter", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        visibility: Optional[Union[str, "_models.WorkspaceVisibility"]] = None,
        reject_invalid_documents: Optional[bool] = None,
        reject_duplicates: Optional[bool] = None,
        whitelist_ingest_addresses: Optional[List[str]] = None,
        document_splitter: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword visibility: Visibility "organization" means everyone in the organization can access
         the workspace. Visibility "private" means only people explicitly added can access the
         workspace. Known values are: "organization", "private".
        :paramtype visibility: str or ~affinda.models.WorkspaceVisibility
        :keyword reject_invalid_documents: If true, the uploaded document will be rejected if it's of
         the wrong document type, or if its document type cannot be determined. No credits will be
         consumed.
        :paramtype reject_invalid_documents: bool
        :keyword reject_duplicates: If "true", parsing will fail when the uploaded document is
         duplicate of an existing document, no credits will be consumed. If "false", will parse the
         document normally whether its a duplicate or not. If not provided, will fallback to the
         workspace settings.
        :paramtype reject_duplicates: bool
        :keyword whitelist_ingest_addresses: If specified, only emails from these addresses will be
         ingested for parsing. Wild cards are allowed, e.g. "*@eyefind.info".
        :paramtype whitelist_ingest_addresses: list[str]
        :keyword document_splitter: Uniquely identify a document splitter.
        :paramtype document_splitter: str
        """
        super(WorkspaceUpdate, self).__init__(**kwargs)
        self.name = name
        self.visibility = visibility
        self.reject_invalid_documents = reject_invalid_documents
        self.reject_duplicates = reject_duplicates
        self.whitelist_ingest_addresses = whitelist_ingest_addresses
        self.document_splitter = document_splitter


class YearsExperienceAnnotation(Annotation):
    """YearsExperienceAnnotation.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required. Annotation's ID.
    :vartype id: int
    :ivar rectangle: Required. x/y coordinates for the rectangular bounding box containing the
     data.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required. x/y coordinates for the rectangles containing the data. An
     annotation can be contained within multiple rectangles.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar document: Required. Unique identifier for the document.
    :vartype document: str
    :ivar page_index: Required. The page number within the document, starting from 0.
    :vartype page_index: int
    :ivar raw: Required. Raw data extracted from the before any post-processing.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required. Indicates whether the data has been validated, either by a human
     using our validation tool or through auto-validation rules.
    :vartype is_verified: bool
    :ivar is_client_verified: Required. Indicates whether the data has been validated by a human.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required. Indicates whether the data has been auto-validated.
    :vartype is_auto_verified: bool
    :ivar data_point: Data point's identifier.
    :vartype data_point: str
    :ivar field: Field's identifier.
    :vartype field: str
    :ivar content_type: Required. The different data types of annotations. Known values are:
     "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
     "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
     "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
    :vartype content_type: str or ~affinda.models.AnnotationContentType
    :ivar parent: The parent annotation's ID.
    :vartype parent: int
    :ivar parsed: Years of experience range.
    :vartype parsed: ~affinda.models.YearsExperienceAnnotationParsed
    """

    _validation = {
        "id": {"required": True, "minimum": 1},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "document": {"required": True},
        "page_index": {"required": True, "minimum": 0},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "document": {"key": "document", "type": "str"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "field": {"key": "field", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parent": {"key": "parent", "type": "int"},
        "parsed": {"key": "parsed", "type": "YearsExperienceAnnotationParsed"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        document: str,
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        content_type: Union[str, "_models.AnnotationContentType"],
        additional_properties: Optional[Dict[str, Any]] = None,
        data_point: Optional[str] = None,
        field: Optional[str] = None,
        parent: Optional[int] = None,
        parsed: Optional["_models.YearsExperienceAnnotationParsed"] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required. Annotation's ID.
        :paramtype id: int
        :keyword rectangle: Required. x/y coordinates for the rectangular bounding box containing the
         data.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required. x/y coordinates for the rectangles containing the data. An
         annotation can be contained within multiple rectangles.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword document: Required. Unique identifier for the document.
        :paramtype document: str
        :keyword page_index: Required. The page number within the document, starting from 0.
        :paramtype page_index: int
        :keyword raw: Required. Raw data extracted from the before any post-processing.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required. Indicates whether the data has been validated, either by a
         human using our validation tool or through auto-validation rules.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required. Indicates whether the data has been validated by a
         human.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required. Indicates whether the data has been auto-validated.
        :paramtype is_auto_verified: bool
        :keyword data_point: Data point's identifier.
        :paramtype data_point: str
        :keyword field: Field's identifier.
        :paramtype field: str
        :keyword content_type: Required. The different data types of annotations. Known values are:
         "text", "integer", "float", "decimal", "date", "datetime", "daterange", "boolean", "enum",
         "location", "phonenumber", "json", "table", "expectedremuneration", "jobtitle", "language",
         "skill", "yearsexperience", "group", "table_deprecated", "url", "image", "docclf".
        :paramtype content_type: str or ~affinda.models.AnnotationContentType
        :keyword parent: The parent annotation's ID.
        :paramtype parent: int
        :keyword parsed: Years of experience range.
        :paramtype parsed: ~affinda.models.YearsExperienceAnnotationParsed
        """
        super(YearsExperienceAnnotation, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            document=document,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            field=field,
            content_type=content_type,
            parent=parent,
            **kwargs,
        )
        self.parsed = parsed


class YearsExperienceAnnotationParsed(msrest.serialization.Model):
    """Years of experience range.

    :ivar minimum: Minimum years of experience.
    :vartype minimum: float
    :ivar maximum: Maximum years of experience.
    :vartype maximum: float
    """

    _attribute_map = {
        "minimum": {"key": "minimum", "type": "float"},
        "maximum": {"key": "maximum", "type": "float"},
    }

    def __init__(
        self, *, minimum: Optional[float] = None, maximum: Optional[float] = None, **kwargs
    ):
        """
        :keyword minimum: Minimum years of experience.
        :paramtype minimum: float
        :keyword maximum: Maximum years of experience.
        :paramtype maximum: float
        """
        super(YearsExperienceAnnotationParsed, self).__init__(**kwargs)
        self.minimum = minimum
        self.maximum = maximum


class YearsExperienceAnnotationUpdate(AnnotationBase):
    """YearsExperienceAnnotationUpdate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id:
    :vartype id: int
    :ivar rectangle:
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles:
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index:
    :vartype page_index: int
    :ivar raw:
    :vartype raw: str
    :ivar confidence: The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: The model's confidence that the text has been classified
     correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: If the document was submitted as an image, this is the
     confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified:
    :vartype is_verified: bool
    :ivar is_client_verified:
    :vartype is_client_verified: bool
    :ivar is_auto_verified:
    :vartype is_auto_verified: bool
    :ivar data_point:
    :vartype data_point: str
    :ivar content_type:
    :vartype content_type: str
    :ivar parsed: Years of experience range.
    :vartype parsed: ~affinda.models.YearsExperienceAnnotationUpdateParsed
    """

    _validation = {
        "rectangles": {"readonly": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "YearsExperienceAnnotationUpdateParsed"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        id: Optional[int] = None,
        rectangle: Optional["_models.Rectangle"] = None,
        page_index: Optional[int] = None,
        raw: Optional[str] = None,
        confidence: Optional[float] = None,
        classification_confidence: Optional[float] = None,
        text_extraction_confidence: Optional[float] = None,
        is_verified: Optional[bool] = None,
        is_client_verified: Optional[bool] = None,
        is_auto_verified: Optional[bool] = None,
        data_point: Optional[str] = None,
        content_type: Optional[str] = None,
        parsed: Optional["_models.YearsExperienceAnnotationUpdateParsed"] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id:
        :paramtype id: int
        :keyword rectangle:
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword page_index:
        :paramtype page_index: int
        :keyword raw:
        :paramtype raw: str
        :keyword confidence: The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: The model's confidence that the text has been classified
         correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: If the document was submitted as an image, this is the
         confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified:
        :paramtype is_verified: bool
        :keyword is_client_verified:
        :paramtype is_client_verified: bool
        :keyword is_auto_verified:
        :paramtype is_auto_verified: bool
        :keyword data_point:
        :paramtype data_point: str
        :keyword content_type:
        :paramtype content_type: str
        :keyword parsed: Years of experience range.
        :paramtype parsed: ~affinda.models.YearsExperienceAnnotationUpdateParsed
        """
        super(YearsExperienceAnnotationUpdate, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            **kwargs,
        )
        self.parsed = parsed


class YearsExperienceAnnotationUpdateParsed(msrest.serialization.Model):
    """Years of experience range.

    :ivar minimum: Minimum years of experience.
    :vartype minimum: float
    :ivar maximum: Maximum years of experience.
    :vartype maximum: float
    """

    _attribute_map = {
        "minimum": {"key": "minimum", "type": "float"},
        "maximum": {"key": "maximum", "type": "float"},
    }

    def __init__(
        self, *, minimum: Optional[float] = None, maximum: Optional[float] = None, **kwargs
    ):
        """
        :keyword minimum: Minimum years of experience.
        :paramtype minimum: float
        :keyword maximum: Maximum years of experience.
        :paramtype maximum: float
        """
        super(YearsExperienceAnnotationUpdateParsed, self).__init__(**kwargs)
        self.minimum = minimum
        self.maximum = maximum
