"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecretManagerWrapperLayer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const lambda = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
/**
 * An AWS SecretManager Wrapper layer
 */
class SecretManagerWrapperLayer extends lambda.LayerVersion {
    constructor(scope, id) {
        const image = core_1.DockerImage.fromBuild(path.join(__dirname, '../layer'));
        image.cp('/layer.zip', path.join(__dirname));
        const props = {
            removalPolicy: core_1.RemovalPolicy.DESTROY,
            code: lambda.Code.fromAsset(path.join(__dirname, 'layer.zip')),
            description: 'this layer has wrapper script help you setting secret manager json string into lambda runtime',
        };
        super(scope, id, props);
    }
    static getOrCreate(scope) {
        const stack = core_1.Stack.of(scope);
        const id = 'SecretManagerWrapperLayer';
        const existing = stack.node.tryFindChild(id);
        return existing || new SecretManagerWrapperLayer(stack, id);
    }
}
exports.SecretManagerWrapperLayer = SecretManagerWrapperLayer;
_a = JSII_RTTI_SYMBOL_1;
SecretManagerWrapperLayer[_a] = { fqn: "cdk-secret-manager-wrapper-layer.SecretManagerWrapperLayer", version: "1.0.394" };
//# sourceMappingURL=data:application/json;base64,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