# nuro

nuro is a minimal, scoop-like command runner focused on distributing and invoking PowerShell scripts from remote repositories. It keeps a lightweight local cache under `~/.nuro`, supports bucket pinning, and can transparently execute PowerShell, Python, or shell helpers published alongside your scripts.

## Features
- **Bucket-based distribution** – Fetch `cmds/<name>.ps1` (and optional `.py` / `.sh`) from GitHub-style "buckets" or local folders.
- **Commit pinning** – Lock a bucket to an exact commit hash via `buckets.json` so remote changes do not unexpectedly roll out.
- **Command caching** – Store downloaded scripts in `~/.nuro/cache/cmds/<ext>/<bucket>/` and reuse them while allowing manual refreshes.
- **Usage caching** – Cache one-line help snippets generated by `NuroUsage_<name>` functions so `nuro` can display usage without spinning up PowerShell each time.
- **Dependency aware Python support** – Automatically install `requirements` declared inside downloaded Python scripts before running them.
- **Trace logging** – Automatically append detailed execution logs to `~/.nuro/logs/nuro-debug.log` for later inspection.

## Installation
```bash
pip install nuro
```

For Windows-first setups there is also a bootstrapper (`bootstrap/get.nuro.ps1`) that provisions a virtual environment under `~/.nuro/venv`, creates a shim at `~/.nuro/bin/nuro.cmd`, and wires the folder into your PATH. After bootstrap you still interact with the PyPI package above.

## Quick Start
1. Install the package: `pip install nuro`
2. Run `nuro` with no arguments to see available commands fetched from your configured buckets.
3. Execute a command: `nuro example` will download `cmds/example.ps1` from the highest-priority bucket (unless overridden by pinning).
4. Show usage details: `nuro example --help`
5. Force a fresh command list and clear caches: `nuro --refresh`

## Configuration
nuro keeps its state inside `~/.nuro` (created automatically on first run):
- `config/config.json` – Application defaults, notably `official_bucket_base` which points at the canonical bucket (defaults to `https://raw.githubusercontent.com/nor-void/nuro/main`).
- `config/buckets.json` – Registry of buckets and command pins. Each entry looks like:
  ```json
  {
    "name": "official",
    "uri": "raw::https://raw.githubusercontent.com/nor-void/nuro/main",
    "priority": 100,
    "trusted": true,
    "sha1-hash": "<optional commit sha>"
  }
  ```
  Add a `pins` object mapping command names to bucket names to force per-command resolution.
- `cache/` – Script (`cmds/`) and usage (`usage/`) caches. Running `nuro --refresh` removes this directory before rebuilding entries.
- `logs/` – Contains `nuro-debug.log` with detailed trace logs.

## Command Resolution
1. Optional `bucket:command` prefix on the CLI takes precedence.
2. Bucket pins (`pins` section in `buckets.json`) resolve specific commands.
3. Remaining buckets are tried by descending `priority`.
4. nuro prefers `.ps1`, then `.py`, then `.sh`. PowerShell scripts are executed through a helper host so `NuroCmd_<name>` can interact with the current PowerShell session when desired.

## Diagnostics
- `nuro --refresh` removes the entire `~/.nuro/cache` tree before re-listing commands.
- Validation commands can be run manually: `nuro official:your-cmd` fetches straight from the `official` bucket even if pins exist.

## Developing Buckets
Bucket repositories follow a simple structure:
```
repo/
  cmds/
    hello.ps1
    hello.py
    hello.sh
```
Each PowerShell script can optionally expose:
- `function NuroCmd_<name> { param([string[]]$Args) … }` – the entry point executed by nuro
- `function NuroUsage_<name> { "nuro <name> …" }` – a one-line usage string cached by nuro

When you update bucket contents, publish to your Git remote and, if you need deterministic rollouts, update the `sha1-hash` in `buckets.json` to the new commit.

## Contributing
Clone the repository, create a virtual environment (or run `bootstrap/get.nuro.ps1` on Windows), then install in editable mode:
```bash
pip install -e .
```
Run the CLI locally with `python -m nuro` to inspect fetch and resolution behaviour. Pull requests and issue reports are welcome.

## License
nuro is released under the MIT License. See `LICENSE` for full details.
