    SELECT
        TABLE_CATALOG AS DATABASE
        ,TABLE_SCHEMA AS SCHEMA_NAME
        ,TABLE_NAME AS OBJECT_NAME
        ,NULL AS SIGNATURE
        ,TABLE_TYPE AS OBJECT_TYPE -- either 'VIEW' or 'BASE TABLE'
    FROM
        "{database_name}"."INFORMATION_SCHEMA"."TABLES"
UNION ALL
    SELECT
        FUNCTION_CATALOG AS DATABASE
        ,FUNCTION_SCHEMA AS SCHEMA_NAME
        ,FUNCTION_NAME AS OBJECT_NAME
        ,ARGUMENT_SIGNATURE AS SIGNATURE
        ,'FUNCTION' AS OBJECT_TYPE
    FROM
        "{database_name}"."INFORMATION_SCHEMA"."FUNCTIONS"
UNION ALL
    SELECT
        PROCEDURE_CATALOG AS DATABASE
        ,PROCEDURE_SCHEMA AS SCHEMA_NAME
        ,PROCEDURE_NAME AS OBJECT_NAME
        ,ARGUMENT_SIGNATURE AS SIGNATURE
        ,'PROCEDURE' AS OBJECT_TYPE
    FROM
        "{database_name}"."INFORMATION_SCHEMA"."PROCEDURES"
UNION ALL
    SELECT
        FILE_FORMAT_CATALOG AS DATABASE
        ,FILE_FORMAT_SCHEMA AS SCHEMA_NAME
        ,FILE_FORMAT_NAME AS OBJECT_NAME
        ,NULL AS SIGNATURE
        ,'FILE FORMAT' AS OBJECT_TYPE
    FROM
        "{database_name}"."INFORMATION_SCHEMA"."FILE_FORMATS"
UNION ALL
    SELECT
        STAGE_CATALOG AS DATABASE
        ,STAGE_SCHEMA AS SCHEMA_NAME
        ,STAGE_NAME AS OBJECT_NAME
        ,NULL AS SIGNATURE
        ,'STAGE' AS OBJECT_TYPE
    FROM
        "{database_name}"."INFORMATION_SCHEMA"."STAGES";
