SELECT
     S.CATALOG_NAME AS DATABASE_NAME
    ,S.SCHEMA_NAME AS SCHEMA_NAME
    ,S.IS_TRANSIENT AS IS_TRANSIENT
    ,S.IS_MANAGED_ACCESS AS IS_MANAGED_ACCESS
    ,S.RETENTION_TIME AS RETENTION_TIME
    ,D.RETENTION_TIME AS DATABASE_RETENTION_TIME
    ,S.COMMENT AS COMMENT
FROM
    INFORMATION_SCHEMA.SCHEMATA S
INNER JOIN
    INFORMATION_SCHEMA.DATABASES D
    ON
        D.DATABASE_NAME = S.CATALOG_NAME
WHERE
    SCHEMA_NAME = '{schema_name}'
;
