WITH COLUMNS AS (
    SELECT
         TABLE_SCHEMA
        ,TABLE_NAME
        ,ARRAYAGG(
            OBJECT_CONSTRUCT( -- aggregate column information for each table in a json string
                 'DATABASE_NAME', TABLE_CATALOG
                ,'TABLE_SCHEMA', TABLE_SCHEMA
                ,'TABLE_NAME', TABLE_NAME
                ,'COLUMN_NAME', COLUMN_NAME
                ,'ORDINAL_POSITION', ORDINAL_POSITION
                ,'COLUMN_DEFAULT', COLUMN_DEFAULT
                ,'IS_NULLABLE', IS_NULLABLE
                ,'DATA_TYPE', DATA_TYPE
                ,'CHARACTER_MAXIMUM_LENGTH', CHARACTER_MAXIMUM_LENGTH
                ,'CHARACTER_OCTET_LENGTH', CHARACTER_OCTET_LENGTH
                ,'NUMERIC_PRECISION', NUMERIC_PRECISION
                ,'NUMERIC_PRECISION_RADIX', NUMERIC_PRECISION_RADIX
                ,'NUMERIC_SCALE', NUMERIC_SCALE
                ,'DATETIME_PRECISION', DATETIME_PRECISION
                ,'INTERVAL_TYPE', INTERVAL_TYPE
                ,'INTERVAL_PRECISION', INTERVAL_PRECISION
                ,'CHARACTER_SET_CATALOG', CHARACTER_SET_CATALOG
                ,'CHARACTER_SET_SCHEMA', CHARACTER_SET_SCHEMA
                ,'CHARACTER_SET_NAME', CHARACTER_SET_NAME
                ,'COLLATION_CATALOG', COLLATION_CATALOG
                ,'COLLATION_SCHEMA', COLLATION_SCHEMA
                ,'COLLATION_NAME', COLLATION_NAME
                ,'DOMAIN_CATALOG', DOMAIN_CATALOG
                ,'DOMAIN_SCHEMA', DOMAIN_SCHEMA
                ,'DOMAIN_NAME', DOMAIN_NAME
                ,'UDT_CATALOG', UDT_CATALOG
                ,'UDT_SCHEMA', UDT_SCHEMA
                ,'UDT_NAME', UDT_NAME
                ,'SCOPE_CATALOG', SCOPE_CATALOG
                ,'SCOPE_SCHEMA', SCOPE_SCHEMA
                ,'SCOPE_NAME', SCOPE_NAME
                ,'MAXIMUM_CARDINALITY', MAXIMUM_CARDINALITY
                ,'DTD_IDENTIFIER', DTD_IDENTIFIER
                ,'IS_SELF_REFERENCING', IS_SELF_REFERENCING
                ,'IS_IDENTITY', IS_IDENTITY
                ,'IDENTITY_GENERATION', IDENTITY_GENERATION
                ,'IDENTITY_START', IDENTITY_START
                ,'IDENTITY_INCREMENT', IDENTITY_INCREMENT
                ,'IDENTITY_MAXIMUM', IDENTITY_MAXIMUM
                ,'IDENTITY_MINIMUM', IDENTITY_MINIMUM
                ,'IDENTITY_CYCLE', IDENTITY_CYCLE
                ,'COMMENT', COMMENT
            )
        ) AS COLUMN_DETAILS
    FROM
        INFORMATION_SCHEMA.COLUMNS
    WHERE
        TABLE_SCHEMA = '{schema_name}'
    GROUP BY
         TABLE_SCHEMA
        ,TABLE_NAME
),
VIEWS AS (
    SELECT
         TABLE_SCHEMA
        ,TABLE_NAME
        ,VIEW_DEFINITION
        ,IS_SECURE
        ,COMMENT
    FROM
        INFORMATION_SCHEMA.VIEWS
    WHERE
        TABLE_SCHEMA = '{schema_name}'
)
SELECT
     TABLES.TABLE_CATALOG AS DATABASE_NAME
    ,TABLES.TABLE_SCHEMA AS SCHEMA_NAME
    ,TABLES.TABLE_NAME AS OBJECT_NAME
    ,TABLES.TABLE_TYPE
    ,TABLES.CLUSTERING_KEY
    ,VIEWS.VIEW_DEFINITION
    ,VIEWS.IS_SECURE
    ,VIEWS.COMMENT
    ,COLUMNS.COLUMN_DETAILS
FROM INFORMATION_SCHEMA.TABLES AS TABLES
INNER JOIN VIEWS ON
         TABLES.TABLE_SCHEMA = VIEWS.TABLE_SCHEMA
     AND TABLES.TABLE_NAME = VIEWS.TABLE_NAME
INNER JOIN COLUMNS ON
         TABLES.TABLE_SCHEMA = COLUMNS.TABLE_SCHEMA
     AND TABLES.TABLE_NAME = COLUMNS.TABLE_NAME
WHERE
    TABLES.TABLE_TYPE = 'VIEW' AND
    TABLES.TABLE_SCHEMA = '{schema_name}';
