# encoding: utf-8

def truth(*args):
    return True

def class_in_session(node):
    return (8 <= node.engine.character['physical'].stat['hour'] < 15)

def in_classroom_after_class(node):
    assert hasattr(node, 'location'), f'Tried to get location of {node.name} in {node.character.name}'
    phys = node.character
    return ((node.location == phys.place['classroom']) and (phys.stat['hour'] >= 15))

def party_time(character):
    phys = character.engine.character['physical']
    return (23 >= phys.stat['hour'] > 15)

def out_of_class(character):
    unit = character.unit['physical'].only
    assert hasattr(unit, 'location'), f'Tried to get location of {unit.name} in physical, a unit of {character.name}'
    classroom = unit.character.place['classroom']
    return (unit.location != classroom)

def in_class(node):
    classroom = node.engine.character['physical'].place['classroom']
    student = node.character.unit['physical'].only
    assert hasattr(student, 'location'), f'Tried to get location of {student.name} in physical, a unit of {node.character.name}'
    return (student.location == classroom)

def somewhat_drunk(node):
    return (node['drunk'] > 0)

def somewhat_late(node):
    return (node['slow'] > 0)
