import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ContainerConfig extends cdktf.TerraformMetaArguments {
    /**
     * @stability stable
     */
    readonly attach?: boolean;
    /**
     * @stability stable
     */
    readonly command?: string[];
    /**
     * @stability stable
     */
    readonly cpuSet?: string;
    /**
     * @stability stable
     */
    readonly cpuShares?: number;
    /**
     * @stability stable
     */
    readonly destroyGraceSeconds?: number;
    /**
     * @stability stable
     */
    readonly dns?: string[];
    /**
     * @stability stable
     */
    readonly dnsOpts?: string[];
    /**
     * @stability stable
     */
    readonly dnsSearch?: string[];
    /**
     * @stability stable
     */
    readonly domainname?: string;
    /**
     * @stability stable
     */
    readonly entrypoint?: string[];
    /**
     * @stability stable
     */
    readonly env?: string[];
    /**
     * Additional groups for the container user.
     *
     * @stability stable
     */
    readonly groupAdd?: string[];
    /**
     * @stability stable
     */
    readonly hostname?: string;
    /**
     * @stability stable
     */
    readonly image: string;
    /**
     * IPC sharing mode for the container.
     *
     * @stability stable
     */
    readonly ipcMode?: string;
    /**
     * @stability stable
     */
    readonly links?: string[];
    /**
     * @stability stable
     */
    readonly logDriver?: string;
    /**
     * @stability stable
     */
    readonly logOpts?: {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    readonly logs?: boolean;
    /**
     * @stability stable
     */
    readonly maxRetryCount?: number;
    /**
     * @stability stable
     */
    readonly memory?: number;
    /**
     * @stability stable
     */
    readonly memorySwap?: number;
    /**
     * @stability stable
     */
    readonly mustRun?: boolean;
    /**
     * @stability stable
     */
    readonly name: string;
    /**
     * Set an alias for the container in all specified networks.
     *
     * @stability stable
     */
    readonly networkAlias?: string[];
    /**
     * @stability stable
     */
    readonly networkMode?: string;
    /**
     * @stability stable
     */
    readonly networks?: string[];
    /**
     * @stability stable
     */
    readonly pidMode?: string;
    /**
     * @stability stable
     */
    readonly privileged?: boolean;
    /**
     * @stability stable
     */
    readonly publishAllPorts?: boolean;
    /**
     * @stability stable
     */
    readonly readOnly?: boolean;
    /**
     * @stability stable
     */
    readonly restart?: string;
    /**
     * @stability stable
     */
    readonly rm?: boolean;
    /**
     * @stability stable
     */
    readonly shmSize?: number;
    /**
     * @stability stable
     */
    readonly start?: boolean;
    /**
     * @stability stable
     */
    readonly sysctls?: {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    readonly tmpfs?: {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    readonly user?: string;
    /**
     * @stability stable
     */
    readonly usernsMode?: string;
    /**
     * @stability stable
     */
    readonly workingDir?: string;
    /**
     * capabilities block.
     *
     * @stability stable
     */
    readonly capabilities?: ContainerCapabilities[];
    /**
     * devices block.
     *
     * @stability stable
     */
    readonly devices?: ContainerDevices[];
    /**
     * healthcheck block.
     *
     * @stability stable
     */
    readonly healthcheck?: ContainerHealthcheck[];
    /**
     * host block.
     *
     * @stability stable
     */
    readonly host?: ContainerHost[];
    /**
     * labels block.
     *
     * @stability stable
     */
    readonly labels?: ContainerLabels[];
    /**
     * mounts block.
     *
     * @stability stable
     */
    readonly mounts?: ContainerMounts[];
    /**
     * networks_advanced block.
     *
     * @stability stable
     */
    readonly networksAdvanced?: ContainerNetworksAdvanced[];
    /**
     * ports block.
     *
     * @stability stable
     */
    readonly ports?: ContainerPorts[];
    /**
     * ulimit block.
     *
     * @stability stable
     */
    readonly ulimit?: ContainerUlimit[];
    /**
     * upload block.
     *
     * @stability stable
     */
    readonly upload?: ContainerUpload[];
    /**
     * volumes block.
     *
     * @stability stable
     */
    readonly volumes?: ContainerVolumes[];
}
/**
 * @stability stable
 */
export declare class ContainerNetworkData extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get gateway(): string;
    /**
     * @stability stable
     */
    get ipAddress(): string;
    /**
     * @stability stable
     */
    get ipPrefixLength(): number;
    /**
     * @stability stable
     */
    get networkName(): string;
}
/**
 * @stability stable
 */
export interface ContainerCapabilities {
    /**
     * @stability stable
     */
    readonly add?: string[];
    /**
     * @stability stable
     */
    readonly drop?: string[];
}
/**
 * @stability stable
 */
export interface ContainerDevices {
    /**
     * @stability stable
     */
    readonly containerPath?: string;
    /**
     * @stability stable
     */
    readonly hostPath: string;
    /**
     * @stability stable
     */
    readonly permissions?: string;
}
/**
 * @stability stable
 */
export interface ContainerHealthcheck {
    /**
     * Time between running the check (ms|s|m|h).
     *
     * @stability stable
     */
    readonly interval?: string;
    /**
     * Consecutive failures needed to report unhealthy.
     *
     * @stability stable
     */
    readonly retries?: number;
    /**
     * Start period for the container to initialize before counting retries towards unstable (ms|s|m|h).
     *
     * @stability stable
     */
    readonly startPeriod?: string;
    /**
     * The test to perform as list.
     *
     * @stability stable
     */
    readonly test: string[];
    /**
     * Maximum time to allow one check to run (ms|s|m|h).
     *
     * @stability stable
     */
    readonly timeout?: string;
}
/**
 * @stability stable
 */
export interface ContainerHost {
    /**
     * @stability stable
     */
    readonly host: string;
    /**
     * @stability stable
     */
    readonly ip: string;
}
/**
 * @stability stable
 */
export interface ContainerLabels {
    /**
     * Name of the label.
     *
     * @stability stable
     */
    readonly label: string;
    /**
     * Value of the label.
     *
     * @stability stable
     */
    readonly value: string;
}
/**
 * @stability stable
 */
export interface ContainerMountsBindOptions {
    /**
     * A propagation mode with the value.
     *
     * @stability stable
     */
    readonly propagation?: string;
}
/**
 * @stability stable
 */
export interface ContainerMountsTmpfsOptions {
    /**
     * The permission mode for the tmpfs mount in an integer.
     *
     * @stability stable
     */
    readonly mode?: number;
    /**
     * The size for the tmpfs mount in bytes.
     *
     * @stability stable
     */
    readonly sizeBytes?: number;
}
/**
 * @stability stable
 */
export interface ContainerMountsVolumeOptionsLabels {
    /**
     * Name of the label.
     *
     * @stability stable
     */
    readonly label: string;
    /**
     * Value of the label.
     *
     * @stability stable
     */
    readonly value: string;
}
/**
 * @stability stable
 */
export interface ContainerMountsVolumeOptions {
    /**
     * Name of the driver to use to create the volume.
     *
     * @stability stable
     */
    readonly driverName?: string;
    /**
     * key/value map of driver specific options.
     *
     * @stability stable
     */
    readonly driverOptions?: {
        [key: string]: string;
    };
    /**
     * Populate volume with data from the target.
     *
     * @stability stable
     */
    readonly noCopy?: boolean;
    /**
     * labels block.
     *
     * @stability stable
     */
    readonly labels?: ContainerMountsVolumeOptionsLabels[];
}
/**
 * @stability stable
 */
export interface ContainerMounts {
    /**
     * Whether the mount should be read-only.
     *
     * @stability stable
     */
    readonly readOnly?: boolean;
    /**
     * Mount source (e.g. a volume name, a host path).
     *
     * @stability stable
     */
    readonly source?: string;
    /**
     * Container path.
     *
     * @stability stable
     */
    readonly target: string;
    /**
     * The mount type.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * bind_options block.
     *
     * @stability stable
     */
    readonly bindOptions?: ContainerMountsBindOptions[];
    /**
     * tmpfs_options block.
     *
     * @stability stable
     */
    readonly tmpfsOptions?: ContainerMountsTmpfsOptions[];
    /**
     * volume_options block.
     *
     * @stability stable
     */
    readonly volumeOptions?: ContainerMountsVolumeOptions[];
}
/**
 * @stability stable
 */
export interface ContainerNetworksAdvanced {
    /**
     * @stability stable
     */
    readonly aliases?: string[];
    /**
     * @stability stable
     */
    readonly ipv4Address?: string;
    /**
     * @stability stable
     */
    readonly ipv6Address?: string;
    /**
     * @stability stable
     */
    readonly name: string;
}
/**
 * @stability stable
 */
export interface ContainerPorts {
    /**
     * @stability stable
     */
    readonly external?: number;
    /**
     * @stability stable
     */
    readonly internal: number;
    /**
     * @stability stable
     */
    readonly ip?: string;
    /**
     * @stability stable
     */
    readonly protocol?: string;
}
/**
 * @stability stable
 */
export interface ContainerUlimit {
    /**
     * @stability stable
     */
    readonly hard: number;
    /**
     * @stability stable
     */
    readonly name: string;
    /**
     * @stability stable
     */
    readonly soft: number;
}
/**
 * @stability stable
 */
export interface ContainerUpload {
    /**
     * @stability stable
     */
    readonly content?: string;
    /**
     * @stability stable
     */
    readonly contentBase64?: string;
    /**
     * @stability stable
     */
    readonly executable?: boolean;
    /**
     * @stability stable
     */
    readonly file: string;
    /**
     * @stability stable
     */
    readonly source?: string;
    /**
     * @stability stable
     */
    readonly sourceHash?: string;
}
/**
 * @stability stable
 */
export interface ContainerVolumes {
    /**
     * @stability stable
     */
    readonly containerPath?: string;
    /**
     * @stability stable
     */
    readonly fromContainer?: string;
    /**
     * @stability stable
     */
    readonly hostPath?: string;
    /**
     * @stability stable
     */
    readonly readOnly?: boolean;
    /**
     * @stability stable
     */
    readonly volumeName?: string;
}
/**
 * @stability stable
 */
export declare class Container extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ContainerConfig);
    private _attach?;
    /**
     * @stability stable
     */
    get attach(): boolean;
    /**
     * @stability stable
     */
    set attach(value: boolean);
    /**
     * @stability stable
     */
    resetAttach(): void;
    /**
     * @stability stable
     */
    get attachInput(): boolean | undefined;
    /**
     * @stability stable
     */
    get bridge(): string;
    private _command?;
    /**
     * @stability stable
     */
    get command(): string[];
    /**
     * @stability stable
     */
    set command(value: string[]);
    /**
     * @stability stable
     */
    resetCommand(): void;
    /**
     * @stability stable
     */
    get commandInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get containerLogs(): string;
    private _cpuSet?;
    /**
     * @stability stable
     */
    get cpuSet(): string;
    /**
     * @stability stable
     */
    set cpuSet(value: string);
    /**
     * @stability stable
     */
    resetCpuSet(): void;
    /**
     * @stability stable
     */
    get cpuSetInput(): string | undefined;
    private _cpuShares?;
    /**
     * @stability stable
     */
    get cpuShares(): number;
    /**
     * @stability stable
     */
    set cpuShares(value: number);
    /**
     * @stability stable
     */
    resetCpuShares(): void;
    /**
     * @stability stable
     */
    get cpuSharesInput(): number | undefined;
    private _destroyGraceSeconds?;
    /**
     * @stability stable
     */
    get destroyGraceSeconds(): number;
    /**
     * @stability stable
     */
    set destroyGraceSeconds(value: number);
    /**
     * @stability stable
     */
    resetDestroyGraceSeconds(): void;
    /**
     * @stability stable
     */
    get destroyGraceSecondsInput(): number | undefined;
    private _dns?;
    /**
     * @stability stable
     */
    get dns(): string[];
    /**
     * @stability stable
     */
    set dns(value: string[]);
    /**
     * @stability stable
     */
    resetDns(): void;
    /**
     * @stability stable
     */
    get dnsInput(): string[] | undefined;
    private _dnsOpts?;
    /**
     * @stability stable
     */
    get dnsOpts(): string[];
    /**
     * @stability stable
     */
    set dnsOpts(value: string[]);
    /**
     * @stability stable
     */
    resetDnsOpts(): void;
    /**
     * @stability stable
     */
    get dnsOptsInput(): string[] | undefined;
    private _dnsSearch?;
    /**
     * @stability stable
     */
    get dnsSearch(): string[];
    /**
     * @stability stable
     */
    set dnsSearch(value: string[]);
    /**
     * @stability stable
     */
    resetDnsSearch(): void;
    /**
     * @stability stable
     */
    get dnsSearchInput(): string[] | undefined;
    private _domainname?;
    /**
     * @stability stable
     */
    get domainname(): string;
    /**
     * @stability stable
     */
    set domainname(value: string);
    /**
     * @stability stable
     */
    resetDomainname(): void;
    /**
     * @stability stable
     */
    get domainnameInput(): string | undefined;
    private _entrypoint?;
    /**
     * @stability stable
     */
    get entrypoint(): string[];
    /**
     * @stability stable
     */
    set entrypoint(value: string[]);
    /**
     * @stability stable
     */
    resetEntrypoint(): void;
    /**
     * @stability stable
     */
    get entrypointInput(): string[] | undefined;
    private _env?;
    /**
     * @stability stable
     */
    get env(): string[];
    /**
     * @stability stable
     */
    set env(value: string[]);
    /**
     * @stability stable
     */
    resetEnv(): void;
    /**
     * @stability stable
     */
    get envInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get exitCode(): number;
    /**
     * @stability stable
     */
    get gateway(): string;
    private _groupAdd?;
    /**
     * @stability stable
     */
    get groupAdd(): string[];
    /**
     * @stability stable
     */
    set groupAdd(value: string[]);
    /**
     * @stability stable
     */
    resetGroupAdd(): void;
    /**
     * @stability stable
     */
    get groupAddInput(): string[] | undefined;
    private _hostname?;
    /**
     * @stability stable
     */
    get hostname(): string;
    /**
     * @stability stable
     */
    set hostname(value: string);
    /**
     * @stability stable
     */
    resetHostname(): void;
    /**
     * @stability stable
     */
    get hostnameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _image;
    /**
     * @stability stable
     */
    get image(): string;
    /**
     * @stability stable
     */
    set image(value: string);
    /**
     * @stability stable
     */
    get imageInput(): string;
    /**
     * @stability stable
     */
    get ipAddress(): string;
    /**
     * @stability stable
     */
    get ipPrefixLength(): number;
    private _ipcMode?;
    /**
     * @stability stable
     */
    get ipcMode(): string;
    /**
     * @stability stable
     */
    set ipcMode(value: string);
    /**
     * @stability stable
     */
    resetIpcMode(): void;
    /**
     * @stability stable
     */
    get ipcModeInput(): string | undefined;
    private _links?;
    /**
     * @stability stable
     */
    get links(): string[];
    /**
     * @stability stable
     */
    set links(value: string[]);
    /**
     * @stability stable
     */
    resetLinks(): void;
    /**
     * @stability stable
     */
    get linksInput(): string[] | undefined;
    private _logDriver?;
    /**
     * @stability stable
     */
    get logDriver(): string;
    /**
     * @stability stable
     */
    set logDriver(value: string);
    /**
     * @stability stable
     */
    resetLogDriver(): void;
    /**
     * @stability stable
     */
    get logDriverInput(): string | undefined;
    private _logOpts?;
    /**
     * @stability stable
     */
    get logOpts(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set logOpts(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetLogOpts(): void;
    /**
     * @stability stable
     */
    get logOptsInput(): {
        [key: string]: string;
    } | undefined;
    private _logs?;
    /**
     * @stability stable
     */
    get logs(): boolean;
    /**
     * @stability stable
     */
    set logs(value: boolean);
    /**
     * @stability stable
     */
    resetLogs(): void;
    /**
     * @stability stable
     */
    get logsInput(): boolean | undefined;
    private _maxRetryCount?;
    /**
     * @stability stable
     */
    get maxRetryCount(): number;
    /**
     * @stability stable
     */
    set maxRetryCount(value: number);
    /**
     * @stability stable
     */
    resetMaxRetryCount(): void;
    /**
     * @stability stable
     */
    get maxRetryCountInput(): number | undefined;
    private _memory?;
    /**
     * @stability stable
     */
    get memory(): number;
    /**
     * @stability stable
     */
    set memory(value: number);
    /**
     * @stability stable
     */
    resetMemory(): void;
    /**
     * @stability stable
     */
    get memoryInput(): number | undefined;
    private _memorySwap?;
    /**
     * @stability stable
     */
    get memorySwap(): number;
    /**
     * @stability stable
     */
    set memorySwap(value: number);
    /**
     * @stability stable
     */
    resetMemorySwap(): void;
    /**
     * @stability stable
     */
    get memorySwapInput(): number | undefined;
    private _mustRun?;
    /**
     * @stability stable
     */
    get mustRun(): boolean;
    /**
     * @stability stable
     */
    set mustRun(value: boolean);
    /**
     * @stability stable
     */
    resetMustRun(): void;
    /**
     * @stability stable
     */
    get mustRunInput(): boolean | undefined;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _networkAlias?;
    /**
     * @stability stable
     */
    get networkAlias(): string[];
    /**
     * @stability stable
     */
    set networkAlias(value: string[]);
    /**
     * @stability stable
     */
    resetNetworkAlias(): void;
    /**
     * @stability stable
     */
    get networkAliasInput(): string[] | undefined;
    /**
     * @stability stable
     */
    networkData(index: string): ContainerNetworkData;
    private _networkMode?;
    /**
     * @stability stable
     */
    get networkMode(): string;
    /**
     * @stability stable
     */
    set networkMode(value: string);
    /**
     * @stability stable
     */
    resetNetworkMode(): void;
    /**
     * @stability stable
     */
    get networkModeInput(): string | undefined;
    private _networks?;
    /**
     * @stability stable
     */
    get networks(): string[];
    /**
     * @stability stable
     */
    set networks(value: string[]);
    /**
     * @stability stable
     */
    resetNetworks(): void;
    /**
     * @stability stable
     */
    get networksInput(): string[] | undefined;
    private _pidMode?;
    /**
     * @stability stable
     */
    get pidMode(): string;
    /**
     * @stability stable
     */
    set pidMode(value: string);
    /**
     * @stability stable
     */
    resetPidMode(): void;
    /**
     * @stability stable
     */
    get pidModeInput(): string | undefined;
    private _privileged?;
    /**
     * @stability stable
     */
    get privileged(): boolean;
    /**
     * @stability stable
     */
    set privileged(value: boolean);
    /**
     * @stability stable
     */
    resetPrivileged(): void;
    /**
     * @stability stable
     */
    get privilegedInput(): boolean | undefined;
    private _publishAllPorts?;
    /**
     * @stability stable
     */
    get publishAllPorts(): boolean;
    /**
     * @stability stable
     */
    set publishAllPorts(value: boolean);
    /**
     * @stability stable
     */
    resetPublishAllPorts(): void;
    /**
     * @stability stable
     */
    get publishAllPortsInput(): boolean | undefined;
    private _readOnly?;
    /**
     * @stability stable
     */
    get readOnly(): boolean;
    /**
     * @stability stable
     */
    set readOnly(value: boolean);
    /**
     * @stability stable
     */
    resetReadOnly(): void;
    /**
     * @stability stable
     */
    get readOnlyInput(): boolean | undefined;
    private _restart?;
    /**
     * @stability stable
     */
    get restart(): string;
    /**
     * @stability stable
     */
    set restart(value: string);
    /**
     * @stability stable
     */
    resetRestart(): void;
    /**
     * @stability stable
     */
    get restartInput(): string | undefined;
    private _rm?;
    /**
     * @stability stable
     */
    get rm(): boolean;
    /**
     * @stability stable
     */
    set rm(value: boolean);
    /**
     * @stability stable
     */
    resetRm(): void;
    /**
     * @stability stable
     */
    get rmInput(): boolean | undefined;
    private _shmSize?;
    /**
     * @stability stable
     */
    get shmSize(): number;
    /**
     * @stability stable
     */
    set shmSize(value: number);
    /**
     * @stability stable
     */
    resetShmSize(): void;
    /**
     * @stability stable
     */
    get shmSizeInput(): number | undefined;
    private _start?;
    /**
     * @stability stable
     */
    get start(): boolean;
    /**
     * @stability stable
     */
    set start(value: boolean);
    /**
     * @stability stable
     */
    resetStart(): void;
    /**
     * @stability stable
     */
    get startInput(): boolean | undefined;
    private _sysctls?;
    /**
     * @stability stable
     */
    get sysctls(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set sysctls(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetSysctls(): void;
    /**
     * @stability stable
     */
    get sysctlsInput(): {
        [key: string]: string;
    } | undefined;
    private _tmpfs?;
    /**
     * @stability stable
     */
    get tmpfs(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tmpfs(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTmpfs(): void;
    /**
     * @stability stable
     */
    get tmpfsInput(): {
        [key: string]: string;
    } | undefined;
    private _user?;
    /**
     * @stability stable
     */
    get user(): string;
    /**
     * @stability stable
     */
    set user(value: string);
    /**
     * @stability stable
     */
    resetUser(): void;
    /**
     * @stability stable
     */
    get userInput(): string | undefined;
    private _usernsMode?;
    /**
     * @stability stable
     */
    get usernsMode(): string;
    /**
     * @stability stable
     */
    set usernsMode(value: string);
    /**
     * @stability stable
     */
    resetUsernsMode(): void;
    /**
     * @stability stable
     */
    get usernsModeInput(): string | undefined;
    private _workingDir?;
    /**
     * @stability stable
     */
    get workingDir(): string;
    /**
     * @stability stable
     */
    set workingDir(value: string);
    /**
     * @stability stable
     */
    resetWorkingDir(): void;
    /**
     * @stability stable
     */
    get workingDirInput(): string | undefined;
    private _capabilities?;
    /**
     * @stability stable
     */
    get capabilities(): ContainerCapabilities[];
    /**
     * @stability stable
     */
    set capabilities(value: ContainerCapabilities[]);
    /**
     * @stability stable
     */
    resetCapabilities(): void;
    /**
     * @stability stable
     */
    get capabilitiesInput(): ContainerCapabilities[] | undefined;
    private _devices?;
    /**
     * @stability stable
     */
    get devices(): ContainerDevices[];
    /**
     * @stability stable
     */
    set devices(value: ContainerDevices[]);
    /**
     * @stability stable
     */
    resetDevices(): void;
    /**
     * @stability stable
     */
    get devicesInput(): ContainerDevices[] | undefined;
    private _healthcheck?;
    /**
     * @stability stable
     */
    get healthcheck(): ContainerHealthcheck[];
    /**
     * @stability stable
     */
    set healthcheck(value: ContainerHealthcheck[]);
    /**
     * @stability stable
     */
    resetHealthcheck(): void;
    /**
     * @stability stable
     */
    get healthcheckInput(): ContainerHealthcheck[] | undefined;
    private _host?;
    /**
     * @stability stable
     */
    get host(): ContainerHost[];
    /**
     * @stability stable
     */
    set host(value: ContainerHost[]);
    /**
     * @stability stable
     */
    resetHost(): void;
    /**
     * @stability stable
     */
    get hostInput(): ContainerHost[] | undefined;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): ContainerLabels[];
    /**
     * @stability stable
     */
    set labels(value: ContainerLabels[]);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): ContainerLabels[] | undefined;
    private _mounts?;
    /**
     * @stability stable
     */
    get mounts(): ContainerMounts[];
    /**
     * @stability stable
     */
    set mounts(value: ContainerMounts[]);
    /**
     * @stability stable
     */
    resetMounts(): void;
    /**
     * @stability stable
     */
    get mountsInput(): ContainerMounts[] | undefined;
    private _networksAdvanced?;
    /**
     * @stability stable
     */
    get networksAdvanced(): ContainerNetworksAdvanced[];
    /**
     * @stability stable
     */
    set networksAdvanced(value: ContainerNetworksAdvanced[]);
    /**
     * @stability stable
     */
    resetNetworksAdvanced(): void;
    /**
     * @stability stable
     */
    get networksAdvancedInput(): ContainerNetworksAdvanced[] | undefined;
    private _ports?;
    /**
     * @stability stable
     */
    get ports(): ContainerPorts[];
    /**
     * @stability stable
     */
    set ports(value: ContainerPorts[]);
    /**
     * @stability stable
     */
    resetPorts(): void;
    /**
     * @stability stable
     */
    get portsInput(): ContainerPorts[] | undefined;
    private _ulimit?;
    /**
     * @stability stable
     */
    get ulimit(): ContainerUlimit[];
    /**
     * @stability stable
     */
    set ulimit(value: ContainerUlimit[]);
    /**
     * @stability stable
     */
    resetUlimit(): void;
    /**
     * @stability stable
     */
    get ulimitInput(): ContainerUlimit[] | undefined;
    private _upload?;
    /**
     * @stability stable
     */
    get upload(): ContainerUpload[];
    /**
     * @stability stable
     */
    set upload(value: ContainerUpload[]);
    /**
     * @stability stable
     */
    resetUpload(): void;
    /**
     * @stability stable
     */
    get uploadInput(): ContainerUpload[] | undefined;
    private _volumes?;
    /**
     * @stability stable
     */
    get volumes(): ContainerVolumes[];
    /**
     * @stability stable
     */
    set volumes(value: ContainerVolumes[]);
    /**
     * @stability stable
     */
    resetVolumes(): void;
    /**
     * @stability stable
     */
    get volumesInput(): ContainerVolumes[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
