"use strict";
// https://www.terraform.io/docs/providers/docker/r/container.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.Container = exports.ContainerNetworkData = void 0;
const cdktf = require("cdktf");
/**
 * @stability stable
 */
class ContainerNetworkData extends cdktf.ComplexComputedList {
    // gateway - computed: true, optional: false, required: false
    /**
     * @stability stable
     */
    get gateway() {
        return this.getStringAttribute('gateway');
    }
    // ip_address - computed: true, optional: false, required: false
    /**
     * @stability stable
     */
    get ipAddress() {
        return this.getStringAttribute('ip_address');
    }
    // ip_prefix_length - computed: true, optional: false, required: false
    /**
     * @stability stable
     */
    get ipPrefixLength() {
        return this.getNumberAttribute('ip_prefix_length');
    }
    // network_name - computed: true, optional: false, required: false
    /**
     * @stability stable
     */
    get networkName() {
        return this.getStringAttribute('network_name');
    }
}
exports.ContainerNetworkData = ContainerNetworkData;
function containerCapabilitiesToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        add: cdktf.listMapper(cdktf.stringToTerraform)(struct.add),
        drop: cdktf.listMapper(cdktf.stringToTerraform)(struct.drop),
    };
}
function containerDevicesToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        container_path: cdktf.stringToTerraform(struct.containerPath),
        host_path: cdktf.stringToTerraform(struct.hostPath),
        permissions: cdktf.stringToTerraform(struct.permissions),
    };
}
function containerHealthcheckToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        interval: cdktf.stringToTerraform(struct.interval),
        retries: cdktf.numberToTerraform(struct.retries),
        start_period: cdktf.stringToTerraform(struct.startPeriod),
        test: cdktf.listMapper(cdktf.stringToTerraform)(struct.test),
        timeout: cdktf.stringToTerraform(struct.timeout),
    };
}
function containerHostToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        host: cdktf.stringToTerraform(struct.host),
        ip: cdktf.stringToTerraform(struct.ip),
    };
}
function containerLabelsToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        label: cdktf.stringToTerraform(struct.label),
        value: cdktf.stringToTerraform(struct.value),
    };
}
function containerMountsBindOptionsToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        propagation: cdktf.stringToTerraform(struct.propagation),
    };
}
function containerMountsTmpfsOptionsToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        mode: cdktf.numberToTerraform(struct.mode),
        size_bytes: cdktf.numberToTerraform(struct.sizeBytes),
    };
}
function containerMountsVolumeOptionsLabelsToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        label: cdktf.stringToTerraform(struct.label),
        value: cdktf.stringToTerraform(struct.value),
    };
}
function containerMountsVolumeOptionsToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        driver_name: cdktf.stringToTerraform(struct.driverName),
        driver_options: cdktf.hashMapper(cdktf.anyToTerraform)(struct.driverOptions),
        no_copy: cdktf.booleanToTerraform(struct.noCopy),
        labels: cdktf.listMapper(containerMountsVolumeOptionsLabelsToTerraform)(struct.labels),
    };
}
function containerMountsToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        read_only: cdktf.booleanToTerraform(struct.readOnly),
        source: cdktf.stringToTerraform(struct.source),
        target: cdktf.stringToTerraform(struct.target),
        type: cdktf.stringToTerraform(struct.type),
        bind_options: cdktf.listMapper(containerMountsBindOptionsToTerraform)(struct.bindOptions),
        tmpfs_options: cdktf.listMapper(containerMountsTmpfsOptionsToTerraform)(struct.tmpfsOptions),
        volume_options: cdktf.listMapper(containerMountsVolumeOptionsToTerraform)(struct.volumeOptions),
    };
}
function containerNetworksAdvancedToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        aliases: cdktf.listMapper(cdktf.stringToTerraform)(struct.aliases),
        ipv4_address: cdktf.stringToTerraform(struct.ipv4Address),
        ipv6_address: cdktf.stringToTerraform(struct.ipv6Address),
        name: cdktf.stringToTerraform(struct.name),
    };
}
function containerPortsToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        external: cdktf.numberToTerraform(struct.external),
        internal: cdktf.numberToTerraform(struct.internal),
        ip: cdktf.stringToTerraform(struct.ip),
        protocol: cdktf.stringToTerraform(struct.protocol),
    };
}
function containerUlimitToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        hard: cdktf.numberToTerraform(struct.hard),
        name: cdktf.stringToTerraform(struct.name),
        soft: cdktf.numberToTerraform(struct.soft),
    };
}
function containerUploadToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        content: cdktf.stringToTerraform(struct.content),
        content_base64: cdktf.stringToTerraform(struct.contentBase64),
        executable: cdktf.booleanToTerraform(struct.executable),
        file: cdktf.stringToTerraform(struct.file),
        source: cdktf.stringToTerraform(struct.source),
        source_hash: cdktf.stringToTerraform(struct.sourceHash),
    };
}
function containerVolumesToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        container_path: cdktf.stringToTerraform(struct.containerPath),
        from_container: cdktf.stringToTerraform(struct.fromContainer),
        host_path: cdktf.stringToTerraform(struct.hostPath),
        read_only: cdktf.booleanToTerraform(struct.readOnly),
        volume_name: cdktf.stringToTerraform(struct.volumeName),
    };
}
// Resource
/**
 * @stability stable
 */
class Container extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
     * @stability stable
     */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'docker_container',
            terraformGeneratorMetadata: {
                providerName: 'docker'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._attach = config.attach;
        this._command = config.command;
        this._cpuSet = config.cpuSet;
        this._cpuShares = config.cpuShares;
        this._destroyGraceSeconds = config.destroyGraceSeconds;
        this._dns = config.dns;
        this._dnsOpts = config.dnsOpts;
        this._dnsSearch = config.dnsSearch;
        this._domainname = config.domainname;
        this._entrypoint = config.entrypoint;
        this._env = config.env;
        this._groupAdd = config.groupAdd;
        this._hostname = config.hostname;
        this._image = config.image;
        this._ipcMode = config.ipcMode;
        this._links = config.links;
        this._logDriver = config.logDriver;
        this._logOpts = config.logOpts;
        this._logs = config.logs;
        this._maxRetryCount = config.maxRetryCount;
        this._memory = config.memory;
        this._memorySwap = config.memorySwap;
        this._mustRun = config.mustRun;
        this._name = config.name;
        this._networkAlias = config.networkAlias;
        this._networkMode = config.networkMode;
        this._networks = config.networks;
        this._pidMode = config.pidMode;
        this._privileged = config.privileged;
        this._publishAllPorts = config.publishAllPorts;
        this._readOnly = config.readOnly;
        this._restart = config.restart;
        this._rm = config.rm;
        this._shmSize = config.shmSize;
        this._start = config.start;
        this._sysctls = config.sysctls;
        this._tmpfs = config.tmpfs;
        this._user = config.user;
        this._usernsMode = config.usernsMode;
        this._workingDir = config.workingDir;
        this._capabilities = config.capabilities;
        this._devices = config.devices;
        this._healthcheck = config.healthcheck;
        this._host = config.host;
        this._labels = config.labels;
        this._mounts = config.mounts;
        this._networksAdvanced = config.networksAdvanced;
        this._ports = config.ports;
        this._ulimit = config.ulimit;
        this._upload = config.upload;
        this._volumes = config.volumes;
    }
    /**
     * @stability stable
     */
    get attach() {
        return this.getBooleanAttribute('attach');
    }
    /**
     * @stability stable
     */
    set attach(value) {
        this._attach = value;
    }
    /**
     * @stability stable
     */
    resetAttach() {
        this._attach = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get attachInput() {
        return this._attach;
    }
    // bridge - computed: true, optional: false, required: false
    /**
     * @stability stable
     */
    get bridge() {
        return this.getStringAttribute('bridge');
    }
    /**
     * @stability stable
     */
    get command() {
        return this.getListAttribute('command');
    }
    /**
     * @stability stable
     */
    set command(value) {
        this._command = value;
    }
    /**
     * @stability stable
     */
    resetCommand() {
        this._command = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get commandInput() {
        return this._command;
    }
    // container_logs - computed: true, optional: false, required: false
    /**
     * @stability stable
     */
    get containerLogs() {
        return this.getStringAttribute('container_logs');
    }
    /**
     * @stability stable
     */
    get cpuSet() {
        return this.getStringAttribute('cpu_set');
    }
    /**
     * @stability stable
     */
    set cpuSet(value) {
        this._cpuSet = value;
    }
    /**
     * @stability stable
     */
    resetCpuSet() {
        this._cpuSet = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get cpuSetInput() {
        return this._cpuSet;
    }
    /**
     * @stability stable
     */
    get cpuShares() {
        return this.getNumberAttribute('cpu_shares');
    }
    /**
     * @stability stable
     */
    set cpuShares(value) {
        this._cpuShares = value;
    }
    /**
     * @stability stable
     */
    resetCpuShares() {
        this._cpuShares = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get cpuSharesInput() {
        return this._cpuShares;
    }
    /**
     * @stability stable
     */
    get destroyGraceSeconds() {
        return this.getNumberAttribute('destroy_grace_seconds');
    }
    /**
     * @stability stable
     */
    set destroyGraceSeconds(value) {
        this._destroyGraceSeconds = value;
    }
    /**
     * @stability stable
     */
    resetDestroyGraceSeconds() {
        this._destroyGraceSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get destroyGraceSecondsInput() {
        return this._destroyGraceSeconds;
    }
    /**
     * @stability stable
     */
    get dns() {
        return this.getListAttribute('dns');
    }
    /**
     * @stability stable
     */
    set dns(value) {
        this._dns = value;
    }
    /**
     * @stability stable
     */
    resetDns() {
        this._dns = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get dnsInput() {
        return this._dns;
    }
    /**
     * @stability stable
     */
    get dnsOpts() {
        return this.getListAttribute('dns_opts');
    }
    /**
     * @stability stable
     */
    set dnsOpts(value) {
        this._dnsOpts = value;
    }
    /**
     * @stability stable
     */
    resetDnsOpts() {
        this._dnsOpts = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get dnsOptsInput() {
        return this._dnsOpts;
    }
    /**
     * @stability stable
     */
    get dnsSearch() {
        return this.getListAttribute('dns_search');
    }
    /**
     * @stability stable
     */
    set dnsSearch(value) {
        this._dnsSearch = value;
    }
    /**
     * @stability stable
     */
    resetDnsSearch() {
        this._dnsSearch = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get dnsSearchInput() {
        return this._dnsSearch;
    }
    /**
     * @stability stable
     */
    get domainname() {
        return this.getStringAttribute('domainname');
    }
    /**
     * @stability stable
     */
    set domainname(value) {
        this._domainname = value;
    }
    /**
     * @stability stable
     */
    resetDomainname() {
        this._domainname = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get domainnameInput() {
        return this._domainname;
    }
    /**
     * @stability stable
     */
    get entrypoint() {
        return this.getListAttribute('entrypoint');
    }
    /**
     * @stability stable
     */
    set entrypoint(value) {
        this._entrypoint = value;
    }
    /**
     * @stability stable
     */
    resetEntrypoint() {
        this._entrypoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get entrypointInput() {
        return this._entrypoint;
    }
    /**
     * @stability stable
     */
    get env() {
        return this.getListAttribute('env');
    }
    /**
     * @stability stable
     */
    set env(value) {
        this._env = value;
    }
    /**
     * @stability stable
     */
    resetEnv() {
        this._env = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get envInput() {
        return this._env;
    }
    // exit_code - computed: true, optional: false, required: false
    /**
     * @stability stable
     */
    get exitCode() {
        return this.getNumberAttribute('exit_code');
    }
    // gateway - computed: true, optional: false, required: false
    /**
     * @stability stable
     */
    get gateway() {
        return this.getStringAttribute('gateway');
    }
    /**
     * @stability stable
     */
    get groupAdd() {
        return this.getListAttribute('group_add');
    }
    /**
     * @stability stable
     */
    set groupAdd(value) {
        this._groupAdd = value;
    }
    /**
     * @stability stable
     */
    resetGroupAdd() {
        this._groupAdd = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get groupAddInput() {
        return this._groupAdd;
    }
    /**
     * @stability stable
     */
    get hostname() {
        return this.getStringAttribute('hostname');
    }
    /**
     * @stability stable
     */
    set hostname(value) {
        this._hostname = value;
    }
    /**
     * @stability stable
     */
    resetHostname() {
        this._hostname = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get hostnameInput() {
        return this._hostname;
    }
    // id - computed: true, optional: true, required: false
    /**
     * @stability stable
     */
    get id() {
        return this.getStringAttribute('id');
    }
    /**
     * @stability stable
     */
    get image() {
        return this.getStringAttribute('image');
    }
    /**
     * @stability stable
     */
    set image(value) {
        this._image = value;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get imageInput() {
        return this._image;
    }
    // ip_address - computed: true, optional: false, required: false
    /**
     * @stability stable
     */
    get ipAddress() {
        return this.getStringAttribute('ip_address');
    }
    // ip_prefix_length - computed: true, optional: false, required: false
    /**
     * @stability stable
     */
    get ipPrefixLength() {
        return this.getNumberAttribute('ip_prefix_length');
    }
    /**
     * @stability stable
     */
    get ipcMode() {
        return this.getStringAttribute('ipc_mode');
    }
    /**
     * @stability stable
     */
    set ipcMode(value) {
        this._ipcMode = value;
    }
    /**
     * @stability stable
     */
    resetIpcMode() {
        this._ipcMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get ipcModeInput() {
        return this._ipcMode;
    }
    /**
     * @stability stable
     */
    get links() {
        return this.getListAttribute('links');
    }
    /**
     * @stability stable
     */
    set links(value) {
        this._links = value;
    }
    /**
     * @stability stable
     */
    resetLinks() {
        this._links = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get linksInput() {
        return this._links;
    }
    /**
     * @stability stable
     */
    get logDriver() {
        return this.getStringAttribute('log_driver');
    }
    /**
     * @stability stable
     */
    set logDriver(value) {
        this._logDriver = value;
    }
    /**
     * @stability stable
     */
    resetLogDriver() {
        this._logDriver = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get logDriverInput() {
        return this._logDriver;
    }
    /**
     * @stability stable
     */
    get logOpts() {
        return this.interpolationForAttribute('log_opts'); // Getting the computed value is not yet implemented
    }
    /**
     * @stability stable
     */
    set logOpts(value) {
        this._logOpts = value;
    }
    /**
     * @stability stable
     */
    resetLogOpts() {
        this._logOpts = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get logOptsInput() {
        return this._logOpts;
    }
    /**
     * @stability stable
     */
    get logs() {
        return this.getBooleanAttribute('logs');
    }
    /**
     * @stability stable
     */
    set logs(value) {
        this._logs = value;
    }
    /**
     * @stability stable
     */
    resetLogs() {
        this._logs = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get logsInput() {
        return this._logs;
    }
    /**
     * @stability stable
     */
    get maxRetryCount() {
        return this.getNumberAttribute('max_retry_count');
    }
    /**
     * @stability stable
     */
    set maxRetryCount(value) {
        this._maxRetryCount = value;
    }
    /**
     * @stability stable
     */
    resetMaxRetryCount() {
        this._maxRetryCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get maxRetryCountInput() {
        return this._maxRetryCount;
    }
    /**
     * @stability stable
     */
    get memory() {
        return this.getNumberAttribute('memory');
    }
    /**
     * @stability stable
     */
    set memory(value) {
        this._memory = value;
    }
    /**
     * @stability stable
     */
    resetMemory() {
        this._memory = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get memoryInput() {
        return this._memory;
    }
    /**
     * @stability stable
     */
    get memorySwap() {
        return this.getNumberAttribute('memory_swap');
    }
    /**
     * @stability stable
     */
    set memorySwap(value) {
        this._memorySwap = value;
    }
    /**
     * @stability stable
     */
    resetMemorySwap() {
        this._memorySwap = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get memorySwapInput() {
        return this._memorySwap;
    }
    /**
     * @stability stable
     */
    get mustRun() {
        return this.getBooleanAttribute('must_run');
    }
    /**
     * @stability stable
     */
    set mustRun(value) {
        this._mustRun = value;
    }
    /**
     * @stability stable
     */
    resetMustRun() {
        this._mustRun = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get mustRunInput() {
        return this._mustRun;
    }
    /**
     * @stability stable
     */
    get name() {
        return this.getStringAttribute('name');
    }
    /**
     * @stability stable
     */
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get nameInput() {
        return this._name;
    }
    /**
     * @stability stable
     */
    get networkAlias() {
        return this.getListAttribute('network_alias');
    }
    /**
     * @stability stable
     */
    set networkAlias(value) {
        this._networkAlias = value;
    }
    /**
     * @stability stable
     */
    resetNetworkAlias() {
        this._networkAlias = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get networkAliasInput() {
        return this._networkAlias;
    }
    // network_data - computed: true, optional: false, required: false
    /**
     * @stability stable
     */
    networkData(index) {
        return new ContainerNetworkData(this, 'network_data', index);
    }
    /**
     * @stability stable
     */
    get networkMode() {
        return this.getStringAttribute('network_mode');
    }
    /**
     * @stability stable
     */
    set networkMode(value) {
        this._networkMode = value;
    }
    /**
     * @stability stable
     */
    resetNetworkMode() {
        this._networkMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get networkModeInput() {
        return this._networkMode;
    }
    /**
     * @stability stable
     */
    get networks() {
        return this.getListAttribute('networks');
    }
    /**
     * @stability stable
     */
    set networks(value) {
        this._networks = value;
    }
    /**
     * @stability stable
     */
    resetNetworks() {
        this._networks = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get networksInput() {
        return this._networks;
    }
    /**
     * @stability stable
     */
    get pidMode() {
        return this.getStringAttribute('pid_mode');
    }
    /**
     * @stability stable
     */
    set pidMode(value) {
        this._pidMode = value;
    }
    /**
     * @stability stable
     */
    resetPidMode() {
        this._pidMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get pidModeInput() {
        return this._pidMode;
    }
    /**
     * @stability stable
     */
    get privileged() {
        return this.getBooleanAttribute('privileged');
    }
    /**
     * @stability stable
     */
    set privileged(value) {
        this._privileged = value;
    }
    /**
     * @stability stable
     */
    resetPrivileged() {
        this._privileged = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get privilegedInput() {
        return this._privileged;
    }
    /**
     * @stability stable
     */
    get publishAllPorts() {
        return this.getBooleanAttribute('publish_all_ports');
    }
    /**
     * @stability stable
     */
    set publishAllPorts(value) {
        this._publishAllPorts = value;
    }
    /**
     * @stability stable
     */
    resetPublishAllPorts() {
        this._publishAllPorts = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get publishAllPortsInput() {
        return this._publishAllPorts;
    }
    /**
     * @stability stable
     */
    get readOnly() {
        return this.getBooleanAttribute('read_only');
    }
    /**
     * @stability stable
     */
    set readOnly(value) {
        this._readOnly = value;
    }
    /**
     * @stability stable
     */
    resetReadOnly() {
        this._readOnly = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get readOnlyInput() {
        return this._readOnly;
    }
    /**
     * @stability stable
     */
    get restart() {
        return this.getStringAttribute('restart');
    }
    /**
     * @stability stable
     */
    set restart(value) {
        this._restart = value;
    }
    /**
     * @stability stable
     */
    resetRestart() {
        this._restart = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get restartInput() {
        return this._restart;
    }
    /**
     * @stability stable
     */
    get rm() {
        return this.getBooleanAttribute('rm');
    }
    /**
     * @stability stable
     */
    set rm(value) {
        this._rm = value;
    }
    /**
     * @stability stable
     */
    resetRm() {
        this._rm = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get rmInput() {
        return this._rm;
    }
    /**
     * @stability stable
     */
    get shmSize() {
        return this.getNumberAttribute('shm_size');
    }
    /**
     * @stability stable
     */
    set shmSize(value) {
        this._shmSize = value;
    }
    /**
     * @stability stable
     */
    resetShmSize() {
        this._shmSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get shmSizeInput() {
        return this._shmSize;
    }
    /**
     * @stability stable
     */
    get start() {
        return this.getBooleanAttribute('start');
    }
    /**
     * @stability stable
     */
    set start(value) {
        this._start = value;
    }
    /**
     * @stability stable
     */
    resetStart() {
        this._start = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get startInput() {
        return this._start;
    }
    /**
     * @stability stable
     */
    get sysctls() {
        return this.interpolationForAttribute('sysctls');
    }
    /**
     * @stability stable
     */
    set sysctls(value) {
        this._sysctls = value;
    }
    /**
     * @stability stable
     */
    resetSysctls() {
        this._sysctls = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get sysctlsInput() {
        return this._sysctls;
    }
    /**
     * @stability stable
     */
    get tmpfs() {
        return this.interpolationForAttribute('tmpfs');
    }
    /**
     * @stability stable
     */
    set tmpfs(value) {
        this._tmpfs = value;
    }
    /**
     * @stability stable
     */
    resetTmpfs() {
        this._tmpfs = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get tmpfsInput() {
        return this._tmpfs;
    }
    /**
     * @stability stable
     */
    get user() {
        return this.getStringAttribute('user');
    }
    /**
     * @stability stable
     */
    set user(value) {
        this._user = value;
    }
    /**
     * @stability stable
     */
    resetUser() {
        this._user = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get userInput() {
        return this._user;
    }
    /**
     * @stability stable
     */
    get usernsMode() {
        return this.getStringAttribute('userns_mode');
    }
    /**
     * @stability stable
     */
    set usernsMode(value) {
        this._usernsMode = value;
    }
    /**
     * @stability stable
     */
    resetUsernsMode() {
        this._usernsMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get usernsModeInput() {
        return this._usernsMode;
    }
    /**
     * @stability stable
     */
    get workingDir() {
        return this.getStringAttribute('working_dir');
    }
    /**
     * @stability stable
     */
    set workingDir(value) {
        this._workingDir = value;
    }
    /**
     * @stability stable
     */
    resetWorkingDir() {
        this._workingDir = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get workingDirInput() {
        return this._workingDir;
    }
    /**
     * @stability stable
     */
    get capabilities() {
        return this.interpolationForAttribute('capabilities');
    }
    /**
     * @stability stable
     */
    set capabilities(value) {
        this._capabilities = value;
    }
    /**
     * @stability stable
     */
    resetCapabilities() {
        this._capabilities = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get capabilitiesInput() {
        return this._capabilities;
    }
    /**
     * @stability stable
     */
    get devices() {
        return this.interpolationForAttribute('devices');
    }
    /**
     * @stability stable
     */
    set devices(value) {
        this._devices = value;
    }
    /**
     * @stability stable
     */
    resetDevices() {
        this._devices = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get devicesInput() {
        return this._devices;
    }
    /**
     * @stability stable
     */
    get healthcheck() {
        return this.interpolationForAttribute('healthcheck');
    }
    /**
     * @stability stable
     */
    set healthcheck(value) {
        this._healthcheck = value;
    }
    /**
     * @stability stable
     */
    resetHealthcheck() {
        this._healthcheck = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get healthcheckInput() {
        return this._healthcheck;
    }
    /**
     * @stability stable
     */
    get host() {
        return this.interpolationForAttribute('host');
    }
    /**
     * @stability stable
     */
    set host(value) {
        this._host = value;
    }
    /**
     * @stability stable
     */
    resetHost() {
        this._host = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get hostInput() {
        return this._host;
    }
    /**
     * @stability stable
     */
    get labels() {
        return this.interpolationForAttribute('labels');
    }
    /**
     * @stability stable
     */
    set labels(value) {
        this._labels = value;
    }
    /**
     * @stability stable
     */
    resetLabels() {
        this._labels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get labelsInput() {
        return this._labels;
    }
    /**
     * @stability stable
     */
    get mounts() {
        return this.interpolationForAttribute('mounts');
    }
    /**
     * @stability stable
     */
    set mounts(value) {
        this._mounts = value;
    }
    /**
     * @stability stable
     */
    resetMounts() {
        this._mounts = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get mountsInput() {
        return this._mounts;
    }
    /**
     * @stability stable
     */
    get networksAdvanced() {
        return this.interpolationForAttribute('networks_advanced');
    }
    /**
     * @stability stable
     */
    set networksAdvanced(value) {
        this._networksAdvanced = value;
    }
    /**
     * @stability stable
     */
    resetNetworksAdvanced() {
        this._networksAdvanced = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get networksAdvancedInput() {
        return this._networksAdvanced;
    }
    /**
     * @stability stable
     */
    get ports() {
        return this.interpolationForAttribute('ports');
    }
    /**
     * @stability stable
     */
    set ports(value) {
        this._ports = value;
    }
    /**
     * @stability stable
     */
    resetPorts() {
        this._ports = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get portsInput() {
        return this._ports;
    }
    /**
     * @stability stable
     */
    get ulimit() {
        return this.interpolationForAttribute('ulimit');
    }
    /**
     * @stability stable
     */
    set ulimit(value) {
        this._ulimit = value;
    }
    /**
     * @stability stable
     */
    resetUlimit() {
        this._ulimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get ulimitInput() {
        return this._ulimit;
    }
    /**
     * @stability stable
     */
    get upload() {
        return this.interpolationForAttribute('upload');
    }
    /**
     * @stability stable
     */
    set upload(value) {
        this._upload = value;
    }
    /**
     * @stability stable
     */
    resetUpload() {
        this._upload = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get uploadInput() {
        return this._upload;
    }
    /**
     * @stability stable
     */
    get volumes() {
        return this.interpolationForAttribute('volumes');
    }
    /**
     * @stability stable
     */
    set volumes(value) {
        this._volumes = value;
    }
    /**
     * @stability stable
     */
    resetVolumes() {
        this._volumes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get volumesInput() {
        return this._volumes;
    }
    // =========
    // SYNTHESIS
    // =========
    /**
     * @stability stable
     */
    synthesizeAttributes() {
        return {
            attach: cdktf.booleanToTerraform(this._attach),
            command: cdktf.listMapper(cdktf.stringToTerraform)(this._command),
            cpu_set: cdktf.stringToTerraform(this._cpuSet),
            cpu_shares: cdktf.numberToTerraform(this._cpuShares),
            destroy_grace_seconds: cdktf.numberToTerraform(this._destroyGraceSeconds),
            dns: cdktf.listMapper(cdktf.stringToTerraform)(this._dns),
            dns_opts: cdktf.listMapper(cdktf.stringToTerraform)(this._dnsOpts),
            dns_search: cdktf.listMapper(cdktf.stringToTerraform)(this._dnsSearch),
            domainname: cdktf.stringToTerraform(this._domainname),
            entrypoint: cdktf.listMapper(cdktf.stringToTerraform)(this._entrypoint),
            env: cdktf.listMapper(cdktf.stringToTerraform)(this._env),
            group_add: cdktf.listMapper(cdktf.stringToTerraform)(this._groupAdd),
            hostname: cdktf.stringToTerraform(this._hostname),
            image: cdktf.stringToTerraform(this._image),
            ipc_mode: cdktf.stringToTerraform(this._ipcMode),
            links: cdktf.listMapper(cdktf.stringToTerraform)(this._links),
            log_driver: cdktf.stringToTerraform(this._logDriver),
            log_opts: cdktf.hashMapper(cdktf.anyToTerraform)(this._logOpts),
            logs: cdktf.booleanToTerraform(this._logs),
            max_retry_count: cdktf.numberToTerraform(this._maxRetryCount),
            memory: cdktf.numberToTerraform(this._memory),
            memory_swap: cdktf.numberToTerraform(this._memorySwap),
            must_run: cdktf.booleanToTerraform(this._mustRun),
            name: cdktf.stringToTerraform(this._name),
            network_alias: cdktf.listMapper(cdktf.stringToTerraform)(this._networkAlias),
            network_mode: cdktf.stringToTerraform(this._networkMode),
            networks: cdktf.listMapper(cdktf.stringToTerraform)(this._networks),
            pid_mode: cdktf.stringToTerraform(this._pidMode),
            privileged: cdktf.booleanToTerraform(this._privileged),
            publish_all_ports: cdktf.booleanToTerraform(this._publishAllPorts),
            read_only: cdktf.booleanToTerraform(this._readOnly),
            restart: cdktf.stringToTerraform(this._restart),
            rm: cdktf.booleanToTerraform(this._rm),
            shm_size: cdktf.numberToTerraform(this._shmSize),
            start: cdktf.booleanToTerraform(this._start),
            sysctls: cdktf.hashMapper(cdktf.anyToTerraform)(this._sysctls),
            tmpfs: cdktf.hashMapper(cdktf.anyToTerraform)(this._tmpfs),
            user: cdktf.stringToTerraform(this._user),
            userns_mode: cdktf.stringToTerraform(this._usernsMode),
            working_dir: cdktf.stringToTerraform(this._workingDir),
            capabilities: cdktf.listMapper(containerCapabilitiesToTerraform)(this._capabilities),
            devices: cdktf.listMapper(containerDevicesToTerraform)(this._devices),
            healthcheck: cdktf.listMapper(containerHealthcheckToTerraform)(this._healthcheck),
            host: cdktf.listMapper(containerHostToTerraform)(this._host),
            labels: cdktf.listMapper(containerLabelsToTerraform)(this._labels),
            mounts: cdktf.listMapper(containerMountsToTerraform)(this._mounts),
            networks_advanced: cdktf.listMapper(containerNetworksAdvancedToTerraform)(this._networksAdvanced),
            ports: cdktf.listMapper(containerPortsToTerraform)(this._ports),
            ulimit: cdktf.listMapper(containerUlimitToTerraform)(this._ulimit),
            upload: cdktf.listMapper(containerUploadToTerraform)(this._upload),
            volumes: cdktf.listMapper(containerVolumesToTerraform)(this._volumes),
        };
    }
}
exports.Container = Container;
//# sourceMappingURL=data:application/json;base64,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