import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SecretConfig extends cdktf.TerraformMetaArguments {
    /**
     * Base64-url-safe-encoded secret data.
     *
     * @stability stable
     */
    readonly data: string;
    /**
     * User-defined name of the secret.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * labels block.
     *
     * @stability stable
     */
    readonly labels?: SecretLabels[];
}
/**
 * @stability stable
 */
export interface SecretLabels {
    /**
     * Name of the label.
     *
     * @stability stable
     */
    readonly label: string;
    /**
     * Value of the label.
     *
     * @stability stable
     */
    readonly value: string;
}
/**
 * @stability stable
 */
export declare class Secret extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SecretConfig);
    private _data;
    /**
     * @stability stable
     */
    get data(): string;
    /**
     * @stability stable
     */
    set data(value: string);
    /**
     * @stability stable
     */
    get dataInput(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): SecretLabels[];
    /**
     * @stability stable
     */
    set labels(value: SecretLabels[]);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): SecretLabels[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
