import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ServiceConfig extends cdktf.TerraformMetaArguments {
    /**
     * @stability stable
     */
    readonly auth?: {
        [key: string]: string;
    };
    /**
     * Name of the service.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * converge_config block.
     *
     * @stability stable
     */
    readonly convergeConfig?: ServiceConvergeConfig[];
    /**
     * endpoint_spec block.
     *
     * @stability stable
     */
    readonly endpointSpec?: ServiceEndpointSpec[];
    /**
     * labels block.
     *
     * @stability stable
     */
    readonly labels?: ServiceLabels[];
    /**
     * mode block.
     *
     * @stability stable
     */
    readonly mode?: ServiceMode[];
    /**
     * rollback_config block.
     *
     * @stability stable
     */
    readonly rollbackConfig?: ServiceRollbackConfig[];
    /**
     * task_spec block.
     *
     * @stability stable
     */
    readonly taskSpec: ServiceTaskSpec[];
    /**
     * update_config block.
     *
     * @stability stable
     */
    readonly updateConfig?: ServiceUpdateConfig[];
}
/**
 * @stability stable
 */
export interface ServiceConvergeConfig {
    /**
     * The interval to check if the desired state is reached (ms|s).
     *
     * Default: 7s
     *
     * @stability stable
     */
    readonly delay?: string;
    /**
     * The timeout of the service to reach the desired state (s|m).
     *
     * Default: 3m
     *
     * @stability stable
     */
    readonly timeout?: string;
}
/**
 * @stability stable
 */
export interface ServiceEndpointSpecPorts {
    /**
     * A random name for the port.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Rrepresents the protocol of a port: 'tcp', 'udp' or 'sctp'.
     *
     * @stability stable
     */
    readonly protocol?: string;
    /**
     * Represents the mode in which the port is to be published: 'ingress' or 'host'.
     *
     * @stability stable
     */
    readonly publishMode?: string;
    /**
     * The port on the swarm hosts.
     *
     * @stability stable
     */
    readonly publishedPort?: number;
    /**
     * The port inside the container.
     *
     * @stability stable
     */
    readonly targetPort: number;
}
/**
 * @stability stable
 */
export interface ServiceEndpointSpec {
    /**
     * The mode of resolution to use for internal load balancing between tasks.
     *
     * @stability stable
     */
    readonly mode?: string;
    /**
     * ports block.
     *
     * @stability stable
     */
    readonly ports?: ServiceEndpointSpecPorts[];
}
/**
 * @stability stable
 */
export interface ServiceLabels {
    /**
     * Name of the label.
     *
     * @stability stable
     */
    readonly label: string;
    /**
     * Value of the label.
     *
     * @stability stable
     */
    readonly value: string;
}
/**
 * @stability stable
 */
export interface ServiceModeReplicated {
    /**
     * The amount of replicas of the service.
     *
     * @stability stable
     */
    readonly replicas?: number;
}
/**
 * @stability stable
 */
export interface ServiceMode {
    /**
     * The global service mode.
     *
     * @stability stable
     */
    readonly global?: boolean;
    /**
     * replicated block.
     *
     * @stability stable
     */
    readonly replicated?: ServiceModeReplicated[];
}
/**
 * @stability stable
 */
export interface ServiceRollbackConfig {
    /**
     * Delay between task rollbacks (ns|us|ms|s|m|h).
     *
     * @stability stable
     */
    readonly delay?: string;
    /**
     * Action on rollback failure: pause | continue.
     *
     * @stability stable
     */
    readonly failureAction?: string;
    /**
     * Failure rate to tolerate during a rollback.
     *
     * @stability stable
     */
    readonly maxFailureRatio?: string;
    /**
     * Duration after each task rollback to monitor for failure (ns|us|ms|s|m|h).
     *
     * @stability stable
     */
    readonly monitor?: string;
    /**
     * Rollback order: either 'stop-first' or 'start-first'.
     *
     * @stability stable
     */
    readonly order?: string;
    /**
     * Maximum number of tasks to be rollbacked in one iteration.
     *
     * @stability stable
     */
    readonly parallelism?: number;
}
/**
 * @stability stable
 */
export interface ServiceTaskSpecContainerSpecConfigs {
    /**
     * ID of the specific config that we're referencing.
     *
     * @stability stable
     */
    readonly configId: string;
    /**
     * Name of the config that this references, but this is just provided for lookup/display purposes.
     *
     * The config in the reference will be identified by its ID
     *
     * @stability stable
     */
    readonly configName?: string;
    /**
     * Represents the file GID.
     *
     * @stability stable
     */
    readonly fileGid?: string;
    /**
     * Represents represents the FileMode of the file.
     *
     * @stability stable
     */
    readonly fileMode?: number;
    /**
     * Represents the final filename in the filesystem.
     *
     * @stability stable
     */
    readonly fileName: string;
    /**
     * Represents the file UID.
     *
     * @stability stable
     */
    readonly fileUid?: string;
}
/**
 * @stability stable
 */
export interface ServiceTaskSpecContainerSpecDnsConfig {
    /**
     * The IP addresses of the name servers.
     *
     * @stability stable
     */
    readonly nameservers: string[];
    /**
     * A list of internal resolver variables to be modified (e.g., debug, ndots:3, etc.).
     *
     * @stability stable
     */
    readonly options?: string[];
    /**
     * A search list for host-name lookup.
     *
     * @stability stable
     */
    readonly search?: string[];
}
/**
 * @stability stable
 */
export interface ServiceTaskSpecContainerSpecHealthcheck {
    /**
     * Time between running the check (ms|s|m|h).
     *
     * @stability stable
     */
    readonly interval?: string;
    /**
     * Consecutive failures needed to report unhealthy.
     *
     * @stability stable
     */
    readonly retries?: number;
    /**
     * Start period for the container to initialize before counting retries towards unstable (ms|s|m|h).
     *
     * @stability stable
     */
    readonly startPeriod?: string;
    /**
     * The test to perform as list.
     *
     * @stability stable
     */
    readonly test: string[];
    /**
     * Maximum time to allow one check to run (ms|s|m|h).
     *
     * @stability stable
     */
    readonly timeout?: string;
}
/**
 * @stability stable
 */
export interface ServiceTaskSpecContainerSpecHosts {
    /**
     * @stability stable
     */
    readonly host: string;
    /**
     * @stability stable
     */
    readonly ip: string;
}
/**
 * @stability stable
 */
export interface ServiceTaskSpecContainerSpecLabels {
    /**
     * Name of the label.
     *
     * @stability stable
     */
    readonly label: string;
    /**
     * Value of the label.
     *
     * @stability stable
     */
    readonly value: string;
}
/**
 * @stability stable
 */
export interface ServiceTaskSpecContainerSpecMountsBindOptions {
    /**
     * A propagation mode with the value.
     *
     * @stability stable
     */
    readonly propagation?: string;
}
/**
 * @stability stable
 */
export interface ServiceTaskSpecContainerSpecMountsTmpfsOptions {
    /**
     * The permission mode for the tmpfs mount in an integer.
     *
     * @stability stable
     */
    readonly mode?: number;
    /**
     * The size for the tmpfs mount in bytes.
     *
     * @stability stable
     */
    readonly sizeBytes?: number;
}
/**
 * @stability stable
 */
export interface ServiceTaskSpecContainerSpecMountsVolumeOptionsLabels {
    /**
     * Name of the label.
     *
     * @stability stable
     */
    readonly label: string;
    /**
     * Value of the label.
     *
     * @stability stable
     */
    readonly value: string;
}
/**
 * @stability stable
 */
export interface ServiceTaskSpecContainerSpecMountsVolumeOptions {
    /**
     * Name of the driver to use to create the volume.
     *
     * @stability stable
     */
    readonly driverName?: string;
    /**
     * key/value map of driver specific options.
     *
     * @stability stable
     */
    readonly driverOptions?: {
        [key: string]: string;
    };
    /**
     * Populate volume with data from the target.
     *
     * @stability stable
     */
    readonly noCopy?: boolean;
    /**
     * labels block.
     *
     * @stability stable
     */
    readonly labels?: ServiceTaskSpecContainerSpecMountsVolumeOptionsLabels[];
}
/**
 * @stability stable
 */
export interface ServiceTaskSpecContainerSpecMounts {
    /**
     * Whether the mount should be read-only.
     *
     * @stability stable
     */
    readonly readOnly?: boolean;
    /**
     * Mount source (e.g. a volume name, a host path).
     *
     * @stability stable
     */
    readonly source?: string;
    /**
     * Container path.
     *
     * @stability stable
     */
    readonly target: string;
    /**
     * The mount type.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * bind_options block.
     *
     * @stability stable
     */
    readonly bindOptions?: ServiceTaskSpecContainerSpecMountsBindOptions[];
    /**
     * tmpfs_options block.
     *
     * @stability stable
     */
    readonly tmpfsOptions?: ServiceTaskSpecContainerSpecMountsTmpfsOptions[];
    /**
     * volume_options block.
     *
     * @stability stable
     */
    readonly volumeOptions?: ServiceTaskSpecContainerSpecMountsVolumeOptions[];
}
/**
 * @stability stable
 */
export interface ServiceTaskSpecContainerSpecPrivilegesCredentialSpec {
    /**
     * Load credential spec from this file.
     *
     * @stability stable
     */
    readonly file?: string;
    /**
     * Load credential spec from this value in the Windows registry.
     *
     * @stability stable
     */
    readonly registry?: string;
}
/**
 * @stability stable
 */
export interface ServiceTaskSpecContainerSpecPrivilegesSeLinuxContext {
    /**
     * Disable SELinux.
     *
     * @stability stable
     */
    readonly disable?: boolean;
    /**
     * SELinux level label.
     *
     * @stability stable
     */
    readonly level?: string;
    /**
     * SELinux role label.
     *
     * @stability stable
     */
    readonly role?: string;
    /**
     * SELinux type label.
     *
     * @stability stable
     */
    readonly type?: string;
    /**
     * SELinux user label.
     *
     * @stability stable
     */
    readonly user?: string;
}
/**
 * @stability stable
 */
export interface ServiceTaskSpecContainerSpecPrivileges {
    /**
     * credential_spec block.
     *
     * @stability stable
     */
    readonly credentialSpec?: ServiceTaskSpecContainerSpecPrivilegesCredentialSpec[];
    /**
     * se_linux_context block.
     *
     * @stability stable
     */
    readonly seLinuxContext?: ServiceTaskSpecContainerSpecPrivilegesSeLinuxContext[];
}
/**
 * @stability stable
 */
export interface ServiceTaskSpecContainerSpecSecrets {
    /**
     * Represents the file GID.
     *
     * @stability stable
     */
    readonly fileGid?: string;
    /**
     * Represents represents the FileMode of the file.
     *
     * @stability stable
     */
    readonly fileMode?: number;
    /**
     * Represents the final filename in the filesystem.
     *
     * @stability stable
     */
    readonly fileName: string;
    /**
     * Represents the file UID.
     *
     * @stability stable
     */
    readonly fileUid?: string;
    /**
     * ID of the specific secret that we're referencing.
     *
     * @stability stable
     */
    readonly secretId: string;
    /**
     * Name of the secret that this references, but this is just provided for lookup/display purposes.
     *
     * The config in the reference will be identified by its ID
     *
     * @stability stable
     */
    readonly secretName?: string;
}
/**
 * @stability stable
 */
export interface ServiceTaskSpecContainerSpec {
    /**
     * Arguments to the command.
     *
     * @stability stable
     */
    readonly args?: string[];
    /**
     * The command to be run in the image.
     *
     * @stability stable
     */
    readonly command?: string[];
    /**
     * The working directory for commands to run in.
     *
     * @stability stable
     */
    readonly dir?: string;
    /**
     * A list of environment variables in the form VAR="value".
     *
     * @stability stable
     */
    readonly env?: {
        [key: string]: string;
    };
    /**
     * A list of additional groups that the container process will run as.
     *
     * @stability stable
     */
    readonly groups?: string[];
    /**
     * The hostname to use for the container, as a valid RFC 1123 hostname.
     *
     * @stability stable
     */
    readonly hostname?: string;
    /**
     * The image name to use for the containers of the service.
     *
     * @stability stable
     */
    readonly image: string;
    /**
     * Isolation technology of the containers running the service.
     *
     * (Windows only)
     *
     * @stability stable
     */
    readonly isolation?: string;
    /**
     * Mount the container's root filesystem as read only.
     *
     * @stability stable
     */
    readonly readOnly?: boolean;
    /**
     * Amount of time to wait for the container to terminate before forcefully removing it (ms|s|m|h).
     *
     * @stability stable
     */
    readonly stopGracePeriod?: string;
    /**
     * Signal to stop the container.
     *
     * @stability stable
     */
    readonly stopSignal?: string;
    /**
     * The user inside the container.
     *
     * @stability stable
     */
    readonly user?: string;
    /**
     * configs block.
     *
     * @stability stable
     */
    readonly configs?: ServiceTaskSpecContainerSpecConfigs[];
    /**
     * dns_config block.
     *
     * @stability stable
     */
    readonly dnsConfig?: ServiceTaskSpecContainerSpecDnsConfig[];
    /**
     * healthcheck block.
     *
     * @stability stable
     */
    readonly healthcheck?: ServiceTaskSpecContainerSpecHealthcheck[];
    /**
     * hosts block.
     *
     * @stability stable
     */
    readonly hosts?: ServiceTaskSpecContainerSpecHosts[];
    /**
     * labels block.
     *
     * @stability stable
     */
    readonly labels?: ServiceTaskSpecContainerSpecLabels[];
    /**
     * mounts block.
     *
     * @stability stable
     */
    readonly mounts?: ServiceTaskSpecContainerSpecMounts[];
    /**
     * privileges block.
     *
     * @stability stable
     */
    readonly privileges?: ServiceTaskSpecContainerSpecPrivileges[];
    /**
     * secrets block.
     *
     * @stability stable
     */
    readonly secrets?: ServiceTaskSpecContainerSpecSecrets[];
}
/**
 * @stability stable
 */
export interface ServiceTaskSpecLogDriver {
    /**
     * The logging driver to use.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The options for the logging driver.
     *
     * @stability stable
     */
    readonly options?: {
        [key: string]: string;
    };
}
/**
 * @stability stable
 */
export interface ServiceTaskSpecPlacementPlatforms {
    /**
     * The architecture, e.g. amd64.
     *
     * @stability stable
     */
    readonly architecture: string;
    /**
     * The operation system, e.g. linux.
     *
     * @stability stable
     */
    readonly os: string;
}
/**
 * @stability stable
 */
export interface ServiceTaskSpecPlacement {
    /**
     * An array of constraints.
     *
     * e.g.: node.role==manager
     *
     * @stability stable
     */
    readonly constraints?: string[];
    /**
     * Preferences provide a way to make the scheduler aware of factors such as topology.
     *
     * They are provided in order from highest to lowest precedence, e.g.: spread=node.role.manager
     *
     * @stability stable
     */
    readonly prefs?: string[];
    /**
     * platforms block.
     *
     * @stability stable
     */
    readonly platforms?: ServiceTaskSpecPlacementPlatforms[];
}
/**
 * @stability stable
 */
export interface ServiceTaskSpecResourcesLimitsGenericResources {
    /**
     * The Integer resources.
     *
     * @stability stable
     */
    readonly discreteResourcesSpec?: string[];
    /**
     * The String resources.
     *
     * @stability stable
     */
    readonly namedResourcesSpec?: string[];
}
/**
 * @stability stable
 */
export interface ServiceTaskSpecResourcesLimits {
    /**
     * The amounf of memory in bytes the container allocates.
     *
     * @stability stable
     */
    readonly memoryBytes?: number;
    /**
     * CPU shares in units of 1/1e9 (or 10^-9) of the CPU.
     *
     * Should be at least 1000000
     *
     * @stability stable
     */
    readonly nanoCpus?: number;
    /**
     * generic_resources block.
     *
     * @stability stable
     */
    readonly genericResources?: ServiceTaskSpecResourcesLimitsGenericResources[];
}
/**
 * @stability stable
 */
export interface ServiceTaskSpecResourcesReservationGenericResources {
    /**
     * The Integer resources.
     *
     * @stability stable
     */
    readonly discreteResourcesSpec?: string[];
    /**
     * The String resources.
     *
     * @stability stable
     */
    readonly namedResourcesSpec?: string[];
}
/**
 * @stability stable
 */
export interface ServiceTaskSpecResourcesReservation {
    /**
     * The amounf of memory in bytes the container allocates.
     *
     * @stability stable
     */
    readonly memoryBytes?: number;
    /**
     * CPU shares in units of 1/1e9 (or 10^-9) of the CPU.
     *
     * Should be at least 1000000
     *
     * @stability stable
     */
    readonly nanoCpus?: number;
    /**
     * generic_resources block.
     *
     * @stability stable
     */
    readonly genericResources?: ServiceTaskSpecResourcesReservationGenericResources[];
}
/**
 * @stability stable
 */
export interface ServiceTaskSpecResources {
    /**
     * limits block.
     *
     * @stability stable
     */
    readonly limits?: ServiceTaskSpecResourcesLimits[];
    /**
     * reservation block.
     *
     * @stability stable
     */
    readonly reservation?: ServiceTaskSpecResourcesReservation[];
}
/**
 * @stability stable
 */
export interface ServiceTaskSpec {
    /**
     * A counter that triggers an update even if no relevant parameters have been changed.
     *
     * See https://github.com/docker/swarmkit/blob/master/api/specs.proto#L126
     *
     * @stability stable
     */
    readonly forceUpdate?: number;
    /**
     * Ids of the networks in which the  container will be put in.
     *
     * @stability stable
     */
    readonly networks?: string[];
    /**
     * Specification for the restart policy which applies to containers created as part of this service.
     *
     * @stability stable
     */
    readonly restartPolicy?: {
        [key: string]: string;
    };
    /**
     * Runtime is the type of runtime specified for the task executor.
     *
     * See https://github.com/moby/moby/blob/master/api/types/swarm/runtime.go
     *
     * @stability stable
     */
    readonly runtime?: string;
    /**
     * container_spec block.
     *
     * @stability stable
     */
    readonly containerSpec: ServiceTaskSpecContainerSpec[];
    /**
     * log_driver block.
     *
     * @stability stable
     */
    readonly logDriver?: ServiceTaskSpecLogDriver[];
    /**
     * placement block.
     *
     * @stability stable
     */
    readonly placement?: ServiceTaskSpecPlacement[];
    /**
     * resources block.
     *
     * @stability stable
     */
    readonly resources?: ServiceTaskSpecResources[];
}
/**
 * @stability stable
 */
export interface ServiceUpdateConfig {
    /**
     * Delay between task updates (ns|us|ms|s|m|h).
     *
     * @stability stable
     */
    readonly delay?: string;
    /**
     * Action on update failure: pause | continue | rollback.
     *
     * @stability stable
     */
    readonly failureAction?: string;
    /**
     * Failure rate to tolerate during an update.
     *
     * @stability stable
     */
    readonly maxFailureRatio?: string;
    /**
     * Duration after each task update to monitor for failure (ns|us|ms|s|m|h).
     *
     * @stability stable
     */
    readonly monitor?: string;
    /**
     * Update order: either 'stop-first' or 'start-first'.
     *
     * @stability stable
     */
    readonly order?: string;
    /**
     * Maximum number of tasks to be updated in one iteration.
     *
     * @stability stable
     */
    readonly parallelism?: number;
}
/**
 * @stability stable
 */
export declare class Service extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ServiceConfig);
    private _auth?;
    /**
     * @stability stable
     */
    get auth(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set auth(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetAuth(): void;
    /**
     * @stability stable
     */
    get authInput(): {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _convergeConfig?;
    /**
     * @stability stable
     */
    get convergeConfig(): ServiceConvergeConfig[];
    /**
     * @stability stable
     */
    set convergeConfig(value: ServiceConvergeConfig[]);
    /**
     * @stability stable
     */
    resetConvergeConfig(): void;
    /**
     * @stability stable
     */
    get convergeConfigInput(): ServiceConvergeConfig[] | undefined;
    private _endpointSpec?;
    /**
     * @stability stable
     */
    get endpointSpec(): ServiceEndpointSpec[];
    /**
     * @stability stable
     */
    set endpointSpec(value: ServiceEndpointSpec[]);
    /**
     * @stability stable
     */
    resetEndpointSpec(): void;
    /**
     * @stability stable
     */
    get endpointSpecInput(): ServiceEndpointSpec[] | undefined;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): ServiceLabels[];
    /**
     * @stability stable
     */
    set labels(value: ServiceLabels[]);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): ServiceLabels[] | undefined;
    private _mode?;
    /**
     * @stability stable
     */
    get mode(): ServiceMode[];
    /**
     * @stability stable
     */
    set mode(value: ServiceMode[]);
    /**
     * @stability stable
     */
    resetMode(): void;
    /**
     * @stability stable
     */
    get modeInput(): ServiceMode[] | undefined;
    private _rollbackConfig?;
    /**
     * @stability stable
     */
    get rollbackConfig(): ServiceRollbackConfig[];
    /**
     * @stability stable
     */
    set rollbackConfig(value: ServiceRollbackConfig[]);
    /**
     * @stability stable
     */
    resetRollbackConfig(): void;
    /**
     * @stability stable
     */
    get rollbackConfigInput(): ServiceRollbackConfig[] | undefined;
    private _taskSpec;
    /**
     * @stability stable
     */
    get taskSpec(): ServiceTaskSpec[];
    /**
     * @stability stable
     */
    set taskSpec(value: ServiceTaskSpec[]);
    /**
     * @stability stable
     */
    get taskSpecInput(): ServiceTaskSpec[];
    private _updateConfig?;
    /**
     * @stability stable
     */
    get updateConfig(): ServiceUpdateConfig[];
    /**
     * @stability stable
     */
    set updateConfig(value: ServiceUpdateConfig[]);
    /**
     * @stability stable
     */
    resetUpdateConfig(): void;
    /**
     * @stability stable
     */
    get updateConfigInput(): ServiceUpdateConfig[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
