"use strict";
// https://www.terraform.io/docs/providers/docker/r/service.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.Service = void 0;
const cdktf = require("cdktf");
function serviceConvergeConfigToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        delay: cdktf.stringToTerraform(struct.delay),
        timeout: cdktf.stringToTerraform(struct.timeout),
    };
}
function serviceEndpointSpecPortsToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        name: cdktf.stringToTerraform(struct.name),
        protocol: cdktf.stringToTerraform(struct.protocol),
        publish_mode: cdktf.stringToTerraform(struct.publishMode),
        published_port: cdktf.numberToTerraform(struct.publishedPort),
        target_port: cdktf.numberToTerraform(struct.targetPort),
    };
}
function serviceEndpointSpecToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        mode: cdktf.stringToTerraform(struct.mode),
        ports: cdktf.listMapper(serviceEndpointSpecPortsToTerraform)(struct.ports),
    };
}
function serviceLabelsToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        label: cdktf.stringToTerraform(struct.label),
        value: cdktf.stringToTerraform(struct.value),
    };
}
function serviceModeReplicatedToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        replicas: cdktf.numberToTerraform(struct.replicas),
    };
}
function serviceModeToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        global: cdktf.booleanToTerraform(struct.global),
        replicated: cdktf.listMapper(serviceModeReplicatedToTerraform)(struct.replicated),
    };
}
function serviceRollbackConfigToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        delay: cdktf.stringToTerraform(struct.delay),
        failure_action: cdktf.stringToTerraform(struct.failureAction),
        max_failure_ratio: cdktf.stringToTerraform(struct.maxFailureRatio),
        monitor: cdktf.stringToTerraform(struct.monitor),
        order: cdktf.stringToTerraform(struct.order),
        parallelism: cdktf.numberToTerraform(struct.parallelism),
    };
}
function serviceTaskSpecContainerSpecConfigsToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        config_id: cdktf.stringToTerraform(struct.configId),
        config_name: cdktf.stringToTerraform(struct.configName),
        file_gid: cdktf.stringToTerraform(struct.fileGid),
        file_mode: cdktf.numberToTerraform(struct.fileMode),
        file_name: cdktf.stringToTerraform(struct.fileName),
        file_uid: cdktf.stringToTerraform(struct.fileUid),
    };
}
function serviceTaskSpecContainerSpecDnsConfigToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        nameservers: cdktf.listMapper(cdktf.stringToTerraform)(struct.nameservers),
        options: cdktf.listMapper(cdktf.stringToTerraform)(struct.options),
        search: cdktf.listMapper(cdktf.stringToTerraform)(struct.search),
    };
}
function serviceTaskSpecContainerSpecHealthcheckToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        interval: cdktf.stringToTerraform(struct.interval),
        retries: cdktf.numberToTerraform(struct.retries),
        start_period: cdktf.stringToTerraform(struct.startPeriod),
        test: cdktf.listMapper(cdktf.stringToTerraform)(struct.test),
        timeout: cdktf.stringToTerraform(struct.timeout),
    };
}
function serviceTaskSpecContainerSpecHostsToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        host: cdktf.stringToTerraform(struct.host),
        ip: cdktf.stringToTerraform(struct.ip),
    };
}
function serviceTaskSpecContainerSpecLabelsToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        label: cdktf.stringToTerraform(struct.label),
        value: cdktf.stringToTerraform(struct.value),
    };
}
function serviceTaskSpecContainerSpecMountsBindOptionsToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        propagation: cdktf.stringToTerraform(struct.propagation),
    };
}
function serviceTaskSpecContainerSpecMountsTmpfsOptionsToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        mode: cdktf.numberToTerraform(struct.mode),
        size_bytes: cdktf.numberToTerraform(struct.sizeBytes),
    };
}
function serviceTaskSpecContainerSpecMountsVolumeOptionsLabelsToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        label: cdktf.stringToTerraform(struct.label),
        value: cdktf.stringToTerraform(struct.value),
    };
}
function serviceTaskSpecContainerSpecMountsVolumeOptionsToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        driver_name: cdktf.stringToTerraform(struct.driverName),
        driver_options: cdktf.hashMapper(cdktf.anyToTerraform)(struct.driverOptions),
        no_copy: cdktf.booleanToTerraform(struct.noCopy),
        labels: cdktf.listMapper(serviceTaskSpecContainerSpecMountsVolumeOptionsLabelsToTerraform)(struct.labels),
    };
}
function serviceTaskSpecContainerSpecMountsToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        read_only: cdktf.booleanToTerraform(struct.readOnly),
        source: cdktf.stringToTerraform(struct.source),
        target: cdktf.stringToTerraform(struct.target),
        type: cdktf.stringToTerraform(struct.type),
        bind_options: cdktf.listMapper(serviceTaskSpecContainerSpecMountsBindOptionsToTerraform)(struct.bindOptions),
        tmpfs_options: cdktf.listMapper(serviceTaskSpecContainerSpecMountsTmpfsOptionsToTerraform)(struct.tmpfsOptions),
        volume_options: cdktf.listMapper(serviceTaskSpecContainerSpecMountsVolumeOptionsToTerraform)(struct.volumeOptions),
    };
}
function serviceTaskSpecContainerSpecPrivilegesCredentialSpecToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        file: cdktf.stringToTerraform(struct.file),
        registry: cdktf.stringToTerraform(struct.registry),
    };
}
function serviceTaskSpecContainerSpecPrivilegesSeLinuxContextToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        disable: cdktf.booleanToTerraform(struct.disable),
        level: cdktf.stringToTerraform(struct.level),
        role: cdktf.stringToTerraform(struct.role),
        type: cdktf.stringToTerraform(struct.type),
        user: cdktf.stringToTerraform(struct.user),
    };
}
function serviceTaskSpecContainerSpecPrivilegesToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        credential_spec: cdktf.listMapper(serviceTaskSpecContainerSpecPrivilegesCredentialSpecToTerraform)(struct.credentialSpec),
        se_linux_context: cdktf.listMapper(serviceTaskSpecContainerSpecPrivilegesSeLinuxContextToTerraform)(struct.seLinuxContext),
    };
}
function serviceTaskSpecContainerSpecSecretsToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        file_gid: cdktf.stringToTerraform(struct.fileGid),
        file_mode: cdktf.numberToTerraform(struct.fileMode),
        file_name: cdktf.stringToTerraform(struct.fileName),
        file_uid: cdktf.stringToTerraform(struct.fileUid),
        secret_id: cdktf.stringToTerraform(struct.secretId),
        secret_name: cdktf.stringToTerraform(struct.secretName),
    };
}
function serviceTaskSpecContainerSpecToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        args: cdktf.listMapper(cdktf.stringToTerraform)(struct.args),
        command: cdktf.listMapper(cdktf.stringToTerraform)(struct.command),
        dir: cdktf.stringToTerraform(struct.dir),
        env: cdktf.hashMapper(cdktf.anyToTerraform)(struct.env),
        groups: cdktf.listMapper(cdktf.stringToTerraform)(struct.groups),
        hostname: cdktf.stringToTerraform(struct.hostname),
        image: cdktf.stringToTerraform(struct.image),
        isolation: cdktf.stringToTerraform(struct.isolation),
        read_only: cdktf.booleanToTerraform(struct.readOnly),
        stop_grace_period: cdktf.stringToTerraform(struct.stopGracePeriod),
        stop_signal: cdktf.stringToTerraform(struct.stopSignal),
        user: cdktf.stringToTerraform(struct.user),
        configs: cdktf.listMapper(serviceTaskSpecContainerSpecConfigsToTerraform)(struct.configs),
        dns_config: cdktf.listMapper(serviceTaskSpecContainerSpecDnsConfigToTerraform)(struct.dnsConfig),
        healthcheck: cdktf.listMapper(serviceTaskSpecContainerSpecHealthcheckToTerraform)(struct.healthcheck),
        hosts: cdktf.listMapper(serviceTaskSpecContainerSpecHostsToTerraform)(struct.hosts),
        labels: cdktf.listMapper(serviceTaskSpecContainerSpecLabelsToTerraform)(struct.labels),
        mounts: cdktf.listMapper(serviceTaskSpecContainerSpecMountsToTerraform)(struct.mounts),
        privileges: cdktf.listMapper(serviceTaskSpecContainerSpecPrivilegesToTerraform)(struct.privileges),
        secrets: cdktf.listMapper(serviceTaskSpecContainerSpecSecretsToTerraform)(struct.secrets),
    };
}
function serviceTaskSpecLogDriverToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        name: cdktf.stringToTerraform(struct.name),
        options: cdktf.hashMapper(cdktf.anyToTerraform)(struct.options),
    };
}
function serviceTaskSpecPlacementPlatformsToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        architecture: cdktf.stringToTerraform(struct.architecture),
        os: cdktf.stringToTerraform(struct.os),
    };
}
function serviceTaskSpecPlacementToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        constraints: cdktf.listMapper(cdktf.stringToTerraform)(struct.constraints),
        prefs: cdktf.listMapper(cdktf.stringToTerraform)(struct.prefs),
        platforms: cdktf.listMapper(serviceTaskSpecPlacementPlatformsToTerraform)(struct.platforms),
    };
}
function serviceTaskSpecResourcesLimitsGenericResourcesToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        discrete_resources_spec: cdktf.listMapper(cdktf.stringToTerraform)(struct.discreteResourcesSpec),
        named_resources_spec: cdktf.listMapper(cdktf.stringToTerraform)(struct.namedResourcesSpec),
    };
}
function serviceTaskSpecResourcesLimitsToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        memory_bytes: cdktf.numberToTerraform(struct.memoryBytes),
        nano_cpus: cdktf.numberToTerraform(struct.nanoCpus),
        generic_resources: cdktf.listMapper(serviceTaskSpecResourcesLimitsGenericResourcesToTerraform)(struct.genericResources),
    };
}
function serviceTaskSpecResourcesReservationGenericResourcesToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        discrete_resources_spec: cdktf.listMapper(cdktf.stringToTerraform)(struct.discreteResourcesSpec),
        named_resources_spec: cdktf.listMapper(cdktf.stringToTerraform)(struct.namedResourcesSpec),
    };
}
function serviceTaskSpecResourcesReservationToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        memory_bytes: cdktf.numberToTerraform(struct.memoryBytes),
        nano_cpus: cdktf.numberToTerraform(struct.nanoCpus),
        generic_resources: cdktf.listMapper(serviceTaskSpecResourcesReservationGenericResourcesToTerraform)(struct.genericResources),
    };
}
function serviceTaskSpecResourcesToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        limits: cdktf.listMapper(serviceTaskSpecResourcesLimitsToTerraform)(struct.limits),
        reservation: cdktf.listMapper(serviceTaskSpecResourcesReservationToTerraform)(struct.reservation),
    };
}
function serviceTaskSpecToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        force_update: cdktf.numberToTerraform(struct.forceUpdate),
        networks: cdktf.listMapper(cdktf.stringToTerraform)(struct.networks),
        restart_policy: cdktf.hashMapper(cdktf.anyToTerraform)(struct.restartPolicy),
        runtime: cdktf.stringToTerraform(struct.runtime),
        container_spec: cdktf.listMapper(serviceTaskSpecContainerSpecToTerraform)(struct.containerSpec),
        log_driver: cdktf.listMapper(serviceTaskSpecLogDriverToTerraform)(struct.logDriver),
        placement: cdktf.listMapper(serviceTaskSpecPlacementToTerraform)(struct.placement),
        resources: cdktf.listMapper(serviceTaskSpecResourcesToTerraform)(struct.resources),
    };
}
function serviceUpdateConfigToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    return {
        delay: cdktf.stringToTerraform(struct.delay),
        failure_action: cdktf.stringToTerraform(struct.failureAction),
        max_failure_ratio: cdktf.stringToTerraform(struct.maxFailureRatio),
        monitor: cdktf.stringToTerraform(struct.monitor),
        order: cdktf.stringToTerraform(struct.order),
        parallelism: cdktf.numberToTerraform(struct.parallelism),
    };
}
// Resource
/**
 * @stability stable
 */
class Service extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
     * @stability stable
     */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'docker_service',
            terraformGeneratorMetadata: {
                providerName: 'docker'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._auth = config.auth;
        this._name = config.name;
        this._convergeConfig = config.convergeConfig;
        this._endpointSpec = config.endpointSpec;
        this._labels = config.labels;
        this._mode = config.mode;
        this._rollbackConfig = config.rollbackConfig;
        this._taskSpec = config.taskSpec;
        this._updateConfig = config.updateConfig;
    }
    /**
     * @stability stable
     */
    get auth() {
        return this.interpolationForAttribute('auth');
    }
    /**
     * @stability stable
     */
    set auth(value) {
        this._auth = value;
    }
    /**
     * @stability stable
     */
    resetAuth() {
        this._auth = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get authInput() {
        return this._auth;
    }
    // id - computed: true, optional: true, required: false
    /**
     * @stability stable
     */
    get id() {
        return this.getStringAttribute('id');
    }
    /**
     * @stability stable
     */
    get name() {
        return this.getStringAttribute('name');
    }
    /**
     * @stability stable
     */
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get nameInput() {
        return this._name;
    }
    /**
     * @stability stable
     */
    get convergeConfig() {
        return this.interpolationForAttribute('converge_config');
    }
    /**
     * @stability stable
     */
    set convergeConfig(value) {
        this._convergeConfig = value;
    }
    /**
     * @stability stable
     */
    resetConvergeConfig() {
        this._convergeConfig = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get convergeConfigInput() {
        return this._convergeConfig;
    }
    /**
     * @stability stable
     */
    get endpointSpec() {
        return this.interpolationForAttribute('endpoint_spec');
    }
    /**
     * @stability stable
     */
    set endpointSpec(value) {
        this._endpointSpec = value;
    }
    /**
     * @stability stable
     */
    resetEndpointSpec() {
        this._endpointSpec = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get endpointSpecInput() {
        return this._endpointSpec;
    }
    /**
     * @stability stable
     */
    get labels() {
        return this.interpolationForAttribute('labels');
    }
    /**
     * @stability stable
     */
    set labels(value) {
        this._labels = value;
    }
    /**
     * @stability stable
     */
    resetLabels() {
        this._labels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get labelsInput() {
        return this._labels;
    }
    /**
     * @stability stable
     */
    get mode() {
        return this.interpolationForAttribute('mode');
    }
    /**
     * @stability stable
     */
    set mode(value) {
        this._mode = value;
    }
    /**
     * @stability stable
     */
    resetMode() {
        this._mode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get modeInput() {
        return this._mode;
    }
    /**
     * @stability stable
     */
    get rollbackConfig() {
        return this.interpolationForAttribute('rollback_config');
    }
    /**
     * @stability stable
     */
    set rollbackConfig(value) {
        this._rollbackConfig = value;
    }
    /**
     * @stability stable
     */
    resetRollbackConfig() {
        this._rollbackConfig = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get rollbackConfigInput() {
        return this._rollbackConfig;
    }
    /**
     * @stability stable
     */
    get taskSpec() {
        return this.interpolationForAttribute('task_spec');
    }
    /**
     * @stability stable
     */
    set taskSpec(value) {
        this._taskSpec = value;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get taskSpecInput() {
        return this._taskSpec;
    }
    /**
     * @stability stable
     */
    get updateConfig() {
        return this.interpolationForAttribute('update_config');
    }
    /**
     * @stability stable
     */
    set updateConfig(value) {
        this._updateConfig = value;
    }
    /**
     * @stability stable
     */
    resetUpdateConfig() {
        this._updateConfig = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get updateConfigInput() {
        return this._updateConfig;
    }
    // =========
    // SYNTHESIS
    // =========
    /**
     * @stability stable
     */
    synthesizeAttributes() {
        return {
            auth: cdktf.hashMapper(cdktf.anyToTerraform)(this._auth),
            name: cdktf.stringToTerraform(this._name),
            converge_config: cdktf.listMapper(serviceConvergeConfigToTerraform)(this._convergeConfig),
            endpoint_spec: cdktf.listMapper(serviceEndpointSpecToTerraform)(this._endpointSpec),
            labels: cdktf.listMapper(serviceLabelsToTerraform)(this._labels),
            mode: cdktf.listMapper(serviceModeToTerraform)(this._mode),
            rollback_config: cdktf.listMapper(serviceRollbackConfigToTerraform)(this._rollbackConfig),
            task_spec: cdktf.listMapper(serviceTaskSpecToTerraform)(this._taskSpec),
            update_config: cdktf.listMapper(serviceUpdateConfigToTerraform)(this._updateConfig),
        };
    }
}
exports.Service = Service;
//# sourceMappingURL=data:application/json;base64,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