from django.urls import path
from newsflash import App
from . import views


urlpatterns = []


def set_urlpatterns(app: App) -> None:
    global urlpatterns

    urlpatterns = [
        path("", views.build_main_view(app), name="home"),
        path("<int:page_num>", views.build_main_view(app), name="home"),
        path("click", views.build_button_view(app), name="click"),
        path("select", views.build_select_view(app), name="select"),
        path("chart", views.build_chart_view(app), name="chart"),
    ]
