from policyengine_us.model_api import *
from typing import List


class UCGID(Enum):
    US = "0100000US"
    AL = "0400000US01"
    AK = "0400000US02"
    AZ = "0400000US04"
    AR = "0400000US05"
    CA = "0400000US06"
    CO = "0400000US08"
    CT = "0400000US09"
    DE = "0400000US10"
    DC = "0400000US11"
    FL = "0400000US12"
    GA = "0400000US13"
    HI = "0400000US15"
    ID = "0400000US16"
    IL = "0400000US17"
    IN = "0400000US18"
    IA = "0400000US19"
    KS = "0400000US20"
    KY = "0400000US21"
    LA = "0400000US22"
    ME = "0400000US23"
    MD = "0400000US24"
    MA = "0400000US25"
    MI = "0400000US26"
    MN = "0400000US27"
    MS = "0400000US28"
    MO = "0400000US29"
    MT = "0400000US30"
    NE = "0400000US31"
    NV = "0400000US32"
    NH = "0400000US33"
    NJ = "0400000US34"
    NM = "0400000US35"
    NY = "0400000US36"
    NC = "0400000US37"
    ND = "0400000US38"
    OH = "0400000US39"
    OK = "0400000US40"
    OR = "0400000US41"
    PA = "0400000US42"
    RI = "0400000US44"
    SC = "0400000US45"
    SD = "0400000US46"
    TN = "0400000US47"
    TX = "0400000US48"
    UT = "0400000US49"
    VT = "0400000US50"
    VA = "0400000US51"
    WA = "0400000US53"
    WV = "0400000US54"
    WI = "0400000US55"
    WY = "0400000US56"
    AL_01 = "5001800US0101"
    AL_02 = "5001800US0102"
    AL_03 = "5001800US0103"
    AL_04 = "5001800US0104"
    AL_05 = "5001800US0105"
    AL_06 = "5001800US0106"
    AL_07 = "5001800US0107"
    AK_01 = "5001800US0200"
    AZ_01 = "5001800US0401"
    AZ_02 = "5001800US0402"
    AZ_03 = "5001800US0403"
    AZ_04 = "5001800US0404"
    AZ_05 = "5001800US0405"
    AZ_06 = "5001800US0406"
    AZ_07 = "5001800US0407"
    AZ_08 = "5001800US0408"
    AZ_09 = "5001800US0409"
    AR_01 = "5001800US0501"
    AR_02 = "5001800US0502"
    AR_03 = "5001800US0503"
    AR_04 = "5001800US0504"
    CA_01 = "5001800US0601"
    CA_02 = "5001800US0602"
    CA_03 = "5001800US0603"
    CA_04 = "5001800US0604"
    CA_05 = "5001800US0605"
    CA_06 = "5001800US0606"
    CA_07 = "5001800US0607"
    CA_08 = "5001800US0608"
    CA_09 = "5001800US0609"
    CA_10 = "5001800US0610"
    CA_11 = "5001800US0611"
    CA_12 = "5001800US0612"
    CA_13 = "5001800US0613"
    CA_14 = "5001800US0614"
    CA_15 = "5001800US0615"
    CA_16 = "5001800US0616"
    CA_17 = "5001800US0617"
    CA_18 = "5001800US0618"
    CA_19 = "5001800US0619"
    CA_20 = "5001800US0620"
    CA_21 = "5001800US0621"
    CA_22 = "5001800US0622"
    CA_23 = "5001800US0623"
    CA_24 = "5001800US0624"
    CA_25 = "5001800US0625"
    CA_26 = "5001800US0626"
    CA_27 = "5001800US0627"
    CA_28 = "5001800US0628"
    CA_29 = "5001800US0629"
    CA_30 = "5001800US0630"
    CA_31 = "5001800US0631"
    CA_32 = "5001800US0632"
    CA_33 = "5001800US0633"
    CA_34 = "5001800US0634"
    CA_35 = "5001800US0635"
    CA_36 = "5001800US0636"
    CA_37 = "5001800US0637"
    CA_38 = "5001800US0638"
    CA_39 = "5001800US0639"
    CA_40 = "5001800US0640"
    CA_41 = "5001800US0641"
    CA_42 = "5001800US0642"
    CA_43 = "5001800US0643"
    CA_44 = "5001800US0644"
    CA_45 = "5001800US0645"
    CA_46 = "5001800US0646"
    CA_47 = "5001800US0647"
    CA_48 = "5001800US0648"
    CA_49 = "5001800US0649"
    CA_50 = "5001800US0650"
    CA_51 = "5001800US0651"
    CA_52 = "5001800US0652"
    CO_01 = "5001800US0801"
    CO_02 = "5001800US0802"
    CO_03 = "5001800US0803"
    CO_04 = "5001800US0804"
    CO_05 = "5001800US0805"
    CO_06 = "5001800US0806"
    CO_07 = "5001800US0807"
    CO_08 = "5001800US0808"
    CT_01 = "5001800US0901"
    CT_02 = "5001800US0902"
    CT_03 = "5001800US0903"
    CT_04 = "5001800US0904"
    CT_05 = "5001800US0905"
    DE_01 = "5001800US1000"
    DC_01 = "5001800US1198"
    FL_01 = "5001800US1201"
    FL_02 = "5001800US1202"
    FL_03 = "5001800US1203"
    FL_04 = "5001800US1204"
    FL_05 = "5001800US1205"
    FL_06 = "5001800US1206"
    FL_07 = "5001800US1207"
    FL_08 = "5001800US1208"
    FL_09 = "5001800US1209"
    FL_10 = "5001800US1210"
    FL_11 = "5001800US1211"
    FL_12 = "5001800US1212"
    FL_13 = "5001800US1213"
    FL_14 = "5001800US1214"
    FL_15 = "5001800US1215"
    FL_16 = "5001800US1216"
    FL_17 = "5001800US1217"
    FL_18 = "5001800US1218"
    FL_19 = "5001800US1219"
    FL_20 = "5001800US1220"
    FL_21 = "5001800US1221"
    FL_22 = "5001800US1222"
    FL_23 = "5001800US1223"
    FL_24 = "5001800US1224"
    FL_25 = "5001800US1225"
    FL_26 = "5001800US1226"
    FL_27 = "5001800US1227"
    FL_28 = "5001800US1228"
    GA_01 = "5001800US1301"
    GA_02 = "5001800US1302"
    GA_03 = "5001800US1303"
    GA_04 = "5001800US1304"
    GA_05 = "5001800US1305"
    GA_06 = "5001800US1306"
    GA_07 = "5001800US1307"
    GA_08 = "5001800US1308"
    GA_09 = "5001800US1309"
    GA_10 = "5001800US1310"
    GA_11 = "5001800US1311"
    GA_12 = "5001800US1312"
    GA_13 = "5001800US1313"
    GA_14 = "5001800US1314"
    HI_01 = "5001800US1501"
    HI_02 = "5001800US1502"
    ID_01 = "5001800US1601"
    ID_02 = "5001800US1602"
    IL_01 = "5001800US1701"
    IL_02 = "5001800US1702"
    IL_03 = "5001800US1703"
    IL_04 = "5001800US1704"
    IL_05 = "5001800US1705"
    IL_06 = "5001800US1706"
    IL_07 = "5001800US1707"
    IL_08 = "5001800US1708"
    IL_09 = "5001800US1709"
    IL_10 = "5001800US1710"
    IL_11 = "5001800US1711"
    IL_12 = "5001800US1712"
    IL_13 = "5001800US1713"
    IL_14 = "5001800US1714"
    IL_15 = "5001800US1715"
    IL_16 = "5001800US1716"
    IL_17 = "5001800US1717"
    IN_01 = "5001800US1801"
    IN_02 = "5001800US1802"
    IN_03 = "5001800US1803"
    IN_04 = "5001800US1804"
    IN_05 = "5001800US1805"
    IN_06 = "5001800US1806"
    IN_07 = "5001800US1807"
    IN_08 = "5001800US1808"
    IN_09 = "5001800US1809"
    IA_01 = "5001800US1901"
    IA_02 = "5001800US1902"
    IA_03 = "5001800US1903"
    IA_04 = "5001800US1904"
    KS_01 = "5001800US2001"
    KS_02 = "5001800US2002"
    KS_03 = "5001800US2003"
    KS_04 = "5001800US2004"
    KY_01 = "5001800US2101"
    KY_02 = "5001800US2102"
    KY_03 = "5001800US2103"
    KY_04 = "5001800US2104"
    KY_05 = "5001800US2105"
    KY_06 = "5001800US2106"
    LA_01 = "5001800US2201"
    LA_02 = "5001800US2202"
    LA_03 = "5001800US2203"
    LA_04 = "5001800US2204"
    LA_05 = "5001800US2205"
    LA_06 = "5001800US2206"
    ME_01 = "5001800US2301"
    ME_02 = "5001800US2302"
    MD_01 = "5001800US2401"
    MD_02 = "5001800US2402"
    MD_03 = "5001800US2403"
    MD_04 = "5001800US2404"
    MD_05 = "5001800US2405"
    MD_06 = "5001800US2406"
    MD_07 = "5001800US2407"
    MD_08 = "5001800US2408"
    MA_01 = "5001800US2501"
    MA_02 = "5001800US2502"
    MA_03 = "5001800US2503"
    MA_04 = "5001800US2504"
    MA_05 = "5001800US2505"
    MA_06 = "5001800US2506"
    MA_07 = "5001800US2507"
    MA_08 = "5001800US2508"
    MA_09 = "5001800US2509"
    MI_01 = "5001800US2601"
    MI_02 = "5001800US2602"
    MI_03 = "5001800US2603"
    MI_04 = "5001800US2604"
    MI_05 = "5001800US2605"
    MI_06 = "5001800US2606"
    MI_07 = "5001800US2607"
    MI_08 = "5001800US2608"
    MI_09 = "5001800US2609"
    MI_10 = "5001800US2610"
    MI_11 = "5001800US2611"
    MI_12 = "5001800US2612"
    MI_13 = "5001800US2613"
    MN_01 = "5001800US2701"
    MN_02 = "5001800US2702"
    MN_03 = "5001800US2703"
    MN_04 = "5001800US2704"
    MN_05 = "5001800US2705"
    MN_06 = "5001800US2706"
    MN_07 = "5001800US2707"
    MN_08 = "5001800US2708"
    MS_01 = "5001800US2801"
    MS_02 = "5001800US2802"
    MS_03 = "5001800US2803"
    MS_04 = "5001800US2804"
    MO_01 = "5001800US2901"
    MO_02 = "5001800US2902"
    MO_03 = "5001800US2903"
    MO_04 = "5001800US2904"
    MO_05 = "5001800US2905"
    MO_06 = "5001800US2906"
    MO_07 = "5001800US2907"
    MO_08 = "5001800US2908"
    MT_01 = "5001800US3001"
    MT_02 = "5001800US3002"
    NE_01 = "5001800US3101"
    NE_02 = "5001800US3102"
    NE_03 = "5001800US3103"
    NV_01 = "5001800US3201"
    NV_02 = "5001800US3202"
    NV_03 = "5001800US3203"
    NV_04 = "5001800US3204"
    NH_01 = "5001800US3301"
    NH_02 = "5001800US3302"
    NJ_01 = "5001800US3401"
    NJ_02 = "5001800US3402"
    NJ_03 = "5001800US3403"
    NJ_04 = "5001800US3404"
    NJ_05 = "5001800US3405"
    NJ_06 = "5001800US3406"
    NJ_07 = "5001800US3407"
    NJ_08 = "5001800US3408"
    NJ_09 = "5001800US3409"
    NJ_10 = "5001800US3410"
    NJ_11 = "5001800US3411"
    NJ_12 = "5001800US3412"
    NM_01 = "5001800US3501"
    NM_02 = "5001800US3502"
    NM_03 = "5001800US3503"
    NY_01 = "5001800US3601"
    NY_02 = "5001800US3602"
    NY_03 = "5001800US3603"
    NY_04 = "5001800US3604"
    NY_05 = "5001800US3605"
    NY_06 = "5001800US3606"
    NY_07 = "5001800US3607"
    NY_08 = "5001800US3608"
    NY_09 = "5001800US3609"
    NY_10 = "5001800US3610"
    NY_11 = "5001800US3611"
    NY_12 = "5001800US3612"
    NY_13 = "5001800US3613"
    NY_14 = "5001800US3614"
    NY_15 = "5001800US3615"
    NY_16 = "5001800US3616"
    NY_17 = "5001800US3617"
    NY_18 = "5001800US3618"
    NY_19 = "5001800US3619"
    NY_20 = "5001800US3620"
    NY_21 = "5001800US3621"
    NY_22 = "5001800US3622"
    NY_23 = "5001800US3623"
    NY_24 = "5001800US3624"
    NY_25 = "5001800US3625"
    NY_26 = "5001800US3626"
    NC_01 = "5001800US3701"
    NC_02 = "5001800US3702"
    NC_03 = "5001800US3703"
    NC_04 = "5001800US3704"
    NC_05 = "5001800US3705"
    NC_06 = "5001800US3706"
    NC_07 = "5001800US3707"
    NC_08 = "5001800US3708"
    NC_09 = "5001800US3709"
    NC_10 = "5001800US3710"
    NC_11 = "5001800US3711"
    NC_12 = "5001800US3712"
    NC_13 = "5001800US3713"
    NC_14 = "5001800US3714"
    ND_01 = "5001800US3800"
    OH_01 = "5001800US3901"
    OH_02 = "5001800US3902"
    OH_03 = "5001800US3903"
    OH_04 = "5001800US3904"
    OH_05 = "5001800US3905"
    OH_06 = "5001800US3906"
    OH_07 = "5001800US3907"
    OH_08 = "5001800US3908"
    OH_09 = "5001800US3909"
    OH_10 = "5001800US3910"
    OH_11 = "5001800US3911"
    OH_12 = "5001800US3912"
    OH_13 = "5001800US3913"
    OH_14 = "5001800US3914"
    OH_15 = "5001800US3915"
    OK_01 = "5001800US4001"
    OK_02 = "5001800US4002"
    OK_03 = "5001800US4003"
    OK_04 = "5001800US4004"
    OK_05 = "5001800US4005"
    OR_01 = "5001800US4101"
    OR_02 = "5001800US4102"
    OR_03 = "5001800US4103"
    OR_04 = "5001800US4104"
    OR_05 = "5001800US4105"
    OR_06 = "5001800US4106"
    PA_01 = "5001800US4201"
    PA_02 = "5001800US4202"
    PA_03 = "5001800US4203"
    PA_04 = "5001800US4204"
    PA_05 = "5001800US4205"
    PA_06 = "5001800US4206"
    PA_07 = "5001800US4207"
    PA_08 = "5001800US4208"
    PA_09 = "5001800US4209"
    PA_10 = "5001800US4210"
    PA_11 = "5001800US4211"
    PA_12 = "5001800US4212"
    PA_13 = "5001800US4213"
    PA_14 = "5001800US4214"
    PA_15 = "5001800US4215"
    PA_16 = "5001800US4216"
    PA_17 = "5001800US4217"
    RI_01 = "5001800US4401"
    RI_02 = "5001800US4402"
    SC_01 = "5001800US4501"
    SC_02 = "5001800US4502"
    SC_03 = "5001800US4503"
    SC_04 = "5001800US4504"
    SC_05 = "5001800US4505"
    SC_06 = "5001800US4506"
    SC_07 = "5001800US4507"
    SD_01 = "5001800US4600"
    TN_01 = "5001800US4701"
    TN_02 = "5001800US4702"
    TN_03 = "5001800US4703"
    TN_04 = "5001800US4704"
    TN_05 = "5001800US4705"
    TN_06 = "5001800US4706"
    TN_07 = "5001800US4707"
    TN_08 = "5001800US4708"
    TN_09 = "5001800US4709"
    TX_01 = "5001800US4801"
    TX_02 = "5001800US4802"
    TX_03 = "5001800US4803"
    TX_04 = "5001800US4804"
    TX_05 = "5001800US4805"
    TX_06 = "5001800US4806"
    TX_07 = "5001800US4807"
    TX_08 = "5001800US4808"
    TX_09 = "5001800US4809"
    TX_10 = "5001800US4810"
    TX_11 = "5001800US4811"
    TX_12 = "5001800US4812"
    TX_13 = "5001800US4813"
    TX_14 = "5001800US4814"
    TX_15 = "5001800US4815"
    TX_16 = "5001800US4816"
    TX_17 = "5001800US4817"
    TX_18 = "5001800US4818"
    TX_19 = "5001800US4819"
    TX_20 = "5001800US4820"
    TX_21 = "5001800US4821"
    TX_22 = "5001800US4822"
    TX_23 = "5001800US4823"
    TX_24 = "5001800US4824"
    TX_25 = "5001800US4825"
    TX_26 = "5001800US4826"
    TX_27 = "5001800US4827"
    TX_28 = "5001800US4828"
    TX_29 = "5001800US4829"
    TX_30 = "5001800US4830"
    TX_31 = "5001800US4831"
    TX_32 = "5001800US4832"
    TX_33 = "5001800US4833"
    TX_34 = "5001800US4834"
    TX_35 = "5001800US4835"
    TX_36 = "5001800US4836"
    TX_37 = "5001800US4837"
    TX_38 = "5001800US4838"
    UT_01 = "5001800US4901"
    UT_02 = "5001800US4902"
    UT_03 = "5001800US4903"
    UT_04 = "5001800US4904"
    VT_01 = "5001800US5000"
    VA_01 = "5001800US5101"
    VA_02 = "5001800US5102"
    VA_03 = "5001800US5103"
    VA_04 = "5001800US5104"
    VA_05 = "5001800US5105"
    VA_06 = "5001800US5106"
    VA_07 = "5001800US5107"
    VA_08 = "5001800US5108"
    VA_09 = "5001800US5109"
    VA_10 = "5001800US5110"
    VA_11 = "5001800US5111"
    WA_01 = "5001800US5301"
    WA_02 = "5001800US5302"
    WA_03 = "5001800US5303"
    WA_04 = "5001800US5304"
    WA_05 = "5001800US5305"
    WA_06 = "5001800US5306"
    WA_07 = "5001800US5307"
    WA_08 = "5001800US5308"
    WA_09 = "5001800US5309"
    WA_10 = "5001800US5310"
    WV_01 = "5001800US5401"
    WV_02 = "5001800US5402"
    WI_01 = "5001800US5501"
    WI_02 = "5001800US5502"
    WI_03 = "5001800US5503"
    WI_04 = "5001800US5504"
    WI_05 = "5001800US5505"
    WI_06 = "5001800US5506"
    WI_07 = "5001800US5507"
    WI_08 = "5001800US5508"
    WY_01 = "5001800US5600"

    def get_hierarchical_codes(self) -> List[str]:
        """
        Returns all applicable UCGID codes for this enum value in hierarchical order.

        Returns:
            List of UCGID codes from most specific to least specific

        Examples:
            UCGID.CA_23.get_hierarchical_codes() -> ["5001800US0623", "0400000US06", "0100000US"]
            UCGID.CA.get_hierarchical_codes() -> ["0400000US06", "0100000US"]
            UCGID.US.get_hierarchical_codes() -> ["0100000US"]
        """
        code = self.value
        codes_list = [code]

        # If it's a district code (Congressional District format: 5001800US + state + district)
        if code.startswith("5001800US"):
            # Extract state code from district code
            state_code_num = code[9:11]  # Extract 2-digit state code
            state_code = f"0400000US{state_code_num}"

            # Add state code if it exists in the enum
            for state_enum in UCGID:
                if state_enum.value == state_code:
                    codes_list.append(state_code)
                    break

            # Add US code
            codes_list.append("0100000US")

        # If it's a state code (State format: 0400000US + state code)
        elif code.startswith("0400000US"):
            # Add US code
            codes_list.append("0100000US")

        # If it's already the US code, return as-is
        # (US code: "0100000US")

        return codes_list

    def matches_hierarchy(self, target_code: str) -> bool:
        """
        Check if this UCGID code matches a target code in the hierarchy.

        Args:
            target_code: The target code to match against

        Returns:
            True if this code belongs to the target code's hierarchy

        Examples:
            UCGID.CA_23.matches_hierarchy("0400000US06") -> True (CA_23 is in CA)
            UCGID.CA_23.matches_hierarchy("0100000US") -> True (CA_23 is in US)
            UCGID.CA.matches_hierarchy("5001800US0623") -> False (CA is not CA_23)
        """
        hierarchical_codes = self.get_hierarchical_codes()
        return target_code in hierarchical_codes
