from pynput.keyboard import Key, Controller
import time
import pyautogui

typewait = 0.1

kb = Controller()

from pynput.keyboard import Key

def safe(keyname):
    """Return Key.<name> if it exists, else None."""
    return getattr(Key, keyname, None)

SPECIAL_KEYS = {
    # Modifier keys
    "alt": safe("alt"),
    "lalt": safe("alt_l"),
    "ralt": safe("alt_r"),
    "ctrl": safe("ctrl"),
    "lctrl": safe("ctrl_l"),
    "rctrl": safe("ctrl_r"),
    "shift": safe("shift"),
    "lshift": safe("shift_l"),
    "rshift": safe("shift_r"),
    "cmd": safe("cmd"),
    "win": safe("cmd"),
    "meta": safe("cmd"),
    "super": safe("cmd"),

    # Navigation keys
    "tab": safe("tab"),
    "enter": safe("enter"),
    "esc": safe("esc"),
    "escape": safe("esc"),
    "backspace": safe("backspace"),
    "delete": safe("delete"),
    "del": safe("delete"),
    "insert": safe("insert"),        # ← NOW SAFE
    "home": safe("home"),
    "end": safe("end"),
    "pageup": safe("page_up"),
    "pagedown": safe("page_down"),
    "up": safe("up"),
    "down": safe("down"),
    "left": safe("left"),
    "right": safe("right"),

    # Space
    " ": safe("space"),
    "space": safe("space"),

    # Function keys
    **{f"f{i}": safe(f"f{i}") for i in range(1, 25)},

    # Misc
    "capslock": safe("caps_lock"),
    "numlock": safe("num_lock"),
    "scrolllock": safe("scroll_lock"),
    "pause": safe("pause"),
    "printscreen": safe("print_screen"),
}


def get_key_obj(k):
    k_lower = str(k).lower()
    if k_lower in SPECIAL_KEYS:
        return SPECIAL_KEYS[k_lower]
    return k

def run_macro(cmd_list):
    import pressing
    for cmd in cmd_list:
        time.sleep(pressing.typewait)
        
        if cmd.endswith("+"):
            keyname = cmd[:-1]
            kb.press(get_key_obj(keyname))
            continue

        if cmd.endswith("-"):
            keyname = cmd[:-1]
            kb.release(get_key_obj(keyname))
            continue

        if len(cmd) == 1 or cmd.lower() in SPECIAL_KEYS:
            key = get_key_obj(cmd)
            kb.press(key)
            kb.release(key)
            continue

        for ch in cmd:
            key = get_key_obj(ch)
            kb.press(key)
            kb.release(key)

def creator():
    print("Pressing was created by Mongoose")

def press(character):
    """Hold a key or list of keys."""
    if isinstance(character, list):
        commands = [f"{c}+" for c in character]
    else:
        commands = [f"{character}+"]
    run_macro(commands)

def release(character):
    """Release a key or list of keys."""
    if isinstance(character, list):
        commands = [f"{c}-" for c in character]
    else:
        commands = [f"{character}-"]
    run_macro(commands)

def click(character):
    """Tap a key or list of keys (press + release)."""
    if isinstance(character, list):
        commands = [f"{c}" for c in character]
    else:
        commands = [f"{character}"]
    run_macro(commands)

def getpixel(x, y):
    """Utility function for pixel reading."""
    return pyautogui.screenshot().getpixel((x, y))

