"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoDiscover = exports.LambdaExtensionAutoDiscover = exports.EdgeLambdaAutoDiscover = exports.LambdaAutoDiscover = exports.IntegrationTestAutoDiscover = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const integration_test_1 = require("./integration-test");
const internal_1 = require("./internal");
const lambda_extension_1 = require("./lambda-extension");
const lambda_function_1 = require("./lambda-function");
const cdk_1 = require("../cdk");
const component_1 = require("../component");
/**
 * Creates integration tests from entry points discovered in the test tree.
 */
class IntegrationTestAutoDiscover extends cdk_1.IntegrationTestAutoDiscoverBase {
    constructor(project, options) {
        super(project, options);
        for (const entrypoint of this.entrypoints) {
            new integration_test_1.IntegrationTest(this.project, {
                entrypoint,
                cdkDeps: options.cdkDeps,
                tsconfigPath: options.tsconfigPath,
                ...options.integrationTestOptions,
            });
        }
    }
}
exports.IntegrationTestAutoDiscover = IntegrationTestAutoDiscover;
_a = JSII_RTTI_SYMBOL_1;
IntegrationTestAutoDiscover[_a] = { fqn: "projen.awscdk.IntegrationTestAutoDiscover", version: "0.98.16" };
/**
 * Creates lambdas from entry points discovered in the project's source tree.
 */
class LambdaAutoDiscover extends cdk_1.AutoDiscoverBase {
    constructor(project, options) {
        super(project, {
            projectdir: options.srcdir,
            extension: internal_1.TYPESCRIPT_LAMBDA_EXT,
        });
        for (const entrypoint of this.entrypoints) {
            new lambda_function_1.LambdaFunction(this.project, {
                entrypoint,
                cdkDeps: options.cdkDeps,
                ...options.lambdaOptions,
            });
        }
    }
}
exports.LambdaAutoDiscover = LambdaAutoDiscover;
_b = JSII_RTTI_SYMBOL_1;
LambdaAutoDiscover[_b] = { fqn: "projen.awscdk.LambdaAutoDiscover", version: "0.98.16" };
/**
 * Creates edge lambdas from entry points discovered in the project's source tree.
 */
class EdgeLambdaAutoDiscover extends cdk_1.AutoDiscoverBase {
    constructor(project, options) {
        super(project, {
            projectdir: options.srcdir,
            extension: internal_1.TYPESCRIPT_EDGE_LAMBDA_EXT,
        });
        for (const entrypoint of this.entrypoints) {
            new lambda_function_1.LambdaFunction(this.project, {
                entrypoint,
                cdkDeps: options.cdkDeps,
                ...options.lambdaOptions,
                edgeLambda: true,
            });
        }
    }
}
exports.EdgeLambdaAutoDiscover = EdgeLambdaAutoDiscover;
_c = JSII_RTTI_SYMBOL_1;
EdgeLambdaAutoDiscover[_c] = { fqn: "projen.awscdk.EdgeLambdaAutoDiscover", version: "0.98.16" };
/**
 * Creates Lambda Extensions from entrypoints discovered in the project's
 * source tree.
 */
class LambdaExtensionAutoDiscover extends cdk_1.AutoDiscoverBase {
    constructor(project, options) {
        super(project, {
            projectdir: options.srcdir,
            extension: internal_1.TYPESCRIPT_LAMBDA_EXTENSION_EXT,
        });
        for (const entrypoint of this.entrypoints) {
            new lambda_extension_1.LambdaExtension(this.project, {
                entrypoint,
                cdkDeps: options.cdkDeps,
                ...options.lambdaExtensionOptions,
            });
        }
    }
}
exports.LambdaExtensionAutoDiscover = LambdaExtensionAutoDiscover;
_d = JSII_RTTI_SYMBOL_1;
LambdaExtensionAutoDiscover[_d] = { fqn: "projen.awscdk.LambdaExtensionAutoDiscover", version: "0.98.16" };
/**
 * Discovers and creates integration tests and lambdas from code in the
 * project's source and test trees.
 */
class AutoDiscover extends component_1.Component {
    constructor(project, options) {
        super(project);
        if (options.lambdaAutoDiscover ?? true) {
            new LambdaAutoDiscover(this.project, {
                cdkDeps: options.cdkDeps,
                tsconfigPath: options.tsconfigPath,
                srcdir: options.srcdir,
                lambdaOptions: options.lambdaOptions,
            });
        }
        if (options.edgeLambdaAutoDiscover ?? true) {
            new EdgeLambdaAutoDiscover(this.project, {
                cdkDeps: options.cdkDeps,
                tsconfigPath: options.tsconfigPath,
                srcdir: options.srcdir,
                lambdaOptions: options.lambdaOptions,
            });
        }
        if (options.lambdaExtensionAutoDiscover ?? true) {
            new LambdaExtensionAutoDiscover(this.project, {
                cdkDeps: options.cdkDeps,
                tsconfigPath: options.tsconfigPath,
                srcdir: options.srcdir,
                lambdaExtensionOptions: options.lambdaExtensionOptions,
            });
        }
        if (options.integrationTestAutoDiscover ?? true) {
            new IntegrationTestAutoDiscover(this.project, {
                cdkDeps: options.cdkDeps,
                testdir: options.testdir,
                tsconfigPath: options.tsconfigPath,
                integrationTestOptions: options.integrationTestOptions,
            });
        }
    }
}
exports.AutoDiscover = AutoDiscover;
_e = JSII_RTTI_SYMBOL_1;
AutoDiscover[_e] = { fqn: "projen.awscdk.AutoDiscover", version: "0.98.16" };
//# sourceMappingURL=data:application/json;base64,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